/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.controller.medical;

import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.wisdommedical.exception.OutpatientPaymentException;
import com.ebaiyihui.wisdommedical.pojo.vo.repsvo.GetAdmissionRespVO;
import com.ebaiyihui.wisdommedical.pojo.vo.repsvo.GetPayInfoRespVO;
import com.ebaiyihui.wisdommedical.pojo.vo.repsvo.GetPayItemRespVO;
import com.ebaiyihui.wisdommedical.pojo.vo.repsvo.OutpatientPaymentOrderDetailRespVO;
import com.ebaiyihui.wisdommedical.pojo.vo.repsvo.OutpatientPaymentOrderRespVO;
import com.ebaiyihui.wisdommedical.pojo.vo.repsvo.PaySuccessInfoRespVO;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.CreateOutpatientPaymentReqVO;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.GetAdmissionReqVO;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.GetPayItemReqVO;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.OutpatientPaymentOrderDetailReqVO;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.OutpatientPaymentOrderReqVO;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.OutpatientPaymentReqVO;
import com.ebaiyihui.wisdommedical.pojo.yb.TencentCreadOrderResponse;
import com.ebaiyihui.wisdommedical.service.OutpatientPaymentService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Comparator;
import java.util.List;
import javax.validation.Valid;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u95e8\u8bca\u7f34\u8d39api"})
@RequestMapping(value={"/api/v1/outpatient"})
public class OutpatientPaymentController {
    private static final Logger log = LoggerFactory.getLogger(OutpatientPaymentController.class);
    @Autowired
    private OutpatientPaymentService outpatientPaymentService;

    @ApiOperation(value="\u95e8\u8bca\u533b\u4fdd\u9884\u7ed3\u7b97\u4e0b\u5355", notes="\u95e8\u8bca\u533b\u4fdd\u9884\u7ed3\u7b97\u4e0b\u5355")
    @PostMapping(value={"insurinfoCreateOrderPay"})
    public BaseResponse<TencentCreadOrderResponse> insurinfoCreateOrderPay(@Valid @RequestBody OutpatientPaymentReqVO insurinfoCreateOrderReq, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        log.info("OutpatientPaymentController.getAdmission->\u5c31\u8bca\u8bb0\u5f55\u67e5\u8be2\u8bf7\u6c42\u53c2\u6570getAdmissionReqVO\u4e3a:{}", (Object)insurinfoCreateOrderReq.toString());
        BaseResponse tencentCreadOrderResponse = new BaseResponse();
        try {
            tencentCreadOrderResponse = this.outpatientPaymentService.insurinfoCreateOrderPay(insurinfoCreateOrderReq);
        }
        catch (Exception e) {
            e.printStackTrace();
            return BaseResponse.error((String)"\u6682\u65e0\u5c31\u8bca\u8bb0\u5f55");
        }
        return tencentCreadOrderResponse;
    }

    @ApiOperation(value="\u5c31\u8bca\u8bb0\u5f55\u67e5\u8be2", notes="\u5c31\u8bca\u8bb0\u5f55\u67e5\u8be2")
    @PostMapping(value={"getAdmission"})
    public BaseResponse<List<GetAdmissionRespVO>> getAdmission(@Valid @RequestBody GetAdmissionReqVO getAdmissionReqVO, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        log.info("OutpatientPaymentController.getAdmission->\u5c31\u8bca\u8bb0\u5f55\u67e5\u8be2\u8bf7\u6c42\u53c2\u6570getAdmissionReqVO\u4e3a:{}", (Object)getAdmissionReqVO.toString());
        List getAdmissionRespVO = null;
        try {
            getAdmissionRespVO = this.outpatientPaymentService.getAdmission(getAdmissionReqVO);
            getAdmissionRespVO.sort(Comparator.comparing(GetAdmissionRespVO::getAdmDate).reversed());
        }
        catch (Exception e) {
            return BaseResponse.error((String)"\u6682\u65e0\u5c31\u8bca\u8bb0\u5f55");
        }
        return BaseResponse.success((Object)getAdmissionRespVO);
    }

    @ApiOperation(value="\u83b7\u53d6\u95e8\u8bca\u6536\u8d39\u9879\u76ee", notes="\u83b7\u53d6\u95e8\u8bca\u6536\u8d39\u9879\u76ee")
    @PostMapping(value={"getPayItem"})
    public BaseResponse<GetPayItemRespVO> getPayItem(@Valid @RequestBody GetPayItemReqVO getPayItemReqVO, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        log.info("OutpatientPaymentController.getPayItem->\u83b7\u53d6\u95e8\u8bca\u6536\u8d39\u9879\u76ee\u8bf7\u6c42\u53c2\u6570getPayItemReqVO\u4e3a:{}", (Object)getPayItemReqVO.toString());
        GetPayItemRespVO getPayItemRespVO = null;
        try {
            getPayItemRespVO = this.outpatientPaymentService.getPayItem(getPayItemReqVO);
        }
        catch (OutpatientPaymentException e) {
            return BaseResponse.error((String)"\u83b7\u53d6\u95e8\u8bca\u6536\u8d39\u9879\u76ee\u5931\u8d25\uff01");
        }
        return BaseResponse.success((Object)getPayItemRespVO);
    }

    @ApiOperation(value="\u751f\u6210\u95e8\u8bca\u7f34\u8d39\u8ba2\u5355", notes="\u751f\u6210\u95e8\u8bca\u7f34\u8d39\u8ba2\u5355")
    @PostMapping(value={"createOutpatientPayment"})
    public BaseResponse<String> createOutpatientPayment(@Valid @RequestBody CreateOutpatientPaymentReqVO createOutpatientPaymentReqVO, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        log.info("OutpatientPaymentController.createOutpatientPayment->\u751f\u6210\u95e8\u8bca\u7f34\u8d39\u8ba2\u5355\u8bf7\u6c42\u53c2\u6570createOutpatientPaymentReqVO\u4e3a:{}", (Object)createOutpatientPaymentReqVO.toString());
        String outPatientId = this.outpatientPaymentService.createOutpatientPayment(createOutpatientPaymentReqVO);
        return BaseResponse.success((Object)outPatientId);
    }

    @ApiOperation(value="\u83b7\u53d6\u5f85\u652f\u4ed8\u8ba2\u5355\u4fe1\u606f", notes="\u83b7\u53d6\u5f85\u652f\u4ed8\u8ba2\u5355\u4fe1\u606f")
    @GetMapping(value={"getPayInfo"})
    public BaseResponse<GetPayInfoRespVO> getPayInfo(String outPatientId) {
        if (StringUtils.isEmpty((String)outPatientId)) {
            BaseResponse.error((String)"outPatientId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        log.info("OutpatientPaymentController.getPayInfo->\u83b7\u53d6\u5f85\u652f\u4ed8\u8ba2\u5355\u4fe1\u606f\u8bf7\u6c42\u53c2\u6570outPatientId\u4e3a:{}", (Object)outPatientId);
        GetPayInfoRespVO getPayInfoRespVO = null;
        try {
            getPayInfoRespVO = this.outpatientPaymentService.getPayInfo(outPatientId);
        }
        catch (OutpatientPaymentException e) {
            return BaseResponse.error((String)e.getMessage());
        }
        return BaseResponse.success((Object)getPayInfoRespVO);
    }

    @ApiOperation(value="\u95e8\u8bca\u7f34\u8d39\u5386\u53f2\u8ba2\u5355", notes="\u95e8\u8bca\u7f34\u8d39\u5386\u53f2\u8ba2\u5355")
    @PostMapping(value={"getOutpatientPaymentOrder"})
    public BaseResponse<List<OutpatientPaymentOrderRespVO>> getOutpatientPaymentOrder(@Valid @RequestBody OutpatientPaymentOrderReqVO outpatientPaymentOrderReqVO, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        log.info("OutpatientPaymentController.getOutpatientPaymentOrder->\u95e8\u8bca\u7f34\u8d39\u5386\u53f2\u8ba2\u5355\u8bf7\u6c42\u53c2\u6570outpatientPaymentOrderReqVO\u4e3a:{}", (Object)outpatientPaymentOrderReqVO.toString());
        List outpatientPaymentOrder = null;
        try {
            outpatientPaymentOrder = this.outpatientPaymentService.getOutpatientPaymentOrder(outpatientPaymentOrderReqVO);
        }
        catch (OutpatientPaymentException e) {
            return BaseResponse.error((String)e.getMessage());
        }
        return BaseResponse.success((Object)outpatientPaymentOrder);
    }

    @ApiOperation(value="\u95e8\u8bca\u7f34\u8d39\u8ba2\u5355\u8be6\u60c5", notes="\u95e8\u8bca\u7f34\u8d39\u8ba2\u5355\u8be6\u60c5")
    @PostMapping(value={"getOutpatientPaymentOrderDetail"})
    public BaseResponse<OutpatientPaymentOrderDetailRespVO> getOutpatientPaymentOrderDetail(@Valid @RequestBody OutpatientPaymentOrderDetailReqVO outpatientPaymentOrderDetailReqVO, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        log.info("OutpatientPaymentController.getOutpatientPaymentOrderDetail->\u95e8\u8bca\u7f34\u8d39\u8ba2\u5355\u8be6\u60c5\u8bf7\u6c42\u53c2\u6570outpatientPaymentOrderDetailReqVO\u4e3a:{}", (Object)outpatientPaymentOrderDetailReqVO.toString());
        OutpatientPaymentOrderDetailRespVO outpatientPaymentOrderDetailRespVO = null;
        try {
            outpatientPaymentOrderDetailRespVO = this.outpatientPaymentService.getOutpatientSucssessDetail(outpatientPaymentOrderDetailReqVO);
        }
        catch (OutpatientPaymentException e) {
            BaseResponse.error((String)"\u95e8\u8bca\u7f34\u8d39\u8ba2\u5355\u8be6\u60c5\u67e5\u8be2\u5931\u8d25\uff01");
        }
        return BaseResponse.success((Object)outpatientPaymentOrderDetailRespVO);
    }

    @ApiOperation(value="\u95e8\u8bca\u7f34\u8d39\u652f\u4ed8", notes="\u95e8\u8bca\u7f34\u8d39\u652f\u4ed8")
    @PostMapping(value={"outpatientPayment"})
    public BaseResponse<String> outpatientPayment(@Valid @RequestBody OutpatientPaymentReqVO outpatientPaymentReqVO, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        log.info("OutpatientPaymentController.outpatientPayment->\u95e8\u8bca\u7f34\u8d39\u652f\u4ed8\u8bf7\u6c42\u53c2\u6570outpatientPaymentReqVO\u4e3a:{}", (Object)outpatientPaymentReqVO.toString());
        BaseResponse baseResponse = null;
        try {
            baseResponse = this.outpatientPaymentService.outpatientPayment(outpatientPaymentReqVO);
        }
        catch (OutpatientPaymentException e) {
            BaseResponse.error((String)e.getMessage());
        }
        return baseResponse;
    }

    @ApiOperation(value="\u83b7\u53d6\u95e8\u8bca\u7f34\u8d39\u6210\u529f\u8ba2\u5355\u4fe1\u606f", notes="\u83b7\u53d6\u95e8\u8bca\u7f34\u8d39\u6210\u529f\u8ba2\u5355\u4fe1\u606f")
    @GetMapping(value={"getPaySuccessInfo"})
    public BaseResponse<PaySuccessInfoRespVO> getPaySuccessInfo(String outPatientId) {
        if (StringUtils.isEmpty((String)outPatientId)) {
            BaseResponse.error((String)"outPatientId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        log.info("OutpatientPaymentController.getPaySuccessInfo->\u83b7\u53d6\u95e8\u8bca\u7f34\u8d39\u6210\u529f\u8ba2\u5355\u4fe1\u606f\u8bf7\u6c42\u53c2\u6570outPatientId\u4e3a:{}", (Object)outPatientId);
        PaySuccessInfoRespVO paySuccessInfo = null;
        try {
            paySuccessInfo = this.outpatientPaymentService.getPaySuccessInfo(outPatientId);
        }
        catch (OutpatientPaymentException e) {
            BaseResponse.error((String)"\u83b7\u53d6\u95e8\u8bca\u7f34\u8d39\u6210\u529f\u8ba2\u5355\u4fe1\u606f\u5931\u8d25");
        }
        return BaseResponse.success((Object)paySuccessInfo);
    }
}

