/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.service.impl;

import cn.hutool.core.util.IdcardUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.ebaiyihui.card.common.vo.CardDetailsInfoReqVO;
import com.ebaiyihui.card.common.vo.CardDetailsInfoRespVO;
import com.ebaiyihui.common.pojo.vo.card.UcCardListReqVO;
import com.ebaiyihui.common.pojo.vo.card.UserCardListRespVO;
import com.ebaiyihui.common.pojo.vo.card.UserPatientListRespVO;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.utils.IdCardUtil;
import com.ebaiyihui.his.api.AppointApi;
import com.ebaiyihui.his.api.MedicalCardApi;
import com.ebaiyihui.his.api.OutpatientPaymentApi;
import com.ebaiyihui.his.api.ScheduleApi;
import com.ebaiyihui.his.pojo.vo.appoint.AllPayReq;
import com.ebaiyihui.his.pojo.vo.appoint.AppointOrderStatusRes;
import com.ebaiyihui.his.pojo.vo.appoint.CancelRegisterReq;
import com.ebaiyihui.his.pojo.vo.appoint.CancelRegisterRes;
import com.ebaiyihui.his.pojo.vo.appoint.ConfirmRegisterReq;
import com.ebaiyihui.his.pojo.vo.appoint.ConfirmRegisterRes;
import com.ebaiyihui.his.pojo.vo.appoint.DayConfirmRegisterRes;
import com.ebaiyihui.his.pojo.vo.appoint.LockOrderReq;
import com.ebaiyihui.his.pojo.vo.appoint.PayRegistrationMsg;
import com.ebaiyihui.his.pojo.vo.appoint.PayRegistrationReq;
import com.ebaiyihui.his.pojo.vo.appoint.PayRegistrationRes;
import com.ebaiyihui.his.pojo.vo.appoint.PayReq;
import com.ebaiyihui.his.pojo.vo.appoint.ReturnRegisterReq;
import com.ebaiyihui.his.pojo.vo.appoint.ReturnRegisterRes;
import com.ebaiyihui.his.pojo.vo.base.FrontRequest;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.his.pojo.vo.base.GatewayRequest;
import com.ebaiyihui.his.pojo.vo.base.GatewayResponse;
import com.ebaiyihui.his.pojo.vo.card.QueryCardInfoReqVO;
import com.ebaiyihui.his.pojo.vo.card.QueryCardInfoResVO;
import com.ebaiyihui.his.pojo.vo.outpatient.GetRecipelReq;
import com.ebaiyihui.his.pojo.vo.outpatient.GetRecipelRes;
import com.ebaiyihui.his.pojo.vo.outpatient.items.GetPayRecordsResItems;
import com.ebaiyihui.his.pojo.vo.schedule.GetScheduleReqVO;
import com.ebaiyihui.his.pojo.vo.schedule.GetScheduleResVO;
import com.ebaiyihui.his.pojo.vo.schedule.items.GetScheduleResItems;
import com.ebaiyihui.his.pojo.vo.schedule.items.TimeArrangeItems;
import com.ebaiyihui.wisdommedical.common.constant.ProPropertiesConstant;
import com.ebaiyihui.wisdommedical.common.enums.AdmTimeRangeEnum;
import com.ebaiyihui.wisdommedical.common.enums.AppointOrderPayStatusCodeEnum;
import com.ebaiyihui.wisdommedical.common.enums.AppointmentStatusEnum;
import com.ebaiyihui.wisdommedical.common.enums.AppointmentTypeEnums;
import com.ebaiyihui.wisdommedical.common.enums.BusinessTypeEnums;
import com.ebaiyihui.wisdommedical.common.enums.CancelTypeEnum;
import com.ebaiyihui.wisdommedical.common.enums.ChannelEnum;
import com.ebaiyihui.wisdommedical.common.enums.HisPayBusinessTypeEnum;
import com.ebaiyihui.wisdommedical.common.enums.PayChannelEnum;
import com.ebaiyihui.wisdommedical.common.enums.RefundChannelCodeEnum;
import com.ebaiyihui.wisdommedical.common.enums.RefundStatusEnum;
import com.ebaiyihui.wisdommedical.exception.AppointmentException;
import com.ebaiyihui.wisdommedical.exception.ScheduleException;
import com.ebaiyihui.wisdommedical.mapper.AppointmentPayorderMapper;
import com.ebaiyihui.wisdommedical.mapper.AppointmentRecordMapper;
import com.ebaiyihui.wisdommedical.mapper.BusinessResultMapper;
import com.ebaiyihui.wisdommedical.mapper.DeptRecordMapper;
import com.ebaiyihui.wisdommedical.mapper.HospitalConfigMapper;
import com.ebaiyihui.wisdommedical.mapper.OpBusinessOrderEntityMapper;
import com.ebaiyihui.wisdommedical.mapper.ScheduleDetailRecordMapper;
import com.ebaiyihui.wisdommedical.mapper.ScheduleRecordMapper;
import com.ebaiyihui.wisdommedical.model.AppointmentPayorderEntity;
import com.ebaiyihui.wisdommedical.model.AppointmentRecordEntity;
import com.ebaiyihui.wisdommedical.model.BusinessResultEntity;
import com.ebaiyihui.wisdommedical.model.HospitalConfigEntity;
import com.ebaiyihui.wisdommedical.model.OpBusinessOrderEntity;
import com.ebaiyihui.wisdommedical.pojo.bdqueryvo.AppraiseDTO;
import com.ebaiyihui.wisdommedical.pojo.bdqueryvo.DetailPageDTO;
import com.ebaiyihui.wisdommedical.pojo.bdqueryvo.OrderDetailDTO;
import com.ebaiyihui.wisdommedical.pojo.bdqueryvo.PaymentDTO;
import com.ebaiyihui.wisdommedical.pojo.bdvo.EXTDTO;
import com.ebaiyihui.wisdommedical.pojo.bdvo.MainOrderDTO;
import com.ebaiyihui.wisdommedical.pojo.bdvo.MessageSendReqVo;
import com.ebaiyihui.wisdommedical.pojo.bdvo.OrderCenterPushDataDTO;
import com.ebaiyihui.wisdommedical.pojo.bdvo.OrderCenterPushReqVo;
import com.ebaiyihui.wisdommedical.pojo.bdvo.OrderInfoList;
import com.ebaiyihui.wisdommedical.pojo.bdvo.ProductsDTO;
import com.ebaiyihui.wisdommedical.pojo.bdvo.PushOrderInfoReqVo;
import com.ebaiyihui.wisdommedical.pojo.bdvo.StatisticsInfo;
import com.ebaiyihui.wisdommedical.pojo.bdvo.UpdateOrderInfoReqVo;
import com.ebaiyihui.wisdommedical.pojo.bdvo.ValueData;
import com.ebaiyihui.wisdommedical.pojo.dto.DoDayAppointmentDTO;
import com.ebaiyihui.wisdommedical.pojo.dto.OneJoinResDTO;
import com.ebaiyihui.wisdommedical.pojo.dto.RegisterationQueryParamsDTO;
import com.ebaiyihui.wisdommedical.pojo.dto.UpdateScheduleDetailDTO;
import com.ebaiyihui.wisdommedical.pojo.medicalInsurance.req.FetchMedicalInsuranceMemberBasicInfoReq;
import com.ebaiyihui.wisdommedical.pojo.medicalInsurance.req.MedicalInsurInfoReqVo;
import com.ebaiyihui.wisdommedical.pojo.medicalInsurance.req.OutpatientPreRegistratReqVo;
import com.ebaiyihui.wisdommedical.pojo.medicalInsurance.req.OutpatientRegistratConfirmatReqVo;
import com.ebaiyihui.wisdommedical.pojo.medicalInsurance.req.RegConfirmatReqVo;
import com.ebaiyihui.wisdommedical.pojo.medicalInsurance.res.CancalConfirmatRes;
import com.ebaiyihui.wisdommedical.pojo.medicalInsurance.res.ConsultationHealtInuranceRes;
import com.ebaiyihui.wisdommedical.pojo.medicalInsurance.res.InsuranceMemberBasicInfoResOutput;
import com.ebaiyihui.wisdommedical.pojo.medicalInsurance.res.MedicalInsurInfoResVo;
import com.ebaiyihui.wisdommedical.pojo.medicalInsurance.res.RegConfirmatResVo;
import com.ebaiyihui.wisdommedical.pojo.vo.AppointmentCreateOrderVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.AppointmentPayVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.AppointmentRecordDetailVo;
import com.ebaiyihui.wisdommedical.pojo.vo.AppointmentRecordVo;
import com.ebaiyihui.wisdommedical.pojo.vo.CancelAppointmentVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.ConfirmAppointmentVo;
import com.ebaiyihui.wisdommedical.pojo.vo.DayAppointmentCreateOrderVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.DayAppointmentPayVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.GetConfirmPayInfoVoRes;
import com.ebaiyihui.wisdommedical.pojo.vo.GetScheduleVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.GetScheduleVoRes;
import com.ebaiyihui.wisdommedical.pojo.vo.RabbitMqDelayedOrderVo;
import com.ebaiyihui.wisdommedical.pojo.vo.RequestRefundOrderVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.ResponseNotifyRestVo;
import com.ebaiyihui.wisdommedical.pojo.vo.ScheduleBaseInfoVo;
import com.ebaiyihui.wisdommedical.pojo.vo.UpdateDelayAppointmentRecordVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.UpdatePayAppointmentRecordVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.WithdrawNumberVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.YBRefundVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.repsvo.GetFzApppintResVO;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.GetFzApppintReqVO;
import com.ebaiyihui.wisdommedical.pojo.yb.InsuranceInfo;
import com.ebaiyihui.wisdommedical.pojo.yb.RefundRequestContent;
import com.ebaiyihui.wisdommedical.pojo.yb.RequestContent;
import com.ebaiyihui.wisdommedical.pojo.yb.ResultResponse;
import com.ebaiyihui.wisdommedical.pojo.yb.TencentCreadOrderRequest;
import com.ebaiyihui.wisdommedical.pojo.yb.TencentCreadOrderResponse;
import com.ebaiyihui.wisdommedical.pojo.yb.TencentRefundRequest;
import com.ebaiyihui.wisdommedical.pojo.yb.TencentRefundResponse;
import com.ebaiyihui.wisdommedical.service.AppointmentService;
import com.ebaiyihui.wisdommedical.service.PushService;
import com.ebaiyihui.wisdommedical.service.ScheduleService;
import com.ebaiyihui.wisdommedical.service.SpecializDiseaseService;
import com.ebaiyihui.wisdommedical.service.impl.AppointmentServiceImpl;
import com.ebaiyihui.wisdommedical.util.DateUtils;
import com.ebaiyihui.wisdommedical.util.GetCardInfoUtil;
import com.ebaiyihui.wisdommedical.util.HttpKit;
import com.ebaiyihui.wisdommedical.util.IDCardUtils;
import com.ebaiyihui.wisdommedical.util.NumberUtils;
import com.ebaiyihui.wisdommedical.util.PayUtil;
import com.ebaiyihui.wisdommedical.util.RabbitMqUtils;
import com.ebaiyihui.wisdommedical.util.SnowflakeIdWorker;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import redis.clients.jedis.JedisCluster;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class AppointmentServiceImpl
implements AppointmentService {
    private static final Logger log = LoggerFactory.getLogger(AppointmentServiceImpl.class);
    private static final String REGEX_OF_NAME = "(?<=.{1}).";
    private static final String REPLACE_OF_NAME = "*";
    public static final int TWO_HOURS = 7200;
    public static final int CURRENT_DAY_APPOINTMENT = 2;
    public static final int NOT_CURRENT_DAY_APPOINTMENT = 1;
    public static final String YES_TOPAY = "1";
    public static final String NOT_TOPAY = "0";
    public static final String SUCCESS = "Y";
    public static final int HAVE_TIME_ARRANGE_FLAG = 1;
    public static final String DEFAULT_SUCCESS_CODE = "1";
    @Autowired
    private SnowflakeIdWorker snowflakeIdWorker;
    @Autowired
    private DeptRecordMapper deptRecordMapper;
    @Autowired
    private JedisCluster jedisCluster;
    @Autowired
    private ProPropertiesConstant constant;
    @Autowired
    private ScheduleApi scheduleApi;
    @Autowired
    private OpBusinessOrderEntityMapper opBusinessOrderEntityMapper;
    @Autowired
    private AppointApi appointApi;
    @Autowired
    private MedicalCardApi cardApi;
    @Autowired
    private AppointmentRecordMapper appointmentRecordMapper;
    @Autowired
    private ScheduleRecordMapper scheduleRecordMapper;
    @Autowired
    private ScheduleDetailRecordMapper scheduleDetailRecordMapper;
    @Autowired
    private HospitalConfigMapper hospitalConfigMapper;
    @Autowired
    private RabbitTemplate rabbitTemplate;
    @Autowired
    private BusinessResultMapper businessResultMapper;
    @Autowired
    private AppointmentPayorderMapper appointmentPayOrderMapper;
    @Autowired
    private TaskExecutor taskExecutor;
    @Autowired
    private ProPropertiesConstant propertiesConstant;
    @Autowired
    private PushService pushService;
    @Autowired
    private SpecializDiseaseService specializDiseaseService;
    public static final List<Integer> appointmentStatusList = Arrays.asList(4, 15, 16, 17, 18);
    @Autowired
    private GetCardInfoUtil getCardInfoUtil;
    @Autowired
    private ScheduleService scheduleService;
    @Autowired
    private PayUtil payUtil;
    @Autowired
    private OutpatientPaymentApi outpatientPaymentApi;

    public String confirmAppointment(ConfirmAppointmentVo confirmAppointmentVo) throws ScheduleException {
        List timeArrangeItems;
        String admDate = confirmAppointmentVo.getAdmDate();
        List getScheduleResItemsList = this.getHisDaySchedule(confirmAppointmentVo);
        if (CollectionUtils.isEmpty((Collection)getScheduleResItemsList)) {
            throw new ScheduleException("\u5b9e\u65f6\u67e5\u8be2\u533b\u751f\u6392\u73ed\u6570\u636e\u5f02\u5e38,\u8bf7\u91cd\u8bd5");
        }
        GetScheduleResItems getScheduleResItems = (GetScheduleResItems)getScheduleResItemsList.get(0);
        confirmAppointmentVo = this.buildConfirmAppointmentVo(getScheduleResItems, confirmAppointmentVo);
        if (String.valueOf(LocalDate.now()).equals(admDate) && confirmAppointmentVo.getIsTimeArrange().equals(1) && !CollectionUtils.isEmpty((Collection)(timeArrangeItems = confirmAppointmentVo.getTimeArrangeItems()))) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm");
            timeArrangeItems.stream().filter(timeArrangeItem -> {
                LocalDateTime localDateTime = LocalDateTime.now();
                String admDteTimeStr = admDate + " " + timeArrangeItem.getStartTime();
                String nowDateTimeStr = localDateTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd hh:mm"));
                try {
                    Long admDteTime = sdf.parse(admDteTimeStr).getTime();
                    Long nowDateTime = sdf.parse(nowDateTimeStr).getTime();
                    return admDteTime <= nowDateTime;
                }
                catch (Exception e) {
                    log.error("\u8f6c\u6362\u65e5\u671f\u5f02\u5e38:" + e);
                    return false;
                }
            }).collect(Collectors.toList());
        }
        String confirmAppointmentId = String.valueOf(this.snowflakeIdWorker.nextId());
        String confirmAppointmentVoStr = JSON.toJSONString((Object)confirmAppointmentVo);
        this.jedisCluster.set(confirmAppointmentId, confirmAppointmentVoStr);
        this.jedisCluster.expire(confirmAppointmentId, 7200);
        return confirmAppointmentId;
    }

    private String getHosId(String deptCode) {
        String hospitalAreaCode = this.deptRecordMapper.getHospitalAreaCode(deptCode);
        String hosId = "NCDXDEFSYY";
        if (null != hospitalAreaCode && hospitalAreaCode.equals("7902")) {
            return "NDEFYHJZYQ";
        }
        return hosId;
    }

    public String dayAppointmentCreateOrder(DayAppointmentCreateOrderVoReq createOrderVoReq) throws AppointmentException {
        String hisId = this.getHosId(createOrderVoReq.getDeptCode());
        log.info("\u9501\u53f7\u751f\u6210\u8ba2\u5355\u524d\u7aef\u5165\u53c2\uff1a" + createOrderVoReq);
        GatewayRequest gatewayRequest = this.buildGetScheduleGatewayReq(createOrderVoReq, hisId);
        log.info("\u5f53\u65e5\u6302\u53f7\u521b\u5efa\u8ba2\u5355 \u67e5\u8be2\u53f7\u6e90\u662f\u5426\u5b58\u5728 \u8bf7\u6c42his\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)gatewayRequest));
        GatewayResponse gatewayResponse = this.scheduleApi.getDoctorSchedule(gatewayRequest);
        log.info("\u5f53\u65e5\u6302\u53f7\u521b\u5efa\u8ba2\u5355 \u67e5\u8be2\u53f7\u6e90\u662f\u5426\u5b58\u5728 \u8bf7\u6c42his\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)gatewayResponse.getData()));
        if (gatewayResponse == null) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getDoctorSchedule -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            throw new AppointmentException("\u8be5\u65f6\u95f4\u6bb5\u53f7\u6e90\u5df2\u88ab\u5360\u7528\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u5176\u4ed6\u65f6\u95f4\u6bb5");
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getDoctorSchedule -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            throw new AppointmentException("\u8be5\u65f6\u95f4\u6bb5\u53f7\u6e90\u5df2\u88ab\u5360\u7528\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u5176\u4ed6\u65f6\u95f4\u6bb5");
        }
        if (gatewayResponse.getData() == null) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getDoctorSchedule -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            throw new AppointmentException("\u8be5\u65f6\u95f4\u6bb5\u53f7\u6e90\u5df2\u88ab\u5360\u7528\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u5176\u4ed6\u65f6\u95f4\u6bb5");
        }
        QueryCardInfoResVO queryCardInfoResVO = this.getCardInfo(createOrderVoReq.getPatientIdCard(), createOrderVoReq.getPatientName(), createOrderVoReq.getChannelName());
        if (null == queryCardInfoResVO) {
            log.error("======his\u83b7\u53d6\u60a3\u8005\u5361\u4fe1\u606f\u5931\u8d25=====");
            return null;
        }
        GetScheduleResItems getScheduleResItems = (GetScheduleResItems)((GetScheduleResVO)gatewayResponse.getData()).getItems().get(0);
        if (getScheduleResItems == null) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getDoctorSchedule -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            throw new AppointmentException("\u8be5\u65f6\u95f4\u6bb5\u53f7\u6e90\u5df2\u88ab\u5360\u7528\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u5176\u4ed6\u65f6\u95f4\u6bb5");
        }
        AppointmentRecordEntity appointmentRecordEntity = null;
        long sysAppointmentId = this.snowflakeIdWorker.nextId();
        GatewayRequest dayGatewayRequest = this.buildLockOrderReq(sysAppointmentId, createOrderVoReq, queryCardInfoResVO, hisId);
        String admTimeRange = "";
        if (!StringUtils.isEmpty((String)((LockOrderReq)dayGatewayRequest.getBody()).getBeginTime())) {
            admTimeRange = ((LockOrderReq)dayGatewayRequest.getBody()).getBeginTime() + "-" + ((LockOrderReq)dayGatewayRequest.getBody()).getEndTime();
        }
        log.info("\u6302\u53f7\u521b\u5efa\u8ba2\u5355 \u9501\u53f7 \u8bf7\u6c42his\u5165\u53c2\uff1a" + dayGatewayRequest);
        GatewayResponse dayGatewayResponse = this.appointApi.lockOrder(dayGatewayRequest);
        log.info("\u6302\u53f7\u521b\u5efa\u8ba2\u5355 \u9501\u53f7 \u8bf7\u6c42his\u51fa\u53c2\uff1a" + dayGatewayResponse.getData());
        if (null == dayGatewayResponse) {
            log.error("\u6302\u53f7 \u9501\u53f7\u5931\u8d25 lockOrder -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            throw new AppointmentException("\u6302\u53f7\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
        }
        if (!"1".equals(dayGatewayResponse.getCode())) {
            log.error("\u6302\u53f7 \u9501\u53f7\u5931\u8d25 lockOrder -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)dayGatewayResponse.getErrCode(), (Object)dayGatewayResponse.getMsg());
            if ("430".equals(dayGatewayResponse.getErrCode())) {
                throw new AppointmentException(dayGatewayResponse.getMsg());
            }
            throw new AppointmentException(dayGatewayResponse.getMsg());
        }
        if (null == dayGatewayResponse.getData()) {
            log.error("\u6302\u53f7 \u9501\u53f7\u5931\u8d25 lockOrder -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            throw new AppointmentException("\u6302\u53f7\u5931\u8d25\uff0c\u8bf7\u552e\u540e\u91cd\u8bd5\u6216\u53bb\u4eba\u5de5\u7a97\u53e3\u8fdb\u884c\u6302\u53f7");
        }
        try {
            this.updateSchduleCache(createOrderVoReq);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u6302\u53f7\u9501\u53f7\u5220\u9664\u7f13\u5b58\u4e2d\u7684\u6392\u73ed\u4fe1\u606f\u5931\u8d25!");
        }
        DayConfirmRegisterRes dayConfirmRegisterRes = (DayConfirmRegisterRes)dayGatewayResponse.getData();
        createOrderVoReq.setPatientPhone(queryCardInfoResVO.getTelephone());
        createOrderVoReq.setPatientId(queryCardInfoResVO.getPatientNo());
        appointmentRecordEntity = this.buildLockSourceAppointmentRecordEntity(getScheduleResItems, sysAppointmentId, dayConfirmRegisterRes, createOrderVoReq, admTimeRange, queryCardInfoResVO, hisId);
        log.info("\u6302\u53f7\u521b\u5efa\u8ba2\u5355 \u9501\u53f7 \u8bf7\u6c42his\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)appointmentRecordEntity));
        this.appointmentRecordMapper.insertSelective(appointmentRecordEntity);
        RabbitMqDelayedOrderVo rabbitMqDelayedOrderVo = new RabbitMqDelayedOrderVo();
        rabbitMqDelayedOrderVo.setHospitalCode(appointmentRecordEntity.getHospitalCode());
        rabbitMqDelayedOrderVo.setSysAppointmentId(appointmentRecordEntity.getSysAppointmentId());
        RabbitMqUtils.senderDelayedOrderOutTradeNo((RabbitTemplate)this.rabbitTemplate, (String)JSON.toJSONString((Object)rabbitMqDelayedOrderVo), (long)600000L);
        return appointmentRecordEntity.getSysAppointmentId();
    }

    private void updateSchduleCache(DayAppointmentCreateOrderVoReq createOrderVoReq) throws Exception {
        String key = "schduleCache|" + createOrderVoReq.getDeptCode() + "|" + createOrderVoReq.getAdmDate();
        List list = new ArrayList();
        String listStr = this.jedisCluster.get(key);
        if (StringUtils.isEmpty((String)listStr)) {
            return;
        }
        list = JSONObject.parseArray((String)listStr).toJavaList(GetScheduleVoRes.class);
        for (int i = 0; i < list.size(); ++i) {
            List scheduleBaseInfoVoList = ((GetScheduleVoRes)list.get(i)).getScheduleBaseInfoVoList();
            for (int j = 0; j < scheduleBaseInfoVoList.size(); ++j) {
                if (!((ScheduleBaseInfoVo)scheduleBaseInfoVoList.get(j)).getScheduleId().equals(createOrderVoReq.getScheduleHisId())) continue;
                ((ScheduleBaseInfoVo)scheduleBaseInfoVoList.get(j)).setRegAvailable(Integer.valueOf(((ScheduleBaseInfoVo)scheduleBaseInfoVoList.get(j)).getRegAvailable() - 1));
                log.info("\u9501\u53f7\u6210\u529f\u540e\u66f4\u65b0\u7f13\u5b58\u7684\u6392\u73ed\u4fe1\u606f-1\uff1a" + JSON.toJSONString(list));
                this.jedisCluster.set(key, JSONArray.toJSONString(list));
                return;
            }
        }
    }

    private AppointmentRecordEntity buildAppointmentRecordEntity(long sysAppointmentId, GetScheduleResItems getScheduleResItem, DayAppointmentCreateOrderVoReq createOrderVoReq, CardDetailsInfoRespVO cardDetail) {
        AppointmentRecordEntity appointmentRecordEntity = new AppointmentRecordEntity();
        appointmentRecordEntity.setAdmAddress(StringUtils.isEmpty((String)getScheduleResItem.getAdmLocation()) ? "null" : getScheduleResItem.getAdmLocation());
        appointmentRecordEntity.setAdmDate(createOrderVoReq.getAdmDate());
        appointmentRecordEntity.setAdmRange((int)Byte.valueOf(createOrderVoReq.getAdmTimeRange()).byteValue());
        appointmentRecordEntity.setAppointmentTime(new Date());
        appointmentRecordEntity.setAppointmentType(2);
        appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.WAIT_PAY.getValue());
        appointmentRecordEntity.setCardId(createOrderVoReq.getCardId());
        appointmentRecordEntity.setChannelCode(createOrderVoReq.getChannelName());
        appointmentRecordEntity.setDeptCode(createOrderVoReq.getDeptCode());
        appointmentRecordEntity.setDeptName(getScheduleResItem.getLocName());
        appointmentRecordEntity.setDocCode(getScheduleResItem.getDocCode());
        appointmentRecordEntity.setDocName(getScheduleResItem.getDocName());
        appointmentRecordEntity.setHospitalCode(createOrderVoReq.getHospitalCode());
        appointmentRecordEntity.setHospitalName(getScheduleResItem.getHospitalArea());
        appointmentRecordEntity.setInnerChannelCode("\u533b\u9662\u6e20\u9053\u7f16\u7801");
        appointmentRecordEntity.setKeepSource(new Byte("1"));
        appointmentRecordEntity.setPatientCardNo(cardDetail.getCardNo());
        appointmentRecordEntity.setPatientId(cardDetail.getOrganPmi());
        appointmentRecordEntity.setPatientIdCard(createOrderVoReq.getPatientIdCard());
        appointmentRecordEntity.setPatientName(createOrderVoReq.getPatientName());
        appointmentRecordEntity.setPatientPhone(createOrderVoReq.getPatientPhone());
        appointmentRecordEntity.setPatientAge(IdCardUtil.getAgeByIdCard((String)createOrderVoReq.getPatientIdCard()));
        appointmentRecordEntity.setPatientSex(IdCardUtil.getGenderByIdCard((String)createOrderVoReq.getPatientIdCard()) == "M" ? 1 : 2);
        BigDecimal totalFee = new BigDecimal(getScheduleResItem.getRegFee()).add(new BigDecimal(getScheduleResItem.getDiagFee()));
        appointmentRecordEntity.setPayAmount(totalFee.toString());
        appointmentRecordEntity.setRegFee(new BigDecimal(getScheduleResItem.getRegFee()));
        appointmentRecordEntity.setServiceFee(new BigDecimal("0"));
        appointmentRecordEntity.setScheduleHisId(getScheduleResItem.getScheduleId());
        appointmentRecordEntity.setRegTitleName(getScheduleResItem.getRegTitleName());
        appointmentRecordEntity.setScheduleLevelName(getScheduleResItem.getScheduleLevelName());
        appointmentRecordEntity.setScheduleType(getScheduleResItem.getScheduleType().toString());
        appointmentRecordEntity.setSysAppointmentId(String.valueOf(sysAppointmentId));
        appointmentRecordEntity.setSysScheduleId(String.valueOf(this.snowflakeIdWorker.nextId()));
        appointmentRecordEntity.setSysTimeArrangeId(String.valueOf(this.snowflakeIdWorker.nextId()));
        appointmentRecordEntity.setUserId(createOrderVoReq.getUserId());
        appointmentRecordEntity.setHisTimeArrangeId(createOrderVoReq.getTimeArrangeId());
        return appointmentRecordEntity;
    }

    private AppointmentRecordEntity buildLockSourceAppointmentRecordEntity(GetScheduleResItems getScheduleResItems, long sysAppointmentId, DayConfirmRegisterRes dayConfirmRegisterRes, DayAppointmentCreateOrderVoReq createOrderVoReq, String admTimeRange, QueryCardInfoResVO queryCardInfoResVO, String hosId) {
        AppointmentRecordEntity appointmentRecordEntity = new AppointmentRecordEntity();
        appointmentRecordEntity.setHosId(hosId);
        appointmentRecordEntity.setAppointmentId(dayConfirmRegisterRes.getFlowNo());
        appointmentRecordEntity.setAdmAddress(getScheduleResItems.getAdmLocation());
        appointmentRecordEntity.setAdmDate(createOrderVoReq.getAdmDate());
        appointmentRecordEntity.setAdmRange((int)Byte.valueOf(createOrderVoReq.getAdmTimeRange()).byteValue());
        appointmentRecordEntity.setAppointmentTime(new Date());
        appointmentRecordEntity.setAppointmentType(2);
        appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.WAIT_PAY.getValue());
        appointmentRecordEntity.setCardId(createOrderVoReq.getCardId());
        appointmentRecordEntity.setChannelCode(createOrderVoReq.getChannelName());
        appointmentRecordEntity.setDeptCode(createOrderVoReq.getDeptCode());
        appointmentRecordEntity.setDeptName(getScheduleResItems.getLocName());
        appointmentRecordEntity.setDocCode(createOrderVoReq.getDocCode());
        appointmentRecordEntity.setDocName(getScheduleResItems.getDocName());
        appointmentRecordEntity.setHospitalCode(createOrderVoReq.getHospitalCode());
        appointmentRecordEntity.setHospitalName(getScheduleResItems.getHospitalArea());
        appointmentRecordEntity.setInnerChannelCode("\u533b\u9662\u6e20\u9053\u7f16\u7801");
        appointmentRecordEntity.setKeepSource(new Byte("1"));
        appointmentRecordEntity.setPatientCardNo(createOrderVoReq.getPatientCardNo());
        appointmentRecordEntity.setPatientId(queryCardInfoResVO.getPatientId());
        appointmentRecordEntity.setPatientIdCard(createOrderVoReq.getPatientIdCard());
        appointmentRecordEntity.setPatientName(createOrderVoReq.getPatientName());
        appointmentRecordEntity.setPatientPhone(createOrderVoReq.getPatientPhone());
        appointmentRecordEntity.setPatientAge(IdCardUtil.getAgeByIdCard((String)createOrderVoReq.getPatientIdCard()));
        appointmentRecordEntity.setPatientSex(IdCardUtil.getGenderByIdCard((String)createOrderVoReq.getPatientIdCard()) == "M" ? 1 : 2);
        BigDecimal totalFee = new BigDecimal(getScheduleResItems.getRegFee()).add(new BigDecimal(getScheduleResItems.getDiagFee()));
        appointmentRecordEntity.setPayAmount(totalFee.toString());
        appointmentRecordEntity.setRegFee(new BigDecimal(getScheduleResItems.getRegFee()));
        appointmentRecordEntity.setServiceFee(new BigDecimal("0"));
        appointmentRecordEntity.setScheduleHisId(createOrderVoReq.getScheduleHisId());
        appointmentRecordEntity.setRegTitleName(getScheduleResItems.getRegTitleName());
        appointmentRecordEntity.setScheduleLevelName(getScheduleResItems.getScheduleLevelName());
        appointmentRecordEntity.setScheduleType(getScheduleResItems.getScheduleType().toString());
        appointmentRecordEntity.setSysAppointmentId(String.valueOf(sysAppointmentId));
        appointmentRecordEntity.setSysScheduleId(String.valueOf(this.snowflakeIdWorker.nextId()));
        appointmentRecordEntity.setSysTimeArrangeId(String.valueOf(this.snowflakeIdWorker.nextId()));
        appointmentRecordEntity.setUserId(createOrderVoReq.getUserId());
        appointmentRecordEntity.setHisTimeArrangeId(createOrderVoReq.getTimeArrangeId());
        appointmentRecordEntity.setAppointmentNo(createOrderVoReq.getTimeArrangeId());
        if (!StringUtils.isEmpty((String)admTimeRange)) {
            appointmentRecordEntity.setAdmTimeRange(admTimeRange);
        }
        appointmentRecordEntity.setAdmId(dayConfirmRegisterRes.getFlowNo());
        return appointmentRecordEntity;
    }

    private void checkPatientAppointmentInfo(DayAppointmentCreateOrderVoReq createOrderVoReq) throws AppointmentException {
        Integer appointmentCount = this.appointmentRecordMapper.selectPatientCurrentDateSameDeptValidAppointmentCount(createOrderVoReq.getHospitalCode(), createOrderVoReq.getPatientId(), createOrderVoReq.getDeptCode(), String.valueOf(LocalDate.now()));
        if (appointmentCount >= 1) {
            throw new AppointmentException("\u65e0\u6cd5\u9884\u7ea6, \u8be5\u5c31\u8bca\u4eba\u540c\u4e00\u79d1\u5ba4\u533b\u751f\u53ea\u80fd\u9884\u7ea6\u4e00\u4e2a");
        }
        Integer totalAppointmentCount = this.appointmentRecordMapper.selectPatientCurrentDateValidAppointCount(createOrderVoReq.getHospitalCode(), createOrderVoReq.getPatientId(), String.valueOf(LocalDate.now()));
        if (totalAppointmentCount >= 2) {
            throw new AppointmentException("\u65e0\u6cd5\u9884\u7ea6, \u8be5\u5c31\u8bca\u4eba\u4eca\u65e5\u9884\u7ea6\u6b21\u6570\u5df2\u8fbe\u4e0a\u9650");
        }
    }

    public ConfirmAppointmentVo getConfirmAppointment(String confirmAppointmentId) {
        String confirmAppointmentVoStr = this.jedisCluster.get(confirmAppointmentId);
        ConfirmAppointmentVo confirmAppointmentVo = (ConfirmAppointmentVo)JSON.parseObject((String)confirmAppointmentVoStr, ConfirmAppointmentVo.class);
        List timeArrangeItemsList = confirmAppointmentVo.getTimeArrangeItems();
        if (!CollectionUtils.isEmpty((Collection)timeArrangeItemsList)) {
            timeArrangeItemsList.sort(Comparator.comparing(TimeArrangeItems::getStartTime));
        }
        confirmAppointmentVo.setTimeArrangeItems(timeArrangeItemsList);
        return confirmAppointmentVo;
    }

    public GetConfirmPayInfoVoRes getConfirmPayInfo(String sysAppointmentId) {
        AppointmentRecordEntity appointmentRecordEntity = this.appointmentRecordMapper.selectBySysAppointId(sysAppointmentId);
        GetConfirmPayInfoVoRes getConfirmPayInfoVoRes = new GetConfirmPayInfoVoRes();
        getConfirmPayInfoVoRes.setCreateTime(appointmentRecordEntity.getCreatetime());
        getConfirmPayInfoVoRes.setPayAccount(appointmentRecordEntity.getPayAmount());
        getConfirmPayInfoVoRes.setSysAppointmentId(sysAppointmentId);
        getConfirmPayInfoVoRes.setAppointmentType(appointmentRecordEntity.getAppointmentType());
        getConfirmPayInfoVoRes.setPatientName(appointmentRecordEntity.getPatientName());
        return getConfirmPayInfoVoRes;
    }

    private GatewayRequest<GetScheduleReqVO> buildGetScheduleGatewayReq(DayAppointmentCreateOrderVoReq dayAppointmentCreateOrderVoReq, String hisId) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        GetScheduleReqVO getScheduleReqVO = new GetScheduleReqVO();
        getScheduleReqVO.setBgDate(dayAppointmentCreateOrderVoReq.getAdmDate());
        getScheduleReqVO.setEdDate(dayAppointmentCreateOrderVoReq.getAdmDate());
        getScheduleReqVO.setLocCode(dayAppointmentCreateOrderVoReq.getDeptCode());
        getScheduleReqVO.setDocCode(dayAppointmentCreateOrderVoReq.getDocCode());
        getScheduleReqVO.setScheduleCode(hisId);
        gatewayRequest.setBody((Object)getScheduleReqVO);
        gatewayRequest.setChannelName(dayAppointmentCreateOrderVoReq.getChannelName());
        gatewayRequest.setChannel(dayAppointmentCreateOrderVoReq.getChannelName());
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("dayAppointmentCreateOrder");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    public List<AppointmentRecordVo> getAppointRecordByCardList(String userId, String hospitalCode, String appCode, String channelCode) throws AppointmentException {
        UcCardListReqVO reqVo = new UcCardListReqVO();
        reqVo.setUserId(userId);
        reqVo.setOrganCode(hospitalCode);
        reqVo.setAppCode(appCode);
        reqVo.setChannelCode(channelCode);
        List cardIdList = this.getCardIdList(reqVo);
        if (CollectionUtils.isEmpty((Collection)cardIdList)) {
            return new ArrayList<AppointmentRecordVo>();
        }
        List appointmentRecordEntityList = null;
        Date startDate = DateUtils.getCurrentDate();
        HashMap<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put("admDateStart", DateUtils.dateToSimpleString((Date)startDate));
        queryMap.put("admDateEnd", DateUtils.dateToSimpleString((Date)DateUtils.getDateAfter((Date)startDate, (int)7)));
        queryMap.put("userId", userId);
        ArrayList<Integer> appointStatusList = new ArrayList<Integer>();
        appointStatusList.add(AppointmentStatusEnum.PAY.getValue());
        appointStatusList.add(AppointmentStatusEnum.WAIT_PAY.getValue());
        queryMap.put("appointStatus", appointStatusList);
        queryMap.put("now", DateUtils.dateToSimpleString((Date)startDate));
        queryMap.put("hospitalCode", hospitalCode);
        queryMap.put("cardIdList", cardIdList);
        appointmentRecordEntityList = this.appointmentRecordMapper.selectByUserIdAndStatus(queryMap);
        appointmentRecordEntityList = appointmentRecordEntityList.stream().filter(appointmentRecordEntity -> appointmentRecordEntity.getAppointmentType() != AppointmentTypeEnums.DAY_APPOINTMENT.getValue().intValue() || !appointmentRecordEntity.getAppointStatus().equals(AppointmentStatusEnum.WAIT_PAY.getValue())).collect(Collectors.toList());
        return this.buildAppointmentRecordVo(appointmentRecordEntityList);
    }

    private List<String> getCardIdList(UcCardListReqVO reqVo) throws AppointmentException {
        ArrayList<String> cardIdList = new ArrayList<String>();
        log.error("getCardIdList start-------reqVo:{}", (Object)reqVo);
        BaseResponse resp = this.getCardInfoUtil.getUserCardList(reqVo);
        List UserPatientListRespVOList = JSONObject.parseArray((String)JSONObject.toJSONString((Object)resp.getData()), UserPatientListRespVO.class);
        for (UserPatientListRespVO userPatientListRespVO : UserPatientListRespVOList) {
            List userCardListRespVOList = userPatientListRespVO.getUserCardListRespVOS();
            if (userCardListRespVOList == null && userCardListRespVOList.size() <= 0) continue;
            for (UserCardListRespVO userCardListRespVO : userCardListRespVOList) {
                if (userCardListRespVO == null || userCardListRespVO.getCardId() == null || "".equals(userCardListRespVO.getCardId())) continue;
                cardIdList.add(userCardListRespVO.getCardId());
            }
        }
        return cardIdList;
    }

    public List<AppointmentRecordVo> getMyRegistrationList(RegisterationQueryParamsDTO registerationQueryParamsDTO) throws Exception {
        String hospitalCode = registerationQueryParamsDTO.getHospitalCode();
        List appointmentRecordEntityList = this.appointmentRecordMapper.getMyRegistrationList(registerationQueryParamsDTO);
        List appointmentRecordVoList = this.buildAppointmentRecordVo(appointmentRecordEntityList);
        HospitalConfigEntity hospitalConfigEntity = this.hospitalConfigMapper.selectByHospitalCode(hospitalCode);
        for (int i = 0; i < appointmentRecordVoList.size(); ++i) {
            AppointmentRecordVo appointmentRecordVo = (AppointmentRecordVo)appointmentRecordVoList.get(i);
            if (hospitalConfigEntity != null && hospitalConfigEntity.getAppointAutoCancelMin() != null) {
                int appointAutoCancelMin = hospitalConfigEntity.getAppointAutoCancelMin();
                appointmentRecordVo.setExpiredtime((long)(hospitalConfigEntity.getAppointAutoCancelMin() * 60));
                appointmentRecordVo.setExpiredendtime(appointmentRecordVo.getCreatetime() + (long)(hospitalConfigEntity.getAppointAutoCancelMin() * 60 * 1000));
                continue;
            }
            appointmentRecordVo.setExpiredtime(600L);
            appointmentRecordVo.setExpiredendtime(appointmentRecordVo.getCreatetime() + appointmentRecordVo.getExpiredtime() * 1000L);
        }
        return appointmentRecordVoList;
    }

    private List<AppointmentRecordVo> buildAppointmentRecordVo(List<AppointmentRecordEntity> appointmentRecordEntityList) throws AppointmentException {
        if (CollectionUtils.isEmpty(appointmentRecordEntityList)) {
            return new ArrayList<AppointmentRecordVo>();
        }
        CardDetailsInfoReqVO cardDetailsInfoReqVO = new CardDetailsInfoReqVO();
        cardDetailsInfoReqVO.setCardId(appointmentRecordEntityList.get(0).getCardId());
        cardDetailsInfoReqVO.setChannelCode("app");
        CardDetailsInfoRespVO cardDetailsInfoRespVO = this.getCardInfoUtil.getCardDetail(cardDetailsInfoReqVO);
        ArrayList<AppointmentRecordVo> appointmentRecordVoList = new ArrayList<AppointmentRecordVo>();
        for (int i = 0; i < appointmentRecordEntityList.size(); ++i) {
            AppointmentRecordEntity appointmentRecordEntity = appointmentRecordEntityList.get(i);
            if (StringUtils.isEmpty((String)appointmentRecordEntity.getPayAmount())) continue;
            AppointmentRecordVo appointmentRecordVo = new AppointmentRecordVo();
            appointmentRecordVo.setAdmDate(appointmentRecordEntity.getAdmDate());
            if (null != appointmentRecordEntity.getAdmTimeRange()) {
                appointmentRecordVo.setAdmTimeRange(appointmentRecordEntity.getAdmTimeRange());
            } else {
                if (appointmentRecordEntity.getAdmRange() == AdmTimeRangeEnum.MORNING.getValue().intValue()) {
                    appointmentRecordVo.setAdmTimeRange("08:00-12:00");
                }
                if (appointmentRecordEntity.getAdmRange() == AdmTimeRangeEnum.AFTERNOON.getValue().intValue()) {
                    appointmentRecordVo.setAdmTimeRange("14:00-17:30");
                }
                if (appointmentRecordEntity.getAdmRange() == AdmTimeRangeEnum.ALL_DAY.getValue().intValue()) {
                    appointmentRecordVo.setAdmTimeRange("08:00-17:30");
                }
                if (appointmentRecordEntity.getAdmRange() == AdmTimeRangeEnum.NIGHT.getValue().intValue()) {
                    appointmentRecordVo.setAdmTimeRange("18:00-21:00");
                }
            }
            Integer appointStatus = appointmentRecordEntity.getAppointStatus();
            if (appointmentStatusList.contains(appointStatus)) {
                appointStatus = AppointmentStatusEnum.WAIT_HIS_CONFIRM.getValue();
            }
            appointmentRecordVo.setAppointStatus(appointStatus);
            appointmentRecordVo.setDeptName(appointmentRecordEntity.getDeptName());
            appointmentRecordVo.setDocName(appointmentRecordEntity.getDocName());
            appointmentRecordVo.setPatientIdCard(appointmentRecordEntity.getCardId());
            appointmentRecordVo.setUserId(appointmentRecordEntity.getUserId());
            appointmentRecordVo.setPatientName(appointmentRecordEntity.getPatientName());
            appointmentRecordVo.setAdmRange(appointmentRecordEntity.getAdmRange());
            appointmentRecordVo.setRegFee(new BigDecimal(appointmentRecordEntity.getPayAmount()));
            appointmentRecordVo.setSysAppointmentId(appointmentRecordEntity.getSysAppointmentId());
            appointmentRecordVo.setAppointmentType(appointmentRecordEntity.getAppointmentType());
            appointmentRecordVo.setCreatetime(appointmentRecordEntity.getCreatetime().getTime());
            appointmentRecordVo.setPayChannel(appointmentRecordEntity.getPayChannel());
            long daysRemaining = 0L;
            try {
                daysRemaining = DateUtils.getDistanceDays((String)String.valueOf(LocalDate.now()), (String)appointmentRecordEntity.getAdmDate());
            }
            catch (Exception e) {
                log.error("-------\u8ba1\u7b97\u8ddd\u79bb\u5c31\u8bca\u65e5\u5931\u8d25-------");
            }
            appointmentRecordVo.setDaysRemaining(daysRemaining);
            appointmentRecordVo.setIsTheDay(0L == daysRemaining ? 1L : 2L);
            if (cardDetailsInfoRespVO != null && cardDetailsInfoRespVO.getCardTypeName() != null) {
                appointmentRecordVo.setPatientCardName(cardDetailsInfoRespVO.getCardTypeName());
            }
            appointmentRecordVoList.add(appointmentRecordVo);
        }
        return appointmentRecordVoList;
    }

    public AppointmentRecordDetailVo getMyRegistrationDetail(String sysAppointmentId) throws AppointmentException {
        AppointmentRecordEntity appointmentRecordEntity = this.appointmentRecordMapper.selectBySysAppointId(sysAppointmentId);
        if (null == appointmentRecordEntity) {
            log.error("AppointmentServiceImpl.getMyRegistrationDetail->\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff0c\u67e5\u8be2\u8bf7\u6c42\u53c2\u6570sysAppointmentId\u4e3a:{}", (Object)sysAppointmentId);
            throw new AppointmentException();
        }
        String hospitalCode = appointmentRecordEntity.getHospitalCode();
        CardDetailsInfoReqVO cardDetailsInfoReqVO = new CardDetailsInfoReqVO();
        cardDetailsInfoReqVO.setCardId(appointmentRecordEntity.getCardId());
        cardDetailsInfoReqVO.setChannelCode("app");
        AppointmentRecordDetailVo appointmentRecordDetailVo = new AppointmentRecordDetailVo();
        CardDetailsInfoRespVO cardDetailsInfoRespVO = this.getCardInfoUtil.getCardDetail(cardDetailsInfoReqVO);
        if (cardDetailsInfoRespVO != null && cardDetailsInfoRespVO.getCardTypeName() != null) {
            appointmentRecordDetailVo.setPatientCardName(cardDetailsInfoRespVO.getCardTypeName());
            appointmentRecordDetailVo.setHisPatientId(cardDetailsInfoRespVO.getOrganPmi());
        }
        Integer age = 0;
        try {
            age = DateUtils.getAgeByBirth((Date)DateUtils.stringToSimpleDate((String)cardDetailsInfoRespVO.getBirth()));
        }
        catch (ParseException e) {
            log.error("\u3010\u83b7\u53d6\u8ba2\u5355\u8be6\u60c5\u3011\u8f6c\u6362\u5e74\u9f84\u51fa\u9519 :" + e.getMessage());
            throw new AppointmentException("\u8f6c\u6362\u5e74\u9f84\u51fa\u9519");
        }
        appointmentRecordDetailVo.setPatientAge(age);
        this.buildAppointmentRecordDetailVo(appointmentRecordDetailVo, appointmentRecordEntity, hospitalCode);
        return appointmentRecordDetailVo;
    }

    private void buildAppointmentRecordDetailVo(AppointmentRecordDetailVo appointmentRecordDetailVo, AppointmentRecordEntity appointmentRecordEntity, String hospitalCode) {
        appointmentRecordDetailVo.setId(appointmentRecordEntity.getId());
        appointmentRecordDetailVo.setHospitalName(appointmentRecordEntity.getHospitalName());
        appointmentRecordDetailVo.setPatientName(appointmentRecordEntity.getPatientName());
        appointmentRecordDetailVo.setPatientSex(Integer.valueOf(appointmentRecordEntity.getPatientSex()));
        appointmentRecordDetailVo.setSysAppointmentId(appointmentRecordEntity.getSysAppointmentId());
        appointmentRecordDetailVo.setAdmDate(appointmentRecordEntity.getAdmDate());
        appointmentRecordDetailVo.setAdmTimeRange(appointmentRecordEntity.getAdmTimeRange());
        if (StringUtils.isEmpty((String)appointmentRecordEntity.getAdmTimeRange())) {
            if (appointmentRecordEntity.getAdmRange() == AdmTimeRangeEnum.MORNING.getValue().intValue()) {
                appointmentRecordDetailVo.setAdmTimeRange("08:00-12:00");
            }
            if (appointmentRecordEntity.getAdmRange() == AdmTimeRangeEnum.AFTERNOON.getValue().intValue()) {
                appointmentRecordDetailVo.setAdmTimeRange("14:00-17:30");
            }
            if (appointmentRecordEntity.getAdmRange() == AdmTimeRangeEnum.ALL_DAY.getValue().intValue()) {
                appointmentRecordDetailVo.setAdmTimeRange("08:00-17:30");
            }
            if (appointmentRecordEntity.getAdmRange() == AdmTimeRangeEnum.NIGHT.getValue().intValue()) {
                appointmentRecordDetailVo.setAdmTimeRange("18:00-21:00");
            }
        } else {
            appointmentRecordDetailVo.setAdmTimeRange(appointmentRecordEntity.getAdmTimeRange());
        }
        if (appointmentRecordEntity.getAppointmentType() == AppointmentTypeEnums.APPOINTMENT.getValue().intValue() && null != appointmentRecordEntity.getAdmTimeRange() && appointmentRecordEntity.getAdmTimeRange().length() >= 11) {
            appointmentRecordDetailVo.setAdmStartTime(appointmentRecordEntity.getAdmTimeRange().substring(0, 5));
            appointmentRecordDetailVo.setAdmEndTime(appointmentRecordEntity.getAdmTimeRange().substring(6, 11));
        }
        appointmentRecordDetailVo.setDocName(appointmentRecordEntity.getDocName());
        appointmentRecordDetailVo.setDeptName(appointmentRecordEntity.getDeptName());
        appointmentRecordDetailVo.setAdmAddress(appointmentRecordEntity.getAdmAddress());
        appointmentRecordDetailVo.setPatientCardNo(appointmentRecordEntity.getPatientCardNo());
        appointmentRecordDetailVo.setCreatetime(appointmentRecordEntity.getCreatetime().getTime());
        appointmentRecordDetailVo.setPayChannel(appointmentRecordEntity.getPayChannelCode());
        HospitalConfigEntity hospitalConfigEntity = this.hospitalConfigMapper.selectByHospitalCode(hospitalCode);
        if (hospitalConfigEntity != null && hospitalConfigEntity.getAppointAutoCancelMin() != null) {
            int appointAutoCancelMin = hospitalConfigEntity.getAppointAutoCancelMin();
            appointmentRecordDetailVo.setExpiredtime((long)(hospitalConfigEntity.getAppointAutoCancelMin() * 60));
            appointmentRecordDetailVo.setExpiredendtime(appointmentRecordDetailVo.getCreatetime() + (long)(hospitalConfigEntity.getAppointAutoCancelMin() * 60 * 1000));
        } else {
            appointmentRecordDetailVo.setExpiredtime(1800L);
            appointmentRecordDetailVo.setExpiredendtime(appointmentRecordEntity.getCreatetime().getTime() + 600000L);
        }
        appointmentRecordDetailVo.setAppointmentType(appointmentRecordEntity.getAppointmentType());
        appointmentRecordDetailVo.setAdmRange(appointmentRecordEntity.getAdmRange());
        appointmentRecordDetailVo.setRegTitleName(appointmentRecordEntity.getRegTitleName());
        appointmentRecordDetailVo.setTakeTime(appointmentRecordEntity.getTakeTime());
        appointmentRecordDetailVo.setTakeAddress(appointmentRecordEntity.getTakeAddress());
        appointmentRecordDetailVo.setScheduleLevelName(appointmentRecordEntity.getScheduleLevelName());
        appointmentRecordDetailVo.setRegFee(appointmentRecordEntity.getRegFee());
        appointmentRecordDetailVo.setServiceFee(appointmentRecordEntity.getServiceFee());
        appointmentRecordDetailVo.setTotalAmount(new BigDecimal(appointmentRecordEntity.getPayAmount()));
        appointmentRecordDetailVo.setAppointmentNo(appointmentRecordEntity.getAppointmentNo());
        appointmentRecordDetailVo.setPayAccdate(appointmentRecordEntity.getPayAccdate());
        appointmentRecordDetailVo.setPayChannel(appointmentRecordEntity.getPayChannel());
        Integer appointStatus = appointmentRecordEntity.getAppointStatus();
        if (appointmentStatusList.contains(appointStatus)) {
            appointStatus = AppointmentStatusEnum.WAIT_HIS_CONFIRM.getValue();
        }
        try {
            long daysRemaining = DateUtils.getDistanceDays((String)String.valueOf(LocalDate.now()), (String)appointmentRecordEntity.getAdmDate());
            appointmentRecordDetailVo.setDaysRemaining(daysRemaining);
            appointmentRecordDetailVo.setIsTheDay(0L == daysRemaining ? 1L : 2L);
        }
        catch (Exception e) {
            log.error("======\u8ba1\u7b97\u8ddd\u8bca\u65ad\u65e5\u8fd8\u5269\u4e0b\u5929\u6570\u5931\u8d25=====");
        }
        if (null != appointmentRecordEntity.getYbInfo()) {
            ConsultationHealtInuranceRes consultationHealtInuranceRes = (ConsultationHealtInuranceRes)JSONObject.parseObject((String)appointmentRecordEntity.getYbInfo(), ConsultationHealtInuranceRes.class);
            appointmentRecordDetailVo.setFundPay(consultationHealtInuranceRes.getFundPay());
            appointmentRecordDetailVo.setOwnPayAmt(consultationHealtInuranceRes.getOwnPayAmt());
            appointmentRecordDetailVo.setPsnAcctPay(consultationHealtInuranceRes.getPsnAcctPay());
        }
        appointmentRecordDetailVo.setAppointStatus(appointStatus.intValue());
    }

    public void cancelAppointment(CancelAppointmentVoReq cancelAppointmentVoReq) throws AppointmentException {
        AppointmentRecordEntity appointmentRecordEntity = this.appointmentRecordMapper.selectBySysAppointId(cancelAppointmentVoReq.getSysAppointmentId());
        GatewayRequest gatewayRequest = this.buildCancelRegisterGatewayReq(cancelAppointmentVoReq, appointmentRecordEntity);
        String message = "\u53d6\u6d88\u9884\u7ea6 \u53d6\u6d88\u9884\u7ea6 cancelAppoint";
        BusinessResultEntity businessResultEntity = new BusinessResultEntity();
        businessResultEntity.setChannelCode(appointmentRecordEntity.getChannelCode());
        businessResultEntity.setBusinessType(new Byte(BusinessTypeEnums.REFUND_WRITE.getValue().toString()));
        businessResultEntity.setHisRequest(JSON.toJSONString((Object)gatewayRequest));
        this.businessResultMapper.insertSelective(businessResultEntity);
        GatewayResponse gatewayResponse = this.invokeHisCancelLockOrder(gatewayRequest, message);
        businessResultEntity.setErrorCode(gatewayResponse.getErrCode());
        businessResultEntity.setErrorMsg(gatewayResponse.getMsg());
        businessResultEntity.setHisResponse(JSON.toJSONString((Object)gatewayResponse));
        businessResultEntity.setTransationId(gatewayResponse.getTransactionId());
        businessResultEntity.setStatus(new Byte("0"));
        this.businessResultMapper.updateByPrimaryKeySelective(businessResultEntity);
        appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.CANCEL.getValue());
        appointmentRecordEntity.setCancleTime(new Date());
        appointmentRecordEntity.setCancleType(CancelTypeEnum.CHANNEL_CANCEL.getValue().intValue());
        appointmentRecordEntity.setCancleReason("\u7528\u6237\u53d6\u6d88");
        appointmentRecordEntity.setRemark("\u7528\u6237\u4e3b\u52a8\u53d6\u6d88");
        appointmentRecordEntity.setCancleChannelCode(cancelAppointmentVoReq.getChannelName());
        this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecordEntity);
        this.scheduleRecordMapper.updateByScheduleHisId(appointmentRecordEntity.getScheduleHisId());
        if (StringUtils.isNotEmpty((String)appointmentRecordEntity.getAdmTimeRange())) {
            this.scheduleDetailRecordMapper.updateByScheduleHisIdAndTime(appointmentRecordEntity.getScheduleHisId(), appointmentRecordEntity.getAdmTimeRange().substring(0, 5), appointmentRecordEntity.getHospitalCode());
        }
        if (null != appointmentRecordEntity.getPlatform() && appointmentRecordEntity.getPlatform().equals("BD")) {
            this.taskExecutor.execute(() -> {
                UpdateOrderInfoReqVo updateOrderInfoReqVo = new UpdateOrderInfoReqVo();
                updateOrderInfoReqVo.setTimes(Integer.valueOf(1));
                updateOrderInfoReqVo.setOrder_id(appointmentRecordEntity.getSysAppointmentId());
                updateOrderInfoReqVo.setOrder_status(Integer.valueOf(2));
                log.info("==BAIDU==\u8ba2\u5355\u66f4\u65b0\u63a5\u53e3==IN==" + JSONObject.toJSONString((Object)updateOrderInfoReqVo));
                this.specializDiseaseService.updateOrderInfo(updateOrderInfoReqVo);
                OrderCenterPushReqVo orderCenterPushReqVo = this.buildBdorderCenterUpdatahReq(appointmentRecordEntity, cancelAppointmentVoReq.getOpenId());
                this.specializDiseaseService.orderUpdate(orderCenterPushReqVo);
                AppointmentCreateOrderVoReq createOrderVoReq = new AppointmentCreateOrderVoReq();
                createOrderVoReq.setOpenId(cancelAppointmentVoReq.getOpenId());
                createOrderVoReq.setSubscribeId(cancelAppointmentVoReq.getSubscribeId());
                String msg = "\u6302\u53f7\u8005\u672c\u4eba\u53d6\u6d88";
                String templateId = "46cd1cd7519f474b93ae6881b1ee7472";
                MessageSendReqVo messageSendReqVo = this.buildBdMessageSendReq(createOrderVoReq, appointmentRecordEntity, msg, templateId);
                log.info("==messageSendReqVo==:" + JSONObject.toJSONString((Object)messageSendReqVo));
                this.specializDiseaseService.messageSend(messageSendReqVo);
            });
        }
    }

    private OrderCenterPushReqVo buildBdorderCenterUpdatahReq(AppointmentRecordEntity appointmentRecordEntity, String openId) {
        ArrayList<OrderCenterPushDataDTO> data = new ArrayList<OrderCenterPushDataDTO>();
        OrderCenterPushDataDTO orderCenterPushDataDTO = new OrderCenterPushDataDTO();
        orderCenterPushDataDTO.setResourceID(appointmentRecordEntity.getSysAppointmentId());
        orderCenterPushDataDTO.setBizAPPID(this.propertiesConstant.getBaiduAppKey());
        orderCenterPushDataDTO.setStatus(Integer.valueOf(100));
        data.add(orderCenterPushDataDTO);
        OrderCenterPushReqVo orderCenterPushReqVo = new OrderCenterPushReqVo();
        orderCenterPushReqVo.setOpenId(openId);
        orderCenterPushReqVo.setData(data);
        return orderCenterPushReqVo;
    }

    public void cancelRegister(CancelAppointmentVoReq cancelAppointmentVoReq) throws AppointmentException {
        AppointmentRecordEntity appointmentRecordEntity = this.appointmentRecordMapper.selectBySysAppointId(cancelAppointmentVoReq.getSysAppointmentId());
        GatewayRequest gatewayRequest = this.buildCancelRegisterGatewayReq(cancelAppointmentVoReq, appointmentRecordEntity.getAdmId(), appointmentRecordEntity.getHosId());
        String message = "\u53d6\u6d88\u6302\u53f7 \u53d6\u6d88\u6302\u53f7 cancelRegister";
        BusinessResultEntity businessResultEntity = new BusinessResultEntity();
        businessResultEntity.setChannelCode(appointmentRecordEntity.getChannelCode());
        businessResultEntity.setBusinessType(new Byte(BusinessTypeEnums.CANCEL_APPOINTMENT.getValue().toString()));
        businessResultEntity.setHisRequest(JSON.toJSONString((Object)gatewayRequest));
        this.businessResultMapper.insertSelective(businessResultEntity);
        GatewayResponse gatewayResponse = this.invokeHisCancelRegister(gatewayRequest, message);
        businessResultEntity.setErrorCode(gatewayResponse.getErrCode());
        businessResultEntity.setErrorMsg(gatewayResponse.getMsg());
        businessResultEntity.setHisResponse(JSON.toJSONString((Object)gatewayResponse));
        businessResultEntity.setTransationId(gatewayResponse.getTransactionId());
        businessResultEntity.setStatus(new Byte("0"));
        this.businessResultMapper.updateByPrimaryKeySelective(businessResultEntity);
        appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.CANCEL.getValue());
        appointmentRecordEntity.setCancleTime(new Date());
        appointmentRecordEntity.setCancleType(CancelTypeEnum.CHANNEL_CANCEL.getValue().intValue());
        appointmentRecordEntity.setCancleReason("\u7528\u6237\u53d6\u6d88");
        appointmentRecordEntity.setRemark("\u7528\u6237\u4e3b\u52a8\u53d6\u6d88");
        appointmentRecordEntity.setCancleChannelCode(cancelAppointmentVoReq.getChannelName());
        this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecordEntity);
        this.scheduleRecordMapper.updateByScheduleHisId(appointmentRecordEntity.getScheduleHisId());
        if (StringUtils.isNotEmpty((String)appointmentRecordEntity.getAdmTimeRange())) {
            this.scheduleDetailRecordMapper.updateByScheduleHisIdAndTime(appointmentRecordEntity.getScheduleHisId(), appointmentRecordEntity.getAdmTimeRange().substring(0, 5), appointmentRecordEntity.getHospitalCode());
        }
    }

    public BaseResponse<String> withdrawNumber(WithdrawNumberVoReq withdrawNumberVoReq) throws AppointmentException {
        AppointmentRecordEntity appointmentRecordEntity = this.appointmentRecordMapper.selectBySysAppointId(withdrawNumberVoReq.getSysAppointmentId());
        if (appointmentRecordEntity == null || appointmentRecordEntity.getAppointStatus() == null) {
            throw new AppointmentException("\u5f53\u524d\u6302\u53f7\u8bb0\u5f55\u67e5\u8be2\u4e3a\u7a7a\uff01");
        }
        if (null != appointmentRecordEntity.getPayChannel() && appointmentRecordEntity.getPayChannel().equals("YB")) {
            if (!DateUtils.isCancellationAllowed((Date)appointmentRecordEntity.getCreatetime(), (Date)new Date())) {
                throw new AppointmentException("\u533b\u4fdd\u9000\u53f7\u4e0d\u80fd\u8de8\u6708\uff0c\u8bf7\u524d\u5f80\u67dc\u53f0\u5904\u7406\uff01");
            }
            CancalConfirmatRes ybRefundRes = this.ybRefund(appointmentRecordEntity, withdrawNumberVoReq);
            if (null == ybRefundRes) {
                throw new AppointmentException("\u533b\u4fdd\u9000\u8d39\u5931\u8d25\uff01");
            }
        }
        GetRecipelReq getRecipelReq = new GetRecipelReq();
        getRecipelReq.setTransactionId(appointmentRecordEntity.getAdmId());
        GetPayRecordsResItems getPayRecordsResItems = this.getCompletedPayInfo(getRecipelReq, appointmentRecordEntity.getHosId());
        if (null == getPayRecordsResItems) {
            log.error("\u3010his\u67e5\u8be2\u5df2\u7f34\u8d39\u8bb0\u5f554905\u3011\u67e5\u8be2\u5931\u8d25\uff0c\u4ea4\u6613\u8ba2\u5355\u53f7\uff1a" + appointmentRecordEntity.getAdmId());
            throw new AppointmentException("\u5f53\u524d\u6302\u53f7\u8bb0\u5f55\u67e5\u8be2\u4e3a\u7a7a\uff01");
        }
        GatewayRequest gatewayRequest = this.buildWithdrawNumberGatewayReq(getPayRecordsResItems.getAdmId(), withdrawNumberVoReq.getChannelCode(), appointmentRecordEntity.getHosId());
        BusinessResultEntity businessResultEntity = new BusinessResultEntity();
        businessResultEntity.setChannelCode(appointmentRecordEntity.getChannelCode());
        businessResultEntity.setBusinessType(new Byte(BusinessTypeEnums.REFUND_WRITE.getValue().toString()));
        businessResultEntity.setHisRequest(JSON.toJSONString((Object)gatewayRequest));
        this.businessResultMapper.insertSelective(businessResultEntity);
        String message = "\u9000\u53f7 withdrawNumber";
        GatewayResponse gatewayResponse = this.returnRegister(gatewayRequest);
        businessResultEntity.setErrorCode(gatewayResponse.getErrCode());
        businessResultEntity.setErrorMsg(gatewayResponse.getMsg());
        businessResultEntity.setHisResponse(JSON.toJSONString((Object)gatewayResponse));
        businessResultEntity.setTransationId(gatewayResponse.getTransactionId());
        businessResultEntity.setStatus(new Byte("0"));
        this.businessResultMapper.updateByPrimaryKeySelective(businessResultEntity);
        appointmentRecordEntity.setAdmId(getPayRecordsResItems.getAdmId());
        appointmentRecordEntity.setReceptId(getPayRecordsResItems.getReceiptId());
        appointmentRecordEntity.setRemark("his\u9000\u53f7\u6210\u529f");
        this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecordEntity);
        ReturnRegisterRes returnRegisterRes = (ReturnRegisterRes)gatewayResponse.getData();
        String sysAppointmentId = appointmentRecordEntity.getSysAppointmentId();
        AppointmentPayorderEntity appointmentPayorderEntity = new AppointmentPayorderEntity();
        appointmentPayorderEntity.setSysAppointmentId(sysAppointmentId);
        appointmentPayorderEntity.setRefundStatus(Byte.valueOf((byte)RefundStatusEnum.REFUND_AND_CONFIRMATION.getValue().intValue()));
        appointmentPayorderEntity.setRefundChannelCode(Byte.valueOf((byte)RefundChannelCodeEnum.HIS_REFUND.getValue().intValue()));
        appointmentPayorderEntity.setRefundBillNo(returnRegisterRes.getHisTradeNo());
        log.info("\u3010\u9000\u53f7\u3011\u6210\u529f -> \u4fee\u6539\u6302\u53f7\u652f\u4ed8\u8ba2\u5355\u72b6\u6001 \uff1a" + JSON.toJSONString((Object)appointmentPayorderEntity));
        this.appointmentPayOrderMapper.updateRefundStatusBySysAppointmentId(appointmentPayorderEntity);
        appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.ALREADY_REFUND_CONFIRM.getValue());
        appointmentRecordEntity.setReturnAmount(new BigDecimal(returnRegisterRes.getReturnFee()));
        appointmentRecordEntity.setReturnTransationId(returnRegisterRes.getHisTradeNo());
        appointmentRecordEntity.setCancleTime(new Date());
        log.info("\u3010\u9000\u53f7\u3011\u6210\u529f -> \u4fee\u6539\u6302\u53f7\u8ba2\u5355\u72b6\u6001 \uff1a" + JSON.toJSONString((Object)appointmentRecordEntity));
        this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecordEntity);
        try {
            this.addSchduleCache(appointmentRecordEntity);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u9000\u53f7\u65f6\u66f4\u65b0\u6392\u73ed\u7f13\u5b58\u5931\u8d25\uff01");
        }
        return BaseResponse.success();
    }

    private CancalConfirmatRes ybRefund(AppointmentRecordEntity appointmentRecordEntity, WithdrawNumberVoReq withdrawNumberVoReq) {
        CancalConfirmatRes medicareAppointmentCancellationRes = new CancalConfirmatRes();
        String ybInfo = appointmentRecordEntity.getYbInfo();
        ConsultationHealtInuranceRes consultationHealtInuranceRes = (ConsultationHealtInuranceRes)JSONObject.parseObject((String)ybInfo, ConsultationHealtInuranceRes.class);
        try {
            FrontRequest param = new FrontRequest();
            OutpatientRegistratConfirmatReqVo medicareAppointmentCancellationReq = new OutpatientRegistratConfirmatReqVo();
            medicareAppointmentCancellationReq.setInsuDivId(consultationHealtInuranceRes.getInsuDivId());
            medicareAppointmentCancellationReq.setPayAuthNo(withdrawNumberVoReq.getPayAuthNo());
            medicareAppointmentCancellationReq.setIp("10.5.1.2");
            medicareAppointmentCancellationReq.setMac("7c:8a:e1:c7:ee:5f");
            medicareAppointmentCancellationReq.setOptertype("3");
            medicareAppointmentCancellationReq.setSgnType("1");
            param.setBody((Object)medicareAppointmentCancellationReq);
            param.setChannel(appointmentRecordEntity.getHosId());
            log.info("===\u533b\u4fdd\u6302\u53f7\u9000\u8d39===Req{}", (Object)JSON.toJSONString((Object)param));
            String body = HttpKit.jsonPost((String)(this.constant.getHisurl() + "/medicalinsurance/cancalConfirmat"), (String)JSON.toJSONString((Object)param));
            log.info("===\u533b\u4fdd\u6302\u53f7\u9000\u8d39===Res{}", (Object)JSON.toJSONString((Object)body));
            1 typeReference = new /* Unavailable Anonymous Inner Class!! */;
            FrontResponse response = (FrontResponse)JSONObject.parseObject((String)body, (Type)typeReference.getType(), (Feature[])new Feature[0]);
            if (!"1".equals(response.getCode()) || null == response.getBody()) {
                return null;
            }
            medicareAppointmentCancellationRes = (CancalConfirmatRes)response.getBody();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return medicareAppointmentCancellationRes;
    }

    private void addSchduleCache(AppointmentRecordEntity appointmentRecordEntity) {
        String key = "schduleCache|" + appointmentRecordEntity.getDeptCode() + "|" + appointmentRecordEntity.getAdmDate();
        List list = new ArrayList();
        String listStr = this.jedisCluster.get(key);
        if (StringUtils.isEmpty((String)listStr)) {
            return;
        }
        list = JSONObject.parseArray((String)listStr).toJavaList(GetScheduleVoRes.class);
        for (int i = 0; i < list.size(); ++i) {
            List scheduleBaseInfoVoList = ((GetScheduleVoRes)list.get(i)).getScheduleBaseInfoVoList();
            for (int j = 0; j < scheduleBaseInfoVoList.size(); ++j) {
                if (!((ScheduleBaseInfoVo)scheduleBaseInfoVoList.get(j)).getScheduleId().equals(appointmentRecordEntity.getScheduleHisId())) continue;
                ((ScheduleBaseInfoVo)scheduleBaseInfoVoList.get(j)).setRegAvailable(Integer.valueOf(((ScheduleBaseInfoVo)scheduleBaseInfoVoList.get(j)).getRegAvailable() - 1));
                log.info("\u9000\u53f7\u6210\u529f\u540e\u66f4\u65b0\u7f13\u5b58\u7684\u6392\u73ed\u4fe1\u606f+1\uff1a" + JSON.toJSONString(list));
                this.jedisCluster.set(key, JSONArray.toJSONString(list));
                return;
            }
        }
    }

    private GatewayResponse<ReturnRegisterRes> returnRegister(GatewayRequest<ReturnRegisterReq> gatewayRequest) throws AppointmentException {
        log.info("\u3010his\u9000\u53f7\u3011\u8bf7\u6c42\u53c2\u6570\uff1a" + gatewayRequest);
        GatewayResponse gatewayResponse = this.appointApi.returnRegister(gatewayRequest);
        if (gatewayResponse == null) {
            log.error("\u3010his\u9000\u53f7\u3011returnRegister -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            throw new AppointmentException("\u9000\u53f7\u5931\u8d25");
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u3010his\u9000\u53f7\u3011 returnRegister -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            throw new AppointmentException(gatewayResponse.getMsg());
        }
        if (gatewayResponse.getData() == null) {
            log.error("\u3010his\u9000\u53f7\u3011 returnRegister -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            throw new AppointmentException(gatewayResponse.getMsg());
        }
        log.info("\u3010his\u9000\u53f7\u3011\u8bf7\u6c42\u6210\u529f\uff0c\u8fd4\u56de\u53c2\u6570\uff1a" + gatewayResponse.getMsg());
        return gatewayResponse;
    }

    private BaseResponse<String> refund(RequestRefundOrderVoReq requestRefundOrderVoReq) {
        try {
            String body = HttpKit.jsonPost((String)this.propertiesConstant.getRefundUrl(), (String)JSON.toJSONString((Object)requestRefundOrderVoReq));
            BaseResponse response = (BaseResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)body), BaseResponse.class);
            return response;
        }
        catch (Exception e) {
            log.error("\u9000\u6b3e\u8bf7\u6c42\u5931\u8d25\uff0c\u539f\u56e0\u662f:{}", (Object)e.getMessage());
            return BaseResponse.error((String)e.getMessage());
        }
    }

    public BaseResponse confirmPay(String sysAppointmentId, String payChannel) throws AppointmentException {
        AppointmentRecordEntity appointmentRecordEntity = this.appointmentRecordMapper.selectBySysAppointId(sysAppointmentId);
        if (null == appointmentRecordEntity) {
            throw new AppointmentException("\u8ba2\u5355\u4e0d\u5b58\u5728\uff0csysAppointmentId\uff1a" + sysAppointmentId);
        }
        if (AppointmentStatusEnum.PAY.getValue().equals(appointmentRecordEntity.getAppointStatus())) {
            return BaseResponse.success();
        }
        appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.WAIT_HIS_CONFIRM.getValue());
        AppointmentPayorderEntity appointmentPayorderEntity = this.appointmentPayOrderMapper.getBySysAppointmentId(sysAppointmentId);
        if (null != appointmentPayorderEntity) {
            appointmentPayorderEntity.setOrderStatus(Byte.valueOf(Byte.parseByte("1")));
            log.info("\u3010\u6302\u53f7\u652f\u4ed8\u6210\u529f\u3011-> \u4fee\u6539\u6302\u53f7\u652f\u4ed8\u8ba2\u5355\u72b6\u6001\u4e3a\u652f\u4ed8\u6210\u529f\uff0c\u5f85\u786e\u8ba4\uff1a" + JSON.toJSONString((Object)appointmentPayorderEntity));
            this.appointmentPayOrderMapper.updateByPrimaryKeySelective(appointmentPayorderEntity);
        }
        log.info("\u3010\u6302\u53f7\u652f\u4ed8\u6210\u529f\u3011-> \u4fee\u6539\u6302\u53f7\u8ba2\u5355\u72b6\u6001\u4e3a\u652f\u4ed8\u6210\u529f\uff0c\u5f85his\u786e\u8ba4\uff1a" + JSON.toJSONString((Object)appointmentRecordEntity));
        this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecordEntity);
        return BaseResponse.success();
    }

    public String payAppointmentPayToHis(AppointmentRecordEntity appointmentRecordEntity, ResponseNotifyRestVo responseNotifyRestVo, AppointmentPayorderEntity payOrderEntity) throws AppointmentException {
        GatewayRequest gatewayRequest = this.buildPayRegistrationReq(appointmentRecordEntity, responseNotifyRestVo);
        BusinessResultEntity businessResultEntity = new BusinessResultEntity();
        businessResultEntity.setChannelCode(appointmentRecordEntity.getChannelCode());
        businessResultEntity.setBusinessType(new Byte(BusinessTypeEnums.PAI_CONFIRM.getValue().toString()));
        businessResultEntity.setHisRequest(JSON.toJSONString((Object)gatewayRequest));
        this.businessResultMapper.insertSelective(businessResultEntity);
        log.info("\u9884\u7ea6\u6302\u53f7\u652f\u4ed8his\u786e\u8ba4 \u5165\u53c2 PayRegistrationReq{}", gatewayRequest.getBody());
        GatewayResponse gatewayResponse = this.appointApi.payRegistration(gatewayRequest);
        businessResultEntity.setErrorCode(gatewayResponse.getErrCode());
        businessResultEntity.setErrorMsg(gatewayResponse.getMsg());
        businessResultEntity.setHisResponse(JSON.toJSONString((Object)gatewayResponse));
        businessResultEntity.setTransationId(gatewayResponse.getTransactionId());
        businessResultEntity.setStatus(new Byte("0"));
        this.businessResultMapper.updateByPrimaryKeySelective(businessResultEntity);
        log.info("\u9884\u7ea6\u6302\u53f7\u652f\u4ed8his\u786e\u8ba4 \u51fa\u53c2 PayRegistrationRes{}", (Object)JSON.toJSONString((Object)gatewayResponse));
        RequestRefundOrderVoReq requestRefundOrderVoReq = new RequestRefundOrderVoReq();
        requestRefundOrderVoReq.setPayChannel(appointmentRecordEntity.getPayChannelCode());
        requestRefundOrderVoReq.setMchCode(this.propertiesConstant.getMchCode());
        requestRefundOrderVoReq.setOutTradeNo(appointmentRecordEntity.getSysAppointmentId());
        requestRefundOrderVoReq.setDealTradeNo(responseNotifyRestVo.getDealTradeNo());
        requestRefundOrderVoReq.setTotalAmount(new BigDecimal("0.01"));
        requestRefundOrderVoReq.setRefundAmount(new BigDecimal("0.01"));
        log.info("\u9884\u7ea6\u6302\u53f7\u81ea\u52a8\u9000\u6b3e\u8bf7\u6c42\u53c2\u6570\u4e3a:{}", (Object)JSON.toJSONString((Object)requestRefundOrderVoReq));
        if (gatewayResponse == null) {
            BaseResponse baseResponse = this.refund(requestRefundOrderVoReq);
            if ("1".equals(baseResponse.getCode())) {
                appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.LAUNCH_AUTO_REFUND.getValue());
                appointmentRecordEntity.setRemark("\u8bf7\u6c42his\u4e0d\u901a,\u9000\u6b3e");
            } else {
                appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.LAUNCH_AUTO_REFUND_FAIL.getValue());
                appointmentRecordEntity.setRemark("\u8bf7\u6c42his\u4e0d\u901a\uff0c\u9000\u6b3e" + AppointmentStatusEnum.LAUNCH_AUTO_REFUND_FAIL.getDisplay());
            }
            this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecordEntity);
            log.error("\u9884\u7ea6\u6302\u53f7\u652f\u4ed8his\u786e\u8ba4 PayRegistrationRes -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            throw new AppointmentException(gatewayResponse.getMsg());
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            BaseResponse baseResponse = this.refund(requestRefundOrderVoReq);
            if ("1".equals(baseResponse.getCode())) {
                appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.LAUNCH_AUTO_REFUND.getValue());
                appointmentRecordEntity.setRemark(gatewayResponse.getMsg());
            } else {
                appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.LAUNCH_AUTO_REFUND_FAIL.getValue());
                appointmentRecordEntity.setRemark(gatewayResponse.getMsg() + AppointmentStatusEnum.LAUNCH_AUTO_REFUND_FAIL.getDisplay());
            }
            this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecordEntity);
            log.error("\u9884\u7ea6\u6302\u53f7\u652f\u4ed8his\u786e\u8ba4 PayRegistrationRes -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            throw new AppointmentException(gatewayResponse.getMsg());
        }
        PayRegistrationRes payRegistrationRes = (PayRegistrationRes)gatewayResponse.getData();
        UpdatePayAppointmentRecordVoReq updatePayAppointment = new UpdatePayAppointmentRecordVoReq();
        updatePayAppointment.setPayAccdate(DateUtils.dateToString((Date)responseNotifyRestVo.getPayTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        updatePayAppointment.setPayPostId(responseNotifyRestVo.getMchId());
        updatePayAppointment.setPayTransationId(responseNotifyRestVo.getTradeNo());
        updatePayAppointment.setPayChannel(PayChannelEnum.getDisplay((String)responseNotifyRestVo.getPayChannel()));
        updatePayAppointment.setAppointNo(payRegistrationRes.getNo());
        updatePayAppointment.setAdmAdress(payRegistrationRes.getAdmitAddress());
        if (null != payRegistrationRes) {
            updatePayAppointment.setAdmId(payRegistrationRes.getAdmId());
        }
        updatePayAppointment.setAppointStatus(AppointmentStatusEnum.PAY.getValue());
        updatePayAppointment.setSysAppointmentId(appointmentRecordEntity.getSysAppointmentId());
        if (null != payRegistrationRes) {
            updatePayAppointment.setReceptId(payRegistrationRes.getReceiptId());
        }
        updatePayAppointment.setPayChannelCode(responseNotifyRestVo.getPayChannel());
        updatePayAppointment.setRemark("\u652f\u4ed8\u6210\u529f\uff0chis\u9884\u7ea6\u6302\u53f7\u786e\u8ba4\u6210\u529f");
        this.updatePayAppointmentRecord(updatePayAppointment);
        payOrderEntity.setUserId(appointmentRecordEntity.getUserId());
        payOrderEntity.setHospitalCode(appointmentRecordEntity.getHospitalCode());
        payOrderEntity.setChannelCode(appointmentRecordEntity.getChannelCode());
        payOrderEntity.setPatientId(appointmentRecordEntity.getPatientId());
        payOrderEntity.setPaymentSeq(appointmentRecordEntity.getPayChannelCode());
        this.appointmentPayOrderMapper.updateByPrimaryKey(payOrderEntity);
        return appointmentRecordEntity.getSysAppointmentId();
    }

    private GatewayResponse<CancelRegisterRes> invokeHisCancelLockOrder(GatewayRequest<ReturnRegisterReq> gatewayRequest, String message) throws AppointmentException {
        GatewayResponse gatewayResponse = this.appointApi.cancelAppoint(gatewayRequest);
        if (gatewayResponse == null) {
            log.error(message + "-> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            throw new AppointmentException(gatewayResponse.getMsg());
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error(message + " -> his\u53d6\u6d88\u9884\u7ea6\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            throw new AppointmentException(gatewayResponse.getMsg());
        }
        if (gatewayResponse.getData() == null) {
            log.error(message + " -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            throw new AppointmentException(gatewayResponse.getMsg());
        }
        return gatewayResponse;
    }

    private GatewayResponse<CancelRegisterRes> invokeHisCancelRegister(GatewayRequest<CancelRegisterReq> gatewayRequest, String message) throws AppointmentException {
        GatewayResponse gatewayResponse = this.appointApi.cancelRegister(gatewayRequest);
        if (gatewayResponse == null) {
            log.error(message + "-> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            throw new AppointmentException(gatewayResponse.getMsg());
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error(message + " -> his\u53d6\u6d88\u9501\u53f7\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            throw new AppointmentException(gatewayResponse.getMsg());
        }
        return gatewayResponse;
    }

    private GatewayRequest<ReturnRegisterReq> buildCancelRegisterGatewayReq(CancelAppointmentVoReq cancelAppointmentVoReq, AppointmentRecordEntity appointmentRecordEntity) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        ReturnRegisterReq returnRegisterReq = new ReturnRegisterReq();
        returnRegisterReq.setAppointId(appointmentRecordEntity.getAdmId());
        gatewayRequest.setBody((Object)returnRegisterReq);
        gatewayRequest.setChannelName(cancelAppointmentVoReq.getChannelName());
        gatewayRequest.setChannel(appointmentRecordEntity.getHosId());
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("cancelAppoint");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    private GatewayRequest<CancelRegisterReq> buildCancelRegisterGatewayReq(CancelAppointmentVoReq cancelAppointmentVoReq, String appointmentId, String hosId) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        CancelRegisterReq cancelRegisterReq = new CancelRegisterReq();
        cancelRegisterReq.setAppointId(appointmentId);
        gatewayRequest.setBody((Object)cancelRegisterReq);
        gatewayRequest.setChannelName(cancelAppointmentVoReq.getChannelName());
        gatewayRequest.setChannel(hosId);
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("cancelRegister");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    private GatewayRequest<ReturnRegisterReq> buildWithdrawNumberGatewayReq(String appointmentId, String channel, String hosId) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        ReturnRegisterReq returnRegisterReq = new ReturnRegisterReq();
        returnRegisterReq.setAppointId(appointmentId);
        gatewayRequest.setBody((Object)returnRegisterReq);
        gatewayRequest.setChannelName(channel);
        gatewayRequest.setChannel(hosId);
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("returnRegisterReq");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    public String appointmentCreateOrder(AppointmentCreateOrderVoReq createOrderVoReq) throws AppointmentException {
        log.info("[appointmentCreateOrder]\u9884\u7ea6\u8bf7\u6c42\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)createOrderVoReq));
        if (LocalDate.now().toString().equals(createOrderVoReq.getAdmDate())) {
            throw new AppointmentException("\u5f53\u65e5\u53f7\u6e90\u6682\u4e0d\u652f\u6301\u9884\u7ea6\uff0c\u8bf7\u60a8\u5230\u7ebf\u4e0b\u81ea\u52a9\u673a\u6216\u7a97\u53e3\u5b8c\u6210\u6302\u53f7");
        }
        long sysAppointmnetId = this.snowflakeIdWorker.nextId();
        this.checkAppointmentInfo(createOrderVoReq);
        String hosId = this.getHosId(createOrderVoReq.getDeptCode());
        GetScheduleResItems getScheduleResItems = this.isHasAppointmentInfo(createOrderVoReq, hosId);
        if (null == getScheduleResItems) {
            throw new AppointmentException("\u6b64\u53f7\u6bb5\u5df2\u88ab\u5360\u7528\uff0c\u8bf7\u91cd\u65b0\u9009\u7528\u53ef\u7528\u53f7\u6bb5\uff01");
        }
        CardDetailsInfoRespVO cardDetail = this.getCardDetail(createOrderVoReq.getCardId());
        if (null == cardDetail) {
            throw new AppointmentException("\u5361\u4fe1\u606f\u6709\u8bef\uff0c\u9884\u7ea6\u5931\u8d25\uff01");
        }
        GatewayRequest gatewayRequest = this.buildConfirmRegisterReq(createOrderVoReq, hosId);
        BusinessResultEntity businessResultEntity = new BusinessResultEntity();
        businessResultEntity.setChannelCode(createOrderVoReq.getChannelName());
        businessResultEntity.setBusinessType(new Byte(BusinessTypeEnums.APPOINTMENT.getValue().toString()));
        businessResultEntity.setHisRequest(JSON.toJSONString((Object)gatewayRequest));
        this.businessResultMapper.insertSelective(businessResultEntity);
        GatewayResponse gatewayResponse = this.appointApi.appoint(gatewayRequest);
        businessResultEntity.setErrorCode(gatewayResponse.getErrCode());
        businessResultEntity.setErrorMsg(gatewayResponse.getMsg());
        businessResultEntity.setHisResponse(JSON.toJSONString((Object)gatewayResponse));
        businessResultEntity.setTransationId(gatewayResponse.getTransactionId());
        businessResultEntity.setStatus(new Byte("0"));
        this.businessResultMapper.updateByPrimaryKeySelective(businessResultEntity);
        if (gatewayResponse == null) {
            log.error("\u9884\u7ea6 confirmRegister -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            throw new AppointmentException(gatewayResponse.getMsg());
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u9884\u7ea6 confirmRegister -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            throw new AppointmentException(gatewayResponse.getMsg());
        }
        if (gatewayResponse.getData() == null) {
            log.error("\u9884\u7ea6 confirmRegister -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            throw new AppointmentException(gatewayResponse.getMsg());
        }
        ConfirmRegisterRes confirmRegisterRes = (ConfirmRegisterRes)gatewayResponse.getData();
        AppointmentRecordEntity appointmentRecordEntity = this.buildSuccessAppointmentRecordEntity(sysAppointmnetId, confirmRegisterRes, createOrderVoReq, getScheduleResItems, cardDetail, (ConfirmRegisterReq)gatewayRequest.getBody(), hosId);
        this.appointmentRecordMapper.insertSelective(appointmentRecordEntity);
        this.scheduleRecordMapper.updateByhospitalCodeAndscheduleHisId(appointmentRecordEntity.getHospitalCode(), appointmentRecordEntity.getScheduleHisId());
        if (null != appointmentRecordEntity.getAdmTimeRange() && !"".equals(appointmentRecordEntity.getAdmTimeRange())) {
            this.scheduleDetailRecordMapper.updateByScheduleHisIdAndStartTime(appointmentRecordEntity.getScheduleHisId(), appointmentRecordEntity.getHospitalCode(), appointmentRecordEntity.getAdmTimeRange().substring(0, 5));
        }
        if (null != createOrderVoReq.getPlatform() && createOrderVoReq.getPlatform().equals("BD")) {
            this.taskExecutor.execute(() -> {
                PushOrderInfoReqVo pushOrderInfoReqVo = this.buildBdPushOrderInfoReq(createOrderVoReq, appointmentRecordEntity, cardDetail);
                this.specializDiseaseService.pushOrderInfo(pushOrderInfoReqVo);
                OrderCenterPushReqVo orderCenterPushReqVo = this.buildBdorderCenterPushReq(createOrderVoReq, appointmentRecordEntity, pushOrderInfoReqVo);
                this.specializDiseaseService.orderSend(orderCenterPushReqVo);
                String msg = "\u60a8\u5df2\u9884\u7ea6\u6210\u529f\uff0c\u8bf7\u6309\u65f6\u524d\u5f80\u533b\u9662\u81ea\u52a9\u673a\u6216\u7a97\u53e3\u7f34\u8d39\u53d6\u53f7,\u903e\u671f\u534a\u5c0f\u65f6\u81ea\u52a8\u53d6\u6d88";
                String templateId = "3cb862de03a24260968741b19a2337ca";
                MessageSendReqVo messageSendReqVo = this.buildBdMessageSendReq(createOrderVoReq, appointmentRecordEntity, msg, templateId);
                this.specializDiseaseService.messageSend(messageSendReqVo);
            });
        }
        this.taskExecutor.execute(() -> this.pushService.appointmentSuccessMsgPush(appointmentRecordEntity));
        return appointmentRecordEntity.getSysAppointmentId();
    }

    private OrderCenterPushReqVo buildBdorderCenterPushReq(AppointmentCreateOrderVoReq createOrderVoReq, AppointmentRecordEntity appointmentRecordEntity, PushOrderInfoReqVo pushOrderInfoReqVo) {
        ArrayList Data = new ArrayList();
        ArrayList<String> imgList = new ArrayList<String>();
        imgList.add("https://cdn.chinachdu.com/webStatic/wechat-applets/ndefy/baidu-order.jpg");
        ProductsDTO productsDTO = new ProductsDTO();
        DetailPageDTO detailPage = new DetailPageDTO();
        detailPage.setSwanSchema("baiduboxapp://swan/" + this.propertiesConstant.getBaiduAppKey() + "/wisdomTreatment/pages/registerOrderDetail/registerOrderDetail?ids=" + appointmentRecordEntity.getSysAppointmentId());
        productsDTO.setID(appointmentRecordEntity.getAppointmentId());
        productsDTO.setDesc("\u6302\u53f7\u9884\u7ea6");
        productsDTO.setName(appointmentRecordEntity.getDocName() + " " + appointmentRecordEntity.getDeptName() + " \u9884\u7ea6");
        productsDTO.setImgList(imgList);
        productsDTO.setDetailPage(detailPage);
        ArrayList<ProductsDTO> Products = new ArrayList<ProductsDTO>();
        Products.add(productsDTO);
        PaymentDTO payment = new PaymentDTO();
        AppraiseDTO appraise = new AppraiseDTO();
        OrderDetailDTO orderDetail = new OrderDetailDTO();
        orderDetail.setSwanSchema("baiduboxapp://swan/" + this.propertiesConstant.getBaiduAppKey() + "/wisdomTreatment/pages/registerOrderDetail/registerOrderDetail?ids=" + appointmentRecordEntity.getSysAppointmentId());
        MainOrderDTO mainOrder = new MainOrderDTO();
        mainOrder.setProducts(Products);
        mainOrder.setPayment(payment);
        mainOrder.setAppraise(appraise);
        mainOrder.setOrderDetail(orderDetail);
        EXTDTO eXT = new EXTDTO();
        eXT.setMainOrder(mainOrder);
        OrderCenterPushDataDTO orderCenterPushDataDTO = new OrderCenterPushDataDTO();
        orderCenterPushDataDTO.setResourceID(appointmentRecordEntity.getSysAppointmentId());
        orderCenterPushDataDTO.setBizAPPID(this.propertiesConstant.getBaiduAppKey());
        orderCenterPushDataDTO.setStatus(Integer.valueOf(200));
        orderCenterPushDataDTO.setCtime(((OrderInfoList)pushOrderInfoReqVo.getOrderInfoList().get(0)).getCreate_time());
        orderCenterPushDataDTO.setMtime(((OrderInfoList)pushOrderInfoReqVo.getOrderInfoList().get(0)).getCreate_time());
        orderCenterPushDataDTO.setTitle(appointmentRecordEntity.getDocName() + " " + appointmentRecordEntity.getDeptName() + " \u9884\u7ea6");
        orderCenterPushDataDTO.setEXT(eXT);
        OrderCenterPushReqVo OrderCenterPushReqVo2 = new OrderCenterPushReqVo();
        ArrayList<OrderCenterPushDataDTO> datalist = new ArrayList<OrderCenterPushDataDTO>();
        datalist.add(orderCenterPushDataDTO);
        OrderCenterPushReqVo2.setData(datalist);
        OrderCenterPushReqVo2.setOpenId(createOrderVoReq.getOpenId());
        return OrderCenterPushReqVo2;
    }

    private MessageSendReqVo buildBdMessageSendReq(AppointmentCreateOrderVoReq createOrderVoReq, AppointmentRecordEntity appointmentRecordEntity, String msg, String templateId) {
        MessageSendReqVo messageSendReqVo = new MessageSendReqVo();
        messageSendReqVo.setTemplate_id(templateId);
        messageSendReqVo.setSubscribe_id(createOrderVoReq.getSubscribeId());
        messageSendReqVo.setTouser_openId(createOrderVoReq.getOpenId());
        messageSendReqVo.setPage("wisdomTreatment/pages/registerOrderDetail/registerOrderDetail?ids=" + appointmentRecordEntity.getSysAppointmentId());
        HashMap<String, ValueData> map = new HashMap<String, ValueData>();
        ValueData valueData1 = new ValueData();
        valueData1.setValue(appointmentRecordEntity.getPatientName());
        map.put("keyword1", valueData1);
        ValueData valueData2 = new ValueData();
        valueData2.setValue("\u5357\u660c\u5927\u5b66\u7b2c\u4e8c\u9644\u5c5e\u533b\u9662");
        map.put("keyword2", valueData2);
        ValueData valueData3 = new ValueData();
        valueData3.setValue(appointmentRecordEntity.getDeptName());
        map.put("keyword3", valueData3);
        ValueData valueData4 = new ValueData();
        valueData4.setValue(appointmentRecordEntity.getDocName());
        map.put("keyword4", valueData4);
        ValueData valueData5 = new ValueData();
        valueData5.setValue(appointmentRecordEntity.getAdmDate());
        if (null != appointmentRecordEntity.getAdmTimeRange()) {
            valueData5.setValue(appointmentRecordEntity.getAdmDate() + " " + appointmentRecordEntity.getAdmTimeRange());
        }
        map.put("keyword5", valueData5);
        ValueData valueData6 = new ValueData();
        valueData6.setValue(appointmentRecordEntity.getAppointmentId());
        map.put("keyword6", valueData6);
        ValueData valueData7 = new ValueData();
        valueData7.setValue(msg);
        map.put("keyword7", valueData7);
        messageSendReqVo.setData(JSONObject.toJSONString(map));
        return messageSendReqVo;
    }

    private PushOrderInfoReqVo buildBdPushOrderInfoReq(AppointmentCreateOrderVoReq createOrderVoReq, AppointmentRecordEntity appointmentRecordEntity, CardDetailsInfoRespVO cardDetail) {
        try {
            PushOrderInfoReqVo pushOrderInfoReqVo = new PushOrderInfoReqVo();
            pushOrderInfoReqVo.setTimes(Integer.valueOf(1));
            ArrayList<OrderInfoList> orderInfoList = new ArrayList<OrderInfoList>();
            OrderInfoList bdorderInfoList = new OrderInfoList();
            bdorderInfoList.setOrder_id(appointmentRecordEntity.getSysAppointmentId());
            bdorderInfoList.setSwan_id(createOrderVoReq.getSwan_id());
            bdorderInfoList.setDoc_id(appointmentRecordEntity.getDocCode());
            bdorderInfoList.setDoc_name(appointmentRecordEntity.getDocName());
            bdorderInfoList.setSex(Integer.valueOf(appointmentRecordEntity.getPatientSex() == 1 ? 2 : 1));
            bdorderInfoList.setBirthday(cardDetail.getCredNo().substring(6, 14));
            bdorderInfoList.setTotal_real_price(Integer.valueOf(AppointmentServiceImpl.formatAmtY2F((String)appointmentRecordEntity.getPayAmount())));
            bdorderInfoList.setDept_name(appointmentRecordEntity.getDeptName());
            bdorderInfoList.setDep_code(appointmentRecordEntity.getDeptCode());
            bdorderInfoList.setPatient_name(AppointmentServiceImpl.nameEncrypt((String)appointmentRecordEntity.getPatientName()));
            bdorderInfoList.setOrder_status(Integer.valueOf(4));
            String res = HttpKit.sendGet((String)(this.propertiesConstant.getGetEmpowerTime() + "?swanId=" + createOrderVoReq.getSwan_id()));
            JSONObject jsonObject = JSONObject.parseObject((String)res);
            String data = jsonObject.getString("data");
            OneJoinResDTO oneJoinResDTO = (OneJoinResDTO)JSONObject.parseObject((String)data, OneJoinResDTO.class);
            Date createTime = oneJoinResDTO.getCreateTime();
            bdorderInfoList.setFirst_entry_time(Integer.valueOf((int)(createTime.getTime() / 1000L)));
            bdorderInfoList.setCreate_time(Integer.valueOf((int)(System.currentTimeMillis() / 1000L)));
            bdorderInfoList.setSource(createOrderVoReq.getSource());
            bdorderInfoList.setRegister_time(appointmentRecordEntity.getAdmDate());
            if (null != appointmentRecordEntity.getAdmTimeRange()) {
                bdorderInfoList.setRegister_time(appointmentRecordEntity.getAdmDate() + " " + appointmentRecordEntity.getAdmTimeRange().replace("-", "~"));
            }
            bdorderInfoList.setJump_url("wisdomTreatment/pages/registerOrderDetail/registerOrderDetail?ids=" + appointmentRecordEntity.getSysAppointmentId());
            bdorderInfoList.setHospital_card(appointmentRecordEntity.getPatientCardNo());
            bdorderInfoList.setIdcard(IDCardUtils.generateEncryptedID((String)cardDetail.getCredNo()));
            bdorderInfoList.setDisease_code(createOrderVoReq.getDiseaseCode());
            StatisticsInfo statistics = new StatisticsInfo();
            if (null != createOrderVoReq.getStatistics() && !createOrderVoReq.getStatistics().equals("")) {
                statistics = (StatisticsInfo)JSONObject.parseObject((String)createOrderVoReq.getStatistics(), StatisticsInfo.class);
            }
            statistics.setGh_doctor_name(appointmentRecordEntity.getDocName());
            statistics.setGh_title(appointmentRecordEntity.getRegTitleName());
            statistics.setGh_depart_code(appointmentRecordEntity.getDeptCode());
            statistics.setGh_depart_name(appointmentRecordEntity.getDeptName());
            statistics.setGh_clinic_type(appointmentRecordEntity.getScheduleLevelName().contains("\u666e\u901a") ? "\u666e\u901a\u95e8\u8bca" : "\u4e13\u5bb6\u95e8\u8bca");
            statistics.setOpenId(createOrderVoReq.getOpenId());
            statistics.setProvince(IdcardUtil.getProvinceByIdCard((String)cardDetail.getCredNo()));
            statistics.setCity(IdcardUtil.getCityCodeByIdCard((String)cardDetail.getCredNo()));
            statistics.setPageSource(createOrderVoReq.getPageSource());
            statistics.setSourceDoctorHome(createOrderVoReq.getSourceDoctorHome());
            bdorderInfoList.setStatistics(statistics);
            orderInfoList.add(bdorderInfoList);
            pushOrderInfoReqVo.setOrderInfoList(orderInfoList);
            return pushOrderInfoReqVo;
        }
        catch (Exception e) {
            log.info("==BAIDU==Exception====" + e.getMessage());
            return null;
        }
    }

    public static String nameEncrypt(String name) {
        if (StringUtils.isEmpty((String)name)) {
            return name;
        }
        return name.replaceAll("(?<=.{1}).", "*");
    }

    public static String formatAmtY2F(String amtY) {
        if (amtY == null || "".equals(amtY.trim()) || "0".equals(amtY)) {
            return "0";
        }
        if (amtY.indexOf(",") != -1) {
            amtY = amtY.replace(",", "");
        }
        amtY = new DecimalFormat("0.00").format(new BigDecimal(amtY));
        int index = amtY.indexOf(".");
        int len = amtY.length();
        StringBuffer amtF = new StringBuffer();
        if (index == -1) {
            amtF.append(amtY).append("00");
        } else if (len - index == 1) {
            amtF.append(Long.parseLong(amtY.replace(".", ""))).append("00");
        } else if (len - index == 2) {
            amtF.append(Long.parseLong(amtY.replace(".", ""))).append("0");
        } else {
            amtF.append(Long.parseLong(amtY.replace(".", "")));
        }
        return amtF.toString();
    }

    private void checkAppointmentInfo(AppointmentCreateOrderVoReq createOrderVoReq) throws AppointmentException {
        Integer appointmentCount = this.appointmentRecordMapper.selectPatientCurrentDateSameDeptValidAppointmentCount(createOrderVoReq.getHospitalCode(), createOrderVoReq.getPatientId(), createOrderVoReq.getDeptCode(), String.valueOf(LocalDate.now()));
        if (appointmentCount >= 1) {
            throw new AppointmentException("\u65e0\u6cd5\u9884\u7ea6, \u8be5\u5c31\u8bca\u4eba\u540c\u4e00\u79d1\u5ba4\u533b\u751f\u53ea\u80fd\u9884\u7ea6\u4e00\u4e2a");
        }
        Integer totalAppointmentCount = this.appointmentRecordMapper.selectPatientCurrentDateValidAppointCount(createOrderVoReq.getHospitalCode(), createOrderVoReq.getPatientId(), String.valueOf(LocalDate.now()));
        if (totalAppointmentCount >= 2) {
            throw new AppointmentException("\u65e0\u6cd5\u9884\u7ea6, \u8be5\u5c31\u8bca\u4eba\u4eca\u65e5\u9884\u7ea6\u6b21\u6570\u5df2\u8fbe\u4e0a\u9650(2\u6b21\u5305\u542b\u53d6\u6d88)");
        }
    }

    private GetScheduleResItems isHasAppointmentInfo(AppointmentCreateOrderVoReq appointmentCreateOrderVoReq, String hosId) throws AppointmentException {
        GatewayRequest gatewayRequest = this.buildScheduleGetwayRequest(appointmentCreateOrderVoReq, hosId);
        GatewayResponse gatewayResponse = this.scheduleApi.getDoctorSchedule(gatewayRequest);
        if (gatewayResponse == null) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            throw new AppointmentException(gatewayResponse.getMsg());
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            throw new AppointmentException(gatewayResponse.getMsg());
        }
        if (gatewayResponse.getData() == null) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            throw new AppointmentException(gatewayResponse.getMsg());
        }
        GetScheduleResVO getScheduleResVO = (GetScheduleResVO)gatewayResponse.getData();
        if (getScheduleResVO.getItems() == null || getScheduleResVO.getItems().isEmpty()) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u65e0\u6392\u73ed\u4fe1\u606f");
            throw new AppointmentException("\u6682\u65e0\u6392\u73ed\u4fe1\u606f");
        }
        List scheduleResItemsList = getScheduleResVO.getItems();
        log.info("\u9884\u7ea6\u6302\u53f7\u521b\u5efa\u8ba2\u5355 \u67e5\u8be2\u53f7\u6e90\u662f\u5426\u5b58\u5728\u8fc7\u6ee4\u524d\u533b\u751f\u6392\u73ed\uff1a" + scheduleResItemsList);
        scheduleResItemsList = scheduleResItemsList.stream().filter(getScheduleResItems -> getScheduleResItems.getAdmTimeRange().equals(appointmentCreateOrderVoReq.getAdmTimeRange())).collect(Collectors.toList());
        log.info("\u9884\u7ea6\u6302\u53f7\u521b\u5efa\u8ba2\u5355 \u67e5\u8be2\u53f7\u6e90\u662f\u5426\u5b58\u5728\u6839\u636e\u5348\u522b\u8fc7\u6ee4\u51fa\u8be5\u533b\u751f\u6392\u73ed\uff1a" + scheduleResItemsList);
        for (GetScheduleResItems getScheduleResItems2 : scheduleResItemsList) {
            if (!appointmentCreateOrderVoReq.getScheduleHisId().equals(getScheduleResItems2.getScheduleId())) continue;
            return getScheduleResItems2;
        }
        return null;
    }

    private GatewayRequest<GetScheduleReqVO> buildScheduleGetwayRequest(AppointmentCreateOrderVoReq appointmentCreateOrderVoReq, String hosId) {
        GatewayRequest gatewayReq = new GatewayRequest();
        GetScheduleReqVO getScheduleReqVO = new GetScheduleReqVO();
        getScheduleReqVO.setBgDate(appointmentCreateOrderVoReq.getAdmDate());
        getScheduleReqVO.setEdDate(appointmentCreateOrderVoReq.getAdmDate());
        getScheduleReqVO.setLocCode(appointmentCreateOrderVoReq.getDeptCode());
        getScheduleReqVO.setDocCode(appointmentCreateOrderVoReq.getDocCode());
        getScheduleReqVO.setScheduleCode(hosId);
        gatewayReq.setBody((Object)getScheduleReqVO);
        gatewayReq.setChannelName(appointmentCreateOrderVoReq.getChannelName());
        gatewayReq.setChannel(appointmentCreateOrderVoReq.getChannelName());
        gatewayReq.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayReq.setKeyWord("appointmentCreateOrder");
        gatewayReq.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayReq;
    }

    private GatewayRequest<ConfirmRegisterReq> buildConfirmRegisterReq(AppointmentCreateOrderVoReq appointmentCreateOrderVoReq, String hosId) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        ConfirmRegisterReq confirmRegisterReq = new ConfirmRegisterReq();
        confirmRegisterReq.setCardNo(appointmentCreateOrderVoReq.getPatientCardNo());
        confirmRegisterReq.setRbasId(appointmentCreateOrderVoReq.getScheduleHisId());
        confirmRegisterReq.setTimeArrangeId(appointmentCreateOrderVoReq.getTimeArrangeId());
        gatewayRequest.setBody((Object)confirmRegisterReq);
        gatewayRequest.setChannelName(appointmentCreateOrderVoReq.getChannelName());
        gatewayRequest.setChannel(hosId);
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("appointmentCreateOrder");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    private GatewayRequest<LockOrderReq> buildLockOrderReq(long sysAppointmentId, DayAppointmentCreateOrderVoReq createOrderVoReq, QueryCardInfoResVO queryCardInfoResVO, String hosId) throws AppointmentException {
        GatewayRequest gatewayRequest = new GatewayRequest();
        LockOrderReq lockOrderReq = new LockOrderReq();
        lockOrderReq.setCardNo(queryCardInfoResVO.getCardNo());
        lockOrderReq.setPatientId(queryCardInfoResVO.getPatientId());
        lockOrderReq.setScheduleCode(createOrderVoReq.getScheduleHisId());
        lockOrderReq.setBeginTime(createOrderVoReq.getBeginTime());
        lockOrderReq.setEndTime(createOrderVoReq.getEndTime());
        lockOrderReq.setTradeDate(DateUtils.getCurrentDate((String)"yyyy-MM-dd"));
        lockOrderReq.setTradeTime(DateUtils.getCurrentDate((String)"HH:mm:ss"));
        gatewayRequest.setBody((Object)lockOrderReq);
        gatewayRequest.setChannelName(createOrderVoReq.getChannelName());
        gatewayRequest.setChannel(hosId);
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("lockOrderReq");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    private AppointmentRecordEntity buildSuccessAppointmentRecordEntity(long sysAppointmentId, ConfirmRegisterRes confirmRegisterRes, AppointmentCreateOrderVoReq createOrderVoReq, GetScheduleResItems getScheduleResItems, CardDetailsInfoRespVO cardDetailsInfoRespVO, ConfirmRegisterReq reqData, String hosId) {
        AppointmentRecordEntity appointmentRecordEntity = new AppointmentRecordEntity();
        appointmentRecordEntity.setHosId(hosId);
        appointmentRecordEntity.setCredSign(IDCardUtils.generateEncryptedID((String)cardDetailsInfoRespVO.getCredNo()));
        appointmentRecordEntity.setPlatform(createOrderVoReq.getPlatform());
        appointmentRecordEntity.setScheduleType(createOrderVoReq.getAdmTimeRange());
        appointmentRecordEntity.setAppointmentId(confirmRegisterRes.getAppointId());
        appointmentRecordEntity.setAdmId(confirmRegisterRes.getAppointId());
        appointmentRecordEntity.setAdmAddress(confirmRegisterRes.getTakeAddress());
        if (getScheduleResItems.getRegTitleName().equals("\u7279\u9700\u95e8\u8bca\u53f7")) {
            appointmentRecordEntity.setAdmAddress(getScheduleResItems.getAdmLocation());
        }
        appointmentRecordEntity.setTakeAddress(confirmRegisterRes.getTakeAddress());
        appointmentRecordEntity.setTakeTime(confirmRegisterRes.getAdmitTimeRange());
        appointmentRecordEntity.setAdmTimeRange(createOrderVoReq.getAdmTime());
        if (!ObjectUtils.isEmpty((Object)reqData.getTimeArrangeId())) {
            appointmentRecordEntity.setAppointmentNo(createOrderVoReq.getTimeArrangeId());
        }
        appointmentRecordEntity.setAdmDate(createOrderVoReq.getAdmDate());
        appointmentRecordEntity.setAdmRange(Integer.parseInt(createOrderVoReq.getAdmTimeRange()));
        appointmentRecordEntity.setAppointmentTime(new Date());
        appointmentRecordEntity.setAppointmentType(1);
        appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.APPOINTED.getValue());
        appointmentRecordEntity.setCardId(createOrderVoReq.getCardId());
        appointmentRecordEntity.setChannelCode(createOrderVoReq.getChannelName());
        appointmentRecordEntity.setDeptCode(createOrderVoReq.getDeptCode());
        appointmentRecordEntity.setDeptName(createOrderVoReq.getLocName());
        appointmentRecordEntity.setDocCode(createOrderVoReq.getDocCode());
        appointmentRecordEntity.setDocName(createOrderVoReq.getDocName());
        appointmentRecordEntity.setHospitalCode(createOrderVoReq.getHospitalCode());
        appointmentRecordEntity.setHospitalName(createOrderVoReq.getHospitalName());
        appointmentRecordEntity.setInnerChannelCode("\u533b\u9662\u6e20\u9053\u7f16\u7801");
        appointmentRecordEntity.setKeepSource(new Byte("1"));
        appointmentRecordEntity.setPatientCardNo(createOrderVoReq.getPatientCardNo());
        appointmentRecordEntity.setPatientId(cardDetailsInfoRespVO.getOrganPmi());
        appointmentRecordEntity.setPatientIdCard(createOrderVoReq.getPatientIdCard());
        appointmentRecordEntity.setPatientName(createOrderVoReq.getPatientName());
        appointmentRecordEntity.setPatientPhone(cardDetailsInfoRespVO.getTel());
        appointmentRecordEntity.setPatientAge(IdCardUtil.getAgeByIdCard((String)createOrderVoReq.getPatientIdCard()));
        appointmentRecordEntity.setPatientSex(IdCardUtil.getGenderByIdCard((String)createOrderVoReq.getPatientIdCard()) == "M" ? 1 : 2);
        BigDecimal totalFee = new BigDecimal(getScheduleResItems.getRegFee()).add(new BigDecimal(getScheduleResItems.getDiagFee()));
        appointmentRecordEntity.setPayAmount(String.valueOf(totalFee.doubleValue()));
        appointmentRecordEntity.setRegFee(new BigDecimal(confirmRegisterRes.getRegFee()));
        appointmentRecordEntity.setServiceFee(new BigDecimal(getScheduleResItems.getDiagFee()));
        appointmentRecordEntity.setScheduleHisId(createOrderVoReq.getScheduleHisId());
        appointmentRecordEntity.setSysAppointmentId(String.valueOf(sysAppointmentId));
        appointmentRecordEntity.setSysScheduleId(String.valueOf(this.snowflakeIdWorker.nextId()));
        appointmentRecordEntity.setSysTimeArrangeId(String.valueOf(this.snowflakeIdWorker.nextId()));
        appointmentRecordEntity.setUserId(createOrderVoReq.getUserId());
        appointmentRecordEntity.setRegTitleName(getScheduleResItems.getRegTitleName());
        appointmentRecordEntity.setScheduleLevelName(getScheduleResItems.getScheduleLevelName());
        appointmentRecordEntity.setHisTimeArrangeId(createOrderVoReq.getTimeArrangeId());
        appointmentRecordEntity.setRemark("\u9884\u7ea6\u6210\u529f");
        return appointmentRecordEntity;
    }

    public AppointmentRecordEntity getAppointmentRecordBySysAppointmentId(String sysAppointmentId) {
        return this.appointmentRecordMapper.selectBySysAppointId(sysAppointmentId);
    }

    public void autoCancelDelayAppointment(UpdateDelayAppointmentRecordVoReq updateDelayAppointmentRecordVo) {
        this.appointmentRecordMapper.autoCancelDelayAppointment(updateDelayAppointmentRecordVo);
    }

    private void updatePayAppointmentRecord(UpdatePayAppointmentRecordVoReq updatePayAppointmentRecordVoReq) {
        this.appointmentRecordMapper.updatePayAppointmentRecord(updatePayAppointmentRecordVoReq);
    }

    private void updateDoDayRegisterRes(DoDayAppointmentDTO doDayAppointmentDTO) {
        this.appointmentRecordMapper.updateDoDayAppointmentRecord(doDayAppointmentDTO);
    }

    public BaseResponse<String> dayAppointmentPay(DayAppointmentPayVoReq dayAppointmentPayVoReq) {
        AppointmentRecordEntity appointmentRecordEntity = this.appointmentRecordMapper.selectBySysAppointId(dayAppointmentPayVoReq.getSysAppointmentId());
        QueryCardInfoResVO queryCardInfoResVO = this.getCardInfo(appointmentRecordEntity.getPatientIdCard(), appointmentRecordEntity.getPatientName(), dayAppointmentPayVoReq.getChannelCode());
        if (null == queryCardInfoResVO) {
            log.error("\u3010\u6302\u53f7\u652f\u4ed8\u3011====his\u83b7\u53d6\u5361\u4fe1\u606f\u5931\u8d25====");
            return BaseResponse.error((String)"his\u83b7\u53d6\u60a3\u8005\u5361\u4fe1\u606f\u5931\u8d25");
        }
        String result = "";
        AllPayReq payReq = new AllPayReq();
        payReq.setType(HisPayBusinessTypeEnum.REG.getValue());
        payReq.setScheduleCode(appointmentRecordEntity.getScheduleHisId());
        payReq.setPatientCard(queryCardInfoResVO.getPatientId());
        payReq.setPatientId(queryCardInfoResVO.getPatientId());
        payReq.setOrgOrderNo(appointmentRecordEntity.getAdmId());
        payReq.setShouldPay(String.valueOf(appointmentRecordEntity.getRegFee()));
        payReq.setDepartmentId(appointmentRecordEntity.getDeptCode());
        payReq.setOpenId(dayAppointmentPayVoReq.getOpenId());
        payReq.setOrgId(appointmentRecordEntity.getHosId());
        payReq.setSourceCode("7");
        payReq.setTradeDesc("\u6302\u53f7");
        if (dayAppointmentPayVoReq.getChannelCode().equals(ChannelEnum.USER_APPLETS.getValue())) {
            payReq.setUseType("wechatminipay");
        } else {
            payReq.setUseType("aliminipay");
        }
        result = this.payUtil.toPay(payReq, dayAppointmentPayVoReq.getChannelCode());
        if (null == result) {
            return BaseResponse.error((String)"his\u53d1\u8d77\u652f\u4ed8\u5931\u8d25");
        }
        JSONObject jsonObject = JSONObject.parseObject((String)result);
        if (null == jsonObject.get((Object)"payData")) {
            return BaseResponse.error((String)"his\u53d1\u8d77\u652f\u4ed8\u5931\u8d25");
        }
        appointmentRecordEntity.setAppointmentId(jsonObject.getString("platTradeNo"));
        this.appointmentRecordMapper.updateByPrimaryKey(appointmentRecordEntity);
        try {
            this.taskExecutor.execute(() -> {
                String payChannel = dayAppointmentPayVoReq.getChannelCode();
                appointmentRecordEntity.setPayChannelCode(payChannel);
                appointmentRecordEntity.setPayChannel(PayChannelEnum.getDisplay((String)payChannel));
                this.updatePayStatusByPollQuery(appointmentRecordEntity);
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u8fd4\u56de\u652f\u4ed8\u4fe1\u606f\u65b9\u6cd5\u4e2d\u8c03\u7528confirmPay\u65b9\u6cd5\u5931\u8d25");
        }
        return BaseResponse.success((Object)jsonObject.getString("payData"));
    }

    public BaseResponse<String> appointmentPay(DayAppointmentPayVoReq dayAppointmentPayVoReq) {
        AppointmentRecordEntity appointmentRecordEntity = this.appointmentRecordMapper.selectBySysAppointId(dayAppointmentPayVoReq.getSysAppointmentId());
        AppointmentPayVoReq appointmentPayVoReq = new AppointmentPayVoReq();
        appointmentPayVoReq.setActuallyAmount(new BigDecimal("0.01"));
        appointmentPayVoReq.setMchCode(this.propertiesConstant.getMchCode());
        appointmentPayVoReq.setOutTradeNo(appointmentRecordEntity.getSysAppointmentId());
        appointmentPayVoReq.setPayChannel(dayAppointmentPayVoReq.getPayChannel());
        appointmentPayVoReq.setPayType(dayAppointmentPayVoReq.getPayType());
        appointmentPayVoReq.setProductInfo("\u9884\u7ea6\u6302\u53f7");
        appointmentPayVoReq.setServiceCode(this.propertiesConstant.getAppointmentServiceCode());
        appointmentPayVoReq.setTotalAmount(new BigDecimal("0.01"));
        appointmentPayVoReq.setUserSign(dayAppointmentPayVoReq.getOpenId());
        BaseResponse baseResponse = this.payCreateOrder(appointmentPayVoReq);
        return baseResponse;
    }

    private String toPay(PayReq payReq, String channelName) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        gatewayRequest.setBody((Object)payReq);
        gatewayRequest.setChannel(channelName);
        gatewayRequest.setChannelName(channelName);
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("PayReq");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        log.info("\u3010\u53d1\u8d77\u652f\u4ed8\u3011\u8bf7\u6c42\u5165\u53c2\uff1a" + gatewayRequest);
        BusinessResultEntity businessResultEntity = new BusinessResultEntity();
        businessResultEntity.setChannelCode(channelName);
        businessResultEntity.setBusinessType(new Byte(BusinessTypeEnums.PAI_CONFIRM.getValue().toString()));
        businessResultEntity.setHisRequest(JSON.toJSONString((Object)gatewayRequest));
        this.businessResultMapper.insertSelective(businessResultEntity);
        GatewayResponse gatewayResponse = this.appointApi.toPay(gatewayRequest);
        businessResultEntity.setErrorCode(gatewayResponse.getErrCode());
        businessResultEntity.setErrorMsg(gatewayResponse.getMsg());
        businessResultEntity.setHisResponse(JSON.toJSONString((Object)gatewayResponse));
        businessResultEntity.setTransationId(gatewayResponse.getTransactionId());
        businessResultEntity.setStatus(new Byte("0"));
        this.businessResultMapper.updateByPrimaryKeySelective(businessResultEntity);
        log.info("\u3010\u53d1\u8d77\u652f\u4ed8\u3011\u8bf7\u6c42\u51fa\u53c2\uff1a" + gatewayResponse);
        if (gatewayResponse == null) {
            log.error("\u3010\u53d1\u8d77\u652f\u4ed8\u3011comfirmPayNew -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            return null;
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u3010\u53d1\u8d77\u652f\u4ed8\u3011comfirmPayNew -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            return null;
        }
        if (gatewayResponse.getData() == null) {
            log.error("\u3010\u53d1\u8d77\u652f\u4ed8\u3011comfirmPayNew -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            return null;
        }
        return (String)gatewayResponse.getData();
    }

    private BaseResponse<String> payCreateOrder(AppointmentPayVoReq appointmentPayVoReq) {
        try {
            String body = HttpKit.jsonPost((String)this.propertiesConstant.getPayUrl(), (String)JSON.toJSONString((Object)appointmentPayVoReq));
            BaseResponse baseResponse = (BaseResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)body), BaseResponse.class);
            log.info("baseResponse: " + baseResponse);
            return baseResponse;
        }
        catch (Exception e) {
            log.error("\u53d1\u8d77\u652f\u4ed8\u5931\u8d25" + e.getMessage());
            return BaseResponse.error((String)"\u652f\u4ed8\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
        }
    }

    private GatewayRequest<PayRegistrationReq> buildPayRegistrationReq(AppointmentRecordEntity appointmentRecordEntity, ResponseNotifyRestVo responseNotifyRestVo) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        PayRegistrationReq payRegistrationReq = new PayRegistrationReq();
        payRegistrationReq.setCardNo(appointmentRecordEntity.getPatientCardNo());
        payRegistrationReq.setPatientId(appointmentRecordEntity.getPatientId());
        payRegistrationReq.setAppointId(appointmentRecordEntity.getAppointmentId());
        payRegistrationReq.setPayChannel(responseNotifyRestVo.getPayChannel());
        payRegistrationReq.setFlowNo(appointmentRecordEntity.getSysAppointmentId());
        payRegistrationReq.setCardNo(appointmentRecordEntity.getPatientCardNo());
        payRegistrationReq.setRegFee(appointmentRecordEntity.getPayAmount());
        PayRegistrationMsg payRegistrationMsg = new PayRegistrationMsg();
        payRegistrationMsg.setOrderid(responseNotifyRestVo.getTradeNo());
        payRegistrationMsg.setPayment(appointmentRecordEntity.getPayAmount());
        payRegistrationMsg.setSuccess("Y");
        payRegistrationMsg.setPosid(responseNotifyRestVo.getMchId());
        payRegistrationMsg.setAccdate(DateUtils.dateToString((Date)responseNotifyRestVo.getPayTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        payRegistrationMsg.setBusinessCode(responseNotifyRestVo.getServiceCode());
        payRegistrationReq.setRespMsg(payRegistrationMsg);
        gatewayRequest.setBody((Object)payRegistrationReq);
        gatewayRequest.setChannelName(ChannelEnum.getDisplay((String)appointmentRecordEntity.getChannelCode()));
        gatewayRequest.setChannel(appointmentRecordEntity.getChannelCode());
        gatewayRequest.setOrganCode(appointmentRecordEntity.getHospitalCode());
        gatewayRequest.setKeyWord("PayRegistrationReq");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    private void updateScheduleSourceNo(GetScheduleResItems getScheduleResItems, AppointmentCreateOrderVoReq appointmentCreateOrderVoReq) {
        UpdateScheduleDetailDTO updateScheduleDetailDTO = new UpdateScheduleDetailDTO();
        ArrayList<String> timeArrangeIdList = new ArrayList<String>();
        updateScheduleDetailDTO.setHospitalCode(appointmentCreateOrderVoReq.getHospitalCode());
        updateScheduleDetailDTO.setScheduleId(getScheduleResItems.getScheduleId());
        for (TimeArrangeItems timeArrangeItems : getScheduleResItems.getTimeArrangeItems()) {
            timeArrangeIdList.add(timeArrangeItems.getTimeArrangeId());
        }
        String timeArrangeId = "'" + StringUtils.join(timeArrangeIdList, (String)"','") + "'";
        updateScheduleDetailDTO.setTimeArrangeId(timeArrangeId);
        this.scheduleDetailRecordMapper.updateByGetScheduleResItems(updateScheduleDetailDTO);
    }

    private void updateScheduleByDayAppointmentCreateOrderVoReq(DayAppointmentCreateOrderVoReq dayAppointmentCreateOrderVoReq) {
        this.scheduleRecordMapper.updateScheduleByDayAppointmentCreateOrderVoReq(dayAppointmentCreateOrderVoReq);
    }

    private GatewayRequest<GetScheduleReqVO> buildConfirmScheduleGetwayRequest(ConfirmAppointmentVo confirmAppointmentVo) {
        GatewayRequest gatewayReq = new GatewayRequest();
        GetScheduleReqVO getScheduleReqVO = new GetScheduleReqVO();
        getScheduleReqVO.setBgDate(confirmAppointmentVo.getAdmDate());
        getScheduleReqVO.setEdDate(confirmAppointmentVo.getAdmDate());
        getScheduleReqVO.setLocCode(confirmAppointmentVo.getLocCode());
        getScheduleReqVO.setDocCode(confirmAppointmentVo.getDocCode());
        String hisId = this.getHosId(confirmAppointmentVo.getLocCode());
        getScheduleReqVO.setScheduleCode(hisId);
        gatewayReq.setBody((Object)getScheduleReqVO);
        gatewayReq.setChannelName(ChannelEnum.USER_APPLETS.getValue());
        gatewayReq.setChannel(ChannelEnum.USER_APPLETS.getValue());
        gatewayReq.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayReq.setKeyWord("confirmAppointmentVo");
        gatewayReq.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayReq;
    }

    private List<GetScheduleResItems> getHisDaySchedule(ConfirmAppointmentVo confirmAppointmentVo) {
        GatewayRequest gatewayRequest = this.buildConfirmScheduleGetwayRequest(confirmAppointmentVo);
        GatewayResponse gatewayResponse = this.scheduleApi.getDoctorSchedule(gatewayRequest);
        if (gatewayResponse == null) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            return new ArrayList<GetScheduleResItems>();
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            return new ArrayList<GetScheduleResItems>();
        }
        if (gatewayResponse.getData() == null) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            return new ArrayList<GetScheduleResItems>();
        }
        List<GetScheduleResItems> getScheduleResItemsList = ((GetScheduleResVO)gatewayResponse.getData()).getItems();
        if (CollectionUtils.isEmpty((Collection)getScheduleResItemsList)) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u65e0\u6392\u73ed\u4fe1\u606f");
            return new ArrayList<GetScheduleResItems>();
        }
        GetScheduleVoReq getScheduleVoReq = new GetScheduleVoReq();
        getScheduleVoReq.setDeptCode(confirmAppointmentVo.getLocCode());
        getScheduleVoReq.setChannelName(confirmAppointmentVo.getChannelName());
        this.scheduleService.buildScheduleTimeArrangeItems((List)getScheduleResItemsList, getScheduleVoReq);
        getScheduleResItemsList = getScheduleResItemsList.stream().filter(getScheduleResItems -> getScheduleResItems.getAdmTimeRange().equals(confirmAppointmentVo.getAdmTimeRange())).collect(Collectors.toList());
        return getScheduleResItemsList;
    }

    private ConfirmAppointmentVo buildConfirmAppointmentVo(GetScheduleResItems getScheduleResItems, ConfirmAppointmentVo confirmAppointVo) {
        ConfirmAppointmentVo confirmAppointmentVo = new ConfirmAppointmentVo();
        confirmAppointmentVo.setDoctorHeadPortrait(confirmAppointVo.getDoctorHeadPortrait());
        confirmAppointmentVo.setAdmDate(confirmAppointVo.getAdmDate());
        confirmAppointmentVo.setAdmTimeRange(confirmAppointVo.getAdmTimeRange());
        confirmAppointmentVo.setDocCode(confirmAppointVo.getDocCode());
        confirmAppointmentVo.setDocName(confirmAppointVo.getDocName());
        confirmAppointmentVo.setHospitalName(confirmAppointVo.getHospitalName());
        confirmAppointmentVo.setIsAppend(confirmAppointVo.getIsAppend());
        confirmAppointmentVo.setIsTimeArrange(confirmAppointVo.getIsTimeArrange());
        confirmAppointmentVo.setLocCode(confirmAppointVo.getLocCode());
        confirmAppointmentVo.setLocName(confirmAppointVo.getLocName());
        confirmAppointmentVo.setRegFee(confirmAppointVo.getRegFee());
        confirmAppointmentVo.setDiagFee(confirmAppointVo.getDiagFee());
        confirmAppointmentVo.setTotalFee(confirmAppointVo.getTotalFee());
        confirmAppointmentVo.setRegTitleCode(confirmAppointVo.getRegTitleCode());
        confirmAppointmentVo.setRegTitleName(confirmAppointVo.getRegTitleName());
        confirmAppointmentVo.setScheduleHisId(confirmAppointVo.getScheduleHisId());
        confirmAppointmentVo.setScheduleLevelName(confirmAppointVo.getScheduleLevelName());
        List timeArrangeItemsList = getScheduleResItems.getTimeArrangeItems();
        if (CollectionUtils.isEmpty((Collection)timeArrangeItemsList)) {
            confirmAppointmentVo.setTimeArrangeItems(new ArrayList());
        }
        confirmAppointmentVo.setTimeArrangeItems(timeArrangeItemsList);
        return confirmAppointmentVo;
    }

    public BaseResponse<String> appointmentRefund(String sysAppointmentId) {
        AppointmentRecordEntity appointmentRecordEntity = this.appointmentRecordMapper.selectBySysAppointId(sysAppointmentId);
        AppointmentPayorderEntity appointmentPayorderEntity = this.appointmentPayOrderMapper.selectBySysAppointmentId(sysAppointmentId);
        if (null == appointmentPayorderEntity || null == appointmentRecordEntity) {
            return BaseResponse.error((String)"\u5f53\u524d\u72b6\u6001\u4e0d\u80fd\u9000\u6b3e\uff01");
        }
        if (!appointmentStatusList.contains((int)appointmentRecordEntity.getAppointStatus())) {
            return BaseResponse.error((String)"\u5f53\u524d\u72b6\u6001\u4e0d\u80fd\u9000\u6b3e\uff01");
        }
        int appointmentType = appointmentRecordEntity.getAppointmentType();
        RequestRefundOrderVoReq requestRefundOrderVoReq = new RequestRefundOrderVoReq();
        requestRefundOrderVoReq.setPayChannel(appointmentRecordEntity.getPayChannelCode());
        requestRefundOrderVoReq.setMchCode(this.propertiesConstant.getMchCode());
        requestRefundOrderVoReq.setOutTradeNo(appointmentRecordEntity.getSysAppointmentId());
        requestRefundOrderVoReq.setDealTradeNo(appointmentPayorderEntity.getDealSeq());
        requestRefundOrderVoReq.setTotalAmount(new BigDecimal(appointmentRecordEntity.getPayAmount()));
        requestRefundOrderVoReq.setRefundAmount(new BigDecimal(appointmentRecordEntity.getPayAmount()));
        BaseResponse baseResponse = this.refund(requestRefundOrderVoReq);
        if ("1".equals(baseResponse.getCode())) {
            appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.ADMIN_LAUNCH_REFUND_SUCCESS.getValue());
            appointmentRecordEntity.setRemark(AppointmentStatusEnum.ADMIN_LAUNCH_REFUND_SUCCESS.getDisplay());
            this.appointmentRecordMapper.updateByPrimaryKey(appointmentRecordEntity);
        } else {
            BaseResponse.error((String)"\u53d1\u8d77\u9000\u6b3e\u5931\u8d25");
        }
        return BaseResponse.success((Object)"\u53d1\u8d77\u9000\u6b3e\u6210\u529f");
    }

    public BaseResponse<TencentCreadOrderResponse> insurinfoAppointmentPay(DayAppointmentPayVoReq dayAppointmentPayVoReq) {
        AppointmentRecordEntity appointmentRecordEntity = this.appointmentRecordMapper.selectBySysAppointId(dayAppointmentPayVoReq.getSysAppointmentId());
        QueryCardInfoResVO queryCardInfoResVO = this.getCardInfo(appointmentRecordEntity.getPatientIdCard(), appointmentRecordEntity.getPatientName(), dayAppointmentPayVoReq.getChannelCode());
        if (null == queryCardInfoResVO) {
            log.error("\u3010\u6302\u53f7\u652f\u4ed8\u3011====his\u83b7\u53d6\u5361\u4fe1\u606f\u5931\u8d25====");
            return BaseResponse.error((String)"his\u83b7\u53d6\u60a3\u8005\u5361\u4fe1\u606f\u5931\u8d25");
        }
        InsuranceInfo insuranceInfo = this.getYbInfo(queryCardInfoResVO, appointmentRecordEntity.getHosId());
        if (null == insuranceInfo) {
            return BaseResponse.error((String)"\u83b7\u53d6\u533b\u4fdd\u4e2a\u4eba\u4fe1\u606f\u5931\u8d25");
        }
        MedicalInsurInfoResVo medicalInsurInfoResVo = this.getMedicalInsurinfo(appointmentRecordEntity);
        if (null == medicalInsurInfoResVo) {
            return BaseResponse.error((String)"\u83b7\u53d6\u533b\u4fdd\u6302\u53f7\u4fe1\u606f");
        }
        ConsultationHealtInuranceRes consultationHealtInuranceRes = this.insuranceRegYjs(insuranceInfo, dayAppointmentPayVoReq, medicalInsurInfoResVo, appointmentRecordEntity);
        if (null == consultationHealtInuranceRes) {
            return BaseResponse.error((String)"\u6302\u53f7\u533b\u4fdd\u9884\u7ed3\u7b97\u5931\u8d25");
        }
        TencentCreadOrderResponse tencentCreadOrderResponse = this.tencentCreateOrder(consultationHealtInuranceRes, dayAppointmentPayVoReq, appointmentRecordEntity.getHosId());
        if (null == tencentCreadOrderResponse) {
            return BaseResponse.error((String)"\u817e\u8baf\u533b\u4fdd\u4e0b\u5355\u5931\u8d25");
        }
        appointmentRecordEntity.setYbInfo(JSONObject.toJSONString((Object)consultationHealtInuranceRes));
        this.appointmentRecordMapper.updateByPrimaryKey(appointmentRecordEntity);
        tencentCreadOrderResponse.setYbInfo(JSONObject.toJSONString((Object)consultationHealtInuranceRes));
        return BaseResponse.success((Object)tencentCreadOrderResponse);
    }

    public BaseResponse<TencentRefundResponse> ybRefund(YBRefundVoReq refundVoReq) {
        try {
            String ybInfo;
            String hos = "NCDXDEFSYY";
            ConsultationHealtInuranceRes consultationHealtInuranceRes = new ConsultationHealtInuranceRes();
            if (refundVoReq.getType() == 1) {
                AppointmentRecordEntity appointmentRecordEntity = this.appointmentRecordMapper.selectBySysAppointId(refundVoReq.getSysAppointmentId());
                if (null == appointmentRecordEntity) {
                    return BaseResponse.error((String)"\u672a\u627e\u5230\u8be5\u8ba2\u5355");
                }
                ybInfo = appointmentRecordEntity.getYbInfo();
                consultationHealtInuranceRes = (ConsultationHealtInuranceRes)JSONObject.parseObject((String)ybInfo, ConsultationHealtInuranceRes.class);
                hos = appointmentRecordEntity.getHosId();
            } else {
                OpBusinessOrderEntity opBusinessOrderEntity = this.opBusinessOrderEntityMapper.selectByOutPatientId(refundVoReq.getSysAppointmentId());
                if (null == opBusinessOrderEntity) {
                    return BaseResponse.error((String)"\u672a\u627e\u5230\u8be5\u8ba2\u5355");
                }
                ybInfo = opBusinessOrderEntity.getYbInfo();
                consultationHealtInuranceRes = (ConsultationHealtInuranceRes)JSONObject.parseObject((String)ybInfo, ConsultationHealtInuranceRes.class);
                if (null != opBusinessOrderEntity.getItemType()) {
                    if (opBusinessOrderEntity.getItemType().equals("9")) {
                        hos = "NDEFYHJZYQ";
                    } else if (opBusinessOrderEntity.getItemType().equals("10")) {
                        hos = "NDEFYJLYY";
                    }
                }
            }
            RefundRequestContent refundRequestContent = new RefundRequestContent();
            refundRequestContent.setRef_reason("\u9000\u8d39");
            refundRequestContent.setPayOrdId(consultationHealtInuranceRes.getPayOrdId());
            TencentRefundRequest TencentRefundReques = new TencentRefundRequest();
            TencentRefundReques.setHosp_out_trade_no(refundVoReq.getSysAppointmentId());
            TencentRefundReques.setCash_refund_fee(refundVoReq.getCashRefundFee());
            TencentRefundReques.setHosp_out_refund_no(refundVoReq.getHospOutRefundNo());
            TencentRefundReques.setPart_refund_type("CASH_ONLY");
            TencentRefundReques.setNonce_str(DateUtils.getCurrentDateTimeString());
            TencentRefundReques.setOrganCode("79_NCDXDEFSYY");
            if (null != hos) {
                if (hos.equals("NDEFYHJZYQ")) {
                    TencentRefundReques.setOrganCode("79_NDEFYHJZYQ");
                } else if (hos.equals("NDEFYJLYY")) {
                    TencentRefundReques.setOrganCode("79_NDEFYJLYY");
                }
            }
            log.info("===tencentybRefund===Req{}", (Object)JSON.toJSONString((Object)TencentRefundReques));
            String body = HttpKit.jsonPost((String)(this.constant.getYburl() + "/tencent/tencentRefund"), (String)JSON.toJSONString((Object)TencentRefundReques));
            log.info("===tencentybRefund===Res{}", (Object)JSON.toJSONString((Object)body));
            2 typeReference = new /* Unavailable Anonymous Inner Class!! */;
            ResultResponse response = (ResultResponse)JSONObject.parseObject((String)body, (Type)typeReference.getType(), (Feature[])new Feature[0]);
            if (!"1".equals(response.getCode()) || null == response.getBody() || !((TencentRefundResponse)response.getBody()).getResult_code().equals("SUCCESS")) {
                return BaseResponse.error((String)"\u8c03\u7528\u817e\u8baf\u63a5\u53e3\u9000\u8d39\u5931\u8d25");
            }
            TencentRefundResponse res = (TencentRefundResponse)response.getBody();
            return BaseResponse.success((Object)res);
        }
        catch (Exception e) {
            return BaseResponse.error((String)"\u8c03\u7528\u817e\u8baf\u63a5\u53e3\u9000\u8d39\u5f02\u5e38");
        }
    }

    public BaseResponse<String> getFzApppint(GetFzApppintReqVO getFzApppintReqVO) {
        try {
            FrontRequest param = new FrontRequest();
            param.setBody((Object)getFzApppintReqVO);
            log.info("===0\u5143\u590d\u8bca===Req{}", (Object)JSON.toJSONString((Object)param));
            String body = HttpKit.jsonPost((String)(this.constant.getHisurl() + "/appoint/register/GetFzApppint"), (String)JSON.toJSONString((Object)param));
            log.info("===0\u5143\u590d\u8bca===Res{}", (Object)JSON.toJSONString((Object)body));
            3 typeReference = new /* Unavailable Anonymous Inner Class!! */;
            FrontResponse response = (FrontResponse)JSONObject.parseObject((String)body, (Type)typeReference.getType(), (Feature[])new Feature[0]);
            if (!"1".equals(response.getCode()) || null == response.getBody()) {
                return BaseResponse.error((String)"\u6ca1\u67090\u5143\u590d\u8bca\u8d44\u683c");
            }
            GetFzApppintResVO getFzApppintResVO = (GetFzApppintResVO)response.getBody();
            return BaseResponse.success((Object)getFzApppintResVO.getFirstAdm());
        }
        catch (Exception e) {
            e.printStackTrace();
            return BaseResponse.error((String)e.getMessage());
        }
    }

    public BaseResponse<String> zeroCostFollowupPayment(DayAppointmentPayVoReq dayAppointmentPayVoReq) {
        try {
            AppointmentRecordEntity appointmentRecordEntity = this.appointmentRecordMapper.selectBySysAppointId(dayAppointmentPayVoReq.getSysAppointmentId());
            if (appointmentRecordEntity.getAppointStatus() != AppointmentStatusEnum.WAIT_PAY.getValue()) {
                return BaseResponse.error((String)"\u8be5\u6302\u53f7\u8ba2\u5355\u72b6\u6001\u4e0d\u662f\u5f85\u652f\u4ed8");
            }
            if (!dayAppointmentPayVoReq.getPayChannel().equals("FZJZ") || StringUtils.isEmpty((String)dayAppointmentPayVoReq.getFirstAdm())) {
                return BaseResponse.error((String)"\u8bf7\u68c0\u67e5\u53c2\u6570");
            }
            GetFzApppintReqVO getFzApppintReqVO = new GetFzApppintReqVO();
            getFzApppintReqVO.setPatNo(appointmentRecordEntity.getPatientId());
            getFzApppintReqVO.setScheduleId(appointmentRecordEntity.getScheduleHisId());
            BaseResponse fzApppint = this.getFzApppint(getFzApppintReqVO);
            if (!fzApppint.isSuccess()) {
                return BaseResponse.error((String)"\u65e0\u514d\u8d39\u8d44\u683c");
            }
            if (!((String)fzApppint.getData()).equals(dayAppointmentPayVoReq.getFirstAdm())) {
                return BaseResponse.error((String)"\u8bf7\u68c0\u67e5\u53c2\u6570");
            }
            appointmentRecordEntity.setRemark("\u8fdb\u5165\u590d\u8bca\u8bb0\u8d26\u652f\u4ed8");
            appointmentRecordEntity.setPayChannel("FZJZ");
            appointmentRecordEntity.setPayChannelCode("FZJZ");
            appointmentRecordEntity.setPayTransationId(dayAppointmentPayVoReq.getFirstAdm());
            this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecordEntity);
            FrontRequest param = new FrontRequest();
            RegConfirmatReqVo regConfirmatReqVo = new RegConfirmatReqVo();
            regConfirmatReqVo.setFirstAdm(dayAppointmentPayVoReq.getFirstAdm());
            regConfirmatReqVo.setTransactionId(appointmentRecordEntity.getAdmId());
            regConfirmatReqVo.setPatientId(appointmentRecordEntity.getPatientId());
            regConfirmatReqVo.setScheduleItemCode(appointmentRecordEntity.getScheduleHisId());
            regConfirmatReqVo.setPayTradeNo(appointmentRecordEntity.getSysAppointmentId());
            regConfirmatReqVo.setPlatformNo(appointmentRecordEntity.getSysAppointmentId());
            regConfirmatReqVo.setPayFee(appointmentRecordEntity.getRegFee().toString());
            regConfirmatReqVo.setPayAmt(appointmentRecordEntity.getRegFee().toString());
            regConfirmatReqVo.setPayModeCode("FZJZ");
            param.setBody((Object)regConfirmatReqVo);
            param.setChannel(appointmentRecordEntity.getHosId());
            log.info("===\u6302\u53f7\u7ed3\u7b97===Req{}", (Object)JSON.toJSONString((Object)param));
            String body = HttpKit.jsonPost((String)(this.constant.getHisurl() + "/medicalinsurance/regConfirmat"), (String)JSON.toJSONString((Object)param));
            log.info("===\u6302\u53f7\u7ed3\u7b97===bodyRes{}", (Object)JSON.toJSONString((Object)body));
            4 typeReference = new /* Unavailable Anonymous Inner Class!! */;
            FrontResponse response = (FrontResponse)JSONObject.parseObject((String)body, (Type)typeReference.getType(), (Feature[])new Feature[0]);
            if (!"1".equals(response.getCode()) || null == response.getBody()) {
                return BaseResponse.error((String)"his\u6302\u53f7\u5931\u8d25");
            }
            RegConfirmatResVo regConfirmatResVo = (RegConfirmatResVo)response.getBody();
            appointmentRecordEntity.setReceptId(regConfirmatResVo.getAdmNo());
            appointmentRecordEntity.setRemark("\u590d\u8bca\u8bb0\u8d26\u652f\u4ed8\u6210\u529f");
            appointmentRecordEntity.setPayAccdate(DateUtils.dateToFullString((Date)new Date()));
            appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.PAY.getValue());
            this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecordEntity);
            return BaseResponse.success((Object)"\u6302\u53f7\u6210\u529f");
        }
        catch (Exception e) {
            log.info("\u6302\u53f7\u5f02\u5e38:" + e.getMessage());
            return BaseResponse.error((String)"\u6302\u53f7\u5f02\u5e38");
        }
    }

    private TencentCreadOrderResponse tencentCreateOrder(ConsultationHealtInuranceRes consultationHealtInuranceRes, DayAppointmentPayVoReq dayAppointmentPayVoReq, String hos) {
        TencentCreadOrderResponse responseBody = new TencentCreadOrderResponse();
        try {
            TencentCreadOrderRequest tencentCreateOrderReq = new TencentCreadOrderRequest();
            tencentCreateOrderReq.setAllow_fee_change("0");
            tencentCreateOrderReq.setBody("\u5c0f\u7a0b\u5e8f-\u6302\u53f7");
            tencentCreateOrderReq.setCash_add_fee("0");
            tencentCreateOrderReq.setCash_fee(NumberUtils.formatAmtY2F((String)consultationHealtInuranceRes.getOwnPayAmt()));
            tencentCreateOrderReq.setCity_id("360100");
            tencentCreateOrderReq.setGmt_out_create(DateUtils.getCurrentDateTimeString());
            tencentCreateOrderReq.setHosp_out_trade_no(dayAppointmentPayVoReq.getSysAppointmentId());
            tencentCreateOrderReq.setInsurance_fee(new BigDecimal(consultationHealtInuranceRes.getPsnAcctPay()).add(new BigDecimal(consultationHealtInuranceRes.getFundPay())).multiply(new BigDecimal(100)).toString());
            tencentCreateOrderReq.setIs_dept("4");
            tencentCreateOrderReq.setNonce_str(DateUtils.getCurrentDateTimeString());
            tencentCreateOrderReq.setNotify_url("https://ihos.chinachdu.com/zhjy/ncefy/api/v1/payCallBack/v1/tencentNotifyReg");
            tencentCreateOrderReq.setReturn_url("mm");
            tencentCreateOrderReq.setOpenid(dayAppointmentPayVoReq.getOpenId());
            tencentCreateOrderReq.setOrder_type("RegPay");
            tencentCreateOrderReq.setOrganCode("79_NCDXDEFSYY");
            if (null != hos) {
                if (hos.equals("NDEFYHJZYQ")) {
                    tencentCreateOrderReq.setOrganCode("79_NDEFYHJZYQ");
                } else if (hos.equals("NDEFYJLYY")) {
                    tencentCreateOrderReq.setOrganCode("79_NDEFYJLYY");
                }
            }
            if (tencentCreateOrderReq.getCash_fee().equals("0")) {
                tencentCreateOrderReq.setPay_type("2");
            } else {
                tencentCreateOrderReq.setPay_type("3");
            }
            RequestContent request_content = new RequestContent();
            request_content.setPayAuthNo(dayAppointmentPayVoReq.getPayAuthNo());
            request_content.setPayOrdId(consultationHealtInuranceRes.getPayOrdId());
            request_content.setSetlLatlnt(dayAppointmentPayVoReq.getUldLatlnt());
            tencentCreateOrderReq.setRequest_content(request_content);
            tencentCreateOrderReq.setSerial_no(consultationHealtInuranceRes.getMedOrgOrd());
            tencentCreateOrderReq.setSpbill_create_ip("10.5.1.2");
            tencentCreateOrderReq.setTotal_fee(NumberUtils.formatAmtY2F((String)consultationHealtInuranceRes.getFeeSumamt()));
            tencentCreateOrderReq.setUser_card_no(consultationHealtInuranceRes.getUser_card_no());
            tencentCreateOrderReq.setUser_name(consultationHealtInuranceRes.getUser_name());
            tencentCreateOrderReq.setUser_card_type("1");
            log.info("===tencentCreateOrder===Req{}", (Object)JSON.toJSONString((Object)tencentCreateOrderReq));
            String body = HttpKit.jsonPost((String)(this.constant.getYburl() + "/tencent/tencentCreateOrder"), (String)JSON.toJSONString((Object)tencentCreateOrderReq));
            log.info("===tencentCreateOrder===Res{}", (Object)JSON.toJSONString((Object)body));
            5 typeReference = new /* Unavailable Anonymous Inner Class!! */;
            ResultResponse response = (ResultResponse)JSONObject.parseObject((String)body, (Type)typeReference.getType(), (Feature[])new Feature[0]);
            if (!"1".equals(response.getCode()) || null == response.getBody() || !((TencentCreadOrderResponse)response.getBody()).getResult_code().equals("SUCCESS")) {
                return null;
            }
            responseBody = (TencentCreadOrderResponse)response.getBody();
        }
        catch (Exception e) {
            return null;
        }
        return responseBody;
    }

    private ConsultationHealtInuranceRes insuranceRegYjs(InsuranceInfo insuranceInfo, DayAppointmentPayVoReq dayAppointmentPayVoReq, MedicalInsurInfoResVo medicalInsurInfoResVo, AppointmentRecordEntity appointmentRecordEntity) {
        ConsultationHealtInuranceRes consultationHealtInuranceRes = new ConsultationHealtInuranceRes();
        try {
            FrontRequest param = new FrontRequest();
            OutpatientPreRegistratReqVo outpatientPreRegistratReqVo = new OutpatientPreRegistratReqVo();
            outpatientPreRegistratReqVo.setIp("10.5.1.2");
            outpatientPreRegistratReqVo.setMac("7c:8a:e1:c7:ee:5f");
            outpatientPreRegistratReqVo.setExpStr(medicalInsurInfoResVo.getExpString());
            outpatientPreRegistratReqVo.setInsutype(insuranceInfo.getInsutype());
            outpatientPreRegistratReqVo.setInsuplcAdmdvs(insuranceInfo.getInsuplcAdmdvs());
            outpatientPreRegistratReqVo.setMedOrgOrd(dayAppointmentPayVoReq.getSysAppointmentId());
            outpatientPreRegistratReqVo.setPayAuthNo(dayAppointmentPayVoReq.getPayAuthNo());
            outpatientPreRegistratReqVo.setUldLatlnt(dayAppointmentPayVoReq.getUldLatlnt());
            outpatientPreRegistratReqVo.setTransactionId(appointmentRecordEntity.getAppointmentId());
            if (insuranceInfo.getInsuplcAdmdvs().contains("3601")) {
                outpatientPreRegistratReqVo.setAddress("4");
            } else {
                outpatientPreRegistratReqVo.setAddress("75");
            }
            param.setBody((Object)outpatientPreRegistratReqVo);
            param.setChannel(appointmentRecordEntity.getHosId());
            log.info("===\u533b\u4fdd\u6302\u53f7\u9884\u7ed3\u7b97===Req{}", (Object)JSON.toJSONString((Object)param));
            String body = HttpKit.jsonPost((String)(this.constant.getHisurl() + "/medicalinsurance/outpatientpreregistrat"), (String)JSON.toJSONString((Object)param));
            log.info("===\u533b\u4fdd\u6302\u53f7\u9884\u7ed3\u7b97===Res{}", (Object)JSON.toJSONString((Object)body));
            6 typeReference = new /* Unavailable Anonymous Inner Class!! */;
            FrontResponse response = (FrontResponse)JSONObject.parseObject((String)body, (Type)typeReference.getType(), (Feature[])new Feature[0]);
            if (!"1".equals(response.getCode()) || null == response.getBody()) {
                return null;
            }
            consultationHealtInuranceRes = (ConsultationHealtInuranceRes)response.getBody();
            consultationHealtInuranceRes.setUser_name(appointmentRecordEntity.getPatientName());
            consultationHealtInuranceRes.setUser_card_no(appointmentRecordEntity.getPatientIdCard());
            consultationHealtInuranceRes.setPayAuthNo(dayAppointmentPayVoReq.getPayAuthNo());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return consultationHealtInuranceRes;
    }

    private MedicalInsurInfoResVo getMedicalInsurinfo(AppointmentRecordEntity appointmentRecordEntity) {
        MedicalInsurInfoResVo medicalInsurInfoRes = new MedicalInsurInfoResVo();
        try {
            FrontRequest param = new FrontRequest();
            MedicalInsurInfoReqVo getYbInfoReq = new MedicalInsurInfoReqVo();
            getYbInfoReq.setHospitalId(appointmentRecordEntity.getHosId());
            getYbInfoReq.setScheduleItemCode(appointmentRecordEntity.getScheduleHisId());
            getYbInfoReq.setIoType("Reg");
            getYbInfoReq.setPatientId(appointmentRecordEntity.getPatientId());
            getYbInfoReq.setTransactionId(appointmentRecordEntity.getAppointmentId());
            getYbInfoReq.setPayModeCode("CASH");
            param.setBody((Object)getYbInfoReq);
            param.setChannel(appointmentRecordEntity.getHosId());
            log.info("===\u83b7\u53d6\u533b\u4fdd\u6302\u53f7\u4fe1\u606f===Req{}", (Object)JSON.toJSONString((Object)param));
            String body = HttpKit.jsonPost((String)(this.constant.getHisurl() + "/medicalinsurance/medicalinsurinfo"), (String)JSON.toJSONString((Object)param));
            log.info("===\u83b7\u53d6\u533b\u4fdd\u6302\u53f7\u4fe1\u606f===Res{}", (Object)JSON.toJSONString((Object)body));
            7 typeReference = new /* Unavailable Anonymous Inner Class!! */;
            FrontResponse response = (FrontResponse)JSONObject.parseObject((String)body, (Type)typeReference.getType(), (Feature[])new Feature[0]);
            if (!"1".equals(response.getCode()) || null == response.getBody()) {
                return null;
            }
            medicalInsurInfoRes = (MedicalInsurInfoResVo)response.getBody();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return medicalInsurInfoRes;
    }

    private InsuranceInfo getYbInfo(QueryCardInfoResVO queryCardInfoResVO, String hos) {
        InsuranceInfo InsuranceInfo2 = new InsuranceInfo();
        try {
            FrontRequest param = new FrontRequest();
            FetchMedicalInsuranceMemberBasicInfoReq getYbInfoReq = new FetchMedicalInsuranceMemberBasicInfoReq();
            getYbInfoReq.setAdmReasonDr("4");
            getYbInfoReq.setHospId("2");
            getYbInfoReq.setMac("7c:8a:e1:c7:ee:5f");
            getYbInfoReq.setIp("10.5.1.2");
            getYbInfoReq.setUserId("4910");
            getYbInfoReq.setPsnName(queryCardInfoResVO.getName());
            getYbInfoReq.setPsnCertType("02");
            getYbInfoReq.setMdtrtCertNo(queryCardInfoResVO.getCredNo());
            getYbInfoReq.setOpterType("3");
            getYbInfoReq.setMdtrtCertType("02");
            getYbInfoReq.setCertNo(queryCardInfoResVO.getCredNo());
            param.setBody((Object)getYbInfoReq);
            param.setChannel(hos);
            log.info("===fetchMedicalInsuranceMemberBasicInfo===Req{}", (Object)JSON.toJSONString((Object)param));
            String body = HttpKit.jsonPost((String)(this.constant.getHisurl() + "/medicalinsurance/fetchMedicalInsuranceMemberBasicInfo"), (String)JSON.toJSONString((Object)param));
            log.info("===fetchMedicalInsuranceMemberBasicInfo===Res{}", (Object)JSON.toJSONString((Object)body));
            8 typeReference = new /* Unavailable Anonymous Inner Class!! */;
            FrontResponse response = (FrontResponse)JSONObject.parseObject((String)body, (Type)typeReference.getType(), (Feature[])new Feature[0]);
            if (!"1".equals(response.getCode()) || null == response.getBody()) {
                return null;
            }
            List insuinfo = ((InsuranceMemberBasicInfoResOutput)response.getBody()).getInsuinfo();
            insuinfo.removeIf(o -> !o.getPsnInsuStas().equals("1"));
            insuinfo.removeIf(o -> o.getBalc().equals("0"));
            InsuranceMemberBasicInfoResOutput.InsuranceInfo insuranceInfo = (InsuranceMemberBasicInfoResOutput.InsuranceInfo)insuinfo.get(0);
            BeanUtils.copyProperties((Object)insuranceInfo, (Object)InsuranceInfo2);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return InsuranceInfo2;
    }

    private QueryCardInfoResVO getCardInfo(String credNo, String name, String channelName) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        QueryCardInfoReqVO queryCardInfoReqVO = new QueryCardInfoReqVO();
        queryCardInfoReqVO.setCredNo(credNo);
        queryCardInfoReqVO.setName(name);
        gatewayRequest.setBody((Object)queryCardInfoReqVO);
        gatewayRequest.setChannel(channelName);
        gatewayRequest.setChannelName(channelName);
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("QueryCardInfoReqVO");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        GatewayResponse gatewayResponse = this.cardApi.queryCardInfo(gatewayRequest);
        if (gatewayResponse == null) {
            log.error("\u3010\u67e5\u8be2\u5c31\u8bca\u5361\u4fe1\u606f\u3011queryCardInfo -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            return null;
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u3010\u67e5\u8be2\u5c31\u8bca\u5361\u4fe1\u606f\u3011 queryCardInfo -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            return null;
        }
        if (gatewayResponse.getData() == null) {
            log.error("\u3010\u67e5\u8be2\u5c31\u8bca\u5361\u4fe1\u606f\u3011 queryCardInfo -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            return null;
        }
        QueryCardInfoResVO queryCardInfoResVO = (QueryCardInfoResVO)gatewayResponse.getData();
        return queryCardInfoResVO;
    }

    private CardDetailsInfoRespVO getCardDetail(String cardId) {
        CardDetailsInfoReqVO cardDetailsInfoReqVO = new CardDetailsInfoReqVO();
        cardDetailsInfoReqVO.setCardId(cardId);
        cardDetailsInfoReqVO.setChannelCode("app");
        CardDetailsInfoRespVO respVO = this.getCardInfoUtil.getCardDetail(cardDetailsInfoReqVO);
        return respVO;
    }

    private void updatePayStatusByPollQuery(AppointmentRecordEntity appointmentRecordEntity) {
        AppointmentRecordEntity dataBaseAppointmentRecordEntity = this.appointmentRecordMapper.selectBySysAppointId(appointmentRecordEntity.getSysAppointmentId());
        if (AppointmentStatusEnum.PAY.getValue().equals(dataBaseAppointmentRecordEntity.getAppointStatus())) {
            return;
        }
        int times = 350;
        boolean isPayed = false;
        AppointOrderStatusRes appointOrderStatusRes = null;
        try {
            Thread.sleep(3000L);
            while (times > 0) {
                appointOrderStatusRes = this.payUtil.orderStatusQuery(appointmentRecordEntity.getAppointmentId(), appointmentRecordEntity.getChannelCode());
                if (null != appointOrderStatusRes && AppointOrderPayStatusCodeEnum.PAY_COMPLETED.getValue().equals(appointOrderStatusRes.getTradePayCode())) {
                    isPayed = true;
                    log.info("================\u6302\u53f7\u652f\u4ed8\u8ba2\u5355\u72b6\u6001\u67e5\u8be2\u6210\u529f==============");
                    break;
                }
                if (--times <= 50) {
                    Thread.sleep(30000L);
                    continue;
                }
                Thread.sleep(1000L);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (isPayed) {
            appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.PAY.getValue());
            appointmentRecordEntity.setPayAccdate(appointOrderStatusRes.getTradeDate() + " " + appointOrderStatusRes.getTradeTime());
            appointmentRecordEntity.setPayTransationId(appointOrderStatusRes.getTradeNo());
            this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecordEntity);
            AppointmentPayorderEntity appointmentPayorderEntity = this.appointmentPayOrderMapper.getBySysAppointmentId(appointmentRecordEntity.getSysAppointmentId());
            if (null != appointmentPayorderEntity) {
                appointmentPayorderEntity.setOrderStatus(Byte.valueOf(Byte.parseByte("3")));
                this.appointmentPayOrderMapper.updateByPrimaryKeySelective(appointmentPayorderEntity);
            }
        }
    }

    private GetPayRecordsResItems getCompletedPayInfo(GetRecipelReq getRecipelReq, String hosId) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        gatewayRequest.setBody((Object)getRecipelReq);
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        gatewayRequest.setKeyWord("GetRecipelReq");
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setChannel(hosId);
        gatewayRequest.setChannelName(ChannelEnum.MANAGER.getValue());
        log.info("\u3010his\u67e5\u8be2\u5df2\u7f34\u8d39\u8bb0\u5f554905\u3011\u8bf7\u6c42\u53c2\u6570\uff1a" + gatewayRequest);
        GatewayResponse gatewayResponse = this.outpatientPaymentApi.getCompletedPayInfo(gatewayRequest);
        log.info("\u3010his\u67e5\u8be2\u5df2\u7f34\u8d39\u8bb0\u5f554905\u3011\u8fd4\u56de\u53c2\u6570\uff1a" + gatewayResponse);
        if (gatewayResponse == null) {
            log.error("\u3010his\u67e5\u8be2\u5df2\u7f34\u8d39\u8bb0\u5f554905\u3011getCompletedPayInfo -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            return null;
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u3010his\u67e5\u8be2\u5df2\u7f34\u8d39\u8bb0\u5f554905\u3011 getCompletedPayInfo -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            return null;
        }
        if (gatewayResponse.getData() == null) {
            log.error("\u3010his\u67e5\u8be2\u5df2\u7f34\u8d39\u8bb0\u5f554905\u3011 getCompletedPayInfo -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            return null;
        }
        if (CollectionUtils.isEmpty((Collection)((GetRecipelRes)gatewayResponse.getData()).getItems())) {
            log.error("\u3010his\u67e5\u8be2\u5df2\u7f34\u8d39\u8bb0\u5f554905\u3011 getCompletedPayInfo -> his\u67e5\u8be2\u6570\u636e\u4e3a\u7a7a");
            return null;
        }
        ArrayList payRecordsResItems = ((GetRecipelRes)gatewayResponse.getData()).getItems();
        return (GetPayRecordsResItems)payRecordsResItems.get(0);
    }
}

