/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.his.api.AppointApi;
import com.ebaiyihui.his.api.ScheduleApi;
import com.ebaiyihui.his.pojo.vo.appoint.GetAppointRecordReq;
import com.ebaiyihui.his.pojo.vo.appoint.GetAppointRecordRes;
import com.ebaiyihui.his.pojo.vo.base.GatewayRequest;
import com.ebaiyihui.his.pojo.vo.base.GatewayResponse;
import com.ebaiyihui.his.pojo.vo.schedule.GetScheduleReqVO;
import com.ebaiyihui.his.pojo.vo.schedule.GetScheduleResVO;
import com.ebaiyihui.his.pojo.vo.schedule.items.GetScheduleResItems;
import com.ebaiyihui.wisdommedical.common.constant.ProPropertiesConstant;
import com.ebaiyihui.wisdommedical.exception.BdHealthException;
import com.ebaiyihui.wisdommedical.mapper.AppointmentRecordMapper;
import com.ebaiyihui.wisdommedical.mapper.DeptCategoryMapper;
import com.ebaiyihui.wisdommedical.mapper.DeptRecordMapper;
import com.ebaiyihui.wisdommedical.mapper.DoctorRecordMapper;
import com.ebaiyihui.wisdommedical.model.AppointmentRecordEntity;
import com.ebaiyihui.wisdommedical.model.DeptCategoryEntity;
import com.ebaiyihui.wisdommedical.model.DoctorRecordEntity;
import com.ebaiyihui.wisdommedical.pojo.bdqueryvo.BdDoctorScheduleReqVo;
import com.ebaiyihui.wisdommedical.pojo.bdqueryvo.BdDoctorScheduleResVo;
import com.ebaiyihui.wisdommedical.pojo.bdqueryvo.BdDoctorScheduleReslist;
import com.ebaiyihui.wisdommedical.pojo.bdqueryvo.DoctorNumberSourceReqVo;
import com.ebaiyihui.wisdommedical.pojo.bdqueryvo.DoctorResVo;
import com.ebaiyihui.wisdommedical.pojo.bdqueryvo.DoctorScheduleResVo;
import com.ebaiyihui.wisdommedical.pojo.bdqueryvo.GetArrivalDataReqVo;
import com.ebaiyihui.wisdommedical.pojo.bdqueryvo.HospitalBasicInforReqVo;
import com.ebaiyihui.wisdommedical.pojo.bdqueryvo.HospitalBasicInforResVo;
import com.ebaiyihui.wisdommedical.pojo.bdqueryvo.HospitalDeptResVo;
import com.ebaiyihui.wisdommedical.pojo.bdqueryvo.HospitalDoctorReqVo;
import com.ebaiyihui.wisdommedical.pojo.bdqueryvo.HospitalScheduleReqVo;
import com.ebaiyihui.wisdommedical.pojo.bdqueryvo.HospitalScheduleResVo;
import com.ebaiyihui.wisdommedical.pojo.bdqueryvo.Schedule;
import com.ebaiyihui.wisdommedical.pojo.bdqueryvo.ScheduleResItems;
import com.ebaiyihui.wisdommedical.pojo.bdqueryvo.SourceInformation;
import com.ebaiyihui.wisdommedical.pojo.bdqueryvo.SourceList;
import com.ebaiyihui.wisdommedical.pojo.bdqueryvo.SourceListInformation;
import com.ebaiyihui.wisdommedical.pojo.bdvo.BaiduCommonResVo;
import com.ebaiyihui.wisdommedical.pojo.dto.GetDocInfoRes;
import com.ebaiyihui.wisdommedical.pojo.vo.GetDoctorScheduleVoReq;
import com.ebaiyihui.wisdommedical.service.BaiduDataQueryService;
import com.ebaiyihui.wisdommedical.service.DoctorService;
import com.ebaiyihui.wisdommedical.util.CredSignUtils;
import com.ebaiyihui.wisdommedical.util.DateUtils;
import com.ebaiyihui.wisdommedical.util.GetDoctorInfoUtil;
import com.ebaiyihui.wisdommedical.util.MD5Utils;
import com.ebaiyihui.wisdommedical.util.SnowflakeIdWorker;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class BaiduDataQueryServiceImpl
implements BaiduDataQueryService {
    private static final Logger log = LoggerFactory.getLogger(BaiduDataQueryServiceImpl.class);
    @Autowired
    private AppointApi appointApi;
    @Autowired
    private AppointmentRecordMapper appointmentRecordMapper;
    @Autowired
    private ScheduleApi scheduleApi;
    @Autowired
    private ProPropertiesConstant propertiesConstant;
    @Autowired
    private DeptRecordMapper deptRecordMapper;
    @Autowired
    private DeptCategoryMapper deptCategoryMapper;
    @Autowired
    private DoctorRecordMapper doctorRecordMapper;
    @Autowired
    private GetDoctorInfoUtil getDoctorInfoUtil;
    @Autowired
    private SnowflakeIdWorker snowflakeIdWorker;
    @Autowired
    private ProPropertiesConstant constant;
    @Autowired
    private DoctorService doctorService;

    public BaiduCommonResVo<BdDoctorScheduleResVo> doctorSchedule(BdDoctorScheduleReqVo bdDoctorScheduleReqVo) throws BdHealthException {
        if (null == bdDoctorScheduleReqVo.getApp_id() || !bdDoctorScheduleReqVo.getApp_id().equals(this.constant.getBaiduAppKey())) {
            return BaiduCommonResVo.error((String)"app_id\u6709\u8bef");
        }
        HashMap<String, String> req = new HashMap<String, String>();
        req.put("depart_id", bdDoctorScheduleReqVo.getDepart_id());
        req.put("expert_id", bdDoctorScheduleReqVo.getExpert_id());
        req.put("app_id", bdDoctorScheduleReqVo.getApp_id());
        req.put("timestamp", bdDoctorScheduleReqVo.getTimestamp());
        CredSignUtils.getSign(req, (String)"vdyceugd6736737834721v1v1vnnn8789379");
        List doctorDeptRecord = this.doctorService.getDoctorDeptRecord(bdDoctorScheduleReqVo.getExpert_id(), "79");
        if (CollectionUtils.isEmpty((Collection)doctorDeptRecord)) {
            return BaiduCommonResVo.error((String)"\u672a\u67e5\u8be2\u5230\u76f8\u5173\u6392\u73ed\u4fe1\u606f");
        }
        log.info("\u533b\u751f\u5750\u8bca\u79d1\u5ba4\u6709" + JSON.toJSONString((Object)doctorDeptRecord));
        BdDoctorScheduleResVo bdDoctorScheduleResVo = new BdDoctorScheduleResVo();
        ArrayList<BdDoctorScheduleReslist> list = new ArrayList<BdDoctorScheduleReslist>();
        for (DoctorRecordEntity doctorRecordEntity : doctorDeptRecord) {
            List scheduleListAll = new ArrayList();
            GetDoctorScheduleVoReq getDoctorScheduleVoReq = new GetDoctorScheduleVoReq();
            BdDoctorScheduleReslist bdDoctorScheduleReslist = new BdDoctorScheduleReslist();
            getDoctorScheduleVoReq.setDoctorCode(bdDoctorScheduleReqVo.getExpert_id());
            getDoctorScheduleVoReq.setDeptCode(doctorRecordEntity.getDeptCode());
            getDoctorScheduleVoReq.setStartDate(DateUtils.dateToSimpleString((Date)DateUtils.getCurrentDate()));
            getDoctorScheduleVoReq.setEndDate(DateUtils.getStringDateAfter((String)getDoctorScheduleVoReq.getStartDate(), (Integer)10));
            scheduleListAll = this.GetscheduleListAll(getDoctorScheduleVoReq);
            if (CollectionUtils.isEmpty(scheduleListAll)) {
                return BaiduCommonResVo.error((String)"\u672a\u67e5\u8be2\u5230\u76f8\u5173\u6392\u73ed\u4fe1\u606f");
            }
            bdDoctorScheduleResVo.setDepart_id(bdDoctorScheduleReqVo.getDepart_id());
            bdDoctorScheduleResVo.setDoc_id(bdDoctorScheduleReqVo.getExpert_id());
            bdDoctorScheduleResVo.setHos_id("");
            List<ScheduleResItems> schedule = new ArrayList();
            for (GetScheduleResItems getScheduleResItems : scheduleListAll) {
                bdDoctorScheduleResVo.setDoc_name(getScheduleResItems.getDocName());
                bdDoctorScheduleReslist.setDepart(getScheduleResItems.getLocName());
                ScheduleResItems scheduleResItems = new ScheduleResItems();
                scheduleResItems.setCount(getScheduleResItems.getRegAvailable());
                scheduleResItems.setWeek(DateUtils.getWeekChinese((String)getScheduleResItems.getAdmDate()));
                scheduleResItems.setDate(getScheduleResItems.getAdmDate());
                schedule.add(scheduleResItems);
            }
            schedule = schedule.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<ScheduleResItems>(Comparator.comparing(ScheduleResItems::getDate))), ArrayList::new));
            bdDoctorScheduleReslist.setSchedule(schedule);
            list.add(bdDoctorScheduleReslist);
        }
        bdDoctorScheduleResVo.setList(list);
        return BaiduCommonResVo.success((Object)bdDoctorScheduleResVo);
    }

    private List<GetScheduleResItems> GetscheduleListAll(GetDoctorScheduleVoReq getDoctorScheduleVoReq) {
        GatewayRequest gatewayRequest;
        List scheduleResItemsList;
        ArrayList<GetScheduleResItems> scheduleListAll = new ArrayList<GetScheduleResItems>();
        GatewayRequest dayGatewayRequest = this.buildDaySchduleReq(getDoctorScheduleVoReq);
        List dayScheduleResItemsList = this.getDocDaySchedule(dayGatewayRequest);
        if (!CollectionUtils.isEmpty((Collection)dayScheduleResItemsList)) {
            scheduleListAll.addAll(dayScheduleResItemsList);
        }
        if (!CollectionUtils.isEmpty((Collection)(scheduleResItemsList = this.getDocSchedule(gatewayRequest = this.buildGetDoctorScheduleGatewayReq(getDoctorScheduleVoReq))))) {
            scheduleListAll.addAll(scheduleResItemsList);
        }
        return scheduleListAll;
    }

    private List<GetScheduleResItems> getDocDaySchedule(GatewayRequest<GetScheduleReqVO> gatewayRequest) {
        log.info("\u67e5\u8be2\u7b2c\u4e00\u5929\u7684\u533b\u751f\u6392\u73ed\u5165\u53c2" + JSON.toJSONString(gatewayRequest));
        GatewayResponse gatewayResponse = this.scheduleApi.getDoctorSchedule(gatewayRequest);
        log.info("\u67e5\u8be2\u7b2c\u4e00\u5929\u7684\u533b\u751f\u6392\u73ed\u51fa\u53c2" + JSON.toJSONString((Object)gatewayResponse));
        if (gatewayResponse == null) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u8bf7\u6c42\u65e0\u54cd\u5e94" + gatewayResponse.getMsg());
            return new ArrayList<GetScheduleResItems>();
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            return new ArrayList<GetScheduleResItems>();
        }
        GetScheduleResVO getScheduleResVO = (GetScheduleResVO)gatewayResponse.getData();
        if (getScheduleResVO == null) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38" + gatewayResponse.getMsg());
            return new ArrayList<GetScheduleResItems>();
        }
        List getScheduleResItemsList = getScheduleResVO.getItems();
        if (CollectionUtils.isEmpty((Collection)getScheduleResItemsList)) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u65e0\u6392\u73ed\u4fe1\u606f" + gatewayResponse.getMsg());
            return new ArrayList<GetScheduleResItems>();
        }
        return getScheduleResItemsList;
    }

    private GatewayRequest<GetScheduleReqVO> buildGetDoctorScheduleGatewayReq(GetDoctorScheduleVoReq getDoctorScheduleVoReq) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        GetScheduleReqVO getScheduleReqVO = new GetScheduleReqVO();
        getScheduleReqVO.setBgDate(DateUtils.getNextDayToString((String)getDoctorScheduleVoReq.getStartDate()));
        getScheduleReqVO.setEdDate(getDoctorScheduleVoReq.getEndDate());
        getScheduleReqVO.setLocCode(getDoctorScheduleVoReq.getDeptCode());
        getScheduleReqVO.setDocCode(getDoctorScheduleVoReq.getDoctorCode());
        String hisId = this.getHosId(getDoctorScheduleVoReq.getDeptCode());
        getScheduleReqVO.setScheduleCode(hisId);
        gatewayRequest.setBody((Object)getScheduleReqVO);
        gatewayRequest.setChannelName(getDoctorScheduleVoReq.getChannelName());
        gatewayRequest.setChannel(getDoctorScheduleVoReq.getChannelName());
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("getSchedule");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    private GatewayRequest<GetScheduleReqVO> buildDaySchduleReq(GetDoctorScheduleVoReq getDoctorScheduleVoReq) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        GetScheduleReqVO getScheduleReqVO = new GetScheduleReqVO();
        getScheduleReqVO.setBgDate(getDoctorScheduleVoReq.getStartDate());
        getScheduleReqVO.setEdDate(getDoctorScheduleVoReq.getStartDate());
        getScheduleReqVO.setLocCode(getDoctorScheduleVoReq.getDeptCode());
        getScheduleReqVO.setDocCode(getDoctorScheduleVoReq.getDoctorCode());
        String hisId = this.getHosId(getDoctorScheduleVoReq.getDeptCode());
        getScheduleReqVO.setScheduleCode(hisId);
        gatewayRequest.setBody((Object)getScheduleReqVO);
        gatewayRequest.setChannelName(getDoctorScheduleVoReq.getChannelName());
        gatewayRequest.setChannel(getDoctorScheduleVoReq.getChannelName());
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("getDaySchedule");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    private String getHosId(String deptCode) {
        String hospitalAreaCode = this.deptRecordMapper.getHospitalAreaCode(deptCode);
        String hosId = "NCDXDEFSYY";
        if (null != hospitalAreaCode && hospitalAreaCode.equals("7902")) {
            return "NDEFYHJZYQ";
        }
        return hosId;
    }

    public BaiduCommonResVo<HospitalBasicInforResVo> hospitalBasicInfor(HospitalBasicInforReqVo hospitalBasicInforReqVo) throws BdHealthException {
        HospitalBasicInforResVo HospitalBasicInforResVo2 = new HospitalBasicInforResVo();
        HashMap<String, String> map1 = new HashMap<String, String>();
        map1.put("value", "0791-86120120");
        map1.put("type", "\u4e1c\u6e56\u9662\u533a\u54a8\u8be2\u7535\u8bdd");
        HashMap<String, String> map2 = new HashMap<String, String>();
        map2.put("value", "0791-87311120");
        map2.put("type", "\u7ea2\u89d2\u6d32\u9662\u533a\u54a8\u8be2\u7535\u8bdd");
        ArrayList<HashMap<String, String>> phones = new ArrayList<HashMap<String, String>>();
        phones.add(map1);
        phones.add(map2);
        HospitalBasicInforResVo2.setPhone(phones);
        ArrayList<String> hospitalTags = new ArrayList<String>();
        hospitalTags.add("\u5d07\u5fb7\u4f51\u6c11");
        HospitalBasicInforResVo2.setHospitalTag(hospitalTags);
        ArrayList<String> hospitalSpecDeps = new ArrayList<String>();
        hospitalSpecDeps.add("\u7532\u72b6\u817a\u5916\u79d1");
        hospitalSpecDeps.add("\u795e\u7ecf\u5916\u79d1");
        hospitalSpecDeps.add("\u773c\u79d1");
        hospitalSpecDeps.add("\u5185\u5206\u6ccc\u79d1");
        hospitalSpecDeps.add("\u9aa8\u79d1");
        HospitalBasicInforResVo2.setHospitalSpecDeps(hospitalSpecDeps);
        ArrayList<HospitalBasicInforResVo.HospitalAreasDTO> hospitalAreas = new ArrayList<HospitalBasicInforResVo.HospitalAreasDTO>();
        HospitalBasicInforResVo.HospitalAreasDTO HospitalAreasDTO2 = new HospitalBasicInforResVo.HospitalAreasDTO();
        HospitalAreasDTO2.setName("\u7ea2\u89d2\u6d32\u9662\u533a");
        HospitalAreasDTO2.setAreaCode("2");
        HospitalAreasDTO2.setAddress("\u7ea2\u8c37\u6ee9\u533a\u5b66\u5e9c\u5927\u9053566\u53f7");
        hospitalAreas.add(HospitalAreasDTO2);
        HospitalBasicInforResVo.HospitalAreasDTO HospitalAreasDTO22 = new HospitalBasicInforResVo.HospitalAreasDTO();
        HospitalAreasDTO22.setName("\u4e1c\u6e56\u9662\u533a");
        HospitalAreasDTO22.setAreaCode("1");
        HospitalAreasDTO22.setAddress("\u6c5f\u897f\u7701\u5357\u660c\u5e02\u6c11\u5fb7\u8def1\u53f7");
        hospitalAreas.add(HospitalAreasDTO22);
        HospitalBasicInforResVo2.setHospitalAreas(hospitalAreas);
        return BaiduCommonResVo.success((Object)HospitalBasicInforResVo2);
    }

    public BaiduCommonResVo<List<HospitalDeptResVo>> getHospitalDept(HospitalBasicInforReqVo hospitalBasicInforReqVo) {
        ArrayList hospitalDeptResVoList = new ArrayList();
        List firstDeptList = this.deptCategoryMapper.selectAllDept();
        firstDeptList.stream().forEach(firstDept -> {
            HospitalDeptResVo hospitalDeptResVo = new HospitalDeptResVo();
            hospitalDeptResVo.setDepartmentCode(firstDept.getDeptCategoryCode());
            hospitalDeptResVo.setDepartmentLevel("1");
            hospitalDeptResVo.setDepartmentName(firstDept.getDeptCategoryName());
            hospitalDeptResVoList.add(hospitalDeptResVo);
        });
        List firstDeptIds = firstDeptList.stream().map(firstDept -> firstDept.getId()).collect(Collectors.toList());
        List deptRecordList = this.deptRecordMapper.selectSecondByFirstDeptId(firstDeptIds);
        deptRecordList.stream().forEach(deptRecord -> {
            HospitalDeptResVo hospitalDeptResVo = new HospitalDeptResVo();
            hospitalDeptResVo.setDepartmentDesc(deptRecord.getIntroduction());
            hospitalDeptResVo.setDepartmentLevel("2");
            hospitalDeptResVo.setDepartmentCode(deptRecord.getDeptCode());
            hospitalDeptResVo.setDepartmentName(deptRecord.getDeptName());
            hospitalDeptResVo.setAreaCode(deptRecord.getHospitalAreaCode());
            DeptCategoryEntity firstDept = firstDeptList.stream().filter(o -> o.getId() == deptRecord.getFirstDeptId()).findFirst().get();
            hospitalDeptResVo.setParentDepartmentCode(firstDept.getDeptCategoryCode());
            hospitalDeptResVo.setParentDepartmentName(firstDept.getDeptCategoryName());
            hospitalDeptResVoList.add(hospitalDeptResVo);
        });
        return BaiduCommonResVo.success(hospitalDeptResVoList);
    }

    public BaiduCommonResVo<List<DoctorResVo>> getHospitalDoctor(HospitalDoctorReqVo hospitalBasicInforReqVo) throws BdHealthException {
        ArrayList doctorResVoList = new ArrayList();
        List allDoctor = this.doctorRecordMapper.getAllDoctor(hospitalBasicInforReqVo.getDepartmentCode());
        allDoctor = allDoctor.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<DoctorRecordEntity>(Comparator.comparing(DoctorRecordEntity::getDocCode))), ArrayList::new));
        allDoctor.stream().forEach(doctor -> {
            BaseResponse doctorBasicInfoFromHis = this.doctorService.getDoctorBasicInfoFromHis(doctor.getDocCode(), doctor.getDeptCode());
            if (doctorBasicInfoFromHis.isSuccess()) {
                GetDocInfoRes data = (GetDocInfoRes)doctorBasicInfoFromHis.getData();
                DoctorResVo doctorResVo = new DoctorResVo();
                doctorResVo.setDoctorCode(data.getDoctor_id());
                doctorResVo.setDoctorName(data.getDoctor_name());
                doctorResVo.setAreaCode(doctor.getHospitalAreaCode());
                doctorResVo.setDepartmentCode(doctor.getDeptCode());
                doctorResVo.setDepartmentName(doctor.getDeptName());
                doctorResVo.setServiceApntStatus(1);
                doctorResVo.setTitleTeachCode(data.getDoctor_type());
                doctorResVo.setGoodat(data.getPresentation());
                doctorResVo.setIntro(data.getContent());
                doctorResVo.setHeadImgUrl(data.getImage_url());
                doctorResVo.setTitleTeachName(data.getDoctor_type());
                doctorResVoList.add(doctorResVo);
            }
        });
        return BaiduCommonResVo.success(doctorResVoList);
    }

    public BaiduCommonResVo<HospitalScheduleResVo> getDeptSchedule(HospitalScheduleReqVo hospitalScheduleReqVo) throws BdHealthException {
        HospitalScheduleResVo hospitalScheduleResVo = new HospitalScheduleResVo();
        List getScheduleResVO = new ArrayList();
        GetDoctorScheduleVoReq getDoctorScheduleVoReq = new GetDoctorScheduleVoReq();
        getDoctorScheduleVoReq.setDeptCode(hospitalScheduleReqVo.getDepartmentCode());
        getDoctorScheduleVoReq.setStartDate(DateUtils.dateToSimpleString((Date)DateUtils.getCurrentDate()));
        getDoctorScheduleVoReq.setEndDate(DateUtils.getStringDateAfter((String)getDoctorScheduleVoReq.getStartDate(), (Integer)10));
        getScheduleResVO = this.GetscheduleListAll(getDoctorScheduleVoReq);
        hospitalScheduleResVo.setAreaCode(((GetScheduleResItems)getScheduleResVO.get(0)).getHospitalAreaCode());
        hospitalScheduleResVo.setDepartmentCode(((GetScheduleResItems)getScheduleResVO.get(0)).getLocCode());
        hospitalScheduleResVo.setDepartmentName(((GetScheduleResItems)getScheduleResVO.get(0)).getDocName());
        Map<String, List<GetScheduleResItems>> doctorSchedule = getScheduleResVO.stream().collect(Collectors.groupingBy(GetScheduleResItems::getDocCode));
        ArrayList<Schedule> schedules = new ArrayList<Schedule>();
        for (String key : doctorSchedule.keySet()) {
            Schedule schedule = new Schedule();
            schedule.setDoctorCode(key);
            schedule.setDoctorName(doctorSchedule.get(key).get(0).getDocName());
            List<GetScheduleResItems> items = doctorSchedule.get(key);
            ArrayList sourceLists = new ArrayList();
            items.stream().forEach(item -> {
                SourceList sourceList = new SourceList();
                sourceList.setType(item.getScheduleLevelName());
                sourceList.setDate(item.getAdmDate());
                sourceList.setAmount(item.getRegTotal());
                sourceList.setStatus(Integer.valueOf(item.getScheduleStatus().equals("2") ? 3 : (item.getRegAvailable() == 0 ? 2 : 1)));
                String admTimeRange = item.getAdmTimeRange();
                if (admTimeRange.equals("1")) {
                    sourceList.setTime(Long.valueOf(DateUtils.stringToTimestamp((String)(item.getAdmDate() + " 08:00:00")).getTime()));
                    sourceList.setStopRegisterDate(Long.valueOf(DateUtils.stringToTimestamp((String)(item.getAdmDate() + " 12:00:00")).getTime()));
                    sourceList.setInvalidDate(Long.valueOf(DateUtils.stringToTimestamp((String)(item.getAdmDate() + " 12:00:00")).getTime()));
                }
                if (admTimeRange.equals("2")) {
                    sourceList.setTime(Long.valueOf(DateUtils.stringToTimestamp((String)(item.getAdmDate() + " 12:00:00")).getTime()));
                    sourceList.setStopRegisterDate(Long.valueOf(DateUtils.stringToTimestamp((String)(item.getAdmDate() + " 17:30:00")).getTime()));
                    sourceList.setInvalidDate(Long.valueOf(DateUtils.stringToTimestamp((String)(item.getAdmDate() + " 17:30:00")).getTime()));
                }
                if (admTimeRange.equals("3")) {
                    sourceList.setTime(Long.valueOf(DateUtils.stringToTimestamp((String)(item.getAdmDate() + " 08:00:00")).getTime()));
                    sourceList.setStopRegisterDate(Long.valueOf(DateUtils.stringToTimestamp((String)(item.getAdmDate() + " 17:30:00")).getTime()));
                    sourceList.setInvalidDate(Long.valueOf(DateUtils.stringToTimestamp((String)(item.getAdmDate() + " 17:30:00")).getTime()));
                }
                sourceList.setPrice(new Integer(BaiduDataQueryServiceImpl.formatAmtY2F((String)item.getDiagFee())));
                sourceList.setReferralPrice(new Integer(BaiduDataQueryServiceImpl.formatAmtY2F((String)item.getDiagFee())));
                sourceList.setAppointType(item.getScheduleType().toString());
                sourceLists.add(sourceList);
            });
            schedule.setList(sourceLists);
            schedules.add(schedule);
        }
        hospitalScheduleResVo.setSchedule(schedules);
        return BaiduCommonResVo.success((Object)hospitalScheduleResVo);
    }

    public BaiduCommonResVo<DoctorScheduleResVo> getDoctorSchedule(DoctorNumberSourceReqVo doctorNumberSourceReqVo) throws BdHealthException {
        DoctorScheduleResVo hospitalScheduleResVo = new DoctorScheduleResVo();
        GatewayRequest gatewayRequest = this.buildGetScheduleGatewayReq(doctorNumberSourceReqVo.getDepartmentCode(), doctorNumberSourceReqVo.getDoctorCode());
        log.info("\u5b9e\u65f6\u83b7\u53d6\u5341\u65e5\u6392\u73ed\u5165\u53c2" + JSON.toJSONString((Object)gatewayRequest));
        GatewayResponse gatewayResponse = this.scheduleApi.getDoctorSchedule(gatewayRequest);
        log.info("\u5b9e\u65f6\u83b7\u53d6\u5341\u65e5\u6392\u73ed\u51fa\u53c2" + JSON.toJSONString((Object)gatewayResponse));
        if (gatewayResponse == null) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            return BaiduCommonResVo.error((String)"his\u8bf7\u6c42\u65e0\u54cd\u5e94");
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            return BaiduCommonResVo.error((String)"his\u67e5\u8be2\u5931\u8d25");
        }
        if (gatewayResponse.getData() == null) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            return BaiduCommonResVo.error((String)"his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
        }
        GetScheduleResVO getScheduleResVO = (GetScheduleResVO)gatewayResponse.getData();
        if (CollectionUtils.isEmpty((Collection)getScheduleResVO.getItems())) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u65e0\u6392\u73ed\u4fe1\u606f");
            return BaiduCommonResVo.error((String)"\u65e0\u6392\u73ed\u4fe1\u606f");
        }
        hospitalScheduleResVo.setDoctorCode(((GetScheduleResItems)getScheduleResVO.getItems().get(0)).getDocCode());
        hospitalScheduleResVo.setDoctorName(((GetScheduleResItems)getScheduleResVO.getItems().get(0)).getDocName());
        List scheduleItems = getScheduleResVO.getItems();
        Map<String, List<GetScheduleResItems>> doctorSchedule = scheduleItems.stream().collect(Collectors.groupingBy(GetScheduleResItems::getLocCode));
        ArrayList<SourceInformation> schedules = new ArrayList<SourceInformation>();
        for (String key : doctorSchedule.keySet()) {
            SourceInformation schedule = new SourceInformation();
            schedule.setAreaCode(doctorSchedule.get(key).get(0).getHospitalAreaCode());
            schedule.setDepartmentCode(key);
            schedule.setDepartmentName(doctorSchedule.get(key).get(0).getLocName());
            List<GetScheduleResItems> items = doctorSchedule.get(key);
            ArrayList sourceLists = new ArrayList();
            items.stream().forEach(item -> {
                SourceListInformation sourceList = new SourceListInformation();
                sourceList.setType(item.getScheduleLevelName());
                sourceList.setDate(item.getAdmDate());
                sourceList.setAmount(item.getRegTotal());
                sourceList.setStatus(Integer.valueOf(item.getScheduleStatus().equals("2") ? 3 : (item.getRegAvailable() == 0 ? 2 : 1)));
                String admTimeRange = item.getAdmTimeRange();
                if (admTimeRange.equals("1")) {
                    sourceList.setTime(Long.valueOf(DateUtils.stringToTimestamp((String)(item.getAdmDate() + " 08:00:00")).getTime()));
                    sourceList.setStopRegisterDate(Long.valueOf(DateUtils.stringToTimestamp((String)(item.getAdmDate() + " 12:00:00")).getTime()));
                    sourceList.setInvalidDate(Long.valueOf(DateUtils.stringToTimestamp((String)(item.getAdmDate() + " 12:00:00")).getTime()));
                }
                if (admTimeRange.equals("2")) {
                    sourceList.setTime(Long.valueOf(DateUtils.stringToTimestamp((String)(item.getAdmDate() + " 12:00:00")).getTime()));
                    sourceList.setStopRegisterDate(Long.valueOf(DateUtils.stringToTimestamp((String)(item.getAdmDate() + " 17:30:00")).getTime()));
                    sourceList.setInvalidDate(Long.valueOf(DateUtils.stringToTimestamp((String)(item.getAdmDate() + " 17:30:00")).getTime()));
                }
                if (admTimeRange.equals("3")) {
                    sourceList.setTime(Long.valueOf(DateUtils.stringToTimestamp((String)(item.getAdmDate() + " 08:00:00")).getTime()));
                    sourceList.setStopRegisterDate(Long.valueOf(DateUtils.stringToTimestamp((String)(item.getAdmDate() + " 17:30:00")).getTime()));
                    sourceList.setInvalidDate(Long.valueOf(DateUtils.stringToTimestamp((String)(item.getAdmDate() + " 17:30:00")).getTime()));
                }
                sourceList.setPrice(new Integer(BaiduDataQueryServiceImpl.formatAmtY2F((String)item.getDiagFee())));
                sourceList.setReferralPrice(new Integer(BaiduDataQueryServiceImpl.formatAmtY2F((String)item.getDiagFee())));
                sourceList.setAppointType(item.getScheduleType().toString());
                sourceLists.add(sourceList);
            });
            schedule.setList(sourceLists);
            schedules.add(schedule);
        }
        hospitalScheduleResVo.setSchedule(schedules);
        return BaiduCommonResVo.success((Object)hospitalScheduleResVo);
    }

    public BaiduCommonResVo<Map<String, Integer>> getArrivalData(GetArrivalDataReqVo getArrivalDataReqVo) {
        if (null == getArrivalDataReqVo.getSn() || !getArrivalDataReqVo.getSn().equals(MD5Utils.string2MD5((String)this.constant.getBaiduAppKey()))) {
            return BaiduCommonResVo.error((String)"sn\u6709\u8bef");
        }
        if (null == getArrivalDataReqVo.getAd() || !getArrivalDataReqVo.getAd().equals(this.constant.getBaiduAppId())) {
            return BaiduCommonResVo.error((String)"Ad\u6709\u8bef");
        }
        String stData = DateUtils.getStrBystrTimestamp((String)getArrivalDataReqVo.getSt());
        String edData = DateUtils.getStrBystrTimestamp((String)getArrivalDataReqVo.getEt());
        HashMap<String, Integer> arrivalDataMapRes = new HashMap<String, Integer>();
        List list = getArrivalDataReqVo.getI();
        for (String credSign : list) {
            List appointmentRecordEntityList = this.appointmentRecordMapper.selectByCredSign(credSign, stData, edData);
            log.info("\u51fa\u53c2\uff1aappointmentRecordEntityList:" + JSONObject.toJSONString((Object)appointmentRecordEntityList));
            if (null == appointmentRecordEntityList || appointmentRecordEntityList.size() < 1) {
                arrivalDataMapRes.put(credSign, 0);
                continue;
            }
            AppointmentRecordEntity appointmentRecordEntity = (AppointmentRecordEntity)appointmentRecordEntityList.get(0);
            GatewayRequest gatewayRequest = new GatewayRequest();
            GetAppointRecordReq getAppointRecordReq = new GetAppointRecordReq();
            getAppointRecordReq.setCardNo(appointmentRecordEntity.getPatientCardNo());
            getAppointRecordReq.setEndDate(edData);
            getAppointRecordReq.setStartDate(stData);
            gatewayRequest.setBody((Object)getAppointRecordReq);
            String hisId = this.getHosId(appointmentRecordEntity.getDeptCode());
            gatewayRequest.setChannel(hisId);
            gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
            log.info("\u9884\u7ea6 \u8bf7\u6c42his\u5165\u53c2\uff1agatewayRequest:{}", (Object)gatewayRequest);
            GatewayResponse gatewayResponse = this.appointApi.getAppointRecord(gatewayRequest);
            log.info("\u9884\u7ea6 \u8bf7\u6c42his\u51fa\u53c2\uff1aConfirmRegisterRes:{}", gatewayResponse.getData());
            if (gatewayResponse == null) {
                return BaiduCommonResVo.error((String)"\u67e5\u8be2his\u6302\u53f7\u8bb0\u5f55\u5931\u8d25");
            }
            if (null != gatewayResponse.getData()) {
                List items = ((GetAppointRecordRes)gatewayResponse.getData()).getItems();
                items.removeIf(o -> o.getIsPreReg().equals("N"));
                if (items.size() > 0) {
                    arrivalDataMapRes.put(appointmentRecordEntity.getCredSign(), 1);
                    continue;
                }
                arrivalDataMapRes.put(appointmentRecordEntity.getCredSign(), 0);
                continue;
            }
            arrivalDataMapRes.put(appointmentRecordEntity.getCredSign(), 0);
        }
        return BaiduCommonResVo.success(arrivalDataMapRes);
    }

    private GatewayRequest<GetScheduleReqVO> buildGetScheduleGatewayReq(String departmentCode, String docCode) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        GetScheduleReqVO getScheduleReqVO = new GetScheduleReqVO();
        Date startDate = DateUtils.getCurrentDate();
        getScheduleReqVO.setBgDate(DateUtils.dateToSimpleString((Date)startDate));
        getScheduleReqVO.setEdDate(DateUtils.dateToSimpleString((Date)DateUtils.getDateAfter((Date)startDate, (int)10)));
        getScheduleReqVO.setLocCode(departmentCode);
        if (!Objects.isNull(docCode)) {
            getScheduleReqVO.setDocCode(docCode);
        }
        gatewayRequest.setBody((Object)getScheduleReqVO);
        gatewayRequest.setChannelName("baidu");
        gatewayRequest.setChannel("BD");
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("getSchedule");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    public static String formatAmtY2F(String amtY) {
        if (amtY == null || "".equals(amtY.trim()) || "0".equals(amtY)) {
            return "0";
        }
        if (amtY.indexOf(",") != -1) {
            amtY = amtY.replace(",", "");
        }
        amtY = new DecimalFormat("0.00").format(new BigDecimal(amtY));
        int index = amtY.indexOf(".");
        int len = amtY.length();
        StringBuffer amtF = new StringBuffer();
        if (index == -1) {
            amtF.append(amtY).append("00");
        } else if (len - index == 1) {
            amtF.append(Long.parseLong(amtY.replace(".", ""))).append("00");
        } else if (len - index == 2) {
            amtF.append(Long.parseLong(amtY.replace(".", ""))).append("0");
        } else {
            amtF.append(Long.parseLong(amtY.replace(".", "")));
        }
        return amtF.toString();
    }

    private List<GetScheduleResItems> getDocSchedule(GatewayRequest<GetScheduleReqVO> gatewayRequest) {
        log.info("\u67e5\u8be2\u533b\u751f\u9884\u7ea6\u6392\u73ed\u5165\u53c2" + JSON.toJSONString(gatewayRequest));
        GatewayResponse gatewayResponse = this.scheduleApi.getDoctorSchedule(gatewayRequest);
        log.info("\u67e5\u8be2\u533b\u751f\u9884\u7ea6\u6392\u73ed\u51fa\u53c2" + JSON.toJSONString((Object)gatewayResponse));
        if (gatewayResponse == null) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u8bf7\u6c42\u65e0\u54cd\u5e94" + gatewayResponse.getMsg());
            return new ArrayList<GetScheduleResItems>();
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            return new ArrayList<GetScheduleResItems>();
        }
        GetScheduleResVO getScheduleResVO = (GetScheduleResVO)gatewayResponse.getData();
        if (getScheduleResVO == null) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38" + gatewayResponse.getMsg());
            return new ArrayList<GetScheduleResItems>();
        }
        List getScheduleResItemsList = getScheduleResVO.getItems();
        if (CollectionUtils.isEmpty((Collection)getScheduleResItemsList)) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u65e0\u6392\u73ed\u4fe1\u606f" + gatewayResponse.getMsg());
            return new ArrayList<GetScheduleResItems>();
        }
        return getScheduleResItemsList;
    }
}

