/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.service.impl;

import com.alibaba.fastjson.JSON;
import com.doctoruser.api.pojo.base.dto.OrganIdReq;
import com.doctoruser.api.pojo.base.entity.DepartmentEntity;
import com.doctoruser.api.pojo.base.vo.doctor.OrganDeptInfoVO;
import com.ebaiyihui.wisdommedical.exception.AppointmentException;
import com.ebaiyihui.wisdommedical.mapper.AppointmentRecordMapper;
import com.ebaiyihui.wisdommedical.mapper.DeptCategoryMapper;
import com.ebaiyihui.wisdommedical.mapper.DeptRecordMapper;
import com.ebaiyihui.wisdommedical.model.AppointmentRecordEntity;
import com.ebaiyihui.wisdommedical.pojo.vo.GetDeptListVoRes;
import com.ebaiyihui.wisdommedical.pojo.vo.HospitalDeptVo;
import com.ebaiyihui.wisdommedical.service.DepartmentService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.ZSetOperations;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class DepartmentServiceImpl
implements DepartmentService {
    private static final Logger log = LoggerFactory.getLogger(DepartmentServiceImpl.class);
    public static final String POP_DEPT = "\u63a8\u8350\u79d1\u5ba4";
    public static final int ALREADY_VISITING = 1;
    public static final int NOT_VISITING = 0;
    public static final String[] NOT_INCLUDED_DEPT = new String[]{"\u5f85\u5212\u5206", "\u65b0\u7684\u79d1\u5ba4", "ceshi\u79d1\u5ba4", "\u63a8\u8350\u79d1\u5ba4"};
    @Autowired
    private AppointmentRecordMapper appointmentRecordMapper;
    @Autowired
    private DeptCategoryMapper deptCategoryMapper;
    @Autowired
    private DeptRecordMapper deptRecordMapper;
    @Autowired
    private StringRedisTemplate redisTemplate;
    private static int RECENT_SEARCH_RECORD_SIZE = 5;

    public List<GetDeptListVoRes> getDeptList(String organCode, String userId, String hospitalId, String hospAreaCode) throws AppointmentException {
        ArrayList<GetDeptListVoRes> getDeptListVoResList = new ArrayList<GetDeptListVoRes>();
        List organDeptInfoVOList = this.getOrganDeptList(hospitalId, organCode);
        List departmentEntityList = this.getPopOrganDept(hospitalId);
        GetDeptListVoRes deptListVoRes = new GetDeptListVoRes();
        deptListVoRes.setFirstDepName(POP_DEPT);
        List appointmentRecordEntityList = this.appointmentRecordMapper.selectByUserIdAndOrganCode(userId, organCode);
        appointmentRecordEntityList = appointmentRecordEntityList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<AppointmentRecordEntity>(Comparator.comparing(AppointmentRecordEntity::getDeptName))), ArrayList::new));
        List visitingDeptCodeList = appointmentRecordEntityList.stream().map(AppointmentRecordEntity::getDeptCode).collect(Collectors.toList());
        List hospitalDeptVoList = appointmentRecordEntityList.stream().map(appointmentRecordEntity -> {
            HospitalDeptVo hospitalDeptVo = new HospitalDeptVo();
            hospitalDeptVo.setHospitalDepCode(appointmentRecordEntity.getDeptCode());
            hospitalDeptVo.setHospitalDepName(appointmentRecordEntity.getDeptName());
            hospitalDeptVo.setVisiting(1);
            return hospitalDeptVo;
        }).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty((Collection)departmentEntityList)) {
            hospitalDeptVoList.addAll(this.getHospitalDeptVo(visitingDeptCodeList, departmentEntityList));
            hospitalDeptVoList = hospitalDeptVoList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<HospitalDeptVo>(Comparator.comparing(HospitalDeptVo::getHospitalDepCode))), ArrayList::new));
            deptListVoRes.setHospitalDepVoResList(hospitalDeptVoList);
        } else {
            deptListVoRes.setHospitalDepVoResList(hospitalDeptVoList);
        }
        getDeptListVoResList.add(deptListVoRes);
        if (!CollectionUtils.isEmpty((Collection)organDeptInfoVOList)) {
            organDeptInfoVOList.forEach(organDeptInfoVO -> {
                GetDeptListVoRes getDeptListVoRes = new GetDeptListVoRes();
                getDeptListVoRes.setFirstDepName(organDeptInfoVO.getFirstStandDeptName());
                getDeptListVoRes.setFirstDepId(organDeptInfoVO.getFirstStandDeptId());
                getDeptListVoRes.setHospitalDepVoResList(this.getHospitalDeptVo(visitingDeptCodeList, organDeptInfoVO.getDepartmentEntities()));
                getDeptListVoResList.add(getDeptListVoRes);
            });
        }
        if (CollectionUtils.isEmpty(getDeptListVoResList)) {
            return new ArrayList<GetDeptListVoRes>();
        }
        List<GetDeptListVoRes> deptListVoResList = getDeptListVoResList.stream().filter(getDeptListVoRes -> !Arrays.asList(NOT_INCLUDED_DEPT).contains(getDeptListVoRes.getFirstDepName())).collect(Collectors.toList());
        deptListVoResList = deptListVoResList.stream().filter(departmentEntity -> !CollectionUtils.isEmpty((Collection)departmentEntity.getHospitalDepVoResList())).collect(Collectors.toList());
        return deptListVoResList;
    }

    public List<GetDeptListVoRes> getDeptList(String organCode, String userId, String hospAreaCode) throws AppointmentException {
        List<Object> getDeptListVoResList = new ArrayList();
        List firstDeptList = this.deptCategoryMapper.selectAllDept();
        if (CollectionUtils.isEmpty((Collection)firstDeptList)) {
            log.error("*****************\u4e00\u7ea7\u79d1\u5ba4\u672a\u914d\u7f6e***************");
            return new ArrayList<GetDeptListVoRes>();
        }
        List secondDeptList = this.deptRecordMapper.selectListByHospitalCode(organCode, hospAreaCode);
        if (CollectionUtils.isEmpty((Collection)secondDeptList)) {
            log.error("*****************\u672a\u67e5\u8be2\u5230\u533b\u9662\u79d1\u5ba4\u4fe1\u606f***************");
            return new ArrayList<GetDeptListVoRes>();
        }
        List deptListFilter = secondDeptList.stream().filter(deptRecordEntity -> !StringUtils.isEmpty((Object)deptRecordEntity.getFirstDeptId())).collect(Collectors.toList());
        List appointmentRecordEntityList = this.appointmentRecordMapper.selectByUserIdAndOrganCode(userId, organCode);
        appointmentRecordEntityList = appointmentRecordEntityList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<AppointmentRecordEntity>(Comparator.comparing(AppointmentRecordEntity::getDeptName))), ArrayList::new));
        List visitingDeptCodeList = appointmentRecordEntityList.stream().map(AppointmentRecordEntity::getDeptCode).collect(Collectors.toList());
        getDeptListVoResList = firstDeptList.stream().map(deptCategoryEntity -> {
            GetDeptListVoRes getDeptListVoRes = new GetDeptListVoRes();
            getDeptListVoRes.setFirstDepId(deptCategoryEntity.getDeptCategoryCode());
            getDeptListVoRes.setFirstDepName(deptCategoryEntity.getDeptCategoryName());
            List deptList = deptListFilter.stream().filter(deptRecordEntity -> deptRecordEntity.getFirstDeptId().equals(deptCategoryEntity.getId())).collect(Collectors.toList());
            List hospitalDeptVoList = deptList.stream().map(deptRecordEntity -> {
                HospitalDeptVo hospitalDeptVo = new HospitalDeptVo();
                String deptCode = deptRecordEntity.getDeptCode();
                hospitalDeptVo.setHospitalDepCode(deptCode);
                hospitalDeptVo.setHospitalDepName(deptRecordEntity.getDeptName());
                hospitalDeptVo.setIntroduction(deptRecordEntity.getIntroduction());
                if (!CollectionUtils.isEmpty((Collection)visitingDeptCodeList) && visitingDeptCodeList.contains(deptCode)) {
                    hospitalDeptVo.setVisiting(1);
                } else {
                    hospitalDeptVo.setVisiting(0);
                }
                return hospitalDeptVo;
            }).collect(Collectors.toList());
            getDeptListVoRes.setHospitalDepVoResList(hospitalDeptVoList);
            return getDeptListVoRes;
        }).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(getDeptListVoResList)) {
            return new ArrayList<GetDeptListVoRes>();
        }
        List<GetDeptListVoRes> deptListVoResList = getDeptListVoResList.stream().filter(getDeptListVoRes -> !Arrays.asList(NOT_INCLUDED_DEPT).contains(getDeptListVoRes.getFirstDepName())).collect(Collectors.toList());
        deptListVoResList = deptListVoResList.stream().filter(departmentEntity -> !CollectionUtils.isEmpty((Collection)departmentEntity.getHospitalDepVoResList())).collect(Collectors.toList());
        return deptListVoResList;
    }

    private List<HospitalDeptVo> getHospitalDeptVo(List<String> visitingDeptCodeList, List<DepartmentEntity> departmentEntityList) {
        ArrayList<HospitalDeptVo> hospitalDeptVoList = new ArrayList<HospitalDeptVo>();
        if (CollectionUtils.isEmpty(departmentEntityList)) {
            return hospitalDeptVoList;
        }
        return departmentEntityList.stream().map(departmentEntity -> {
            HospitalDeptVo hospitalDepVo = new HospitalDeptVo();
            String deptCode = departmentEntity.getDeptCode();
            hospitalDepVo.setHospitalDepCode(deptCode);
            hospitalDepVo.setHospitalDepName(departmentEntity.getDeptName());
            if (!CollectionUtils.isEmpty((Collection)visitingDeptCodeList) && visitingDeptCodeList.contains(deptCode)) {
                hospitalDepVo.setVisiting(1);
            } else {
                hospitalDepVo.setVisiting(0);
            }
            hospitalDeptVoList.add(hospitalDepVo);
            return hospitalDepVo;
        }).collect(Collectors.toList());
    }

    private List<DepartmentEntity> getPopOrganDept(String organId) throws AppointmentException {
        Object departmentEntityRes = null;
        if (!departmentEntityRes.isSuccess()) {
            log.error("\u67e5\u8be2\u533b\u9662\u70ed\u95e8\u79d1\u5ba4\u5931\u8d25\uff1a " + departmentEntityRes.getMsg());
            throw new AppointmentException(departmentEntityRes.getMsg());
        }
        List departmentEntityList = (List)departmentEntityRes.getData();
        return departmentEntityList;
    }

    private List<OrganDeptInfoVO> getOrganDeptList(String organId, String organCode) throws AppointmentException {
        OrganIdReq organIdReq = new OrganIdReq();
        organIdReq.setOrganId(organId);
        organIdReq.setOrganCode(organCode);
        organIdReq.setDeptType(Integer.valueOf(0));
        Object organDeptListRes = null;
        if (!organDeptListRes.isSuccess()) {
            log.error("\u67e5\u8be2\u533b\u9662\u79d1\u5ba4\u5931\u8d25\uff1a " + organDeptListRes.getMsg());
            throw new AppointmentException(organDeptListRes.getMsg());
        }
        List organDeptInfoVOList = (List)organDeptListRes.getData();
        return organDeptInfoVOList;
    }

    public void saveSearchRecord(String organCode, String userId, String keyword) throws AppointmentException {
        String redisKey = organCode + userId;
        ZSetOperations zSetOperations = this.redisTemplate.opsForZSet();
        zSetOperations.add((Object)redisKey, (Object)keyword, (double)System.currentTimeMillis());
        log.info("\u3010redis\u5b58\u50a8\u79d1\u5ba4\u641c\u7d22\u8bb0\u5f55\u3011key:{}, value:{}", (Object)redisKey, (Object)keyword);
        Long size = zSetOperations.size((Object)redisKey);
        if (size > (long)RECENT_SEARCH_RECORD_SIZE) {
            zSetOperations.removeRange((Object)redisKey, 0L, size - (long)RECENT_SEARCH_RECORD_SIZE - 1L);
        }
        this.redisTemplate.expire((Object)redisKey, 30L, TimeUnit.DAYS);
    }

    public List<HospitalDeptVo> searchDept(String organCode, String userId, String key) throws AppointmentException {
        this.saveSearchRecord(organCode, userId, key);
        List listDep = this.deptRecordMapper.selectByNameAndHospitalCode(organCode, key);
        log.info("\u67e5\u8be2\u5230\u79d1\u5ba4\u4fe1\u606f\uff1a" + JSON.toJSONString((Object)listDep));
        List listDoc = this.deptRecordMapper.selectByDocNameAndHospitalDocCode(organCode, key);
        if (!listDep.isEmpty()) {
            List listDocByDept = this.deptRecordMapper.selectDocByDeptCodeList(listDep);
            listDoc.addAll(listDocByDept);
        }
        if (!listDoc.isEmpty()) {
            listDoc = listDoc.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<HospitalDeptVo>(Comparator.comparing(v -> v.getHospitalDocCode() + ";" + v.getHospitalDepCode() + ";" + v.getIntroduction()))), ArrayList::new));
            listDep.addAll(listDoc);
        }
        log.info("\u67e5\u8be2\u5230\u533b\u751f\u4fe1\u606f\uff1a" + JSON.toJSONString((Object)listDoc));
        return listDep;
    }

    public List<String> getRecentSearchDeptList(String organCode, String userId) throws AppointmentException {
        ArrayList<String> list = new ArrayList<String>();
        String key = organCode + userId;
        ZSetOperations zSetOperations = this.redisTemplate.opsForZSet();
        Set range = zSetOperations.reverseRangeWithScores((Object)key, 0L, (long)(RECENT_SEARCH_RECORD_SIZE - 1));
        log.info("\u3010redis\u83b7\u53d6\u79d1\u5ba4\u641c\u7d22\u8bb0\u5f55\u3011key:{}, object:{} ", (Object)key, (Object)JSON.toJSONString((Object)range));
        for (ZSetOperations.TypedTuple tuple : range) {
            list.add((String)tuple.getValue());
        }
        return list;
    }

    public void deleteOneSearchRecord(String organCode, String userId, String keyword) throws AppointmentException {
        String key = organCode + userId;
        ZSetOperations zSetOperations = this.redisTemplate.opsForZSet();
        zSetOperations.remove((Object)key, new Object[]{keyword});
        log.info("\u3010redis\u5220\u9664\u6307\u5b9a\u79d1\u5ba4\u641c\u7d22\u5386\u53f2\u8bb0\u5f55\u3011key:{}, value:{} ", (Object)key, (Object)keyword);
    }

    public void deleteAllSearchRecords(String organCode, String userId) throws AppointmentException {
        String key = organCode + userId;
        ZSetOperations zSetOperations = this.redisTemplate.opsForZSet();
        zSetOperations.removeRange((Object)key, 0L, (long)(RECENT_SEARCH_RECORD_SIZE - 1));
        log.info("\u3010redis\u5220\u9664\u6240\u6709\u79d1\u5ba4\u641c\u7d22\u5386\u53f2\u8bb0\u5f55\u3011key:{}", (Object)key);
    }

    public String getIntroduction(String deptCode, String deptName) {
        String introduction = this.deptRecordMapper.getIntroduction(deptCode, deptName);
        return introduction;
    }
}

