/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.his.pojo.vo.base.FrontRequest;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.wisdommedical.common.constant.ProPropertiesConstant;
import com.ebaiyihui.wisdommedical.mapper.DoctorRecordMapper;
import com.ebaiyihui.wisdommedical.mapper.HisDoctorMapper;
import com.ebaiyihui.wisdommedical.mapper.HospitalAreaRecordMapper;
import com.ebaiyihui.wisdommedical.mapper.ScheduleRecordMapper;
import com.ebaiyihui.wisdommedical.model.BaseDoctorEntity;
import com.ebaiyihui.wisdommedical.model.DoctorRecordEntity;
import com.ebaiyihui.wisdommedical.model.HisDoctorEntity;
import com.ebaiyihui.wisdommedical.model.HospitalAreaRecordEntity;
import com.ebaiyihui.wisdommedical.model.UploadDocExcelReqVo;
import com.ebaiyihui.wisdommedical.pojo.dto.DocAndDep;
import com.ebaiyihui.wisdommedical.pojo.dto.DocAndDepList;
import com.ebaiyihui.wisdommedical.pojo.dto.GetDocInfoReq;
import com.ebaiyihui.wisdommedical.pojo.dto.GetDocInfoRes;
import com.ebaiyihui.wisdommedical.pojo.dto.ScheduleDoctorDTO;
import com.ebaiyihui.wisdommedical.pojo.vo.GetDoctorPositionInfoVo;
import com.ebaiyihui.wisdommedical.pojo.vo.ScheduleDoctorVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.ScheduleDoctorVoRes;
import com.ebaiyihui.wisdommedical.pojo.vo.repsvo.GetDoctorBaseInfoVo;
import com.ebaiyihui.wisdommedical.service.DoctorService;
import com.ebaiyihui.wisdommedical.service.impl.DoctorServiceImpl;
import com.ebaiyihui.wisdommedical.util.GetDoctorInfoUtil;
import com.ebaiyihui.wisdommedical.util.HttpKit;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import redis.clients.jedis.JedisCluster;

@Service
public class DoctorServiceImpl
implements DoctorService {
    public static final int TWO_MIN = 120;
    public static final String DEFAULT_SUCCESS_CODE = "1";
    @Autowired
    private JedisCluster jedisCluster;
    @Autowired
    private DoctorRecordMapper doctorRecordMapper;
    @Autowired
    private HospitalAreaRecordMapper hospitalAreaRecordMapper;
    @Autowired
    private ScheduleRecordMapper scheduleRecordMapper;
    @Autowired
    private GetDoctorInfoUtil getDoctorInfoUtil;
    @Autowired
    private HisDoctorMapper hisDoctorMapper;
    @Autowired
    private ProPropertiesConstant constant;

    public DoctorRecordEntity getDoctorRecordEntity(String doctorId, String hospitalCode) {
        return this.doctorRecordMapper.selectByDoctorIdAndHospitalCode(doctorId, hospitalCode);
    }

    public List<DoctorRecordEntity> getDoctorIdList(String doctorCodes, String organId) {
        return this.doctorRecordMapper.getDoctorIdList(doctorCodes, organId);
    }

    public DoctorRecordEntity getDoctorRecordByDoctorCodeAndHosCode(String doctorCode, String organCode) {
        return this.doctorRecordMapper.getDoctorRecordByDoctorCodeAndHosCode(doctorCode, organCode);
    }

    public void updateDoctorIdByDoctorCode(String doctorId, String doctorCode, String hospitalCode) {
        DoctorRecordEntity doctorRecordEntity = this.doctorRecordMapper.selectOneByDocCodeAndHospitalCode(hospitalCode, doctorCode);
        if (doctorRecordEntity != null) {
            this.doctorRecordMapper.updateDoctorIdByDoctorCode(doctorId, doctorCode);
        }
    }

    public List<Long> getDoctorCodeListBydoctorIds(String doctorIds) {
        List doctorCodeList = this.doctorRecordMapper.getDoctorCodeList(doctorIds);
        List<Long> doctorIdList = doctorCodeList.stream().map(doctorRecordEntity -> {
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)doctorRecordEntity.getDoctorId())) {
                return Long.valueOf(doctorRecordEntity.getDoctorId());
            }
            return 0L;
        }).collect(Collectors.toList());
        return doctorIdList;
    }

    public List<ScheduleDoctorVoRes> getScheduleDoctor(ScheduleDoctorVoReq scheduleDoctorVoReq) {
        HospitalAreaRecordEntity hospitalAreaRecordEntity = this.hospitalAreaRecordMapper.selectByHospitalId(scheduleDoctorVoReq.getOrganId());
        if (null == hospitalAreaRecordEntity) {
            return new ArrayList<ScheduleDoctorVoRes>();
        }
        List scheduleDoctorDTOS = this.scheduleRecordMapper.selectByHospitalCodeAndDeptCode(hospitalAreaRecordEntity.getHospitalCode(), scheduleDoctorVoReq.getDeptCode());
        ArrayList<ScheduleDoctorVoRes> scheduleDoctorVoResList = new ArrayList<ScheduleDoctorVoRes>();
        for (ScheduleDoctorDTO scheduleDoctorDTO : scheduleDoctorDTOS) {
            if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)scheduleDoctorDTO.getDoctorId())) continue;
            ScheduleDoctorVoRes scheduleDoctorVoRes = new ScheduleDoctorVoRes();
            scheduleDoctorVoRes.setDoctorId(Long.valueOf(scheduleDoctorDTO.getDoctorId()));
            scheduleDoctorVoRes.setDoctorCode(scheduleDoctorDTO.getDoctorCode());
            scheduleDoctorVoRes.setDoctorName(scheduleDoctorDTO.getDoctorName());
            scheduleDoctorVoRes.setDeptCode(scheduleDoctorDTO.getDeptCode());
            scheduleDoctorVoRes.setDeptName(scheduleDoctorDTO.getDeptName());
            scheduleDoctorVoResList.add(scheduleDoctorVoRes);
        }
        return scheduleDoctorVoResList;
    }

    public BaseResponse<GetDoctorBaseInfoVo> getDoctorBasicInfo(String docCode, String organId) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)docCode)) {
            return BaseResponse.error((String)"docCode\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)organId)) {
            return BaseResponse.error((String)"organId\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        GetDoctorBaseInfoVo getDoctorBaseInfoVo = new GetDoctorBaseInfoVo();
        try {
            List baseDoctorEntityList = this.hisDoctorMapper.findByHospCodeAndHisDoctorDoc(docCode);
            if (null == baseDoctorEntityList || baseDoctorEntityList.size() == 0) {
                return BaseResponse.success((Object)getDoctorBaseInfoVo);
            }
            BaseDoctorEntity baseDoctorEntity = (BaseDoctorEntity)baseDoctorEntityList.get(0);
            HisDoctorEntity hisDoctorEntity = this.hisDoctorMapper.findByHospCodeAndHisDoctorId(organId, docCode);
            getDoctorBaseInfoVo.setDeptName(baseDoctorEntity.getDeptName());
            getDoctorBaseInfoVo.setHospitalName(baseDoctorEntity.getHospitalName());
            getDoctorBaseInfoVo.setRegTitelName(baseDoctorEntity.getRegTitelName());
            getDoctorBaseInfoVo.setName(baseDoctorEntity.getDocName());
            if (Objects.isNull(hisDoctorEntity)) {
                return BaseResponse.success((Object)getDoctorBaseInfoVo);
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            ArrayList<String> emplCodeList = new ArrayList<String>();
            emplCodeList.add(hisDoctorEntity.getHisDoctCode());
            params.put("emplCodeList", emplCodeList);
            params.put("organId", organId);
            List doctorBaseInfoDTO = this.getDoctorInfoUtil.getDoctorInfoList(params);
            if (null == doctorBaseInfoDTO || doctorBaseInfoDTO.size() == 0) {
                return BaseResponse.success((Object)getDoctorBaseInfoVo);
            }
            getDoctorBaseInfoVo.setDeptCode(((GetDoctorBaseInfoVo)doctorBaseInfoDTO.get(0)).getDeptCode());
            getDoctorBaseInfoVo.setContactMobile(((GetDoctorBaseInfoVo)doctorBaseInfoDTO.get(0)).getContactMobile());
            getDoctorBaseInfoVo.setCredNo(((GetDoctorBaseInfoVo)doctorBaseInfoDTO.get(0)).getCredNo());
            getDoctorBaseInfoVo.setCredType(((GetDoctorBaseInfoVo)doctorBaseInfoDTO.get(0)).getCredType());
            getDoctorBaseInfoVo.setEmplCode(((GetDoctorBaseInfoVo)doctorBaseInfoDTO.get(0)).getEmplCode());
            getDoctorBaseInfoVo.setGender(((GetDoctorBaseInfoVo)doctorBaseInfoDTO.get(0)).getGender());
            getDoctorBaseInfoVo.setHeadPortrait(((GetDoctorBaseInfoVo)doctorBaseInfoDTO.get(0)).getHeadPortrait());
            getDoctorBaseInfoVo.setId(((GetDoctorBaseInfoVo)doctorBaseInfoDTO.get(0)).getId());
            getDoctorBaseInfoVo.setSpeciality(((GetDoctorBaseInfoVo)doctorBaseInfoDTO.get(0)).getSpeciality());
            getDoctorBaseInfoVo.setName(((GetDoctorBaseInfoVo)doctorBaseInfoDTO.get(0)).getName());
            getDoctorBaseInfoVo.setOrganId(((GetDoctorBaseInfoVo)doctorBaseInfoDTO.get(0)).getOrganId());
            getDoctorBaseInfoVo.setRegisterMobile(((GetDoctorBaseInfoVo)doctorBaseInfoDTO.get(0)).getRegisterMobile());
        }
        catch (Exception e) {
            e.printStackTrace();
            return BaseResponse.error((String)"\u670d\u52a1\u51fa\u73b0\u9519\u8bef");
        }
        return BaseResponse.success((Object)getDoctorBaseInfoVo);
    }

    public BaseResponse<GetDoctorPositionInfoVo> getDoctorBasicInfoByDoctorId(String doctorId) {
        GetDoctorPositionInfoVo getCardDetailByPmiUrlVo = new GetDoctorPositionInfoVo();
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("doctorId", doctorId);
            getCardDetailByPmiUrlVo = this.getDoctorInfoUtil.getDoctorInfo(params);
        }
        catch (Exception e) {
            return BaseResponse.error((String)"\u67e5\u8be2\u670d\u52a1\u5f02\u5e38");
        }
        return BaseResponse.success((Object)getCardDetailByPmiUrlVo);
    }

    public List<DoctorRecordEntity> getDoctorDeptRecord(String docCode, String organId) {
        List doctorDeptList = this.doctorRecordMapper.getDoctorDeptList(docCode);
        doctorDeptList = doctorDeptList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<DoctorRecordEntity>(Comparator.comparing(DoctorRecordEntity::getDeptCode))), ArrayList::new));
        return doctorDeptList;
    }

    public BaseResponse<GetDocInfoRes> getDoctorBasicInfoFromHis(String doctorCode, String deptCode) {
        String key = doctorCode + "|" + deptCode + "|DOCINFO";
        String listStr = this.jedisCluster.get(key);
        if (!StringUtils.isEmpty((Object)listStr)) {
            GetDocInfoRes res = (GetDocInfoRes)JSONObject.parseObject((String)listStr, GetDocInfoRes.class);
            return BaseResponse.success((Object)res);
        }
        try {
            FrontRequest param = new FrontRequest();
            GetDocInfoReq getDocInfoRes = new GetDocInfoReq();
            getDocInfoRes.setDoctorCode(Integer.valueOf(doctorCode));
            getDocInfoRes.setDepartmentCode(Integer.valueOf(deptCode));
            param.setBody((Object)getDocInfoRes);
            String body = HttpKit.jsonPost((String)(this.constant.getHisurl() + "/schedule/getDocInfo"), (String)JSON.toJSONString((Object)param));
            1 typeReference = new /* Unavailable Anonymous Inner Class!! */;
            FrontResponse response = (FrontResponse)JSONObject.parseObject((String)body, (Type)typeReference.getType(), (Feature[])new Feature[0]);
            if (!DEFAULT_SUCCESS_CODE.equals(response.getCode()) || null == response.getBody()) {
                return BaseResponse.error((String)response.getMessage());
            }
            this.jedisCluster.set(key, JSON.toJSONString((Object)response.getBody()));
            this.jedisCluster.expire(key, 120);
            return BaseResponse.success((Object)response.getBody());
        }
        catch (Exception e) {
            return BaseResponse.error((String)"\u83b7\u53d6\u533b\u751f\u4fe1\u606f\u5f02\u5e38");
        }
    }

    public BaseResponse<Object> importWestern(List<UploadDocExcelReqVo> uploadDocList) {
        for (UploadDocExcelReqVo uploadDocExcelReqVo : uploadDocList) {
            this.doctorRecordMapper.updateByDocName(uploadDocExcelReqVo.getName(), uploadDocExcelReqVo.getDocCode());
        }
        return BaseResponse.success((Object)"111");
    }

    public BaseResponse<Object> docimportWesternFileUpload(String s) {
        DocAndDep docAndDep = (DocAndDep)JSONObject.parseObject((String)s, DocAndDep.class);
        List usersInfo = docAndDep.getUsersInfo();
        for (DocAndDepList docAndDepList : usersInfo) {
            String[] str;
            for (String ss : str = docAndDepList.getDep_id().split(",")) {
                DoctorRecordEntity doctorRecordEntity = new DoctorRecordEntity();
                doctorRecordEntity.setCreatetime(new Date());
                doctorRecordEntity.setDeptCode(ss);
                doctorRecordEntity.setDocCode(docAndDepList.getId());
                doctorRecordEntity.setDocName(docAndDepList.getRealname());
                doctorRecordEntity.setUpdatetime(new Date());
                this.doctorRecordMapper.insertnew(doctorRecordEntity);
            }
        }
        return BaseResponse.success((Object)"yes");
    }
}

