/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.service.impl;

import com.ebaiyihui.framework.page.PageResult;
import com.ebaiyihui.wisdommedical.exception.DoctorScheduleException;
import com.ebaiyihui.wisdommedical.mapper.DoctorRecordMapper;
import com.ebaiyihui.wisdommedical.mapper.HospitalAreaRecordMapper;
import com.ebaiyihui.wisdommedical.mapper.ScheduleRecordMapper;
import com.ebaiyihui.wisdommedical.model.DoctorRecordEntity;
import com.ebaiyihui.wisdommedical.model.HospitalAreaRecordEntity;
import com.ebaiyihui.wisdommedical.model.ScheduleRecordEntity;
import com.ebaiyihui.wisdommedical.pojo.vo.ManageDocSchedulePageVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.ManageDocScheduleVo;
import com.ebaiyihui.wisdommedical.pojo.vo.ManageDocScheduleVoRes;
import com.ebaiyihui.wisdommedical.service.ManageDocScheduleService;
import com.ebaiyihui.wisdommedical.util.DateUtils;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ManageDocScheduleServiceImpl
implements ManageDocScheduleService {
    private static final Logger log = LoggerFactory.getLogger(ManageDocScheduleServiceImpl.class);
    public static final int PAGESIZE = 20;
    @Autowired
    private DoctorRecordMapper doctorRecordMapper;
    @Autowired
    private HospitalAreaRecordMapper hospitalAreaRecordMapper;
    @Autowired
    private ScheduleRecordMapper scheduleRecordMapper;

    public ManageDocScheduleVoRes getManageDocSchedule(String organCode, String docCode, String orderByFlag) throws DoctorScheduleException {
        ManageDocScheduleVoRes manageDocScheduleVoRes = new ManageDocScheduleVoRes();
        HospitalAreaRecordEntity hospitalAreaRecordEntity = this.hospitalAreaRecordMapper.selectOneByhospitalCode(organCode);
        if (null == hospitalAreaRecordEntity) {
            log.info("\u672a\u67e5\u8be2\u5230\u8be5\u533b\u9662\u4fe1\u606f\uff1a\u533b\u9662\u7f16\u7801\u4e3a{}", (Object)organCode);
            return null;
        }
        DoctorRecordEntity doctorRecordEntity = this.doctorRecordMapper.selectOneByDocCodeAndHospitalCode(organCode, docCode);
        if (null == doctorRecordEntity) {
            log.info("\u672a\u67e5\u8be2\u5230\u8be5\u533b\u9662\u8be5\u533b\u751f\u4fe1\u606f\uff1a\u533b\u9662\u7f16\u7801\u4e3a{},\u533b\u751f\u7f16\u7801{}", (Object)organCode, (Object)docCode);
            return null;
        }
        List manageDocScheduleVoList = this.scheduleRecordMapper.selectByDocCode(organCode, docCode, orderByFlag);
        if (null == manageDocScheduleVoList || manageDocScheduleVoList.isEmpty()) {
            log.info("\u672a\u67e5\u8be2\u5230\u8be5\u533b\u9662\u8be5\u533b\u751f\u6392\u73ed\u4fe1\u606f\uff1a\u533b\u9662\u7f16\u7801\u4e3a{},\u533b\u751f\u7f16\u7801{}", (Object)organCode, (Object)docCode);
            return null;
        }
        manageDocScheduleVoRes.setDocName(doctorRecordEntity.getDocName());
        manageDocScheduleVoRes.setRegTitelName(doctorRecordEntity.getRegTitelName());
        manageDocScheduleVoRes.setDeptName(((ScheduleRecordEntity)manageDocScheduleVoList.get(0)).getDeptName());
        manageDocScheduleVoRes.setOrganName(hospitalAreaRecordEntity.getHospitalAreaName());
        manageDocScheduleVoRes.setManageDocScheduleVoList(this.getManageDocScheduleVoList(manageDocScheduleVoList));
        return manageDocScheduleVoRes;
    }

    public PageResult<ManageDocScheduleVo> getPageManageDocScheduleVo(ManageDocSchedulePageVoReq manageDocSchedulePageVoReq) throws DoctorScheduleException {
        PageResult pageResult = new PageResult();
        Integer pageSize = 20;
        if (!manageDocSchedulePageVoReq.getPageSize().equals("") && null != manageDocSchedulePageVoReq.getPageSize()) {
            pageSize = manageDocSchedulePageVoReq.getPageSize();
        }
        PageHelper.startPage((int)manageDocSchedulePageVoReq.getPageNum(), (int)pageSize);
        Page page = this.scheduleRecordMapper.selectPageByOrganCode(manageDocSchedulePageVoReq);
        List scheduleRecordEntity = page.getResult();
        if (CollectionUtils.isEmpty((Collection)scheduleRecordEntity)) {
            return pageResult;
        }
        List manageDocScheduleVoList = this.getManageDocScheduleVoList(scheduleRecordEntity);
        pageResult.setContent(manageDocScheduleVoList);
        Long total = page.getTotal();
        double totalPages = (double)page.getTotal() / (double)page.getPageSize();
        pageResult.setPageSize(page.getPageSize());
        pageResult.setTotal(total.intValue());
        pageResult.setPageNum(page.getPageNum());
        pageResult.setTotalPages((int)Math.ceil(totalPages));
        return pageResult;
    }

    private List<ManageDocScheduleVo> getManageDocScheduleVoList(List<ScheduleRecordEntity> scheduleRecordEntityList) throws DoctorScheduleException {
        ArrayList<ManageDocScheduleVo> manageDocScheduleVoList = new ArrayList<ManageDocScheduleVo>();
        if (null == scheduleRecordEntityList || scheduleRecordEntityList.isEmpty()) {
            return null;
        }
        for (ScheduleRecordEntity scheduleRecordEntity : scheduleRecordEntityList) {
            ManageDocScheduleVo manageDocScheduleVo = new ManageDocScheduleVo();
            manageDocScheduleVo.setScheduleId(scheduleRecordEntity.getScheduleHisId());
            manageDocScheduleVo.setDocName(scheduleRecordEntity.getDocName());
            manageDocScheduleVo.setDocCode(scheduleRecordEntity.getDocCode());
            manageDocScheduleVo.setRegTitleName(scheduleRecordEntity.getRegTitelName());
            manageDocScheduleVo.setScheduleType(Integer.valueOf(scheduleRecordEntity.getScheduleType().byteValue()));
            manageDocScheduleVo.setHospitalAreaName(scheduleRecordEntity.getHospitalAreaName());
            manageDocScheduleVo.setLocName(scheduleRecordEntity.getDeptName());
            manageDocScheduleVo.setLocCode(scheduleRecordEntity.getDeptCode());
            manageDocScheduleVo.setScheduleLevelName(scheduleRecordEntity.getScheduleLevel());
            manageDocScheduleVo.setAdmDate(DateUtils.dateToSimpleString((Date)scheduleRecordEntity.getScheduleDate()));
            manageDocScheduleVo.setAdmTimeRange(scheduleRecordEntity.getScheduleRange().toString());
            BigDecimal totalFee = scheduleRecordEntity.getRegFee().add(scheduleRecordEntity.getDiagFee());
            manageDocScheduleVo.setRegFee(totalFee.toString());
            manageDocScheduleVo.setRegTotal(scheduleRecordEntity.getTotalCount());
            manageDocScheduleVo.setRegRemainder(scheduleRecordEntity.getAvailableCount());
            manageDocScheduleVo.setScheduleStatus(scheduleRecordEntity.getStatus().toString());
            manageDocScheduleVo.setReplaceScheduleId(scheduleRecordEntity.getReplaceScheduleHisId());
            manageDocScheduleVoList.add(manageDocScheduleVo);
        }
        return manageDocScheduleVoList;
    }
}

