/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.ebaiyihui.card.common.vo.CardDetailsInfoReqVO;
import com.ebaiyihui.card.common.vo.CardDetailsInfoRespVO;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.his.api.ElectronicReportApi;
import com.ebaiyihui.his.pojo.vo.base.FrontRequest;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.his.pojo.vo.base.GatewayRequest;
import com.ebaiyihui.his.pojo.vo.base.GatewayResponse;
import com.ebaiyihui.his.pojo.vo.report.GetReportListsReq;
import com.ebaiyihui.his.pojo.vo.report.GetReportListsRes;
import com.ebaiyihui.his.pojo.vo.report.LisReportListReq;
import com.ebaiyihui.his.pojo.vo.report.LisReportListRes;
import com.ebaiyihui.his.pojo.vo.report.PacsReportListReq;
import com.ebaiyihui.his.pojo.vo.report.PacsReportListRes;
import com.ebaiyihui.his.pojo.vo.report.datas.GetReportListsData;
import com.ebaiyihui.his.pojo.vo.report.datas.LisReportListResData;
import com.ebaiyihui.his.pojo.vo.report.datas.micDatas.LisReportListResMicData;
import com.ebaiyihui.wisdommedical.common.constant.ProPropertiesConstant;
import com.ebaiyihui.wisdommedical.pojo.vo.CheckReportDetailsReq;
import com.ebaiyihui.wisdommedical.pojo.vo.CheckReportDetailsRes;
import com.ebaiyihui.wisdommedical.pojo.vo.ListReportHosReq;
import com.ebaiyihui.wisdommedical.pojo.vo.ListReportHosRes;
import com.ebaiyihui.wisdommedical.pojo.vo.NetReportBaseRequest;
import com.ebaiyihui.wisdommedical.pojo.vo.ReportDetailData;
import com.ebaiyihui.wisdommedical.pojo.vo.ReportDetailMicData;
import com.ebaiyihui.wisdommedical.pojo.vo.ReportDetailReq;
import com.ebaiyihui.wisdommedical.pojo.vo.ReportDetailRes;
import com.ebaiyihui.wisdommedical.pojo.vo.ReportInfo;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.GetReportPDFReq;
import com.ebaiyihui.wisdommedical.service.NetReportService;
import com.ebaiyihui.wisdommedical.service.impl.NetReportServiceImpl;
import com.ebaiyihui.wisdommedical.util.DateUtils;
import com.ebaiyihui.wisdommedical.util.GetCardInfoUtil;
import com.ebaiyihui.wisdommedical.util.HttpKit;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class NetReportServiceImpl
implements NetReportService {
    @Autowired
    private ProPropertiesConstant constant;
    @Resource
    private ElectronicReportApi electronicReportClient;
    @Autowired
    private GetCardInfoUtil getCardInfoUtil;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public BaseResponse<ListReportHosRes> queryLisReportList(ListReportHosReq param) {
        CardDetailsInfoRespVO cardDetail = this.getCardDetail(param.getCardId());
        if (null == cardDetail) {
            this.logger.error("\u3010\u68c0\u9a8c\u62a5\u544a\u5217\u8868\u67e5\u8be2\u3011======\u83b7\u53d6\u60a3\u8005id\u5931\u8d25=====");
            return null;
        }
        GetReportListsReq listReportParam = new GetReportListsReq();
        listReportParam.setCardNo(cardDetail.getCardNo());
        listReportParam.setPatientId(cardDetail.getOrganPmi());
        listReportParam.setBeginTime(param.getBeginDate());
        listReportParam.setEndTime(param.getEndDate());
        GatewayRequest gatewayRequest = this.getGateWayParam((NetReportBaseRequest)param, (Object)listReportParam);
        GatewayResponse response = this.electronicReportClient.getlisReportLists(gatewayRequest);
        GetReportListsRes gateWayData = (GetReportListsRes)this.checkHisResponse((BaseResponse)response);
        if (gateWayData == null) {
            return BaseResponse.success();
        }
        List reportDataList = gateWayData.getDatas();
        if (reportDataList == null) {
            this.logger.error("request his gateway error - \u6682\u65e0\u6570\u636e");
            return BaseResponse.success();
        }
        ListReportHosRes data = new ListReportHosRes();
        List reportInfoList = reportDataList.stream().sorted(Comparator.comparing(GetReportListsData::getReportDate).reversed()).map(arg_0 -> this.matchReportData(arg_0)).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(reportInfoList)) {
            reportInfoList = new ArrayList();
        }
        for (ReportInfo reportInfo : reportInfoList) {
            if (!StringUtils.isBlank((CharSequence)reportInfo.getReportDate())) continue;
            reportInfo.setReportDate(reportInfo.getReportTime());
        }
        data.setReportList(reportInfoList);
        return BaseResponse.success((Object)data);
    }

    public BaseResponse<ReportDetailRes> queryReportDetail(ReportDetailReq param) {
        CardDetailsInfoRespVO cardDetail;
        ReportDetailRes reportDetail = new ReportDetailRes();
        LisReportListReq lisReportListReq = new LisReportListReq();
        lisReportListReq.setReportNo(param.getReportNo());
        GatewayRequest gatewayRequest = this.getGateWayParam((NetReportBaseRequest)param, (Object)lisReportListReq);
        GatewayResponse response = this.electronicReportClient.lisReportList(gatewayRequest);
        LisReportListRes gateWayData = (LisReportListRes)this.checkHisResponse((BaseResponse)response);
        if (gateWayData == null) {
            return BaseResponse.success();
        }
        BeanUtils.copyProperties((Object)gateWayData, (Object)reportDetail);
        List lisReportListResDataList = gateWayData.getDatas();
        if (lisReportListResDataList == null) {
            this.logger.error("request his gateway error - \u6682\u65e0\u6570\u636e");
            return BaseResponse.success();
        }
        List reportDetailDataList = lisReportListResDataList.stream().map(arg_0 -> this.matchJyReportDetail(arg_0)).collect(Collectors.toList());
        reportDetail.setDatas(reportDetailDataList);
        reportDetail.setPdfUrl(param.getPdfUrl());
        if (StringUtils.isNotBlank((CharSequence)param.getCardId()) && null != (cardDetail = this.getCardDetail(param.getCardId()))) {
            this.logger.error("\u3010\u68c0\u9a8c\u62a5\u544a\u660e\u7ec6\u67e5\u8be2\u3011======\u83b7\u53d6\u60a3\u8005\u4fe1\u606f\u5931\u8d25=====");
            reportDetail.setPatientName(cardDetail.getPatientName());
            reportDetail.setSex(String.valueOf(cardDetail.getGender()));
            try {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                Date birthday = simpleDateFormat.parse(cardDetail.getBirth());
                String age = String.valueOf(DateUtils.getAgeByBirth((Date)birthday));
                reportDetail.setAge(age);
            }
            catch (ParseException e) {
                this.logger.info(e.toString());
            }
        }
        return BaseResponse.success((Object)reportDetail);
    }

    public BaseResponse<ListReportHosRes> queryPacsReportList(ListReportHosReq param) {
        CardDetailsInfoRespVO cardDetail = this.getCardDetail(param.getCardId());
        if (null == cardDetail) {
            this.logger.error("\u3010\u68c0\u9a8c\u62a5\u544a\u5217\u8868\u67e5\u8be2\u3011======\u83b7\u53d6\u60a3\u8005id\u5931\u8d25=====");
            return null;
        }
        GetReportListsReq listReportParam = new GetReportListsReq();
        listReportParam.setCardNo(cardDetail.getCardNo());
        listReportParam.setPatientId(cardDetail.getOrganPmi());
        listReportParam.setBeginTime(param.getBeginDate());
        listReportParam.setEndTime(param.getEndDate());
        GatewayRequest gatewayRequest = this.getGateWayParam((NetReportBaseRequest)param, (Object)listReportParam);
        GatewayResponse response = this.electronicReportClient.getpacsReportLists(gatewayRequest);
        GetReportListsRes gateWayData = (GetReportListsRes)this.checkHisResponse((BaseResponse)response);
        if (gateWayData == null) {
            return BaseResponse.success();
        }
        List reportDataList = gateWayData.getDatas();
        if (reportDataList == null) {
            this.logger.error("request his gateway error - \u6682\u65e0\u6570\u636e");
            return BaseResponse.success();
        }
        ListReportHosRes data = new ListReportHosRes();
        List reportInfoList = reportDataList.stream().sorted(Comparator.comparing(GetReportListsData::getReportDate).reversed()).map(arg_0 -> this.matchReportData(arg_0)).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(reportInfoList)) {
            reportInfoList = new ArrayList();
        }
        for (ReportInfo reportInfo : reportInfoList) {
            if (!StringUtils.isBlank((CharSequence)reportInfo.getReportDate())) continue;
            reportInfo.setReportDate(reportInfo.getReportTime());
        }
        data.setReportList(reportInfoList);
        return BaseResponse.success((Object)data);
    }

    public BaseResponse<CheckReportDetailsRes> queryCheckReportDetail(CheckReportDetailsReq param) {
        CardDetailsInfoRespVO cardDetail;
        CheckReportDetailsRes reportDetail = new CheckReportDetailsRes();
        PacsReportListReq pacsReportListReq = new PacsReportListReq();
        pacsReportListReq.setReportNo(param.getReportNo());
        GatewayRequest gatewayRequest = this.getGateWayParam((NetReportBaseRequest)param, (Object)pacsReportListReq);
        GatewayResponse response = this.electronicReportClient.pacsReportList(gatewayRequest);
        PacsReportListRes gateWayData = (PacsReportListRes)this.checkHisResponse((BaseResponse)response);
        if (gateWayData == null) {
            return BaseResponse.success();
        }
        BeanUtils.copyProperties((Object)gateWayData, (Object)reportDetail);
        reportDetail.setAdmType("O");
        reportDetail.setAuthUser(gateWayData.getDoctorName());
        reportDetail.setCheckImages(gateWayData.getCheckImages());
        reportDetail.setPdfUrl(param.getPdfUrl());
        if (StringUtils.isNotBlank((CharSequence)param.getCardId()) && null != (cardDetail = this.getCardDetail(param.getCardId()))) {
            this.logger.error("\u3010\u68c0\u67e5\u62a5\u544a\u660e\u7ec6\u67e5\u8be2\u3011======\u83b7\u53d6\u60a3\u8005\u4fe1\u606f\u5931\u8d25=====");
            Date birth = DateUtils.stringToSimpleDate((String)cardDetail.getBirth());
            int age = 0;
            try {
                age = DateUtils.getAgeByBirth((Date)birth);
                reportDetail.setAge(String.valueOf(age));
            }
            catch (ParseException e) {
                this.logger.error("\u3010\u68c0\u67e5\u62a5\u544a\u660e\u7ec6\u67e5\u8be2\u3011======\u8f6c\u6362\u60a3\u8005\u5e74\u9f84\u5931\u8d25=====", (Object)e.getMessage());
            }
            reportDetail.setPatientName(cardDetail.getPatientName());
            reportDetail.setSex(String.valueOf(cardDetail.getGender()));
        }
        return BaseResponse.success((Object)reportDetail);
    }

    public BaseResponse<String> getReportOrGetPacsPDF(GetReportPDFReq param) {
        String URl = "/report/getReportOrGetPacsPDF";
        BaseResponse baseResponse = new BaseResponse();
        FrontResponse responseData = new FrontResponse();
        FrontRequest frontRequest = new FrontRequest();
        frontRequest.setTransactionId(UUID.randomUUID().toString());
        frontRequest.setBody((Object)param);
        frontRequest.setOrganCode("");
        frontRequest.setChannel("");
        try {
            String resultData = HttpKit.jsonPost((String)(this.constant.getHisurl() + URl), (String)JSON.toJSONString((Object)frontRequest));
            1 typeReference = new /* Unavailable Anonymous Inner Class!! */;
            responseData = (FrontResponse)JSONObject.parseObject((String)resultData, (Type)typeReference.getType(), (Feature[])new Feature[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if ("0".equals(responseData.getCode())) {
            return BaseResponse.error((String)responseData.getMessage());
        }
        baseResponse = BaseResponse.success((Object)responseData.getBody());
        return baseResponse;
    }

    private CardDetailsInfoRespVO getCardDetail(String cardId) {
        CardDetailsInfoReqVO cardDetailsInfoReqVO = new CardDetailsInfoReqVO();
        cardDetailsInfoReqVO.setCardId(cardId);
        cardDetailsInfoReqVO.setChannelCode("app");
        CardDetailsInfoRespVO respVO = this.getCardInfoUtil.getCardDetail(cardDetailsInfoReqVO);
        return respVO;
    }

    private ReportDetailData matchJyReportDetail(LisReportListResData lisReportListResData) {
        ReportDetailData reportDetailData = new ReportDetailData();
        BeanUtils.copyProperties((Object)lisReportListResData, (Object)reportDetailData);
        List micDataList = lisReportListResData.getMicDatas();
        if (micDataList != null) {
            List detailMicDataList = micDataList.stream().map(arg_0 -> this.matchJyReportData(arg_0)).collect(Collectors.toList());
            reportDetailData.setMicDatas(detailMicDataList);
        }
        return reportDetailData;
    }

    private ReportDetailMicData matchJyReportData(LisReportListResMicData lisReportListResMicData) {
        ReportDetailMicData reportDetailMicData = new ReportDetailMicData();
        BeanUtils.copyProperties((Object)lisReportListResMicData, (Object)reportDetailMicData);
        return reportDetailMicData;
    }

    private ReportInfo matchReportData(GetReportListsData hisReportData) {
        ReportInfo reportData = new ReportInfo();
        reportData.setReportNo(hisReportData.getReportNo());
        reportData.setReportName(hisReportData.getReportName());
        reportData.setReportType(hisReportData.getReportType());
        reportData.setReportDate(hisReportData.getReportDate());
        reportData.setReportTime(hisReportData.getReportTime());
        reportData.setDeptName(hisReportData.getDeptName());
        reportData.setDiagnosis(hisReportData.getClinicalDiagnosis());
        reportData.setDoctorName(hisReportData.getReportDoctorName());
        reportData.setTsName(hisReportData.getTsName());
        reportData.setTsCode(hisReportData.getTsCode());
        return reportData;
    }

    private <T> T checkHisResponse(BaseResponse<T> response) {
        if (response == null) {
            this.logger.error("request his gateway error - \u65e0\u54cd\u5e94");
            return null;
        }
        if (!response.isSuccess()) {
            this.logger.error("request his gateway error - \u8bf7\u6c42\u7ed3\u679c-\u5931\u8d25");
            return null;
        }
        if (response.getData() == null) {
            this.logger.error("request his gateway error - \u8fd4\u56de\u5b9e\u4f53\u6570\u636e\u5f02\u5e38");
            return null;
        }
        return (T)response.getData();
    }

    private <T> GatewayRequest<T> getGateWayParam(NetReportBaseRequest baseRequest, T body) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        gatewayRequest.setOrganCode(baseRequest.getOrganCode());
        gatewayRequest.setBody(body);
        gatewayRequest.setChannel(baseRequest.getChannel());
        gatewayRequest.setChannelName(baseRequest.getChannelName());
        String transactionId = UUID.randomUUID().toString();
        gatewayRequest.setTransactionId(transactionId);
        this.logger.info("his gateway - transactionId:{}", (Object)transactionId);
        return gatewayRequest;
    }
}

