/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.his.api.HisBillApi;
import com.ebaiyihui.his.api.MedicalCardApi;
import com.ebaiyihui.his.pojo.vo.base.GatewayRequest;
import com.ebaiyihui.his.pojo.vo.base.GatewayResponse;
import com.ebaiyihui.his.pojo.vo.bill.GetRealTimeHisBillInfoRes;
import com.ebaiyihui.his.pojo.vo.bill.GetRealTimeHisBillInfoResItem;
import com.ebaiyihui.his.pojo.vo.bill.GetRealTimeHisBillReqVo;
import com.ebaiyihui.his.pojo.vo.card.QueryCardInfoReqVO;
import com.ebaiyihui.his.pojo.vo.card.QueryCardInfoResVO;
import com.ebaiyihui.wisdommedical.common.constant.ProPropertiesConstant;
import com.ebaiyihui.wisdommedical.common.enums.AdmTimeRangeEnum;
import com.ebaiyihui.wisdommedical.common.enums.AppointmentStatusEnum;
import com.ebaiyihui.wisdommedical.common.enums.ChannelEnum;
import com.ebaiyihui.wisdommedical.exception.BillException;
import com.ebaiyihui.wisdommedical.mapper.AppointmentRecordMapper;
import com.ebaiyihui.wisdommedical.mapper.DoctorRecordMapper;
import com.ebaiyihui.wisdommedical.mapper.InpatientDepositDetailEntityMapper;
import com.ebaiyihui.wisdommedical.mapper.InpatientPayorderEntityMapper;
import com.ebaiyihui.wisdommedical.mapper.OpBusinessOrderDetailEntityMapper;
import com.ebaiyihui.wisdommedical.mapper.OpBusinessOrderEntityMapper;
import com.ebaiyihui.wisdommedical.mapper.OpRechargePaymentOrderEntityMapper;
import com.ebaiyihui.wisdommedical.model.AppointmentRecordEntity;
import com.ebaiyihui.wisdommedical.model.DoctorRecordEntity;
import com.ebaiyihui.wisdommedical.model.OpBusinessOrderDetailEntity;
import com.ebaiyihui.wisdommedical.model.OpBusinessOrderEntity;
import com.ebaiyihui.wisdommedical.model.OpRechargePaymentOrderEntity;
import com.ebaiyihui.wisdommedical.pojo.medicalInsurance.res.ConsultationHealtInuranceRes;
import com.ebaiyihui.wisdommedical.pojo.vo.CheckOrderReqVo;
import com.ebaiyihui.wisdommedical.pojo.vo.CheckOrderResVo;
import com.ebaiyihui.wisdommedical.pojo.vo.OrderRecordPageResult;
import com.ebaiyihui.wisdommedical.pojo.vo.OrderRecordReqVo;
import com.ebaiyihui.wisdommedical.pojo.vo.OrderRecordResVo;
import com.ebaiyihui.wisdommedical.pojo.vo.OutPatientOrderRecordPageResult;
import com.ebaiyihui.wisdommedical.pojo.vo.OutpatientOrderRecordDetailVO;
import com.ebaiyihui.wisdommedical.pojo.vo.repsvo.OutPatientOrderRecordResVo;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.OutPatientOrderRecordReqVo;
import com.ebaiyihui.wisdommedical.service.OrderService;
import com.ebaiyihui.wisdommedical.util.CommonUtils;
import com.ebaiyihui.wisdommedical.util.DateUtils;
import com.ebaiyihui.wisdommedical.util.SnowflakeIdWorker;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class OrderServiceImpl
implements OrderService {
    private static final Logger log = LoggerFactory.getLogger(OrderServiceImpl.class);
    public static final String GET_REAL_TIME_HIS_BILL_INFO = "getRealTimeHisBillInfo";
    public static final String REFUND_FLAG = "1";
    public static final String NOT_REFUND_FLAG = "0";
    public static final List<String> APPOINT_ORDER_STATUS_LIST = Arrays.asList("11", "15", "16", "17", "18");
    public static final List<String> OUTPATIENT_ORDER_STATUS_LIST = Arrays.asList("1", "3", "8", "9", "10", "11", "12");
    @Autowired
    private InpatientDepositDetailEntityMapper inpatientDepositDetailEntityMapper;
    public static final String PAID = "1";
    @Autowired
    private ProPropertiesConstant propertiesConstant;
    @Autowired
    private AppointmentRecordMapper appointmentRecordMapper;
    @Autowired
    private HisBillApi hisBillApi;
    @Autowired
    private SnowflakeIdWorker snowflakeIdWorker;
    @Autowired
    private OpBusinessOrderEntityMapper opBusinessOrderEntityMapper;
    @Autowired
    private OpRechargePaymentOrderEntityMapper opRechargePaymentOrderEntityMapper;
    @Autowired
    private InpatientDepositDetailEntityMapper depositDetailEntityMapper;
    @Autowired
    private InpatientPayorderEntityMapper payorderEntityMapper;
    @Autowired
    private OpBusinessOrderDetailEntityMapper opBusinessOrderDetailEntityMapper;
    @Autowired
    private DoctorRecordMapper doctorRecordMapper;
    @Autowired
    private MedicalCardApi cardApi;

    public OrderRecordPageResult getAppointmentOrderList(OrderRecordReqVo orderRecordReqVo) {
        log.info("\u3010\u7ba1\u7406\u7aef\u67e5\u8be2\u6302\u53f7\u8ba2\u5355\u5217\u8868\u3011\u8bf7\u6c42\u5165\u53c2 orderRecordReqVo" + JSON.toJSONString((Object)orderRecordReqVo));
        OrderRecordPageResult pageResult = new OrderRecordPageResult();
        PageHelper.startPage((int)orderRecordReqVo.getPageNum(), (int)orderRecordReqVo.getPageSize());
        Page page = this.appointmentRecordMapper.selectPageByOrderRecordReqVo(orderRecordReqVo);
        int totalCount = this.appointmentRecordMapper.getOrderCount(orderRecordReqVo.getHospitalCode(), orderRecordReqVo.getPlatform());
        int registeredCount = this.appointmentRecordMapper.getRegisteredCount(orderRecordReqVo);
        int appointedCount = this.appointmentRecordMapper.getAppointedCount(orderRecordReqVo);
        String registeredAmount = this.appointmentRecordMapper.getRegisteredAmount(orderRecordReqVo);
        pageResult.setTotalCount(Integer.valueOf(totalCount));
        pageResult.setRegisteredCount(Integer.valueOf(registeredCount));
        pageResult.setAppointedCount(Integer.valueOf(appointedCount));
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)registeredAmount)) {
            pageResult.setRegisteredAmount(new BigDecimal(registeredAmount));
        } else {
            pageResult.setRegisteredAmount(new BigDecimal(0));
        }
        List appointmentRecordEntityList = page.getResult();
        if (CollectionUtils.isEmpty((Collection)appointmentRecordEntityList)) {
            pageResult.setContent(new ArrayList());
            return pageResult;
        }
        List orderRecordResVoList = this.getOrderRecordResVoList(appointmentRecordEntityList);
        if (CollectionUtils.isEmpty((Collection)orderRecordResVoList)) {
            pageResult.setContent(new ArrayList());
        } else {
            pageResult.setContent(orderRecordResVoList);
        }
        Long total = page.getTotal();
        double totalPages = (double)page.getTotal() / (double)page.getPageSize();
        pageResult.setPageSize(page.getPageSize());
        pageResult.setTotal(total.intValue());
        pageResult.setPageNum(page.getPageNum());
        pageResult.setTotalPages((int)Math.ceil(totalPages));
        log.info("\u8fd4\u56de\u6570\u636epageResult: " + pageResult);
        return pageResult;
    }

    public OutPatientOrderRecordPageResult getOutPatientOrderList(OutPatientOrderRecordReqVo orderRecordReqVo) {
        OutPatientOrderRecordPageResult pageResult = new OutPatientOrderRecordPageResult();
        PageHelper.startPage((int)orderRecordReqVo.getPageNum(), (int)orderRecordReqVo.getPageSize());
        String orderStatusReq = "1".equals(orderRecordReqVo.getOrderStatus()) ? "'" + StringUtils.join((Collection)OUTPATIENT_ORDER_STATUS_LIST, (String)"','") + "'" : orderRecordReqVo.getOrderStatus();
        orderRecordReqVo.setOrderStatus(orderStatusReq);
        Page page = this.opBusinessOrderEntityMapper.selectByOrderRecordReqVo(orderRecordReqVo);
        int totalCount = this.opBusinessOrderEntityMapper.getOrderCount(orderRecordReqVo);
        int paidCount = this.opBusinessOrderEntityMapper.getPaidCount(orderRecordReqVo);
        String paidAmount = this.opBusinessOrderEntityMapper.getPaidAmount(orderRecordReqVo);
        pageResult.setTotalCount(Integer.valueOf(totalCount));
        pageResult.setPaidCount(Integer.valueOf(paidCount));
        if (org.apache.commons.lang3.StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{paidAmount})) {
            pageResult.setPaidAmount(new BigDecimal(paidAmount));
        } else {
            pageResult.setPaidAmount(new BigDecimal(0));
        }
        List orderRecordResVoList = page.getResult();
        if (CollectionUtils.isEmpty((Collection)orderRecordResVoList)) {
            pageResult.setContent(new ArrayList());
            return pageResult;
        }
        for (OutPatientOrderRecordResVo orderRecordResVo : orderRecordResVoList) {
            String orderStatus;
            if (null != orderRecordResVo.getYbInfo()) {
                ConsultationHealtInuranceRes consultationHealtInuranceRes = (ConsultationHealtInuranceRes)JSONObject.parseObject((String)orderRecordResVo.getYbInfo(), ConsultationHealtInuranceRes.class);
                orderRecordResVo.setFundPay(consultationHealtInuranceRes.getFundPay());
                orderRecordResVo.setOwnPayAmt(consultationHealtInuranceRes.getOwnPayAmt());
                orderRecordResVo.setPsnAcctPay(consultationHealtInuranceRes.getPsnAcctPay());
            }
            if (OUTPATIENT_ORDER_STATUS_LIST.contains(orderStatus = String.valueOf(orderRecordResVo.getOrderStatus()))) {
                orderStatus = "1";
            }
            orderRecordResVo.setOrderStatus(Integer.valueOf(Integer.parseInt(orderStatus)));
            orderRecordResVo.setPatientIdCard(CommonUtils.idEncrypt((String)orderRecordResVo.getPatientIdCard()));
        }
        pageResult.setContent(orderRecordResVoList);
        Long total = page.getTotal();
        double totalPages = (double)page.getTotal() / (double)page.getPageSize();
        pageResult.setPageSize(page.getPageSize());
        pageResult.setTotal(total.intValue());
        pageResult.setPageNum(page.getPageNum());
        pageResult.setTotalPages((int)Math.ceil(totalPages));
        return pageResult;
    }

    public CheckOrderResVo checkOutPatientOrderWhetherRefund(CheckOrderReqVo checkOrderReqVo) throws BillException {
        CheckOrderResVo checkOrderResVo = new CheckOrderResVo();
        OpBusinessOrderEntity opBusinessOrderEntity = this.opBusinessOrderEntityMapper.selectByOutPatientId(checkOrderReqVo.getOutPatientId());
        if (null == opBusinessOrderEntity) {
            throw new BillException("\u67e5\u8be2\u8ba2\u5355\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        List opBusinessOrderDetailEntityList = this.opBusinessOrderDetailEntityMapper.selectByOutPatientId(checkOrderReqVo.getOutPatientId());
        if (CollectionUtils.isEmpty((Collection)opBusinessOrderDetailEntityList)) {
            throw new BillException("\u7f34\u8d39\u660e\u7ec6\u4e0d\u5b58\u5728");
        }
        OpRechargePaymentOrderEntity opRechargePaymentOrderEntity = this.opRechargePaymentOrderEntityMapper.selectByOutPatientId(checkOrderReqVo.getOutPatientId());
        if (null != opRechargePaymentOrderEntity) {
            checkOrderResVo.setPayTime(DateUtils.dateToFullString((Date)opRechargePaymentOrderEntity.getCreateTime()));
            checkOrderResVo.setPayBillNo(opRechargePaymentOrderEntity.getPayBillNo());
        }
        QueryCardInfoResVO queryCardInfoResVO = new QueryCardInfoResVO();
        queryCardInfoResVO = this.getCardInfo(opBusinessOrderEntity.getCardNo(), ChannelEnum.MANAGER.getValue());
        if (null != queryCardInfoResVO) {
            checkOrderResVo.setMobile(queryCardInfoResVO.getTelephone());
        }
        checkOrderResVo.setPatientName(opBusinessOrderEntity.getPatientName());
        checkOrderResVo.setPatientGender(opBusinessOrderEntity.getPatientGender());
        checkOrderResVo.setPatientAge(Integer.valueOf(opBusinessOrderEntity.getPatientAge()));
        checkOrderResVo.setPatientIdCard(CommonUtils.idEncrypt((String)opBusinessOrderEntity.getIdCard()));
        checkOrderResVo.setDoctorName(opBusinessOrderEntity.getDocName());
        DoctorRecordEntity doctorRecordEntity = this.doctorRecordMapper.getDoctorRecordByDoctorCodeAndHosCode(opBusinessOrderEntity.getDocCode(), opBusinessOrderEntity.getOrganCode());
        if (null != doctorRecordEntity) {
            checkOrderResVo.setDoctorTitleName(doctorRecordEntity.getRegTitelName());
        }
        checkOrderResVo.setDeptName(opBusinessOrderEntity.getDeptName());
        checkOrderResVo.setAdmDate(opBusinessOrderEntity.getAdmTime().split(" ")[0]);
        checkOrderResVo.setCreateTime(DateUtils.dateToFullString((Date)opBusinessOrderEntity.getCreateTime()));
        ArrayList<OutpatientOrderRecordDetailVO> detailVOList = new ArrayList<OutpatientOrderRecordDetailVO>();
        int totalNum = 0;
        BigDecimal totalAmount = new BigDecimal(0);
        for (OpBusinessOrderDetailEntity opBusinessOrderDetailEntity : opBusinessOrderDetailEntityList) {
            OutpatientOrderRecordDetailVO detailVO = new OutpatientOrderRecordDetailVO();
            detailVO.setItemName(opBusinessOrderDetailEntity.getItemName());
            detailVO.setPrice(opBusinessOrderDetailEntity.getPrice());
            detailVO.setAmount(opBusinessOrderDetailEntity.getMoney());
            detailVO.setNum(Integer.valueOf(opBusinessOrderDetailEntity.getQuantity().intValue()));
            totalNum += opBusinessOrderDetailEntity.getQuantity().intValue();
            totalAmount = totalAmount.add(opBusinessOrderDetailEntity.getMoney());
            detailVOList.add(detailVO);
        }
        checkOrderResVo.setTotalNum(Integer.valueOf(totalNum));
        checkOrderResVo.setTotalAmount(totalAmount);
        checkOrderResVo.setDetailList(detailVOList);
        return checkOrderResVo;
    }

    public OutPatientOrderRecordPageResult getHosOrderList(OutPatientOrderRecordReqVo orderRecordReqVo) {
        OutPatientOrderRecordPageResult pageResult = new OutPatientOrderRecordPageResult();
        PageHelper.startPage((int)orderRecordReqVo.getPageNum(), (int)orderRecordReqVo.getPageSize());
        Page page = this.inpatientDepositDetailEntityMapper.selectList(orderRecordReqVo);
        int totalCount = this.inpatientDepositDetailEntityMapper.getOrderCount(orderRecordReqVo);
        int paidCount = this.inpatientDepositDetailEntityMapper.getPaidCount(orderRecordReqVo);
        String paidAmount = this.inpatientDepositDetailEntityMapper.getPaidAmount(orderRecordReqVo);
        pageResult.setTotalCount(Integer.valueOf(totalCount));
        pageResult.setPaidCount(Integer.valueOf(paidCount));
        if (org.apache.commons.lang3.StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{paidAmount})) {
            pageResult.setPaidAmount(new BigDecimal(paidAmount));
        } else {
            pageResult.setPaidAmount(new BigDecimal(0));
        }
        List orderRecordResVoList = page.getResult();
        if (CollectionUtils.isEmpty((Collection)orderRecordResVoList)) {
            pageResult.setContent(new ArrayList());
            return pageResult;
        }
        pageResult.setContent(orderRecordResVoList);
        Long total = page.getTotal();
        double totalPages = (double)page.getTotal() / (double)page.getPageSize();
        pageResult.setPageSize(page.getPageSize());
        pageResult.setTotal(total.intValue());
        pageResult.setPageNum(page.getPageNum());
        pageResult.setTotalPages((int)Math.ceil(totalPages));
        return pageResult;
    }

    private List<GetRealTimeHisBillInfoResItem> buildGetRealTimeHisBillReq(String seriaNo, String payType, String startDate, String endDate) throws BillException {
        GatewayRequest gatewayRequest = new GatewayRequest();
        GetRealTimeHisBillReqVo getRealTimeHisBillReqVo = new GetRealTimeHisBillReqVo();
        getRealTimeHisBillReqVo.setSerialNo(seriaNo);
        getRealTimeHisBillReqVo.setPayType(payType);
        getRealTimeHisBillReqVo.setBeginTime(startDate);
        getRealTimeHisBillReqVo.setEndTime(endDate);
        gatewayRequest.setBody((Object)getRealTimeHisBillReqVo);
        gatewayRequest.setKeyWord(GET_REAL_TIME_HIS_BILL_INFO);
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        gatewayRequest.setChannel(ChannelEnum.MANAGER.getValue());
        gatewayRequest.setChannelName(ChannelEnum.MANAGER.getDisplay());
        log.info("\u9a8c\u8bc1\u662f\u5426\u53ef\u9000\u6b3e \u67e5\u8be2\u5b9e\u65f6\u8ba2\u5355 \u8bf7\u6c42his\u5165\u53c2\uff1a" + gatewayRequest);
        GatewayResponse gatewayResponse = this.hisBillApi.getRealTimeHisBillInfo(gatewayRequest);
        log.info("\u9a8c\u8bc1\u662f\u5426\u53ef\u9000\u6b3e \u67e5\u8be2\u5b9e\u65f6\u8ba2\u5355 \u8bf7\u6c42his\u51fa\u53c2\uff1a" + gatewayResponse);
        if (gatewayResponse == null) {
            log.error("\u67e5\u8be2\u5b9e\u65f6\u8ba2\u5355 getRealTimeHisBillInfo -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            throw new BillException("\u67e5\u8be2\u5b9e\u65f6\u8ba2\u5355\u5f02\u5e38");
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u67e5\u8be2\u5b9e\u65f6\u8ba2\u5355 getRealTimeHisBillInfo -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            throw new BillException("\u67e5\u8be2\u5b9e\u65f6\u8ba2\u5355\u5f02\u5e38");
        }
        if (gatewayResponse.getData() == null) {
            log.error("\u67e5\u8be2\u5b9e\u65f6\u8ba2\u5355 getRealTimeHisBillInfo -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            throw new BillException("\u67e5\u8be2\u5b9e\u65f6\u8ba2\u5355\u5f02\u5e38");
        }
        GetRealTimeHisBillInfoRes getRealTimeHisBillInfoRes = (GetRealTimeHisBillInfoRes)gatewayResponse.getData();
        return getRealTimeHisBillInfoRes.getItems();
    }

    private List<OrderRecordResVo> getOrderRecordResVoList(List<AppointmentRecordEntity> orderRecordResVoList) {
        ArrayList<OrderRecordResVo> manageOrderRecordResVoList = new ArrayList<OrderRecordResVo>();
        if (null == orderRecordResVoList || orderRecordResVoList.isEmpty()) {
            return null;
        }
        for (AppointmentRecordEntity appointmentRecordEntity : orderRecordResVoList) {
            OrderRecordResVo orderRecordResVo = new OrderRecordResVo();
            if (null != appointmentRecordEntity.getYbInfo()) {
                ConsultationHealtInuranceRes consultationHealtInuranceRes = (ConsultationHealtInuranceRes)JSONObject.parseObject((String)appointmentRecordEntity.getYbInfo(), ConsultationHealtInuranceRes.class);
                orderRecordResVo.setFundPay(consultationHealtInuranceRes.getFundPay());
                orderRecordResVo.setOwnPayAmt(consultationHealtInuranceRes.getOwnPayAmt());
                orderRecordResVo.setPsnAcctPay(consultationHealtInuranceRes.getPsnAcctPay());
            }
            orderRecordResVo.setCreateTime(appointmentRecordEntity.getCreatetime());
            orderRecordResVo.setOrderMoney(appointmentRecordEntity.getPayAmount());
            orderRecordResVo.setOrderSeq(appointmentRecordEntity.getSysAppointmentId());
            Integer appointStatus = appointmentRecordEntity.getAppointStatus();
            if (APPOINT_ORDER_STATUS_LIST.contains(String.valueOf(appointStatus))) {
                appointStatus = AppointmentStatusEnum.WAIT_HIS_CONFIRM.getValue();
            }
            orderRecordResVo.setOrderStatus(appointStatus);
            orderRecordResVo.setPatientIdCard(CommonUtils.idEncrypt((String)appointmentRecordEntity.getPatientIdCard()));
            orderRecordResVo.setPatientName(appointmentRecordEntity.getPatientName());
            orderRecordResVo.setDeptName(appointmentRecordEntity.getDeptName());
            orderRecordResVo.setDoctorName(appointmentRecordEntity.getDocName());
            orderRecordResVo.setAppointTime(appointmentRecordEntity.getAdmDate() + AdmTimeRangeEnum.getDisplay((Integer)appointmentRecordEntity.getAdmRange()));
            manageOrderRecordResVoList.add(orderRecordResVo);
        }
        return manageOrderRecordResVoList;
    }

    private QueryCardInfoResVO getCardInfo(String cardNo, String channelName) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        QueryCardInfoReqVO queryCardInfoReqVO = new QueryCardInfoReqVO();
        queryCardInfoReqVO.setCardNo(cardNo);
        queryCardInfoReqVO.setCredNo(cardNo);
        gatewayRequest.setBody((Object)queryCardInfoReqVO);
        gatewayRequest.setChannel(channelName);
        gatewayRequest.setChannelName(channelName);
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("QueryCardInfoReqVO");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        log.info("\u3010\u67e5\u8be2\u5c31\u8bca\u5361\u4fe1\u606f\u3011\u8bf7\u6c42his\u5165\u53c2\uff1a" + gatewayRequest);
        GatewayResponse gatewayResponse = this.cardApi.queryCardInfo(gatewayRequest);
        log.info("\u3010\u67e5\u8be2\u5c31\u8bca\u5361\u4fe1\u606f\u3011\u8bf7\u6c42his\u51fa\u53c2\uff1a" + gatewayResponse);
        if (gatewayResponse == null) {
            log.error("\u3010\u67e5\u8be2\u5c31\u8bca\u5361\u4fe1\u606f\u3011queryCardInfo -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            return null;
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u3010\u67e5\u8be2\u5c31\u8bca\u5361\u4fe1\u606f\u3011 queryCardInfo -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            return null;
        }
        if (gatewayResponse.getData() == null) {
            log.error("\u3010\u67e5\u8be2\u5c31\u8bca\u5361\u4fe1\u606f\u3011 queryCardInfo -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            return null;
        }
        QueryCardInfoResVO queryCardInfoResVO = (QueryCardInfoResVO)gatewayResponse.getData();
        return queryCardInfoResVO;
    }
}

