/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.his.api.AppointApi;
import com.ebaiyihui.his.api.HisBillApi;
import com.ebaiyihui.his.api.OutpatientPaymentApi;
import com.ebaiyihui.his.pojo.vo.appoint.DayRegisterMsg;
import com.ebaiyihui.his.pojo.vo.appoint.DayRegisterReq;
import com.ebaiyihui.his.pojo.vo.appoint.DayRegisterRes;
import com.ebaiyihui.his.pojo.vo.base.FrontRequest;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.his.pojo.vo.base.GatewayRequest;
import com.ebaiyihui.his.pojo.vo.base.GatewayResponse;
import com.ebaiyihui.his.pojo.vo.bill.RefundCallBackReq;
import com.ebaiyihui.his.pojo.vo.bill.RefundCallBackRes;
import com.ebaiyihui.his.pojo.vo.hospitalization.DepositRes;
import com.ebaiyihui.his.pojo.vo.outpatient.ComfirmPayNewReq;
import com.ebaiyihui.his.pojo.vo.outpatient.ComfirmPayNewRes;
import com.ebaiyihui.his.pojo.vo.outpatient.GetRecipelReq;
import com.ebaiyihui.his.pojo.vo.outpatient.GetRecipelRes;
import com.ebaiyihui.his.pojo.vo.outpatient.items.GetPayRecordsResItems;
import com.ebaiyihui.his.pojo.vo.outpatient.respmsg.ComfirmPayNewReqMsg;
import com.ebaiyihui.wisdommedical.common.constant.ProPropertiesConstant;
import com.ebaiyihui.wisdommedical.common.enums.AppointmentStatusEnum;
import com.ebaiyihui.wisdommedical.common.enums.BusinessTypeEnums;
import com.ebaiyihui.wisdommedical.common.enums.ChannelEnum;
import com.ebaiyihui.wisdommedical.common.enums.DayAppointRefundCodeEnum;
import com.ebaiyihui.wisdommedical.common.enums.PayChannelEnum;
import com.ebaiyihui.wisdommedical.common.enums.medical.BusinessOrderStatusEnum;
import com.ebaiyihui.wisdommedical.common.enums.medical.PayStatusEnum;
import com.ebaiyihui.wisdommedical.common.enums.medical.YBPayStatusEnum;
import com.ebaiyihui.wisdommedical.exception.AppointmentException;
import com.ebaiyihui.wisdommedical.exception.InHospitalException;
import com.ebaiyihui.wisdommedical.exception.OutpatientPaymentException;
import com.ebaiyihui.wisdommedical.mapper.AppointmentPayorderMapper;
import com.ebaiyihui.wisdommedical.mapper.AppointmentRecordMapper;
import com.ebaiyihui.wisdommedical.mapper.BusinessResultMapper;
import com.ebaiyihui.wisdommedical.mapper.InpatientDepositDetailEntityMapper;
import com.ebaiyihui.wisdommedical.mapper.InpatientPayorderEntityMapper;
import com.ebaiyihui.wisdommedical.mapper.OpBusinessOrderDetailEntityMapper;
import com.ebaiyihui.wisdommedical.mapper.OpBusinessOrderEntityMapper;
import com.ebaiyihui.wisdommedical.mapper.OpGuideEntityMapper;
import com.ebaiyihui.wisdommedical.mapper.OpRechargePaymentOrderEntityMapper;
import com.ebaiyihui.wisdommedical.mapper.ScheduleDetailRecordMapper;
import com.ebaiyihui.wisdommedical.mapper.ScheduleRecordMapper;
import com.ebaiyihui.wisdommedical.model.AppointmentPayorderEntity;
import com.ebaiyihui.wisdommedical.model.AppointmentRecordEntity;
import com.ebaiyihui.wisdommedical.model.BusinessResultEntity;
import com.ebaiyihui.wisdommedical.model.InpatientDepositDetailEntity;
import com.ebaiyihui.wisdommedical.model.OpBusinessOrderDetailEntity;
import com.ebaiyihui.wisdommedical.model.OpBusinessOrderEntity;
import com.ebaiyihui.wisdommedical.model.OpGuideEntity;
import com.ebaiyihui.wisdommedical.model.OpRechargePaymentOrderEntity;
import com.ebaiyihui.wisdommedical.pojo.dto.InHospDepostPayCallDTO;
import com.ebaiyihui.wisdommedical.pojo.medicalInsurance.req.OutpatientRegistratConfirmatReqVo;
import com.ebaiyihui.wisdommedical.pojo.medicalInsurance.req.RegConfirmatReqVo;
import com.ebaiyihui.wisdommedical.pojo.medicalInsurance.req.SettlementConfirmationReq;
import com.ebaiyihui.wisdommedical.pojo.medicalInsurance.req.confirmMedicalReq;
import com.ebaiyihui.wisdommedical.pojo.medicalInsurance.res.ConsultationHealtInuranceRes;
import com.ebaiyihui.wisdommedical.pojo.medicalInsurance.res.OutpatientRegistratConfirmatData;
import com.ebaiyihui.wisdommedical.pojo.medicalInsurance.res.RegConfirmatResVo;
import com.ebaiyihui.wisdommedical.pojo.medicalInsurance.res.SettlementConfirmationRes;
import com.ebaiyihui.wisdommedical.pojo.medicalInsurance.res.confirmMedicalRes;
import com.ebaiyihui.wisdommedical.pojo.vo.PayPlatformCallBackVoRes;
import com.ebaiyihui.wisdommedical.pojo.vo.RequestRefundOrderVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.ResponseNotifyRestVo;
import com.ebaiyihui.wisdommedical.pojo.vo.ResponseRefundNotifyRestVo;
import com.ebaiyihui.wisdommedical.pojo.yb.PayNotifyReqVO;
import com.ebaiyihui.wisdommedical.pojo.yb.TencentNotifyResponse;
import com.ebaiyihui.wisdommedical.service.AppointmentService;
import com.ebaiyihui.wisdommedical.service.IWaitingQueueService;
import com.ebaiyihui.wisdommedical.service.InHospitalService;
import com.ebaiyihui.wisdommedical.service.PayCallBackService;
import com.ebaiyihui.wisdommedical.service.PushService;
import com.ebaiyihui.wisdommedical.service.impl.PayCallBackServiceImpl;
import com.ebaiyihui.wisdommedical.util.DateUtils;
import com.ebaiyihui.wisdommedical.util.HttpKit;
import com.ebaiyihui.wisdommedical.util.SnowflakeIdWorker;
import com.ebaiyihui.wisdommedical.util.XmlUtil;
import com.ebaiyihui.wisdommedical.util.wx.NotifyRequest;
import com.ebaiyihui.wisdommedical.util.wx.WXPayUtil;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import redis.clients.jedis.JedisCluster;

@Service
public class PayCallBackServiceImpl
implements PayCallBackService {
    private static final Logger log = LoggerFactory.getLogger(PayCallBackServiceImpl.class);
    public static final String ACCEPT_REQUEST = "0";
    public static final String PAY_SUCCESS = "3";
    public static final String SUCCESS = "Y";
    public static final String HIS_SUCCESS = "1";
    @Autowired
    private JedisCluster jedisCluster;
    public static final byte TO_BE_PAID = 0;
    public static final byte PAID = 1;
    @Autowired
    private AppointmentRecordMapper appointmentRecordMapper;
    public static final String DEFAULT_SUCCESS_CODE = "1";
    @Autowired
    private AppointApi appointApi;
    @Autowired
    private ProPropertiesConstant constant;
    @Autowired
    private HisBillApi hisBillApi;
    @Autowired
    private ScheduleDetailRecordMapper scheduleDetailRecordMapper;
    @Autowired
    private SnowflakeIdWorker snowflakeIdWorker;
    @Autowired
    private AppointmentPayorderMapper appointmentPayOrderMapper;
    @Autowired
    private ScheduleRecordMapper scheduleRecordMapper;
    @Autowired
    private BusinessResultMapper businessResultMapper;
    @Autowired
    private AppointmentService appointmentService;
    @Autowired
    private PushService pushService;
    @Autowired
    private TaskExecutor taskExecutor;
    @Autowired
    private IWaitingQueueService iWaitingQueueService;
    @Autowired
    private ProPropertiesConstant propertiesConstant;
    @Autowired
    private OpBusinessOrderEntityMapper opBusinessOrderEntityMapper;
    @Autowired
    private OpRechargePaymentOrderEntityMapper opRechargePaymentOrderEntityMapper;
    @Autowired
    private InpatientDepositDetailEntityMapper inpatientDepositDetailEntityMapper;
    @Autowired
    private InpatientPayorderEntityMapper inpatientPayorderEntityMapper;
    @Autowired
    private InHospitalService inHospitalService;
    @Autowired
    private OpGuideEntityMapper opGuideEntityMapper;
    @Autowired
    private OutpatientPaymentApi outpatientPaymentApi;
    @Autowired
    private OpBusinessOrderDetailEntityMapper opBusinessOrderDetailEntityMapper;

    public void dayAppointmentCallBack(ResponseNotifyRestVo responseNotifyRestVo) throws AppointmentException {
        log.info("\u5f53\u65e5\u6302\u53f7\u652f\u4ed8\u56de\u8c03responseNotifyRestVo: " + JSON.toJSONString((Object)responseNotifyRestVo.toString()));
        String sysAppointmentId = responseNotifyRestVo.getOutTradeNo();
        AppointmentRecordEntity appointmentRecordEntity = this.appointmentRecordMapper.selectBySysAppointId(sysAppointmentId);
        AppointmentPayorderEntity payOrderEntity = this.saveAppointmentPayorder(responseNotifyRestVo, appointmentRecordEntity);
        if (AppointmentStatusEnum.WAIT_PAY.getValue().intValue() != appointmentRecordEntity.getAppointStatus().intValue()) {
            return;
        }
        this.waitHisConfirm(responseNotifyRestVo, appointmentRecordEntity);
        GatewayRequest gatewayRequest = this.buildDayRegisterParams(appointmentRecordEntity, responseNotifyRestVo);
        BusinessResultEntity businessResultEntity = new BusinessResultEntity();
        businessResultEntity.setChannelCode(appointmentRecordEntity.getChannelCode());
        businessResultEntity.setBusinessType(new Byte(BusinessTypeEnums.PAI_CONFIRM.getValue().toString()));
        businessResultEntity.setHisRequest(JSON.toJSONString((Object)gatewayRequest));
        this.businessResultMapper.insertSelective(businessResultEntity);
        log.info("\u5f53\u65e5\u6302\u53f7\u652f\u4ed8\u8bf7\u6c42his\u5165\u53c2\uff1a" + JSON.toJSONString((Object)gatewayRequest));
        GatewayResponse dayRegisterGatewayRes = this.appointApi.dayRegister(gatewayRequest);
        log.info("\u5f53\u65e5\u6302\u53f7\u652f\u4ed8\u8bf7\u6c42his\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)dayRegisterGatewayRes));
        if (null != dayRegisterGatewayRes) {
            businessResultEntity.setErrorCode(dayRegisterGatewayRes.getErrCode());
            businessResultEntity.setErrorMsg(dayRegisterGatewayRes.getMsg());
            businessResultEntity.setTransationId(dayRegisterGatewayRes.getTransactionId());
        }
        businessResultEntity.setHisResponse(JSON.toJSONString((Object)dayRegisterGatewayRes));
        businessResultEntity.setStatus(new Byte(ACCEPT_REQUEST));
        this.businessResultMapper.updateByPrimaryKeySelective(businessResultEntity);
        if (null == dayRegisterGatewayRes) {
            log.error("\u5f53\u65e5\u6302\u53f7\u652f\u4ed8 dayRegister -> \u8bf7\u6c42his\u4e0d\u901a,\u9000\u6b3e");
            BaseResponse baseResponse = this.appointRefund(appointmentRecordEntity, responseNotifyRestVo);
            if ("1".equals(baseResponse.getCode())) {
                appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.LAUNCH_AUTO_REFUND.getValue());
                appointmentRecordEntity.setRemark("\u8bf7\u6c42his\u4e0d\u901a,\u9000\u6b3e");
            } else {
                appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.LAUNCH_AUTO_REFUND_FAIL.getValue());
                appointmentRecordEntity.setRemark("\u8bf7\u6c42his\u4e0d\u901a\uff0c\u9000\u6b3e" + AppointmentStatusEnum.LAUNCH_AUTO_REFUND_FAIL.getDisplay());
            }
            this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecordEntity);
            throw new AppointmentException(dayRegisterGatewayRes.getMsg());
        }
        if (!"1".equals(dayRegisterGatewayRes.getCode())) {
            String remark = DayAppointRefundCodeEnum.getDisplay((Integer)Integer.parseInt(dayRegisterGatewayRes.getErrCode()));
            if (StringUtils.isNotBlank((String)remark)) {
                BaseResponse baseResponse = this.appointRefund(appointmentRecordEntity, responseNotifyRestVo);
                if ("1".equals(baseResponse.getCode())) {
                    appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.LAUNCH_AUTO_REFUND.getValue());
                    appointmentRecordEntity.setRemark(remark);
                } else {
                    appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.LAUNCH_AUTO_REFUND_FAIL.getValue());
                    appointmentRecordEntity.setRemark(remark + AppointmentStatusEnum.LAUNCH_AUTO_REFUND_FAIL.getDisplay());
                }
                this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecordEntity);
            } else {
                appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.APPOINT_FAIL.getValue());
                appointmentRecordEntity.setRemark(AppointmentStatusEnum.APPOINT_FAIL.getDisplay());
                this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecordEntity);
            }
            log.error("\u5f53\u65e5\u6302\u53f7 dayRegister -> his\u6302\u53f7\u5931\u8d25 err_code:{},mag:{}", (Object)dayRegisterGatewayRes.getErrCode(), (Object)dayRegisterGatewayRes.getMsg());
            throw new AppointmentException(dayRegisterGatewayRes.getMsg());
        }
        DayRegisterRes dayRegisterRes = (DayRegisterRes)dayRegisterGatewayRes.getData();
        this.updateHisReturnMsg(appointmentRecordEntity, dayRegisterRes);
        this.scheduleRecordMapper.updateByhospitalCodeAndscheduleHisId(appointmentRecordEntity.getHospitalCode(), appointmentRecordEntity.getScheduleHisId());
        this.scheduleDetailRecordMapper.updateByScheduleHisIdAndStartTime(appointmentRecordEntity.getScheduleHisId(), appointmentRecordEntity.getHospitalCode(), appointmentRecordEntity.getAdmTimeRange().substring(0, 5));
        this.updateAppointmentPayorder(appointmentRecordEntity, payOrderEntity, dayRegisterRes);
        this.taskExecutor.execute(() -> this.pushService.appointmentSuccessMsgPush(appointmentRecordEntity));
    }

    private BaseResponse<String> appointRefund(AppointmentRecordEntity appointmentRecordEntity, ResponseNotifyRestVo responseNotifyRestVo) {
        RequestRefundOrderVoReq requestRefundOrderVoReq = new RequestRefundOrderVoReq();
        requestRefundOrderVoReq.setPayChannel(appointmentRecordEntity.getPayChannelCode());
        requestRefundOrderVoReq.setMchCode(this.propertiesConstant.getMchCode());
        requestRefundOrderVoReq.setOutTradeNo(appointmentRecordEntity.getSysAppointmentId());
        requestRefundOrderVoReq.setDealTradeNo(responseNotifyRestVo.getDealTradeNo());
        requestRefundOrderVoReq.setTotalAmount(new BigDecimal("0.01"));
        requestRefundOrderVoReq.setRefundAmount(new BigDecimal("0.01"));
        log.info("\u5f53\u65e5\u6302\u53f7\u81ea\u52a8\u9000\u6b3e\u8bf7\u6c42\u53c2\u6570\u4e3a:{}", (Object)JSON.toJSONString((Object)requestRefundOrderVoReq));
        return this.refund(requestRefundOrderVoReq);
    }

    private BaseResponse<String> refund(RequestRefundOrderVoReq requestRefundOrderVoReq) {
        try {
            String body = HttpKit.jsonPost((String)this.propertiesConstant.getRefundUrl(), (String)JSON.toJSONString((Object)requestRefundOrderVoReq));
            BaseResponse response = (BaseResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)body), BaseResponse.class);
            return response;
        }
        catch (Exception e) {
            log.error("\u9000\u6b3e\u8bf7\u6c42\u5931\u8d25\uff0c\u539f\u56e0\u662f:{}", (Object)e.getMessage());
            return BaseResponse.error((String)e.getMessage());
        }
    }

    private AppointmentPayorderEntity saveAppointmentPayorder(ResponseNotifyRestVo responseNotifyRestVo, AppointmentRecordEntity appointmentRecordEntity) {
        AppointmentPayorderEntity payOrderEntity = new AppointmentPayorderEntity();
        payOrderEntity.setDealSeq(responseNotifyRestVo.getDealTradeNo());
        payOrderEntity.setMerchantId(responseNotifyRestVo.getMchId());
        payOrderEntity.setBizSysSeq(responseNotifyRestVo.getServiceCode());
        payOrderEntity.setPaymentTime(responseNotifyRestVo.getPayTime());
        payOrderEntity.setPayBillNo(responseNotifyRestVo.getTradeNo());
        payOrderEntity.setOrderStatus(new Byte(PAY_SUCCESS));
        payOrderEntity.setDealMoney(new BigDecimal(appointmentRecordEntity.getPayAmount()));
        payOrderEntity.setSysAppointmentId(appointmentRecordEntity.getSysAppointmentId());
        payOrderEntity.setBizDealSeq(String.valueOf(this.snowflakeIdWorker.nextId()));
        payOrderEntity.setUserId(appointmentRecordEntity.getUserId());
        payOrderEntity.setChannelCode(appointmentRecordEntity.getChannelCode());
        payOrderEntity.setHospitalCode(appointmentRecordEntity.getHospitalCode());
        this.appointmentPayOrderMapper.insertSelective(payOrderEntity);
        return payOrderEntity;
    }

    private void updateAppointmentPayorder(AppointmentRecordEntity appointmentRecordEntity, AppointmentPayorderEntity payOrderEntity, DayRegisterRes dayRegisterRes) {
        payOrderEntity.setUserId(appointmentRecordEntity.getUserId());
        payOrderEntity.setHospitalCode(appointmentRecordEntity.getHospitalCode());
        payOrderEntity.setBusinessByToDay(JSON.toJSONString((Object)dayRegisterRes));
        payOrderEntity.setChannelCode(appointmentRecordEntity.getChannelCode());
        payOrderEntity.setPatientId(appointmentRecordEntity.getPatientId());
        payOrderEntity.setPaymentSeq(appointmentRecordEntity.getPayChannelCode());
        this.appointmentPayOrderMapper.updateByPrimaryKey(payOrderEntity);
    }

    private void updateHisReturnMsg(AppointmentRecordEntity appointmentRecordEntity, DayRegisterRes dayRegisterRes) {
        List items = dayRegisterRes.getItems();
        appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.PAY.getValue());
        appointmentRecordEntity.setAdmId(dayRegisterRes.getAppointId());
        appointmentRecordEntity.setAppointmentId(dayRegisterRes.getAppointId());
        appointmentRecordEntity.setAdmTimeRange(dayRegisterRes.getAdmitTimeRange());
        appointmentRecordEntity.setTakeAddress(dayRegisterRes.getTakeAddress());
        appointmentRecordEntity.setAdmAddress(dayRegisterRes.getTakeAddress());
        appointmentRecordEntity.setTakeTime(dayRegisterRes.getTakeTime());
        appointmentRecordEntity.setAppointmentNo(dayRegisterRes.getNo());
        appointmentRecordEntity.setReceptId(dayRegisterRes.getReceiptId());
        appointmentRecordEntity.setAdmAddress(dayRegisterRes.getAdmitAddress());
        appointmentRecordEntity.setRemark("\u652f\u4ed8\u6210\u529f\uff0chis\u5f53\u65e5\u6302\u53f7\u786e\u8ba4\u6210\u529f");
        log.info("\u5f53\u65e5\u6302\u53f7\u652f\u4ed8\u4fdd\u5b58his\u8fd4\u56dereceiptId\u8ba2\u5355:" + JSON.toJSONString((Object)appointmentRecordEntity));
        this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecordEntity);
    }

    private void waitHisConfirm(ResponseNotifyRestVo responseNotifyRestVo, AppointmentRecordEntity appointmentRecordEntity) {
        appointmentRecordEntity.setPayAccdate(DateUtils.dateToString((Date)responseNotifyRestVo.getPayTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        appointmentRecordEntity.setPayPostId(responseNotifyRestVo.getMchId());
        appointmentRecordEntity.setPayTransationId(responseNotifyRestVo.getTradeNo());
        appointmentRecordEntity.setPayChannel(PayChannelEnum.getDisplay((String)responseNotifyRestVo.getPayChannel()));
        appointmentRecordEntity.setPayChannelCode(responseNotifyRestVo.getPayChannel());
        appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.WAIT_HIS_CONFIRM.getValue());
        appointmentRecordEntity.setRemark(AppointmentStatusEnum.WAIT_HIS_CONFIRM.getDisplay());
        log.info("\u9884\u7ea6\u6302\u53f7\u652f\u4ed8\u6210\u529f\uff0c\u5f85his\u786e\u8ba4\uff1a" + JSON.toJSONString((Object)appointmentRecordEntity));
        this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecordEntity);
    }

    private GatewayRequest<DayRegisterReq> buildDayRegisterParams(AppointmentRecordEntity appointmentRecordEntity, ResponseNotifyRestVo responseNotifyRestVo) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        DayRegisterReq dayRegisterReq = new DayRegisterReq();
        dayRegisterReq.setTimeArrangeId(appointmentRecordEntity.getHisTimeArrangeId());
        dayRegisterReq.setAdmNo(appointmentRecordEntity.getAdmId());
        dayRegisterReq.setCardNo(appointmentRecordEntity.getPatientCardNo());
        dayRegisterReq.setPatientId(appointmentRecordEntity.getPatientId());
        dayRegisterReq.setDeptNo(appointmentRecordEntity.getDeptCode());
        dayRegisterReq.setDoctorNo(appointmentRecordEntity.getDocCode());
        dayRegisterReq.setTimeFlag(String.valueOf(appointmentRecordEntity.getAdmRange()));
        dayRegisterReq.setPayChannel(responseNotifyRestVo.getPayChannel());
        dayRegisterReq.setFlowNo(appointmentRecordEntity.getSysAppointmentId());
        dayRegisterReq.setRbasId(appointmentRecordEntity.getScheduleHisId());
        dayRegisterReq.setRegFee(appointmentRecordEntity.getPayAmount());
        dayRegisterReq.setTimeArrangeId(appointmentRecordEntity.getHisTimeArrangeId());
        DayRegisterMsg dayRegisterMsg = new DayRegisterMsg();
        dayRegisterMsg.setAccdate(DateUtils.dateToString((Date)responseNotifyRestVo.getPayTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        dayRegisterMsg.setBusinessCode(responseNotifyRestVo.getServiceCode());
        dayRegisterMsg.setPayment(appointmentRecordEntity.getPayAmount());
        dayRegisterMsg.setOrderid(responseNotifyRestVo.getTradeNo());
        dayRegisterMsg.setSuccess(SUCCESS);
        dayRegisterMsg.setPosid(responseNotifyRestVo.getMchId());
        dayRegisterReq.setRespMsg(dayRegisterMsg);
        gatewayRequest.setBody((Object)dayRegisterReq);
        gatewayRequest.setChannel(appointmentRecordEntity.getChannelCode());
        gatewayRequest.setOrganCode(appointmentRecordEntity.getHospitalCode());
        gatewayRequest.setKeyWord("dayRegister");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    public void appointmentCallBack(ResponseNotifyRestVo responseNotifyRestVo) throws AppointmentException {
        log.info("\u9884\u7ea6\u6302\u53f7\u652f\u4ed8\u56de\u8c03responseNotifyRestVo: " + responseNotifyRestVo.toString());
        String sysAppointmentId = responseNotifyRestVo.getOutTradeNo();
        AppointmentRecordEntity appointmentRecordEntity = this.appointmentRecordMapper.selectBySysAppointId(sysAppointmentId);
        AppointmentPayorderEntity payOrderEntity = this.saveAppointmentPayorder(responseNotifyRestVo, appointmentRecordEntity);
        if (AppointmentStatusEnum.WAIT_PAY.getValue().intValue() != appointmentRecordEntity.getAppointStatus().intValue()) {
            return;
        }
        this.waitHisConfirm(responseNotifyRestVo, appointmentRecordEntity);
        this.appointmentService.payAppointmentPayToHis(appointmentRecordEntity, responseNotifyRestVo, payOrderEntity);
    }

    public List<PayPlatformCallBackVoRes> payPlatformCallBack(String posId, String tranDate) {
        return this.appointmentRecordMapper.selectByPayPosIdAndDate(posId, tranDate);
    }

    public void outpatientPaymentCallBack(ResponseNotifyRestVo responseNotifyRestVo) throws OutpatientPaymentException {
        String outPatientId = responseNotifyRestVo.getOutTradeNo();
        OpBusinessOrderEntity opBusinessOrderEntity = this.opBusinessOrderEntityMapper.selectByOutPatientId(outPatientId);
        OpRechargePaymentOrderEntity opRechargePaymentOrderEntity = this.opRechargePaymentOrderEntityMapper.selectByOutPatientId(outPatientId);
        opBusinessOrderEntity.setStatus(BusinessOrderStatusEnum.WAIT_CONFIRM.getValue());
        this.opBusinessOrderEntityMapper.updateByPrimaryKey(opBusinessOrderEntity);
        opRechargePaymentOrderEntity.setPayStatus(Byte.valueOf((byte)1));
        opRechargePaymentOrderEntity.setPayBillNo(responseNotifyRestVo.getTradeNo());
        opRechargePaymentOrderEntity.setPaymentTime(responseNotifyRestVo.getPayTime());
        opRechargePaymentOrderEntity.setMerchantId(responseNotifyRestVo.getMchId());
        opRechargePaymentOrderEntity.setUpdateTime(new Date());
        opRechargePaymentOrderEntity.setDealSeq(responseNotifyRestVo.getDealTradeNo());
        opRechargePaymentOrderEntity.setRemark("\u5df2\u652f\u4ed8");
        log.info("\u66f4\u65b0\u652f\u4ed8\u4fe1\u606f\uff0c\u53c2\u6570\u4e3aopRechargePaymentOrderEntity\uff1a{}", (Object)opRechargePaymentOrderEntity);
        this.opRechargePaymentOrderEntityMapper.updateByPrimaryKey(opRechargePaymentOrderEntity);
        GatewayRequest gatewayRequest = this.buildComfirmPayNewReq(opBusinessOrderEntity, opRechargePaymentOrderEntity, responseNotifyRestVo);
        GatewayResponse gatewayResponse = this.comfirmPayNew(gatewayRequest);
        String receiptId = ((ComfirmPayNewRes)gatewayResponse.getData()).getReceiptId();
        opBusinessOrderEntity.setReceiptId(receiptId);
        this.taskExecutor.execute(() -> this.pushService.outPatientSuccessMsgPush(opBusinessOrderEntity, DateUtils.dateToFullString((Date)opRechargePaymentOrderEntity.getPaymentTime())));
        OpGuideEntity opGuideEntity = this.buildOpGuideEntity(opBusinessOrderEntity, gatewayResponse);
        this.opGuideEntityMapper.insert(opGuideEntity);
        opBusinessOrderEntity.setStatus(BusinessOrderStatusEnum.PAID.getValue());
        opBusinessOrderEntity.setPayTime(responseNotifyRestVo.getPayTime());
        opBusinessOrderEntity.setRemark("\u5df2\u652f\u4ed8");
        this.opBusinessOrderEntityMapper.updateByPrimaryKey(opBusinessOrderEntity);
    }

    public void inHospDepositPayCallBack(ResponseNotifyRestVo responseNotifyRestVo) throws InHospitalException {
        InpatientDepositDetailEntity inpatientDepositDetailEntity = this.inpatientDepositDetailEntityMapper.selectByOrderSeq(responseNotifyRestVo.getOutTradeNo());
        InHospDepostPayCallDTO inHospDepostPayCallDTO = new InHospDepostPayCallDTO();
        inHospDepostPayCallDTO.setPayTime(DateUtils.dateToString((Date)responseNotifyRestVo.getPayTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        inHospDepostPayCallDTO.setRemark("\u652f\u4ed8\u56de\u8c03\u6210\u529f\uff0c\u652f\u4ed8\u5b8c\u6210");
        inHospDepostPayCallDTO.setOrderSeq(inpatientDepositDetailEntity.getOrderSeq());
        inHospDepostPayCallDTO.setUpdateTime(new Date());
        inHospDepostPayCallDTO.setPayStatus(Byte.valueOf(BusinessOrderStatusEnum.WAIT_CONFIRM.getValue().byteValue()));
        inHospDepostPayCallDTO.setInpatientIepositId(String.valueOf(inpatientDepositDetailEntity.getId()));
        inHospDepostPayCallDTO.setBankTradeNo("");
        inHospDepostPayCallDTO.setMerchantId(responseNotifyRestVo.getMchId());
        inHospDepostPayCallDTO.setPaymentSeq(responseNotifyRestVo.getPayChannel());
        inHospDepostPayCallDTO.setPayBillNo(responseNotifyRestVo.getTradeNo());
        inHospDepostPayCallDTO.setDealSeq(responseNotifyRestVo.getDealTradeNo());
        this.inpatientDepositDetailEntityMapper.updateByOrderSeq(inHospDepostPayCallDTO);
        this.inpatientPayorderEntityMapper.updateByInpatientDepositId(inHospDepostPayCallDTO);
        DepositRes depositRes = this.inHospitalService.InHospDeposit(inpatientDepositDetailEntity, responseNotifyRestVo);
        inHospDepostPayCallDTO.setReceiptId(depositRes.getReceiptId());
        inHospDepostPayCallDTO.setPayStatus(Byte.valueOf(BusinessOrderStatusEnum.PAID.getValue().byteValue()));
        inHospDepostPayCallDTO.setUpdateTime(new Date());
        inHospDepostPayCallDTO.setRemark("\u5df2\u652f\u4ed8\uff0chis\u6210\u529f\u786e\u8ba4");
        this.inpatientDepositDetailEntityMapper.updateByOrderSeqToHisPaid(inHospDepostPayCallDTO);
    }

    private OpGuideEntity buildOpGuideEntity(OpBusinessOrderEntity opBusinessOrderEntity, GatewayResponse<ComfirmPayNewRes> gatewayResponse) {
        OpGuideEntity opGuideEntity = new OpGuideEntity();
        Date now = new Date();
        opGuideEntity.setGuideInfoId(String.valueOf(this.snowflakeIdWorker.nextId()));
        opGuideEntity.setGuideInfo(((ComfirmPayNewRes)gatewayResponse.getData()).getRemark());
        opGuideEntity.setCreateTime(now);
        opGuideEntity.setUpdateTime(now);
        opGuideEntity.setOutPatientId(opBusinessOrderEntity.getOutPatientId());
        opGuideEntity.setAdmId(opBusinessOrderEntity.getAdmId());
        opGuideEntity.setPatientId(opBusinessOrderEntity.getPatientId());
        opGuideEntity.setPatientOrganId(opBusinessOrderEntity.getPatientOrganId());
        opGuideEntity.setCardNo(opBusinessOrderEntity.getCardNo());
        opGuideEntity.setCardId(opBusinessOrderEntity.getCardId());
        opGuideEntity.setUserId(opBusinessOrderEntity.getUserId());
        opGuideEntity.setOrganCode(opBusinessOrderEntity.getOrganCode());
        opGuideEntity.setOrganName(opBusinessOrderEntity.getOrganName());
        return opGuideEntity;
    }

    private GatewayResponse<ComfirmPayNewRes> comfirmPayNew(GatewayRequest<ComfirmPayNewReq> gatewayRequest) throws OutpatientPaymentException {
        log.info("\u95e8\u8bca\u6536\u8d39\u786e\u8ba4\u63a5\u53e3,\u8bf7\u6c42his\u53c2\u6570 gatewayRequest:{}", gatewayRequest);
        GatewayResponse gatewayResponse = this.outpatientPaymentApi.comfirmPayNew(gatewayRequest);
        log.info("\u95e8\u8bca\u6536\u8d39\u786e\u8ba4\u63a5\u53e3 gatewayResponse ->{}" + gatewayResponse.toString() + gatewayResponse.getCode() + gatewayResponse.getMsg() + gatewayResponse.getData());
        if (gatewayResponse == null) {
            log.error("\u95e8\u8bca\u6536\u8d39\u786e\u8ba4\u63a5\u53e3 comfirmPayNew -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            throw new OutpatientPaymentException(gatewayResponse.getMsg());
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u95e8\u8bca\u6536\u8d39\u786e\u8ba4\u63a5\u53e3 comfirmPayNew -> his\u8bf7\u6c42\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            throw new OutpatientPaymentException(gatewayResponse.getMsg());
        }
        if (gatewayResponse.getData() == null) {
            log.error("\u95e8\u8bca\u6536\u8d39\u786e\u8ba4\u63a5\u53e3 comfirmPayNew -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            throw new OutpatientPaymentException(gatewayResponse.getMsg());
        }
        log.info("gatewayResponse.getData():" + ((ComfirmPayNewRes)gatewayResponse.getData()).toString());
        ComfirmPayNewRes comfirmPayNewRes = (ComfirmPayNewRes)gatewayResponse.getData();
        if (null == comfirmPayNewRes) {
            log.error("\u95e8\u8bca\u6536\u8d39\u786e\u8ba4\u63a5\u53e3 comfirmPayNew -> his\u8fd4\u56de\u5bfc\u8bca\u4fe1\u606f\u4e3a\u7a7a");
            throw new OutpatientPaymentException("his\u8fd4\u56de\u5bfc\u8bca\u4fe1\u606f\u4e3a\u7a7a");
        }
        return gatewayResponse;
    }

    private GatewayRequest<ComfirmPayNewReq> buildComfirmPayNewReq(OpBusinessOrderEntity opBusinessOrderEntity, OpRechargePaymentOrderEntity opRechargePaymentOrderEntity, ResponseNotifyRestVo responseNotifyRestVo) {
        ComfirmPayNewReq comfirmPayNewReq = new ComfirmPayNewReq();
        comfirmPayNewReq.setId(opBusinessOrderEntity.getAdmId());
        comfirmPayNewReq.setAmount(opBusinessOrderEntity.getMoney().toString());
        comfirmPayNewReq.setPaychannel(opRechargePaymentOrderEntity.getPaymentSeq());
        comfirmPayNewReq.setFlowNo(opBusinessOrderEntity.getOutPatientId());
        ComfirmPayNewReqMsg comfirmPayNewReqMsg = new ComfirmPayNewReqMsg();
        comfirmPayNewReqMsg.setOrderid(responseNotifyRestVo.getTradeNo());
        comfirmPayNewReqMsg.setPayment(opRechargePaymentOrderEntity.getDealMoney().toString());
        comfirmPayNewReqMsg.setAccdate(DateUtils.dateToFullString((Date)responseNotifyRestVo.getPayTime()));
        comfirmPayNewReqMsg.setPosid(responseNotifyRestVo.getMchId());
        comfirmPayNewReqMsg.setSuccess(SUCCESS);
        comfirmPayNewReqMsg.setUsrmsg("");
        comfirmPayNewReq.setRespmsg(comfirmPayNewReqMsg);
        comfirmPayNewReq.setPatientId(opBusinessOrderEntity.getPatientOrganId());
        comfirmPayNewReq.setCardNo(opBusinessOrderEntity.getCardNo());
        ArrayList<String> prescriptionNoList = new ArrayList<String>();
        List opBusinessOrderDetailEntityList = this.opBusinessOrderDetailEntityMapper.selectByOutPatientId(opBusinessOrderEntity.getOutPatientId());
        if (!CollectionUtils.isEmpty((Collection)opBusinessOrderDetailEntityList)) {
            for (OpBusinessOrderDetailEntity entity : opBusinessOrderDetailEntityList) {
                prescriptionNoList.add(entity.getPrescriptionNo() + "," + entity.getItemId());
            }
            comfirmPayNewReq.setPrescriptionNos(String.join((CharSequence)"|", prescriptionNoList));
        }
        GatewayRequest gatewayRequest = new GatewayRequest();
        gatewayRequest.setKeyWord("comfirmPayNew");
        gatewayRequest.setChannelName(ChannelEnum.getDisplay((String)opBusinessOrderEntity.getChannelCode()));
        gatewayRequest.setChannel(opBusinessOrderEntity.getChannelCode());
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setBody((Object)comfirmPayNewReq);
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    private boolean refundCallBackToHis(ResponseRefundNotifyRestVo responseRefundNotifyRestVo, String orderNo, String trandNo, String refundSerialNo) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        RefundCallBackReq refundCallBackReq = new RefundCallBackReq();
        refundCallBackReq.setFlowNo(orderNo);
        refundCallBackReq.setRefundTrandNo(responseRefundNotifyRestVo.getRefundNo());
        refundCallBackReq.setMoney(String.valueOf(responseRefundNotifyRestVo.getRefundMoney()));
        refundCallBackReq.setPayType(responseRefundNotifyRestVo.getPayChannel());
        refundCallBackReq.setTrandNo(trandNo);
        refundCallBackReq.setRefundTime(DateUtils.dateToFullString((Date)responseRefundNotifyRestVo.getRefundTime()));
        refundCallBackReq.setRefundSerialNo(refundSerialNo);
        gatewayRequest.setBody((Object)refundCallBackReq);
        gatewayRequest.setChannel(responseRefundNotifyRestVo.getPayChannel());
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("refundResult");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        log.info("\u6302\u53f7\u9000\u6b3e\u56de\u8c03\u8bf7\u6c42his\u5165\u53c2\uff1a" + JSON.toJSONString((Object)gatewayRequest));
        GatewayResponse refundCallBack = this.hisBillApi.refundCallBack(gatewayRequest);
        log.info("\u6302\u53f7\u9000\u6b3e\u56de\u8c03\u8bf7\u6c42his\u5165\u53c2\uff1a" + JSON.toJSONString((Object)gatewayRequest));
        return refundCallBack.isSuccess() && "1".equals(((RefundCallBackRes)refundCallBack.getData()).getState());
    }

    private void outPatientRepeatCallBackHis(ResponseRefundNotifyRestVo responseNotifyRestVo, OpBusinessOrderEntity opBusinessOrderEntity, OpRechargePaymentOrderEntity opRechargePaymentOrderEntity, String refundSerialNo) {
        boolean flag = this.refundCallBackToHis(responseNotifyRestVo, opBusinessOrderEntity.getOutPatientId(), opRechargePaymentOrderEntity.getPayBillNo(), refundSerialNo);
        if (!flag) {
            opBusinessOrderEntity.setRemark("\u9000\u6b3e\u6210\u529f\uff0c\u56de\u8c03his\u5931\u8d25");
            this.opBusinessOrderEntityMapper.updateByPrimaryKey(opBusinessOrderEntity);
        }
    }

    private void inHospRepeatCallBackHis(ResponseRefundNotifyRestVo responseNotifyRestVo, InpatientDepositDetailEntity inpatientDepositDetailEntity, String trandNo, String refundSerialNo) {
        boolean flag = this.refundCallBackToHis(responseNotifyRestVo, inpatientDepositDetailEntity.getOrderSeq(), trandNo, refundSerialNo);
        if (!flag) {
            inpatientDepositDetailEntity.setRemark("\u9000\u6b3e\u6210\u529f\uff0c\u56de\u8c03his\u5931\u8d25");
            this.inpatientDepositDetailEntityMapper.updateByPrimaryKey(inpatientDepositDetailEntity);
        }
    }

    private void appointRepeatCallBackHis(ResponseRefundNotifyRestVo responseNotifyRestVo, AppointmentRecordEntity appointmentRecordEntity, String refundSerialNo) {
        boolean flag = this.refundCallBackToHis(responseNotifyRestVo, appointmentRecordEntity.getSysAppointmentId(), appointmentRecordEntity.getPayTransationId(), refundSerialNo);
        if (!flag) {
            appointmentRecordEntity.setRemark("\u9000\u6b3e\u6210\u529f\uff0c\u56de\u8c03his\u5931\u8d25");
            this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecordEntity);
        }
    }

    public String tencentMedicalNotify(String tencentNotify) {
        TencentNotifyResponse tencentNotifyResponse = (TencentNotifyResponse)XmlUtil.convertToJavaBean((String)tencentNotify, TencentNotifyResponse.class);
        String s = this.jedisCluster.get("YBMED_" + tencentNotifyResponse.getHosp_out_trade_no());
        if (!StringUtils.isEmpty((String)s)) {
            return this.returnStr(YBPayStatusEnum.SUCCESS.getValue());
        }
        this.jedisCluster.set("YBMED_" + tencentNotifyResponse.getHosp_out_trade_no(), tencentNotifyResponse.getHosp_out_trade_no());
        this.jedisCluster.expire(tencentNotifyResponse.getHosp_out_trade_no(), 300);
        PayNotifyReqVO payNotifyReqVO = new PayNotifyReqVO();
        payNotifyReqVO.setOutTradeNo(tencentNotifyResponse.getHosp_out_trade_no());
        payNotifyReqVO.setReturnCode(tencentNotifyResponse.getReturn_code());
        payNotifyReqVO.setPayChannel("NCEFY_ONLINE_MEDICAL_INS_PAY");
        payNotifyReqVO.setDealTradeNo(tencentNotifyResponse.getMed_trans_id());
        BigDecimal bigDecimal = new BigDecimal(tencentNotifyResponse.getTotal_fee());
        payNotifyReqVO.setTotalAmount(bigDecimal.divide(new BigDecimal(100)));
        payNotifyReqVO.setResultCode(tencentNotifyResponse.getResult_code());
        OpBusinessOrderEntity opBusinessOrderEntity = this.opBusinessOrderEntityMapper.selectByOutPatientId(payNotifyReqVO.getOutTradeNo());
        if (null == opBusinessOrderEntity || opBusinessOrderEntity.getStatus() == BusinessOrderStatusEnum.PAID.getValue()) {
            log.info("====opBusinessOrderEntity:null");
            return this.returnStr(YBPayStatusEnum.SUCCESS.getValue());
        }
        if (YBPayStatusEnum.SUCCESS.getValue().equals(payNotifyReqVO.getReturnCode())) {
            SettlementConfirmationRes settlementConfirmationRes = this.ybMedicalJs(opBusinessOrderEntity);
            if (null == settlementConfirmationRes) {
                return this.returnStr(YBPayStatusEnum.SUCCESS.getValue());
            }
            confirmMedicalRes confirmMedicalRes2 = this.MedicalJs(opBusinessOrderEntity, payNotifyReqVO);
            if (null == confirmMedicalRes2) {
                return this.returnStr(YBPayStatusEnum.SUCCESS.getValue());
            }
            opBusinessOrderEntity.setStatus(BusinessOrderStatusEnum.PAID.getValue());
            OpRechargePaymentOrderEntity paymentOrderEntity = this.opRechargePaymentOrderEntityMapper.selectByOutPatientId(opBusinessOrderEntity.getOutPatientId());
            if (null != paymentOrderEntity) {
                log.info("\u3010\u95e8\u8bca\u7f34\u8d39\u3011\u652f\u4ed8\u6210\u529f -> \u4fee\u6539\u652f\u4ed8\u8ba2\u5355\u8868\u652f\u4ed8\u72b6\u6001\uff1a" + JSON.toJSONString((Object)paymentOrderEntity));
                paymentOrderEntity.setPayStatus(Byte.valueOf(PayStatusEnum.HAS_PAY_OR_REFUND.getValue().byteValue()));
                paymentOrderEntity.setPaymentTime(new Date());
                paymentOrderEntity.setRemark("\u5df2\u652f\u4ed8");
                this.opRechargePaymentOrderEntityMapper.updateByPrimaryKey(paymentOrderEntity);
            }
            this.opBusinessOrderEntityMapper.updateByPrimaryKey(opBusinessOrderEntity);
            return this.returnStr(YBPayStatusEnum.SUCCESS.getValue());
        }
        return this.returnStr(YBPayStatusEnum.SUCCESS.getValue());
    }

    private confirmMedicalRes MedicalJs(OpBusinessOrderEntity opBusinessOrderEntity, PayNotifyReqVO payNotifyReqVO) {
        String ybInfo = opBusinessOrderEntity.getYbInfo();
        ConsultationHealtInuranceRes consultationHealtInuranceRes = (ConsultationHealtInuranceRes)JSONObject.parseObject((String)ybInfo, ConsultationHealtInuranceRes.class);
        confirmMedicalRes settlementConfirmationRes = new confirmMedicalRes();
        try {
            FrontRequest param = new FrontRequest();
            confirmMedicalReq reqData = new confirmMedicalReq();
            reqData.setPatientId(opBusinessOrderEntity.getPatientOrganId());
            reqData.setOrderNo(opBusinessOrderEntity.getReceiptId());
            reqData.setInvoiceNoStr(opBusinessOrderEntity.getInvoiceNo());
            reqData.setPayModeCode("HLWYYWX");
            reqData.setPlatformNo(payNotifyReqVO.getOutTradeNo());
            reqData.setOutPayNo(payNotifyReqVO.getDealTradeNo());
            reqData.setTradeChannel("DHCC");
            reqData.setPayAmt(consultationHealtInuranceRes.getOwnPayAmt());
            reqData.setOrderSum(opBusinessOrderEntity.getMoney().toString());
            param.setBody((Object)reqData);
            param.setChannel("NCDXDEFSYY");
            if (null != opBusinessOrderEntity.getItemType()) {
                if (opBusinessOrderEntity.getItemType().equals("9")) {
                    param.setChannel("NDEFYHJZYQ");
                } else if (opBusinessOrderEntity.getItemType().equals("10")) {
                    param.setChannel("NDEFYJLYY");
                }
            }
            log.info("===\u95e8\u8bca\u7ed3\u7b97===Req{}", (Object)JSON.toJSONString((Object)param));
            String body = HttpKit.jsonPost((String)(this.constant.getHisurl() + "/medicalinsurance/confirmMedical"), (String)JSON.toJSONString((Object)param));
            log.info("===\u95e8\u8bca\u7ed3\u7b97===Res{}", (Object)JSON.toJSONString((Object)body));
            1 typeReference = new /* Unavailable Anonymous Inner Class!! */;
            FrontResponse response = (FrontResponse)JSONObject.parseObject((String)body, (Type)typeReference.getType(), (Feature[])new Feature[0]);
            if (!"1".equals(response.getCode()) || null == response.getBody()) {
                return null;
            }
            settlementConfirmationRes = (confirmMedicalRes)response.getBody();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return settlementConfirmationRes;
    }

    private SettlementConfirmationRes ybMedicalJs(OpBusinessOrderEntity opBusinessOrderEntity) {
        String ybInfo = opBusinessOrderEntity.getYbInfo();
        ConsultationHealtInuranceRes consultationHealtInuranceRes = (ConsultationHealtInuranceRes)JSONObject.parseObject((String)ybInfo, ConsultationHealtInuranceRes.class);
        SettlementConfirmationRes settlementConfirmationRes = new SettlementConfirmationRes();
        try {
            FrontRequest param = new FrontRequest();
            SettlementConfirmationReq settlementConfirmationReq = new SettlementConfirmationReq();
            settlementConfirmationReq.setInsuDivId(consultationHealtInuranceRes.getInsuDivId());
            settlementConfirmationReq.setIp("10.5.1.2");
            settlementConfirmationReq.setMac("7c:8a:e1:c7:ee:5f");
            settlementConfirmationReq.setOptertype(PAY_SUCCESS);
            settlementConfirmationReq.setSgnType("1");
            settlementConfirmationReq.setOwnPayAmt(new BigDecimal(consultationHealtInuranceRes.getOwnPayAmt()));
            settlementConfirmationReq.setOwnPayPMDr("92");
            settlementConfirmationReq.setPayAuthNo(consultationHealtInuranceRes.getPayAuthNo());
            param.setBody((Object)settlementConfirmationReq);
            param.setChannel("NCDXDEFSYY");
            if (null != opBusinessOrderEntity.getItemType()) {
                if (opBusinessOrderEntity.getItemType().equals("9")) {
                    param.setChannel("NDEFYHJZYQ");
                } else if (opBusinessOrderEntity.getItemType().equals("10")) {
                    param.setChannel("NDEFYJLYY");
                }
            }
            log.info("===\u95e8\u8bca\u533b\u4fdd\u7ed3\u7b97===Req{}", (Object)JSON.toJSONString((Object)param));
            String body = HttpKit.jsonPost((String)(this.constant.getHisurl() + "/medicalinsurance/insuranceConfirmMedical"), (String)JSON.toJSONString((Object)param));
            log.info("===\u95e8\u8bca\u533b\u4fdd\u7ed3\u7b97===Res{}", (Object)JSON.toJSONString((Object)body));
            2 typeReference = new /* Unavailable Anonymous Inner Class!! */;
            FrontResponse response = (FrontResponse)JSONObject.parseObject((String)body, (Type)typeReference.getType(), (Feature[])new Feature[0]);
            if (!"1".equals(response.getCode()) || null == response.getBody()) {
                return null;
            }
            settlementConfirmationRes = (SettlementConfirmationRes)response.getBody();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return settlementConfirmationRes;
    }

    public String tencentNotifyReg(String tencentNotify) {
        try {
            TencentNotifyResponse tencentNotifyResponse = (TencentNotifyResponse)XmlUtil.convertToJavaBean((String)tencentNotify, TencentNotifyResponse.class);
            String s = this.jedisCluster.get("YBREG_" + tencentNotifyResponse.getHosp_out_trade_no());
            if (!StringUtils.isEmpty((String)s)) {
                return this.returnStr(YBPayStatusEnum.SUCCESS.getValue());
            }
            this.jedisCluster.set("YBREG_" + tencentNotifyResponse.getHosp_out_trade_no(), tencentNotifyResponse.getHosp_out_trade_no());
            this.jedisCluster.expire(tencentNotifyResponse.getHosp_out_trade_no(), 300);
            PayNotifyReqVO payNotifyReqVO = new PayNotifyReqVO();
            payNotifyReqVO.setOutTradeNo(tencentNotifyResponse.getHosp_out_trade_no());
            payNotifyReqVO.setReturnCode(tencentNotifyResponse.getReturn_code());
            payNotifyReqVO.setPayChannel("NCEFY_ONLINE_MEDICAL_INS_PAY");
            payNotifyReqVO.setDealTradeNo(tencentNotifyResponse.getMed_trans_id());
            BigDecimal bigDecimal = new BigDecimal(tencentNotifyResponse.getTotal_fee());
            payNotifyReqVO.setTotalAmount(bigDecimal.divide(new BigDecimal(100)));
            payNotifyReqVO.setResultCode(tencentNotifyResponse.getResult_code());
            AppointmentRecordEntity appointmentRecordEntity = this.appointmentRecordMapper.selectBySysAppointId(tencentNotifyResponse.getHosp_out_trade_no());
            if (!AppointmentStatusEnum.WAIT_PAY.getValue().equals(appointmentRecordEntity.getAppointStatus())) {
                return this.returnStr(YBPayStatusEnum.SUCCESS.getValue());
            }
            if (YBPayStatusEnum.SUCCESS.getValue().equals(payNotifyReqVO.getReturnCode())) {
                OutpatientRegistratConfirmatData outpatientRegistratConfirmatData = this.ybRegJs(appointmentRecordEntity);
                if (null == outpatientRegistratConfirmatData) {
                    return this.returnStr(YBPayStatusEnum.SUCCESS.getValue());
                }
                RegConfirmatResVo RegConfirmatResVo2 = this.RegJs(appointmentRecordEntity, outpatientRegistratConfirmatData);
                GetRecipelReq getRecipelReq = new GetRecipelReq();
                getRecipelReq.setTransactionId(appointmentRecordEntity.getAdmId());
                GetPayRecordsResItems getPayRecordsResItems = this.getCompletedPayInfo(getRecipelReq, appointmentRecordEntity.getHosId());
                if (null == getPayRecordsResItems) {
                    return this.returnStr(YBPayStatusEnum.SUCCESS.getValue());
                }
                appointmentRecordEntity.setReceptId(getPayRecordsResItems.getAdmId());
                appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.PAY.getValue());
                appointmentRecordEntity.setRemark("\u533b\u4fdd\u652f\u4ed8\u6210\u529f");
                appointmentRecordEntity.setPayChannel("YB");
                appointmentRecordEntity.setPayChannelCode("YB");
                appointmentRecordEntity.setPayAccdate(DateUtils.dateToFullString((Date)new Date()));
                appointmentRecordEntity.setPayTransationId(tencentNotifyResponse.getMed_trans_id());
                this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecordEntity);
                AppointmentPayorderEntity appointmentPayorderEntity = this.appointmentPayOrderMapper.getBySysAppointmentId(appointmentRecordEntity.getSysAppointmentId());
                if (null != appointmentPayorderEntity) {
                    appointmentPayorderEntity.setOrderStatus(Byte.valueOf(Byte.parseByte(PAY_SUCCESS)));
                    this.appointmentPayOrderMapper.updateByPrimaryKeySelective(appointmentPayorderEntity);
                }
                log.info("\u6302\u53f7\u56de\u8c03\u8fd4\u56deSUCCESS,\u72b6\u6001\u4fee\u6539\u6210\u529f:{}", (Object)JSONObject.toJSONString((Object)appointmentPayorderEntity.getSysAppointmentId()));
                return this.returnStr(YBPayStatusEnum.SUCCESS.getValue());
            }
            return this.returnStr(YBPayStatusEnum.SUCCESS.getValue());
        }
        catch (Exception e) {
            return this.returnStr(YBPayStatusEnum.SUCCESS.getValue());
        }
    }

    private GetPayRecordsResItems getCompletedPayInfo(GetRecipelReq getRecipelReq, String hosId) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        gatewayRequest.setBody((Object)getRecipelReq);
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        gatewayRequest.setKeyWord("GetRecipelReq");
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setChannel(hosId);
        gatewayRequest.setChannelName(ChannelEnum.MANAGER.getValue());
        log.info("\u3010his\u67e5\u8be2\u5df2\u7f34\u8d39\u8bb0\u5f554905\u3011\u8bf7\u6c42\u53c2\u6570\uff1a" + gatewayRequest);
        GatewayResponse gatewayResponse = this.outpatientPaymentApi.getCompletedPayInfo(gatewayRequest);
        log.info("\u3010his\u67e5\u8be2\u5df2\u7f34\u8d39\u8bb0\u5f554905\u3011\u8fd4\u56de\u53c2\u6570\uff1a{} ", (Object)JSON.toJSONString((Object)gatewayResponse));
        if (gatewayResponse == null) {
            log.error("\u3010his\u67e5\u8be2\u5df2\u7f34\u8d39\u8bb0\u5f554905\u3011getCompletedPayInfo -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            return null;
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u3010his\u67e5\u8be2\u5df2\u7f34\u8d39\u8bb0\u5f554905\u3011 getCompletedPayInfo -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            return null;
        }
        if (gatewayResponse.getData() == null) {
            log.error("\u3010his\u67e5\u8be2\u5df2\u7f34\u8d39\u8bb0\u5f554905\u3011 getCompletedPayInfo -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            return null;
        }
        if (CollectionUtils.isEmpty((Collection)((GetRecipelRes)gatewayResponse.getData()).getItems())) {
            log.error("\u3010his\u67e5\u8be2\u5df2\u7f34\u8d39\u8bb0\u5f554905\u3011 getCompletedPayInfo -> his\u67e5\u8be2\u6570\u636e\u4e3a\u7a7a");
            return null;
        }
        ArrayList payRecordsResItems = ((GetRecipelRes)gatewayResponse.getData()).getItems();
        return (GetPayRecordsResItems)payRecordsResItems.get(0);
    }

    private RegConfirmatResVo RegJs(AppointmentRecordEntity appointmentRecordEntity, OutpatientRegistratConfirmatData outpatientRegistratConfirmatData) {
        RegConfirmatResVo regConfirmatResVo = new RegConfirmatResVo();
        try {
            FrontRequest param = new FrontRequest();
            RegConfirmatReqVo regConfirmatReqVo = new RegConfirmatReqVo();
            regConfirmatReqVo.setTransactionId(appointmentRecordEntity.getAdmId());
            regConfirmatReqVo.setPatientId(appointmentRecordEntity.getPatientId());
            regConfirmatReqVo.setScheduleItemCode(appointmentRecordEntity.getScheduleHisId());
            regConfirmatReqVo.setPayInsuFeeStr(outpatientRegistratConfirmatData.getInsuPayStr());
            regConfirmatReqVo.setPayTradeNo(appointmentRecordEntity.getSysAppointmentId());
            regConfirmatReqVo.setPlatformNo(appointmentRecordEntity.getSysAppointmentId());
            regConfirmatReqVo.setPayFee(appointmentRecordEntity.getRegFee().toString());
            regConfirmatReqVo.setPayAmt(outpatientRegistratConfirmatData.getOwnPayAmt());
            regConfirmatReqVo.setPayModeCode("HLWYYWX");
            param.setBody((Object)regConfirmatReqVo);
            param.setChannel(appointmentRecordEntity.getHosId());
            log.info("===\u6302\u53f7\u7ed3\u7b97===Req{}", (Object)JSON.toJSONString((Object)param));
            String body = HttpKit.jsonPost((String)(this.constant.getHisurl() + "/medicalinsurance/regConfirmat"), (String)JSON.toJSONString((Object)param));
            log.info("===\u6302\u53f7\u7ed3\u7b97===bodyRes{}", (Object)JSON.toJSONString((Object)body));
            3 typeReference = new /* Unavailable Anonymous Inner Class!! */;
            FrontResponse response = (FrontResponse)JSONObject.parseObject((String)body, (Type)typeReference.getType(), (Feature[])new Feature[0]);
            if (!"1".equals(response.getCode()) || null == response.getBody()) {
                return null;
            }
            regConfirmatResVo = (RegConfirmatResVo)response.getBody();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return regConfirmatResVo;
    }

    private OutpatientRegistratConfirmatData ybRegJs(AppointmentRecordEntity appointmentRecordEntity) {
        String ybInfo = appointmentRecordEntity.getYbInfo();
        ConsultationHealtInuranceRes consultationHealtInuranceRes = (ConsultationHealtInuranceRes)JSONObject.parseObject((String)ybInfo, ConsultationHealtInuranceRes.class);
        OutpatientRegistratConfirmatData outpatientRegistratConfirmatData = new OutpatientRegistratConfirmatData();
        try {
            FrontRequest param = new FrontRequest();
            OutpatientRegistratConfirmatReqVo outpatientRegistratReqVo = new OutpatientRegistratConfirmatReqVo();
            outpatientRegistratReqVo.setPayAuthNo(consultationHealtInuranceRes.getPayAuthNo());
            outpatientRegistratReqVo.setInsuDivId(consultationHealtInuranceRes.getInsuDivId());
            outpatientRegistratReqVo.setOwnPayAmt(consultationHealtInuranceRes.getOwnPayAmt());
            outpatientRegistratReqVo.setOwnPayPMDr("92");
            param.setBody((Object)outpatientRegistratReqVo);
            param.setChannel(appointmentRecordEntity.getHosId());
            log.info("===\u533b\u4fdd\u6302\u53f7\u7ed3\u7b97===Req{}", (Object)JSON.toJSONString((Object)param));
            String body = HttpKit.jsonPost((String)(this.constant.getHisurl() + "/medicalinsurance/ybRegConfirmat"), (String)JSON.toJSONString((Object)param));
            log.info("===\u533b\u4fdd\u6302\u53f7\u7ed3\u7b97===bodyRes{}", (Object)JSON.toJSONString((Object)body));
            4 typeReference = new /* Unavailable Anonymous Inner Class!! */;
            FrontResponse response = (FrontResponse)JSONObject.parseObject((String)body, (Type)typeReference.getType(), (Feature[])new Feature[0]);
            if (!"1".equals(response.getCode()) || null == response.getBody()) {
                return null;
            }
            outpatientRegistratConfirmatData = (OutpatientRegistratConfirmatData)response.getBody();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return outpatientRegistratConfirmatData;
    }

    private String returnStr(String status) {
        try {
            String PAYKEY = "fc6541f3f8f3f0243b4e443e81c2a925";
            NotifyRequest notifyRequest = new NotifyRequest();
            notifyRequest.setNonce_str(DateUtils.getCurrentDateSimpleToString());
            notifyRequest.setResult_code(status);
            notifyRequest.setReturn_code(status);
            notifyRequest.setReturn_msg("OK");
            Map objectMap = WXPayUtil.object2Map((Object)notifyRequest);
            String sign = WXPayUtil.generateSignature((Map)objectMap, (String)PAYKEY);
            objectMap.put("sign", sign);
            return WXPayUtil.mapToXml((Map)objectMap);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }
}

