/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.service.impl;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.common.pojo.login.UcWxAuthReqVo;
import com.ebaiyihui.common.pojo.login.UcWxAuthRespVo;
import com.ebaiyihui.common.pojo.vo.UserLastLoginDeviceReqVo;
import com.ebaiyihui.common.pojo.vo.UserLastLoginDeviceRespVo;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.wisdommedical.common.constant.ProPropertiesConstant;
import com.ebaiyihui.wisdommedical.common.enums.ChannelEnum;
import com.ebaiyihui.wisdommedical.model.AppointmentRecordEntity;
import com.ebaiyihui.wisdommedical.model.OpBusinessOrderEntity;
import com.ebaiyihui.wisdommedical.pojo.vo.PushConfigurationDetailVO;
import com.ebaiyihui.wisdommedical.pojo.vo.PushSubscribeMessageReqVO;
import com.ebaiyihui.wisdommedical.pojo.vo.UmPushMsgAndroidReqVO;
import com.ebaiyihui.wisdommedical.pojo.vo.UmPushMsgIOSReqVo;
import com.ebaiyihui.wisdommedical.service.PushService;
import com.ebaiyihui.wisdommedical.util.DateUtils;
import com.ebaiyihui.wisdommedical.util.GetUserInfoUtil;
import com.ebaiyihui.wisdommedical.util.PushInfoManagerUtils;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PushServiceImpl
implements PushService {
    private static final Logger log = LoggerFactory.getLogger(PushServiceImpl.class);
    @Autowired
    private PushInfoManagerUtils pushInfoManagerUtils;
    @Autowired
    private ProPropertiesConstant propertiesConstant;
    @Autowired
    private GetUserInfoUtil getUserInfoUtil;

    public void appointmentSuccessMsgPush(AppointmentRecordEntity appointmentRecordEntity) {
        BaseResponse response;
        log.info("===========================\u8fdb\u5165\u4e86\u63a8\u9001===================================");
        if (ChannelEnum.USER_ANDROID.getValue().equals(appointmentRecordEntity.getChannelCode())) {
            log.info("===========================Android\u63a8\u9001===================================");
            UmPushMsgAndroidReqVO umPushMsgAndroidReqVO = this.buildAndroidAppointPushMsgTemplate(appointmentRecordEntity);
            if (null == umPushMsgAndroidReqVO) {
                log.info("======\u6784\u5efa\u6a21\u677f\u4fe1\u606f\u4e3anull\uff0c\u63a8\u9001\u5931\u8d25=====");
                return;
            }
            log.info("====\u8c03\u7528\u63a8\u9001\u670d\u52a1\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)umPushMsgAndroidReqVO));
            response = this.pushInfoManagerUtils.pushAndroidMessage(umPushMsgAndroidReqVO);
            log.info("====\u8c03\u7528\u63a8\u9001\u670d\u52a1\uff0c\u8fd4\u56de\u53c2\u6570\uff1a{}", (Object)response.toString());
        }
        if (ChannelEnum.USER_IOS.getValue().equals(appointmentRecordEntity.getChannelCode())) {
            log.info("===========================IOS\u63a8\u9001===================================");
            UmPushMsgIOSReqVo umPushMsgIOSReqVo = this.buildIOSAppointPushMsgTemplate(appointmentRecordEntity);
            if (null == umPushMsgIOSReqVo) {
                log.info("======\u6784\u5efa\u6a21\u677f\u4fe1\u606f\u4e3anull\uff0c\u63a8\u9001\u5931\u8d25=====");
                return;
            }
            log.info("====\u8c03\u7528\u63a8\u9001\u670d\u52a1\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)umPushMsgIOSReqVo));
            response = this.pushInfoManagerUtils.pushIOSMessage(umPushMsgIOSReqVo);
            log.info("====\u8c03\u7528\u63a8\u9001\u670d\u52a1\uff0c\u8fd4\u56de\u53c2\u6570\uff1a{}", (Object)response.toString());
        }
        if (ChannelEnum.USER_APPLETS.getValue().equals(appointmentRecordEntity.getChannelCode())) {
            log.info("===========================\u5c0f\u7a0b\u5e8f\u63a8\u9001===================================");
            PushSubscribeMessageReqVO pushSubscribeMessageReqVO = this.buildAppointmentPushTemplateMsgVO(appointmentRecordEntity);
            if (null == pushSubscribeMessageReqVO) {
                log.info("======\u6784\u5efa\u6a21\u677f\u4fe1\u606f\u4e3anull\uff0c\u63a8\u9001\u5931\u8d25=====");
                return;
            }
            log.info("====\u8c03\u7528\u63a8\u9001\u670d\u52a1\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)pushSubscribeMessageReqVO));
            response = this.pushInfoManagerUtils.pushSubscribeMessage(pushSubscribeMessageReqVO);
            log.info("====\u8c03\u7528\u63a8\u9001\u670d\u52a1\uff0c\u8fd4\u56de\u53c2\u6570\uff1a{}", (Object)response.toString());
        }
    }

    public void appointmentCancelMsgPush(AppointmentRecordEntity appointmentRecordEntity) {
        BaseResponse response;
        log.info("===========================\u8fdb\u5165\u4e86\u63a8\u9001===================================");
        if (ChannelEnum.USER_ANDROID.getValue().equals(appointmentRecordEntity.getChannelCode())) {
            log.info("===========================app\u63a8\u9001  android===================================");
            UmPushMsgAndroidReqVO umPushMsgAndroidReqVO = this.buildAndroidCancleAppointPushMsgTemplate(appointmentRecordEntity);
            if (null == umPushMsgAndroidReqVO) {
                log.info("======\u6784\u5efa\u6a21\u677f\u4fe1\u606f\u4e3anull\uff0c\u63a8\u9001\u5931\u8d25=====");
                return;
            }
            log.info("====\u8c03\u7528\u63a8\u9001\u670d\u52a1\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)umPushMsgAndroidReqVO));
            response = this.pushInfoManagerUtils.pushAndroidMessage(umPushMsgAndroidReqVO);
            log.info("====\u8c03\u7528\u63a8\u9001\u670d\u52a1\uff0c\u8fd4\u56de\u53c2\u6570\uff1a{}", (Object)response.toString());
        }
        if (ChannelEnum.USER_IOS.getValue().equals(appointmentRecordEntity.getChannelCode())) {
            log.info("===========================app\u63a8\u9001  IOS===================================");
            UmPushMsgIOSReqVo umPushMsgIOSReqVo = this.buildIOSAppointCanclePushMsgTemplate(appointmentRecordEntity);
            if (null == umPushMsgIOSReqVo) {
                log.info("======\u6784\u5efa\u6a21\u677f\u4fe1\u606f\u4e3anull\uff0c\u63a8\u9001\u5931\u8d25=====");
                return;
            }
            log.info("====\u8c03\u7528\u63a8\u9001\u670d\u52a1\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)umPushMsgIOSReqVo));
            response = this.pushInfoManagerUtils.pushIOSMessage(umPushMsgIOSReqVo);
            log.info("====\u8c03\u7528\u63a8\u9001\u670d\u52a1\uff0c\u8fd4\u56de\u53c2\u6570\uff1a{}", (Object)response.toString());
        }
        if (ChannelEnum.USER_APPLETS.getValue().equals(appointmentRecordEntity.getChannelCode())) {
            log.info("===========================\u63a8\u9001  \u5c0f\u7a0b\u5e8f===================================");
            PushSubscribeMessageReqVO pushSubscribeMessageReqVO = this.buildCancelPushTemplateMsgVO(appointmentRecordEntity);
            if (null == pushSubscribeMessageReqVO) {
                log.info("======\u6784\u5efa\u6a21\u677f\u4fe1\u606f\u4e3anull\uff0c\u63a8\u9001\u5931\u8d25=====");
                return;
            }
            log.info("====\u8c03\u7528\u63a8\u9001\u670d\u52a1\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)pushSubscribeMessageReqVO));
            response = this.pushInfoManagerUtils.pushSubscribeMessage(pushSubscribeMessageReqVO);
            log.info("====\u8c03\u7528\u63a8\u9001\u670d\u52a1\uff0c\u8fd4\u56de\u53c2\u6570\uff1a{}", (Object)response.toString());
        }
    }

    public void outPatientSuccessMsgPush(OpBusinessOrderEntity opBusinessOrderEntity, String payTime) {
        log.info("===========================\u8fdb\u5165\u4e86\u95e8\u8bca\u7f34\u8d39\u63a8\u9001===================================");
        if (ChannelEnum.USER_APPLETS.getValue().equals(opBusinessOrderEntity.getChannelCode())) {
            log.info("===========================\u63a8\u9001  \u5c0f\u7a0b\u5e8f===================================");
            PushSubscribeMessageReqVO pushSubscribeMessageReqVO = this.buildOutPatientPushTemplateMsgVO(opBusinessOrderEntity, payTime);
            if (null == pushSubscribeMessageReqVO) {
                log.info("======\u6784\u5efa\u6a21\u677f\u4fe1\u606f\u4e3anull\uff0c\u63a8\u9001\u5931\u8d25=====");
                return;
            }
            log.info("====\u8c03\u7528\u63a8\u9001\u670d\u52a1\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)pushSubscribeMessageReqVO));
            BaseResponse response = this.pushInfoManagerUtils.pushSubscribeMessage(pushSubscribeMessageReqVO);
            log.info("====\u8c03\u7528\u63a8\u9001\u670d\u52a1\uff0c\u8fd4\u56de\u53c2\u6570\uff1a{}", (Object)response.toString());
        }
    }

    private PushSubscribeMessageReqVO buildAppointmentPushTemplateMsgVO(AppointmentRecordEntity appointmentRecordEntity) {
        PushSubscribeMessageReqVO pushSubscribeMessageReqVO = new PushSubscribeMessageReqVO();
        Map data = this.getAppointmentPushTemplateData(appointmentRecordEntity);
        String wxOpenid = this.getWxOpenid(appointmentRecordEntity.getUserId());
        log.info("***\u4ece\u7528\u6237\u4e2d\u5fc3\u83b7\u53d6\u7684openid {}", (Object)wxOpenid);
        if (StringUtils.isEmpty((String)wxOpenid)) {
            return null;
        }
        PushConfigurationDetailVO pushConfig = this.pushInfoManagerUtils.getPushConfig(this.propertiesConstant.getAppCode(), "weChatApplets", "patient", "weChatApplets");
        if (null == pushConfig && StringUtils.isEmpty((String)pushConfig.getClientCode())) {
            return null;
        }
        pushSubscribeMessageReqVO.setData(data);
        pushSubscribeMessageReqVO.setOpenId(wxOpenid);
        pushSubscribeMessageReqVO.setPage("/wisdomTreatment/pages/registerDetail/index?id=" + appointmentRecordEntity.getSysAppointmentId());
        pushSubscribeMessageReqVO.setTemplateCode("treatment_warn");
        pushSubscribeMessageReqVO.setClientCode(pushConfig.getClientCode());
        return pushSubscribeMessageReqVO;
    }

    private PushSubscribeMessageReqVO buildCancelPushTemplateMsgVO(AppointmentRecordEntity appointmentRecordEntity) {
        PushSubscribeMessageReqVO pushSubscribeMessageReqVO = new PushSubscribeMessageReqVO();
        Map data = this.getCancelAppointmentPushTemplateData(appointmentRecordEntity);
        String wxOpenid = this.getWxOpenid(appointmentRecordEntity.getUserId());
        log.info("***\u4ece\u7528\u6237\u4e2d\u5fc3\u83b7\u53d6\u7684openid {}", (Object)wxOpenid);
        if (StringUtils.isEmpty((String)wxOpenid)) {
            return null;
        }
        PushConfigurationDetailVO pushConfig = this.pushInfoManagerUtils.getPushConfig(this.propertiesConstant.getAppCode(), "weChatApplets", "patient", "weChatApplets");
        if (null == pushConfig && StringUtils.isEmpty((String)pushConfig.getClientCode())) {
            return null;
        }
        pushSubscribeMessageReqVO.setData(data);
        pushSubscribeMessageReqVO.setOpenId(wxOpenid);
        pushSubscribeMessageReqVO.setPage("/wisdomTreatment/pages/registerDetail/index?id=" + appointmentRecordEntity.getSysAppointmentId());
        pushSubscribeMessageReqVO.setTemplateCode("treatment_warn");
        pushSubscribeMessageReqVO.setClientCode(pushConfig.getClientCode());
        return pushSubscribeMessageReqVO;
    }

    private Map<String, Map<String, Object>> getAppointmentPushTemplateData(AppointmentRecordEntity appointmentRecordEntity) {
        LinkedHashMap<String, Map<String, Object>> pushTemplateDataMap = new LinkedHashMap<String, Map<String, Object>>();
        HashMap<String, String> serviceItems = new HashMap<String, String>();
        serviceItems.put("value", appointmentRecordEntity.getPatientName());
        pushTemplateDataMap.put("\u5c31\u8bca\u4eba", serviceItems);
        HashMap<String, String> serviceTime = new HashMap<String, String>();
        serviceTime.put("value", appointmentRecordEntity.getDeptName());
        pushTemplateDataMap.put("\u5c31\u8bca\u79d1\u5ba4", serviceTime);
        HashMap<String, String> patientName = new HashMap<String, String>();
        patientName.put("value", appointmentRecordEntity.getDocName() + "\u533b\u751f");
        pushTemplateDataMap.put("\u9884\u7ea6\u533b\u751f", patientName);
        HashMap<String, String> docName = new HashMap<String, String>();
        docName.put("value", DateUtils.dateToYMDString((Date)DateUtils.stringToSimpleDate((String)appointmentRecordEntity.getAdmDate())) + " " + appointmentRecordEntity.getAdmTimeRange().substring(0, 5) + ":00");
        pushTemplateDataMap.put("\u5c31\u8bca\u65f6\u95f4", docName);
        HashMap<String, String> remark = new HashMap<String, String>();
        remark.put("value", "\u60a8\u5df2\u6210\u529f\u6302\u53f7,\u8bf7\u6309\u65f6\u95f4\u5c31\u8bca");
        pushTemplateDataMap.put("\u63d0\u793a\u8bf4\u660e", remark);
        return pushTemplateDataMap;
    }

    private Map<String, Map<String, Object>> getCancelAppointmentPushTemplateData(AppointmentRecordEntity appointmentRecordEntity) {
        LinkedHashMap<String, Map<String, Object>> pushTemplateDataMap = new LinkedHashMap<String, Map<String, Object>>();
        HashMap<String, String> serviceItems = new HashMap<String, String>();
        serviceItems.put("value", appointmentRecordEntity.getPatientName());
        pushTemplateDataMap.put("\u5c31\u8bca\u4eba", serviceItems);
        HashMap<String, String> refundMoney = new HashMap<String, String>();
        refundMoney.put("value", appointmentRecordEntity.getDeptName());
        pushTemplateDataMap.put("\u5c31\u8bca\u79d1\u5ba4", refundMoney);
        HashMap<String, String> refundTime = new HashMap<String, String>();
        refundTime.put("value", appointmentRecordEntity.getDocName() + "\u533b\u751f");
        pushTemplateDataMap.put("\u9884\u7ea6\u533b\u751f", refundTime);
        HashMap<String, String> orderNo = new HashMap<String, String>();
        orderNo.put("value", DateUtils.dateToYMDString((Date)DateUtils.stringToSimpleDate((String)appointmentRecordEntity.getAdmDate())) + " " + appointmentRecordEntity.getAdmTimeRange().substring(0, 5) + ":00");
        pushTemplateDataMap.put("\u5c31\u8bca\u65f6\u95f4", orderNo);
        HashMap<String, String> remark = new HashMap<String, String>();
        remark.put("value", "\u60a8\u5df2\u6210\u529f\u9000\u53f7\uff0c\u8d39\u7528\u5c06\u9000\u56de\u539f\u652f\u4ed8\u8d26\u6237");
        pushTemplateDataMap.put("\u63d0\u793a\u8bf4\u660e", remark);
        return pushTemplateDataMap;
    }

    private String getWxOpenid(String userId) {
        UcWxAuthReqVo ucWxAuthReqVo = new UcWxAuthReqVo();
        ucWxAuthReqVo.setUserId(userId);
        ucWxAuthReqVo.setStatus(Short.valueOf((short)1));
        ucWxAuthReqVo.setUserType(Short.valueOf((short)0));
        UcWxAuthRespVo respVo = this.getUserInfoUtil.getWxAuthByCondition(ucWxAuthReqVo);
        if (null != respVo) {
            return respVo.getWxOpenid();
        }
        return null;
    }

    private String getDeviceToken(String userId) {
        short userType = 0;
        UserLastLoginDeviceReqVo userLastLoginDeviceReqVo = new UserLastLoginDeviceReqVo();
        userLastLoginDeviceReqVo.setUserId(userId);
        userLastLoginDeviceReqVo.setUserType(Short.valueOf(userType));
        log.info("\u83b7\u53d6\u79fb\u52a8\u8bbe\u5907\u53f7\u5165\u53c2userLastLoginDeviceReqVo:" + userLastLoginDeviceReqVo.toString());
        UserLastLoginDeviceRespVo userLastLoginDevice = this.getUserInfoUtil.getUserLastLoginDevice(userLastLoginDeviceReqVo);
        if (null == userLastLoginDevice) {
            return null;
        }
        String deviceToken = userLastLoginDevice.getDeviceNumber();
        return deviceToken;
    }

    private UmPushMsgIOSReqVo buildIOSAppointPushMsgTemplate(AppointmentRecordEntity appointmentRecordEntity) {
        String deviceToken = this.getDeviceToken(appointmentRecordEntity.getUserId());
        if (StringUtils.isEmpty((String)deviceToken)) {
            return null;
        }
        PushConfigurationDetailVO pushConfig = this.pushInfoManagerUtils.getPushConfig(this.propertiesConstant.getAppCode(), "youmengPush", "patient", "IOS");
        if (null == pushConfig && StringUtils.isEmpty((String)pushConfig.getClientCode())) {
            return null;
        }
        UmPushMsgIOSReqVo umPushMsgIOSReqVo = new UmPushMsgIOSReqVo();
        umPushMsgIOSReqVo.setBusiCode("hlwyygh");
        umPushMsgIOSReqVo.setClientCode(pushConfig.getClientCode());
        String patientName = appointmentRecordEntity.getPatientName();
        String admDate = appointmentRecordEntity.getAdmDate() + " " + appointmentRecordEntity.getAdmTimeRange();
        String hospitalName = appointmentRecordEntity.getHospitalName();
        String deptName = appointmentRecordEntity.getDeptName();
        String docName = appointmentRecordEntity.getDocName();
        umPushMsgIOSReqVo.setDeviceTokens(deviceToken);
        String body = MessageFormat.format("{0}\u60a8\u597d\uff0c\u60a8\u5df2\u6210\u529f\u652f\u4ed8{1} {2} {3} {4}\u533b\u751f\u770b\u8bca\u7684\u6302\u53f7\u8d39\u7528\uff0c\u70b9\u51fb\u8be6\u60c5\u53ef\u8fdb\u5165\u8be6\u60c5\u67e5\u770b", patientName, admDate, hospitalName, deptName, docName);
        umPushMsgIOSReqVo.setBody(body);
        umPushMsgIOSReqVo.setTitle("\u9884\u7ea6\u6302\u53f7");
        umPushMsgIOSReqVo.setSubTitle("\u9884\u7ea6\u6302\u53f7");
        umPushMsgIOSReqVo.setDescription("\u9884\u7ea6\u6302\u53f7");
        umPushMsgIOSReqVo.setUserId(appointmentRecordEntity.getUserId());
        HashMap<String, String> map = new HashMap<String, String>(2);
        map.put("businessId", appointmentRecordEntity.getSysAppointmentId());
        map.put("content", umPushMsgIOSReqVo.getBody());
        umPushMsgIOSReqVo.setExtra(map);
        return umPushMsgIOSReqVo;
    }

    private UmPushMsgIOSReqVo buildIOSAppointCanclePushMsgTemplate(AppointmentRecordEntity appointmentRecordEntity) {
        String deviceToken = this.getDeviceToken(appointmentRecordEntity.getUserId());
        if (StringUtils.isEmpty((String)deviceToken)) {
            return null;
        }
        PushConfigurationDetailVO pushConfig = this.pushInfoManagerUtils.getPushConfig(this.propertiesConstant.getAppCode(), "youmengPush", "patient", "IOS");
        if (null == pushConfig && StringUtils.isEmpty((String)pushConfig.getClientCode())) {
            return null;
        }
        UmPushMsgIOSReqVo umPushMsgIOSReqVo = new UmPushMsgIOSReqVo();
        umPushMsgIOSReqVo.setBusiCode("hlwyygh");
        umPushMsgIOSReqVo.setClientCode(pushConfig.getClientCode());
        umPushMsgIOSReqVo.setDeviceTokens(deviceToken);
        String admDate = appointmentRecordEntity.getAdmDate();
        String hospitalName = appointmentRecordEntity.getHospitalName();
        String deptName = appointmentRecordEntity.getDeptName();
        String docName = appointmentRecordEntity.getDocName();
        String body = MessageFormat.format("\u60a8\u9884\u7ea6\u7684{0} ,\u65f6\u95f4{1},{2}\u79d1\u5ba4{3}\u533b\u751f\u7684\u53f7\uff0c\u5df2\u7ecf\u6210\u529f\u53d6\u6d88\uff0c\u8c22\u8c22\u60a8\u7684\u652f\u6301\u3002", hospitalName, admDate, deptName, docName);
        umPushMsgIOSReqVo.setBody(body);
        umPushMsgIOSReqVo.setTitle("\u9884\u7ea6\u6302\u53f7");
        umPushMsgIOSReqVo.setSubTitle("\u9884\u7ea6\u6302\u53f7");
        umPushMsgIOSReqVo.setDescription("\u9884\u7ea6\u6302\u53f7");
        umPushMsgIOSReqVo.setUserId(appointmentRecordEntity.getUserId());
        HashMap<String, String> map = new HashMap<String, String>(2);
        map.put("businessId", appointmentRecordEntity.getSysAppointmentId());
        map.put("content", umPushMsgIOSReqVo.getBody());
        umPushMsgIOSReqVo.setExtra(map);
        return umPushMsgIOSReqVo;
    }

    private UmPushMsgAndroidReqVO buildAndroidAppointPushMsgTemplate(AppointmentRecordEntity appointmentRecordEntity) {
        String deviceToken = this.getDeviceToken(appointmentRecordEntity.getUserId());
        if (StringUtils.isEmpty((String)deviceToken)) {
            return null;
        }
        PushConfigurationDetailVO pushConfig = this.pushInfoManagerUtils.getPushConfig(this.propertiesConstant.getAppCode(), "youmengPush", "patient", "Android");
        if (null == pushConfig && StringUtils.isEmpty((String)pushConfig.getClientCode())) {
            return null;
        }
        UmPushMsgAndroidReqVO umPushMsgAndroidReqVO = new UmPushMsgAndroidReqVO();
        umPushMsgAndroidReqVO.setBusiCode("hlwyygh");
        umPushMsgAndroidReqVO.setClientCode(pushConfig.getClientCode());
        String patientName = appointmentRecordEntity.getPatientName();
        String admDate = appointmentRecordEntity.getAdmDate() + " " + appointmentRecordEntity.getAdmTimeRange();
        String hospitalName = appointmentRecordEntity.getHospitalName();
        String deptName = appointmentRecordEntity.getDeptName();
        String docName = appointmentRecordEntity.getDocName();
        umPushMsgAndroidReqVO.setDeviceTokens(deviceToken);
        String text = MessageFormat.format("{0}\u60a8\u597d\uff0c\u60a8\u5df2\u6210\u529f\u652f\u4ed8{1} {2} {3} {4}\u533b\u751f\u770b\u8bca\u7684\u6302\u53f7\u8d39\u7528\uff0c\u70b9\u51fb\u8be6\u60c5\u53ef\u8fdb\u5165\u8be6\u60c5\u67e5\u770b", patientName, admDate, hospitalName, deptName, docName);
        umPushMsgAndroidReqVO.setText(text);
        umPushMsgAndroidReqVO.setTitle("\u9884\u7ea6\u6302\u53f7");
        umPushMsgAndroidReqVO.setUserId(appointmentRecordEntity.getUserId());
        HashMap<String, String> map = new HashMap<String, String>(2);
        map.put("businessId", appointmentRecordEntity.getSysAppointmentId());
        map.put("content", umPushMsgAndroidReqVO.getText());
        umPushMsgAndroidReqVO.setExtra(map);
        return umPushMsgAndroidReqVO;
    }

    private UmPushMsgAndroidReqVO buildAndroidCancleAppointPushMsgTemplate(AppointmentRecordEntity appointmentRecordEntity) {
        String deviceToken = this.getDeviceToken(appointmentRecordEntity.getUserId());
        if (StringUtils.isEmpty((String)deviceToken)) {
            return null;
        }
        PushConfigurationDetailVO pushConfig = this.pushInfoManagerUtils.getPushConfig(this.propertiesConstant.getAppCode(), "youmengPush", "patient", "Android");
        if (null == pushConfig && StringUtils.isEmpty((String)pushConfig.getClientCode())) {
            return null;
        }
        UmPushMsgAndroidReqVO umPushMsgAndroidReqVO = new UmPushMsgAndroidReqVO();
        umPushMsgAndroidReqVO.setBusiCode("hlwyygh");
        umPushMsgAndroidReqVO.setClientCode(pushConfig.getClientCode());
        String admDate = appointmentRecordEntity.getAdmDate();
        String hospitalName = appointmentRecordEntity.getHospitalName();
        String deptName = appointmentRecordEntity.getDeptName();
        String docName = appointmentRecordEntity.getDocName();
        umPushMsgAndroidReqVO.setDeviceTokens(deviceToken);
        String text = MessageFormat.format("\u60a8\u9884\u7ea6\u7684{0} ,\u65f6\u95f4{1},{2}\u79d1\u5ba4{3}\u533b\u751f\u7684\u53f7\uff0c\u5df2\u7ecf\u6210\u529f\u53d6\u6d88\uff0c\u8c22\u8c22\u60a8\u7684\u652f\u6301\u3002", hospitalName, admDate, deptName, docName);
        umPushMsgAndroidReqVO.setText(text);
        umPushMsgAndroidReqVO.setTitle("\u9884\u7ea6\u6302\u53f7");
        umPushMsgAndroidReqVO.setUserId(appointmentRecordEntity.getUserId());
        HashMap<String, String> map = new HashMap<String, String>(2);
        map.put("businessId", appointmentRecordEntity.getSysAppointmentId());
        map.put("content", umPushMsgAndroidReqVO.getText());
        umPushMsgAndroidReqVO.setExtra(map);
        return umPushMsgAndroidReqVO;
    }

    private PushSubscribeMessageReqVO buildOutPatientPushTemplateMsgVO(OpBusinessOrderEntity opBusinessOrderEntity, String payTime) {
        PushSubscribeMessageReqVO pushSubscribeMessageReqVO = new PushSubscribeMessageReqVO();
        Map data = this.getOutPatientPushTemplateData(opBusinessOrderEntity, payTime);
        String wxOpenid = this.getWxOpenid(opBusinessOrderEntity.getUserId());
        if (StringUtils.isEmpty((String)wxOpenid)) {
            log.error("======\u4ece\u7528\u6237\u4e2d\u5fc3\u83b7\u53d6openid\u5931\u8d25======");
            return null;
        }
        PushConfigurationDetailVO pushConfig = this.pushInfoManagerUtils.getPushConfig(this.propertiesConstant.getAppCode(), "weChatApplets", "patient", "weChatApplets");
        if (null == pushConfig && StringUtils.isEmpty((String)pushConfig.getClientCode())) {
            log.error("======\u83b7\u53d6\u63a8\u9001\u914d\u7f6e\u5931\u8d25======");
            return null;
        }
        pushSubscribeMessageReqVO.setOpenId(wxOpenid);
        pushSubscribeMessageReqVO.setTemplateCode("pay_success_notify");
        pushSubscribeMessageReqVO.setData(data);
        pushSubscribeMessageReqVO.setClientCode(pushConfig.getClientCode());
        return pushSubscribeMessageReqVO;
    }

    private Map<String, Map<String, Object>> getOutPatientPushTemplateData(OpBusinessOrderEntity opBusinessOrderEntity, String payTime) {
        LinkedHashMap<String, Map<String, Object>> pushTemplateDataMap = new LinkedHashMap<String, Map<String, Object>>();
        HashMap<String, String> admPatient = new HashMap<String, String>();
        admPatient.put("value", opBusinessOrderEntity.getPatientName());
        pushTemplateDataMap.put("*\u5c31\u8bca\u4eba ", admPatient);
        HashMap<String, String> serviceTime = new HashMap<String, String>();
        serviceTime.put("value", payTime);
        pushTemplateDataMap.put("*\u7f34\u8d39\u65e5\u671f ", serviceTime);
        HashMap<String, String> money = new HashMap<String, String>();
        money.put("value", "\uffe5" + opBusinessOrderEntity.getMoney().toString() + "\u5143");
        pushTemplateDataMap.put("*\u7f34\u8d39\u91d1\u989d ", money);
        HashMap<String, String> receiptId = new HashMap<String, String>();
        receiptId.put("value", opBusinessOrderEntity.getReceiptId());
        pushTemplateDataMap.put("*\u8ba2\u5355\u53f7 ", receiptId);
        HashMap<String, String> remark = new HashMap<String, String>();
        remark.put("value", "\u7f34\u8d39\u6210\u529f");
        pushTemplateDataMap.put("*\u5907\u6ce8 ", remark);
        return pushTemplateDataMap;
    }
}

