/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.doctoruser.api.pojo.base.dto.DoctorBaseInfoDTO;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.his.api.ScheduleApi;
import com.ebaiyihui.his.pojo.vo.base.GatewayRequest;
import com.ebaiyihui.his.pojo.vo.base.GatewayResponse;
import com.ebaiyihui.his.pojo.vo.schedule.GetScheduleReqVO;
import com.ebaiyihui.his.pojo.vo.schedule.GetScheduleResVO;
import com.ebaiyihui.his.pojo.vo.schedule.items.GetScheduleResItems;
import com.ebaiyihui.his.pojo.vo.schedule.items.TimeArrangeItems;
import com.ebaiyihui.wisdommedical.common.constant.ProPropertiesConstant;
import com.ebaiyihui.wisdommedical.common.enums.AdmTimeRangeEnum;
import com.ebaiyihui.wisdommedical.common.enums.ChannelEnum;
import com.ebaiyihui.wisdommedical.exception.ScheduleException;
import com.ebaiyihui.wisdommedical.mapper.AppointmentRecordMapper;
import com.ebaiyihui.wisdommedical.mapper.DeptRecordMapper;
import com.ebaiyihui.wisdommedical.mapper.HisDeptMapper;
import com.ebaiyihui.wisdommedical.mapper.HisDoctorMapper;
import com.ebaiyihui.wisdommedical.mapper.ScheduleDetailRecordMapper;
import com.ebaiyihui.wisdommedical.mapper.ScheduleRecordMapper;
import com.ebaiyihui.wisdommedical.mapper.SpecialistDoctorMapper;
import com.ebaiyihui.wisdommedical.model.AppointmentRecordEntity;
import com.ebaiyihui.wisdommedical.model.DeptRecordEntity;
import com.ebaiyihui.wisdommedical.model.DoctorRecordEntity;
import com.ebaiyihui.wisdommedical.model.HisDeptEntity;
import com.ebaiyihui.wisdommedical.model.HisDoctorEntity;
import com.ebaiyihui.wisdommedical.model.ScheduleDetailRecordEntity;
import com.ebaiyihui.wisdommedical.model.ScheduleRecordEntity;
import com.ebaiyihui.wisdommedical.model.SpecialistDoctorEntity;
import com.ebaiyihui.wisdommedical.pojo.dto.GetDocInfoRes;
import com.ebaiyihui.wisdommedical.pojo.dto.GetScheduleDTO;
import com.ebaiyihui.wisdommedical.pojo.vo.DayDoctorScheduleVo;
import com.ebaiyihui.wisdommedical.pojo.vo.GetDoctorSchedulePackingVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.GetDoctorScheduleVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.GetDoctorScheduleVoRes;
import com.ebaiyihui.wisdommedical.pojo.vo.GetScheduleVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.GetScheduleVoRes;
import com.ebaiyihui.wisdommedical.pojo.vo.HospitalDeptVo;
import com.ebaiyihui.wisdommedical.pojo.vo.RecommendedDoctorInfoVo;
import com.ebaiyihui.wisdommedical.pojo.vo.ScheduleBaseInfoVo;
import com.ebaiyihui.wisdommedical.pojo.vo.repsvo.ScheduleAndRecommendVO;
import com.ebaiyihui.wisdommedical.pojo.vo.repsvo.ScheduleStatusResVO;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.ScheduleTimeArrangeReq;
import com.ebaiyihui.wisdommedical.service.DoctorService;
import com.ebaiyihui.wisdommedical.service.ScheduleService;
import com.ebaiyihui.wisdommedical.util.DateUtils;
import com.ebaiyihui.wisdommedical.util.GetDoctorInfoUtil;
import com.ebaiyihui.wisdommedical.util.MapValueComparator;
import com.ebaiyihui.wisdommedical.util.SnowflakeIdWorker;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import redis.clients.jedis.JedisCluster;

@Service
public class ScheduleServiceImpl
implements ScheduleService {
    private static final Logger log = LoggerFactory.getLogger(ScheduleServiceImpl.class);
    @Autowired
    private ScheduleApi scheduleApi;
    @Autowired
    private SnowflakeIdWorker snowflakeIdWorker;
    @Autowired
    private AppointmentRecordMapper appointmentRecordMapper;
    @Autowired
    private DeptRecordMapper deptRecordMapper;
    @Autowired
    private ScheduleRecordMapper scheduleRecordMapper;
    @Autowired
    private ScheduleDetailRecordMapper scheduleDetailRecordMapper;
    @Autowired
    private DoctorService doctorService;
    @Autowired
    private ProPropertiesConstant propertiesConstant;
    @Autowired
    private GetDoctorInfoUtil getDoctorInfoUtil;
    @Autowired
    private HisDeptMapper hisDeptMapper;
    @Autowired
    private HisDoctorMapper hisDoctorMapper;
    @Autowired
    private SpecialistDoctorMapper specialistDoctorMapper;
    @Autowired
    private JedisCluster jedisCluster;
    public static final int TWO_HOURS = 7200;

    public List<ScheduleStatusResVO> getScheduleStatus(GetScheduleVoReq getScheduleVoReq) throws ScheduleException {
        log.info("\u67e5\u8be2\u6709\u65e0\u53f7\u6e90\u5165\u53c2\uff1a {}", (Object)JSON.toJSONString((Object)getScheduleVoReq));
        String key = getScheduleVoReq.getDeptCode() + "|" + getScheduleVoReq.getStartDate() + "|" + getScheduleVoReq.getEndDate() + "|" + getScheduleVoReq.getDeptType();
        ArrayList<ScheduleStatusResVO> list = new ArrayList();
        String listStr = this.jedisCluster.get(key);
        if (!StringUtils.isEmpty((Object)listStr) && LocalDateTime.now().getHour() < 17) {
            list = JSONObject.parseArray((String)listStr).toJavaList(ScheduleStatusResVO.class);
            log.info("key\uff1a" + key);
            log.info("\u67e5\u8be2\u6709\u65e0\u53f7\u6e90\u7f13\u5b58\u51fa\u53c2\uff1a" + JSON.toJSONString(list));
            return list;
        }
        GetScheduleResVO getScheduleResVO = this.getSchduleStatus(getScheduleVoReq);
        GetScheduleResVO schduleStatusNowday = this.getSchduleStatusNowday(getScheduleVoReq);
        List getScheduleResItemsNowday = new ArrayList();
        if (null != schduleStatusNowday) {
            getScheduleResItemsNowday = this.removeSchedule(getScheduleVoReq.getDeptType(), schduleStatusNowday.getItems());
        }
        if (Objects.nonNull(getScheduleResVO) && Objects.nonNull(getScheduleResVO.getItems())) {
            List getScheduleResItems = getScheduleResVO.getItems();
            getScheduleResItems = this.removeSchedule(getScheduleVoReq.getDeptType(), getScheduleResItems);
            getScheduleResItems = getScheduleResItems.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<GetScheduleResItems>(Comparator.comparing(GetScheduleResItems::getAdmDate))), ArrayList::new));
            Map<String, Integer> map = getScheduleResItems.stream().collect(Collectors.toMap(GetScheduleResItems::getAdmDate, GetScheduleResItems::getRegAvailable));
            String admDate = getScheduleVoReq.getStartDate();
            for (int i = 0; i < 7; ++i) {
                ScheduleStatusResVO scheduleStatusResVO = new ScheduleStatusResVO();
                Integer regAvailable = map.get(admDate);
                if (Objects.nonNull(regAvailable) && regAvailable > 0) {
                    scheduleStatusResVO.setStatus("1");
                } else {
                    scheduleStatusResVO.setStatus("-1");
                }
                scheduleStatusResVO.setAdmDate(admDate);
                if (admDate.equals(DateUtils.getCurrentDateSimpleToString())) {
                    scheduleStatusResVO.setWeek("\u4eca\u5929");
                    Integer hours = LocalDateTime.now().getHour();
                    if (null != schduleStatusNowday && getScheduleResItemsNowday.size() > 0) {
                        scheduleStatusResVO.setStatus("1");
                    }
                    switch (getScheduleVoReq.getDeptCode()) {
                        case "825": {
                            break;
                        }
                        case "632": {
                            break;
                        }
                        default: {
                            if (hours >= 17) {
                                scheduleStatusResVO.setStatus("-1");
                                break;
                            } else {
                                break;
                            }
                        }
                    }
                } else {
                    scheduleStatusResVO.setWeek(DateUtils.getWeekSimpleChinese((String)admDate));
                }
                scheduleStatusResVO.setViewDate(admDate.replace("-", ".").substring(5));
                list.add(scheduleStatusResVO);
                admDate = DateUtils.getNextDayToString((String)admDate);
            }
        } else {
            return this.schduleIsnull();
        }
        log.info("\u67e5\u8be2\u6709\u65e0\u53f7\u6e90\u51fa\u53c2\uff1a" + JSON.toJSONString(list));
        this.jedisCluster.set(key, JSONArray.toJSONString(list));
        this.jedisCluster.expire(key, 7200);
        return list;
    }

    private List<GetScheduleResItems> removeSchedule(String deptType, List<GetScheduleResItems> getScheduleResItems) {
        switch (deptType) {
            case "1": {
                getScheduleResItems.removeIf(o -> !o.getScheduleLevelName().contains("\u666e\u901a"));
                break;
            }
            case "2": {
                getScheduleResItems.removeIf(o -> o.getScheduleLevelName().contains("\u666e\u901a"));
                break;
            }
            case "3": {
                getScheduleResItems.removeIf(s -> s.getDocCode().equals("5077") || s.getDocCode().equals("5076") || s.getDocCode().equals("1995") || s.getDocCode().equals("181"));
                break;
            }
            case "4": {
                getScheduleResItems.removeIf(o -> !o.getScheduleLevelName().contains("\u7279\u9700"));
                break;
            }
            case "5": {
                List specialistDoctorEntities = this.specialistDoctorMapper.selectSpecialistDoctor();
                ArrayList<GetScheduleResItems> tempList = new ArrayList<GetScheduleResItems>();
                for (int i = 0; i < specialistDoctorEntities.size(); ++i) {
                    String docCode = ((SpecialistDoctorEntity)specialistDoctorEntities.get(i)).getDocCode();
                    getScheduleResItems.stream().forEach(items -> {
                        if (items.getDocCode().equals(docCode)) {
                            tempList.add((GetScheduleResItems)items);
                        }
                    });
                }
                getScheduleResItems = tempList;
                break;
            }
        }
        return getScheduleResItems;
    }

    public List<ScheduleStatusResVO> schduleIsnull() {
        ArrayList<ScheduleStatusResVO> list = new ArrayList<ScheduleStatusResVO>();
        String admDate = DateUtils.getCurrentDateSimpleToString();
        for (int i = 0; i < 7; ++i) {
            ScheduleStatusResVO scheduleStatusResVO = new ScheduleStatusResVO();
            scheduleStatusResVO.setStatus("-1");
            scheduleStatusResVO.setAdmDate(admDate);
            if (admDate.equals(DateUtils.getCurrentDateSimpleToString())) {
                scheduleStatusResVO.setWeek("\u4eca\u5929");
            } else {
                scheduleStatusResVO.setWeek(DateUtils.getWeekSimpleChinese((String)admDate));
            }
            scheduleStatusResVO.setViewDate(admDate.replace("-", ".").substring(5));
            list.add(scheduleStatusResVO);
            admDate = DateUtils.getNextDayToString((String)admDate);
        }
        return list;
    }

    private GetScheduleResVO getSchduleStatus(GetScheduleVoReq getScheduleVoReq) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        GetScheduleReqVO getScheduleReqVO = new GetScheduleReqVO();
        getScheduleReqVO.setBgDate(DateUtils.getStringDateAfter((String)getScheduleVoReq.getStartDate(), (Integer)1));
        getScheduleReqVO.setEdDate(getScheduleVoReq.getEndDate());
        getScheduleReqVO.setLocCode(getScheduleVoReq.getDeptCode());
        String hisId = this.getHosId(getScheduleVoReq.getDeptCode());
        getScheduleReqVO.setScheduleCode(hisId);
        gatewayRequest.setBody((Object)getScheduleReqVO);
        gatewayRequest.setChannelName(getScheduleVoReq.getChannelName());
        gatewayRequest.setChannel(getScheduleVoReq.getChannelName());
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("getDocSourceSchedule");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        log.info("\u83b7\u53d6\u6392\u73ed\u5165\u53c2one" + JSON.toJSONString((Object)gatewayRequest));
        GatewayResponse gatewayResponse = this.scheduleApi.getDocSourceSchedule(gatewayRequest);
        log.info("\u83b7\u53d6\u6392\u73ed\u51fa\u53c2one" + JSON.toJSONString((Object)gatewayResponse));
        if (null == gatewayResponse) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            return null;
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            return null;
        }
        if (gatewayResponse.getData() == null) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            return null;
        }
        GetScheduleResVO getScheduleResVO = (GetScheduleResVO)gatewayResponse.getData();
        if (CollectionUtils.isEmpty((Collection)getScheduleResVO.getItems())) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u65e0\u6392\u73ed\u4fe1\u606f");
            return null;
        }
        return getScheduleResVO;
    }

    private String getHosId(String deptCode) {
        String hospitalAreaCode = this.deptRecordMapper.getHospitalAreaCode(deptCode);
        String hosId = "NCDXDEFSYY";
        if (null != hospitalAreaCode && hospitalAreaCode.equals("7902")) {
            return "NDEFYHJZYQ";
        }
        return hosId;
    }

    private GetScheduleResVO getSchdulecommon(GetDoctorSchedulePackingVoReq getScheduleVoReq) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        GetScheduleReqVO getScheduleReqVO = new GetScheduleReqVO();
        getScheduleReqVO.setBgDate(DateUtils.getStringDateAfter((String)getScheduleVoReq.getStartDate(), (Integer)1));
        getScheduleReqVO.setEdDate(getScheduleVoReq.getEndDate());
        getScheduleReqVO.setLocCode(getScheduleVoReq.getDeptCode());
        getScheduleReqVO.setDocCode(getScheduleVoReq.getDoctorCode());
        String hisId = this.getHosId(getScheduleVoReq.getDeptCode());
        getScheduleReqVO.setScheduleCode(hisId);
        gatewayRequest.setBody((Object)getScheduleReqVO);
        gatewayRequest.setChannelName(getScheduleVoReq.getChannelName());
        gatewayRequest.setChannel(getScheduleVoReq.getChannelName());
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("getDocSourceSchedule");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        log.info("\u83b7\u53d6\u6392\u73ed\u5165\u53c2one" + JSON.toJSONString((Object)gatewayRequest));
        GatewayResponse gatewayResponse = this.scheduleApi.getDocSourceSchedule(gatewayRequest);
        if (null == gatewayResponse) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            return null;
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            return null;
        }
        if (gatewayResponse.getData() == null) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            return null;
        }
        GetScheduleResVO getScheduleResVO = (GetScheduleResVO)gatewayResponse.getData();
        if (CollectionUtils.isEmpty((Collection)getScheduleResVO.getItems())) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u65e0\u6392\u73ed\u4fe1\u606f");
            return null;
        }
        log.info("\u83b7\u53d6\u6392\u73ed\u51fa\u53c2one" + JSON.toJSONString((Object)getScheduleResVO));
        return getScheduleResVO;
    }

    private GetScheduleResVO getSchduleStatusNowday(GetScheduleVoReq getScheduleVoReq) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        GetScheduleReqVO getScheduleReqVO = new GetScheduleReqVO();
        getScheduleReqVO.setBgDate(getScheduleVoReq.getStartDate());
        getScheduleReqVO.setEdDate(getScheduleVoReq.getStartDate());
        getScheduleReqVO.setLocCode(getScheduleVoReq.getDeptCode());
        String hisId = this.getHosId(getScheduleVoReq.getDeptCode());
        getScheduleReqVO.setScheduleCode(hisId);
        gatewayRequest.setBody((Object)getScheduleReqVO);
        gatewayRequest.setChannelName(getScheduleVoReq.getChannelName());
        gatewayRequest.setChannel(getScheduleVoReq.getChannelName());
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("getDocSourceSchedule");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        log.info("\u83b7\u53d6\u6392\u73ed\u5165\u53c2one" + JSON.toJSONString((Object)gatewayRequest));
        GatewayResponse gatewayResponse = this.scheduleApi.getDocSourceSchedule(gatewayRequest);
        log.info("\u83b7\u53d6\u6392\u73ed\u51fa\u53c2one" + JSON.toJSONString((Object)gatewayResponse));
        if (null == gatewayResponse) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            return null;
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            return null;
        }
        if (gatewayResponse.getData() == null) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            return null;
        }
        GetScheduleResVO getScheduleResVO = (GetScheduleResVO)gatewayResponse.getData();
        if (CollectionUtils.isEmpty((Collection)getScheduleResVO.getItems())) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u65e0\u6392\u73ed\u4fe1\u606f");
            return null;
        }
        return getScheduleResVO;
    }

    public static void main(String[] args) {
        ArrayList items = new ArrayList();
        ArrayList<GetScheduleResItems> itemsOther = new ArrayList<GetScheduleResItems>();
        GetScheduleResItems GetScheduleResItems2 = new GetScheduleResItems();
        GetScheduleResItems2.setAdmDate("2w2w32");
        itemsOther.add(GetScheduleResItems2);
        items.addAll(itemsOther);
        System.out.println(JSONObject.toJSONString(itemsOther));
    }

    public List<GetScheduleVoRes> getSchedule(GetScheduleVoReq getScheduleVoReq) throws ScheduleException {
        Object mapValueComparator;
        log.info("\u83b7\u53d6\u5f53\u65e5\u6392\u73ed\u5165\u53c2\uff1a {}", (Object)JSON.toJSONString((Object)getScheduleVoReq));
        List scheduleResItemsList = null;
        GatewayRequest gatewayRequest = this.buildGetScheduleGatewayReq(getScheduleVoReq);
        GatewayResponse gatewayResponse = null;
        if (getScheduleVoReq.getStartDate().equals(LocalDate.now().toString())) {
            log.info("\u5b9e\u65f6\u83b7\u53d6\u5f53\u65e5\u6392\u73ed\u5165\u53c2" + JSON.toJSONString((Object)gatewayRequest));
            gatewayResponse = this.scheduleApi.getDoctorSchedule(gatewayRequest);
        } else {
            log.info("\u5b9e\u65f6\u83b7\u53d6\u6bcf\u65e5\u6392\u73ed\u5165\u53c2" + JSON.toJSONString((Object)gatewayRequest));
            gatewayResponse = this.scheduleApi.getDoctorSchedule(gatewayRequest);
        }
        log.info("\u5b9e\u65f6\u83b7\u53d6\u6392\u73ed\u51fa\u53c2" + JSON.toJSONString((Object)gatewayResponse));
        if (gatewayResponse == null) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            throw new ScheduleException(gatewayResponse.getMsg());
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            throw new ScheduleException(gatewayResponse.getMsg());
        }
        if (gatewayResponse.getData() == null) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            throw new ScheduleException(gatewayResponse.getMsg());
        }
        GetScheduleResVO getScheduleResVO = (GetScheduleResVO)gatewayResponse.getData();
        if (CollectionUtils.isEmpty((Collection)getScheduleResVO.getItems())) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u65e0\u6392\u73ed\u4fe1\u606f");
            throw new ScheduleException("\u6682\u65e0\u6392\u73ed\u4fe1\u606f");
        }
        scheduleResItemsList = getScheduleResVO.getItems();
        if ("632".equals(getScheduleVoReq.getDeptCode())) {
            scheduleResItemsList = scheduleResItemsList.stream().filter(getScheduleResItems -> !"42".equals(getScheduleResItems.getRegTitleCode())).collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty((Collection)scheduleResItemsList)) {
            return new ArrayList<GetScheduleVoRes>();
        }
        List doctorCodeList = scheduleResItemsList.stream().map(GetScheduleResItems::getDocCode).collect(Collectors.toList());
        List doctorRecordEntityList = this.doctorService.getDoctorIdList(String.join((CharSequence)",", doctorCodeList), getScheduleVoReq.getOrganCode());
        doctorRecordEntityList.removeIf(doc -> !doc.getIntroduction().equals(getScheduleVoReq.getDeptType()));
        doctorRecordEntityList = doctorRecordEntityList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<DoctorRecordEntity>(Comparator.comparing(DoctorRecordEntity::getDocCode))), ArrayList::new));
        List doctorIdList = doctorRecordEntityList.stream().map(doctorRecordEntity -> {
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)doctorRecordEntity.getDoctorId())) {
                return Long.valueOf(doctorRecordEntity.getDoctorId());
            }
            return 0L;
        }).collect(Collectors.toList());
        Map<String, DoctorRecordEntity> doctorEntrtyMap = doctorRecordEntityList.stream().collect(Collectors.toMap(DoctorRecordEntity::getDocCode, doctorRecordEntity -> doctorRecordEntity));
        List doctorBaseInfoDTOList = this.getDoctorInfoList(getScheduleVoReq.getOrganId(), doctorIdList);
        Map<String, DoctorBaseInfoDTO> doctorBaseInfoDTOMap = doctorBaseInfoDTOList.stream().collect(Collectors.toMap(doctorBaseInfo -> doctorBaseInfo.getXId().toString(), doctorBaseInfoDTO -> doctorBaseInfoDTO));
        List doctorIds = doctorBaseInfoDTOList.stream().map(DoctorBaseInfoDTO::getXId).collect(Collectors.toList());
        List getScheduleResItemsList = scheduleResItemsList.stream().filter(getScheduleResItems -> {
            if (getScheduleVoReq.getStartDate().equals(LocalDate.now().toString())) {
                Integer hours = LocalDateTime.now().getHour();
                if (hours >= 12 && getScheduleResItems.getAdmTimeRange().equals(String.valueOf(AdmTimeRangeEnum.MORNING.getValue()))) {
                    return false;
                }
                if (hours >= 17 && getScheduleResItems.getAdmTimeRange().equals(String.valueOf(AdmTimeRangeEnum.AFTERNOON.getValue()))) {
                    return false;
                }
            }
            return true;
        }).collect(Collectors.toList());
        Map<String, List<GetScheduleResItems>> getScheduleResItemMap = getScheduleResItemsList.stream().collect(Collectors.groupingBy(GetScheduleResItems::getDocCode));
        Map<Object, Object> compare = new HashMap();
        ArrayList docCodeList = new ArrayList();
        if ("1".equals(getScheduleVoReq.getDeptType())) {
            getScheduleResItemMap.keySet().forEach(docCode -> {
                if (Objects.isNull(((GetScheduleResItems)((List)getScheduleResItemMap.get(docCode)).get(0)).getScheduleLevelCode())) {
                    return;
                }
                if (!((GetScheduleResItems)((List)getScheduleResItemMap.get(docCode)).get(0)).getScheduleLevelName().contains("\u666e\u901a")) {
                    log.info("\u9700\u8981\u5220\u9664\u7684docCode\u4e3a:{}", docCode);
                    docCodeList.add(docCode);
                }
            });
            for (String docCode2 : docCodeList) {
                getScheduleResItemMap.remove(docCode2);
            }
            compare = getScheduleResItemMap;
        } else if ("2".equals(getScheduleVoReq.getDeptType())) {
            getScheduleResItemMap.keySet().forEach(docCode -> {
                if (Objects.isNull(((GetScheduleResItems)((List)getScheduleResItemMap.get(docCode)).get(0)).getScheduleLevelCode())) {
                    docCodeList.add(docCode);
                    return;
                }
                if (((GetScheduleResItems)((List)getScheduleResItemMap.get(docCode)).get(0)).getScheduleLevelName().contains("\u666e\u901a")) {
                    log.info("\u9700\u8981\u5220\u9664\u7684docCode\u4e3a:{}", docCode);
                    docCodeList.add(docCode);
                }
            });
            for (String docCode2 : docCodeList) {
                getScheduleResItemMap.remove(docCode2);
            }
            mapValueComparator = new MapValueComparator();
            compare = mapValueComparator.compare(getScheduleResItemMap);
        } else if ("4".equals(getScheduleVoReq.getDeptType())) {
            getScheduleResItemMap.keySet().forEach(docCode -> {
                if (Objects.isNull(((GetScheduleResItems)((List)getScheduleResItemMap.get(docCode)).get(0)).getScheduleLevelCode())) {
                    docCodeList.add(docCode);
                    return;
                }
                if (!((GetScheduleResItems)((List)getScheduleResItemMap.get(docCode)).get(0)).getScheduleLevelName().contains("\u7279\u9700")) {
                    log.info("\u9700\u8981\u5220\u9664\u7684docCode\u4e3a:{}", docCode);
                    docCodeList.add(docCode);
                }
                if (((GetScheduleResItems)((List)getScheduleResItemMap.get(docCode)).get(0)).getScheduleLevelName().contains("\u7279\u9700")) {
                    docCodeList.remove(docCode);
                }
            });
            for (String docCode2 : docCodeList) {
                getScheduleResItemMap.remove(docCode2);
            }
            mapValueComparator = new MapValueComparator();
            compare = mapValueComparator.compare(getScheduleResItemMap);
        } else if ("5".equals(getScheduleVoReq.getDeptType())) {
            getScheduleResItemMap.keySet().forEach(docCode -> {
                if (Objects.isNull(((GetScheduleResItems)((List)getScheduleResItemMap.get(docCode)).get(0)).getScheduleLevelCode())) {
                    docCodeList.add(docCode);
                    return;
                }
                if (!(docCode.equals("5766") || docCode.equals("6412") || docCode.equals("6384") || docCode.equals("6417") || docCode.equals("5768"))) {
                    log.info("\u9700\u8981\u5220\u9664\u7684docCode\u4e3a:{}", docCode);
                    docCodeList.add(docCode);
                }
            });
            for (String docCode2 : docCodeList) {
                getScheduleResItemMap.remove(docCode2);
            }
            mapValueComparator = new MapValueComparator();
            compare = mapValueComparator.compare(getScheduleResItemMap);
        }
        ArrayList<GetScheduleVoRes> getScheduleVoResList = new ArrayList<GetScheduleVoRes>();
        ArrayList getScheduleVoResListTemp = new ArrayList();
        compare.keySet().forEach(docCode -> {
            GetScheduleResItems getScheduleResItems = (GetScheduleResItems)((List)getScheduleResItemMap.get(docCode)).get(0);
            GetScheduleVoRes getScheduleVoRes = this.buildGetScheduleVoResVo(getScheduleResItems, getScheduleVoReq);
            if (!Objects.isNull(doctorEntrtyMap.get(docCode))) {
                String docId = ((DoctorRecordEntity)doctorEntrtyMap.get(docCode)).getDoctorId();
                String hospitalCode = ((DoctorRecordEntity)doctorEntrtyMap.get(docCode)).getHospitalAreaCode();
                String hospitalAreaName = ((DoctorRecordEntity)doctorEntrtyMap.get(docCode)).getHospitalAreaName();
                String introduction = ((DoctorRecordEntity)doctorEntrtyMap.get(docCode)).getIntroduction();
                getScheduleVoRes.setHospitalCode(hospitalCode);
                getScheduleVoRes.setHospitalAreaName(hospitalAreaName);
                getScheduleVoRes.setIntroduction(introduction);
                DoctorBaseInfoDTO doctorBaseInfoDTO = (DoctorBaseInfoDTO)doctorBaseInfoDTOMap.get(docId);
                if (doctorBaseInfoDTO != null) {
                    getScheduleVoRes.setDoctorId(docId);
                    getScheduleVoRes.setDoctorHeadPortrait(doctorBaseInfoDTO.getPortrait());
                    getScheduleVoRes.setDoctorSpeciality(doctorBaseInfoDTO.getProfession());
                    getScheduleVoRes.setDoctorGender(String.valueOf(doctorBaseInfoDTO.getGender()));
                    getScheduleVoRes.setDoctorScore(new Double(5.0));
                }
            }
            Integer appointmentCount = this.appointmentRecordMapper.selectDoctorAppointmentCount(getScheduleVoRes.getDocCode(), getScheduleVoReq.getOrganCode());
            getScheduleVoRes.setAppointmentCount(appointmentCount);
            AppointmentRecordEntity entity = this.appointmentRecordMapper.selectLastAdmRecordByUserId(getScheduleVoReq.getOrganCode(), getScheduleVoReq.getUserId());
            if (null != entity && entity.getDocCode().equals(docCode)) {
                getScheduleVoRes.setIsLastSelect(Integer.valueOf(1));
            }
            List scheduleBaseInfoVoList = ((List)getScheduleResItemMap.get(docCode)).stream().map(scheduleResItem -> this.buildScheduleBaseInfoVo(scheduleResItem)).collect(Collectors.toList());
            scheduleBaseInfoVoList.sort(Comparator.comparing(ScheduleBaseInfoVo::getAdmTimeRange));
            getScheduleVoRes.setScheduleBaseInfoVoList(scheduleBaseInfoVoList);
            if ("2531".equals(getScheduleVoRes.getDocCode())) {
                getScheduleVoResListTemp.add(getScheduleVoRes);
            } else {
                getScheduleVoResList.add(getScheduleVoRes);
            }
        });
        if (!CollectionUtils.isEmpty(compare)) {
            for (int i = 0; i < getScheduleVoResListTemp.size(); ++i) {
                getScheduleVoResList.add(i, (GetScheduleVoRes)getScheduleVoResListTemp.get(i));
            }
        }
        return getScheduleVoResList;
    }

    public List<GetScheduleVoRes> getScheduleNew(GetScheduleVoReq getScheduleVoReq) throws ScheduleException {
        log.info("\u83b7\u53d6\u5f53\u65e5\u6392\u73ed\u5165\u53c2\uff1a {}", (Object)JSON.toJSONString((Object)getScheduleVoReq));
        List scheduleResItemsList = null;
        GatewayRequest gatewayRequest = this.buildGetScheduleGatewayReq(getScheduleVoReq);
        GatewayResponse gatewayResponse = this.scheduleApi.getDoctorSchedule(gatewayRequest);
        log.info("\u5b9e\u65f6\u83b7\u53d6\u6392\u73ed\u51fa\u53c2" + JSON.toJSONString((Object)gatewayResponse));
        if (gatewayResponse == null) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            throw new ScheduleException(gatewayResponse.getMsg());
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            throw new ScheduleException(gatewayResponse.getMsg());
        }
        if (gatewayResponse.getData() == null) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            throw new ScheduleException(gatewayResponse.getMsg());
        }
        GetScheduleResVO getScheduleResVO = (GetScheduleResVO)gatewayResponse.getData();
        if (CollectionUtils.isEmpty((Collection)getScheduleResVO.getItems())) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u65e0\u6392\u73ed\u4fe1\u606f");
            throw new ScheduleException("\u6682\u65e0\u6392\u73ed\u4fe1\u606f");
        }
        scheduleResItemsList = getScheduleResVO.getItems();
        if ("632".equals(getScheduleVoReq.getDeptCode())) {
            scheduleResItemsList = scheduleResItemsList.stream().filter(getScheduleResItems -> !"42".equals(getScheduleResItems.getRegTitleCode())).collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty((Collection)scheduleResItemsList)) {
            return new ArrayList<GetScheduleVoRes>();
        }
        if ("1".equals(getScheduleVoReq.getDeptType())) {
            scheduleResItemsList = scheduleResItemsList.stream().filter(getScheduleResItems -> getScheduleResItems.getScheduleLevelName().contains("\u666e\u901a")).collect(Collectors.toList());
        } else if ("2".equals(getScheduleVoReq.getDeptType())) {
            scheduleResItemsList = scheduleResItemsList.stream().filter(getScheduleResItems -> !getScheduleResItems.getScheduleLevelName().contains("\u666e\u901a")).collect(Collectors.toList());
        } else if ("4".equals(getScheduleVoReq.getDeptType())) {
            scheduleResItemsList = scheduleResItemsList.stream().filter(getScheduleResItems -> getScheduleResItems.getScheduleLevelName().contains("\u7279\u9700")).collect(Collectors.toList());
        } else if ("5".equals(getScheduleVoReq.getDeptType())) {
            List specialistDoctorEntities = this.specialistDoctorMapper.selectSpecialistDoctor();
            ArrayList tempList = new ArrayList();
            for (int i = 0; i < specialistDoctorEntities.size(); ++i) {
                String docCode2 = ((SpecialistDoctorEntity)specialistDoctorEntities.get(i)).getDocCode();
                scheduleResItemsList.stream().forEach(items -> {
                    if (items.getDocCode().equals(docCode2)) {
                        tempList.add(items);
                    }
                });
            }
            scheduleResItemsList = tempList;
        }
        if (CollectionUtils.isEmpty(scheduleResItemsList)) {
            return new ArrayList<GetScheduleVoRes>();
        }
        List doctorCodeList = scheduleResItemsList.stream().map(GetScheduleResItems::getDocCode).collect(Collectors.toList());
        List getScheduleResItemsList = scheduleResItemsList.stream().filter(getScheduleResItems -> {
            if (getScheduleVoReq.getStartDate().equals(LocalDate.now().toString())) {
                Integer hours = LocalDateTime.now().getHour();
                if (hours >= 12 && getScheduleResItems.getAdmTimeRange().equals(String.valueOf(AdmTimeRangeEnum.MORNING.getValue()))) {
                    return false;
                }
                if (hours >= 18) {
                    return false;
                }
            }
            return true;
        }).collect(Collectors.toList());
        Map<String, List<GetScheduleResItems>> getScheduleResItemMap = getScheduleResItemsList.stream().collect(Collectors.groupingBy(GetScheduleResItems::getDocCode));
        Map compare = new HashMap();
        MapValueComparator mapValueComparator = new MapValueComparator();
        compare = mapValueComparator.compare(getScheduleResItemMap);
        ArrayList<GetScheduleVoRes> getScheduleVoResList = new ArrayList<GetScheduleVoRes>();
        ArrayList getScheduleVoResListTemp = new ArrayList();
        compare.keySet().forEach(docCode -> {
            BaseResponse docRes;
            GetScheduleResItems getScheduleResItems = (GetScheduleResItems)((List)getScheduleResItemMap.get(docCode)).get(0);
            GetScheduleVoRes getScheduleVoRes = this.buildGetScheduleVoResVo(getScheduleResItems, getScheduleVoReq);
            DeptRecordEntity deptRecordEntity = this.deptRecordMapper.selectOneByLocCodeAndHospitalCode(getScheduleVoReq.getOrganId(), getScheduleVoReq.getDeptCode());
            if (null != deptRecordEntity) {
                getScheduleVoRes.setHospitalCode(deptRecordEntity.getHospitalCode());
                getScheduleVoRes.setHospitalAreaName(deptRecordEntity.getHospitalAreaName());
                getScheduleVoRes.setIntroduction(getScheduleVoReq.getDeptType());
            }
            if ("1".equals((docRes = this.doctorService.getDoctorBasicInfoFromHis(docCode, getScheduleVoReq.getDeptCode())).getCode()) && docRes.getData() != null) {
                GetDocInfoRes doctorBaseInfoDTO = (GetDocInfoRes)docRes.getData();
                getScheduleVoRes.setDoctorHeadPortrait(doctorBaseInfoDTO.getImage_url());
                getScheduleVoRes.setDoctorSpeciality(doctorBaseInfoDTO.getDoctor_special());
                getScheduleVoRes.setDoctorScore(new Double(5.0));
            }
            Integer appointmentCount = this.appointmentRecordMapper.selectDoctorAppointmentCount(getScheduleVoRes.getDocCode(), getScheduleVoReq.getOrganCode());
            getScheduleVoRes.setAppointmentCount(appointmentCount);
            AppointmentRecordEntity entity = this.appointmentRecordMapper.selectLastAdmRecordByUserId(getScheduleVoReq.getOrganCode(), getScheduleVoReq.getUserId());
            if (null != entity && entity.getDocCode().equals(docCode)) {
                getScheduleVoRes.setIsLastSelect(Integer.valueOf(1));
            }
            List scheduleBaseInfoVoList = ((List)getScheduleResItemMap.get(docCode)).stream().map(scheduleResItem -> this.buildScheduleBaseInfoVo(scheduleResItem)).collect(Collectors.toList());
            scheduleBaseInfoVoList.sort(Comparator.comparing(ScheduleBaseInfoVo::getAdmTimeRange));
            getScheduleVoRes.setScheduleBaseInfoVoList(scheduleBaseInfoVoList);
            if ("2531".equals(getScheduleVoRes.getDocCode())) {
                getScheduleVoResListTemp.add(getScheduleVoRes);
            } else {
                getScheduleVoResList.add(getScheduleVoRes);
            }
        });
        if (!CollectionUtils.isEmpty(compare)) {
            for (int i = 0; i < getScheduleVoResListTemp.size(); ++i) {
                getScheduleVoResList.add(i, (GetScheduleVoRes)getScheduleVoResListTemp.get(i));
            }
        }
        return getScheduleVoResList;
    }

    public List<GetScheduleVoRes> getNewSchedule(GetDoctorScheduleVoReq getScheduleVoReq) throws ScheduleException {
        log.info("\u83b7\u53d6\u5f53\u65e5\u6392\u73ed\u5165\u53c2\uff1a {}", (Object)JSON.toJSONString((Object)getScheduleVoReq));
        String key = "schduleCache|" + getScheduleVoReq.getDeptCode() + "|" + getScheduleVoReq.getStartDate();
        GatewayRequest gatewayRequest = this.buildDaySchduleReq(getScheduleVoReq);
        GatewayResponse gatewayResponse = null;
        if (((GetScheduleReqVO)gatewayRequest.getBody()).getLocCode().equals("825") || ((GetScheduleReqVO)gatewayRequest.getBody()).getLocCode().equals("632")) {
            ((GetScheduleReqVO)gatewayRequest.getBody()).setDocCode("");
        }
        log.info("\u5b9e\u65f6\u83b7\u53d6\u5f53\u65e5\u6392\u73ed\u5165\u53c2" + JSON.toJSONString((Object)gatewayRequest));
        gatewayResponse = this.scheduleApi.getDoctorSchedule(gatewayRequest);
        if (gatewayResponse == null) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            throw new ScheduleException(gatewayResponse.getMsg());
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            throw new ScheduleException(gatewayResponse.getMsg());
        }
        if (gatewayResponse.getData() == null) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            throw new ScheduleException(gatewayResponse.getMsg());
        }
        GetScheduleResVO getScheduleResVO = (GetScheduleResVO)gatewayResponse.getData();
        if (CollectionUtils.isEmpty((Collection)getScheduleResVO.getItems())) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u65e0\u6392\u73ed\u4fe1\u606f");
            throw new ScheduleException("\u6682\u65e0\u6392\u73ed\u4fe1\u606f");
        }
        List scheduleResItemsList = getScheduleResVO.getItems();
        if (CollectionUtils.isEmpty((Collection)scheduleResItemsList)) {
            return new ArrayList<GetScheduleVoRes>();
        }
        if (((GetScheduleReqVO)gatewayRequest.getBody()).getLocCode().equals("825") || ((GetScheduleReqVO)gatewayRequest.getBody()).getLocCode().equals("632")) {
            scheduleResItemsList.removeIf(s -> s.getDocCode().equals("5077") || s.getDocCode().equals("5076") || s.getDocCode().equals("1995") || s.getDocCode().equals("181"));
        }
        List getScheduleResItemsList = scheduleResItemsList.stream().filter(getScheduleResItems -> {
            if (getScheduleVoReq.getStartDate().equals(LocalDate.now().toString())) {
                Integer hours = LocalDateTime.now().getHour();
                if (hours >= 12 && getScheduleResItems.getAdmTimeRange().equals(String.valueOf(AdmTimeRangeEnum.MORNING.getValue()))) {
                    return false;
                }
                if (hours >= 17 && getScheduleResItems.getAdmTimeRange().equals(String.valueOf(AdmTimeRangeEnum.AFTERNOON.getValue()))) {
                    return false;
                }
            }
            return true;
        }).collect(Collectors.toList());
        log.info("\u8fc7\u6ee4\u8fc7\u65f6\u7684\u53f7\u6e90\u4e4b\u540e\uff1a" + getScheduleResItemsList);
        Map<String, List<GetScheduleResItems>> getScheduleResItemMap = getScheduleResItemsList.stream().collect(Collectors.groupingBy(GetScheduleResItems::getDocCode));
        ArrayList<GetScheduleVoRes> getScheduleVoResList = new ArrayList<GetScheduleVoRes>();
        getScheduleResItemMap.keySet().forEach(docCode -> {
            GetScheduleResItems getScheduleResItems = (GetScheduleResItems)((List)getScheduleResItemMap.get(docCode)).get(0);
            GetScheduleVoRes getScheduleVoRes = new GetScheduleVoRes();
            getScheduleVoRes.setDocCode(getScheduleResItems.getDocCode());
            getScheduleVoRes.setDocName(getScheduleResItems.getDocName());
            getScheduleVoRes.setHospitalArea(getScheduleResItems.getHospitalArea());
            getScheduleVoRes.setHospitalAreaCode(getScheduleResItems.getHospitalAreaCode());
            getScheduleVoRes.setLocCode(getScheduleVoReq.getDeptCode());
            getScheduleVoRes.setLocName(getScheduleResItems.getLocName());
            getScheduleVoRes.setRegTitleCode(getScheduleResItems.getRegTitleCode());
            getScheduleVoRes.setRegTitleName(getScheduleResItems.getRegTitleName());
            Integer appointmentCount = this.appointmentRecordMapper.selectDoctorAppointmentCount(getScheduleVoRes.getDocCode(), getScheduleVoReq.getOrganCode());
            getScheduleVoRes.setAppointmentCount(appointmentCount);
            List scheduleBaseInfoVoList = ((List)getScheduleResItemMap.get(docCode)).stream().map(scheduleResItem -> this.buildScheduleBaseInfoVo(scheduleResItem)).collect(Collectors.toList());
            scheduleBaseInfoVoList.sort(Comparator.comparing(ScheduleBaseInfoVo::getAdmTimeRange));
            getScheduleVoRes.setScheduleBaseInfoVoList(scheduleBaseInfoVoList);
            getScheduleVoResList.add(getScheduleVoRes);
        });
        if (((GetScheduleReqVO)gatewayRequest.getBody()).getLocCode().equals("825") || ((GetScheduleReqVO)gatewayRequest.getBody()).getLocCode().equals("632")) {
            log.info("\u7f13\u5b58\u5f53\u5929\u7684\u6838\u9178\u6392\u73ed\u4fe1\u606f\uff1a" + JSON.toJSONString(getScheduleVoResList));
            this.jedisCluster.set(key, JSONArray.toJSONString(getScheduleVoResList));
            this.jedisCluster.expire(key, 14400);
        }
        return getScheduleVoResList;
    }

    public void buildScheduleTimeArrangeItems(List<GetScheduleResItems> scheduleResItemsList, GetScheduleVoReq getScheduleVoReq) {
        List isArrangeScheduleResItemList = scheduleResItemsList.stream().filter(getScheduleResItems -> getScheduleResItems.getIsTimeArrange() == 1).collect(Collectors.toList());
        HashMap<String, List> timeArrangeItemMap = new HashMap<String, List>();
        if (!CollectionUtils.isEmpty(isArrangeScheduleResItemList)) {
            for (GetScheduleResItems getScheduleResItems2 : isArrangeScheduleResItemList) {
                GetScheduleReqVO getScheduleReqVO = new GetScheduleReqVO();
                getScheduleReqVO.setScheduleCode(getScheduleResItems2.getScheduleId());
                getScheduleReqVO.setLocCode(getScheduleVoReq.getDeptCode());
                getScheduleReqVO.setDocCode(getScheduleResItems2.getDocCode());
                GetScheduleResItems getScheduleResItem = this.getScheduleTimeArrangeItems(getScheduleReqVO, getScheduleVoReq.getChannelName());
                if (null == getScheduleResItem) continue;
                timeArrangeItemMap.put(getScheduleResItems2.getScheduleId(), getScheduleResItem.getTimeArrangeItems());
            }
            for (GetScheduleResItems getScheduleResItems2 : scheduleResItemsList) {
                if (!timeArrangeItemMap.containsKey(getScheduleResItems2.getScheduleId())) continue;
                getScheduleResItems2.setTimeArrangeItems((List)timeArrangeItemMap.get(getScheduleResItems2.getScheduleId()));
            }
        }
    }

    public void buildScheduleTimeArrangeItems(List<GetScheduleResItems> scheduleResItemsList, String channelName) {
        List isArrangeScheduleResItemList = scheduleResItemsList.stream().filter(getScheduleResItems -> getScheduleResItems.getIsTimeArrange() == 1).collect(Collectors.toList());
        HashMap<String, List> timeArrangeItemMap = new HashMap<String, List>();
        if (!CollectionUtils.isEmpty(isArrangeScheduleResItemList)) {
            for (GetScheduleResItems getScheduleResItems2 : isArrangeScheduleResItemList) {
                GetScheduleReqVO getScheduleReqVO = new GetScheduleReqVO();
                getScheduleReqVO.setScheduleCode(getScheduleResItems2.getScheduleId());
                getScheduleReqVO.setLocCode(getScheduleResItems2.getLocCode());
                getScheduleReqVO.setDocCode(getScheduleResItems2.getDocCode());
                GetScheduleResItems getScheduleResItem = this.getScheduleTimeArrangeItems(getScheduleReqVO, channelName);
                if (null == getScheduleResItem) continue;
                timeArrangeItemMap.put(getScheduleResItems2.getScheduleId(), getScheduleResItem.getTimeArrangeItems());
            }
            for (GetScheduleResItems getScheduleResItems2 : scheduleResItemsList) {
                if (!timeArrangeItemMap.containsKey(getScheduleResItems2.getScheduleId())) continue;
                List timeArrangeItems = (List)timeArrangeItemMap.get(getScheduleResItems2.getScheduleId());
                if (getScheduleResItems2.getAdmDate().equals(new SimpleDateFormat("yyyy-MM-dd").format(System.currentTimeMillis()))) {
                    timeArrangeItems.removeIf(obj -> DateUtils.judgeTime((String)(obj.getEndTime() + ":00"), (String)new SimpleDateFormat("HH:mm:ss").format(System.currentTimeMillis())));
                }
                if (timeArrangeItems.isEmpty()) {
                    TimeArrangeItems temp = new TimeArrangeItems();
                    if (AdmTimeRangeEnum.MORNING.getValue().toString().equals(getScheduleResItems2.getAdmTimeRange())) {
                        temp.setStartTime("09:00");
                        temp.setEndTime("12:00");
                    }
                    if (AdmTimeRangeEnum.AFTERNOON.getValue().toString().equals(getScheduleResItems2.getAdmTimeRange())) {
                        temp.setStartTime("13:00");
                        temp.setEndTime("17:00");
                    }
                    if (AdmTimeRangeEnum.ALL_DAY.getValue().toString().equals(getScheduleResItems2.getAdmTimeRange())) {
                        temp.setStartTime("09:00");
                        temp.setEndTime("17:00");
                    }
                    if (AdmTimeRangeEnum.NIGHT.getValue().toString().equals(getScheduleResItems2.getAdmTimeRange())) {
                        temp.setStartTime("18:00");
                        temp.setEndTime("21:00");
                    }
                    temp.setTimeArrangeId("-1");
                    timeArrangeItems.add(temp);
                }
                getScheduleResItems2.setTimeArrangeItems(timeArrangeItems);
            }
        }
    }

    private GetScheduleResItems getScheduleTimeArrangeItems(GetScheduleReqVO getScheduleReqVO, String channel) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        gatewayRequest.setBody((Object)getScheduleReqVO);
        gatewayRequest.setBody((Object)getScheduleReqVO);
        gatewayRequest.setChannelName(channel);
        gatewayRequest.setChannel(channel);
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("getScheduleTimeArrangeItems");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        log.info("\u5b9e\u65f6\u83b7\u53d6his\u53f7\u6e90\u65f6\u6bb5\u4fe1\u606f\u5165\u53c2" + JSON.toJSONString((Object)gatewayRequest));
        GatewayResponse gatewayResponse = this.scheduleApi.getScheduleTimeArrangeItems(gatewayRequest);
        if (gatewayResponse == null) {
            log.error("his\u53f7\u6e90\u65f6\u6bb5\u4fe1\u606f\u67e5\u8be2 getScheduleTimeArrangeItems -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            return null;
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("his\u53f7\u6e90\u65f6\u6bb5\u4fe1\u606f\u67e5\u8be2 getScheduleTimeArrangeItems -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            return null;
        }
        if (gatewayResponse.getData() == null) {
            log.error("his\u53f7\u6e90\u65f6\u6bb5\u4fe1\u606f\u67e5\u8be2 getScheduleTimeArrangeItems -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            return null;
        }
        GetScheduleResItems getScheduleResItems = (GetScheduleResItems)gatewayResponse.getData();
        if (CollectionUtils.isEmpty((Collection)getScheduleResItems.getTimeArrangeItems())) {
            log.error("his\u53f7\u6e90\u65f6\u6bb5\u4fe1\u606f\u67e5\u8be2 getScheduleTimeArrangeItems -> his\u65e0\u5bf9\u5e94\u7684\u53f7\u6e90\u65f6\u6bb5\u4fe1\u606f");
        }
        return getScheduleResItems;
    }

    public BaseResponse<GetScheduleResItems> getScheduleTimeArrange(ScheduleTimeArrangeReq scheduleTimeArrangeReq) {
        GetScheduleReqVO getScheduleReqVO = new GetScheduleReqVO();
        getScheduleReqVO.setScheduleCode(scheduleTimeArrangeReq.getScheduleCode());
        getScheduleReqVO.setBgDate(scheduleTimeArrangeReq.getBgDate());
        getScheduleReqVO.setEdDate(scheduleTimeArrangeReq.getEdDate());
        getScheduleReqVO.setLocCode(scheduleTimeArrangeReq.getLocCode());
        getScheduleReqVO.setDocCode(scheduleTimeArrangeReq.getDocCode());
        return BaseResponse.success((Object)this.getScheduleTimeArrangeItems(getScheduleReqVO, scheduleTimeArrangeReq.getChannelName()));
    }

    public BaseResponse<GetScheduleResItems> getScheduleTimeArrangeItemsByScheduleId(String schduleId, String admDate, String admTimeRange, String hosId) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        GetScheduleReqVO getScheduleReqVO = new GetScheduleReqVO();
        getScheduleReqVO.setScheduleCode(schduleId);
        gatewayRequest.setBody((Object)getScheduleReqVO);
        gatewayRequest.setChannelName(ChannelEnum.USER_APPLETS.getDisplay());
        gatewayRequest.setChannel(hosId);
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("getScheduleTimeArrangeItemsByScheduleId");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        log.info("\u5b9e\u65f6\u83b7\u53d6his\u53f7\u6e90\u65f6\u6bb5\u4fe1\u606f\u5165\u53c2" + JSON.toJSONString((Object)gatewayRequest));
        GatewayResponse gatewayResponse = this.scheduleApi.getScheduleTimeArrangeItems(gatewayRequest);
        log.error("\u5b9e\u65f6\u83b7\u53d6his\u53f7\u6e90\u65f6\u6bb5\u4fe1\u606f\u5165\u53c2{}", (Object)JSON.toJSONString((Object)gatewayResponse));
        if (gatewayResponse == null) {
            log.error("his\u53f7\u6e90\u65f6\u6bb5\u4fe1\u606f\u67e5\u8be2 getScheduleTimeArrangeItems -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            return null;
        }
        GetScheduleResItems getScheduleResItems = new GetScheduleResItems();
        List<TimeArrangeItems> timeArrangeItems = new ArrayList();
        if (!"1".equals(gatewayResponse.getCode()) || gatewayResponse.getData() == null) {
            TimeArrangeItems temp = new TimeArrangeItems();
            if (AdmTimeRangeEnum.MORNING.getValue().toString().equals(admTimeRange)) {
                temp.setStartTime("08:00");
                temp.setEndTime("12:00");
            }
            if (AdmTimeRangeEnum.AFTERNOON.getValue().toString().equals(admTimeRange)) {
                temp.setStartTime("14:00");
                temp.setEndTime("17:30");
            }
            if (AdmTimeRangeEnum.ALL_DAY.getValue().toString().equals(admTimeRange)) {
                temp.setStartTime("08:00");
                temp.setEndTime("17:30");
            }
            if (AdmTimeRangeEnum.NIGHT.getValue().toString().equals(admTimeRange)) {
                temp.setStartTime("18:00");
                temp.setEndTime("21:00");
            }
            temp.setTimeArrangeId("-1");
            timeArrangeItems.add(temp);
            getScheduleResItems.setTimeArrangeItems(timeArrangeItems);
            return BaseResponse.success((Object)getScheduleResItems);
        }
        getScheduleResItems = (GetScheduleResItems)gatewayResponse.getData();
        timeArrangeItems = getScheduleResItems.getTimeArrangeItems();
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)admDate) && !timeArrangeItems.isEmpty() && admDate.equals(new SimpleDateFormat("yyyy-MM-dd").format(System.currentTimeMillis()))) {
            timeArrangeItems.removeIf(obj -> DateUtils.judgeTime((String)obj.getEndTime(), (String)new SimpleDateFormat("HH:mm:ss").format(System.currentTimeMillis())));
        }
        if (CollectionUtils.isEmpty((Collection)getScheduleResItems.getTimeArrangeItems())) {
            log.error("his\u53f7\u6e90\u65f6\u6bb5\u4fe1\u606f\u67e5\u8be2 getScheduleTimeArrangeItems -> his\u65e0\u5bf9\u5e94\u7684\u53f7\u6e90\u65f6\u6bb5\u4fe1\u606f");
        }
        log.info("\u5206\u65f6\u6bb5\u53f7\u6e90\u67e5\u8be2\u8fd4\u56de\u7ed9\u524d\u7aef\u51fa\u53c2\uff1a" + getScheduleResItems);
        return BaseResponse.success((Object)getScheduleResItems);
    }

    private GetScheduleVoRes buildGetScheduleVoResVo(GetScheduleResItems scheduleResItem, GetScheduleVoReq getScheduleVoReq) {
        GetScheduleVoRes getScheduleVoRes = new GetScheduleVoRes();
        getScheduleVoRes.setDocCode(scheduleResItem.getDocCode());
        getScheduleVoRes.setDocName(scheduleResItem.getDocName());
        getScheduleVoRes.setHospitalArea(scheduleResItem.getHospitalArea());
        getScheduleVoRes.setHospitalAreaCode(scheduleResItem.getHospitalAreaCode());
        getScheduleVoRes.setAdmLocation(scheduleResItem.getAdmLocation());
        getScheduleVoRes.setLocCode(getScheduleVoReq.getDeptCode());
        getScheduleVoRes.setLocName(scheduleResItem.getLocName());
        getScheduleVoRes.setRegTitleCode(scheduleResItem.getRegTitleCode());
        getScheduleVoRes.setRegTitleName(scheduleResItem.getRegTitleName());
        return getScheduleVoRes;
    }

    public GetDoctorScheduleVoRes getDoctorSchedule(GetDoctorScheduleVoReq getDoctorScheduleVoReq) throws ScheduleException {
        GatewayRequest gatewayRequest;
        List scheduleResItemsList;
        ArrayList scheduleListAll = new ArrayList();
        GatewayRequest dayGatewayRequest = this.buildDaySchduleReq(getDoctorScheduleVoReq);
        List dayScheduleResItemsList = this.getDocDaySchedule(dayGatewayRequest);
        if (!CollectionUtils.isEmpty((Collection)dayScheduleResItemsList)) {
            scheduleListAll.addAll(dayScheduleResItemsList);
        }
        if (!CollectionUtils.isEmpty((Collection)(scheduleResItemsList = this.getDocSchedule(gatewayRequest = this.buildGetDoctorScheduleGatewayReq(getDoctorScheduleVoReq))))) {
            scheduleListAll.addAll(scheduleResItemsList);
        }
        GetScheduleVoReq getScheduleVoReq = new GetScheduleVoReq();
        getScheduleVoReq.setChannelName(getDoctorScheduleVoReq.getChannelName());
        getScheduleVoReq.setDeptCode(getDoctorScheduleVoReq.getDeptCode());
        GetDoctorScheduleVoRes getDoctorScheduleVoRes = new GetDoctorScheduleVoRes();
        GetScheduleResItems getScheduleResItem = (GetScheduleResItems)scheduleListAll.get(0);
        getDoctorScheduleVoRes.setDocCode(getScheduleResItem.getDocCode());
        getDoctorScheduleVoRes.setDocName(getScheduleResItem.getDocName());
        getDoctorScheduleVoRes.setRegTitleCode(getScheduleResItem.getRegTitleCode());
        getDoctorScheduleVoRes.setRegTitleName(getScheduleResItem.getRegTitleName());
        getDoctorScheduleVoRes.setDeptCode(getDoctorScheduleVoReq.getDeptCode());
        getDoctorScheduleVoRes.setDeptName(getScheduleResItem.getLocName());
        getDoctorScheduleVoRes.setHospitalName(getScheduleResItem.getHospitalArea());
        List getScheduleResItemsList = scheduleListAll.stream().filter(getScheduleResItems -> {
            if (getScheduleResItems.getAdmDate().equals(LocalDate.now().toString())) {
                Integer hours = LocalDateTime.now().getHour();
                if (hours >= 12 && getScheduleResItems.getAdmTimeRange().equals(String.valueOf(AdmTimeRangeEnum.MORNING.getValue()))) {
                    return false;
                }
                if (hours >= 17) {
                    return false;
                }
            }
            return true;
        }).collect(Collectors.toList());
        Map<String, List<GetScheduleResItems>> getScheduleResItemsMap = getScheduleResItemsList.stream().collect(Collectors.groupingBy(GetScheduleResItems::getAdmDate));
        ArrayList dayDoctorScheduleVoList = new ArrayList();
        List<String> admDateList = getScheduleResItemsMap.keySet().stream().map(amdDate -> amdDate).collect(Collectors.toList());
        admDateList.sort(Comparator.comparing(admDate -> admDate));
        admDateList.forEach(amdDate -> {
            DayDoctorScheduleVo dayDoctorScheduleVo = new DayDoctorScheduleVo();
            List getScheduleResItems = (List)getScheduleResItemsMap.get(amdDate);
            List scheduleBaseInfoVoList = getScheduleResItems.stream().map(getScheduleRes -> this.buildScheduleBaseInfoVo(getScheduleRes)).collect(Collectors.toList());
            scheduleBaseInfoVoList.sort(Comparator.comparing(ScheduleBaseInfoVo::getAdmTimeRange));
            dayDoctorScheduleVo.setScheduleBaseInfoVoList(scheduleBaseInfoVoList);
            dayDoctorScheduleVoList.add(dayDoctorScheduleVo);
        });
        getDoctorScheduleVoRes.setDayDoctorScheduleVoList(dayDoctorScheduleVoList);
        DoctorRecordEntity doctorRecordEntity = this.doctorService.getDoctorRecordByDoctorCodeAndHosCode(getDoctorScheduleVoReq.getDoctorCode(), getDoctorScheduleVoReq.getOrganCode());
        Long docId = 0L;
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)doctorRecordEntity.getDoctorId())) {
            docId = Long.valueOf(doctorRecordEntity.getDoctorId());
        }
        getDoctorScheduleVoRes.setDoctorId(docId);
        DoctorBaseInfoDTO doctorBaseInfoDTO = this.getDoctorInfoUtil.getDoctorInfo(docId, getDoctorScheduleVoReq.getOrganId());
        if (doctorBaseInfoDTO != null) {
            getDoctorScheduleVoRes.setDoctorHeadPortrait(doctorBaseInfoDTO.getPortrait());
            getDoctorScheduleVoRes.setDoctorSpeciality(doctorBaseInfoDTO.getProfession());
            getDoctorScheduleVoRes.setDoctorIntroduce(doctorBaseInfoDTO.getIntroduction());
            getDoctorScheduleVoRes.setDoctorScore(5.0);
        }
        Integer appointmentCount = this.appointmentRecordMapper.selectDoctorAppointmentCount(getDoctorScheduleVoReq.getDoctorCode(), getDoctorScheduleVoReq.getOrganCode());
        getDoctorScheduleVoRes.setAppointmentCount(appointmentCount);
        List scheduleRecordEntityList = this.scheduleRecordMapper.selectRecommendedDoctor(getDoctorScheduleVoReq.getDoctorCode(), getDoctorScheduleVoReq.getDeptCode(), getDoctorScheduleVoReq.getOrganCode());
        if (!CollectionUtils.isEmpty((Collection)scheduleRecordEntityList)) {
            List doctorCodeList = scheduleRecordEntityList.stream().map(ScheduleRecordEntity::getDocCode).collect(Collectors.toList());
            List doctorRecordEntityList = this.doctorService.getDoctorIdList(String.join((CharSequence)",", doctorCodeList), getDoctorScheduleVoReq.getOrganCode());
            List doctorIdList = doctorRecordEntityList.stream().map(doctorRecord -> {
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)doctorRecordEntity.getDoctorId())) {
                    return Long.valueOf(doctorRecordEntity.getDoctorId());
                }
                return 0L;
            }).collect(Collectors.toList());
            Map<String, String> doctorMap = doctorRecordEntityList.stream().collect(Collectors.toMap(DoctorRecordEntity::getDocCode, DoctorRecordEntity::getDoctorId));
            List doctorBaseInfoDTOList = this.getDoctorInfoList(getDoctorScheduleVoReq.getOrganId(), doctorIdList);
            Map<String, DoctorBaseInfoDTO> doctorBaseInfoDTOMap = doctorBaseInfoDTOList.stream().collect(Collectors.toMap(doctorBaseInfo -> doctorBaseInfoDTO.getXId().toString(), doctorBaseInfo -> doctorBaseInfo));
            List doctorIds = doctorBaseInfoDTOList.stream().map(DoctorBaseInfoDTO::getXId).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty((Collection)scheduleRecordEntityList)) {
                List recommendedDoctorInfoVoList = scheduleRecordEntityList.stream().map(scheduleRecordEntity -> {
                    RecommendedDoctorInfoVo recommendedDoctorInfoVo = new RecommendedDoctorInfoVo();
                    recommendedDoctorInfoVo.setDeptCode(scheduleRecordEntity.getDeptCode());
                    recommendedDoctorInfoVo.setDeptName(scheduleRecordEntity.getDeptName());
                    recommendedDoctorInfoVo.setDoctorCode(scheduleRecordEntity.getDocCode());
                    recommendedDoctorInfoVo.setDoctorName(scheduleRecordEntity.getDocName());
                    recommendedDoctorInfoVo.setRegTitleName(scheduleRecordEntity.getRegTitelName());
                    String doctorId = (String)doctorMap.get(scheduleRecordEntity.getDocCode());
                    DoctorBaseInfoDTO doctorBaseInfo = (DoctorBaseInfoDTO)doctorBaseInfoDTOMap.get(doctorId);
                    if (doctorBaseInfo != null) {
                        recommendedDoctorInfoVo.setDoctorHeadPortrait(doctorBaseInfoDTO.getPortrait());
                        recommendedDoctorInfoVo.setDoctorSpeciality(doctorBaseInfoDTO.getProfession());
                        recommendedDoctorInfoVo.setDoctorGender(String.valueOf(doctorBaseInfoDTO.getGender()));
                        recommendedDoctorInfoVo.setDoctorScore(new Double(5.0));
                    }
                    Integer count = this.appointmentRecordMapper.selectDoctorAppointmentCount(scheduleRecordEntity.getDocCode(), scheduleRecordEntity.getHospitalCode());
                    recommendedDoctorInfoVo.setAppointmentCount(count);
                    return recommendedDoctorInfoVo;
                }).collect(Collectors.toList());
                getDoctorScheduleVoRes.setRecommendedDoctorInfoVoList(recommendedDoctorInfoVoList);
            }
        }
        return getDoctorScheduleVoRes;
    }

    public List<GetScheduleResItems> getNewDoctorSchedule(GetDoctorScheduleVoReq getDoctorScheduleVoReq) {
        GetDoctorSchedulePackingVoReq getScheduleVoReq = new GetDoctorSchedulePackingVoReq();
        if (getDoctorScheduleVoReq.getChannelName() != null && getDoctorScheduleVoReq.getChannelName().equals("FZ_WX")) {
            HisDeptEntity byHospCodeAndHisDeptCode = this.hisDeptMapper.findByHospCodeAndHisDeptCode(getDoctorScheduleVoReq.getOrganCode(), getDoctorScheduleVoReq.getDeptCode());
            getDoctorScheduleVoReq.setDeptCode(String.valueOf(byHospCodeAndHisDeptCode.getHisDeptId()));
            HisDoctorEntity byHospCodeAndHisDoctCode = this.hisDoctorMapper.findByHospCodeAndHisDoctCode(getDoctorScheduleVoReq.getOrganCode(), getDoctorScheduleVoReq.getDoctorCode());
            getDoctorScheduleVoReq.setDoctorCode(String.valueOf(byHospCodeAndHisDoctCode.getHisDoctId()));
        }
        getScheduleVoReq.setDeptCode(getDoctorScheduleVoReq.getDeptCode());
        getScheduleVoReq.setDoctorCode(getDoctorScheduleVoReq.getDoctorCode());
        getScheduleVoReq.setEndDate(getDoctorScheduleVoReq.getEndDate());
        getScheduleVoReq.setStartDate(getDoctorScheduleVoReq.getStartDate());
        List scheduleResItemsList = this.getScheduleResult(getScheduleVoReq);
        if (CollectionUtils.isEmpty((Collection)scheduleResItemsList)) {
            return null;
        }
        scheduleResItemsList.sort(Comparator.comparing(GetScheduleResItems::getAdmDate));
        return scheduleResItemsList;
    }

    private ScheduleBaseInfoVo buildScheduleBaseInfoVo(GetScheduleResItems scheduleResItem) {
        ScheduleBaseInfoVo scheduleBaseInfoVo = new ScheduleBaseInfoVo();
        scheduleBaseInfoVo.setAdmDate(scheduleResItem.getAdmDate());
        scheduleBaseInfoVo.setAdmTimeRange(scheduleResItem.getAdmTimeRange());
        scheduleBaseInfoVo.setAppStartNo(scheduleResItem.getAppStartNo());
        scheduleBaseInfoVo.setIsTimeArrange(scheduleResItem.getIsTimeArrange());
        scheduleBaseInfoVo.setLocTypeCode(scheduleResItem.getLocTypeCode());
        scheduleBaseInfoVo.setLocTypeName(scheduleResItem.getLocTypeName());
        scheduleBaseInfoVo.setRegAvailable(scheduleResItem.getRegAvailable());
        scheduleBaseInfoVo.setRegFee(String.valueOf(new BigDecimal(scheduleResItem.getRegFee()).doubleValue()));
        scheduleBaseInfoVo.setDiagFee(scheduleResItem.getDiagFee());
        BigDecimal totalFee = new BigDecimal(scheduleResItem.getRegFee()).add(new BigDecimal(scheduleResItem.getDiagFee()));
        scheduleBaseInfoVo.setTotalFee(String.valueOf(totalFee.doubleValue()));
        scheduleBaseInfoVo.setRegTotal(scheduleResItem.getRegTotal());
        scheduleBaseInfoVo.setReplaceScheduleId(scheduleResItem.getReplaceScheduleId());
        scheduleBaseInfoVo.setScheduleId(scheduleResItem.getScheduleId());
        scheduleBaseInfoVo.setScheduleLevelCode(scheduleResItem.getScheduleLevelCode());
        scheduleBaseInfoVo.setScheduleLevelName(scheduleResItem.getScheduleLevelName());
        scheduleBaseInfoVo.setScheduleStatus(scheduleResItem.getScheduleStatus());
        scheduleBaseInfoVo.setScheduleType(scheduleResItem.getScheduleType());
        scheduleBaseInfoVo.setIsAppend(scheduleResItem.getIsAppend());
        return scheduleBaseInfoVo;
    }

    private List<DoctorBaseInfoDTO> getDoctorInfoList(String organId, List<Long> doctorIdList) throws ScheduleException {
        if (CollectionUtils.isEmpty(doctorIdList)) {
            return new ArrayList<DoctorBaseInfoDTO>();
        }
        log.info("\u67e5\u8be2\u533b\u751f\u4fe1\u606f\u8bf7\u6c42\u53c2\u6570\uff1a" + doctorIdList);
        List doctorBaseInfoDTOList = this.getDoctorInfoUtil.getDoctorInfoList(doctorIdList, organId);
        if (doctorBaseInfoDTOList == null) {
            return new ArrayList<DoctorBaseInfoDTO>();
        }
        return doctorBaseInfoDTOList;
    }

    private GatewayRequest<GetScheduleReqVO> buildGetScheduleGatewayReq(GetScheduleVoReq getScheduleVoReq) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        GetScheduleReqVO getScheduleReqVO = new GetScheduleReqVO();
        getScheduleReqVO.setBgDate(getScheduleVoReq.getStartDate());
        getScheduleReqVO.setEdDate(getScheduleVoReq.getEndDate());
        getScheduleReqVO.setLocCode(getScheduleVoReq.getDeptCode());
        String hisId = this.getHosId(getScheduleVoReq.getDeptCode());
        getScheduleReqVO.setScheduleCode(hisId);
        gatewayRequest.setBody((Object)getScheduleReqVO);
        gatewayRequest.setChannelName(getScheduleVoReq.getChannelName());
        gatewayRequest.setChannel(getScheduleVoReq.getChannelName());
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("getSchedule");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    private GatewayRequest<GetScheduleReqVO> buildGetDoctorScheduleGatewayReq(GetDoctorScheduleVoReq getDoctorScheduleVoReq) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        GetScheduleReqVO getScheduleReqVO = new GetScheduleReqVO();
        getScheduleReqVO.setBgDate(DateUtils.getNextDayToString((String)getDoctorScheduleVoReq.getStartDate()));
        getScheduleReqVO.setEdDate(getDoctorScheduleVoReq.getEndDate());
        getScheduleReqVO.setLocCode(getDoctorScheduleVoReq.getDeptCode());
        getScheduleReqVO.setDocCode(getDoctorScheduleVoReq.getDoctorCode());
        String hisId = this.getHosId(getDoctorScheduleVoReq.getDeptCode());
        getScheduleReqVO.setScheduleCode(hisId);
        gatewayRequest.setBody((Object)getScheduleReqVO);
        gatewayRequest.setChannelName(getDoctorScheduleVoReq.getChannelName());
        gatewayRequest.setChannel(getDoctorScheduleVoReq.getChannelName());
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("getSchedule");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    private GatewayRequest<GetScheduleReqVO> buildDaySchduleReq(GetDoctorScheduleVoReq getDoctorScheduleVoReq) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        GetScheduleReqVO getScheduleReqVO = new GetScheduleReqVO();
        getScheduleReqVO.setBgDate(getDoctorScheduleVoReq.getStartDate());
        getScheduleReqVO.setEdDate(getDoctorScheduleVoReq.getStartDate());
        getScheduleReqVO.setLocCode(getDoctorScheduleVoReq.getDeptCode());
        getScheduleReqVO.setDocCode(getDoctorScheduleVoReq.getDoctorCode());
        String hisId = this.getHosId(getDoctorScheduleVoReq.getDeptCode());
        getScheduleReqVO.setScheduleCode(hisId);
        gatewayRequest.setBody((Object)getScheduleReqVO);
        gatewayRequest.setChannelName(getDoctorScheduleVoReq.getChannelName());
        gatewayRequest.setChannel(getDoctorScheduleVoReq.getChannelName());
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("getDaySchedule");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    private GetScheduleResItems buildGetScheduleResItems(ScheduleRecordEntity scheduleRecordEntity, List<TimeArrangeItems> timeArrangeItemsList) {
        GetScheduleResItems scheduleResItems = new GetScheduleResItems();
        scheduleResItems.setScheduleId(scheduleRecordEntity.getScheduleHisId());
        scheduleResItems.setScheduleType(Integer.valueOf(scheduleRecordEntity.getScheduleType().intValue()));
        scheduleResItems.setAdmDate(DateUtils.dateToString((Date)scheduleRecordEntity.getScheduleDate(), (String)"yyyy-MM-dd"));
        scheduleResItems.setAdmTimeRange(scheduleRecordEntity.getScheduleRange().toString());
        scheduleResItems.setHospitalArea(scheduleRecordEntity.getHospitalAreaName());
        scheduleResItems.setHospitalAreaCode(scheduleRecordEntity.getHospitalArea());
        scheduleResItems.setDocCode(scheduleRecordEntity.getDocCode());
        scheduleResItems.setDocName(scheduleRecordEntity.getDocName());
        scheduleResItems.setLocCode(scheduleRecordEntity.getDeptCode());
        scheduleResItems.setLocName(scheduleRecordEntity.getDeptName());
        scheduleResItems.setRegFee(scheduleRecordEntity.getRegFee().toString());
        scheduleResItems.setRegTitleCode(scheduleRecordEntity.getRegTitelCode());
        scheduleResItems.setRegTitleName(scheduleRecordEntity.getRegTitelName());
        scheduleResItems.setScheduleLevelCode(scheduleRecordEntity.getScheduleLevelCode());
        scheduleResItems.setScheduleLevelName(scheduleRecordEntity.getScheduleLevel());
        scheduleResItems.setLocTypeCode(scheduleRecordEntity.getDeptCategoryCode());
        scheduleResItems.setLocTypeName(scheduleRecordEntity.getDeptCategoryName());
        scheduleResItems.setAdmLocation(scheduleRecordEntity.getAdmLocation());
        scheduleResItems.setRegAvailable(scheduleRecordEntity.getAvailableCount());
        scheduleResItems.setRegTotal(scheduleRecordEntity.getTotalCount());
        scheduleResItems.setAppStartNo(String.valueOf(scheduleRecordEntity.getStartNo()));
        scheduleResItems.setScheduleStatus(scheduleRecordEntity.getStatus().toString());
        scheduleResItems.setReplaceScheduleId(scheduleRecordEntity.getReplaceScheduleHisId());
        scheduleResItems.setIsTimeArrange(Integer.valueOf(scheduleRecordEntity.getIsPrecise().intValue()));
        scheduleResItems.setDiagFee(scheduleRecordEntity.getDiagFee().toString());
        scheduleResItems.setTimeArrangeItems(timeArrangeItemsList);
        return scheduleResItems;
    }

    private List<TimeArrangeItems> buildTimeArrangeItems(List<ScheduleDetailRecordEntity> scheduleDetailRecordList) {
        List<TimeArrangeItems> TimeArrangeItemList = scheduleDetailRecordList.stream().map(scheduleDetailRecordEntity -> {
            TimeArrangeItems getTimeArrangeItems = new TimeArrangeItems();
            getTimeArrangeItems.setStartNo(scheduleDetailRecordEntity.getStartNo());
            getTimeArrangeItems.setEndNo(scheduleDetailRecordEntity.getEndNo());
            getTimeArrangeItems.setStartTime(scheduleDetailRecordEntity.getStartTime());
            getTimeArrangeItems.setEndTime(scheduleDetailRecordEntity.getEndTime());
            getTimeArrangeItems.setTimeArrangeId(scheduleDetailRecordEntity.getHisTimeArrangeId());
            getTimeArrangeItems.setBookedNos(scheduleDetailRecordEntity.getBookedNos());
            return getTimeArrangeItems;
        }).collect(Collectors.toList());
        return TimeArrangeItemList;
    }

    private List<ScheduleRecordEntity> getScheduleByScheduleDTO(GetScheduleDTO getScheduleDTO) {
        return this.scheduleRecordMapper.selectByGetScheduleDTO(getScheduleDTO);
    }

    private List<ScheduleDetailRecordEntity> getScheduleDetailRecord(String hisScheduleId, String organCode) {
        return this.scheduleDetailRecordMapper.selectByHisScheduleId(hisScheduleId, organCode);
    }

    private List<GetScheduleResItems> getScheduleResItemsList(GetScheduleDTO getScheduleDTO) {
        List recordEntityList = this.getScheduleByScheduleDTO(getScheduleDTO);
        List filterRecordEntityList = recordEntityList.stream().filter(scheduleRecordEntity -> scheduleRecordEntity.getRegFee().compareTo(BigDecimal.ZERO) != 0).collect(Collectors.toList());
        List<GetScheduleResItems> scheduleResItemsList = filterRecordEntityList.stream().map(scheduleRecordEntity -> {
            GetScheduleResItems getScheduleResItems = new GetScheduleResItems();
            List scheduleDetailRecordList = this.getScheduleDetailRecord(scheduleRecordEntity.getScheduleHisId(), scheduleRecordEntity.getHospitalCode());
            List TimeArrangeItems2 = this.buildTimeArrangeItems(scheduleDetailRecordList);
            getScheduleResItems = this.buildGetScheduleResItems(scheduleRecordEntity, TimeArrangeItems2);
            return getScheduleResItems;
        }).collect(Collectors.toList());
        return scheduleResItemsList;
    }

    private List<GetScheduleResItems> getDocSchedule(GatewayRequest<GetScheduleReqVO> gatewayRequest) {
        log.info("\u67e5\u8be2\u533b\u751f\u9884\u7ea6\u6392\u73ed\u5165\u53c2" + JSON.toJSONString(gatewayRequest));
        GatewayResponse gatewayResponse = this.scheduleApi.getDocSourceSchedule(gatewayRequest);
        if (gatewayResponse == null) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u8bf7\u6c42\u65e0\u54cd\u5e94" + gatewayResponse.getMsg());
            return new ArrayList<GetScheduleResItems>();
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            return new ArrayList<GetScheduleResItems>();
        }
        GetScheduleResVO getScheduleResVO = (GetScheduleResVO)gatewayResponse.getData();
        if (getScheduleResVO == null) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38" + gatewayResponse.getMsg());
            return new ArrayList<GetScheduleResItems>();
        }
        List getScheduleResItemsList = getScheduleResVO.getItems();
        if (CollectionUtils.isEmpty((Collection)getScheduleResItemsList)) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u65e0\u6392\u73ed\u4fe1\u606f" + gatewayResponse.getMsg());
            return new ArrayList<GetScheduleResItems>();
        }
        return getScheduleResItemsList;
    }

    private List<GetScheduleResItems> getDocDaySchedule(GatewayRequest<GetScheduleReqVO> gatewayRequest) {
        log.info("\u67e5\u8be2\u7b2c\u4e00\u5929\u7684\u533b\u751f\u6392\u73ed\u5165\u53c2" + JSON.toJSONString(gatewayRequest));
        GatewayResponse gatewayResponse = this.scheduleApi.getDoctorSchedule(gatewayRequest);
        log.info("\u67e5\u8be2\u7b2c\u4e00\u5929\u7684\u533b\u751f\u6392\u73ed\u51fa\u53c2" + JSON.toJSONString((Object)gatewayResponse));
        if (gatewayResponse == null) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u8bf7\u6c42\u65e0\u54cd\u5e94" + gatewayResponse.getMsg());
            return new ArrayList<GetScheduleResItems>();
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            return new ArrayList<GetScheduleResItems>();
        }
        GetScheduleResVO getScheduleResVO = (GetScheduleResVO)gatewayResponse.getData();
        if (getScheduleResVO == null) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38" + gatewayResponse.getMsg());
            return new ArrayList<GetScheduleResItems>();
        }
        List getScheduleResItemsList = getScheduleResVO.getItems();
        if (CollectionUtils.isEmpty((Collection)getScheduleResItemsList)) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u65e0\u6392\u73ed\u4fe1\u606f" + gatewayResponse.getMsg());
            return new ArrayList<GetScheduleResItems>();
        }
        return getScheduleResItemsList;
    }

    public BaseResponse<ScheduleAndRecommendVO> getNewScheduleAndRecommend(GetDoctorSchedulePackingVoReq getScheduleVoReq) {
        log.info("\u7528\u6237\u7aef\u67e5\u8be2\u533b\u751f\u5f53\u65e5\u6392\u73ed\u53ca\u63a8\u8350\u540c\u79d1\u5ba4\u533b\u751f\u5165\u53c2\uff1a " + JSON.toJSONString((Object)getScheduleVoReq));
        ScheduleAndRecommendVO scheduleAndRecommendVO = new ScheduleAndRecommendVO();
        List scheduleResItemsList = this.getScheduleResult(getScheduleVoReq);
        List newDoc = this.getDoctorRecommend(getScheduleVoReq);
        scheduleAndRecommendVO.setDoctorSchedule(scheduleResItemsList);
        scheduleAndRecommendVO.setDoctorRecommend(newDoc);
        return BaseResponse.success((Object)scheduleAndRecommendVO);
    }

    public List<GetScheduleResItems> getScheduleResult(GetDoctorSchedulePackingVoReq getScheduleVoReq) {
        List<Object> scheduleResItemsList = new ArrayList<GetScheduleResItems>();
        try {
            GetScheduleResVO getScheduleResVO;
            GatewayRequest gatewayRequest = new GatewayRequest();
            GetScheduleReqVO getScheduleReqVO = new GetScheduleReqVO();
            getScheduleReqVO.setBgDate(getScheduleVoReq.getStartDate());
            getScheduleReqVO.setEdDate(getScheduleVoReq.getStartDate());
            getScheduleReqVO.setLocCode(getScheduleVoReq.getDeptCode());
            getScheduleReqVO.setDocCode(getScheduleVoReq.getDoctorCode());
            String hisId = this.getHosId(getScheduleVoReq.getDeptCode());
            getScheduleReqVO.setScheduleCode(hisId);
            gatewayRequest.setBody((Object)getScheduleReqVO);
            gatewayRequest.setChannelName(getScheduleVoReq.getChannelName());
            gatewayRequest.setChannel(getScheduleVoReq.getChannelName());
            gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
            gatewayRequest.setKeyWord("getDocSourceSchedule");
            gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
            GatewayResponse gatewayResponse = null;
            log.info("\u5b9e\u65f6\u83b7\u53d6\u5f53\u65e5\u6392\u73ed\u5165\u53c2" + JSON.toJSONString((Object)gatewayRequest));
            gatewayResponse = this.scheduleApi.getDocSourceSchedule(gatewayRequest);
            GetScheduleResVO getScheduleRes = this.getSchdulecommon(getScheduleVoReq);
            if (gatewayResponse == null) {
                log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            }
            if (!"1".equals(gatewayResponse.getCode())) {
                log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            }
            if (gatewayResponse.getData() == null) {
                log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            }
            if (gatewayResponse.getData() != null && (getScheduleResVO = (GetScheduleResVO)gatewayResponse.getData()).getItems() != null) {
                scheduleResItemsList = getScheduleResVO.getItems();
            }
            if (null != getScheduleRes && null != getScheduleRes.getItems()) {
                scheduleResItemsList.addAll(getScheduleRes.getItems());
                log.info("addAll" + JSON.toJSONString(scheduleResItemsList));
            }
            log.info("addAll" + JSON.toJSONString(scheduleResItemsList));
            scheduleResItemsList = scheduleResItemsList.stream().filter(getScheduleResItems -> {
                if (getScheduleResItems.getAdmDate().equals(LocalDate.now().toString())) {
                    Integer hours = LocalDateTime.now().getHour();
                    if (hours >= 12 && getScheduleResItems.getAdmTimeRange().equals(String.valueOf(AdmTimeRangeEnum.MORNING.getValue()))) {
                        return false;
                    }
                    if (hours >= 17) {
                        return false;
                    }
                }
                return true;
            }).collect(Collectors.toList());
            if (getScheduleVoReq.getDeptType().equals("1")) {
                scheduleResItemsList.removeIf(o -> !o.getScheduleLevelName().contains("\u666e\u901a"));
            } else {
                scheduleResItemsList.removeIf(o -> o.getScheduleLevelName().contains("\u666e\u901a"));
            }
            scheduleResItemsList.stream().forEach(s -> {
                try {
                    String nowDate = DateUtils.getCurrentDateSimpleToString();
                    int num = DateUtils.daysBetween((Date)DateUtils.parseDate((String)nowDate, (String)"yyyy-MM-dd"), (Date)DateUtils.parseDate((String)s.getAdmDate(), (String)"yyyy-MM-dd"));
                    String str = num + "\u5929\u540e";
                    if (num == 0) {
                        str = "\u4eca\u5929";
                    }
                    String week = DateUtils.getWeekSimpleChinese((String)s.getAdmDate());
                    s.setDateAfter(str);
                    s.setWeek(week);
                }
                catch (Exception e) {
                    log.error("\u67e5\u8be2\u6392\u73ed\u65e5\u671f\u8f6c\u6362\u51fa\u73b0\u9519\u8bef");
                }
            });
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u6392\u73ed\u51fa\u73b0\u9519\u8bef");
        }
        scheduleResItemsList.sort(Comparator.comparing(GetScheduleResItems::getAdmDate));
        return scheduleResItemsList;
    }

    public List<HospitalDeptVo> getDoctorRecommend(GetDoctorSchedulePackingVoReq getScheduleVoReq) {
        List<Object> newDoc = new ArrayList<HospitalDeptVo>();
        try {
            ArrayList<HospitalDeptVo> listDepCode = new ArrayList<HospitalDeptVo>();
            HospitalDeptVo hospitalDeptVo = new HospitalDeptVo();
            hospitalDeptVo.setHospitalDepCode(getScheduleVoReq.getDeptCode());
            listDepCode.add(hospitalDeptVo);
            List listDoc = this.deptRecordMapper.selectDocByDeptCodeList(listDepCode);
            listDoc.removeIf(h -> h.getIntroduction().equals("1"));
            listDoc.removeIf(h -> h.getHospitalDocName().contains("\u666e\u901a\u53f7"));
            listDoc = listDoc.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<HospitalDeptVo>(Comparator.comparing(v -> v.getHospitalDocCode() + ";" + v.getHospitalDepCode()))), ArrayList::new));
            listDoc.removeIf(h -> h.getHospitalDocCode().equals(getScheduleVoReq.getDoctorCode()));
            ArrayList doctorIdList = new ArrayList();
            listDoc.stream().forEach(doc -> {
                doc.setProfession("");
                if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)doc.getDoctorId()) && org.apache.commons.lang3.StringUtils.isNumeric((CharSequence)doc.getDoctorId())) {
                    doctorIdList.add(Long.valueOf(doc.getDoctorId()));
                }
            });
            List doctorBaseInfoDTOList = this.getDoctorInfoList(getScheduleVoReq.getOrganId(), doctorIdList);
            newDoc = listDoc.stream().map(doc -> {
                doctorBaseInfoDTOList.stream().filter(bas -> doc.getDoctorId().equals(String.valueOf(bas.getXId()))).forEach(s -> {
                    doc.setProfession(s.getProfession());
                    doc.setDoctorHeadPortrait(s.getPortrait());
                });
                return doc;
            }).collect(Collectors.toList());
            newDoc.removeIf(n -> org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)n.getDoctorId()));
            newDoc.removeIf(c -> org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)c.getProfession()));
            newDoc.sort(Comparator.comparing(HospitalDeptVo::getDocSort));
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u63a8\u8350\u533b\u751f\u51fa\u73b0\u9519\u8bef");
        }
        return newDoc;
    }
}

