/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.service.impl;

import cn.hutool.json.JSONObject;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.utils.JsonUtil;
import com.ebaiyihui.wisdommedical.common.constant.ProPropertiesConstant;
import com.ebaiyihui.wisdommedical.common.enums.RouteEnumPro;
import com.ebaiyihui.wisdommedical.exception.BdHealthException;
import com.ebaiyihui.wisdommedical.mapper.AppointmentRecordMapper;
import com.ebaiyihui.wisdommedical.model.AppointmentRecordEntity;
import com.ebaiyihui.wisdommedical.pojo.bdvo.BaiduCommonResVo;
import com.ebaiyihui.wisdommedical.pojo.bdvo.CommonResponse;
import com.ebaiyihui.wisdommedical.pojo.bdvo.DoctorListUrlReqVo;
import com.ebaiyihui.wisdommedical.pojo.bdvo.DoctorListUrlResVo;
import com.ebaiyihui.wisdommedical.pojo.bdvo.GetBaiduOrderReqVo;
import com.ebaiyihui.wisdommedical.pojo.bdvo.GetBaiduOrderResVo;
import com.ebaiyihui.wisdommedical.pojo.bdvo.GetDocConsReqVo;
import com.ebaiyihui.wisdommedical.pojo.bdvo.GetDocConsResVo;
import com.ebaiyihui.wisdommedical.pojo.bdvo.GetDocPackageReqVo;
import com.ebaiyihui.wisdommedical.pojo.bdvo.GetDocPackageResVo;
import com.ebaiyihui.wisdommedical.pojo.bdvo.MessageSendReqVo;
import com.ebaiyihui.wisdommedical.pojo.bdvo.MessageSendResVo;
import com.ebaiyihui.wisdommedical.pojo.bdvo.OrderCenterPushReqVo;
import com.ebaiyihui.wisdommedical.pojo.bdvo.PatientMsgCountResVo;
import com.ebaiyihui.wisdommedical.pojo.bdvo.PushOrderInfoReqVo;
import com.ebaiyihui.wisdommedical.pojo.bdvo.UpdateOrderInfoReqVo;
import com.ebaiyihui.wisdommedical.pojo.bdvo.ZbDepartListResVo;
import com.ebaiyihui.wisdommedical.pojo.bdvo.ZbGuideRedPointReqVo;
import com.ebaiyihui.wisdommedical.pojo.bdvo.ZbGuideRedPointResVo;
import com.ebaiyihui.wisdommedical.service.SpecializDiseaseService;
import com.ebaiyihui.wisdommedical.service.impl.SpecializDiseaseServiceImpl;
import com.ebaiyihui.wisdommedical.util.BaiDuRequestUtil;
import com.ebaiyihui.wisdommedical.util.HttpKit;
import com.ebaiyihui.wisdommedical.util.MD5Utils;
import com.ebaiyihui.wisdommedical.util.RenCiUtils;
import java.lang.reflect.Type;
import java.util.ArrayList;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class SpecializDiseaseServiceImpl
implements SpecializDiseaseService {
    private static final Logger log = LoggerFactory.getLogger(SpecializDiseaseServiceImpl.class);
    @Autowired
    private StringRedisTemplate redisTemplate;
    @Autowired
    private AppointmentRecordMapper appointmentRecordMapper;
    @Autowired
    private ProPropertiesConstant constant;
    public static final Integer SCHEDULE_STATUS = 0;

    public BaseResponse<ZbGuideRedPointResVo> zbGuideRedPoint(ZbGuideRedPointReqVo zbGuideRedPointReqVo) {
        try {
            CommonResponse commonResponse = new BaiDuRequestUtil().requestBaiduPro(RouteEnumPro.ZB_GUIDE_REDPOINT.getValue(), JSON.toJSONString((Object)zbGuideRedPointReqVo), ZbGuideRedPointResVo.class);
            return BaseResponse.success((Object)commonResponse.getData());
        }
        catch (BdHealthException e) {
            return BaseResponse.success();
        }
    }

    public BaseResponse<ZbDepartListResVo> zbDepartList(String appKey, String hosCode) {
        CommonResponse commonResponse = new CommonResponse();
        log.info("\u67e5\u8be2\u4e13\u75c5\u79d1\u5ba4\u5217\u8868url:" + this.constant.getBaiduProUrl() + RouteEnumPro.ZB_DEPART_LIST.getValue() + "?hosCode=" + hosCode + "&appKey=" + appKey);
        String result = HttpKit.sendGet((String)(this.constant.getBaiduProUrl() + RouteEnumPro.ZB_DEPART_LIST.getValue() + "?hosCode=" + hosCode + "&appKey=" + appKey));
        1 typeReference = new /* Unavailable Anonymous Inner Class!! */;
        commonResponse = (CommonResponse)com.alibaba.fastjson.JSONObject.parseObject((String)result, (Type)typeReference.getType(), (Feature[])new Feature[0]);
        if (null == commonResponse) {
            return BaseResponse.error((String)"\u67e5\u8be2\u4e13\u75c5\u79d1\u5ba4\u5217\u8868\u5931\u8d25");
        }
        if (commonResponse.getErrno() != SCHEDULE_STATUS) {
            return BaseResponse.error((String)commonResponse.getErrmsg());
        }
        return BaseResponse.success((Object)commonResponse.getData());
    }

    public BaseResponse<GetDocConsResVo> getDocCons(GetDocConsReqVo getDocConsReqVo) {
        try {
            CommonResponse commonResponse = new BaiDuRequestUtil().requestBaiduPro(RouteEnumPro.ZB_DOC_CONS.getValue(), JSON.toJSONString((Object)getDocConsReqVo), GetDocConsResVo.class);
            return BaseResponse.success((Object)commonResponse.getData());
        }
        catch (BdHealthException e) {
            return BaseResponse.success();
        }
    }

    public BaseResponse<GetDocPackageResVo> getDocPackage(GetDocPackageReqVo getDocPackageReqVo) {
        try {
            CommonResponse commonResponse = new BaiDuRequestUtil().requestBaiduPro(RouteEnumPro.ZB_DOC_PACKAGE.getValue(), JSON.toJSONString((Object)getDocPackageReqVo), GetDocConsResVo.class);
            return BaseResponse.success((Object)commonResponse.getData());
        }
        catch (BdHealthException e) {
            return BaseResponse.success();
        }
    }

    public BaseResponse<PatientMsgCountResVo> patientMsgCount(String appCode, String openId) {
        CommonResponse commonResponse = new CommonResponse();
        log.info("\u4e2a\u4eba\u4e2d\u5fc3\u5c0f\u7ea2\u70b9url:" + this.constant.getBaiduProUrl() + RouteEnumPro.PATIENT_MSG_COUNT.getValue() + "?app_code=" + appCode + "&openid=" + openId);
        String result = HttpKit.sendGet((String)(this.constant.getBaiduProUrl() + RouteEnumPro.PATIENT_MSG_COUNT.getValue() + "?app_code=" + appCode + "&openid=" + openId));
        2 typeReference = new /* Unavailable Anonymous Inner Class!! */;
        commonResponse = (CommonResponse)com.alibaba.fastjson.JSONObject.parseObject((String)result, (Type)typeReference.getType(), (Feature[])new Feature[0]);
        if (null == commonResponse) {
            return BaseResponse.error((String)"\u4e2a\u4eba\u4e2d\u5fc3\u5c0f\u7ea2\u70b9\u5931\u8d25");
        }
        if (commonResponse.getErrno() != SCHEDULE_STATUS) {
            return BaseResponse.error((String)commonResponse.getErrmsg());
        }
        return BaseResponse.success((Object)commonResponse.getData());
    }

    public BaseResponse<DoctorListUrlResVo> doctorListUrl(DoctorListUrlReqVo doctorListUrlReqVo) throws BdHealthException {
        try {
            CommonResponse commonResponse = new BaiDuRequestUtil().requestBaiduPro(RouteEnumPro.DOCTOR_LIST_UR.getValue(), JSON.toJSONString((Object)doctorListUrlReqVo), DoctorListUrlResVo.class);
            return BaseResponse.success((Object)commonResponse.getData());
        }
        catch (BdHealthException e) {
            return BaseResponse.success(null);
        }
    }

    public boolean pushOrderInfo(PushOrderInfoReqVo doctorListUrlReqVo) {
        int maxCount = 6;
        log.info("\u7b2c\u3010" + doctorListUrlReqVo.getTimes() + "\u3011\u6b21\u8c03\u7528");
        try {
            CommonResponse commonResponse = new BaiDuRequestUtil().requestBaiduPro(RouteEnumPro.PUSH_ORDER_INFO.getValue(), JSON.toJSONString((Object)doctorListUrlReqVo.getOrderInfoList()), String.class);
            return true;
        }
        catch (BdHealthException e) {
            int retryCount = doctorListUrlReqVo.getTimes() + 1;
            if (retryCount >= maxCount) {
                return false;
            }
            doctorListUrlReqVo.setTimes(Integer.valueOf(retryCount));
            this.pushOrderInfo(doctorListUrlReqVo);
            return false;
        }
    }

    public boolean updateOrderInfo(UpdateOrderInfoReqVo updateOrderInfoReqVo) {
        log.info("\u7b2c\u3010" + updateOrderInfoReqVo.getTimes() + "\u3011\u6b21\u8c03\u7528");
        int maxCount = 6;
        try {
            CommonResponse commonResponse = new BaiDuRequestUtil().requestBaiduPro(RouteEnumPro.UPDATE_ORDER_INFO.getValue(), JSON.toJSONString((Object)updateOrderInfoReqVo), String.class);
            return true;
        }
        catch (BdHealthException e) {
            int retryCount = updateOrderInfoReqVo.getTimes() + 1;
            if (retryCount >= maxCount) {
                return false;
            }
            updateOrderInfoReqVo.setTimes(Integer.valueOf(retryCount));
            this.updateOrderInfo(updateOrderInfoReqVo);
            return false;
        }
    }

    public BaseResponse<MessageSendResVo> messageSend(MessageSendReqVo messageSendReqVo) {
        try {
            CommonResponse commonResponse = new CommonResponse();
            log.info("AccessTokenurl:" + this.constant.getGetbdAccessToken() + "?appCode=" + this.constant.getAppCode());
            String accessTokenData = HttpKit.sendGet((String)(this.constant.getGetbdAccessToken() + "?appCode=" + this.constant.getAppCode()));
            log.info("==accessTokenData==:" + accessTokenData);
            com.alibaba.fastjson.JSONObject jsonObject = com.alibaba.fastjson.JSONObject.parseObject((String)accessTokenData);
            String accessToken = jsonObject.getString("data");
            log.info("==accessToken==:" + accessToken);
            log.info("getMessageSendUrl:" + this.constant.getMessageSend() + "?access_token=" + accessToken);
            ArrayList params = new ArrayList();
            JSONObject json = new JSONObject((Object)com.alibaba.fastjson.JSONObject.toJSONString((Object)messageSendReqVo));
            json.forEach((k, v) -> params.add(new BasicNameValuePair(k, String.valueOf(v))));
            log.info("getMessageSend==OUT==:", (Object)json);
            String result = RenCiUtils.executeApi((String)(this.constant.getMessageSend() + "?access_token=" + accessToken), params);
            log.info("getMessageSend==OUT==:" + result);
            3 typeReference = new /* Unavailable Anonymous Inner Class!! */;
            commonResponse = (CommonResponse)com.alibaba.fastjson.JSONObject.parseObject((String)result, (Type)typeReference.getType(), (Feature[])new Feature[0]);
            if (null == commonResponse) {
                return BaseResponse.error((String)"messageSend\u5931\u8d25");
            }
            if (commonResponse.getErrno() != SCHEDULE_STATUS) {
                return BaseResponse.error((String)commonResponse.getErrmsg());
            }
            return BaseResponse.success((Object)commonResponse.getData());
        }
        catch (Exception e) {
            log.info("messageSend\u5931\u8d25 {}", (Throwable)e);
            return BaseResponse.error((String)"messageSend\u5931\u8d25");
        }
    }

    public void orderSend(OrderCenterPushReqVo orderCenterPushReqVo) {
        try {
            log.info("AccessTokenurl:" + this.constant.getGetbdAccessToken() + "?appCode=" + this.constant.getAppCode());
            String accessTokenData = HttpKit.sendGet((String)(this.constant.getGetbdAccessToken() + "?appCode=" + this.constant.getAppCode()));
            log.info("==accessTokenData==:" + accessTokenData);
            com.alibaba.fastjson.JSONObject jsonObject = com.alibaba.fastjson.JSONObject.parseObject((String)accessTokenData);
            String accessToken = jsonObject.getString("data");
            log.info("==accessToken==:" + accessToken);
            String url = this.constant.getOrderPush() + "?access_token=" + accessToken + "&open_id=" + orderCenterPushReqVo.getOpenId() + "&scene_id=&scene_type=2&m_app_key=MMmSJa";
            log.info("==aurl==:" + url);
            log.info("==orderCenterPushReqVo==:" + JSON.toJSONString((Object)orderCenterPushReqVo));
            String result = HttpKit.jsonPost((String)url, (String)JSON.toJSONString((Object)orderCenterPushReqVo));
            log.info("==orderCenterPushResVo==:" + JsonUtil.convertObject((Object)result));
        }
        catch (Exception e) {
            log.info("orderSend\u5931\u8d25 {}", (Throwable)e);
        }
    }

    public void orderUpdate(OrderCenterPushReqVo orderCenterPushReqVo) {
        try {
            log.info("AccessTokenurl:" + this.constant.getGetbdAccessToken() + "?appCode=" + this.constant.getAppCode());
            String accessTokenData = HttpKit.sendGet((String)(this.constant.getGetbdAccessToken() + "?appCode=" + this.constant.getAppCode()));
            log.info("==accessTokenData==:" + accessTokenData);
            com.alibaba.fastjson.JSONObject jsonObject = com.alibaba.fastjson.JSONObject.parseObject((String)accessTokenData);
            String accessToken = jsonObject.getString("data");
            log.info("==accessToken==:" + accessToken);
            String url = this.constant.getOrderUpdate() + "?access_token=" + accessToken + "&open_id=" + orderCenterPushReqVo.getOpenId() + "&scene_id=&scene_type=2&m_app_key=MMmSJa";
            log.info("==orderUpdateurl==:" + url);
            log.info("==orderUpdateReqVo==:" + JSON.toJSONString((Object)orderCenterPushReqVo));
            String result = HttpKit.jsonPost((String)url, (String)JSON.toJSONString((Object)orderCenterPushReqVo));
            log.info("==orderUpdateResVo==:" + JsonUtil.convertObject((Object)result));
        }
        catch (Exception e) {
            log.info("orderUpdate\u5931\u8d25 {}", (Throwable)e);
        }
    }

    public BaiduCommonResVo<GetBaiduOrderResVo> getBaiduOrders(GetBaiduOrderReqVo getBaiduOrderReqVo) {
        AppointmentRecordEntity appointmentRecordEntity = this.appointmentRecordMapper.selectBySysAppointId(getBaiduOrderReqVo.getTpOrderId());
        if (null == appointmentRecordEntity) {
            BaiduCommonResVo.error((String)"\u4e0d\u5b58\u5728\u8ba2\u5355");
        }
        GetBaiduOrderResVo getBaiduOrderResVo = new GetBaiduOrderResVo();
        getBaiduOrderResVo.setTpOrderId(appointmentRecordEntity.getAppointmentId());
        getBaiduOrderResVo.setMchIdMd5(MD5Utils.string2MD5((String)"1509251531"));
        getBaiduOrderResVo.setPayChannel("WeChat");
        getBaiduOrderResVo.setTradeNo(appointmentRecordEntity.getAppointmentId());
        getBaiduOrderResVo.setPayAmount(appointmentRecordEntity.getPayAmount());
        switch (appointmentRecordEntity.getAppointStatus()) {
            case 7: {
                getBaiduOrderResVo.setStatus(Integer.valueOf(2));
                break;
            }
            case 8: {
                getBaiduOrderResVo.setStatus(Integer.valueOf(-1));
                break;
            }
            default: {
                getBaiduOrderResVo.setStatus(Integer.valueOf(1));
            }
        }
        return null;
    }
}

