/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.service.impl;

import com.ebaiyihui.framework.utils.JsonUtil;
import com.ebaiyihui.his.api.ScheduleApi;
import com.ebaiyihui.his.pojo.vo.base.GatewayRequest;
import com.ebaiyihui.his.pojo.vo.base.GatewayResponse;
import com.ebaiyihui.his.pojo.vo.schedule.GetDeptDoctorInfoReqVO;
import com.ebaiyihui.his.pojo.vo.schedule.GetDeptDoctorInfoResVO;
import com.ebaiyihui.his.pojo.vo.schedule.GetDeptScheduleReqVO;
import com.ebaiyihui.his.pojo.vo.schedule.GetDeptScheduleResVO;
import com.ebaiyihui.his.pojo.vo.schedule.GetScheduleReqVO;
import com.ebaiyihui.his.pojo.vo.schedule.GetScheduleResVO;
import com.ebaiyihui.his.pojo.vo.schedule.items.GetDeptDoctorInfoResItems;
import com.ebaiyihui.his.pojo.vo.schedule.items.GetDeptScheduleResItems;
import com.ebaiyihui.his.pojo.vo.schedule.items.GetScheduleResItems;
import com.ebaiyihui.his.pojo.vo.schedule.items.TimeArrangeItems;
import com.ebaiyihui.wisdommedical.exception.SyncHisScheduleException;
import com.ebaiyihui.wisdommedical.mapper.DeptRecordMapper;
import com.ebaiyihui.wisdommedical.mapper.DoctorRecordMapper;
import com.ebaiyihui.wisdommedical.mapper.HisDoctorMapper;
import com.ebaiyihui.wisdommedical.mapper.HospitalAreaRecordMapper;
import com.ebaiyihui.wisdommedical.mapper.HospitalTitleMapper;
import com.ebaiyihui.wisdommedical.mapper.ScheduleDetailRecordMapper;
import com.ebaiyihui.wisdommedical.mapper.ScheduleRecordMapper;
import com.ebaiyihui.wisdommedical.model.DeptRecordEntity;
import com.ebaiyihui.wisdommedical.model.DoctorRecordEntity;
import com.ebaiyihui.wisdommedical.model.HisDoctorEntity;
import com.ebaiyihui.wisdommedical.model.HospitalAreaRecordEntity;
import com.ebaiyihui.wisdommedical.model.HospitalTitleEntity;
import com.ebaiyihui.wisdommedical.model.ScheduleDetailRecordEntity;
import com.ebaiyihui.wisdommedical.model.ScheduleRecordEntity;
import com.ebaiyihui.wisdommedical.pojo.dto.GetDeptInfoDTO;
import com.ebaiyihui.wisdommedical.pojo.dto.GetDoctorInfoDTO;
import com.ebaiyihui.wisdommedical.pojo.vo.repsvo.GetDoctorBaseInfoVo;
import com.ebaiyihui.wisdommedical.service.SynchroHisService;
import com.ebaiyihui.wisdommedical.util.DateUtils;
import com.ebaiyihui.wisdommedical.util.GetDoctorInfoUtil;
import com.ebaiyihui.wisdommedical.util.SnowflakeIdWorker;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
@Transactional
public class SynchroHisServiceImpl
implements SynchroHisService {
    private static final Logger log = LoggerFactory.getLogger(SynchroHisServiceImpl.class);
    private static Logger logger = LoggerFactory.getLogger(SynchroHisServiceImpl.class);
    @Autowired
    private ScheduleApi scheduleApi;
    @Autowired
    private HospitalAreaRecordMapper hospitalAreaRecordMapper;
    @Autowired
    private ScheduleRecordMapper scheduleRecordMapper;
    @Autowired
    private DoctorRecordMapper doctorRecordMapper;
    @Autowired
    private DeptRecordMapper deptRecordMapper;
    @Autowired
    private HospitalTitleMapper hospitalTitleMapper;
    @Autowired
    private SnowflakeIdWorker snowflakeIdWorker;
    @Autowired
    private ScheduleDetailRecordMapper scheduleDetailRecordMapper;
    @Autowired
    private GetDoctorInfoUtil getDoctorInfoUtil;
    @Autowired
    private HisDoctorMapper hisDoctorMapper;

    public void syncDocSchedule(String hospitalCode) throws SyncHisScheduleException {
        HospitalAreaRecordEntity hospitalRecord = this.hospitalAreaRecordMapper.selectOneByhospitalCode(hospitalCode);
        if (null == hospitalRecord || StringUtils.isEmpty((String)hospitalRecord.toString())) {
            log.error("----------------\u533b\u9662\u672a\u914d\u7f6e\uff0c\u533b\u9662\u7f16\u7801 hospitalCode:{}" + hospitalCode);
            throw new SyncHisScheduleException("\u533b\u9662\u4fe1\u606f\u672a\u914d\u7f6e\uff0c\u8bf7\u5148\u914d\u7f6e\u8be5\u533b\u9662\u4fe1\u606f hospitalCode=" + hospitalCode);
        }
        List deptRecordList = this.deptRecordMapper.selectListByHospitalCode(hospitalCode, null);
        if (CollectionUtils.isEmpty((Collection)deptRecordList)) {
            log.error("----------------\u533b\u9662\u79d1\u5ba4\u672a\u540c\u6b65\uff0c\u533b\u9662\u7f16\u7801 hospitalCode:{}" + hospitalCode);
            throw new SyncHisScheduleException("\u533b\u9662\u79d1\u5ba4\u672a\u540c\u6b65\uff0c\u8bf7\u5148\u540c\u6b65\u6539\u533b\u9662\u79d1\u5ba4\u4fe1\u606f hospitalCode=" + hospitalCode);
        }
        Date nowDate = DateUtils.getCurrentDate();
        Integer allowDays = 7;
        String startDate = DateUtils.dateToSimpleString((Date)nowDate);
        String endDate = DateUtils.dateToSimpleString((Date)DateUtils.addDays((Date)nowDate, (Integer)allowDays));
        ArrayList docScheduleList = new ArrayList();
        for (DeptRecordEntity deptRecordEntity : deptRecordList) {
            List schedule = this.getSchedule(startDate, endDate, deptRecordEntity.getDeptCode(), hospitalCode);
            if (CollectionUtils.isEmpty((Collection)schedule)) continue;
            docScheduleList.addAll(schedule);
        }
        if (CollectionUtils.isEmpty(docScheduleList)) {
            log.error("----------------\u533b\u751f\u6392\u73ed\u67e5\u8be2\u5931\u8d25 hospitalCode:{}" + hospitalCode);
            throw new SyncHisScheduleException("\u533b\u751f\u6392\u73ed\u67e5\u8be2\u5931\u8d25 hospitalCode=" + hospitalCode);
        }
        this.scheduleRecordMapper.updateAbleStatus();
        this.scheduleDetailRecordMapper.updateAbleStatus();
        ArrayList<ScheduleRecordEntity> recordEntityList = new ArrayList<ScheduleRecordEntity>();
        ArrayList<ScheduleDetailRecordEntity> detailRecordEntityList = new ArrayList<ScheduleDetailRecordEntity>();
        for (GetScheduleResItems getScheduleResItems : docScheduleList) {
            ScheduleRecordEntity scheduleRecordEntity = this.buildNewScheduleRecored(getScheduleResItems, hospitalRecord);
            if (null == scheduleRecordEntity) continue;
            recordEntityList.add(scheduleRecordEntity);
            if (CollectionUtils.isEmpty((Collection)getScheduleResItems.getTimeArrangeItems())) continue;
            for (TimeArrangeItems timeArrangeItem : getScheduleResItems.getTimeArrangeItems()) {
                ScheduleDetailRecordEntity newScheduleDetailRecord = this.buidScheduleDetailRecord(timeArrangeItem, getScheduleResItems, hospitalRecord);
                if (null == newScheduleDetailRecord) continue;
                detailRecordEntityList.add(newScheduleDetailRecord);
            }
        }
        this.scheduleRecordMapper.insertOrUpdatePlanList(recordEntityList);
        this.scheduleDetailRecordMapper.insertPlanList(detailRecordEntityList);
    }

    public void syncMissDocSchedule(String hospitalCode, String deptCode, String deptName) throws SyncHisScheduleException {
    }

    public void syncDeptInfo(String hospitalCode) throws SyncHisScheduleException {
        HospitalAreaRecordEntity hospitalRecord = this.hospitalAreaRecordMapper.selectOneByhospitalCode(hospitalCode);
        if (null == hospitalRecord || StringUtils.isEmpty((String)hospitalRecord.toString())) {
            log.error("----------------\u533b\u9662\u672a\u914d\u7f6e\uff0c\u533b\u9662\u7f16\u7801 hospitalCode:{}" + hospitalCode);
            throw new SyncHisScheduleException("\u533b\u9662\u4fe1\u606f\u672a\u914d\u7f6e\uff0c\u8bf7\u5148\u914d\u7f6e\u8be5\u533b\u9662\u4fe1\u606f hospitalCode=" + hospitalCode);
        }
        Date currentDate = DateUtils.getCurrentDate();
        List hisDeptSchedule = this.getHisDeptSchedule(DateUtils.dateToSimpleString((Date)currentDate), hospitalCode);
        if (CollectionUtils.isEmpty((Collection)hisDeptSchedule)) {
            log.info("------------\u540c\u6b65\u79d1\u5ba4\uff0c\u83b7\u53d6his\u79d1\u5ba4\u5931\u8d25\uff01-------------");
            throw new SyncHisScheduleException("\u540c\u6b65\u79d1\u5ba4\uff0c\u83b7\u53d6his\u79d1\u5ba4\u5931\u8d25\uff01 hospitalCode=" + hospitalCode);
        }
        ArrayList<GetDeptInfoDTO> deptInfoDTOList = new ArrayList<GetDeptInfoDTO>();
        for (GetDeptScheduleResItems getDeptScheduleResItems : hisDeptSchedule) {
            GetDeptInfoDTO getDeptInfoDTO = new GetDeptInfoDTO();
            getDeptInfoDTO.setDeptCode(getDeptScheduleResItems.getDeptCode());
            getDeptInfoDTO.setDeptName(getDeptScheduleResItems.getDeptName());
            getDeptInfoDTO.setDeptAddress(getDeptScheduleResItems.getDeptAddress());
            getDeptInfoDTO.setHospitalCode(hospitalCode);
            deptInfoDTOList.add(getDeptInfoDTO);
        }
        this.deptRecordMapper.insertOrUpdatePlanList(deptInfoDTOList);
    }

    public void syncDoctorInfo(String hospitalCode) throws SyncHisScheduleException {
        HospitalAreaRecordEntity hospitalRecord = this.hospitalAreaRecordMapper.selectOneByhospitalCode(hospitalCode);
        if (null == hospitalRecord || StringUtils.isEmpty((String)hospitalRecord.toString())) {
            log.error("----------------\u533b\u9662\u672a\u914d\u7f6e\uff0c\u533b\u9662\u7f16\u7801 hospitalCode:{}" + hospitalCode);
            throw new SyncHisScheduleException("\u533b\u9662\u4fe1\u606f\u672a\u914d\u7f6e\uff0c\u8bf7\u5148\u914d\u7f6e\u8be5\u533b\u9662\u4fe1\u606f hospitalCode=" + hospitalCode);
        }
        List doctorList = this.getHisDoctor(hospitalCode);
        if (CollectionUtils.isEmpty((Collection)doctorList)) {
            log.info("----\u672a\u67e5\u8be2\u5230\u533b\u751f\u4fe1\u606f---\u533b\u751f\u672a\u540c\u6b65");
            throw new SyncHisScheduleException("\u540c\u6b65\u533b\u751f\uff0c\u83b7\u53d6his\u533b\u751f\u5931\u8d25\uff01 hospitalCode=" + hospitalCode);
        }
        ArrayList<GetDoctorInfoDTO> getDoctorInfoDTOList = new ArrayList<GetDoctorInfoDTO>();
        for (GetDeptDoctorInfoResItems items : doctorList) {
            GetDoctorInfoDTO getDoctorInfoDTO = new GetDoctorInfoDTO();
            getDoctorInfoDTO.setDocId("");
            getDoctorInfoDTO.setDocCode(items.getDoctorCode());
            getDoctorInfoDTO.setDocName(items.getDoctorName());
            getDoctorInfoDTO.setHospitalCode(hospitalCode);
            getDoctorInfoDTO.setRegTitelCode(items.getDoctorTitle());
            getDoctorInfoDTO.setRegTitelName(items.getDoctorTitleCode());
            getDoctorInfoDTOList.add(getDoctorInfoDTO);
        }
        this.doctorRecordMapper.insertOrUpdatePlanList(getDoctorInfoDTOList);
    }

    private List<GetDeptScheduleResItems> getHisDeptSchedule(String admDate, String hospitalCode) {
        GatewayRequest request = new GatewayRequest();
        GetDeptScheduleReqVO deptScheduleReqVO = new GetDeptScheduleReqVO();
        deptScheduleReqVO.setBgDate(admDate);
        deptScheduleReqVO.setEdDate(admDate);
        request.setBody((Object)deptScheduleReqVO);
        request.setOrganCode(hospitalCode);
        request.setKeyWord("getHisSchedule");
        request.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        GatewayResponse gatewayResponse = this.scheduleApi.getDeptSchedule(request);
        if (gatewayResponse == null) {
            log.error("\u6302\u53f7\u79d1\u5ba4\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            return new ArrayList<GetDeptScheduleResItems>();
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u6302\u53f7\u79d1\u5ba4\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            return new ArrayList<GetDeptScheduleResItems>();
        }
        if (gatewayResponse.getData() == null) {
            log.error("\u6302\u53f7\u79d1\u5ba4\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            return new ArrayList<GetDeptScheduleResItems>();
        }
        List getDeptScheduleResItemsList = ((GetDeptScheduleResVO)gatewayResponse.getData()).getItems();
        if (CollectionUtils.isEmpty((Collection)getDeptScheduleResItemsList)) {
            log.error("\u6302\u53f7\u79d1\u5ba4\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u65e0\u6392\u73ed\u4fe1\u606f");
            return new ArrayList<GetDeptScheduleResItems>();
        }
        return getDeptScheduleResItemsList;
    }

    private List<GetDeptDoctorInfoResItems> getHisDoctor(String hospitalCode) {
        GatewayRequest request = new GatewayRequest();
        GetDeptDoctorInfoReqVO doctorInfoReqVO = new GetDeptDoctorInfoReqVO();
        request.setBody((Object)doctorInfoReqVO);
        request.setOrganCode(hospitalCode);
        request.setKeyWord("getHisDoctor");
        request.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        GatewayResponse gatewayResponse = this.scheduleApi.getDeptDoctorInfo(request);
        if (gatewayResponse == null) {
            log.error("\u6302\u53f7\u533b\u751f\u67e5\u8be2 getHisDoctor -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            return new ArrayList<GetDeptDoctorInfoResItems>();
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u6302\u53f7\u533b\u751f\u67e5\u8be2 getHisDoctor -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            return new ArrayList<GetDeptDoctorInfoResItems>();
        }
        if (gatewayResponse.getData() == null) {
            log.error("\u6302\u53f7\u533b\u751f\u67e5\u8be2 getHisDoctor -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            return new ArrayList<GetDeptDoctorInfoResItems>();
        }
        List items = ((GetDeptDoctorInfoResVO)gatewayResponse.getData()).getItems();
        if (CollectionUtils.isEmpty((Collection)items)) {
            log.error("\u6302\u53f7\u79d1\u5ba4\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u65e0\u6392\u73ed\u4fe1\u606f");
            return new ArrayList<GetDeptDoctorInfoResItems>();
        }
        return items;
    }

    private List<GetDeptDoctorInfoResItems> getHisDoctor(String hospitalCode, String deptCode) {
        GatewayRequest request = new GatewayRequest();
        GetDeptDoctorInfoReqVO doctorInfoReqVO = new GetDeptDoctorInfoReqVO();
        doctorInfoReqVO.setDeptCode(deptCode);
        request.setBody((Object)doctorInfoReqVO);
        request.setOrganCode(hospitalCode);
        request.setKeyWord("getHisDoctor");
        request.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        GatewayResponse gatewayResponse = this.scheduleApi.getDeptDoctorInfo(request);
        if (gatewayResponse == null) {
            log.error("\u6302\u53f7\u533b\u751f\u67e5\u8be2 getHisDoctor -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            return new ArrayList<GetDeptDoctorInfoResItems>();
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u6302\u53f7\u533b\u751f\u67e5\u8be2 getHisDoctor -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            return new ArrayList<GetDeptDoctorInfoResItems>();
        }
        if (gatewayResponse.getData() == null) {
            log.error("\u6302\u53f7\u533b\u751f\u67e5\u8be2 getHisDoctor -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            return new ArrayList<GetDeptDoctorInfoResItems>();
        }
        List items = ((GetDeptDoctorInfoResVO)gatewayResponse.getData()).getItems();
        if (CollectionUtils.isEmpty((Collection)items)) {
            log.error("\u6302\u53f7\u79d1\u5ba4\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u65e0\u6392\u73ed\u4fe1\u606f");
            return new ArrayList<GetDeptDoctorInfoResItems>();
        }
        return items;
    }

    private List<GetScheduleResItems> getSchedule(String startDate, String endDate, String deptCode, String hospitalCode) throws SyncHisScheduleException {
        GatewayRequest request = new GatewayRequest();
        GetScheduleReqVO scheduleReqVO = new GetScheduleReqVO();
        scheduleReqVO.setBgDate(startDate);
        scheduleReqVO.setEdDate(endDate);
        scheduleReqVO.setLocCode(deptCode);
        request.setOrganCode(hospitalCode);
        request.setKeyWord("getHisSchedule");
        request.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        request.setBody((Object)scheduleReqVO);
        log.info("\u67e5\u8be2his\u533b\u751f\u6392\u73ed\u8bf7\u6c42\u53c2\u6570:" + JsonUtil.convertObject((Object)request));
        GatewayResponse gatewayResponse = this.scheduleApi.getSchedule(request);
        log.info("\u67e5\u8be2his\u533b\u751f\u6392\u73ed\u8fd4\u56de\u53c2\u6570:" + JsonUtil.convertObject((Object)gatewayResponse));
        if (gatewayResponse == null) {
            log.error("\u6302\u53f7\u533b\u751f\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            return new ArrayList<GetScheduleResItems>();
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u6302\u53f7\u533b\u751f\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            return new ArrayList<GetScheduleResItems>();
        }
        if (gatewayResponse.getData() == null) {
            log.error("\u6302\u53f7\u533b\u751f\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            return new ArrayList<GetScheduleResItems>();
        }
        List getScheduleResItemsList = ((GetScheduleResVO)gatewayResponse.getData()).getItems();
        if (CollectionUtils.isEmpty((Collection)getScheduleResItemsList)) {
            log.error("\u6302\u53f7\u533b\u751f\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u65e0\u6392\u73ed\u4fe1\u606f");
            return new ArrayList<GetScheduleResItems>();
        }
        return getScheduleResItemsList;
    }

    public void syncDeptCoedAndDoctorInfo(String hospitalCode) throws SyncHisScheduleException {
        ArrayList deptDoctorList = new ArrayList();
        List secondDeptList = this.deptRecordMapper.selectListByHospitalCode(hospitalCode, "");
        if (!secondDeptList.isEmpty()) {
            secondDeptList.removeIf(dep -> dep.getIntroduction().equals("1"));
            String startDate = DateUtils.getCurrentDate((String)"yyyy-MM-dd");
            String endDate = DateUtils.getCurrentDate((String)"yyyy-MM-dd");
            secondDeptList.stream().forEach(deptRecordEntity -> {
                List getDeptDoctorInfoResItemsList = this.getHisDoctor(hospitalCode, deptRecordEntity.getDeptCode());
                if (!getDeptDoctorInfoResItemsList.isEmpty()) {
                    ArrayList<GetDoctorInfoDTO> getDoctorInfoDTOList = new ArrayList<GetDoctorInfoDTO>();
                    for (GetDeptDoctorInfoResItems items : getDeptDoctorInfoResItemsList) {
                        GetDoctorInfoDTO getDoctorInfoDTO = new GetDoctorInfoDTO();
                        HisDoctorEntity hisDoctorEntity = this.hisDoctorMapper.findByHospCodeAndHisDoctorId(hospitalCode, items.getDoctorCode());
                        getDoctorInfoDTO.setDocId("");
                        if (!Objects.isNull(hisDoctorEntity)) {
                            HashMap<String, Object> params = new HashMap<String, Object>();
                            ArrayList<String> emplCodeList = new ArrayList<String>();
                            emplCodeList.add(hisDoctorEntity.getHisDoctCode());
                            params.put("emplCodeList", emplCodeList);
                            params.put("organId", hospitalCode);
                            List doctorBaseInfoDTO = this.getDoctorInfoUtil.getDoctorInfoList(params);
                            if (null != doctorBaseInfoDTO && doctorBaseInfoDTO.size() > 0) {
                                getDoctorInfoDTO.setDocId(((GetDoctorBaseInfoVo)doctorBaseInfoDTO.get(0)).getId());
                            }
                        }
                        getDoctorInfoDTO.setDocCode(items.getDoctorCode());
                        getDoctorInfoDTO.setDocName(items.getDoctorName());
                        getDoctorInfoDTO.setHospitalCode(hospitalCode);
                        getDoctorInfoDTO.setRegTitelCode(items.getDoctorTitle());
                        getDoctorInfoDTO.setRegTitelName(items.getDoctorTitleCode());
                        getDoctorInfoDTO.setDeptCode(deptRecordEntity.getDeptCode());
                        switch (items.getDoctorTitle()) {
                            case "47": {
                                getDoctorInfoDTO.setDocSort(1);
                                break;
                            }
                            case "48": {
                                getDoctorInfoDTO.setDocSort(2);
                                break;
                            }
                            case "9": {
                                getDoctorInfoDTO.setDocSort(3);
                                break;
                            }
                            case "11": {
                                getDoctorInfoDTO.setDocSort(4);
                                break;
                            }
                            case "49": {
                                getDoctorInfoDTO.setDocSort(5);
                                break;
                            }
                            case "50": {
                                getDoctorInfoDTO.setDocSort(6);
                                break;
                            }
                            case "33": {
                                getDoctorInfoDTO.setDocSort(7);
                                break;
                            }
                            case "58": {
                                getDoctorInfoDTO.setDocSort(8);
                                break;
                            }
                            case "1": {
                                getDoctorInfoDTO.setDocSort(9);
                                break;
                            }
                            case "60": {
                                getDoctorInfoDTO.setDocSort(10);
                                break;
                            }
                            default: {
                                getDoctorInfoDTO.setDocSort(11);
                            }
                        }
                        getDoctorInfoDTOList.add(getDoctorInfoDTO);
                    }
                    deptDoctorList.addAll(getDoctorInfoDTOList);
                }
            });
            this.doctorRecordMapper.insertOrUpdateDocInfo(deptDoctorList);
        }
    }

    private List<GetScheduleResItems> getDocSchedule(String startDate, String endDate, String deptCode, String hospitalCode) throws SyncHisScheduleException {
        List appointScheduleList;
        ArrayList<GetScheduleResItems> getScheduleResItemsList = new ArrayList<GetScheduleResItems>();
        List dayScheduleList = this.getDaySchedule(startDate, deptCode, hospitalCode);
        if (!CollectionUtils.isEmpty((Collection)dayScheduleList)) {
            getScheduleResItemsList.addAll(dayScheduleList);
        }
        if (!CollectionUtils.isEmpty((Collection)(appointScheduleList = this.getAppointSchedule(startDate, endDate, deptCode, hospitalCode)))) {
            getScheduleResItemsList.addAll(appointScheduleList);
        }
        return getScheduleResItemsList;
    }

    private ScheduleRecordEntity buildNewScheduleRecored(GetScheduleResItems schedule, HospitalAreaRecordEntity hospitalRecord) {
        ScheduleRecordEntity scheduleRecord = new ScheduleRecordEntity();
        scheduleRecord.setAdmLocation(schedule.getAdmLocation());
        scheduleRecord.setAvailableCount(schedule.getRegAvailable());
        scheduleRecord.setDeptCategoryCode(schedule.getLocTypeCode());
        scheduleRecord.setDeptCategoryName(schedule.getLocTypeName());
        scheduleRecord.setDeptCode(schedule.getLocCode());
        scheduleRecord.setDeptName(schedule.getLocName());
        scheduleRecord.setDocCode(schedule.getDocCode());
        scheduleRecord.setDocName(schedule.getDocName());
        scheduleRecord.setHospitalArea(schedule.getHospitalAreaCode());
        scheduleRecord.setHospitalAreaName(schedule.getHospitalArea());
        scheduleRecord.setHospitalCode(hospitalRecord.getHospitalCode());
        scheduleRecord.setHospitalName(hospitalRecord.getHospitalAreaName());
        scheduleRecord.setIsPrecise(Byte.valueOf(schedule.getIsTimeArrange().byteValue()));
        scheduleRecord.setRegFee(StringUtils.isEmpty((String)schedule.getRegFee()) ? BigDecimal.ZERO : new BigDecimal(schedule.getRegFee()));
        scheduleRecord.setReplaceScheduleHisId(schedule.getReplaceScheduleId());
        scheduleRecord.setScheduleDate(DateUtils.stringToSimpleDate((String)schedule.getAdmDate()));
        scheduleRecord.setScheduleHisId(schedule.getScheduleId());
        scheduleRecord.setScheduleLevel(schedule.getScheduleLevelName());
        scheduleRecord.setScheduleLevelCode(schedule.getScheduleLevelCode());
        scheduleRecord.setScheduleLevelOrder(Integer.valueOf(1));
        scheduleRecord.setScheduleRange(Byte.valueOf(schedule.getAdmTimeRange()));
        scheduleRecord.setScheduleType(Byte.valueOf(schedule.getScheduleType().byteValue()));
        scheduleRecord.setServiceFee(new BigDecimal("0.0"));
        scheduleRecord.setStatus(Byte.valueOf(schedule.getScheduleStatus()));
        scheduleRecord.setTotalCount(schedule.getRegTotal());
        scheduleRecord.setRegTitelCode(schedule.getRegTitleCode());
        scheduleRecord.setRegTitelName(schedule.getRegTitleName());
        scheduleRecord.setUpdatetime(new Date());
        scheduleRecord.setUpdateStatus(Byte.valueOf((byte)1));
        scheduleRecord.setSysScheduleId(String.valueOf(this.snowflakeIdWorker.nextId()));
        scheduleRecord.setAutoId(Long.valueOf(this.snowflakeIdWorker.nextId()));
        scheduleRecord.setDiagFee(StringUtils.isEmpty((String)schedule.getDiagFee()) ? BigDecimal.ZERO : new BigDecimal(schedule.getDiagFee()));
        scheduleRecord.setIsAppend(schedule.getIsAppend());
        return scheduleRecord;
    }

    private DoctorRecordEntity buildDoctorRecord(GetScheduleResItems schedule, String hospitalCode) {
        DoctorRecordEntity doctorRecord = new DoctorRecordEntity();
        doctorRecord.setDocCode(schedule.getDocCode());
        doctorRecord.setDocName(schedule.getDocName());
        doctorRecord.setHospitalCode(hospitalCode);
        doctorRecord.setRegTitelCode(schedule.getRegTitleCode());
        doctorRecord.setRegTitelName(schedule.getRegTitleName());
        doctorRecord.setStatus(Byte.valueOf((byte)1));
        return doctorRecord;
    }

    private DeptRecordEntity buildNewDeptRecord(String deptCode, String deptName, String hospitalCode) {
        DeptRecordEntity deptRecord = new DeptRecordEntity();
        deptRecord.setAddress("");
        deptRecord.setDeptCode(deptCode);
        deptRecord.setDeptName(deptName);
        deptRecord.setDeptType(Byte.valueOf((byte)1));
        deptRecord.setHospitalCode(hospitalCode);
        deptRecord.setIntroduction("");
        deptRecord.setStatus(Byte.valueOf((byte)1));
        return deptRecord;
    }

    private ScheduleDetailRecordEntity buidScheduleDetailRecord(TimeArrangeItems timeArrangeItem, GetScheduleResItems schedule, HospitalAreaRecordEntity hospitalRecord) {
        ScheduleDetailRecordEntity scheduleDetailRecord = new ScheduleDetailRecordEntity();
        scheduleDetailRecord.setAvaliable(Integer.valueOf(timeArrangeItem.getStartNo().equals(timeArrangeItem.getEndNo()) ? 1 : schedule.getRegAvailable()));
        scheduleDetailRecord.setBookedNos(timeArrangeItem.getBookedNos());
        scheduleDetailRecord.setEndNo(timeArrangeItem.getEndNo());
        scheduleDetailRecord.setEndTime(timeArrangeItem.getEndTime());
        scheduleDetailRecord.setHisScheduleId(schedule.getScheduleId());
        scheduleDetailRecord.setHisTimeArrangeId(timeArrangeItem.getTimeArrangeId());
        scheduleDetailRecord.setHospitalCode(hospitalRecord.getHospitalCode());
        scheduleDetailRecord.setStartTime(timeArrangeItem.getStartTime());
        scheduleDetailRecord.setStartNo(timeArrangeItem.getStartNo());
        scheduleDetailRecord.setSysScheduleId(String.valueOf(this.snowflakeIdWorker.nextId()));
        scheduleDetailRecord.setTotal(Integer.valueOf(timeArrangeItem.getStartNo().equals(timeArrangeItem.getEndNo()) ? 1 : schedule.getRegTotal()));
        scheduleDetailRecord.setUpdatetime(new Date());
        scheduleDetailRecord.setUpdateStatus(Byte.valueOf((byte)1));
        scheduleDetailRecord.setSysTimeArrangeId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return scheduleDetailRecord;
    }

    private HospitalTitleEntity buildHospitalTitle(GetScheduleResItems schedule, String hospitalCode) {
        HospitalTitleEntity hospitalTitle = new HospitalTitleEntity();
        hospitalTitle.setHospitalCode(hospitalCode);
        hospitalTitle.setHospitalAreaCode(schedule.getHospitalAreaCode());
        hospitalTitle.setName(schedule.getRegTitleName());
        hospitalTitle.setCode(schedule.getScheduleLevelCode());
        hospitalTitle.setStatus(Byte.valueOf((byte)1));
        hospitalTitle.setSerialNumber(Integer.valueOf(1));
        return hospitalTitle;
    }

    private List<GetScheduleResItems> getDaySchedule(String startDate, String deptCode, String hospitalCode) throws SyncHisScheduleException {
        GatewayRequest request = new GatewayRequest();
        GetScheduleReqVO scheduleReqVO = new GetScheduleReqVO();
        scheduleReqVO.setBgDate(startDate);
        scheduleReqVO.setEdDate(startDate);
        scheduleReqVO.setLocCode(deptCode);
        request.setOrganCode(hospitalCode);
        request.setKeyWord("getDocSchedule");
        request.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        request.setBody((Object)scheduleReqVO);
        log.info("\u67e5\u8be2\u5f53\u65e5his\u533b\u751f\u6392\u73ed\u8bf7\u6c42\u53c2\u6570:" + JsonUtil.convertObject((Object)request));
        GatewayResponse gatewayResponse = this.scheduleApi.getSchedule(request);
        log.info("\u67e5\u8be2\u5f53\u65e5his\u533b\u751f\u6392\u73ed\u8fd4\u56de\u53c2\u6570:" + JsonUtil.convertObject((Object)gatewayResponse));
        if (gatewayResponse == null) {
            log.error("\u6302\u53f7\u533b\u751f\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            return new ArrayList<GetScheduleResItems>();
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u6302\u53f7\u533b\u751f\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            return new ArrayList<GetScheduleResItems>();
        }
        if (gatewayResponse.getData() == null) {
            log.error("\u6302\u53f7\u533b\u751f\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            return new ArrayList<GetScheduleResItems>();
        }
        List getScheduleResItemsList = ((GetScheduleResVO)gatewayResponse.getData()).getItems();
        if (CollectionUtils.isEmpty((Collection)getScheduleResItemsList)) {
            log.error("\u6302\u53f7\u533b\u751f\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u65e0\u6392\u73ed\u4fe1\u606f");
            return new ArrayList<GetScheduleResItems>();
        }
        return getScheduleResItemsList;
    }

    private List<GetScheduleResItems> getAppointSchedule(String startDate, String endDate, String deptCode, String hospitalCode) throws SyncHisScheduleException {
        GatewayRequest request = new GatewayRequest();
        GetScheduleReqVO scheduleReqVO = new GetScheduleReqVO();
        scheduleReqVO.setBgDate(DateUtils.getNextDayToString((String)startDate));
        scheduleReqVO.setEdDate(endDate);
        scheduleReqVO.setLocCode(deptCode);
        request.setOrganCode(hospitalCode);
        request.setKeyWord("getDocSchedule");
        request.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        request.setBody((Object)scheduleReqVO);
        log.info("\u67e5\u8be2his\u533b\u751f\u6392\u73ed\u8bf7\u6c42\u53c2\u6570:" + JsonUtil.convertObject((Object)request));
        GatewayResponse gatewayResponse = this.scheduleApi.getSchedule(request);
        log.info("\u67e5\u8be2his\u533b\u751f\u6392\u73ed\u8fd4\u56de\u53c2\u6570:" + JsonUtil.convertObject((Object)gatewayResponse));
        if (gatewayResponse == null) {
            log.error("\u6302\u53f7\u533b\u751f\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            return new ArrayList<GetScheduleResItems>();
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u6302\u53f7\u533b\u751f\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            return new ArrayList<GetScheduleResItems>();
        }
        if (gatewayResponse.getData() == null) {
            log.error("\u6302\u53f7\u533b\u751f\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            return new ArrayList<GetScheduleResItems>();
        }
        List getScheduleResItemsList = ((GetScheduleResVO)gatewayResponse.getData()).getItems();
        if (CollectionUtils.isEmpty((Collection)getScheduleResItemsList)) {
            log.error("\u6302\u53f7\u533b\u751f\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u65e0\u6392\u73ed\u4fe1\u606f");
            return new ArrayList<GetScheduleResItems>();
        }
        return getScheduleResItemsList;
    }
}

