/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.doctoruser.api.pojo.base.dto.DoctorBaseInfoDTO;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.wisdommedical.common.constant.ProPropertiesConstant;
import com.ebaiyihui.wisdommedical.pojo.vo.GetDoctorPositionInfoVo;
import com.ebaiyihui.wisdommedical.pojo.vo.repsvo.GetDoctorBaseInfoVo;
import com.ebaiyihui.wisdommedical.util.HttpKit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GetDoctorInfoUtil {
    private static final Logger log = LoggerFactory.getLogger(GetDoctorInfoUtil.class);
    @Autowired
    private ProPropertiesConstant constant;

    public DoctorBaseInfoDTO getDoctorInfo(Long doctorId, String organId) {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("doctorId", doctorId.toString());
            params.put("organId", organId);
            String body = HttpKit.get((String)this.constant.getGetDoctorInfoUrl(), params);
            BaseResponse response = (BaseResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)body), BaseResponse.class);
            log.info("\u3010\u67e5\u8be2\u533b\u751f\u57fa\u7840\u4fe1\u606f\u3011 getDoctorInfo -> \u8fd4\u56debaseResponse\uff1a" + response);
            if (!response.isSuccess()) {
                log.error("\u3010\u67e5\u8be2\u533b\u751f\u57fa\u7840\u4fe1\u606f\u3011 getDoctorInfo -> \u67e5\u8be2\u533b\u751f\u57fa\u7840\u4fe1\u606f err_code:{},mag:{}", (Object)response.getErrCode(), (Object)response.getMsg());
            }
            if (null == response.getData()) {
                log.error("\u3010\u67e5\u8be2\u533b\u751f\u57fa\u7840\u4fe1\u606f\u3011 getDoctorInfo -> \u8fd4\u56de\u6570\u636e\u4e3a\u7a7a");
            }
            DoctorBaseInfoDTO doctorBaseInfoDTO = (DoctorBaseInfoDTO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)response.getData()), DoctorBaseInfoDTO.class);
            log.info("\u3010\u67e5\u8be2\u533b\u751f\u57fa\u7840\u4fe1\u606f\u3011 getDoctorInfo -> " + doctorBaseInfoDTO);
            return doctorBaseInfoDTO;
        }
        catch (Exception e) {
            log.error("\u3010\u67e5\u8be2\u533b\u751f\u57fa\u7840\u4fe1\u606f\u3011 getDoctorInfo -> doctorService\u8bf7\u6c42\u51fa\u9519");
            return new DoctorBaseInfoDTO();
        }
    }

    public List<DoctorBaseInfoDTO> getDoctorInfoList(List<Long> doctorIdList, String organId) {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("doctorIdList", StringUtils.join((Object[])doctorIdList.toArray(), (String)","));
            params.put("organId", organId);
            String body = HttpKit.get((String)this.constant.getGetDoctorInfoListUrl(), params);
            BaseResponse response = (BaseResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)body), BaseResponse.class);
            log.info("\u3010\u67e5\u8be2\u533b\u751f\u57fa\u7840\u4fe1\u606f\u3011getDoctorInfoList -> \u8fd4\u56debaseResponse\uff1a" + response);
            if (!response.isSuccess()) {
                log.error("\u3010\u67e5\u8be2\u533b\u751f\u57fa\u7840\u4fe1\u606f\u3011getDoctorInfoList -> \u67e5\u8be2\u533b\u751f\u57fa\u7840\u4fe1\u606f err_code:{},msg:{}", (Object)response.getErrCode(), (Object)response.getMsg());
            }
            if (null == response.getData()) {
                log.error("\u3010\u67e5\u8be2\u533b\u751f\u57fa\u7840\u4fe1\u606f\u3011 getDoctorInfoList -> \u8fd4\u56de\u6570\u636e\u4e3a\u7a7a");
            }
            List list = JSONObject.parseArray((String)JSONObject.toJSONString((Object)response.getData()), DoctorBaseInfoDTO.class);
            log.info("\u3010\u67e5\u8be2\u533b\u751f\u57fa\u7840\u4fe1\u606f\u3011 getDoctorInfoList -> " + list);
            return list;
        }
        catch (Exception e) {
            log.error("\u3010\u67e5\u8be2\u533b\u751f\u57fa\u7840\u4fe1\u606f\u3011getDoctorInfoList -> doctorService\u8bf7\u6c42\u51fa\u9519");
            return new ArrayList<DoctorBaseInfoDTO>();
        }
    }

    public GetDoctorPositionInfoVo getDoctorInfo(Map<String, String> params) {
        try {
            String body = HttpKit.get((String)this.constant.getGetDoctorPositionInfo(), params);
            BaseResponse response = (BaseResponse)JSONObject.toJavaObject((JSON)JSON.parseObject((String)body), BaseResponse.class);
            log.info("\u3010\u67e5\u8be2\u533b\u751f\u57fa\u7840\u4fe1\u606f\u3011 getDoctorInfo -> \u8fd4\u56debaseResponse\uff1a" + response);
            if (!response.isSuccess()) {
                log.error("\u3010\u67e5\u8be2\u533b\u751f\u57fa\u7840\u4fe1\u606f\u3011 getDoctorInfo -> \u67e5\u8be2\u533b\u751f\u57fa\u7840\u4fe1\u606f err_code:{},mag:{}", (Object)response.getErrCode(), (Object)response.getMsg());
            }
            if (null == response.getData()) {
                log.error("\u3010\u67e5\u8be2\u533b\u751f\u57fa\u7840\u4fe1\u606f\u3011 getDoctorInfo -> \u8fd4\u56de\u6570\u636e\u4e3a\u7a7a");
            }
            GetDoctorPositionInfoVo getCardDetailByPmiUrlVo = (GetDoctorPositionInfoVo)JSONObject.parseObject((String)JSONObject.toJSONString((Object)response.getData()), GetDoctorPositionInfoVo.class);
            log.info("\u3010\u67e5\u8be2\u533b\u751f\u57fa\u7840\u4fe1\u606f\u3011 getDoctorInfo -> " + getCardDetailByPmiUrlVo);
            return getCardDetailByPmiUrlVo;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u3010\u67e5\u8be2\u533b\u751f\u57fa\u7840\u4fe1\u606f\u3011 getDoctorInfo -> doctorService\u8bf7\u6c42\u51fa\u9519");
            return null;
        }
    }

    public List<GetDoctorBaseInfoVo> getDoctorInfoList(Map<String, Object> params) {
        try {
            log.info("\u3010\u67e5\u8be2\u533b\u751f\u57fa\u7840\u4fe1\u606f\u3011getDoctorInfoList \uff1a " + this.constant.getFindDoctorInfoByEmplCode() + " -> \u5165\u53c2params\uff1a" + JSONObject.toJSONString(params));
            String body = HttpKit.jsonPost((String)this.constant.getFindDoctorInfoByEmplCode(), (String)JSONObject.toJSONString(params));
            BaseResponse response = (BaseResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)body), BaseResponse.class);
            log.info("\u3010\u67e5\u8be2\u533b\u751f\u57fa\u7840\u4fe1\u606f\u3011getDoctorInfoList -> \u8fd4\u56debaseResponse\uff1a" + response);
            if (!response.isSuccess()) {
                log.error("\u3010\u67e5\u8be2\u533b\u751f\u57fa\u7840\u4fe1\u606f\u3011getDoctorInfoList -> \u67e5\u8be2\u533b\u751f\u57fa\u7840\u4fe1\u606f err_code:{},msg:{}", (Object)response.getErrCode(), (Object)response.getMsg());
            }
            if (null == response.getData()) {
                log.error("\u3010\u67e5\u8be2\u533b\u751f\u57fa\u7840\u4fe1\u606f\u3011 getDoctorInfoList -> \u8fd4\u56de\u6570\u636e\u4e3a\u7a7a");
            }
            List list = JSONObject.parseArray((String)JSONObject.toJSONString((Object)response.getData()), GetDoctorBaseInfoVo.class);
            log.info("\u3010\u67e5\u8be2\u533b\u751f\u57fa\u7840\u4fe1\u606f\u3011 getDoctorInfoList -> " + list);
            return list;
        }
        catch (Exception e) {
            log.error("\u3010\u67e5\u8be2\u533b\u751f\u57fa\u7840\u4fe1\u606f\u3011getDoctorInfoList -> doctorService\u8bf7\u6c42\u51fa\u9519");
            return new ArrayList<GetDoctorBaseInfoVo>();
        }
    }
}

