/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.util;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.his.api.AppointApi;
import com.ebaiyihui.his.pojo.vo.appoint.AllPayReq;
import com.ebaiyihui.his.pojo.vo.appoint.AppointOrderStatusReq;
import com.ebaiyihui.his.pojo.vo.appoint.AppointOrderStatusRes;
import com.ebaiyihui.his.pojo.vo.appoint.PayReq;
import com.ebaiyihui.his.pojo.vo.base.GatewayRequest;
import com.ebaiyihui.his.pojo.vo.base.GatewayResponse;
import com.ebaiyihui.wisdommedical.common.constant.ProPropertiesConstant;
import com.ebaiyihui.wisdommedical.common.enums.BusinessTypeEnums;
import com.ebaiyihui.wisdommedical.mapper.BusinessResultMapper;
import com.ebaiyihui.wisdommedical.model.BusinessResultEntity;
import com.ebaiyihui.wisdommedical.util.SnowflakeIdWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PayUtil {
    private static final Logger log = LoggerFactory.getLogger(PayUtil.class);
    @Autowired
    private ProPropertiesConstant propertiesConstant;
    @Autowired
    private SnowflakeIdWorker snowflakeIdWorker;
    @Autowired
    private AppointApi appointApi;
    @Autowired
    private BusinessResultMapper businessResultMapper;

    public String weChatPay(PayReq payReq, String channelName) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        gatewayRequest.setBody((Object)payReq);
        gatewayRequest.setChannel(channelName);
        gatewayRequest.setChannelName(channelName);
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("PayReq");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        log.info("\u3010\u53d1\u8d77\u5fae\u4fe1\u652f\u4ed8\u3011\u8bf7\u6c42\u5165\u53c2\uff1a" + gatewayRequest);
        GatewayResponse gatewayResponse = this.appointApi.weChatPay(gatewayRequest);
        log.info("\u3010\u53d1\u8d77\u5fae\u4fe1\u652f\u4ed8\u3011\u8bf7\u6c42\u51fa\u53c2\uff1a" + gatewayResponse);
        if (gatewayResponse == null) {
            log.error("\u3010\u53d1\u8d77\u5fae\u4fe1\u652f\u4ed8\u3011comfirmPayNew -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            return null;
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u3010\u53d1\u8d77\u5fae\u4fe1\u652f\u4ed8\u3011comfirmPayNew -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            return null;
        }
        if (gatewayResponse.getData() == null) {
            log.error("\u3010\u53d1\u8d77\u5fae\u4fe1\u652f\u4ed8\u3011comfirmPayNew -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            return null;
        }
        return (String)gatewayResponse.getData();
    }

    public String toPay(AllPayReq payReq, String channelName) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        gatewayRequest.setBody((Object)payReq);
        gatewayRequest.setChannel(channelName);
        gatewayRequest.setChannelName(channelName);
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("PayReq");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        log.info("\u3010\u53d1\u8d77\u652f\u4ed8\u5b9d\u652f\u4ed8\u3011\u8bf7\u6c42\u5165\u53c2\uff1a" + gatewayRequest);
        BusinessResultEntity businessResultEntity = new BusinessResultEntity();
        businessResultEntity.setChannelCode(channelName);
        businessResultEntity.setBusinessType(new Byte(BusinessTypeEnums.PAI_CONFIRM.getValue().toString()));
        businessResultEntity.setHisRequest(JSON.toJSONString((Object)gatewayRequest));
        this.businessResultMapper.insertSelective(businessResultEntity);
        GatewayResponse gatewayResponse = this.appointApi.allPay(gatewayRequest);
        businessResultEntity.setErrorCode(gatewayResponse.getErrCode());
        businessResultEntity.setErrorMsg(gatewayResponse.getMsg());
        businessResultEntity.setHisResponse(JSON.toJSONString((Object)gatewayResponse));
        businessResultEntity.setTransationId(gatewayResponse.getTransactionId());
        businessResultEntity.setStatus(new Byte("0"));
        this.businessResultMapper.updateByPrimaryKeySelective(businessResultEntity);
        log.info("\u3010\u53d1\u8d77\u652f\u4ed8\u5b9d\u652f\u4ed8\u3011\u8bf7\u6c42\u51fa\u53c2\uff1a" + gatewayResponse);
        if (gatewayResponse == null) {
            log.error("\u3010\u53d1\u8d77\u652f\u4ed8\u5b9d\u652f\u4ed8\u3011comfirmPayNew -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            return null;
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u3010\u53d1\u8d77\u652f\u4ed8\u5b9d\u652f\u4ed8\u3011comfirmPayNew -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            return null;
        }
        if (gatewayResponse.getData() == null) {
            log.error("\u3010\u53d1\u8d77\u652f\u4ed8\u5b9d\u652f\u4ed8\u3011comfirmPayNew -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            return null;
        }
        return (String)gatewayResponse.getData();
    }

    public AppointOrderStatusRes orderStatusQuery(String hisTradeNo, String channel) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        AppointOrderStatusReq appointOrderStatusReq = new AppointOrderStatusReq();
        appointOrderStatusReq.setHisTradeNo(hisTradeNo);
        gatewayRequest.setBody((Object)appointOrderStatusReq);
        gatewayRequest.setChannel(channel);
        gatewayRequest.setChannelName(channel);
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("AppointOrderStatusReq");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        log.info("\u3010his\u67e5\u8be2\u652f\u4ed8\u8ba2\u5355\u72b6\u6001\u3011\u8bf7\u6c42\u5165\u53c2\uff1a" + gatewayRequest);
        GatewayResponse gatewayResponse = this.appointApi.orderStatusQuery(gatewayRequest);
        log.info("\u3010his\u67e5\u8be2\u652f\u4ed8\u8ba2\u5355\u72b6\u6001\u3011\u8bf7\u6c42\u51fa\u53c2\uff1a" + gatewayResponse);
        if (gatewayResponse == null) {
            log.error("\u3010his\u67e5\u8be2\u652f\u4ed8\u8ba2\u5355\u72b6\u6001\u3011orderStatusQuery -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            return null;
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u3010his\u67e5\u8be2\u652f\u4ed8\u8ba2\u5355\u72b6\u6001\u3011orderStatusQuery -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            return null;
        }
        if (gatewayResponse.getData() == null) {
            log.error("\u3010his\u67e5\u8be2\u652f\u4ed8\u8ba2\u5355\u72b6\u6001\u3011orderStatusQuery -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            return null;
        }
        return (AppointOrderStatusRes)gatewayResponse.getData();
    }
}

