/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.util;

import java.io.UnsupportedEncodingException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class RSASign {
    private static final String CHARSET = "UTF-8";
    private static final String SIGN_TYPE_RSA = "RSA";
    private static final String SIGN_ALGORITHMS = "SHA1WithRSA";
    private static final String SIGN_KEY = "rsaSign";

    public static String sign(Map<String, Object> params, String privateKey) throws Exception {
        Assert.isTrue((!CollectionUtils.isEmpty(params) ? 1 : 0) != 0, (String)"params is required");
        Assert.notNull((Object)privateKey, (String)"privateKey is required");
        String signContent = RSASign.signContent(params);
        Signature signature = Signature.getInstance("SHA1WithRSA");
        signature.initSign(RSASign.getPrivateKeyPKCS8((String)privateKey));
        signature.update(signContent.getBytes("UTF-8"));
        byte[] signed = signature.sign();
        return new String(Base64.getEncoder().encode(signed));
    }

    public static boolean checkSign(Map<String, Object> params, String publicKey) throws Exception {
        Assert.isTrue((!CollectionUtils.isEmpty(params) ? 1 : 0) != 0, (String)"params is required");
        Assert.notNull((Object)publicKey, (String)"publicKey is required");
        String content = RSASign.signContent(params);
        String rsaSign = params.get("rsaSign").toString();
        Signature signature = Signature.getInstance("SHA1WithRSA");
        signature.initVerify(RSASign.getPublicKeyX509((String)publicKey));
        signature.update(content.getBytes("UTF-8"));
        return signature.verify(Base64.getDecoder().decode(rsaSign.getBytes("UTF-8")));
    }

    public static String signContent(Map<String, Object> params) throws UnsupportedEncodingException {
        TreeMap sortedParams = new TreeMap(Comparator.naturalOrder());
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            String key = entry.getKey();
            if (!RSASign.legalKey((String)key)) continue;
            sortedParams.put(key, entry.getValue().toString());
        }
        StringBuilder builder = new StringBuilder();
        if (!CollectionUtils.isEmpty(sortedParams)) {
            for (Map.Entry entry : sortedParams.entrySet()) {
                builder.append((String)entry.getKey());
                builder.append("=");
                builder.append((String)entry.getValue());
                builder.append("&");
            }
            builder.deleteCharAt(builder.length() - 1);
        }
        return builder.toString();
    }

    private static PublicKey getPublicKeyX509(String publicKey) throws InvalidKeySpecException, NoSuchAlgorithmException, UnsupportedEncodingException {
        if (StringUtils.isEmpty((Object)publicKey)) {
            return null;
        }
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        byte[] decodedKey = Base64.getDecoder().decode(publicKey.getBytes("UTF-8"));
        return keyFactory.generatePublic(new X509EncodedKeySpec(decodedKey));
    }

    private static PrivateKey getPrivateKeyPKCS8(String privateKey) throws Exception {
        if (StringUtils.isEmpty((Object)privateKey)) {
            return null;
        }
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        byte[] decodedKey = Base64.getDecoder().decode(privateKey.getBytes("UTF-8"));
        return keyFactory.generatePrivate(new PKCS8EncodedKeySpec(decodedKey));
    }

    private static boolean legalKey(String key) {
        return StringUtils.hasText((String)key) && !"rsaSign".equalsIgnoreCase(key);
    }
}

