/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.util.wx;

import com.ebaiyihui.wisdommedical.util.wx.WXPayConstants;
import com.ebaiyihui.wisdommedical.util.wx.WXPayXmlUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * Exception performing whole class analysis ignored.
 */
public class WXPayUtil {
    private static final String SYMBOLS = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final Random RANDOM = new SecureRandom();

    public static Map<String, String> xmlToMap(String strXML) throws Exception {
        try {
            HashMap<String, String> data = new HashMap<String, String>();
            DocumentBuilder documentBuilder = WXPayXmlUtil.newDocumentBuilder();
            ByteArrayInputStream stream = new ByteArrayInputStream(strXML.getBytes("UTF-8"));
            Document doc = documentBuilder.parse(stream);
            doc.getDocumentElement().normalize();
            NodeList nodeList = doc.getDocumentElement().getChildNodes();
            for (int idx = 0; idx < nodeList.getLength(); ++idx) {
                Node node = nodeList.item(idx);
                if (node.getNodeType() != 1) continue;
                Element element = (Element)node;
                data.put(element.getNodeName(), element.getTextContent());
            }
            try {
                ((InputStream)stream).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return data;
        }
        catch (Exception ex) {
            WXPayUtil.getLogger().warn("Invalid XML, can not convert to map. Error message: {}. XML content: {}", (Object)ex.getMessage(), (Object)strXML);
            throw ex;
        }
    }

    public static String mapToXml(Map<String, String> data) throws Exception {
        Document document = WXPayXmlUtil.newDocument();
        Element root = document.createElement("xml");
        document.appendChild(root);
        for (String key : data.keySet()) {
            String value = data.get(key);
            if (value == null) {
                value = "";
            }
            value = value.trim();
            Element filed = document.createElement(key);
            filed.appendChild(document.createTextNode(value));
            root.appendChild(filed);
        }
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        DOMSource source = new DOMSource(document);
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("indent", "yes");
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        transformer.transform(source, result);
        String output = writer.getBuffer().toString().replace("\n", "");
        try {
            writer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return output;
    }

    public static String generateSignedXml(Map<String, String> data, String key) throws Exception {
        return WXPayUtil.generateSignedXml(data, (String)key, (WXPayConstants.SignType)WXPayConstants.SignType.MD5);
    }

    public static String generateSignedXml(Map<String, String> data, String key, WXPayConstants.SignType signType) throws Exception {
        String sign = WXPayUtil.generateSignature(data, (String)key, (WXPayConstants.SignType)signType);
        data.put("sign", sign);
        return WXPayUtil.mapToXml(data);
    }

    public static boolean isSignatureValid(String xmlStr, String key) throws Exception {
        Map data = WXPayUtil.xmlToMap((String)xmlStr);
        if (!data.containsKey("sign")) {
            return false;
        }
        String sign = (String)data.get("sign");
        return WXPayUtil.generateSignature((Map)data, (String)key).equals(sign);
    }

    public static void main(String[] args) throws Exception {
        String s = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\\n<xml>\\n<nonce_str>2024-06-14</nonce_str>\\n<result_code>FAIL</result_code>\\n<return_code>FAIL</return_code>\\n<sign>65660706D92F1A46354B998BA8E8AABF</sign>\\n</xml>\\n";
        String s1 = s.replace("\\n", "");
        boolean b = WXPayUtil.isSignatureValid((String)s1, (String)"fc6541f3f8f3f0243b4e443e81c2a925");
        System.out.println(b);
    }

    public static boolean isSignatureValid(Map<String, String> data, String key) throws Exception {
        return WXPayUtil.isSignatureValid(data, (String)key, (WXPayConstants.SignType)WXPayConstants.SignType.MD5);
    }

    public static boolean isSignatureValid(Map<String, String> data, String key, WXPayConstants.SignType signType) throws Exception {
        if (!data.containsKey("sign")) {
            return false;
        }
        String sign = data.get("sign");
        return WXPayUtil.generateSignature(data, (String)key, (WXPayConstants.SignType)signType).equals(sign);
    }

    public static String generateSignature(Map<String, String> data, String key) throws Exception {
        return WXPayUtil.generateSignature(data, (String)key, (WXPayConstants.SignType)WXPayConstants.SignType.MD5);
    }

    public static String generateSignature(Map<String, String> data, String key, WXPayConstants.SignType signType) throws Exception {
        Set<String> keySet = data.keySet();
        Object[] keyArray = keySet.toArray(new String[keySet.size()]);
        Arrays.sort(keyArray);
        StringBuilder sb = new StringBuilder();
        for (Object k : keyArray) {
            if (((String)k).equals("sign") || data.get(k).trim().length() <= 0) continue;
            sb.append((String)k).append("=").append(data.get(k).trim()).append("&");
        }
        sb.append("key=").append(key);
        if (WXPayConstants.SignType.MD5.equals((Object)signType)) {
            return WXPayUtil.MD5((String)sb.toString()).toUpperCase();
        }
        if (WXPayConstants.SignType.HMACSHA256.equals((Object)signType)) {
            return WXPayUtil.HMACSHA256((String)sb.toString(), (String)key);
        }
        throw new Exception(String.format("Invalid sign_type: %s", signType));
    }

    public static String generateNonceStr() {
        char[] nonceChars = new char[32];
        for (int index = 0; index < nonceChars.length; ++index) {
            nonceChars[index] = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".charAt(RANDOM.nextInt("0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".length()));
        }
        return new String(nonceChars);
    }

    public static String MD5(String data) throws Exception {
        MessageDigest md = MessageDigest.getInstance("MD5");
        byte[] array = md.digest(data.getBytes("UTF-8"));
        StringBuilder sb = new StringBuilder();
        for (byte item : array) {
            sb.append(Integer.toHexString(item & 0xFF | 0x100).substring(1, 3));
        }
        return sb.toString().toUpperCase();
    }

    public static String HMACSHA256(String data, String key) throws Exception {
        Mac sha256_HMAC = Mac.getInstance("HmacSHA256");
        SecretKeySpec secret_key = new SecretKeySpec(key.getBytes("UTF-8"), "HmacSHA256");
        sha256_HMAC.init(secret_key);
        byte[] array = sha256_HMAC.doFinal(data.getBytes("UTF-8"));
        StringBuilder sb = new StringBuilder();
        for (byte item : array) {
            sb.append(Integer.toHexString(item & 0xFF | 0x100).substring(1, 3));
        }
        return sb.toString().toUpperCase();
    }

    public static Logger getLogger() {
        Logger logger = LoggerFactory.getLogger((String)"wxpay java sdk");
        return logger;
    }

    public static long getCurrentTimestamp() {
        return System.currentTimeMillis() / 1000L;
    }

    public static long getCurrentTimestampMs() {
        return System.currentTimeMillis();
    }

    public static Map<String, String> object2Map(Object obj) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        if (obj == null) {
            return map;
        }
        Class<?> clazz = obj.getClass();
        Field[] fields = clazz.getDeclaredFields();
        try {
            for (Field field : fields) {
                field.setAccessible(true);
                if (field.get(obj) == null) continue;
                map.put(field.getName(), String.valueOf(field.get(obj)));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    public static Object map2Object(Map<String, Object> map, Class<?> clazz) {
        if (map == null) {
            return null;
        }
        Object obj = null;
        try {
            Field[] fields;
            obj = clazz.newInstance();
            for (Field field : fields = obj.getClass().getDeclaredFields()) {
                int mod = field.getModifiers();
                if (Modifier.isStatic(mod) || Modifier.isFinal(mod)) continue;
                field.setAccessible(true);
                field.set(obj, map.get(field.getName()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return obj;
    }
}

