/*
 * Decompiled with CFR 0.152.
 */
package com.byh.auth.config.security;

import com.byh.auth.config.security.AccessDeny;
import com.byh.auth.config.security.AuthenticationEnryPoint;
import com.byh.auth.config.security.LoginFaildHandler;
import com.byh.auth.config.security.LoginSuccessHandler;
import com.byh.auth.config.security.MyLogoutHandler;
import com.byh.auth.config.security.MyLogoutSuccessHandler;
import com.byh.auth.constant.PatternConstant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.annotation.authentication.configuration.AuthenticationConfiguration;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;

@Configuration
@EnableWebSecurity
@EnableGlobalMethodSecurity(prePostEnabled=true, securedEnabled=true)
public class SecurityConfig
extends WebSecurityConfigurerAdapter {
    @Autowired
    private LoginSuccessHandler loginSuccessHandler;
    @Autowired
    private LoginFaildHandler loginFaildHandler;
    @Autowired
    private MyLogoutSuccessHandler myLogoutSuccessHandler;
    @Autowired
    private MyLogoutHandler myLogoutHandler;
    @Autowired
    private AuthenticationEnryPoint authenticationEnryPoint;
    @Autowired
    private AccessDeny accessDeny;
    private String[] urlArray = PatternConstant.SECURITY_PATTERN_URL;

    @Bean
    public PasswordEncoder passwordEncoder() {
        return new BCryptPasswordEncoder();
    }

    protected void configure(HttpSecurity http) throws Exception {
        ((HttpSecurity)((HttpSecurity)((FormLoginConfigurer)((FormLoginConfigurer)((HttpSecurity)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().antMatchers(this.urlArray)).permitAll().anyRequest()).authenticated().and()).logout().permitAll().and()).formLogin().successHandler((AuthenticationSuccessHandler)this.loginSuccessHandler)).failureHandler((AuthenticationFailureHandler)this.loginFaildHandler)).and()).logout().logoutUrl("/user/logout").addLogoutHandler((LogoutHandler)this.myLogoutHandler).logoutSuccessHandler((LogoutSuccessHandler)this.myLogoutSuccessHandler).and()).exceptionHandling().accessDeniedHandler((AccessDeniedHandler)this.accessDeny).authenticationEntryPoint((AuthenticationEntryPoint)this.authenticationEnryPoint);
        http.sessionManagement().sessionFixation().changeSessionId().disable();
        http.csrf().disable();
        http.cors();
    }

    @Bean
    public AuthenticationManager authenticationManager(AuthenticationConfiguration authenticationConfiguration) throws Exception {
        return authenticationConfiguration.getAuthenticationManager();
    }
}

