/*
 * Decompiled with CFR 0.152.
 */
package com.byh.auth.controller;

import com.byh.auth.util.ResponseData;
import java.security.Principal;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.oauth2.common.DefaultOAuth2AccessToken;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.provider.endpoint.TokenEndpoint;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/oauth"})
public class OauthController {
    @Autowired
    private TokenEndpoint tokenEndpoint;

    @GetMapping(value={"/token"})
    public ResponseData getAccessToken(Principal principal, @RequestParam Map<String, String> parameters) throws HttpRequestMethodNotSupportedException {
        return this.custom((OAuth2AccessToken)this.tokenEndpoint.getAccessToken(principal, parameters).getBody(), parameters);
    }

    @PostMapping(value={"/token"})
    public ResponseData postAccessToken(HttpServletRequest request, Principal principal, @RequestParam Map<String, String> parameters) throws HttpRequestMethodNotSupportedException {
        return this.custom((OAuth2AccessToken)this.tokenEndpoint.postAccessToken(principal, parameters).getBody(), parameters);
    }

    private ResponseData custom(OAuth2AccessToken accessToken, Map<String, String> parameters) {
        DefaultOAuth2AccessToken token = (DefaultOAuth2AccessToken)accessToken;
        LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>(token.getAdditionalInformation());
        data.put("access_token", token.getValue());
        if (token.getRefreshToken() != null) {
            data.put("refresh_token", token.getRefreshToken().getValue());
        }
        data.put("tokenType", token.getTokenType());
        data.put("expire_in", token.getExpiresIn());
        data.put("scope", token.getScope());
        return ResponseData.success(data);
    }
}

