/*
 * Decompiled with CFR 0.152.
 */
package com.byh.auth.exception;

import com.byh.auth.exception.BusinessException;
import com.byh.auth.exception.SecurityException;
import com.byh.auth.util.ResponseData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

@ControllerAdvice
public class ExceptionAdvice {
    public static Logger logger = LoggerFactory.getLogger(ExceptionAdvice.class);

    @ExceptionHandler(value={BusinessException.class})
    @ResponseBody
    public ResponseData exceptionHandler(BusinessException businessException, Exception e) {
        e.printStackTrace();
        if (null == businessException.getErrorCode() || "".equals(businessException.getErrorCode())) {
            return ResponseData.error((String)"400", (String)businessException.getMessage());
        }
        return ResponseData.error((String)businessException.getErrorCode(), (String)businessException.getMessage());
    }

    @ExceptionHandler(value={SecurityException.class})
    @ResponseBody
    public ResponseData securityHandler(SecurityException securityException, Exception e) {
        e.printStackTrace();
        if (null == securityException.getErrorCode() || "".equals(securityException.getErrorCode())) {
            return ResponseData.error((String)"400", (String)securityException.getMessage());
        }
        return ResponseData.error((String)securityException.getErrorCode(), (String)securityException.getMessage());
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    @ResponseBody
    public ResponseData methodExceptionHandler(MethodArgumentNotValidException exception) {
        FieldError field = exception.getFieldError();
        exception.printStackTrace();
        return ResponseData.error((String)ResponseData.ResponseEnum.BAD_REQUEST.getCode(), (String)("\u5bf9\u8c61\u3010" + field.getObjectName() + "\u3011\u62a5\u9519\uff1a" + field.getDefaultMessage())).data((Object)Boolean.FALSE);
    }
}

