/*
 * Decompiled with CFR 0.152.
 */
package com.byh.auth.exception;

import com.byh.auth.entity.dto.sysException.SysExceptionSaveDto;
import com.byh.auth.exception.BusinessException;
import com.byh.auth.exception.SecurityException;
import com.byh.auth.service.SysExceptionService;
import com.byh.auth.util.CommonRequest;
import com.byh.auth.util.ResponseData;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

@ControllerAdvice
public class ExceptionAdvice {
    public static Logger logger = LoggerFactory.getLogger(ExceptionAdvice.class);
    @Autowired
    private HttpServletRequest request;
    @Autowired
    private SysExceptionService sysExceptionService;
    @Autowired
    private CommonRequest commonRequest;

    @ExceptionHandler(value={BusinessException.class})
    @ResponseBody
    public ResponseData exceptionHandler(BusinessException businessException, Exception e) {
        e.printStackTrace();
        if (null == businessException.getErrorCode() || "".equals(businessException.getErrorCode())) {
            this.assemblyObject(ResponseData.ResponseEnum.BAD_REQUEST.getCode(), businessException.getMessage());
            return ResponseData.error((String)"400", (String)businessException.getMessage());
        }
        this.assemblyObject(businessException.getErrorCode(), businessException.getMessage());
        return ResponseData.error((String)businessException.getErrorCode(), (String)businessException.getMessage());
    }

    @ExceptionHandler(value={SecurityException.class})
    @ResponseBody
    public ResponseData securityHandler(SecurityException securityException, Exception e) {
        e.printStackTrace();
        if (null == securityException.getErrorCode() || "".equals(securityException.getErrorCode())) {
            this.assemblyObject(ResponseData.ResponseEnum.BAD_REQUEST.getCode(), securityException.getMessage());
            return ResponseData.error((String)ResponseData.ResponseEnum.BAD_REQUEST.getCode(), (String)securityException.getMessage());
        }
        this.assemblyObject(securityException.getErrorCode(), securityException.getMessage());
        return ResponseData.error((String)securityException.getErrorCode(), (String)securityException.getMessage());
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    @ResponseBody
    public ResponseData methodExceptionHandler(MethodArgumentNotValidException exception) {
        FieldError field = exception.getFieldError();
        exception.printStackTrace();
        String msg = "\u5bf9\u8c61\u3010" + field.getObjectName() + "\u3011\u62a5\u9519\uff1a" + field.getDefaultMessage();
        this.assemblyObject(ResponseData.ResponseEnum.BAD_REQUEST.getCode(), msg);
        return ResponseData.error((String)ResponseData.ResponseEnum.BAD_REQUEST.getCode(), (String)msg).data((Object)Boolean.FALSE);
    }

    private void assemblyObject(String code, String message) {
        SysExceptionSaveDto dto = new SysExceptionSaveDto();
        dto.setTenantId(this.commonRequest.getTenant());
        dto.setCreateId(this.commonRequest.getUserId().toString());
        dto.setCode(code);
        dto.setMessage(message);
        dto.setUrl(this.request.getRequestURI());
        dto.setMethod(this.request.getMethod());
        dto.setParam(this.request.getQueryString());
        dto.setRemoteUser(this.request.getRemoteUser());
        this.sysExceptionService.sysExceptionSave(dto);
    }

    private void assemblyObject(SysExceptionSaveDto dto) {
        dto.setTenantId(this.commonRequest.getTenant());
        dto.setCreateId(this.commonRequest.getUserId().toString());
        dto.setUrl(this.request.getRequestURI());
        dto.setMethod(this.request.getMethod());
        dto.setParam(this.request.getQueryString());
        dto.setParam(this.request.getQueryString());
        this.sysExceptionService.sysExceptionSave(dto);
    }
}

