/*
 * Decompiled with CFR 0.152.
 */
package com.byh.config;

import com.byh.config.RedisConfiguration;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.annotation.CachingConfigurerSupport;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.cache.interceptor.CacheErrorHandler;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

@Configuration
@EnableCaching
public class RedisConfiguration
extends CachingConfigurerSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedisConfiguration.class);
    @Value(value="${spring.redis.host}")
    private String host;
    @Value(value="${spring.redis.password}")
    private String password;
    @Value(value="${spring.redis.port}")
    private int port;
    @Value(value="${spring.redis.timeout}")
    private int timeout;
    @Value(value="${spring.redis.jedis.pool.max-idle}")
    private int maxIdle;
    @Value(value="${spring.redis.jedis.pool.max-wait}")
    private long maxWaitMillis;
    @Value(value="${spring.redis.jedis.pool.max-active}")
    private int maxActive;
    @Value(value="${spring.redis.jedis.pool.min-idle}")
    private int minIdle;
    @Autowired
    private JedisPool jedisPool;

    @Bean
    public CacheErrorHandler errorHandler() {
        LOGGER.info("\u521d\u59cb\u5316 -> [{}]", (Object)"Redis CacheErrorHandler");
        1 cacheErrorHandler = new /* Unavailable Anonymous Inner Class!! */;
        return cacheErrorHandler;
    }

    @Bean
    public synchronized JedisPool redisPoolFactory() {
        if (this.jedisPool == null) {
            LOGGER.info("JedisPool init successful\uff0chost -> [{}]\uff1bport -> [{}]", (Object)this.host, (Object)this.port);
            JedisPoolConfig jedisPoolConfig = new JedisPoolConfig();
            jedisPoolConfig.setMaxIdle(this.maxIdle);
            jedisPoolConfig.setMaxWaitMillis(this.maxWaitMillis);
            jedisPoolConfig.setMinIdle(this.minIdle);
            jedisPoolConfig.setMaxTotal(this.maxActive);
            this.jedisPool = new JedisPool((GenericObjectPoolConfig)jedisPoolConfig, this.host, this.port, this.timeout, this.password);
        }
        return this.jedisPool;
    }

    static /* synthetic */ Logger access$000() {
        return LOGGER;
    }
}

