/*
 * Decompiled with CFR 0.152.
 */
package com.byh.controller.referral;

import com.byh.common.ResultInfo;
import com.byh.controller.BaseController;
import com.byh.enums.ReturnCodeEnum;
import com.byh.pojo.entity.patient.PatientCaseInfoEntity;
import com.byh.pojo.entity.referral.CaseReferralEntity;
import com.byh.service.referral.CaseReferralService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/case_referral"})
@Api(tags={"\u8f6c\u8bca\u75c5\u5386\u9644\u4ef6\u4fe1\u606f"})
public class CaseReferralController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(CaseReferralController.class);
    @Autowired
    private CaseReferralService caseReferralService;

    @ApiOperation(value="\u6dfb\u52a0\u8f6c\u8bca\u75c5\u5386")
    @PostMapping(value={"/save_case_referral"})
    public ResultInfo saveCaseReferral(@RequestBody CaseReferralEntity caseReferralEntity) {
        int insert = this.caseReferralService.saveCaseReferral(caseReferralEntity);
        if (insert == 0) {
            return this.returnFailure(ReturnCodeEnum.FAILURE.getDisplay());
        }
        return this.returnSucceed(ReturnCodeEnum.SUCCEED.getDisplay());
    }

    @ApiOperation(value="\u6279\u91cf\u6dfb\u52a0\u8f6c\u8bca\u75c5\u5386")
    @PostMapping(value={"/batch_save_case"})
    public ResultInfo batchSaveCaseReferral(@RequestBody List<CaseReferralEntity> caseList) {
        try {
            this.caseReferralService.batchSaveCaseReferral(caseList);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            return this.returnFailure(ReturnCodeEnum.FAILURE.getDisplay());
        }
        return this.returnSucceed(ReturnCodeEnum.SUCCEED.getDisplay());
    }

    @ApiOperation(value="\u67e5\u8be2\u8f6c\u8bca\u75c5\u5386\u9644\u4ef6\u96c6\u5408")
    @PostMapping(value={"/get_case_referral_list"})
    public ResultInfo<List<PatientCaseInfoEntity>> getCaseReferralList(@RequestParam(value="referralId") Long referralId) {
        List list = this.caseReferralService.getCaseReferralList(referralId);
        return this.returnSucceed((Object)list, ReturnCodeEnum.SUCCEED.getDisplay());
    }

    @ApiOperation(value="\u5220\u9664\u8f6c\u8bca\u75c5\u5386\u9644\u4ef6")
    @PostMapping(value={"/delete_case_referral"})
    public ResultInfo deleteCaseReferral(@RequestParam(value="referralId") Long referralId) {
        try {
            this.caseReferralService.deleteCaseReferral(referralId);
        }
        catch (Exception e) {
            return this.returnFailure(ReturnCodeEnum.FAILURE.getDisplay());
        }
        return this.returnSucceed(ReturnCodeEnum.SUCCEED.getDisplay());
    }
}

