/*
 * Decompiled with CFR 0.152.
 */
package com.byh.controller.referral;

import com.byh.controller.BaseController;
import com.byh.pojo.entity.referral.ReferralEntity;
import com.byh.service.referral.ReferralService;
import com.byh.util.FileUtils;
import com.byh.util.WordUtils;
import com.byh.util.ZipUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/referral/export"})
@Api(tags={"\u8f6c\u8bca\u5bfc\u51fazip"})
public class ExportWordController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(ExportWordController.class);
    @Autowired
    private ReferralService referralService;

    @ApiOperation(value="\u8f6c\u8bca\u5355\u5bfc\u51fa")
    @GetMapping(value={"zip"})
    public void exportWord(@RequestParam(value="ids") List<Long> ids, HttpServletResponse response) {
        log.info(ids.toString());
        List referralEntities = this.referralService.getByIds(ids);
        log.info(referralEntities.toString());
        if (referralEntities.size() == 0) {
            return;
        }
        String path = this.getClass().getClassLoader().getResource("application.yml").getPath();
        String zipPath = FileUtils.getPath((String)path, (String)"zip/");
        String wordPath = FileUtils.getPath((String)path, (String)"word/");
        for (ReferralEntity referralEntity : referralEntities) {
            WordUtils.saveWord((ReferralEntity)referralEntity, (String)wordPath);
        }
        ZipUtils.saveZip((String)wordPath, (String)zipPath, (String)DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd_HHmmssSSS"), (HttpServletResponse)response);
    }
}

