/*
 * Decompiled with CFR 0.152.
 */
package com.byh.controller.referral;

import com.byh.common.ResultInfo;
import com.byh.controller.BaseController;
import com.byh.enums.ReturnCodeEnum;
import com.byh.pojo.entity.patient.PatientOtherInfoEntity;
import com.byh.pojo.entity.referral.OtherInfoReferralEntity;
import com.byh.service.referral.OtherInfoReferralService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/other_info_referral"})
@Api(tags={"\u5176\u4ed6\u9644\u4ef6\u4fe1\u606f"})
public class OtherInfoReferralController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(OtherInfoReferralController.class);
    @Autowired
    private OtherInfoReferralService otherInfoReferralService;

    @ApiOperation(value="\u6dfb\u52a0\u5176\u4ed6\u9644\u4ef6\u4fe1\u606f")
    @PostMapping(value={"/save_other_info"})
    public ResultInfo saveOtherInfoReferral(@RequestBody OtherInfoReferralEntity otherInfoReferral) {
        int insert = this.otherInfoReferralService.saveOtherInfoReferral(otherInfoReferral);
        if (insert == 0) {
            return this.returnFailure(ReturnCodeEnum.FAILURE.getDisplay());
        }
        return this.returnSucceed(ReturnCodeEnum.SUCCEED.getDisplay());
    }

    @ApiOperation(value="\u6279\u91cf\u6dfb\u52a0\u5176\u4ed6\u9644\u4ef6\u4fe1\u606f")
    @PostMapping(value={"/batch_save_other_info"})
    public ResultInfo batchSaveOtherInfo(@RequestBody List<OtherInfoReferralEntity> infoList) {
        try {
            this.otherInfoReferralService.batchSaveOtherInfo(infoList);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            return this.returnFailure(ReturnCodeEnum.FAILURE.getDisplay());
        }
        return this.returnSucceed(ReturnCodeEnum.SUCCEED.getDisplay());
    }

    @ApiOperation(value="\u67e5\u8be2\u5176\u4ed6\u4fe1\u606f\u9644\u4ef6\u96c6\u5408")
    @GetMapping(value={"/get_other_info_list"})
    public ResultInfo<List<PatientOtherInfoEntity>> getOtherInfoList(@RequestParam(value="referralId") Long referralId, @RequestParam(value="type") Integer type) {
        List infoList = this.otherInfoReferralService.getOtherInfoList(referralId, type);
        return this.returnSucceed((Object)infoList, ReturnCodeEnum.SUCCEED.getDisplay());
    }

    @ApiOperation(value="\u5220\u9664\u8f6c\u8bca\u5176\u4ed6\u4fe1\u606f\u9644\u4ef6")
    @PostMapping(value={"/delete_other_info"})
    public ResultInfo deleteOtherInfo(@RequestParam(value="referralId") Long referralId, @RequestParam(value="type") Integer type) {
        try {
            this.otherInfoReferralService.deleteOtherInfo(referralId, type);
        }
        catch (Exception e) {
            return this.returnFailure(ReturnCodeEnum.FAILURE.getDisplay());
        }
        return this.returnSucceed(ReturnCodeEnum.SUCCEED.getDisplay());
    }
}

