/*
 * Decompiled with CFR 0.152.
 */
package com.byh.controller.referral;

import com.byh.common.PageResult;
import com.byh.common.ResultInfo;
import com.byh.controller.BaseController;
import com.byh.enums.ReturnCodeEnum;
import com.byh.pojo.vo.referral.ReferraVerifyVo;
import com.byh.pojo.vo.referral.ReferralDetailListVo;
import com.byh.pojo.vo.referral.ReferralDraftVo;
import com.byh.pojo.vo.referral.ReferralPageParamVo;
import com.byh.pojo.vo.referral.ReferralPageVo;
import com.byh.pojo.vo.referral.ReferralSaveAllVo;
import com.byh.service.referral.ReferralService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u53cc\u5411\u8f6c\u8bca"})
@RestController
@RequestMapping(value={"/api/v1/referral"})
public class ReferralController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(ReferralController.class);
    @Autowired
    private ReferralService referralService;

    @ApiOperation(value="\u63a5\u6536\u533b\u9662\u5ba1\u6838")
    @PostMapping(value={"/verify"})
    public ResultInfo referralVerify(@RequestBody ReferraVerifyVo referraVerifyVo) {
        int result = 0;
        try {
            result = this.referralService.verifyReferral(referraVerifyVo);
            if (result > 0) {
                return this.returnSucceed(ReturnCodeEnum.SUCCEED.getDisplay());
            }
            return this.returnFailure(ReturnCodeEnum.FAILURE.getDisplay());
        }
        catch (Exception e) {
            return this.returnFailure(e.getMessage());
        }
    }

    @ApiOperation(value="\u65b0\u589e\u53cc\u5411\u8f6c\u8bca")
    @PostMapping(value={"/savenew"})
    public ResultInfo saveReferral(@RequestBody ReferralSaveAllVo referralSaveAllVo) {
        try {
            this.referralService.save(referralSaveAllVo);
        }
        catch (Exception e) {
            return this.returnFailure(e.getMessage());
        }
        return this.returnSucceed(ReturnCodeEnum.SUCCEED.getDisplay());
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u8f6c\u5165\u672c\u9662\u53cc\u5411\u8f6c\u8bca\u8bb0\u5f55")
    @GetMapping(value={"/referralpage"})
    public ResultInfo<PageResult<List<ReferralPageVo>>> pageReferralByHospitalId(@RequestParam(value="pageNo") Integer pageNo, @RequestParam(value="pageSize") Integer pageSize, @RequestParam(value="findType") Integer findType, @RequestParam(value="hospitalId") Long hospitalId, ReferralPageParamVo referralPageParamVo) {
        PageResult referralPagePar = this.referralService.pageReferralByHospitalId(pageNo, pageSize, findType, hospitalId, referralPageParamVo);
        return this.returnSucceed((Object)referralPagePar, ReturnCodeEnum.SUCCEED.getDisplay());
    }

    @ApiOperation(value="\u53cc\u5411\u8f6c\u8bca\u8be6\u60c5")
    @GetMapping(value={"/get_referral_detail"})
    public ResultInfo getReferralDetail(@RequestParam(value="findType") Integer findType, @RequestParam(value="id") Long id) {
        ReferralDetailListVo referralDetailListVo = this.referralService.getReferralDetail(findType, id);
        return this.returnSucceed((Object)referralDetailListVo, ReturnCodeEnum.SUCCEED.getDisplay());
    }

    @ApiOperation(value="\u4fdd\u5b58\u8f6c\u8bca\u8ba2\u5355\u8349\u7a3f")
    @PostMapping(value={"/save_referral_draft"})
    public ResultInfo saveReferralDraft(@RequestBody ReferralDraftVo referralDraftVo, @RequestParam(value="userId") Long userId) {
        try {
            this.referralService.saveReferralDraft(referralDraftVo, userId);
        }
        catch (Exception e) {
            return this.returnFailure(ReturnCodeEnum.FAILURE.getDisplay());
        }
        return this.returnSucceed(ReturnCodeEnum.SUCCEED.getDisplay());
    }

    @ApiOperation(value="\u7f16\u8f91\u8f6c\u8bca\u8ba2\u5355\u8349\u7a3f")
    @PostMapping(value={"/update_referral_draft"})
    public ResultInfo updateReferralDraft(@RequestBody ReferralDraftVo referralDraftVo, @RequestParam(value="userId") Long userId) {
        try {
            this.referralService.updateReferralDraft(referralDraftVo, userId);
        }
        catch (Exception e) {
            return this.returnFailure(ReturnCodeEnum.FAILURE.getDisplay());
        }
        return this.returnSucceed(ReturnCodeEnum.SUCCEED.getDisplay());
    }

    @ApiOperation(value="\u67e5\u8be2\u8f6c\u8bca\u8ba2\u5355\u8349\u7a3f")
    @GetMapping(value={"/get_referral_draft"})
    public ResultInfo<ReferralDraftVo> getReferralDraft(@RequestParam(value="id") String id, @RequestParam(value="userId") Long userId) {
        ReferralDraftVo referralDraft = this.referralService.getReferralDraft(id, userId);
        return this.returnSucceed((Object)referralDraft, ReturnCodeEnum.SUCCEED.getDisplay());
    }

    @ApiOperation(value="\u5220\u9664\u8f6c\u8bca\u8ba2\u5355\u8349\u7a3f")
    @PostMapping(value={"/delete_referral_draft"})
    public ResultInfo deleteReferralDraft(@RequestParam(value="id") String id, @RequestParam(value="userId") Long userId) {
        try {
            this.referralService.deleteReferralDraft(id, userId);
        }
        catch (Exception e) {
            return this.returnFailure(ReturnCodeEnum.FAILURE.getDisplay());
        }
        return this.returnSucceed(ReturnCodeEnum.SUCCEED.getDisplay());
    }

    @ApiOperation(value="\u67e5\u8be2\u8f6c\u8bca\u8ba2\u5355\u8349\u7a3f\u96c6\u5408")
    @GetMapping(value={"get_referral_draft_list"})
    public ResultInfo getReferralDraftList(@RequestParam(value="userId") Long userId, @RequestParam(value="page") int page, @RequestParam(value="size") int size) {
        PageResult pageResult = this.referralService.getReferralDraftList(userId, page, size);
        return this.returnSucceed((Object)pageResult, ReturnCodeEnum.SUCCEED.getDisplay());
    }

    @ApiOperation(value="\u67e5\u8be2\u60a3\u8005\u5728\u5f53\u524d\u533b\u9662\u7684\u8f6c\u8bca\u8bb0\u5f55")
    @GetMapping(value={"/get_history_referral"})
    public ResultInfo getHistoryReferral(@RequestParam(value="hospitalId") Long hospitalId, @RequestParam(value="patientId") Long patientId) {
        List referralCurtVos = this.referralService.getHistoryReferral(hospitalId, patientId);
        return this.returnSucceed((Object)referralCurtVos, ReturnCodeEnum.SUCCEED.getDisplay());
    }
}

