/*
 * Decompiled with CFR 0.152.
 */
package com.byh.controller.referral;

import com.byh.common.ResultInfo;
import com.byh.controller.BaseController;
import com.byh.enums.ReturnCodeEnum;
import com.byh.pojo.entity.referral.SurgeryReferralEntity;
import com.byh.service.referral.SurgeryReferralService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/surgery_referral"})
@Api(tags={"\u8f6c\u8bca\u624b\u672f\u8bb0\u5f55\u9644\u4ef6"})
public class SurgeryReferralController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(SurgeryReferralController.class);
    @Autowired
    private SurgeryReferralService surgeryReferralService;

    @ApiOperation(value="\u6dfb\u52a0\u624b\u672f\u8bb0\u5f55\u9644\u4ef6")
    @PostMapping(value={"/save_surgery"})
    public ResultInfo saveSurgeryReferral(@RequestBody SurgeryReferralEntity surgeryReferralEntity) {
        int insert = this.surgeryReferralService.saveSurgeryReferral(surgeryReferralEntity);
        if (insert == 0) {
            return this.returnFailure(ReturnCodeEnum.FAILURE.getDisplay());
        }
        return this.returnSucceed(ReturnCodeEnum.SUCCEED.getDisplay());
    }

    @ApiOperation(value="\u6279\u91cf\u6dfb\u52a0\u624b\u672f\u8bb0\u5f55\u9644\u4ef6")
    @PostMapping(value={"/batch_save_surgery"})
    public ResultInfo batchSaveSurgery(@RequestBody List<SurgeryReferralEntity> surgeryList) {
        try {
            this.surgeryReferralService.batchSaveSurgery(surgeryList);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            return this.returnFailure(ReturnCodeEnum.FAILURE.getDisplay());
        }
        return this.returnSucceed(ReturnCodeEnum.SUCCEED.getDisplay());
    }

    @ApiOperation(value="\u67e5\u8be2\u624b\u672f\u8bb0\u5f55\u9644\u4ef6\u96c6\u5408")
    @GetMapping(value={"/get_other_info_list"})
    public ResultInfo getSurgeryInfoList(@RequestParam(value="referralId") Long referralId) {
        List list = this.surgeryReferralService.getSurgeryInfoList(referralId);
        return this.returnSucceed((Object)list, ReturnCodeEnum.SUCCEED.getDisplay());
    }

    @ApiOperation(value="\u5220\u9664\u624b\u672f\u8bb0\u5f55\u9644\u4ef6")
    @GetMapping(value={"/delete_surgery_referral"})
    public ResultInfo deleteSurgeryReferral(@RequestParam(value="referralId") Long referralId) {
        try {
            this.surgeryReferralService.deleteSurgeryReferral(referralId);
        }
        catch (Exception e) {
            return this.returnFailure(ReturnCodeEnum.FAILURE.getDisplay());
        }
        return this.returnSucceed(ReturnCodeEnum.SUCCEED.getDisplay());
    }
}

