/*
 * Decompiled with CFR 0.152.
 */
package com.byh.service.impl.healthalliace;

import com.byh.dao.healthalliance.HospitalHealthAllianceMemberMapper;
import com.byh.pojo.entity.healthallian.HospitalHealthAllianceMemberEntity;
import com.byh.service.healthalliace.HealthAllianceMemberService;
import com.github.pagehelper.PageHelper;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class HealthAllianceMemberServiceImpl
implements HealthAllianceMemberService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private HospitalHealthAllianceMemberMapper hospitalHealthAllianceMemberMapper;

    @Transactional(rollbackFor={Exception.class})
    public String getHealthAllianceByHospitalId(Long hospitalId, Integer pageIndex, Integer pageSize) {
        String flag = "0";
        String ids = "";
        List allianceUuidList = this.hospitalHealthAllianceMemberMapper.getMemberAllianceUuidByHosId(hospitalId);
        if (allianceUuidList == null || allianceUuidList.size() < 1) {
            return "0";
        }
        PageHelper.startPage((int)pageIndex, (int)pageSize);
        HashSet hosIdList = this.hospitalHealthAllianceMemberMapper.getMemberHosIdByAllianceUuid(allianceUuidList);
        for (Integer hosId : hosIdList) {
            ids = ids + hosId.toString() + ",";
        }
        if (ids.length() > 0) {
            ids = ids.substring(0, ids.length() - 1);
        }
        if (ids.equals("")) {
            return null;
        }
        return ids;
    }

    public HospitalHealthAllianceMemberEntity getHealthAllianceMemberByHospitalId(Long hospitalId) {
        return this.hospitalHealthAllianceMemberMapper.getHealthAllianceMemberByHospitalId(hospitalId);
    }

    public int insertHealthAllianceMember(HospitalHealthAllianceMemberEntity hospitalHealthAllianceMemberEntity) {
        return this.hospitalHealthAllianceMemberMapper.insert(hospitalHealthAllianceMemberEntity);
    }

    public HospitalHealthAllianceMemberEntity queryHospitalHealthAllianceMember(String allianceUuid, Long hospitalId, Integer status) {
        return this.hospitalHealthAllianceMemberMapper.queryHospitalHealthAllianceMember(allianceUuid, hospitalId, status);
    }

    public int updateHospitalHealthAllianceMemberByAllianceUuidAndHosId(String allianceUuid, Long hospitalId, Integer status) {
        return this.hospitalHealthAllianceMemberMapper.updateHospitalHealthAllianceMemberByAllianceUuidAndHosId(allianceUuid, hospitalId, status);
    }

    public List<HospitalHealthAllianceMemberEntity> getHealthAllianceMemberByAllianceUuid(String viewId, Long hosId) {
        return this.hospitalHealthAllianceMemberMapper.getHealthAllianceMemberByAllianceUuid(viewId, hosId);
    }

    public List<HospitalHealthAllianceMemberEntity> getHealthAllianceMemberByAllianceUuid1(String viewId, Long hosId) {
        return this.hospitalHealthAllianceMemberMapper.getHealthAllianceMemberByAllianceUuid1(viewId, hosId);
    }

    public List<HospitalHealthAllianceMemberEntity> getListHealthAllianceMemberByHospitalId(Long hospitalId) {
        return this.hospitalHealthAllianceMemberMapper.getListHealthAllianceMemberByHospitalId(hospitalId);
    }

    public int updateHospitalHealthAllianceMemberIsOnline(String allianceUuid, Integer status) {
        return this.hospitalHealthAllianceMemberMapper.updateHospitalHealthAllianceMemberIsOnline(allianceUuid, status);
    }
}

