/*
 * Decompiled with CFR 0.152.
 */
package com.byh.service.impl.patient;

import com.byh.common.PageResult;
import com.byh.dao.patient.PatientCaseInfoMapper;
import com.byh.pojo.bo.PatientCaseInfoDTO;
import com.byh.pojo.entity.patient.PatientCaseInfoEntity;
import com.byh.pojo.vo.patient.CaseVO;
import com.byh.pojo.vo.patient.PatientCaseInfoVO;
import com.byh.service.patient.PatientCaseInfoService;
import com.byh.util.UuidUtils;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PatientCaseInfoServiceImpl
implements PatientCaseInfoService {
    private static final Logger log = LoggerFactory.getLogger(PatientCaseInfoServiceImpl.class);
    @Autowired
    PatientCaseInfoMapper patientCaseInfoMapper;

    public int deletePatientCaseInfoById(Long id) {
        return this.patientCaseInfoMapper.deleteById(id, Integer.valueOf(-1));
    }

    @Transactional(rollbackFor={Exception.class})
    public PatientCaseInfoVO insertPatientCaseInfo(PatientCaseInfoVO patientCaseInfoVO) {
        patientCaseInfoVO.setStatus(Integer.valueOf(1));
        patientCaseInfoVO.setViewId(UuidUtils.generateUUID());
        this.patientCaseInfoMapper.insert(patientCaseInfoVO);
        return patientCaseInfoVO;
    }

    public PatientCaseInfoEntity selectPatientCaseInfoById(Long id) {
        return this.patientCaseInfoMapper.selectById(id);
    }

    public List<PatientCaseInfoEntity> selectPatientCaseInfoByStatus(Integer status) {
        List patientCaseInfoDTOList = this.patientCaseInfoMapper.selectByStatus(status);
        return this.getNewPatientCaseInfoDTO(patientCaseInfoDTOList);
    }

    @Transactional(rollbackFor={Exception.class})
    public int updatePatientCaseInfoByIdSelective(PatientCaseInfoVO patientCaseInfoVO) {
        return this.patientCaseInfoMapper.updateByIdSelective(patientCaseInfoVO);
    }

    public List<PatientCaseInfoEntity> findPatientCaseInfoListByIds(List<Long> ids) {
        List patientCaseInfoDTOList = this.patientCaseInfoMapper.findPatientCaseInfoListByIds(ids, Integer.valueOf(1));
        return this.getNewPatientCaseInfoDTO(patientCaseInfoDTOList);
    }

    public List<CaseVO> findPatientCaseListByPatientIdAndDeptIdAndCaseTypeAndInputTime(Long patientId, Long deptId, Integer caseType, String startTime, String endTime) {
        ArrayList<CaseVO> list = new ArrayList<CaseVO>();
        List patientCaseInfoDTOList = this.patientCaseInfoMapper.findPatientCaseListByPatientIdAndDeptIdAndCaseTypeAndInputTime(patientId, deptId, caseType, startTime, endTime, 1);
        for (PatientCaseInfoEntity patientCaseInfoDTO : patientCaseInfoDTOList) {
            CaseVO caseVO = new CaseVO();
            BeanUtils.copyProperties((Object)patientCaseInfoDTO, (Object)caseVO);
            caseVO.setNormalImagesPath(this.newPath(patientCaseInfoDTO.getNormalImages()));
            caseVO.setRadioGraphFilmImagesPath(this.newPath(patientCaseInfoDTO.getRadioGraphFilmImages()));
            caseVO.setCheckReportImagesPath(this.newPath(patientCaseInfoDTO.getCheckReportImages()));
            list.add(caseVO);
        }
        return list;
    }

    public List<PatientCaseInfoEntity> findPatientCaseListByUserIdAndPatientIdAndHospitalIdAndInputDate(Long userId, Long patientId, Long hospitalId, String inputDate) {
        List patientCaseInfoDTOList = this.patientCaseInfoMapper.findPatientCaseListByUserIdAndPatientIdAndHospitalIdAndInputDate(userId, patientId, hospitalId, inputDate, 1);
        return this.getNewPatientCaseInfoDTO(patientCaseInfoDTOList);
    }

    public PatientCaseInfoEntity findPatientCaseInfoById(Long id) {
        PatientCaseInfoEntity patientCaseInfoDTO = this.patientCaseInfoMapper.selectById(id);
        patientCaseInfoDTO.setNormalImages(this.newPath(patientCaseInfoDTO.getNormalImages()));
        patientCaseInfoDTO.setCheckReportImages(this.newPath(patientCaseInfoDTO.getCheckReportImages()));
        patientCaseInfoDTO.setRadioGraphFilmImages(this.newPath(patientCaseInfoDTO.getRadioGraphFilmImages()));
        return patientCaseInfoDTO;
    }

    public String newPath(String path) {
        StringBuffer filePath = new StringBuffer();
        if (path == null || path.trim().equals("")) {
            return null;
        }
        return null;
    }

    public List<PatientCaseInfoEntity> getNewPatientCaseInfoDTO(List<PatientCaseInfoEntity> patientCaseInfoDTOList) {
        ArrayList<PatientCaseInfoEntity> list = new ArrayList<PatientCaseInfoEntity>();
        for (PatientCaseInfoEntity patientCaseInfoDTO : patientCaseInfoDTOList) {
            patientCaseInfoDTO.setNormalImages(this.newPath(patientCaseInfoDTO.getNormalImages()));
            patientCaseInfoDTO.setCheckReportImages(this.newPath(patientCaseInfoDTO.getCheckReportImages()));
            patientCaseInfoDTO.setRadioGraphFilmImages(this.newPath(patientCaseInfoDTO.getRadioGraphFilmImages()));
            list.add(patientCaseInfoDTO);
        }
        return list;
    }

    public PageResult<CaseVO> findPatientCaseByHospitalIdAndPatientId(Long patientId, Long hospitalId, int pageNum, int pageSize) {
        PageHelper.startPage((int)pageNum, (int)pageSize);
        Page patientCaseInfoDTOPage = this.patientCaseInfoMapper.findPatientCaseByHospitalIdAndPatientId(patientId, hospitalId, PatientCaseInfoDTO.PUCT_TYPE, Integer.valueOf(1));
        ArrayList<CaseVO> list = new ArrayList<CaseVO>();
        for (PatientCaseInfoEntity patientCaseInfoDTO : patientCaseInfoDTOPage.getResult()) {
            CaseVO caseVO = new CaseVO();
            BeanUtils.copyProperties((Object)patientCaseInfoDTO, (Object)caseVO);
            caseVO.setNormalImagesPath(this.newPath(patientCaseInfoDTO.getNormalImages()));
            caseVO.setRadioGraphFilmImagesPath(this.newPath(patientCaseInfoDTO.getRadioGraphFilmImages()));
            caseVO.setCheckReportImagesPath(this.newPath(patientCaseInfoDTO.getCheckReportImages()));
            list.add(caseVO);
        }
        PageResult pageResult = new PageResult(list, patientCaseInfoDTOPage.getPageNum(), patientCaseInfoDTOPage.getPageSize(), patientCaseInfoDTOPage.getTotal(), patientCaseInfoDTOPage.getPages());
        return pageResult;
    }
}

