/*
 * Decompiled with CFR 0.152.
 */
package com.byh.service.impl.referral;

import com.byh.dao.referral.CaseReferralMapper;
import com.byh.pojo.entity.patient.PatientCaseInfoEntity;
import com.byh.pojo.entity.referral.CaseReferralEntity;
import com.byh.service.patient.PatientCaseInfoService;
import com.byh.service.referral.CaseReferralService;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CaseReferralServiceImpl
implements CaseReferralService {
    @Autowired
    private CaseReferralMapper caseReferralMapper;
    @Autowired
    private PatientCaseInfoService patientCaseInfoService;

    public int saveCaseReferral(CaseReferralEntity caseReferralEntity) {
        return this.caseReferralMapper.insertSelective(caseReferralEntity);
    }

    @Transactional(rollbackFor={RuntimeException.class})
    public void batchSaveCaseReferral(List<CaseReferralEntity> caseList) {
        this.caseReferralMapper.batchSaveCaseReferral(caseList);
    }

    public List<PatientCaseInfoEntity> getCaseReferralList(Long referralId) {
        List caseList = this.caseReferralMapper.getCaseReferralList(referralId, 1);
        List caseIds = caseList.stream().map(CaseReferralEntity::getCaseId).collect(Collectors.toList());
        List<Object> patientCaseInfoDTOS = new ArrayList<PatientCaseInfoEntity>();
        if (caseIds.size() == 0) {
            return patientCaseInfoDTOS;
        }
        patientCaseInfoDTOS = this.patientCaseInfoService.findPatientCaseInfoListByIds(caseIds);
        return patientCaseInfoDTOS;
    }

    public void deleteCaseReferral(Long referralId) {
        this.caseReferralMapper.deleteCaseReferralByReferral(referralId, -1);
    }
}

