/*
 * Decompiled with CFR 0.152.
 */
package com.byh.service.impl.referral;

import com.alibaba.fastjson.JSON;
import com.byh.common.Function;
import com.byh.common.PageResult;
import com.byh.dao.referral.ReferralMapper;
import com.byh.enums.GanderEnum;
import com.byh.enums.InformationEnum;
import com.byh.enums.ReferralEnum;
import com.byh.feign.IPatientServiceFeignClient;
import com.byh.pojo.entity.patient.PatientCaseInfoEntity;
import com.byh.pojo.entity.patient.PatientOtherInfoEntity;
import com.byh.pojo.entity.patient.PatientSurgeryInfoEntity;
import com.byh.pojo.entity.referral.CaseReferralEntity;
import com.byh.pojo.entity.referral.OtherInfoReferralEntity;
import com.byh.pojo.entity.referral.ReferralEntity;
import com.byh.pojo.entity.referral.SurgeryReferralEntity;
import com.byh.pojo.vo.patient.PatientCaseInfoVO;
import com.byh.pojo.vo.patient.PatientConsulVO;
import com.byh.pojo.vo.referral.PatientCaseInfoVo;
import com.byh.pojo.vo.referral.PatientCaseVo;
import com.byh.pojo.vo.referral.PatientOtherInfoVo;
import com.byh.pojo.vo.referral.ReferraVerifyVo;
import com.byh.pojo.vo.referral.ReferralCurtVo;
import com.byh.pojo.vo.referral.ReferralDetailListVo;
import com.byh.pojo.vo.referral.ReferralDetailVo;
import com.byh.pojo.vo.referral.ReferralDraftVo;
import com.byh.pojo.vo.referral.ReferralPageParamVo;
import com.byh.pojo.vo.referral.ReferralPageVo;
import com.byh.pojo.vo.referral.ReferralSaveAllVo;
import com.byh.pojo.vo.referral.ReferralVo;
import com.byh.service.patient.PatientCaseInfoService;
import com.byh.service.patient.PatientOtherInfoService;
import com.byh.service.patient.PatientSurgeryInfoService;
import com.byh.service.referral.CaseReferralService;
import com.byh.service.referral.OtherInfoReferralService;
import com.byh.service.referral.ReferralService;
import com.byh.service.referral.SurgeryReferralService;
import com.byh.util.DateUtils;
import com.byh.util.RandomUtil;
import com.byh.util.RedisUtils;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.hxgy.patientservice.api.pojo.vo.SavePatientInfoReqVo;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Service
public class ReferralServiceImpl
implements ReferralService {
    private static final Logger log = LoggerFactory.getLogger(ReferralServiceImpl.class);
    public static final Integer CASE_TYPE_REFERRAL = 1;
    public static final String USER_REFERRAL_DRAFT = "admin-user-referral-draft";
    @Autowired
    private ReferralMapper referralMapper;
    @Autowired
    private PatientCaseInfoService patientCaseInfoService;
    @Autowired
    private PatientOtherInfoService patientOtherInfoService;
    @Autowired
    private PatientSurgeryInfoService patientSurgeryInfoService;
    @Autowired
    private CaseReferralService caseReferralService;
    @Autowired
    private OtherInfoReferralService otherInfoReferralService;
    @Autowired
    private SurgeryReferralService surgeryReferralService;
    @Autowired
    IPatientServiceFeignClient patientServiceFeignClient;
    @Autowired
    private JedisPool jedisPool;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T excute(Function<Jedis, T> fun) {
        Jedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            Object object = fun.callback((Object)jedis);
            return (T)object;
        }
        catch (Exception e) {
            log.error("redis error" + e.getMessage());
        }
        finally {
            RedisUtils.returnResource((JedisPool)this.jedisPool, (Jedis)jedis);
            RedisUtils.returnBrokenResource((JedisPool)this.jedisPool, (Jedis)jedis);
        }
        return null;
    }

    @Transactional(rollbackFor={Exception.class})
    public void save(ReferralSaveAllVo referralSaveAllVo) throws Exception {
        if (referralSaveAllVo.getPatientCaseInfoVos().isEmpty() && referralSaveAllVo.getReferralVo().getType().equals(ReferralEnum.REFERRAL_HIGHER.getValue())) {
            throw new Exception("\u4e0a\u8f6c\u7c7b\u578b\u8f6c\u8bca\u75c5\u5386\u8d44\u6599\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (referralSaveAllVo.getReferralVo().getType().equals(ReferralEnum.REFERRAL_BACK.getValue())) {
            List list;
            if (referralSaveAllVo.getPatientOtherInfoVos().isEmpty()) {
                throw new Exception("\u56de\u8f6c\u7c7b\u578b\u8f6c\u8bca\u533b\u5631\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (referralSaveAllVo.getPatientOtherInfoVos().size() > 0 && (list = referralSaveAllVo.getPatientOtherInfoVos().stream().filter(patientOtherInfoVo -> patientOtherInfoVo.getInfoType().equals(InformationEnum.INFORMATION_DOCTOR_ADVICE.getValue())).collect(Collectors.toList())).isEmpty()) {
                throw new Exception("\u56de\u8f6c\u7c7b\u578b\u8f6c\u8bca\u533b\u5631\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        ReferralVo referralVo = referralSaveAllVo.getReferralVo();
        ReferralEntity referralEntity = new ReferralEntity();
        BeanUtils.copyProperties((Object)referralVo, (Object)referralEntity);
        referralEntity.setState(ReferralEnum.REVIEW_TOAUDIT.getValue());
        String viewId = String.valueOf(System.currentTimeMillis()) + RandomUtil.getRandom();
        referralEntity.setViewId(viewId);
        referralEntity.setState(ReferralEnum.REVIEW_TOAUDIT.getValue());
        this.referralMapper.insert(referralEntity);
        Long referralId = referralEntity.getId();
        Long hospitalId = referralVo.getHospitalId();
        Long patientId = referralVo.getPatientId();
        if (!referralSaveAllVo.getPatientCaseInfoVos().isEmpty()) {
            List patientCaseInfoVos = referralSaveAllVo.getPatientCaseInfoVos();
            ArrayList<PatientCaseInfoVO> patientCaseInfoVOS = new ArrayList<PatientCaseInfoVO>();
            for (Object patientCaseInfoVo : patientCaseInfoVos) {
                if (patientCaseInfoVo.getId() != null) continue;
                PatientCaseInfoVO patientCaseInfoVO = new PatientCaseInfoVO();
                BeanUtils.copyProperties((Object)patientCaseInfoVo, (Object)patientCaseInfoVO);
                patientCaseInfoVO.setPatientId(patientId);
                patientCaseInfoVO.setHospitalId(hospitalId);
                patientCaseInfoVO.setHospitalName(referralSaveAllVo.getReferralVo().getHospitalName());
                patientCaseInfoVO.setPatientName(referralSaveAllVo.getReferralVo().getPatientName());
                patientCaseInfoVO.setCaseType(CASE_TYPE_REFERRAL);
                patientCaseInfoVO.setStatus(Integer.valueOf(1));
                patientCaseInfoVOS.add(patientCaseInfoVO);
            }
            ArrayList patientCaseInfoVOList = new ArrayList();
            for (PatientCaseInfoVO patientCaseInfo : patientCaseInfoVOS) {
                PatientCaseInfoVO patientCaseInfo1 = this.patientCaseInfoService.insertPatientCaseInfo(patientCaseInfo);
                patientCaseInfoVOList.add(patientCaseInfo1);
            }
            this.caseInfoReferral(referralId, (List)patientCaseInfoVOList, patientCaseInfoVos);
        }
        if (!referralSaveAllVo.getPatientSurgeryInfoVos().isEmpty()) {
            List patientSurgeryInfoVos = referralSaveAllVo.getPatientSurgeryInfoVos();
            ArrayList<PatientSurgeryInfoEntity> patientSurgeryInfoEntities = new ArrayList<PatientSurgeryInfoEntity>();
            for (Object patientSurgeryInfoVo : patientSurgeryInfoVos) {
                PatientSurgeryInfoEntity patientSurgeryInfoEntity = new PatientSurgeryInfoEntity();
                BeanUtils.copyProperties((Object)patientSurgeryInfoVo, (Object)patientSurgeryInfoEntity);
                patientSurgeryInfoEntity.setPatientId(patientId);
                patientSurgeryInfoEntity.setHospitalId(hospitalId);
                patientSurgeryInfoEntity.setStatus(Integer.valueOf(1));
                patientSurgeryInfoEntities.add(patientSurgeryInfoEntity);
            }
            ArrayList surgeryInfoIds = new ArrayList();
            for (PatientSurgeryInfoEntity patientSurgeryInfoEntity : patientSurgeryInfoEntities) {
                this.patientSurgeryInfoService.savePatientSurgeryInfo(patientSurgeryInfoEntity);
                surgeryInfoIds.add(patientSurgeryInfoEntity.getId());
            }
            this.surgeryInfoReferral(referralId, (List)surgeryInfoIds);
        }
        if (!referralSaveAllVo.getPatientOtherInfoVos().isEmpty()) {
            List patientOtherInfoVos = referralSaveAllVo.getPatientOtherInfoVos();
            ArrayList<PatientOtherInfoEntity> patientOtherInfoEntities = new ArrayList<PatientOtherInfoEntity>();
            for (PatientOtherInfoVo patientOtherInfoVo2 : patientOtherInfoVos) {
                PatientOtherInfoEntity patientOtherInfoEntity = new PatientOtherInfoEntity();
                BeanUtils.copyProperties((Object)patientOtherInfoVo2, (Object)patientOtherInfoEntity);
                patientOtherInfoEntity.setHospitalId(hospitalId);
                patientOtherInfoEntity.setPatientId(patientId);
                patientOtherInfoEntity.setStatus(Integer.valueOf(1));
                patientOtherInfoEntities.add(patientOtherInfoEntity);
            }
            ArrayList<PatientOtherInfoEntity> patientOtherInfoEntityList = new ArrayList<PatientOtherInfoEntity>();
            for (PatientOtherInfoEntity tempPatientOtherInfoEntity : patientOtherInfoEntities) {
                this.patientOtherInfoService.savePatientOtherInfo(tempPatientOtherInfoEntity);
                patientOtherInfoEntityList.add(tempPatientOtherInfoEntity);
            }
            this.otherInfoReferral(referralId, patientOtherInfoEntityList);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public int verifyReferral(ReferraVerifyVo referralVerifyVo) throws Exception {
        if (referralVerifyVo.getState() == null) {
            throw new Exception("\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (referralVerifyVo.getState().equals(ReferralEnum.REVIEW_APPROVED.getValue())) {
            if (referralVerifyVo.getReceiveDoctorId() == null || referralVerifyVo.getReceiveDoctorName() == null) {
                throw new Exception("\u63a5\u8bca\u533b\u751f\u4e0d\u80fd\u4e3a\u7a7a");
            }
            ReferralEntity referralEntity = this.referralMapper.selectByPrimaryKey(referralVerifyVo.getId());
            String phone = referralEntity.getPatientPhone();
            PatientConsulVO consultationVO = new PatientConsulVO();
            consultationVO.setMobileNumber(phone);
            consultationVO.setHospitalId(referralEntity.getReceiveHospitalId());
            consultationVO.setIdCard(referralEntity.getPatientCardNo());
            SavePatientInfoReqVo savePatientInfoReqVo = new SavePatientInfoReqVo();
            savePatientInfoReqVo.setName(consultationVO.getName());
            savePatientInfoReqVo.setCredNo(consultationVO.getIdCard());
            savePatientInfoReqVo.setGender(Short.valueOf(consultationVO.getGender().shortValue()));
            LocalDate birthday = LocalDate.now().plusYears(-consultationVO.getAge().intValue());
            savePatientInfoReqVo.setBirthdate(DateUtils.convertLocalDateToDate((LocalDate)birthday));
            this.patientServiceFeignClient.savePatientInfo(savePatientInfoReqVo);
        }
        if (referralVerifyVo.getState().equals(ReferralEnum.REVIEW_REFUSED.getValue()) && (referralVerifyVo.getReason() == null || referralVerifyVo.getReason() == "")) {
            throw new Exception("\u62d2\u7edd\u539f\u56e0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        int result = this.referralMapper.verifyReferral(referralVerifyVo);
        return result;
    }

    public PageResult<List<ReferralPageVo>> pageReferralByHospitalId(Integer pageNo, Integer pageSize, Integer findType, Long hospitalId, ReferralPageParamVo referralPageParamVo) {
        PageHelper.startPage((int)pageNo, (int)pageSize);
        Page referralEntities = this.referralMapper.pageReferralByHospitalId(findType, hospitalId, referralPageParamVo);
        ArrayList<ReferralPageVo> referralPageVoList = new ArrayList<ReferralPageVo>();
        for (ReferralEntity referralEntity : referralEntities.getResult()) {
            ReferralPageVo referralPageVo = new ReferralPageVo();
            if (findType.equals(1)) {
                referralPageVo.setHospitalName(referralEntity.getHospitalName());
                referralPageVo.setDeptDetailName(referralEntity.getDeptDetailName());
            }
            if (findType.equals(2)) {
                referralPageVo.setHospitalName(referralEntity.getReceiveHospitalName());
                referralPageVo.setDeptDetailName(referralEntity.getReceiveDeptDetailName());
            }
            referralPageVo.setId(referralEntity.getId());
            referralPageVo.setViewId(referralEntity.getViewId());
            referralPageVo.setDoctorName(referralEntity.getDoctorName());
            referralPageVo.setReferralDate(DateUtils.dateToString((Date)referralEntity.getReceiveDate(), (String)"yyyy-MM-dd"));
            referralPageVo.setType(ReferralEnum.getByValue((Integer)referralEntity.getType()).getDisplay());
            referralPageVo.setState(ReferralEnum.getByValue((Integer)referralEntity.getState()).getDisplay());
            referralPageVo.setCreateTime(DateUtils.dateToString((Date)referralEntity.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            referralPageVo.setPatientInfo(referralEntity.getPatientName() + "/" + GanderEnum.getByValue((Integer)referralEntity.getPatientGender()).getDisplay() + "/" + referralEntity.getPatientAge());
            referralPageVoList.add(referralPageVo);
        }
        PageResult pageResult = new PageResult(referralPageVoList, referralEntities.getPageNum(), referralEntities.getPageSize(), referralEntities.getTotal(), referralEntities.getPages());
        return pageResult;
    }

    public List<ReferralEntity> getByIds(List<Long> ids) {
        List referralEntities = this.referralMapper.getByIds(ids);
        return referralEntities;
    }

    public ReferralDetailListVo getReferralDetail(Integer findType, Long id) {
        ReferralDetailListVo referralDetailListVo = new ReferralDetailListVo();
        ReferralEntity referralEntity = this.referralMapper.selectByPrimaryKey(id);
        ReferralDetailVo referralDetailVo = new ReferralDetailVo();
        BeanUtils.copyProperties((Object)referralEntity, (Object)referralDetailVo);
        if (findType.equals(1)) {
            referralDetailVo.setHospitalName(referralEntity.getHospitalName());
        }
        if (findType.equals(2)) {
            referralDetailVo.setHospitalName(referralEntity.getReceiveHospitalName());
        }
        referralDetailVo.setReceiveDate(DateUtils.dateToString((Date)referralEntity.getReceiveDate(), (String)"yyyy-MM-dd"));
        referralDetailVo.setType(ReferralEnum.getByValue((Integer)referralEntity.getType()).getDisplay());
        referralDetailVo.setState(ReferralEnum.getByValue((Integer)referralEntity.getState()).getDisplay());
        referralDetailListVo.setReferralDetailVo(referralDetailVo);
        Long patientId = referralEntity.getPatientId();
        Long hospitalId = null;
        if (findType.equals(1)) {
            hospitalId = referralEntity.getReceiveHospitalId();
        }
        if (findType.equals(2)) {
            hospitalId = referralEntity.getHospitalId();
        }
        List referralCurtVos = this.referralMapper.getListByHospitalIdAndPatientId(hospitalId, patientId);
        referralDetailListVo.setReferralCurtVos(referralCurtVos);
        List patientCaseInfoDTOS = this.caseReferralService.getCaseReferralList(id);
        ArrayList<PatientCaseVo> patientCaseVos = new ArrayList<PatientCaseVo>();
        for (PatientCaseInfoEntity patientCaseInfoDTO : patientCaseInfoDTOS) {
            PatientCaseVo patientCaseVo = new PatientCaseVo();
            BeanUtils.copyProperties((Object)patientCaseInfoDTO, (Object)patientCaseVo);
            patientCaseVo.setHospitalName(referralEntity.getHospitalName());
            patientCaseVos.add(patientCaseVo);
        }
        referralDetailListVo.setPatientCaseVos(patientCaseVos);
        return referralDetailListVo;
    }

    public void saveReferralDraft(ReferralDraftVo referralDraftVo, Long userId) {
        referralDraftVo.setSaveId(Double.valueOf(System.currentTimeMillis()));
        this.excute((Function)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void updateReferralDraft(ReferralDraftVo referralDraftVo, Long userId) {
        this.excute((Function)new /* Unavailable Anonymous Inner Class!! */);
        referralDraftVo.setSaveId(Double.valueOf(System.currentTimeMillis()));
        this.excute((Function)new /* Unavailable Anonymous Inner Class!! */);
    }

    public ReferralDraftVo getReferralDraft(String id, Long userId) {
        Set set = (Set)this.excute((Function)new /* Unavailable Anonymous Inner Class!! */);
        List list = set.stream().map(str -> str).collect(Collectors.toList());
        if (list.size() == 1) {
            return (ReferralDraftVo)JSON.parseObject((String)((String)list.get(0)), ReferralDraftVo.class);
        }
        return null;
    }

    public void deleteReferralDraft(String id, Long userId) {
        this.excute((Function)new /* Unavailable Anonymous Inner Class!! */);
    }

    public PageResult getReferralDraftList(Long userId, int page, int size) {
        Long count = (Long)this.excute((Function)new /* Unavailable Anonymous Inner Class!! */);
        Integer length = count.intValue();
        int totalPage = length % size == 0 ? length / size : length / size + 1;
        long start = (page - 1) * size;
        long end = page != totalPage ? (long)(page * size - 1) : (long)length.intValue();
        Set sets = (Set)this.excute((Function)new /* Unavailable Anonymous Inner Class!! */);
        List list = sets.stream().map(str -> str).collect(Collectors.toList());
        ArrayList<ReferralDraftVo> referralDraftList = new ArrayList<ReferralDraftVo>();
        for (String referralDraftStr : list) {
            ReferralDraftVo referralDraft = (ReferralDraftVo)JSON.parseObject((String)referralDraftStr, ReferralDraftVo.class);
            referralDraftList.add(referralDraft);
        }
        return new PageResult(referralDraftList, (long)length.intValue());
    }

    public List<ReferralCurtVo> getHistoryReferral(Long hospitalId, Long patientId) {
        return this.referralMapper.getListByHospitalIdAndPatientId(hospitalId, patientId);
    }

    public void otherInfoReferral(Long referralId, List<PatientOtherInfoEntity> patientOtherInfoEntityList) {
        ArrayList<OtherInfoReferralEntity> otherInfoReferralEntities = new ArrayList<OtherInfoReferralEntity>();
        for (PatientOtherInfoEntity patientOtherInfoEntity : patientOtherInfoEntityList) {
            OtherInfoReferralEntity otherInfoReferralEntity = new OtherInfoReferralEntity();
            otherInfoReferralEntity.setReferralId(referralId);
            otherInfoReferralEntity.setOtherInfoId(patientOtherInfoEntity.getId());
            otherInfoReferralEntity.setType(patientOtherInfoEntity.getInfoType());
            otherInfoReferralEntities.add(otherInfoReferralEntity);
        }
        this.otherInfoReferralService.batchSaveOtherInfo(otherInfoReferralEntities);
    }

    public void caseInfoReferral(Long referralId, List<PatientCaseInfoVO> patientCaseInfoVOList, List<PatientCaseInfoVo> patientCaseInfoVos) {
        CaseReferralEntity caseReferralEntity;
        ArrayList<CaseReferralEntity> caseReferralEntities = new ArrayList<CaseReferralEntity>();
        for (PatientCaseInfoVO patientCaseInfoVO : patientCaseInfoVOList) {
            caseReferralEntity = new CaseReferralEntity();
            caseReferralEntity.setCaseId(patientCaseInfoVO.getId());
            caseReferralEntity.setReferralId(referralId);
            caseReferralEntities.add(caseReferralEntity);
        }
        for (PatientCaseInfoVo patientCaseInfoVo : patientCaseInfoVos) {
            if (patientCaseInfoVo.getId() == null) continue;
            caseReferralEntity = new CaseReferralEntity();
            caseReferralEntity.setCaseId(patientCaseInfoVo.getId());
            caseReferralEntity.setReferralId(referralId);
            caseReferralEntities.add(caseReferralEntity);
        }
        this.caseReferralService.batchSaveCaseReferral(caseReferralEntities);
    }

    public void surgeryInfoReferral(Long referralId, List<Long> surgeryInfoIds) {
        ArrayList<SurgeryReferralEntity> surgeryReferralEntities = new ArrayList<SurgeryReferralEntity>();
        for (Long surgeryId : surgeryInfoIds) {
            SurgeryReferralEntity surgeryReferralEntity = new SurgeryReferralEntity();
            surgeryReferralEntity.setSurgeryId(surgeryId);
            surgeryReferralEntity.setReferralId(referralId);
            surgeryReferralEntities.add(surgeryReferralEntity);
        }
        this.surgeryReferralService.batchSaveSurgery(surgeryReferralEntities);
    }
}

