/*
 * Decompiled with CFR 0.152.
 */
package com.byh.service.impl.referral;

import com.byh.dao.referral.SurgeryReferralMapper;
import com.byh.pojo.entity.patient.PatientSurgeryInfoEntity;
import com.byh.pojo.entity.referral.SurgeryReferralEntity;
import com.byh.service.patient.PatientSurgeryInfoService;
import com.byh.service.referral.SurgeryReferralService;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SurgeryReferralServiceImpl
implements SurgeryReferralService {
    @Autowired
    private SurgeryReferralMapper surgeryReferralMapper;
    @Autowired
    private PatientSurgeryInfoService patientSurgeryInfoService;

    public int saveSurgeryReferral(SurgeryReferralEntity surgeryReferralEntity) {
        return this.surgeryReferralMapper.insertSelective(surgeryReferralEntity);
    }

    public void batchSaveSurgery(List<SurgeryReferralEntity> surgeryList) {
        this.surgeryReferralMapper.batchSaveSurgeryReferral(surgeryList);
    }

    public List<PatientSurgeryInfoEntity> getSurgeryInfoList(Long referralId) {
        List<Object> patientSurgeryInfoEntities = new ArrayList<PatientSurgeryInfoEntity>();
        List surgeryList = this.surgeryReferralMapper.getSurgeryInfoList(referralId, 1);
        List surgeryIds = surgeryList.stream().map(SurgeryReferralEntity::getSurgeryId).collect(Collectors.toList());
        if (surgeryIds.size() == 0) {
            return patientSurgeryInfoEntities;
        }
        patientSurgeryInfoEntities = this.patientSurgeryInfoService.findPatientSurgeryInfoListByIds(surgeryIds);
        return patientSurgeryInfoEntities;
    }

    public void deleteSurgeryReferral(Long referralId) {
        this.surgeryReferralMapper.deleteSurgeryByReferralId(referralId, -1);
    }
}

