/*
 * Decompiled with CFR 0.152.
 */
package com.byh.util;

import cn.afterturn.easypoi.word.WordExportUtil;
import com.byh.pojo.entity.referral.ReferralEntity;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WordUtils {
    private static final Logger log = LoggerFactory.getLogger(WordUtils.class);
    public static final Integer ROll_BACK_TYPE = 2;

    public static void saveWord(ReferralEntity referralEntity, String wordPath) {
        log.info(wordPath + "---------->" + referralEntity.toString());
        String dateTime = DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd_HHmmssSSS");
        String year = DateFormatUtils.format((Date)new Date(), (String)"yyyy");
        String month = DateFormatUtils.format((Date)new Date(), (String)"MM");
        String day = DateFormatUtils.format((Date)new Date(), (String)"dd");
        String templPath = "template/rollout.docx";
        if (referralEntity.getType() == ROll_BACK_TYPE) {
            templPath = "template/rollback.docx";
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("hospitalName", referralEntity.getHospitalName());
        param.put("name", referralEntity.getPatientName());
        if (referralEntity.getPatientGender() == 1) {
            param.put("sex", "\u7537");
        } else {
            param.put("sex", "\u5973");
        }
        param.put("cardNo", referralEntity.getViewId() == null ? " " : referralEntity.getViewId());
        param.put("age", referralEntity.getPatientAge() == null ? " " : referralEntity.getPatientAge());
        param.put("phone", referralEntity.getPatientPhone() == null ? " " : referralEntity.getPatientPhone());
        param.put("idCard", referralEntity.getPatientCardNo() == null ? " " : referralEntity.getPatientCardNo());
        param.put("rhname", referralEntity.getReceiveHospitalName() == null ? " " : referralEntity.getReceiveHospitalName());
        param.put("rdname", referralEntity.getReceiveDeptDetailName() == null ? " " : referralEntity.getReceiveDeptDetailName());
        param.put("dname", referralEntity.getDoctorName() == null ? " " : referralEntity.getDoctorName());
        param.put("rname", referralEntity.getReceiveDoctorName() == null ? " " : referralEntity.getReceiveDoctorName());
        param.put("cbzd", referralEntity.getPrimaryDiagno() == null ? " " : referralEntity.getPrimaryDiagno());
        param.put("zzmd", referralEntity.getReferralPurpose() == null ? " " : referralEntity.getReferralPurpose());
        param.put("year", year);
        param.put("month", month);
        param.put("day", day);
        try {
            XWPFDocument doc = WordExportUtil.exportWord07((String)templPath, param);
            FileOutputStream fos = new FileOutputStream(wordPath + param.get("name") + dateTime + ".docx");
            doc.write((OutputStream)fos);
            fos.close();
        }
        catch (Exception e) {
            log.error("word\u6a21\u677f\u5199\u5165\u5931\u8d25");
            e.printStackTrace();
        }
    }
}

