/*
 * Decompiled with CFR 0.152.
 */
package com.byh.controller.allocation;

import com.alibaba.excel.EasyExcel;
import com.byh.pojo.vo.allocation.req.BatchSettleReqVO;
import com.byh.pojo.vo.allocation.req.BatchUpdateIncomeReqVO;
import com.byh.pojo.vo.allocation.req.BillInfoReqVO;
import com.byh.pojo.vo.allocation.req.ExportExcelReqVO;
import com.byh.pojo.vo.allocation.req.ImmediateSettleReqVO;
import com.byh.pojo.vo.allocation.req.OverviewSettleReqVO;
import com.byh.pojo.vo.allocation.req.UpdateIncomeReqVO;
import com.byh.pojo.vo.allocation.resp.AllocationOverviewRespVO;
import com.byh.pojo.vo.allocation.resp.BusinessTypeInfoRespVO;
import com.byh.service.allocation.BillInfoService;
import com.ebaiyihui.framework.response.BaseResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.Consts;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5206\u8d26\u8bb0\u5f55\u8868API"})
@RestController
@RequestMapping(value={"/billInfo"}, produces={"application/json;charset:UTF-8"})
public class BillInfoController {
    @Autowired
    private BillInfoService billInfoService;

    @ApiOperation(value="\u67e5\u8be2\u4e1a\u52a1\u7c7b\u578b\u4fa7\u8fb9\u680f\u4fe1\u606f")
    @GetMapping(value={"/findBusinessTypeInfoList"})
    public BaseResponse<List<BusinessTypeInfoRespVO>> findBusinessTypeInfoList() {
        List businessTypeInfoRespVOList = this.billInfoService.findBusinessTypeInfoList();
        return BaseResponse.success((Object)businessTypeInfoRespVOList);
    }

    @ApiOperation(value="\u67e5\u8be2\u5212\u62e8\u6982\u89c8\u5217\u8868")
    @GetMapping(value={"/findAllocationOverviewList"})
    public BaseResponse<List<AllocationOverviewRespVO>> findAllocationOverviewList(@RequestParam(value="businessCode") Integer businessCode, @RequestParam(value="allocationRuleName", required=false, defaultValue="") String allocationRuleName) {
        List allocationOverviewRespVOList = this.billInfoService.findAllocationOverviewList(businessCode, allocationRuleName);
        return BaseResponse.success((Object)allocationOverviewRespVOList);
    }

    @ApiOperation(value="\u6982\u89c8\u5217\u8868\u7acb\u5373\u7ed3\u7b97")
    @PostMapping(value={"/overviewImmediateSettle"})
    public BaseResponse<Map<String, String>> overviewImmediateSettle(@RequestBody @Validated OverviewSettleReqVO overviewSettleReqVO, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            String errorMessage = bindingResult.getFieldError().getDefaultMessage();
            return BaseResponse.error((String)errorMessage);
        }
        Map ret = this.billInfoService.overviewImmediateSettle(overviewSettleReqVO);
        if (ret.size() > 0) {
            return BaseResponse.error((String)((String)ret.get("errorMsg")));
        }
        return BaseResponse.success();
    }

    @ApiOperation(value="\u8be6\u60c5\u5217\u8868\u6279\u91cf\u7ed3\u7b97")
    @PostMapping(value={"/batchImmediateSettlement"})
    public BaseResponse<Map<String, String>> batchImmediateSettle(@RequestBody @Validated BatchSettleReqVO batchSettleReqVO, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            String errorMessage = bindingResult.getFieldError().getDefaultMessage();
            return BaseResponse.error((String)errorMessage);
        }
        Map ret = this.billInfoService.batchImmediateSettle(batchSettleReqVO);
        if (ret.size() > 0) {
            return BaseResponse.error((String)((String)ret.get("errorMsg")));
        }
        return BaseResponse.success();
    }

    @ApiOperation(value="\u8be6\u60c5\u5217\u8868\u7acb\u5373\u7ed3\u7b97")
    @PostMapping(value={"/immediateSettlement"})
    public BaseResponse immediateSettle(@RequestBody @Validated ImmediateSettleReqVO immediateSettleReqVO, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            String errorMessage = bindingResult.getFieldError().getDefaultMessage();
            return BaseResponse.error((String)errorMessage);
        }
        this.billInfoService.immediateSettle(immediateSettleReqVO);
        return BaseResponse.success();
    }

    @ApiOperation(value="\u67e5\u8be2\u5212\u62e8\u8d26\u5355\u8be6\u60c5")
    @PostMapping(value={"/findBillInfoDetail"})
    public BaseResponse<Map<String, Object>> findBillInfoDetail(@RequestBody @Validated BillInfoReqVO billInfoReqVO, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            String errorMessage = bindingResult.getFieldError().getDefaultMessage();
            return BaseResponse.error((String)errorMessage);
        }
        if (billInfoReqVO.getBeginTime() != null && !"".equals(billInfoReqVO.getBeginTime())) {
            billInfoReqVO.setBeginTime(billInfoReqVO.getBeginTime() + " 00:00:00");
        }
        if (billInfoReqVO.getEndTime() != null && !"".equals(billInfoReqVO.getEndTime())) {
            billInfoReqVO.setEndTime(billInfoReqVO.getEndTime() + " 23:59:59");
        }
        Map ret = this.billInfoService.findBillInfoDetail(billInfoReqVO);
        return BaseResponse.success((Object)ret);
    }

    @ApiOperation(value="\u4fee\u6539\u6536\u76ca")
    @PostMapping(value={"/updateIncome"})
    public BaseResponse updateIncome(@RequestBody @Validated UpdateIncomeReqVO updateIncomeReqVO, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            String errorMessage = bindingResult.getFieldError().getDefaultMessage();
            return BaseResponse.error((String)errorMessage);
        }
        this.billInfoService.updateIncome(updateIncomeReqVO);
        return BaseResponse.success();
    }

    @ApiOperation(value="\u4e0b\u8f7d\u8d26\u5355")
    @GetMapping(value={"/downloadBill"})
    public void downloadBill(@RequestParam(value="businessCode") Integer businessCode, @RequestParam(value="multipleAccountRuleId", required=false) Long multipleAccountRuleId, @RequestParam(value="beginTime", required=false) String beginTime, @RequestParam(value="endTime", required=false) String endTime, @RequestParam(value="assignStatus", required=false) Integer assignStatus, @RequestParam(value="uploadOrFinish", required=false) Integer uploadOrFinish, @RequestParam(value="queryVal", required=false) String queryVal, HttpServletResponse response) throws IOException {
        response.setContentType("application/vnd.ms-excel");
        response.setCharacterEncoding(Consts.UTF_8.name());
        String fileName = URLEncoder.encode("\u8d26\u5355\u4fe1\u606f" + System.currentTimeMillis(), Consts.UTF_8.name());
        response.setHeader("Content-disposition", "attachment;filename=" + fileName + ".xlsx");
        ExportExcelReqVO exportExcelReqVO = new ExportExcelReqVO();
        exportExcelReqVO.setBusinessCode(businessCode);
        exportExcelReqVO.setMultipleAccountRuleId(multipleAccountRuleId);
        exportExcelReqVO.setBeginTime(beginTime);
        exportExcelReqVO.setEndTime(endTime);
        exportExcelReqVO.setAssignStatus(assignStatus);
        exportExcelReqVO.setQueryVal(queryVal);
        exportExcelReqVO.setUploadOrFinish(uploadOrFinish);
        EasyExcel.write((OutputStream)response.getOutputStream()).head(this.billInfoService.getHead(exportExcelReqVO)).sheet("\u8d26\u5355\u4fe1\u606f").doWrite(this.billInfoService.getDataList(exportExcelReqVO));
    }

    @ApiOperation(value="\u4e0b\u8f7d\u8d26\u5355")
    @GetMapping(value={"/downloadAllBill"})
    public void downloadAllBill(HttpServletResponse response) throws IOException {
        response.setContentType("application/vnd.ms-excel");
        response.setCharacterEncoding(Consts.UTF_8.name());
        String fileName = URLEncoder.encode("\u8d26\u5355\u4fe1\u606f" + System.currentTimeMillis(), Consts.UTF_8.name());
        response.setHeader("Content-disposition", "attachment;filename=" + fileName + ".xlsx");
        EasyExcel.write((OutputStream)response.getOutputStream()).head(this.billInfoService.getAllHead()).sheet("\u8d26\u5355\u4fe1\u606f").doWrite(this.billInfoService.getAllDataList());
    }

    @ApiOperation(value="\u6279\u91cf\u4fee\u6539\u6536\u76ca")
    @PostMapping(value={"/batch_update_Income"})
    public BaseResponse batchUpdateIncome(@RequestBody @Validated BatchUpdateIncomeReqVO batchUpdateIncomeReqVO, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            String errorMessage = bindingResult.getFieldError().getDefaultMessage();
            return BaseResponse.error((String)errorMessage);
        }
        this.billInfoService.batchUpdateIncome(batchUpdateIncomeReqVO);
        return BaseResponse.success();
    }
}

