/*
 * Decompiled with CFR 0.152.
 */
package com.byh.controller.allocation;

import com.byh.pojo.vo.allocation.resp.AddMultipleVO;
import com.byh.pojo.vo.allocation.resp.MultipleDTO;
import com.byh.service.allocation.MultipleAccountRuleService;
import com.ebaiyihui.framework.response.BaseResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u89c4\u5219\u914d\u7f6e"})
@RestController
@RequestMapping(value={"/api/multiple"}, produces={"application/json;charset:UTF-8"})
public class MultipleController {
    private static final Logger log = LoggerFactory.getLogger(MultipleController.class);
    @Autowired
    private MultipleAccountRuleService multipleAccountRuleService;

    @ApiOperation(value="\u65b0\u589e\u5206\u8d26\u89c4\u5219")
    @PostMapping(value={"/addMultiple"})
    public BaseResponse<String> addMultiple(@RequestBody AddMultipleVO addMultipleVO) {
        return this.multipleAccountRuleService.addMultiple(addMultipleVO);
    }

    @ApiOperation(value="\u4fee\u6539\u5206\u8d26\u89c4\u5219")
    @PostMapping(value={"/updateMultiple"})
    public BaseResponse<String> updateMultiple(@RequestBody AddMultipleVO addMultipleVO) {
        return this.multipleAccountRuleService.updateMultiple(addMultipleVO);
    }

    @ApiOperation(value="\u5206\u8d26\u89c4\u5219\u5217\u8868")
    @PostMapping(value={"/getList"})
    public BaseResponse<List<MultipleDTO>> getList(@RequestParam(value="pageIndex", required=false, defaultValue="1") Integer pageIndex, @RequestParam(value="pageSize", required=false, defaultValue="10") Integer pageSize, @RequestParam(value="type", required=true, defaultValue="10") Integer type, @RequestParam(value="search", required=false, defaultValue="") String search) {
        if (pageIndex == null) {
            log.error("pageIndex\u4e0d\u80fd\u4e3a\u7a7a...");
            return BaseResponse.error((String)"pageIndex\u4e0d\u80fd\u4e3a\u7a7a...");
        }
        if (pageSize == null) {
            log.error("pageSize\u4e0d\u80fd\u4e3a\u7a7a...");
            return BaseResponse.error((String)"pageSize\u4e0d\u80fd\u4e3a\u7a7a...");
        }
        return this.multipleAccountRuleService.getList(pageIndex, pageSize, search, type);
    }

    @ApiOperation(value="\u5206\u8d26\u89c4\u5219\u5220\u9664")
    @PostMapping(value={"/deleteMultiple"})
    public BaseResponse<String> deleteMultiple(@RequestParam(value="multipleId", required=true, defaultValue="") Long multipleId) {
        return this.multipleAccountRuleService.deleteMultiple(multipleId);
    }
}

