/*
 * Decompiled with CFR 0.152.
 */
package com.byh.controller.consultation;

import com.byh.common.ResultInfo;
import com.byh.controller.BaseController;
import com.byh.enums.BaseStatusEnum;
import com.byh.enums.ReturnCodeEnum;
import com.byh.manage.consultation.BusinessManage;
import com.byh.manage.consultation.ConsultationManager;
import com.byh.manage.consultation.ConsultationReportManager;
import com.byh.manage.consultation.TRTCManage;
import com.byh.pojo.entity.consultation.ConsultationEntity;
import com.byh.pojo.entity.consultation.ConsultationExtendEntity;
import com.byh.service.cosultation.ConsultationExtendService;
import com.byh.service.cosultation.ConsultationService;
import com.byh.service.cosultation.DoctorBillInfoService;
import com.byh.util.StringUtil;
import com.ebaiyihui.framework.response.BaseResponse;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/business/v2"}, produces={"application/json;charset:UTF-8"})
public class BusinessController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(BusinessController.class);
    @Autowired
    private ConsultationManager consultationManager;
    @Autowired
    private DoctorBillInfoService doctorBillInfoService;
    @Autowired
    private ConsultationReportManager consultationReportManager;
    @Autowired
    private BusinessManage businessManage;
    @Autowired
    private ConsultationExtendService consultationExtendService;
    @Autowired
    private ConsultationService consultationService;
    @Autowired
    private TRTCManage trtcManage;

    @PostMapping(value={"/directAccountEntry"})
    public BaseResponse<String> directAccountEntry(@RequestParam(value="orderIds", defaultValue="") String ids, @RequestParam(value="needCheck", defaultValue="=-1") Integer needChek) {
        if (needChek == null) {
            return BaseResponse.error((String)"\u662f\u5426\u9700\u8981\u6821\u9a8c\u8ba2\u5355\u5408\u683c\u53c2\u6570\u672a\u4f20");
        }
        List list = Stream.of(ids.split(",")).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(list)) {
            for (String orderViewId : list) {
                ConsultationEntity consultationEntity = this.consultationManager.getByViewId(orderViewId.trim());
                ConsultationExtendEntity consultationExtendEntity = this.consultationExtendService.queryByConsultationId(consultationEntity.getId());
                Boolean verifyCheck = BaseStatusEnum.STATUS_VALID.getValue().equals(needChek) ? Boolean.TRUE : Boolean.FALSE;
                Boolean flag = Boolean.FALSE;
                if (verifyCheck.booleanValue()) {
                    try {
                        flag = this.consultationManager.detailElementCheck(consultationEntity, consultationExtendEntity);
                    }
                    catch (Exception e) {
                        log.error(e.getMessage(), (Throwable)e);
                    }
                }
                if (!flag.booleanValue() && !BaseStatusEnum.STATUS_INVALID.getValue().equals(needChek)) continue;
                this.consultationReportManager.recorded(consultationEntity, consultationExtendEntity);
            }
        }
        return BaseResponse.success((Object)"\u5165\u8d26\u6210\u529f");
    }

    @ApiOperation(value="\u751f\u4ea7\u73af\u5883\u4f7f\u7528\u67e5\u627e\u89c6\u9891\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(value="\u8ba2\u5355\u7684viewId", name="orderViewId", required=true, dataType="string", paramType="query")})
    @GetMapping(value={"/getVedioUrlByStreamId"})
    public ResultInfo<Map<String, String>> getVedioUrlByStreamId(@RequestParam(value="orderViewId", defaultValue="0") String orderViewId) {
        ConsultationEntity consultationEntity = this.consultationManager.getByViewId(orderViewId);
        if (consultationEntity != null) {
            Map map = this.businessManage.getVideoDetailL(consultationEntity);
            log.info("=====\u4ece\u8865\u507f\u89c6\u9891\u673a\u5236\u4e2d\u83b7\u53d6\u5f55\u5236\u89c6\u9891\uff0c\u8ba2\u5355id\u662f:{}", (Object)(consultationEntity.getId() + "====\u83b7\u53d6\u5230\u7684\u89c6\u9891map\u662f\u8fd9\u4e2a:{}"), (Object)map.toString());
            return this.returnSucceed((Object)map, ReturnCodeEnum.SUCCEED.getDisplay());
        }
        return this.returnFailure("\u8ba2\u5355\u4e0d\u5b58\u5728");
    }

    @PostMapping(value={"/saveOrUpdateSignCode"})
    public BaseResponse<String> saveOrUpdateSignCode(@RequestParam(value="appCode", defaultValue="") String appCode, @RequestParam(value="signCode", defaultValue="") String signCode) {
        if (StringUtil.isBlank((String)appCode) || StringUtil.isBlank((String)signCode)) {
            return BaseResponse.error((String)"appCode\u6216\u8005signCode\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.businessManage.saveOrUpdateSignCode(appCode, signCode);
    }

    @GetMapping(value={"/getSignCodeByAppCode"})
    public BaseResponse<String> getSignCode(@RequestParam(value="appCode", defaultValue="") String appCode) {
        return this.businessManage.getSignCodeByAppCode(appCode);
    }

    @PostMapping(value={"/replenishVideoInfo"})
    public BaseResponse<String> replenishVideoInfo(@RequestParam(value="beginTime", defaultValue="") String beginTime, @RequestParam(value="endTime", defaultValue="") String endTime) {
        if (StringUtil.isBlank((String)beginTime) || StringUtil.isBlank((String)endTime)) {
            return BaseResponse.error((String)"\u5f00\u59cb\u65f6\u95f4\u6216\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List consultationEntityList = this.consultationService.getVideoTimeEmptyOrders(beginTime = beginTime + " 00:00:00", endTime = endTime + " 23:59:59");
        if (CollectionUtils.isNotEmpty((Collection)consultationEntityList)) {
            for (ConsultationEntity consultationEntity : consultationEntityList) {
                Long duration = 0L;
                try {
                    Map videoFilesMap = this.trtcManage.getDoctorVideoFileds(consultationEntity);
                    List expertVideoList = (List)videoFilesMap.get("expertVideoFileId");
                    if (CollectionUtils.isNotEmpty((Collection)expertVideoList)) {
                        duration = this.trtcManage.getTotalVideoDuration(expertVideoList);
                    } else {
                        List doctorVideoList = (List)videoFilesMap.get("doctorVideoFileId");
                        if (CollectionUtils.isNotEmpty((Collection)doctorVideoList)) {
                            duration = this.trtcManage.getTotalVideoDuration(doctorVideoList);
                        }
                    }
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
                this.consultationExtendService.updateVideoTimeByOrder(consultationEntity.getId(), duration.toString());
            }
        }
        return BaseResponse.success((Object)"\u6b64\u65f6\u95f4\u6bb5\u5237\u5e93\u6210\u529f");
    }

    @PostMapping(value={"/refreshNotQualifiedOrders"})
    public BaseResponse<String> refreshNotQualifiedOrders(@RequestParam(value="beginTime", defaultValue="") String beginTime, String endTime) {
        if (StringUtil.isBlank((String)beginTime) || StringUtil.isBlank((String)endTime)) {
            return BaseResponse.error((String)"\u5f00\u59cb\u65f6\u95f4\u6216\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        List consultationEntityList = this.consultationService.getNotQualifiedOrders(beginTime + " 00:00:00", endTime + " 23:59:59");
        if (CollectionUtils.isNotEmpty((Collection)consultationEntityList)) {
            for (ConsultationEntity consultationEntity : consultationEntityList) {
                ConsultationExtendEntity extendEntity = this.consultationExtendService.queryByConsultationId(consultationEntity.getId());
                try {
                    if (StringUtil.isBlank((String)extendEntity.getVideoUrl())) {
                        this.consultationReportManager.compensateVideo(consultationEntity, extendEntity);
                    }
                    if (!this.consultationManager.detailElementCheck(consultationEntity, extendEntity).booleanValue()) continue;
                    extendEntity.setQualified(BaseStatusEnum.STATUS_VALID.getValue());
                    this.consultationExtendService.update(extendEntity);
                    this.consultationReportManager.recorded(consultationEntity, extendEntity);
                }
                catch (Exception e) {
                    log.error("\u5b9a\u65f6\u68c0\u67e5\u8ba2\u5355\u662f\u5426\u5408\u683c\uff0c\u51fa\u9519\u7684\u8ba2\u5355\u7f16\u53f7\u662f:{}", (Object)consultationEntity.getId(), (Object)e);
                }
            }
        }
        return BaseResponse.success((Object)"\u539f\u56e0\u5237\u65b0\u6210\u529f");
    }
}

