/*
 * Decompiled with CFR 0.152.
 */
package com.byh.controller.consultation;

import com.alibaba.excel.EasyExcel;
import com.byh.common.ResultInfo;
import com.byh.controller.BaseController;
import com.byh.enums.ConfigurationEnum;
import com.byh.enums.OrderStatusEnum;
import com.byh.enums.OrderTypeEnum;
import com.byh.enums.ReturnCodeEnum;
import com.byh.exception.PushInfoException;
import com.byh.manage.consultation.ConsultationManager;
import com.byh.manage.consultation.ConsultationReportManager;
import com.byh.manage.consultation.OrderPayManage;
import com.byh.manage.consultation.ProgramMessageManager;
import com.byh.manage.consultation.RemoteManage;
import com.byh.manage.consultation.ShortMessageManager;
import com.byh.manage.consultation.TRTCManage;
import com.byh.manage.consultation.WebAndAppMessageManager;
import com.byh.pojo.bo.consultation.HosManageOrderDto;
import com.byh.pojo.bo.consultation.OrderDetailDto;
import com.byh.pojo.bo.consultation.PatientInfoDto;
import com.byh.pojo.entity.consultation.ConsultationEntity;
import com.byh.pojo.entity.consultation.ConsultationSpecialConfiguration;
import com.byh.pojo.vo.consultation.AppOrderListVo;
import com.byh.pojo.vo.consultation.ConsultationPatientCaseInfoVO;
import com.byh.pojo.vo.consultation.ConsultationVO;
import com.byh.pojo.vo.consultation.ExcelParamVo;
import com.byh.pojo.vo.consultation.ExpertAcceptVO;
import com.byh.pojo.vo.consultation.FinishConsultationVO;
import com.byh.pojo.vo.consultation.ImproveOrderResVO;
import com.byh.pojo.vo.consultation.JoinRoomVO;
import com.byh.pojo.vo.consultation.OrderReqVo;
import com.byh.pojo.vo.consultation.PatientSignatureRelationshipVO;
import com.byh.pojo.vo.consultation.PatientSignatureVO;
import com.byh.pojo.vo.consultation.StartConsultationVO;
import com.byh.pojo.vo.consultation.TransferReqVO;
import com.byh.pojo.vo.consultation.TransferResVO;
import com.byh.pojo.vo.consultation.WechatConsultationVO;
import com.byh.pojo.vo.consultation.excel.ConsultationDataInfoVO;
import com.byh.pojo.vo.consultation.req.AfreshAuditVO;
import com.byh.pojo.vo.consultation.req.ReceiptVO;
import com.byh.service.cosultation.CommonService;
import com.byh.service.cosultation.ConsultationSpecialConfigurationService;
import com.byh.util.DateTimeUtil;
import com.byh.util.StringUtil;
import com.doctoruser.api.pojo.vo.basedata.doctor.DoctorEntityInfoVO;
import com.ebaiyihui.framework.response.BaseResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Consts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u8ba2\u5355\u670d\u52a1"})
@RestController
@RequestMapping(value={"/api/v1/consultation"}, produces={"application/json;charset:UTF-8"})
public class ConsultationController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(ConsultationController.class);
    @Autowired
    private ConsultationManager consultationManager;
    @Autowired
    private RemoteManage remoteManage;
    @Autowired
    private WebAndAppMessageManager webAndAppMessageManager;
    @Autowired
    private ShortMessageManager shortMessageManager;
    @Autowired
    private ProgramMessageManager programMessageManager;
    @Autowired
    private ConsultationSpecialConfigurationService consultationSpecialConfigurationService;
    @Autowired
    private ConsultationReportManager consultationReportManager;
    @Autowired
    private TRTCManage trtcManage;
    @Autowired
    private OrderPayManage orderPayManage;
    @Autowired
    private CommonService commonService;
    private static final String SHEET_NAME = "\u4f1a\u8bca\u6570\u636e\u4fe1\u606f";

    @ApiOperation(value="web\u7aef+app\u7aef\u4f1a\u8bca\u7533\u8bf7")
    @PostMapping(value={"/addOrder"})
    @Transactional(rollbackFor={Exception.class}, noRollbackFor={PushInfoException.class})
    public ResultInfo<ConsultationEntity> saveConsultation(@RequestBody ConsultationVO consultationVO) {
        if (consultationVO.getTencentRong() == null || consultationVO.getTencentRong().equals(1)) {
            return this.returnFailure("\u5f53\u524dAPP\u7248\u672c\u592a\u4f4e\u65e0\u6cd5\u4e0b\u5355\uff0c\u8bf7\u60a8\u5347\u7ea7APP!");
        }
        Map map = this.consultationManager.saveConsultation(consultationVO);
        if (ReturnCodeEnum.SUCCEED.getValue().equalsIgnoreCase((String)map.get("code"))) {
            ConsultationEntity consultationEntity = this.consultationManager.getByViewId((String)map.get("viewId"));
            try {
                this.shortMessageManager.remindUserSignName(consultationEntity, consultationVO.getMobileNumber());
                this.shortMessageManager.doctorHaveSubmitApply(consultationEntity);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            return this.returnSucceed((Object)consultationEntity, ReturnCodeEnum.SUCCEED.getDisplay());
        }
        return this.returnFailure((String)map.get("msg"));
    }

    @ApiOperation(value="\u67e5\u8be2\u8ba2\u5355")
    @GetMapping(value={"/query_consultation_by_id"})
    public ResultInfo queryConsultationById(@RequestParam(value="id") Long id) {
        if (id == 0L || id == null) {
            log.error("id\u4e0d\u80fd\u4e3a\u7a7a\u6216\u8005\u4e3a0...");
            return this.returnFailure("id\u4e0d\u80fd\u4e3a\u7a7a\u6216\u8005\u4e3a0...");
        }
        ConsultationEntity consultationEntity = this.consultationManager.queryConsultationEntityById(id);
        if (consultationEntity == null) {
            return this.returnFailure("\u672a\u67e5\u8be2\u5230\u8ba2\u5355...");
        }
        return this.returnSucceed((Object)consultationEntity, "\u67e5\u8be2\u8ba2\u5355\u6210\u529f!");
    }

    @ApiOperation(value="\u67e5\u8be2\u533b\u751f\u8ba2\u5355\u5217\u8868")
    @GetMapping(value={"/query_consultation_list_by_doctor_id"})
    public ResultInfo<List<HosManageOrderDto>> queryConsultationListByDoctorId(@RequestParam(value="pageIndex", required=false, defaultValue="1") Integer pageIndex, @RequestParam(value="pageSize", required=false, defaultValue="10") Integer pageSize, @RequestParam(value="doctorId", defaultValue="0") Long doctorId, @RequestParam(value="beginTime", required=false, defaultValue="") String beginTime, @RequestParam(value="endTime", required=false, defaultValue="") String endTime, @RequestParam(value="type", required=false, defaultValue="0") Integer type, @RequestParam(value="status", required=false, defaultValue="0") Integer status, @RequestParam(value="isSponsor", defaultValue="1") Integer isSponsor, @RequestParam(value="search", required=false, defaultValue="") String search) {
        if (doctorId == null || doctorId == 0L) {
            return this.returnFailure("doctorId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (isSponsor == null || isSponsor == 0) {
            return this.returnFailure("isSponsor\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (pageIndex == null) {
            log.error("pageIndex\u4e0d\u80fd\u4e3a\u7a7a...");
            return this.returnFailure("pageIndex\u4e0d\u80fd\u4e3a\u7a7a...");
        }
        if (pageSize == null) {
            log.error("pageSize\u4e0d\u80fd\u4e3a\u7a7a...");
            return this.returnFailure("pageSize\u4e0d\u80fd\u4e3a\u7a7a...");
        }
        return this.consultationManager.queryConsultationListByDoctorId(pageIndex, pageSize, doctorId, beginTime, endTime, type, status, isSponsor, search);
    }

    @ApiOperation(value="\u7efc\u5408\u7ba1\u7406\u5e73\u53f0\u4f1a\u8bca\u8ba2\u5355\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageIndex", value="\u5f53\u524d\u9875", required=false, defaultValue="1", dataType="int", paramType="query"), @ApiImplicitParam(name="pageSize", value="\u6bcf\u9875\u6761\u6570", required=false, defaultValue="10", dataType="int", paramType="query"), @ApiImplicitParam(name="search", value="\u6a21\u7cca\u5173\u952e\u5b57", required=false, dataType="String", paramType="query"), @ApiImplicitParam(name="beginTime", value="\u5f00\u59cb\u65e5\u671f", required=false, dataType="String", paramType="query"), @ApiImplicitParam(name="endTime", value="\u7ed3\u675f\u65e5\u671f", required=false, dataType="String", paramType="query"), @ApiImplicitParam(name="depName", value="\u79d1\u5ba4\u540d\u79f0", required=false, dataType="String", paramType="query"), @ApiImplicitParam(name="status", value="\u8ba2\u5355\u72b6\u6001", required=false, dataType="int", paramType="query"), @ApiImplicitParam(name="isSponsor", value="1:\u7533\u8bf72:\u63a5\u8bca,3:\u5168\u90e8", required=true, dataType="int", paramType="query")})
    @PostMapping(value={"/query_hospitalManage_order_byHospitalId"})
    public ResultInfo<List<HosManageOrderDto>> queryHospitalManageOrderByHospitalId(@RequestHeader(value="userId", defaultValue="0") String userId, @RequestHeader(value="appCode", defaultValue="") String appCode, @RequestParam(value="pageIndex", required=false, defaultValue="1") Integer pageIndex, @RequestParam(value="pageSize", required=false, defaultValue="10") Integer pageSize, @RequestParam(value="search", required=false, defaultValue="") String search, @RequestParam(value="beginTime", required=false, defaultValue="") String beginTime, @RequestParam(value="endTime", required=false, defaultValue="") String endTime, @RequestParam(value="depName", required=false, defaultValue="") String depName, @RequestParam(value="status", required=false, defaultValue="0") Integer status, @RequestParam(value="isSponsor", defaultValue="3") Integer isSponsor, @RequestParam(value="applicationChannels", defaultValue="0") Integer applicationChannels) {
        return this.consultationManager.queryHospitalManageOrderByHospitalId(appCode, userId, pageIndex, pageSize, search, beginTime, endTime, depName, status, isSponsor, applicationChannels);
    }

    @ApiOperation(value="\u4e0b\u5355,\u60a3\u8005\u4fe1\u606f\u96c6\u5408")
    @ApiImplicitParams(value={@ApiImplicitParam(name="doctorId", value="\u533b\u751fid", required=true, dataType="long", paramType="query"), @ApiImplicitParam(name="pageIndex", value="\u5f53\u524d\u9875", required=false, defaultValue="1", dataType="int", paramType="query"), @ApiImplicitParam(name="pageSize", value="\u6bcf\u9875\u6761\u6570", required=false, defaultValue="10", dataType="int", paramType="query")})
    @GetMapping(value={"/query_patientInfo_list"})
    public ResultInfo<List<PatientInfoDto>> queryPatientInfoList(@RequestParam(value="doctorId", defaultValue="0") Long doctorId, @RequestParam(value="pageIndex", required=false, defaultValue="1") Integer pageIndex, @RequestParam(value="pageSize", required=false, defaultValue="10") Integer pageSize) {
        return this.consultationManager.queryPatientInfoList(doctorId, pageIndex, pageSize);
    }

    @ApiOperation(value="\u4e0a\u4f20\u7b7e\u7f72\u7167\u7247")
    @ApiImplicitParams(value={@ApiImplicitParam(name="orderId", value="\u8ba2\u5355id", required=true, dataType="long", paramType="query"), @ApiImplicitParam(name="patientSignature", value="\u7b7e\u540d", required=true, dataType="String", paramType="query")})
    @PostMapping(value={"/update_patient_signature"})
    @Transactional(rollbackFor={Exception.class})
    public ResultInfo updatePatientSignature(@RequestParam(value="orderId", defaultValue="0") Long orderId, @RequestParam(value="patientSignature", defaultValue="") String patientSignature) {
        if (orderId == null || orderId.intValue() == 0) {
            return this.returnFailure("\u8ba2\u5355id\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        if (patientSignature == null || patientSignature.equals("")) {
            return this.returnFailure("\u7b7e\u540d\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        return this.consultationManager.updatePatientSignature(orderId, patientSignature);
    }

    @ApiOperation(value="\u4e0a\u4f20\u7b7e\u7f72\u7167\u7247")
    @ApiImplicitParams(value={@ApiImplicitParam(name="orderId", value="\u8ba2\u5355id", required=true, dataType="long", paramType="query"), @ApiImplicitParam(name="patientSignature", value="\u7b7e\u540d", required=true, dataType="String", paramType="query")})
    @PostMapping(value={"/v1/update_patient_signature"})
    @Transactional(rollbackFor={Exception.class})
    public ResultInfo updatePatientSignature2(@RequestBody PatientSignatureVO patientSignatureVO) {
        if (patientSignatureVO.getOrderId() == null || patientSignatureVO.getOrderId().intValue() == 0) {
            return this.returnFailure("\u8ba2\u5355id\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        if (patientSignatureVO.getPatientSignature() == null || patientSignatureVO.getPatientSignature().equals("")) {
            return this.returnFailure("\u7b7e\u540d\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        return this.consultationManager.updatePatientSignature(patientSignatureVO.getOrderId(), patientSignatureVO.getPatientSignature());
    }

    @ApiOperation(value="\u5728\u7ebf\u7b7e\u7f72")
    @ApiImplicitParams(value={@ApiImplicitParam(name="orderId", value="\u8ba2\u5355id", required=true, dataType="long", paramType="query"), @ApiImplicitParam(name="patientSignature", value="\u7b7e\u540d", required=true, dataType="String", paramType="query"), @ApiImplicitParam(name="patientSignerRelationship", value="\u60a3\u8005\u4e0e\u7b7e\u540d\u8005\u7684\u5173\u7cfb", required=true, dataType="int", paramType="query")})
    @PostMapping(value={"/update_patient_signature_relationship"})
    @Transactional(rollbackFor={Exception.class})
    public ResultInfo updatePatientSignatureRelationship(@RequestParam(value="orderId", defaultValue="0") Long orderId, @RequestParam(value="patientSignature", defaultValue="") String patientSignature, @RequestParam(value="patientSignerRelationship", defaultValue="1") Integer patientSignerRelationship) {
        if (orderId == null || orderId.intValue() == 0) {
            return this.returnFailure("\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (patientSignature == null || patientSignature.equals("")) {
            return this.returnFailure("\u7b7e\u540d\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        if (patientSignerRelationship == null || patientSignerRelationship == 0) {
            return this.returnFailure("\u5173\u7cfb\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        return this.consultationManager.updatePatientSignatureRelationship(orderId, patientSignature, patientSignerRelationship);
    }

    @ApiOperation(value="\u5728\u7ebf\u7b7e\u7f72")
    @ApiImplicitParams(value={@ApiImplicitParam(name="orderId", value="\u8ba2\u5355id", required=true, dataType="long", paramType="query"), @ApiImplicitParam(name="patientSignature", value="\u7b7e\u540d", required=true, dataType="String", paramType="query"), @ApiImplicitParam(name="patientSignerRelationship", value="\u60a3\u8005\u4e0e\u7b7e\u540d\u8005\u7684\u5173\u7cfb", required=true, dataType="int", paramType="query")})
    @PostMapping(value={"/v1/update_patient_signature_relationship"})
    @Transactional(rollbackFor={Exception.class})
    public ResultInfo updatePatientSignatureRelationship(@RequestBody PatientSignatureRelationshipVO patientSignatureRelationshipVO) {
        if (patientSignatureRelationshipVO.getOrderId() == null || patientSignatureRelationshipVO.getOrderId().intValue() == 0) {
            return this.returnFailure("\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (patientSignatureRelationshipVO.getPatientSignature() == null || patientSignatureRelationshipVO.getPatientSignature().equals("")) {
            return this.returnFailure("\u7b7e\u540d\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        if (patientSignatureRelationshipVO.getPatientSignerRelationship() == null || patientSignatureRelationshipVO.getPatientSignerRelationship() == 0) {
            return this.returnFailure("\u5173\u7cfb\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        return this.consultationManager.updatePatientSignatureRelationship(patientSignatureRelationshipVO.getOrderId(), patientSignatureRelationshipVO.getPatientSignature(), patientSignatureRelationshipVO.getPatientSignerRelationship());
    }

    @ApiOperation(value="\u4e13\u5bb6\u63a5\u8bca")
    @ApiImplicitParams(value={@ApiImplicitParam(name="orderId", value="\u8ba2\u5355id", required=true, dataType="long", paramType="query")})
    @PostMapping(value={"/order_expert_accept"})
    @Transactional(rollbackFor={Exception.class}, noRollbackFor={PushInfoException.class})
    public ResultInfo orderExpertAccept(@RequestParam(value="orderId", defaultValue="0") Long orderId) {
        if (orderId == null || orderId.intValue() == 0) {
            return this.returnFailure("\u8ba2\u5355id\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002\u3002\u3002");
        }
        ResultInfo resultInfo = this.consultationManager.orderExpertAccept(orderId);
        if (resultInfo.getCode().equals("1")) {
            ConsultationEntity consultationEntity = this.consultationManager.queryConsultationEntityById(orderId);
            if (consultationEntity.getType().intValue() == OrderTypeEnum.TYPE_VEDIO.getValue().intValue()) {
                this.trtcManage.saveRtcRoomId(consultationEntity.getId());
            }
            try {
                this.webAndAppMessageManager.orderExpertAcceptSendMessage(orderId, "", "", "");
                String acceptTime = DateTimeUtil.formatTime((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss");
                this.programMessageManager.expertAcceptPush(consultationEntity, acceptTime);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return resultInfo;
    }

    @ApiOperation(value="\u4e13\u5bb6\u63a5\u8bca")
    @ApiImplicitParams(value={@ApiImplicitParam(name="orderId", value="\u8ba2\u5355id", required=true, dataType="long", paramType="query")})
    @PostMapping(value={"/v1/order_expert_accept"})
    @Transactional(rollbackFor={Exception.class}, noRollbackFor={PushInfoException.class})
    public ResultInfo orderExpertAccept2(@RequestBody ExpertAcceptVO expertAcceptVO) {
        if (expertAcceptVO.getOrderId() == null || expertAcceptVO.getOrderId().intValue() == 0) {
            return this.returnFailure("\u8ba2\u5355id\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002\u3002\u3002");
        }
        ResultInfo resultInfo = this.consultationManager.orderExpertAccept(expertAcceptVO.getOrderId());
        if (resultInfo.getCode().equals("1")) {
            ConsultationEntity consultationEntity = this.consultationManager.queryConsultationEntityById(expertAcceptVO.getOrderId());
            if (consultationEntity.getType().intValue() == OrderTypeEnum.TYPE_VEDIO.getValue().intValue()) {
                this.trtcManage.saveRtcRoomId(consultationEntity.getId());
            }
            try {
                this.webAndAppMessageManager.orderExpertAcceptSendMessage(expertAcceptVO.getOrderId(), "", "", "");
                String acceptTime = DateTimeUtil.formatTime((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss");
                this.programMessageManager.expertAcceptPush(consultationEntity, acceptTime);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return resultInfo;
    }

    @ApiOperation(value="\u533b\u9662\u7ba1\u7406+\u8d85\u7ba1\u540e\u53f0_\u4e13\u5bb6\u5206\u914d")
    @ApiImplicitParams(value={@ApiImplicitParam(name="orderIds", value="\u8ba2\u5355ids", required=true, dataType="String", paramType="query"), @ApiImplicitParam(name="orderType", value="\u8ba2\u5355\u7c7b\u578b", required=true, dataType="int", paramType="query"), @ApiImplicitParam(name="expertId", value="\u4e13\u5bb6id", required=true, dataType="long", paramType="query"), @ApiImplicitParam(name="expertType", value="\u4e13\u5bb6\u7c7b\u578b", required=true, dataType="int", paramType="query"), @ApiImplicitParam(name="expertName", value="\u4e13\u5bb6name", required=true, dataType="String", paramType="query"), @ApiImplicitParam(name="expertDepId", value="\u4e13\u5bb6\u79d1\u5ba4id", required=true, dataType="long", paramType="query"), @ApiImplicitParam(name="expertDepName", value="\u4e13\u5bb6\u79d1\u5ba4name", required=true, dataType="String", paramType="query"), @ApiImplicitParam(name="expertHosId", value="\u4e13\u5bb6\u533b\u9662id", dataType="long", paramType="query"), @ApiImplicitParam(name="expertHosName", value="\u4e13\u5bb6\u533b\u9662name", dataType="String", paramType="query"), @ApiImplicitParam(name="consultationDate", value="\u4f1a\u8bca\u65f6\u95f4", required=true, dataType="String", paramType="query")})
    @PostMapping(value={"/hospitalManage_order_distribution"})
    @Transactional(rollbackFor={Exception.class}, noRollbackFor={PushInfoException.class})
    public ResultInfo hospitalManageOrderDistribution(@RequestParam(value="orderIds", defaultValue="") String orderIds, @RequestParam(value="orderType", defaultValue="0") Integer orderType, @RequestParam(value="expertId", defaultValue="0") Long expertId, @RequestParam(value="expertType", defaultValue="0") Integer expertType, @RequestParam(value="expertName", defaultValue="") String expertName, @RequestParam(value="expertDepId", defaultValue="0") Long expertDepId, @RequestParam(value="expertDepName", defaultValue="") String expertDepName, @RequestParam(value="expertHosId", required=false, defaultValue="0") Long expertHosId, @RequestParam(value="expertHosName", required=false, defaultValue="") String expertHosName, @RequestParam(value="consultationDate", defaultValue="") String consultationDate) {
        if (orderIds == null || orderIds.equals("")) {
            return this.returnFailure("\u8ba2\u5355ids\u9519\u8bef");
        }
        if (orderType == null || orderType == 0) {
            return this.returnFailure("\u8ba2\u5355\u7c7b\u578b\u9519\u8bef");
        }
        if (expertId == null || expertId.intValue() == 0) {
            return this.returnFailure("\u4e13\u5bb6id\u9519\u8bef");
        }
        if (expertName == null || expertName.equals("")) {
            return this.returnFailure("\u5206\u914d\u4e13\u5bb6\u540d\u79f0\u4e3a\u7a7a");
        }
        if (expertDepId == null || expertDepId.intValue() == 0) {
            return this.returnFailure("\u4e13\u5bb6\u79d1\u5ba4id\u9519\u8bef");
        }
        if (expertDepName == null || expertDepName.equals("")) {
            return this.returnFailure("\u4e13\u5bb6\u79d1\u5ba4\u540d\u79f0\u9519\u8bef");
        }
        if (expertHosId == null || expertHosId.intValue() == 0) {
            return this.returnFailure("\u4e13\u5bb6\u533b\u9662id\u9519\u8bef");
        }
        if (expertHosName == null || expertHosName.equals("")) {
            return this.returnFailure("\u4e13\u5bb6\u533b\u9662\u540d\u79f0\u9519\u8bef");
        }
        ResultInfo resultInfo = null;
        try {
            resultInfo = this.consultationManager.hospitalManageOrderDistribution(orderIds, orderType, expertId, expertType, expertName, expertDepId, expertDepName, expertHosId, expertHosName, consultationDate);
        }
        catch (Exception e) {
            log.error("hospitalManageOrderDistribution", (Throwable)e);
        }
        return resultInfo;
    }

    @ApiOperation(value="\u5b8c\u6210\u4f1a\u8bca\u670d\u52a1")
    @ApiImplicitParams(value={@ApiImplicitParam(name="orderId", value="\u8ba2\u5355id", required=true, dataType="Long", paramType="query"), @ApiImplicitParam(name="userId", value="\u4f1a\u8bca\u533b\u751fid", required=true, dataType="Long", paramType="query")})
    @PostMapping(value={"/finishConsultaion"})
    @Transactional(rollbackFor={Exception.class}, noRollbackFor={PushInfoException.class})
    public ResultInfo<Map<String, Object>> finishConsultation(@RequestParam(value="orderId", defaultValue="0") Long orderId, @RequestParam(value="userId", defaultValue="0") Long userId) {
        ConsultationEntity consultationEntity = this.consultationManager.queryConsultationEntityById(orderId);
        if (consultationEntity != null) {
            consultationEntity.setStatus(OrderStatusEnum.FINISH.getValue());
            consultationEntity.setFinishTime(DateTimeUtil.formatTime((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
            log.info("consultationEntity:" + consultationEntity);
            int value = this.consultationManager.updateConsultation(consultationEntity);
            if (value != 0) {
                ConsultationEntity consultationEntity1 = this.consultationManager.getByViewId(consultationEntity.getViewId());
                try {
                    this.webAndAppMessageManager.remindExpertWriteReportNews(consultationEntity1.getViewId());
                    this.programMessageManager.finishOrderPush(consultationEntity);
                    if (StringUtils.isNotEmpty((CharSequence)consultationEntity.getGroupId())) {
                        this.commonService.tencentDestroyGroupMsg(consultationEntity);
                    }
                }
                catch (Exception e) {
                    log.error("finishConsultation", (Throwable)e);
                }
                return this.returnSucceed(ReturnCodeEnum.SUCCEED.getDisplay());
            }
            return this.returnFailure(ReturnCodeEnum.FAILURE.getDisplay());
        }
        return this.returnFailure(ReturnCodeEnum.FAILURE.getDisplay());
    }

    @ApiOperation(value="\u5b8c\u6210\u4f1a\u8bca\u670d\u52a1")
    @ApiImplicitParams(value={@ApiImplicitParam(name="orderId", value="\u8ba2\u5355id", required=true, dataType="Long", paramType="query"), @ApiImplicitParam(name="userId", value="\u4f1a\u8bca\u533b\u751fid", required=true, dataType="Long", paramType="query")})
    @PostMapping(value={"/v1/finishConsultaion"})
    @Transactional(rollbackFor={Exception.class}, noRollbackFor={PushInfoException.class})
    public ResultInfo<Map<String, Object>> finishConsultation(@RequestBody FinishConsultationVO finishConsultationVO) {
        ConsultationEntity consultationEntity = this.consultationManager.queryConsultationEntityById(finishConsultationVO.getOrderId());
        if (consultationEntity != null) {
            consultationEntity.setStatus(OrderStatusEnum.FINISH.getValue());
            consultationEntity.setFinishTime(DateTimeUtil.formatTime((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
            log.info("consultationEntity:" + consultationEntity);
            int value = this.consultationManager.updateConsultation(consultationEntity);
            if (value != 0) {
                ConsultationEntity consultationEntity1 = this.consultationManager.getByViewId(consultationEntity.getViewId());
                try {
                    this.webAndAppMessageManager.remindExpertWriteReportNews(consultationEntity1.getViewId());
                    this.programMessageManager.finishOrderPush(consultationEntity);
                    if (StringUtils.isNotEmpty((CharSequence)consultationEntity.getGroupId())) {
                        this.commonService.tencentDestroyGroupMsg(consultationEntity);
                    }
                }
                catch (Exception e) {
                    log.error("finishConsultation", (Throwable)e);
                }
                return this.returnSucceed(ReturnCodeEnum.SUCCEED.getDisplay());
            }
            return this.returnFailure(ReturnCodeEnum.FAILURE.getDisplay());
        }
        return this.returnFailure(ReturnCodeEnum.FAILURE.getDisplay());
    }

    @ApiOperation(value="\u5f00\u59cb\u4f1a\u8bca\u670d\u52a1")
    @ApiImplicitParams(value={@ApiImplicitParam(name="orderId", value="\u8ba2\u5355id", required=true, dataType="Long", paramType="query")})
    @PostMapping(value={"/startConsultation"})
    @Transactional(rollbackFor={Exception.class}, noRollbackFor={PushInfoException.class})
    public ResultInfo<Map<String, String>> startConsultation(@RequestParam(value="orderId", defaultValue="0") Long orderId) {
        HashMap<String, String> map = new HashMap<String, String>();
        ConsultationEntity consultationEntity = this.consultationManager.queryConsultationEntityById(orderId);
        if (consultationEntity != null) {
            String systemTime = DateTimeUtil.formatTime((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss");
            String startTime = StringUtil.isBlank((String)consultationEntity.getBeginTime()) ? DateTimeUtil.formatTime((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss") : consultationEntity.getBeginTime();
            map.put("startTime", startTime);
            map.put("systemTime", systemTime);
            consultationEntity.setBeginTime(startTime);
            int value = this.consultationManager.updateConsultation(consultationEntity);
            if (value != 0) {
                if (StringUtil.isBlank((String)consultationEntity.getBeginTime())) {
                    try {
                        this.webAndAppMessageManager.startConsultationSendMessage(consultationEntity);
                        this.shortMessageManager.consultationStartedToDoctor(consultationEntity);
                    }
                    catch (Exception e) {
                        log.error("startConsultation", (Throwable)e);
                    }
                }
                return this.returnSucceed(map, ReturnCodeEnum.SUCCEED.getDisplay());
            }
            return this.returnFailure(ReturnCodeEnum.FAILURE.getDisplay());
        }
        return this.returnFailure(ReturnCodeEnum.FAILURE.getDisplay());
    }

    @ApiOperation(value="\u5f00\u59cb\u4f1a\u8bca\u670d\u52a1")
    @ApiImplicitParams(value={@ApiImplicitParam(name="orderId", value="\u8ba2\u5355id", required=true, dataType="Long", paramType="query")})
    @PostMapping(value={"/v1/startConsultation"})
    @Transactional(rollbackFor={Exception.class}, noRollbackFor={PushInfoException.class})
    public ResultInfo<Map<String, String>> startConsultation2(@RequestBody StartConsultationVO startConsultationVO) {
        HashMap<String, String> map = new HashMap<String, String>();
        ConsultationEntity consultationEntity = this.consultationManager.queryConsultationEntityById(startConsultationVO.getOrderId());
        if (consultationEntity != null) {
            String systemTime = DateTimeUtil.formatTime((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss");
            String startTime = StringUtil.isBlank((String)consultationEntity.getBeginTime()) ? DateTimeUtil.formatTime((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss") : consultationEntity.getBeginTime();
            map.put("startTime", startTime);
            map.put("systemTime", systemTime);
            consultationEntity.setBeginTime(startTime);
            int value = this.consultationManager.updateConsultation(consultationEntity);
            if (value != 0) {
                if (StringUtil.isBlank((String)consultationEntity.getBeginTime())) {
                    try {
                        this.webAndAppMessageManager.startConsultationSendMessage(consultationEntity);
                        this.shortMessageManager.consultationStartedToDoctor(consultationEntity);
                    }
                    catch (Exception e) {
                        log.error("startConsultation", (Throwable)e);
                    }
                }
                return this.returnSucceed(map, ReturnCodeEnum.SUCCEED.getDisplay());
            }
            return this.returnFailure(ReturnCodeEnum.FAILURE.getDisplay());
        }
        return this.returnFailure(ReturnCodeEnum.FAILURE.getDisplay());
    }

    @ApiOperation(value="app_\u8ba2\u5355\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageIndex", value="\u5f53\u524d\u9875", defaultValue="1", dataType="int", paramType="query"), @ApiImplicitParam(name="pageSize", value="\u6bcf\u9875\u6761\u6570", defaultValue="10", dataType="int", paramType="query"), @ApiImplicitParam(name="doctorId", value="\u533b\u751fid", required=true, defaultValue="0", dataType="Long", paramType="query"), @ApiImplicitParam(name="status", value="\u72b6\u6001", required=true, defaultValue="", dataType="int", paramType="query"), @ApiImplicitParam(name="isSponsor", value="1:\u7533\u8bf7 2:\u63a5\u8bca", required=true, defaultValue="1", dataType="int", paramType="query")})
    @GetMapping(value={"query_app_consultation_list_by_doctor_id"})
    public ResultInfo<List<HosManageOrderDto>> queryAppConsultationListByDoctorId(@RequestParam(value="pageIndex", required=false, defaultValue="1") Integer pageIndex, @RequestParam(value="pageSize", required=false, defaultValue="10") Integer pageSize, @RequestParam(value="doctorId", defaultValue="0") Long doctorId, @RequestParam(value="status", defaultValue="0") Integer status, @RequestParam(value="isSponsor", defaultValue="0") Integer isSponsor) {
        if (doctorId == null || doctorId == 0L) {
            return this.returnFailure("doctorId\u4e0d\u80fd\u4e3a\u7a7a\u6216\u8005\u4e3a0");
        }
        if (isSponsor == null || isSponsor == 0) {
            return this.returnFailure("isSponsor\u4e0d\u80fd\u4e3a\u7a7a\u6216\u8005\u4e3a0...");
        }
        return this.consultationManager.queryAppConsultationListByDoctorId(pageIndex, pageSize, doctorId, status, isSponsor);
    }

    @ApiOperation(value="\u83b7\u53d6\u65b0\u7533\u8bf7\u91cf\u548c\u4eca\u65e5\u4f1a\u8bca\u91cf")
    @ApiImplicitParams(value={@ApiImplicitParam(name="doctorId", value="\u533b\u751f\u6216\u662f\u4e13\u5bb6\u7684id", required=true, dataType="Long", paramType="query")})
    @GetMapping(value={"/getApplyCoutAndTodayConsultation"})
    public ResultInfo<Map<String, Integer>> getApplyCoutAndTodayConsultation(@RequestParam(value="doctorId", defaultValue="0") Long doctorId) {
        DoctorEntityInfoVO doctorEntityInfoVO = this.remoteManage.getDoctorDetailById(doctorId);
        if (doctorEntityInfoVO != null) {
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            int applyCount = this.consultationManager.getApplyCountByDoctorId(doctorId, OrderStatusEnum.NEW_APPLY.getValue().intValue());
            map.put("applyCount", applyCount);
            int todayConsultionCount = this.consultationManager.getDoctorConsultationCount(doctorId, OrderStatusEnum.RUNNING.getValue());
            map.put("todayConsultionCount", todayConsultionCount);
            return this.returnSucceed(map, ReturnCodeEnum.SUCCEED.getDisplay());
        }
        return this.returnFailure("\u533b\u751f\u4e0d\u5b58\u5728");
    }

    @ApiOperation(value="\u7efc\u5408\u7ba1\u7406\u5e73\u53f0\u6570\u636e\u7edf\u8ba1\u63a5\u53e3")
    @GetMapping(value={"/management/order/data"})
    public ResultInfo<Map<String, Object>> orderDataManagement(@RequestHeader(value="userId", defaultValue="0") String userId, @RequestHeader(value="appCode", defaultValue="") String appCode, @RequestParam(value="search", required=false, defaultValue="") String search, @RequestParam(value="type", required=false, defaultValue="0") Integer type, @RequestParam(value="status", required=false, defaultValue="0") Integer status, @RequestParam(value="timeType", required=false, defaultValue="0") Integer timeType, @RequestParam(value="beginTime", required=false, defaultValue="") String beginTime, @RequestParam(value="endTime", required=false, defaultValue="") String endTime, @RequestParam(value="qualified", required=false, defaultValue="0") Integer qualified, @RequestParam(value="pageIndex", defaultValue="1") Integer pageIndex, @RequestParam(value="pageSize", defaultValue="10") Integer pageSize, @RequestParam(value="applicationChannels", defaultValue="0") Integer applicationChannels) {
        return this.consultationManager.queryManageDataConsultation(userId, appCode, search, type, status, timeType, beginTime, endTime, qualified, pageIndex, pageSize, applicationChannels);
    }

    @GetMapping(value={"/superAdmin/order/data"})
    public BaseResponse<Map<String, Object>> superAdminOrderData(@RequestParam(value="search", required=false, defaultValue="") String search, @RequestParam(value="type", required=false, defaultValue="0") Integer type, @RequestParam(value="status", required=false, defaultValue="0") Integer status, @RequestParam(value="timeType", required=false, defaultValue="0") Integer timeType, @RequestParam(value="beginTime", required=false, defaultValue="") String beginTime, @RequestParam(value="endTime", required=false, defaultValue="") String endTime, @RequestParam(value="qualified", required=false, defaultValue="0") Integer qualified, @RequestParam(value="pageIndex", defaultValue="1") Integer pageIndex, @RequestParam(value="pageSize", defaultValue="10") Integer pageSize, @RequestParam(value="applicationChannels", defaultValue="0") Integer applicationChannels) {
        return BaseResponse.success((Object)this.consultationManager.superAdminOrderData(search, type, status, timeType, beginTime, endTime, qualified, pageIndex, pageSize, applicationChannels));
    }

    @ApiOperation(value="\u7efc\u5408\u7ba1\u7406\u5e73\u53f0\u5bfc\u51fa\u4f1a\u8bca\u6570\u636eexcel")
    @PostMapping(value={"/Admin/exportExcel"})
    public void exportExcel(@RequestBody ExcelParamVo excelParamVo, HttpServletResponse response) {
        response.setContentType("application/vnd.ms-excel");
        response.setCharacterEncoding(Consts.UTF_8.name());
        String fileName = "";
        String ids = excelParamVo.getIds() == null ? "" : excelParamVo.getIds();
        String search = excelParamVo.getSearch() == null ? "" : excelParamVo.getSearch();
        Integer type = excelParamVo.getType() == null ? 0 : excelParamVo.getType();
        Integer status = excelParamVo.getStatus() == null ? 0 : excelParamVo.getStatus();
        Integer timeType = excelParamVo.getTimeType() == null ? 0 : excelParamVo.getTimeType();
        String beginTime = excelParamVo.getBeginTime() == null ? "" : excelParamVo.getBeginTime();
        String endTime = excelParamVo.getEndTime() == null ? "" : excelParamVo.getEndTime();
        Integer qualified = excelParamVo.getQualified() == null ? 0 : excelParamVo.getQualified();
        String userId = excelParamVo.getUserId() == null ? "" : excelParamVo.getUserId();
        String appCode = excelParamVo.getAppCode() == null ? "" : excelParamVo.getAppCode();
        Integer applicationChannels = excelParamVo.getApplicationChannels() == null ? 0 : excelParamVo.getApplicationChannels();
        try {
            fileName = URLEncoder.encode(SHEET_NAME + System.currentTimeMillis(), Consts.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        response.setHeader("Content-disposition", "attachment;filename=" + fileName + ".xlsx");
        try {
            EasyExcel.write((OutputStream)response.getOutputStream(), ConsultationDataInfoVO.class).sheet(SHEET_NAME).doWrite(this.consultationManager.exportConsultationDataInfo(ids, appCode, search, type, status, timeType, beginTime, endTime, userId, qualified, applicationChannels));
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    @ApiOperation(value="\u8d85\u7ea7\u7ba1\u7406\u5458_\u5bfc\u51faEXCEL-\u6570\u636e\u7ba1\u7406")
    @PostMapping(value={"/Admin/superExportExcel"})
    public void superExportExcel(@RequestBody ExcelParamVo excelParamVo, HttpServletResponse response) {
        response.setContentType("application/vnd.ms-excel");
        response.setCharacterEncoding(Consts.UTF_8.name());
        String fileName = "";
        String ids = excelParamVo.getIds() == null ? "" : excelParamVo.getIds();
        String search = excelParamVo.getSearch() == null ? "" : excelParamVo.getSearch();
        Integer type = excelParamVo.getType() == null ? 0 : excelParamVo.getType();
        Integer status = excelParamVo.getStatus() == null ? 0 : excelParamVo.getStatus();
        Integer timeType = excelParamVo.getTimeType() == null ? 0 : excelParamVo.getTimeType();
        String beginTime = excelParamVo.getBeginTime() == null ? "" : excelParamVo.getBeginTime();
        String endTime = excelParamVo.getEndTime() == null ? "" : excelParamVo.getEndTime();
        Integer qualified = excelParamVo.getQualified() == null ? 0 : excelParamVo.getQualified();
        Integer applicationChannels = excelParamVo.getApplicationChannels() == null ? 0 : excelParamVo.getApplicationChannels();
        try {
            fileName = URLEncoder.encode(SHEET_NAME + System.currentTimeMillis(), Consts.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        response.setHeader("Content-disposition", "attachment;filename=" + fileName + ".xlsx");
        try {
            EasyExcel.write((OutputStream)response.getOutputStream(), ConsultationDataInfoVO.class).sheet(SHEET_NAME).doWrite(this.consultationManager.superAdminExportDataInfo(ids, search, type, status, timeType, beginTime, endTime, qualified, applicationChannels));
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    @ApiOperation(value="\u63a5\u8bca_\u56fe\u6587")
    @ApiImplicitParams(value={@ApiImplicitParam(name="orderId", value="\u8ba2\u5355id", required=true, dataType="long", paramType="query")})
    @GetMapping(value={"/accept/tuWen_expertAccept"})
    @Transactional(rollbackFor={Exception.class}, noRollbackFor={PushInfoException.class})
    public ResultInfo tuWenExpertAccept(@RequestParam(value="orderId", defaultValue="0") Long orderId) {
        if (orderId.intValue() == 0) {
            log.info("\u53c2\u6570\u9519\u8bef:\u8ba2\u5355id\u9519\u8bef=============");
            return this.returnFailure("\u53c2\u6570\u9519\u8bef:\u8ba2\u5355id\u9519\u8bef");
        }
        Date date = new Date();
        String acceptTime = DateTimeUtil.formatTime((Date)date, (String)"yyyy-MM-dd HH:mm:ss");
        String consultationDate = DateTimeUtil.formatTime((Date)date, (String)"yyyy-MM-dd");
        String consultationTime = DateTimeUtil.formatTime((Date)date, (String)"HH:mm:ss");
        ResultInfo resultInfo = this.consultationManager.tuWenExpertAccept(orderId, acceptTime, consultationDate, consultationTime);
        try {
            this.webAndAppMessageManager.orderExpertAcceptSendMessage(orderId, acceptTime, consultationDate, consultationTime);
            ConsultationEntity consultationEntity = this.consultationManager.queryConsultationEntityById(orderId);
            this.programMessageManager.expertAcceptPush(consultationEntity, acceptTime);
        }
        catch (Exception e) {
            e.getMessage();
        }
        return resultInfo;
    }

    @ApiOperation(value="\u6839\u636e\u4e13\u5bb6ID\u6216\u533b\u751fID\u67e5\u8be2\u6709\u6548\u8ba2\u5355\u6570\u91cf")
    @GetMapping(value={"/findAllConsultationByExpIdOrDocId"})
    public ResultInfo<Object> findAllConsultationByExpIdOrDocId(@RequestParam(value="expOrDocId") Long expOrDocId) {
        return this.returnSucceed((Object)this.consultationManager.findAllConsultationByExpIdOrDocId(expOrDocId), "\u67e5\u8be2\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u4fee\u6539\u75c5\u4f8b")
    @PostMapping(value={"/update_patientcaseInfo"})
    @ApiResponses(value={@ApiResponse(code=200, message="\u4fee\u6539\u6210\u529f")})
    @Transactional(rollbackFor={Exception.class})
    public ResultInfo<ConsultationEntity> updatePatientCaseInfo(@RequestBody ConsultationPatientCaseInfoVO consultationPatientCaseInfoVO) {
        if (consultationPatientCaseInfoVO.getOrderId() != null && consultationPatientCaseInfoVO.getOrderId() != 0L) {
            ConsultationEntity consultationEntity = this.consultationManager.updatePatientCaseInfo(consultationPatientCaseInfoVO);
            if (consultationEntity != null) {
                return this.returnSucceed((Object)consultationEntity, ReturnCodeEnum.SUCCEED.getDisplay());
            }
            return this.returnFailure("\u4fee\u6539\u75c5\u4f8b\u5931\u8d25");
        }
        return this.returnFailure("\u8ba2\u5355\u4e0d\u5b58\u5728");
    }

    @PostMapping(value={"/app/getOrderList"})
    public BaseResponse<List<AppOrderListVo>> getAppOrderList(@RequestBody OrderReqVo orderReqVo) {
        log.info("====\u8bf7\u6c42\u53c2\u6570\u662f:{}", (Object)orderReqVo.toString());
        List appOrderListVos = this.consultationManager.getAppOrderList(orderReqVo.getDoctorId(), orderReqVo.getProduce(), orderReqVo.getOrderStatus(), orderReqVo.getOrderTypes(), orderReqVo.getSerarchParam(), orderReqVo.getPageIndex(), orderReqVo.getPageSize(), orderReqVo.getReportStatus());
        return BaseResponse.success((Object)appOrderListVos);
    }

    @ApiOperation(value="\u60a3\u8005\u4e0b\u5355")
    @PostMapping(value={"/patientAddorder"})
    @Transactional(rollbackFor={Exception.class}, noRollbackFor={PushInfoException.class})
    public ResultInfo<Map<String, Object>> saveConsultation(@RequestBody WechatConsultationVO wechatConsultationVO) {
        log.info("=====\u60a3\u8005\u7aef\u5f00\u59cb\u4e0b\u5355,\u6240\u4f20\u53c2\u6570\u662f:" + wechatConsultationVO.toString());
        Map map = this.consultationManager.patientAddOrder(wechatConsultationVO);
        if (((String)map.get("code")).equals(ReturnCodeEnum.SUCCEED.getValue())) {
            String orderViewId = (String)map.get("viewId");
            ConsultationEntity consultationEntity = this.consultationManager.getByViewId(orderViewId);
            try {
                this.webAndAppMessageManager.pushToDoctor(consultationEntity);
                this.shortMessageManager.applySubmittedToUser(orderViewId);
                this.programMessageManager.patientOrderPush(consultationEntity);
            }
            catch (Exception e) {
                log.error("saveConsultation", (Throwable)e);
            }
            return this.returnSucceed((Object)consultationEntity, ReturnCodeEnum.SUCCEED.getDisplay());
        }
        return this.returnFailure((String)map.get("msg"));
    }

    @ApiOperation(value="\u533b\u751f\u5b8c\u5584\u8ba2\u5355\u4fe1\u606f")
    @PostMapping(value={"/improveOrder"})
    @Transactional(rollbackFor={Exception.class}, noRollbackFor={PushInfoException.class})
    public ResultInfo<ImproveOrderResVO> improveOrder(@RequestBody WechatConsultationVO wechatConsultationVO) {
        log.info("\u4e13\u5bb6\u5f00\u59cb\u5b8c\u5584\u8ba2\u5355=====>\u8ba2\u5355id\u662f{}", (Object)wechatConsultationVO.getId());
        return this.consultationManager.improveOrder(wechatConsultationVO);
    }

    @GetMapping(value={"/weixin/getWeixinOrderList"})
    public BaseResponse<List<OrderDetailDto>> getWeixinOrderList(@RequestParam(value="pageIndex", required=false, defaultValue="1") Integer pageIndex, @RequestParam(value="pageSize", required=false, defaultValue="10") Integer pageSize, @RequestParam(value="patientId", required=false, defaultValue="0") Long patientId, @RequestParam(value="userId", required=false, defaultValue="0") Long userId, @RequestParam(value="appCode", required=true, defaultValue="") String appCode) {
        if (StringUtil.isEmpty((String)appCode)) {
            return BaseResponse.error((String)"\u8282\u70b9code\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List list = new ArrayList();
        list = patientId != 0L ? this.consultationManager.getWeixinOrderListByPatientId(appCode, pageIndex, pageSize, patientId) : this.consultationManager.getWeixinOrderListByUserId(appCode, pageIndex, pageSize, userId);
        return BaseResponse.success(list);
    }

    @GetMapping(value={"/appworkbenchcount"})
    public BaseResponse<Map<String, String>> appWorkbenchCount(@RequestParam(value="doctorId", defaultValue="0") Long doctorId) {
        HashMap<String, String> map = new HashMap<String, String>();
        int count1 = this.consultationManager.appWorkbenchCount(doctorId);
        int count2 = this.consultationManager.completedAllCount(doctorId);
        int finish = this.consultationManager.reportHasUploaded(doctorId);
        map.put("finish", String.valueOf(finish));
        int count3 = count2 - finish;
        map.put("processed", String.valueOf(count1 + count3));
        map.put("name", "consultation");
        return BaseResponse.success(map);
    }

    @GetMapping(value={"/hospital/permissions"})
    public BaseResponse<Map<String, Long>> videoPermissions(@RequestParam(value="hospitalId", defaultValue="0") Long hospitalId) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        Long videoConfiguration = -1L;
        if (hospitalId == 0L) {
            return BaseResponse.error((String)"\u533b\u9662id\u4e0d\u80fd\u4e3a0");
        }
        ConsultationSpecialConfiguration specialConfiguration = this.consultationSpecialConfigurationService.getByHospitalIdAndConfiguration(hospitalId, Long.valueOf(ConfigurationEnum.VIDEO_VIWE.getValue().longValue()));
        if (specialConfiguration != null) {
            videoConfiguration = 1L;
        }
        map.put("videoConfiguration", videoConfiguration);
        map.put("hopitalId", hospitalId);
        return BaseResponse.success(map);
    }

    @GetMapping(value={"/findOrderStatus"})
    public BaseResponse<Integer> findOrderStatus(@RequestParam(value="viewId", defaultValue="0") Long viewId) {
        ConsultationEntity consultationEntity = this.consultationManager.getByViewId(viewId.toString());
        if (consultationEntity == null) {
            return BaseResponse.error((String)"\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        return BaseResponse.success((Object)consultationEntity.getStatus());
    }

    @GetMapping(value={"/manangement/platform/order/detail"})
    public ResultInfo<OrderDetailDto> managementPlatformOrderDetail(@RequestParam(value="orderViewId") String orderViewId, @RequestHeader(value="appCode") String appCode) {
        ResultInfo orderDetailDtoResultInfo = this.consultationReportManager.queryOrderDetail(orderViewId);
        if (orderDetailDtoResultInfo.getCode().equals(ReturnCodeEnum.SUCCEED.getValue()) && orderDetailDtoResultInfo.getData() != null) {
            OrderDetailDto orderDetailDto = (OrderDetailDto)orderDetailDtoResultInfo.getData();
            if (orderDetailDto.getOrderStatus() >= OrderStatusEnum.WAIT_DISTRIBUTION.getValue() && orderDetailDto.getOrderStatus().intValue() != OrderStatusEnum.CANCEL.getValue().intValue() && orderDetailDto.getExpertHospId() != 0L) {
                String expertAppCode = this.remoteManage.getAppCodeByHospitalId(Integer.valueOf(orderDetailDto.getExpertHospId().intValue()));
                if (appCode.equalsIgnoreCase(expertAppCode)) {
                    orderDetailDto.setIsApply(Integer.valueOf(2));
                } else {
                    orderDetailDto.setIsApply(Integer.valueOf(1));
                }
            }
            return this.returnSucceed((Object)orderDetailDto, ReturnCodeEnum.SUCCEED.getDisplay());
        }
        return orderDetailDtoResultInfo;
    }

    @ApiOperation(value="\u5f71\u50cf\u4f1a\u8bca\u7533\u8bf7")
    @PostMapping(value={"/addImageOrder"})
    @Transactional(rollbackFor={Exception.class}, noRollbackFor={PushInfoException.class})
    public ResultInfo<ConsultationEntity> addImageOrder(@RequestBody ConsultationVO consultationVO) {
        Map map = this.consultationManager.addImageOrder(consultationVO);
        if (ReturnCodeEnum.SUCCEED.getValue().equals(map.get("code"))) {
            ConsultationEntity consultationEntity = this.consultationManager.getByViewId(((String)map.get("viewId")).toString());
            return this.returnSucceed((Object)consultationEntity, ReturnCodeEnum.SUCCEED.getDisplay());
        }
        return this.returnFailure((String)map.get("msg"));
    }

    @ApiOperation(value="\u8f6c\u8bca\u8c03\u53d6\u4f1a\u8bca\u670d\u52a1\u7684\u4fe1\u606f")
    @PostMapping(value={"/getConsultationInfoToTransfer"})
    public BaseResponse<List<TransferResVO>> getConsultationInfoToTransfer(@RequestBody List<TransferReqVO> transferReqVOList) {
        return this.consultationManager.getConsultationInfoToTransfer(transferReqVOList);
    }

    @ApiOperation(value="\u83b7\u53d6\u533b\u751f\u5c31\u8bca\u91cf")
    @GetMapping(value={"/getDoctorConsultationCount"})
    public BaseResponse<Integer> getDoctorConsultationCount(@RequestParam(value="doctorId", defaultValue="0") Long doctorId) {
        if (doctorId == null || doctorId.equals(0L)) {
            return BaseResponse.error((String)"\u533b\u751fid\u4e0d\u80fd\u4e3a\u7a7a\u6216\u8005\u4e3a0");
        }
        int count = this.consultationManager.getDoctorConsultationCount(doctorId, OrderStatusEnum.FINISH.getValue());
        return BaseResponse.success((Object)count);
    }

    @PostMapping(value={"/msgJoinRoom"})
    public BaseResponse<String> msgJoinRoom(@RequestParam(value="orderViewId", defaultValue="") String orderViewId, @RequestParam(value="doctorId", defaultValue="") String doctorId) {
        ConsultationEntity consultationEntity = this.consultationManager.getByViewId(orderViewId);
        if (consultationEntity == null) {
            return BaseResponse.error((String)"\u8ba2\u5355\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u8ba2\u5355\u7f16\u53f7\u662f\u5426\u6b63\u786e");
        }
        this.webAndAppMessageManager.pushToDoctorWhenJoinRoom(consultationEntity, doctorId);
        return BaseResponse.success((Object)"\u7ed9\u672a\u52a0\u5165\u623f\u95f4\u7684\u533b\u751f\u53d1\u9001\u63d0\u9192\u63a8\u9001\u6210\u529f");
    }

    @PostMapping(value={"/v1/msgJoinRoom"})
    public BaseResponse<String> msgJoinRoom2(@RequestBody JoinRoomVO joinRoomVO) {
        ConsultationEntity consultationEntity = this.consultationManager.getByViewId(joinRoomVO.getOrderViewId());
        if (consultationEntity == null) {
            return BaseResponse.error((String)"\u8ba2\u5355\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u8ba2\u5355\u7f16\u53f7\u662f\u5426\u6b63\u786e");
        }
        this.webAndAppMessageManager.pushToDoctorWhenJoinRoom(consultationEntity, joinRoomVO.getDoctorId());
        return BaseResponse.success((Object)"\u7ed9\u672a\u52a0\u5165\u623f\u95f4\u7684\u533b\u751f\u53d1\u9001\u63d0\u9192\u63a8\u9001\u6210\u529f");
    }

    @ApiOperation(value="\u91cd\u65b0\u5ba1\u6838\u529f\u80fd")
    @PostMapping(value={"/afreshAudit"})
    public BaseResponse<String> afreshAudit(@RequestBody @Valid AfreshAuditVO afreshAuditVO) {
        return this.consultationManager.afreshAudit(afreshAuditVO);
    }

    @ApiOperation(value="\u6536\u6b3e\u4ea4\u6613\u7f16\u53f7")
    @PostMapping(value={"/receiptPay"})
    public BaseResponse<String> receiptPay(@Valid @RequestBody ReceiptVO receiptVO, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.orderPayManage.receiptPay(receiptVO);
    }

    @ApiOperation(value="\u76d1\u63a7\u4f1a\u8bca\u670d\u52a1")
    @GetMapping(value={"/check_health"})
    public BaseResponse monitorConsultation() {
        return this.consultationManager.monitorConsultation();
    }

    @ApiOperation(value="\u4f1a\u8bca\u8ba2\u5355\u5b8c\u6210\u6216\u8005\u53d6\u6d88\u89e3\u6563\u7fa4\u7ec4")
    @GetMapping(value={"/unGroupConsulationOrder"})
    public BaseResponse unGroupConsulationOrder() {
        return this.consultationManager.unGroupConsulationOrder();
    }
}

