/*
 * Decompiled with CFR 0.152.
 */
package com.byh.controller.consultation;

import com.alibaba.fastjson.JSONObject;
import com.byh.enums.HxgyPayStatusEnum;
import com.byh.enums.OrderStatusEnum;
import com.byh.enums.OrderTypeEnum;
import com.byh.enums.PayStateEnum;
import com.byh.enums.PayStatusEnum;
import com.byh.enums.TradeTypeEnum;
import com.byh.exception.PushInfoException;
import com.byh.manage.consultation.AggregationPayManage;
import com.byh.manage.consultation.ConsultationManager;
import com.byh.manage.consultation.OrderPayManage;
import com.byh.manage.consultation.ShortMessageManager;
import com.byh.manage.consultation.WebAndAppMessageManager;
import com.byh.manage.mdt.MdtWebAndAppMessageManager;
import com.byh.pojo.bo.pay.PayNotify;
import com.byh.pojo.dto.pay.BusinessBillsParamVo;
import com.byh.pojo.dto.pay.PayNotifyReqVO;
import com.byh.pojo.dto.pay.PayOrderDtoReq;
import com.byh.pojo.dto.pay.RefundCallbackVo;
import com.byh.pojo.dto.pay.RefundVo;
import com.byh.pojo.dto.pay.RequestOfflineOederQueryVO;
import com.byh.pojo.entity.consultation.ConsultationEntity;
import com.byh.pojo.entity.consultation.ConsultationExtendEntity;
import com.byh.pojo.entity.consultation.ConsultationMerchantConfigEntity;
import com.byh.pojo.entity.consultation.ConsultationPayInfoEntity;
import com.byh.pojo.entity.consultation.ServicePayBillEntity;
import com.byh.pojo.vo.consultation.res.QrCodeResVO;
import com.byh.service.cosultation.CommonService;
import com.byh.service.cosultation.ConsultationExtendService;
import com.byh.service.cosultation.ConsultationMerchantConfigService;
import com.byh.service.cosultation.ConsultationPayInfoService;
import com.byh.service.mdtconsultation.MdtConsultationService;
import com.byh.util.DateTimeUtil;
import com.byh.util.UniqueKeyGenerator;
import com.ebaiyihui.framework.response.BaseResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4f1a\u8bca\u652f\u4ed8\u63a5\u53e3"})
@RestController
@RequestMapping(value={"/api/order/pay"}, produces={"application/json;charset:UTF-8"})
public class OrderPayController
extends BaseResponse {
    private static final Logger log = LoggerFactory.getLogger(OrderPayController.class);
    @Autowired
    private ConsultationManager consultationManager;
    @Autowired
    private OrderPayManage orderPayManage;
    @Autowired
    private CommonService commonService;
    @Autowired
    private ConsultationPayInfoService consultationPayInfoService;
    @Autowired
    private ShortMessageManager shortMessageManager;
    @Autowired
    private WebAndAppMessageManager webAndAppMessageManager;
    @Autowired
    private ConsultationMerchantConfigService consultationMerchantConfigService;
    @Autowired
    private ConsultationExtendService consultationExtendService;
    @Autowired
    private AggregationPayManage aggregationPayManage;
    @Autowired
    private MdtConsultationService mdtConsultationService;
    @Autowired
    private MdtWebAndAppMessageManager mdtWebAndAppMessageManager;

    @GetMapping(value={"/paymentParameters"})
    public BaseResponse<Map<String, String>> paymentParameters(@RequestParam(value="orderId", defaultValue="0") Long orderId) {
        ConsultationEntity consultationEntity = this.consultationManager.queryConsultationEntityById(orderId);
        ConsultationExtendEntity consultationExtendEntity = this.consultationExtendService.queryByConsultationId(orderId);
        if (consultationEntity == null || consultationExtendEntity == null) {
            return BaseResponse.error((String)"\u8ba2\u5355\u53f7\u53c2\u6570\u9519\u8bef");
        }
        if (consultationEntity.getStatus() > OrderStatusEnum.UN_PAY.getValue() && consultationEntity.getStatus().intValue() != OrderStatusEnum.CANCEL.getValue().intValue()) {
            return BaseResponse.error((String)"\u5df2\u652f\u4ed8\u8fc7\u6216\u5df2\u53d6\u6d88\u7684\u4e0d\u80fd\u652f\u4ed8");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        String appCode = this.orderPayManage.getAppCode(orderId);
        ConsultationMerchantConfigEntity consultationMerchantConfigEntity = this.consultationMerchantConfigService.getByAppCode(appCode.toUpperCase());
        log.info("\u6839\u636eappCode:{},\u53d6\u5230\u7684\u5546\u6237\u53f7\u662f:{},\u53d6\u5230\u7684\u4e1a\u52a1\u7cfb\u7edf\u7f16\u53f7\u662f:{}", new Object[]{appCode, consultationMerchantConfigEntity.getMerchantSeq(), consultationMerchantConfigEntity.getBizSysSeq()});
        String tradeNo = this.orderPayManage.createOrderTrade(consultationEntity.getId(), consultationMerchantConfigEntity.getMerchantSeq(), consultationMerchantConfigEntity.getBizSysSeq());
        ConsultationPayInfoEntity infoEntity = new ConsultationPayInfoEntity();
        infoEntity.setViewId(UniqueKeyGenerator.generateViewId());
        infoEntity.setTradeType(TradeTypeEnum.TYPE_WEIXIN.getValue());
        infoEntity.setTotalPrice(consultationExtendEntity.getPrice());
        infoEntity.setPayPrice(consultationExtendEntity.getPrice());
        infoEntity.setStatus(Integer.valueOf(1));
        infoEntity.setOrderViewId(Long.valueOf(Long.parseLong(consultationEntity.getViewId())));
        infoEntity.setOrderType(consultationEntity.getType());
        infoEntity.setTradeNo(tradeNo);
        infoEntity.setMerchantSeq(consultationMerchantConfigEntity.getMerchantSeq());
        infoEntity.setBizsysSeq(consultationMerchantConfigEntity.getBizSysSeq());
        this.consultationPayInfoService.insert(infoEntity);
        map.put("dealSeq", tradeNo);
        map.put("merchantSeq", consultationMerchantConfigEntity.getMerchantSeq());
        map.put("bizSysSeq", consultationMerchantConfigEntity.getBizSysSeq());
        return BaseResponse.success(map);
    }

    @PostMapping(value={"/payNotify"})
    public String payNotify(@RequestBody PayNotify payNotify) {
        log.info("======\u8fdb\u5165\u652f\u4ed8\u56de\u8c03====\u4e1a\u52a1\u7f16\u53f7\u662f:" + payNotify.getBizDealSeq());
        log.info("====\u56de\u8c03\u53d6\u5230\u7684\u5168\u90e8\u503c\u662f:" + payNotify.toString());
        String orderViewId = payNotify.getBizDealSeq();
        ConsultationEntity order = this.consultationManager.getByViewId(orderViewId);
        if (order.getStatus() > OrderStatusEnum.WAITING.getValue()) {
            return "fail";
        }
        if (payNotify != null && payNotify.getNotifyType().equalsIgnoreCase("paid")) {
            if (!payNotify.getResultType().equalsIgnoreCase(HxgyPayStatusEnum.PAY_SUCCESS.getDisplay())) {
                return "fail";
            }
            this.payNotifyCommon(order, DateTimeUtil.formatTime((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
            ConsultationPayInfoEntity payInfoEntity = this.consultationPayInfoService.selectByTradeNo(payNotify.getDealSeq());
            payInfoEntity.setBankTradeNo(payInfoEntity.getBankTradeNo());
            payInfoEntity.setPaymentTime(payNotify.getPaymentTime());
            payInfoEntity.setStatus(Integer.valueOf(2));
            this.consultationPayInfoService.update(payInfoEntity);
            this.orderPayManage.closeTrade(order.getId(), payNotify.getDealSeq());
            try {
                if (order.getTencentRong().toString().equals("1")) {
                    this.commonService.creatRongCloudGroup(order.getId());
                }
                if (order.getTencentRong().toString().equals("2")) {
                    this.commonService.tencentCreatRongCloudGroup(order);
                }
                if (order.getType().intValue() == OrderTypeEnum.TYPE_VEDIO.getValue().intValue()) {
                    this.shortMessageManager.videoConsultationApplyToExpert(orderViewId);
                } else {
                    this.shortMessageManager.photoConsultationApplyToExpert(orderViewId);
                }
                this.webAndAppMessageManager.addOrderSendMessageToPatient(order);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            log.info("------>\u8ba2\u5355\u7f16\u53f7:{}\u652f\u4ed8\u56de\u8c03\u6210\u529f", (Object)payNotify.getBizDealSeq());
            return "success";
        }
        return "fail";
    }

    @ApiOperation(value="\u521b\u5efa\u652f\u4ed8\u4ea4\u6613")
    @PostMapping(value={"/createTrade"})
    public BaseResponse<JSONObject> createTradeAggregation(@RequestBody PayOrderDtoReq payOrderDtoReq) {
        log.info("\u521b\u5efa\u652f\u4ed8\u4ea4\u6613\u8bf7\u6c42\u53c2\u6570payOrderDtoReq:{}", (Object)payOrderDtoReq);
        ConsultationEntity consultationEntity = this.consultationManager.queryConsultationEntityById(payOrderDtoReq.getOrderId());
        ConsultationExtendEntity consultationExtendEntity = this.consultationExtendService.queryByConsultationId(payOrderDtoReq.getOrderId());
        if (consultationEntity == null || consultationExtendEntity == null) {
            return BaseResponse.error((String)"\u6ca1\u6709\u6b64\u8ba2\u5355");
        }
        if (consultationEntity.getStatus() > OrderStatusEnum.UN_PAY.getValue() && consultationEntity.getStatus().intValue() != OrderStatusEnum.CANCEL.getValue().intValue()) {
            return BaseResponse.error((String)"\u6b64\u8ba2\u5355\u5df2\u53d6\u6d88\u6216\u662f\u5df2\u652f\u4ed8");
        }
        return this.orderPayManage.createTradeAggregation(payOrderDtoReq, consultationEntity, consultationExtendEntity);
    }

    @PostMapping(value={"/callback/payNotify"})
    @Transactional(rollbackFor={Exception.class}, noRollbackFor={PushInfoException.class})
    public BaseResponse<String> callBackPayNotifyAggregation(@RequestBody PayNotifyReqVO payNotifyReqVO) {
        log.info("======>>\u8fdb\u5165\u4e86\u652f\u4ed8\u56de\u8c03,\u56de\u8c03\u7684\u4fe1\u606f\u662f:{}", (Object)payNotifyReqVO.toString());
        if (PayStatusEnum.SUCCESS.getValue().equals(payNotifyReqVO.getReturnCode()) && PayStatusEnum.SUCCESS.getValue().equals(payNotifyReqVO.getResultCode())) {
            log.info("====\u8ba2\u5355\u652f\u4ed8\u6210\u529f\uff0c\u652f\u4ed8\u4fe1\u606f\u662f:{}", (Object)payNotifyReqVO.toString());
            ConsultationEntity order = this.consultationManager.getByViewId(payNotifyReqVO.getOutTradeNo());
            this.payNotifyCommon(order, DateTimeUtil.formatTime((Date)payNotifyReqVO.getPayTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            this.aggregationPayManage.aggregationPayCallback(payNotifyReqVO, order);
            try {
                List consultationMdtEntityList;
                if (order.getApplicationChannels() <= 30 && order.getTencentRong().toString().equals("1")) {
                    this.commonService.creatRongCloudGroup(order.getId());
                }
                if (order.getApplicationChannels() <= 30 && order.getTencentRong().toString().equals("2")) {
                    this.commonService.tencentCreatRongCloudGroup(order);
                    this.commonService.tencentPushGroupMsg(order);
                }
                if (order.getApplicationChannels() > 30 && order.getTencentRong().toString().equals("2")) {
                    this.commonService.tencentMdtGroup(order);
                    this.commonService.tencentPushGroupMdtMsg(order);
                }
                if ((consultationMdtEntityList = this.mdtConsultationService.queryMdtConsultationEntityByOrderViewId(order.getViewId())) == null) {
                    if (order.getType().intValue() == OrderTypeEnum.TYPE_VEDIO.getValue().intValue()) {
                        this.shortMessageManager.videoConsultationApplyToExpert(order.getViewId());
                    } else {
                        this.shortMessageManager.photoConsultationApplyToExpert(order.getViewId());
                    }
                    this.webAndAppMessageManager.addOrderSendMessageToPatient(order);
                } else {
                    this.mdtWebAndAppMessageManager.addOrderSendMessageToPatient(order, consultationMdtEntityList);
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            log.info("------>\u8ba2\u5355\u7f16\u53f7:{}\u652f\u4ed8\u56de\u8c03\u6210\u529f", (Object)payNotifyReqVO.getOutTradeNo());
            return BaseResponse.success((Object)PayStatusEnum.SUCCESS.getValue());
        }
        return BaseResponse.error((String)PayStatusEnum.FAIL.getValue());
    }

    private void payNotifyCommon(ConsultationEntity order, String payTime) {
        order.setStatus(OrderStatusEnum.WAITING.getValue());
        order.setPayTime(payTime);
        this.consultationManager.updateConsultation(order);
        ConsultationExtendEntity extendEntity = this.consultationExtendService.queryByConsultationId(order.getId());
        extendEntity.setWechatReceipt(extendEntity.getPrice().toString());
        extendEntity.setPayState(PayStateEnum.HAS_PAY_STATE.getValue());
        this.consultationExtendService.update(extendEntity);
    }

    @GetMapping(value={"/getPayQRCodeInfo"})
    public BaseResponse<QrCodeResVO> getPayQRCodeInfoAggregation(@RequestParam(value="orderViewId", defaultValue="") String orderViewId) {
        ConsultationEntity consultationEntity = this.consultationManager.getByViewId(orderViewId);
        if (consultationEntity == null) {
            return BaseResponse.error((String)"\u8ba2\u5355\u4e0d\u5b58\u5728!");
        }
        if (OrderStatusEnum.UN_PAY.getValue().equals(consultationEntity.getStatus())) {
            return this.orderPayManage.getPayQRCodeInfoAggregation(consultationEntity);
        }
        return BaseResponse.error((String)"\u8ba2\u5355\u4e0d\u662f\u5f85\u652f\u4ed8\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u652f\u4ed8!");
    }

    @PostMapping(value={"/offline_order_query"})
    public BaseResponse<JSONObject> queryOfflineOrder(@RequestBody RequestOfflineOederQueryVO reqVo) {
        log.info("======\u8fdb\u5165\u7ebf\u4e0b\u67e5\u8be2\u8ba2\u5355\u63a5\u53e3====\u5165\u53c2\u662f:{}" + reqVo);
        return this.orderPayManage.queryOfflinePayOrder(reqVo);
    }

    @ApiOperation(value="\u4e1a\u52a1\u8d26\u5355\u83b7\u53d6")
    @PostMapping(value={"/queryBusinessBills"})
    public BaseResponse<List<ServicePayBillEntity>> queryBusinessBills(@RequestBody BusinessBillsParamVo businessBillsParamVo) {
        log.info("======\u4e1a\u52a1\u8d26\u5355\u83b7\u53d6\u63a5\u53e3====\u5165\u53c2\u662f:{}" + businessBillsParamVo);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String end = sdf.format(new Date(businessBillsParamVo.getEndTime()));
        String star = sdf.format(new Date(businessBillsParamVo.getStartTime()));
        businessBillsParamVo.setStartTimeStr(star);
        businessBillsParamVo.setEndTimeStr(end);
        return this.orderPayManage.queryBusinessBills(businessBillsParamVo);
    }

    @ApiOperation(value="\u9000\u6b3e")
    @PostMapping(value={"/refund"})
    public BaseResponse<Object> refund(@RequestBody RefundVo refundVo) {
        return this.orderPayManage.refund(refundVo);
    }

    @ApiOperation(value="\u9000\u6b3e\u56de\u8c03")
    @PostMapping(value={"/refundCallback"})
    public BaseResponse<String> refundCallback(@RequestBody RefundCallbackVo refundCallbackVo) {
        return this.orderPayManage.refundCallback(refundCallbackVo);
    }
}

