/*
 * Decompiled with CFR 0.152.
 */
package com.byh.controller.consultation;

import com.alibaba.fastjson.JSONObject;
import com.byh.constants.ConsultationConstant;
import com.byh.enums.BaseStatusEnum;
import com.byh.manage.consultation.RemoteManage;
import com.byh.manage.consultation.TRTCManage;
import com.byh.pojo.bo.consultation.TencentRongListDto;
import com.byh.pojo.bo.video.VideoNotify;
import com.byh.pojo.entity.consultation.ConsultationEntity;
import com.byh.pojo.entity.consultation.ConsultationExtendEntity;
import com.byh.pojo.entity.consultation.ConsultationMdtEntity;
import com.byh.pojo.entity.consultation.ConsultationTranscodeVideoEntity;
import com.byh.pojo.entity.consultation.ConsultationVedioEntity;
import com.byh.pojo.mdt.dto.TencentRongOrderDto;
import com.byh.service.cosultation.ConsultationExtendService;
import com.byh.service.cosultation.ConsultationService;
import com.byh.service.cosultation.ConsultationTranscodeVideoService;
import com.byh.service.cosultation.ConsultationVedioService;
import com.byh.service.mdtconsultation.MdtConsultationService;
import com.byh.util.DateTimeUtil;
import com.byh.util.StringUtil;
import com.byh.util.UuidUtils;
import com.doctoruser.api.pojo.vo.basedata.doctor.DoctorEntityInfoVO;
import com.ebaiyihui.framework.response.BaseResponse;
import com.rabbitmq.client.Channel;
import com.tencentcloudapi.vod.v20180717.models.MediaProcessTaskResult;
import com.tencentcloudapi.vod.v20180717.models.MediaProcessTaskTranscodeResult;
import com.tencentcloudapi.vod.v20180717.models.ProcedureTask;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/tencent/rtc"}, produces={"application/json;charset:UTF-8"})
public class TRTCController {
    private static final Logger log = LoggerFactory.getLogger(TRTCController.class);
    @Autowired
    private TRTCManage trtcManage;
    @Autowired
    private ConsultationVedioService consultationVedioService;
    @Autowired
    private ConsultationService consultationService;
    @Autowired
    private ConsultationExtendService consultationExtendService;
    @Autowired
    private ConsultationTranscodeVideoService consultationTranscodeVideoService;
    @Autowired
    private RemoteManage remoteManage;
    @Autowired
    private MdtConsultationService mdtConsultationService;
    private static final String LOG_URL = "http://tupian201805.oss-cn-beijing.aliyuncs.com/2019/0/25/1548382195565_a8f889794b454136ac0de6341fc1f52d.png";
    private static final String CHAT_NAME = "\u8fdc\u7a0b\u4f1a\u8bca\u804a\u5929\u5ba4";

    @GetMapping(value={"/index"})
    public BaseResponse<String> stringBaseResponse(@RequestParam(value="orderId") Long orderId) {
        this.trtcManage.saveRtcRoomId(orderId);
        return BaseResponse.success((Object)"\u6210\u529f");
    }

    @RabbitListener(queues={"video.queue"})
    public void listenVideo(Message message, Channel channel) {
        log.info("mq enter!!" + JSONObject.toJSONString((Object)message));
        try {
            String videoMsg = new String(message.getBody());
            log.info("=========\u8fdb\u5165\u89c6\u9891\u56de\u8c03========" + videoMsg);
            if (StringUtil.isNotEmpty((String)videoMsg)) {
                VideoNotify videoNotify = (VideoNotify)JSONObject.parseObject((String)videoMsg, VideoNotify.class);
                String orderViewId = videoNotify.getTreatmentId();
                ConsultationEntity consultationEntity = this.consultationService.queryConsultationEntityByViewId(orderViewId);
                ConsultationExtendEntity consultationExtendEntity = this.consultationExtendService.queryByConsultationId(consultationEntity.getId());
                if (consultationEntity != null && consultationExtendEntity != null) {
                    List expertVideoList;
                    ConsultationVedioEntity consultationVedio = this.consultationVedioService.getByVedioUrl(videoNotify.getVideoUrl());
                    consultationExtendEntity.setVideoUrl(videoNotify.getVideoUrl());
                    Long doctorDuration = 0L;
                    Long expertDuration = 0L;
                    Map videoFilesMap = this.trtcManage.getDoctorVideoFileds(consultationEntity);
                    List doctorVideoList = (List)videoFilesMap.get("doctorVideoFileId");
                    if (CollectionUtils.isNotEmpty((Collection)doctorVideoList)) {
                        doctorDuration = this.trtcManage.getTotalVideoDuration(doctorVideoList);
                    }
                    if (CollectionUtils.isNotEmpty((Collection)(expertVideoList = (List)videoFilesMap.get("expertVideoFileId")))) {
                        expertDuration = this.trtcManage.getTotalVideoDuration(expertVideoList);
                    }
                    if (doctorDuration != null && expertDuration != null && doctorDuration < expertDuration) {
                        consultationExtendEntity.setVideoTime(String.valueOf(doctorDuration));
                    } else {
                        consultationExtendEntity.setVideoTime(String.valueOf(expertDuration));
                    }
                    if (consultationVedio == null) {
                        long startTimeSeconed = videoNotify.getStartTime();
                        long endTimeSeconed = videoNotify.getEndTime();
                        String startTime = DateTimeUtil.formatTime((Date)new Date(startTimeSeconed * 1000L), (String)"yyyy-MM-dd HH:mm:ss");
                        String endTime = DateTimeUtil.formatTime((Date)new Date(endTimeSeconed * 1000L), (String)"yyyy-MM-dd HH:mm:ss");
                        ConsultationVedioEntity consultationVedioEntity = new ConsultationVedioEntity();
                        consultationVedioEntity.setStatus(Integer.valueOf(1));
                        consultationVedioEntity.setVedioUrl(videoNotify.getVideoUrl());
                        consultationVedioEntity.setConsultationType(consultationEntity.getType().intValue());
                        consultationVedioEntity.setViewId(UuidUtils.generateUUID());
                        long duration = endTimeSeconed - startTimeSeconed;
                        consultationVedioEntity.setDuration(Long.valueOf(duration));
                        consultationVedioEntity.setStartTime(startTime);
                        consultationVedioEntity.setEndTime(endTime);
                        consultationVedioEntity.setConsultationId(consultationEntity.getId());
                        this.consultationVedioService.insertConsultationVedio(consultationVedioEntity);
                        ConsultationTranscodeVideoEntity videoEntity = new ConsultationTranscodeVideoEntity();
                        videoEntity.setStatus(BaseStatusEnum.STATUS_VALID.getValue());
                        videoEntity.setOrderViewId(consultationEntity.getViewId());
                        videoEntity.setOrderType(consultationEntity.getType());
                        videoEntity.setFileId(consultationEntity.getViewId());
                        videoEntity.setVideoType("mp4");
                        videoEntity.setVideoUrl(videoNotify.getVideoUrl());
                        videoEntity.setDuration(Long.valueOf(duration));
                        this.consultationTranscodeVideoService.insert(videoEntity);
                    }
                    this.consultationService.updateConsultationEntity(consultationEntity);
                    this.consultationExtendService.update(consultationExtendEntity);
                }
            }
        }
        catch (Exception e) {
            log.error("listenVideo error,e=", (Throwable)e);
        }
        try {
            channel.basicAck(message.getMessageProperties().getDeliveryTag(), false);
        }
        catch (IOException e) {
            log.error("basicAck error,e=", (Throwable)e);
        }
    }

    @RequestMapping(value={"/transcodingCallback"}, method={RequestMethod.GET, RequestMethod.POST})
    public void transcodingCallback(@RequestBody JSONObject jsonObject) {
        log.info("====\u8fdb\u5165\u4e86\u52a0\u6c34\u5370\u7684\u89c6\u9891\u8f6c\u7801\u7684\u56de\u8c03=====");
        log.info("====data\u662f:" + jsonObject.toString());
    }

    @PostMapping(value={"/invokeProcessVideo"})
    public BaseResponse<String> invokeProcessVideo(@RequestParam(value="orderViewId", defaultValue="") String orderViewId) {
        ConsultationEntity consultationEntity = this.consultationService.selectByViewId(orderViewId);
        if (consultationEntity == null) {
            return BaseResponse.error((String)"\u8ba2\u5355\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4\u8ba2\u5355\u7f16\u53f7\u662f\u5426\u6b63\u786e");
        }
        ConsultationTranscodeVideoEntity consultationTranscodeVideoEntity = this.consultationTranscodeVideoService.getByOrderViewIdAndOrderType(orderViewId, consultationEntity.getType());
        if (consultationTranscodeVideoEntity != null) {
            return BaseResponse.error((String)"\u6b63\u5728\u8f6c\u7801\u4e2d\uff0c\u8bf7\u60a8\u7a0d\u540e\u4e0b\u8f7d");
        }
        return BaseResponse.success((Object)"\u8f6c\u7801\u6210\u529f\uff0c\u8bf7\u7a0d\u540e\u67e5\u770b");
    }

    @RequestMapping(value={"/callBack/processvideo"}, method={RequestMethod.GET, RequestMethod.POST})
    public void callBackProcessVideo(@RequestBody JSONObject jsonObject) {
        log.info("\u8fdb\u5165\u8f6c\u7801\u56de\u8c03,\u56de\u8c03\u4fe1\u606f\u662f:{}", (Object)jsonObject.toJSONString());
        String eventType = jsonObject.getString("EventType");
        String procedureTaskStr = JSONObject.toJSONString((Object)jsonObject.getJSONObject("ProcedureStateChangeEvent"));
        ProcedureTask procedureTask = (ProcedureTask)JSONObject.parseObject((String)procedureTaskStr, ProcedureTask.class);
        if ("ProcedureStateChanged".equalsIgnoreCase(eventType) && "FINISH".equalsIgnoreCase(procedureTask.getStatus()) && procedureTask.getMediaProcessResultSet() != null) {
            MediaProcessTaskResult[] mediaProcessTaskResults;
            log.info("======>\u786e\u8ba4\u662f\u89c6\u9891\u8f6c\u7801\u56de\u8c03");
            String videoUrl = "";
            Long duration = 0L;
            String fileId = procedureTask.getFileId();
            ConsultationTranscodeVideoEntity videoEntity = this.consultationTranscodeVideoService.getByFileId(fileId);
            log.info("videoEntity:{}", (Object)videoEntity.toString());
            for (MediaProcessTaskResult mediaProcessTaskResult : mediaProcessTaskResults = procedureTask.getMediaProcessResultSet()) {
                if (!"Transcode".equalsIgnoreCase(mediaProcessTaskResult.getType())) continue;
                MediaProcessTaskTranscodeResult mediaProcessTaskTranscodeResult = mediaProcessTaskResult.getTranscodeTask();
                videoUrl = mediaProcessTaskTranscodeResult.getOutput().getUrl();
                log.info("videoUrl:{}", (Object)videoUrl);
                duration = mediaProcessTaskTranscodeResult.getOutput().getDuration().longValue();
                log.info("duration:{}", (Object)duration);
                break;
            }
            this.consultationTranscodeVideoService.updateVideoTypeAndUrlAndDuration("mp4", videoUrl, duration, videoEntity.getId());
        }
    }

    @GetMapping(value={"/tencentList"})
    public BaseResponse<List<TencentRongListDto>> tencentList(@RequestParam(value="doctorId") Long doctorId) {
        ArrayList<TencentRongListDto> list = new ArrayList<TencentRongListDto>();
        List orderList = this.consultationService.getOrderListByDocId(doctorId);
        if (CollectionUtils.isEmpty((Collection)orderList)) {
            return BaseResponse.success(list);
        }
        for (ConsultationEntity order : orderList) {
            TencentRongListDto TencentDto = new TencentRongListDto();
            TencentDto.setCreateTime(Long.valueOf(order.getCreateTime().getTime()));
            TencentDto.setGroupId(order.getGroupId());
            TencentDto.setTencentRong(order.getTencentRong());
            if (StringUtil.isNotEmpty((String)order.getDoctorName()) && StringUtil.isNotEmpty((String)order.getExpertName())) {
                TencentDto.setGroupName(order.getDoctorName() + "\u548c" + order.getExpertName() + "\u7684\u804a\u5929\u5ba4");
            } else {
                TencentDto.setGroupName(CHAT_NAME);
            }
            TencentDto.setOrderType(order.getType());
            TencentDto.setOrderViewId(order.getViewId());
            if (StringUtil.isEmpty((String)order.getGroupUrl())) {
                TencentDto.setPhoto(LOG_URL);
            }
            TencentDto.setPhoto(order.getGroupUrl());
            list.add(TencentDto);
        }
        return BaseResponse.success(list);
    }

    @GetMapping(value={"/mdt/tencentListMdt"})
    public BaseResponse<List<TencentRongListDto>> tencentListMdt(@RequestParam(value="doctorId") Long doctorId) {
        ArrayList<TencentRongListDto> list = new ArrayList<TencentRongListDto>();
        ArrayList orderList = new ArrayList();
        List orderListMdt = this.consultationService.getOrderListMdtByDocId(doctorId);
        if (CollectionUtils.isNotEmpty((Collection)orderListMdt)) {
            for (Object tencentRongOrderDto : orderListMdt) {
                if (ConsultationConstant.TYPE_APPLICATION_CHANNELS_SECOND_OPINION_HYBRID.intValue() == tencentRongOrderDto.getApplicationChannels().intValue()) {
                    tencentRongOrderDto.setSubjectType(Integer.valueOf(3));
                    continue;
                }
                tencentRongOrderDto.setSubjectType(Integer.valueOf(2));
            }
            orderList.addAll(orderListMdt);
        }
        List orderListMdts = orderListMdt.stream().distinct().collect(Collectors.toList());
        for (Object mdtOrderDto : orderListMdts) {
            ConsultationEntity consultationEntity = this.consultationService.selectByViewId(mdtOrderDto.getOrderViewId());
            List mdtConsultationEntityList = this.mdtConsultationService.queryMdtConsultationEntityByOrderViewId(consultationEntity.getViewId());
            TencentRongListDto TencentDto = new TencentRongListDto();
            TencentDto.setCreateTime(Long.valueOf(mdtOrderDto.getOrderCreateTime().getTime()));
            TencentDto.setGroupId(mdtOrderDto.getGroupId());
            TencentDto.setTencentRong(mdtOrderDto.getTencentRong());
            String groupName = consultationEntity.getDoctorName();
            for (ConsultationMdtEntity consultationMdtEntity : mdtConsultationEntityList) {
                groupName = groupName + "\u3001" + consultationMdtEntity.getExpertName();
            }
            if (StringUtil.isNotEmpty((String)groupName)) {
                TencentDto.setGroupName(groupName + "\u7684\u804a\u5929\u5ba4");
            } else {
                TencentDto.setGroupName(CHAT_NAME);
            }
            TencentDto.setOrderType(mdtOrderDto.getType());
            TencentDto.setOrderViewId(mdtOrderDto.getOrderViewId());
            if (StringUtil.isEmpty((String)mdtOrderDto.getGroupUrl())) {
                TencentDto.setPhoto(LOG_URL);
            }
            TencentDto.setPhoto(mdtOrderDto.getGroupUrl());
            TencentDto.setSubjectType(mdtOrderDto.getSubjectType());
            list.add(TencentDto);
        }
        List orderListOnce = this.consultationService.getOrderListOnceByDocId(doctorId);
        if (CollectionUtils.isNotEmpty((Collection)orderListOnce)) {
            for (TencentRongOrderDto tencentRongOrderDto : orderListOnce) {
                if (ConsultationConstant.TYPE_APPLICATION_CHANNELS_SECOND_OPINION_HYBRID.intValue() == tencentRongOrderDto.getApplicationChannels().intValue()) {
                    tencentRongOrderDto.setSubjectType(Integer.valueOf(3));
                    continue;
                }
                tencentRongOrderDto.setSubjectType(Integer.valueOf(1));
            }
            orderList.addAll(orderListOnce);
        }
        if (CollectionUtils.isEmpty(orderList)) {
            return BaseResponse.success(list);
        }
        for (TencentRongOrderDto order : orderListOnce) {
            DoctorEntityInfoVO doctorDetailInfoEntity = this.remoteManage.getDoctorDetailById(order.getDoctorId());
            log.info("\u83b7\u53d6\u533b\u751f\u4fe1\u606f\uff1adoctorDetailInfoEntity:{}", (Object)doctorDetailInfoEntity);
            DoctorEntityInfoVO expertDetailInfoEntity = this.remoteManage.getDoctorDetailById(order.getExpertId());
            log.info("\u83b7\u53d6\u4e13\u5bb6\u4fe1\u606f\uff1aexpertDetailInfoEntity:{}", (Object)expertDetailInfoEntity);
            TencentRongListDto TencentDto = new TencentRongListDto();
            TencentDto.setCreateTime(Long.valueOf(order.getOrderCreateTime().getTime()));
            TencentDto.setGroupId(order.getGroupId());
            TencentDto.setTencentRong(order.getTencentRong());
            if (doctorDetailInfoEntity != null && expertDetailInfoEntity != null) {
                TencentDto.setGroupName(doctorDetailInfoEntity.getName() + "\u548c" + expertDetailInfoEntity.getName() + "\u7684\u804a\u5929\u5ba4");
            } else {
                TencentDto.setGroupName(CHAT_NAME);
            }
            TencentDto.setOrderType(order.getType());
            TencentDto.setOrderViewId(order.getOrderViewId());
            if (StringUtil.isEmpty((String)order.getGroupUrl())) {
                TencentDto.setPhoto(LOG_URL);
            }
            TencentDto.setPhoto(order.getGroupUrl());
            TencentDto.setSubjectType(order.getSubjectType());
            list.add(TencentDto);
        }
        List list1 = list.stream().distinct().collect(Collectors.toList());
        return BaseResponse.success(list1);
    }
}

