/*
 * Decompiled with CFR 0.152.
 */
package com.byh.controller.dashboard;

import com.byh.pojo.vo.dashboard.DashBoardReqVO;
import com.byh.pojo.vo.dashboard.DoctorOrderVO;
import com.byh.pojo.vo.dashboard.DoctorReqVO;
import com.byh.pojo.vo.dashboard.OrderBarGraph;
import com.byh.pojo.vo.dashboard.OrderGraphReqVO;
import com.byh.pojo.vo.dashboard.OrderIncome;
import com.byh.pojo.vo.dashboard.OrderInfoVO;
import com.byh.pojo.vo.dashboard.OrderPriceReqVO;
import com.byh.pojo.vo.dashboard.OrderPriceRespVO;
import com.byh.service.dashboard.StatisticsService;
import com.ebaiyihui.framework.response.BaseResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4f1a\u8bca\u6570\u636e\u7edf\u8ba1"})
@RestController
@RequestMapping(value={"/api/v1/statistics"})
public class StatisticsController {
    @Autowired
    private StatisticsService statisticsService;

    @ApiOperation(value="\u83b7\u53d6\u4f1a\u8bca\u670d\u52a1\u8ba2\u5355\u4fe1\u606f", notes="\u83b7\u53d6\u4f1a\u8bca\u670d\u52a1\u8ba2\u5355\u4fe1\u606f")
    @PostMapping(value={"/getPriceInfo"})
    public BaseResponse<OrderPriceRespVO> getPriceInfo(@RequestBody OrderPriceReqVO reqVO) {
        return this.statisticsService.getPriceInfo(reqVO);
    }

    @ApiOperation(value="\u83b7\u53d6\u4f1a\u8bca-\u603b\u6536\u5165\u7edf\u8ba1\u3001\u6210\u4ea4\u8f6c\u5316", notes="\u83b7\u53d6\u4f1a\u8bca-\u603b\u6536\u5165\u7edf\u8ba1\u3001\u6210\u4ea4\u8f6c\u5316")
    @GetMapping(value={"/getOrderInfo"})
    public BaseResponse<OrderInfoVO> getOrderInfo(@RequestParam(value="appCode") String appCode, @RequestParam(value="organId") Integer organId) {
        return this.statisticsService.getOrderInfo(appCode, organId);
    }

    @ApiOperation(value="\u652f\u4ed8\u8ba2\u5355\u6570-\u67f1\u72b6\u56fe", notes="\u652f\u4ed8\u8ba2\u5355\u6570-\u67f1\u72b6\u56fe")
    @PostMapping(value={"/getOrderBarGraph"})
    public BaseResponse<List<OrderBarGraph>> getOrderBarGraph(@RequestBody @Validated OrderGraphReqVO reqVO) {
        return this.statisticsService.getOrderBarGraph(reqVO);
    }

    @ApiOperation(value="\u8ba2\u5355\u6536\u5165-\u6298\u73b0\u56fe", notes="\u8ba2\u5355\u6536\u5165-\u6298\u73b0\u56fe")
    @PostMapping(value={"/getOrderIncome"})
    public BaseResponse<List<OrderIncome>> getOrderIncome(@RequestBody @Validated OrderGraphReqVO reqVO) {
        return this.statisticsService.getOrderIncome(reqVO);
    }

    @ApiOperation(value="\u6570\u636e\u5bfc\u51fa", notes="\u6570\u636e\u5bfc\u51fa")
    @PostMapping(value={"/exportOrderInfo"})
    public void exportOrderInfo(@RequestBody DashBoardReqVO reqVO) {
        this.statisticsService.exportOrderInfo(reqVO.getAppCode(), reqVO.getOrganId());
    }

    @ApiOperation(value="\u533b\u751f\u7aef-\u652f\u4ed8\u4fe1\u606f", notes="\u533b\u751f\u7aef-\u652f\u4ed8\u4fe1\u606f")
    @PostMapping(value={"/getDoctorInfo"})
    public BaseResponse<DoctorOrderVO> getDoctorInfo(@RequestBody @Validated DoctorReqVO reqVO) {
        return this.statisticsService.getDoctorInfo(reqVO);
    }

    @ApiOperation(value="\u533b\u751f\u7aef-\u6536\u5165\u6298\u7ebf\u56fe", notes="\u533b\u751f\u7aef-\u6536\u5165\u6298\u7ebf\u56fe")
    @PostMapping(value={"/getDoctorPriceInfo"})
    public BaseResponse<List<OrderIncome>> getDoctorPriceInfo(@RequestBody @Validated DoctorReqVO reqVO) {
        return this.statisticsService.getDoctorPriceInfo(reqVO);
    }
}

