/*
 * Decompiled with CFR 0.152.
 */
package com.byh.controller.healalliance;

import com.byh.common.ResultInfo;
import com.byh.controller.BaseController;
import com.byh.pojo.entity.healthallian.HospitalHealthAllianceMemberEntity;
import com.byh.pojo.entity.healthallian.HospitalHealthAllianceServiceEntity;
import com.byh.service.healthalliace.HealthAllianceMemberService;
import com.byh.service.healthalliace.HealthAllianceServiceService;
import com.byh.util.UuidUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(description="\u6708\u7ed3\u670d\u52a1")
@RestController
@RequestMapping(value={"/api/v1/healthAllianceService"}, produces={"application/json;charset:UTF-8"})
public class HealthAllianceServiceController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(HealthAllianceServiceController.class);
    @Autowired
    private HealthAllianceServiceService healthAllianceServiceService;
    @Autowired
    private HealthAllianceMemberService healthAllianceMemberService;

    @ApiOperation(value="\u5f00\u542f\u670d\u52a1\u6708\u7ed3")
    @ApiImplicitParams(value={@ApiImplicitParam(name="hospitalId", value="\u533b\u9662id", required=true, dataType="int", paramType="query"), @ApiImplicitParam(name="serviceId", value="\u670d\u52a1id", required=true, dataType="int", paramType="query")})
    @PostMapping(value={"/insert_hospital_health_alliance_service"})
    public ResultInfo insertHospitalHealthAllianceService(@RequestParam(value="hospitalId", defaultValue="0") Long hospitalId, @RequestParam(value="serviceId", defaultValue="0") Integer serviceId) {
        if (hospitalId == null || hospitalId.intValue() == 0) {
            return this.returnFailure("\u533b\u9662id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HospitalHealthAllianceMemberEntity hospitalHealthAllianceMemberEntity = this.healthAllianceMemberService.getHealthAllianceMemberByHospitalId(hospitalId);
        if (hospitalHealthAllianceMemberEntity == null) {
            return this.returnFailure("\u533b\u9662\u4e0d\u5728\u533b\u8054\u4f53");
        }
        HospitalHealthAllianceServiceEntity healthAllianceService = this.healthAllianceServiceService.getHealthAllianceServiceByHospitalIdAndServiceId(hospitalId, Long.valueOf(0L), serviceId);
        if (healthAllianceService == null) {
            HospitalHealthAllianceServiceEntity hospitalHealthAllianceServiceEntity = new HospitalHealthAllianceServiceEntity();
            hospitalHealthAllianceServiceEntity.setViewId(UuidUtils.generateUUID());
            hospitalHealthAllianceServiceEntity.setHospitalId(hospitalId);
            hospitalHealthAllianceServiceEntity.setParentHosId(hospitalHealthAllianceMemberEntity.getParentHosId());
            hospitalHealthAllianceServiceEntity.setServiceId(serviceId);
            hospitalHealthAllianceServiceEntity.setStatus(Integer.valueOf(1));
            hospitalHealthAllianceServiceEntity.setAllianceUuid(hospitalHealthAllianceMemberEntity.getAllianceUuid());
            int i = this.healthAllianceServiceService.insertHospitalHealthAllianceService(hospitalHealthAllianceServiceEntity);
            if (i > 0) {
                return this.returnSucceed("\u5f00\u542f\u6210\u529f");
            }
            return this.returnFailure("\u5f00\u542f\u5931\u8d25");
        }
        if (healthAllianceService.getStatus() == 1) {
            return this.returnSucceed("\u5f00\u542f\u6210\u529f");
        }
        int i = this.healthAllianceServiceService.updateHealthAllianceService(hospitalId, Integer.valueOf(1), serviceId);
        if (i > 0) {
            return this.returnSucceed("\u5f00\u542f\u6210\u529f");
        }
        return this.returnFailure("\u5f00\u542f\u5931\u8d25");
    }

    @ApiOperation(value="\u6708\u7ed3\u6570\u636e\u67e5\u8be2")
    @ApiImplicitParams(value={@ApiImplicitParam(name="hospitalId", value="\u533b\u9662id", required=true, dataType="Long", paramType="query")})
    @GetMapping(value={"/select_hospital_health_alliance_service_byHospitalId"})
    public ResultInfo<HospitalHealthAllianceServiceEntity> selectHospitalHealthAllianceServiceByHospitalId(@RequestParam(value="hospitalId", defaultValue="0") Long hospitalId) {
        if (hospitalId == null || hospitalId.intValue() == 0) {
            return this.returnFailure("\u533b\u9662Id\u5f02\u5e38");
        }
        List list = this.healthAllianceServiceService.getListHospitalHealthAllianceService(hospitalId);
        if (list == null || list.size() < 1) {
            return this.returnSucceed("\u8be5\u533b\u9662\u672a\u5f00\u542f\u670d\u52a1");
        }
        return this.returnSucceed((Object)list, "\u6210\u529f");
    }

    @ApiOperation(value="\u533b\u9662\u670d\u52a1\u6708\u7ed3\u72b6\u6001\u4fee\u6539")
    @ApiImplicitParams(value={@ApiImplicitParam(name="status", value="\u72b6\u6001", required=true, dataType="int", paramType="query"), @ApiImplicitParam(name="hospitalId", value="\u533b\u9662id", required=true, dataType="Long", paramType="query"), @ApiImplicitParam(name="serviceId", value="\u670d\u52a1id", required=true, dataType="int", paramType="query")})
    @PostMapping(value={"/update_hospital_health_alliance_service_byHospitalId"})
    public ResultInfo updateHospitalHealthAllianceServiceByHospitalId(@RequestParam(value="hospitalId", defaultValue="0") Long hospitalId, @RequestParam(value="status", defaultValue="1") Integer status, @RequestParam(value="serviceId", defaultValue="0") Integer serviceId) {
        if (hospitalId == null || hospitalId.intValue() == 0) {
            return this.returnFailure("\u533b\u9662id\u53c2\u6570\u5f02\u5e38");
        }
        if (serviceId == null || serviceId == 0) {
            return this.returnFailure("serviceId\u5f02\u5e38");
        }
        HospitalHealthAllianceMemberEntity hospitalHealthAllianceMemberEntity = this.healthAllianceMemberService.getHealthAllianceMemberByHospitalId(hospitalId);
        if (hospitalHealthAllianceMemberEntity == null) {
            return this.returnFailure("\u533b\u8054\u4f53\u4e0d\u5b58\u5728\u8be5\u533b\u9662");
        }
        int i = this.healthAllianceServiceService.updateHealthAllianceService(hospitalId, status, serviceId);
        if (i > 0) {
            return this.returnSucceed("\u4fee\u6539\u6210\u529f");
        }
        return this.returnFailure("\u4fee\u6539\u5931\u8d25");
    }

    @ApiOperation(value="\u67e5\u8be2\u67d0\u4e2a\u670d\u52a1\u6708\u7ed3\u662f\u5426\u5f00\u542f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="hospitalId", value="\u533b\u9662id", required=true, dataType="Long", paramType="query"), @ApiImplicitParam(name="serviceId", value="\u670d\u52a1id", required=true, dataType="int", paramType="query")})
    @GetMapping(value={"/select_hospital_health_alliance_service_isOpen"})
    public ResultInfo selectHospitalHealthAllianceServiceIsOpen(@RequestParam(value="hospitalId", defaultValue="0") Long hospitalId, @RequestParam(value="serviceId", defaultValue="0") Integer serviceId) {
        if (hospitalId == null || hospitalId.intValue() == 0) {
            return this.returnFailure("\u533b\u9662id\u6709\u8bef");
        }
        if (serviceId == null || serviceId == 0) {
            return this.returnFailure("\u670d\u52a1id\u6709\u8bef");
        }
        HospitalHealthAllianceMemberEntity hospitalHealthAllianceMemberEntity = this.healthAllianceMemberService.getHealthAllianceMemberByHospitalId(hospitalId);
        if (hospitalHealthAllianceMemberEntity == null) {
            return this.returnFailure("\u8be5\u533b\u9662\u4e0d\u5728\u533b\u8054\u4f53");
        }
        List list = this.healthAllianceServiceService.selectHospitalHealthAllianceServiceIsOpen(hospitalId, serviceId);
        if (list != null && list.size() > 0) {
            return this.returnSucceed("\u8be5\u670d\u52a1\u5f00\u542f");
        }
        return this.returnSucceed("\u8be5\u670d\u52a1\u672a\u5f00\u542f");
    }
}

