/*
 * Decompiled with CFR 0.152.
 */
package com.byh.controller.mdtconsultation;

import com.alibaba.fastjson.JSON;
import com.byh.common.ResultInfo;
import com.byh.constants.ConsultationConstant;
import com.byh.controller.BaseController;
import com.byh.enums.OrderTypeEnum;
import com.byh.manage.mdt.MdtManage;
import com.byh.manage.mdtconsultation.MdtClinicManager;
import com.byh.pojo.vo.mdtconsultation.CancelOrderMdtVo;
import com.byh.pojo.vo.mdtconsultation.ExpertAcceptMdtVo;
import com.byh.pojo.vo.mdtconsultation.FinishConsultaionMdtVo;
import com.byh.pojo.vo.mdtconsultation.OrderAssignMdtVo;
import com.byh.pojo.vo.mdtconsultation.StartConsultaionMdtVo;
import com.byh.util.StringUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u591a\u5b66\u79d1\u4f1a\u8bca\u5176\u4ed6\u4fe1\u606f\u63a5\u53e3"})
@RestController
@RequestMapping(value={"/api/v2/MyClinic"}, produces={"application/json;charset:UTF-8"})
public class MdtClinicController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(MdtClinicController.class);
    @Autowired
    private MdtClinicManager mdtClinicManager;
    @Autowired
    private MdtManage mdtManage;

    @ApiOperation(value="\u8d85\u7ba1\u540e\u53f0\u4e13\u5bb6\u5206\u914d")
    @PostMapping(value={"/mdtOrderAssign"})
    public ResultInfo mdtOrderAssign(@RequestBody OrderAssignMdtVo orderAssignMdtVo) {
        if (orderAssignMdtVo == null) {
            return this.returnFailure("\u63d0\u4ea4\u53c2\u6570\u4e3a\u7a7a");
        }
        if (StringUtil.isBlank((String)orderAssignMdtVo.getOrderViewId())) {
            return this.returnFailure("\u8ba2\u5355id\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        if (orderAssignMdtVo.getList() == null || orderAssignMdtVo.getList().size() == 0) {
            return this.returnFailure("\u4e13\u5bb6\u96c6\u5408\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        if (orderAssignMdtVo.getApplicationChannels().intValue() != ConsultationConstant.TYPE_APPLICATION_CHANNELS_MDT_UNION.intValue() && orderAssignMdtVo.getApplicationChannels().intValue() != ConsultationConstant.TYPE_APPLICATION_CHANNELS_MDT_EXPERT.intValue() && orderAssignMdtVo.getApplicationChannels().intValue() != ConsultationConstant.TYPE_APPLICATION_CHANNELS_MDT_HYBRID.intValue()) {
            return this.returnFailure("\u591a\u5b66\u79d1\u7533\u8bf7\u6e20\u9053\u53c2\u6570\u4e0d\u6b63\u786e");
        }
        return this.mdtManage.mdtOrderAssign(orderAssignMdtVo);
    }

    @ApiOperation(value="\u7ed3\u675f\u4f1a\u8bca\u670d\u52a1")
    @PostMapping(value={"/finishConsultaion"})
    public ResultInfo<Map<String, Object>> finishConsultation(@RequestBody FinishConsultaionMdtVo finishConsultaionMdtVo) {
        if (finishConsultaionMdtVo == null || StringUtil.isBlank((String)finishConsultaionMdtVo.getOrderViewId())) {
            return this.returnFailure("\u53c2\u6570\u4e3a\u7a7a");
        }
        if (finishConsultaionMdtVo.getDoctorIdByLoginUser() == null || finishConsultaionMdtVo.getDoctorIdByLoginUser().intValue() == 0) {
            return this.returnFailure("doctorIdByLoginUser\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        log.info("\u7ed3\u675f\u4f1a\u8bca\u670d\u52a1:{}", (Object)JSON.toJSONString((Object)finishConsultaionMdtVo));
        return this.mdtClinicManager.finishConsultaion(finishConsultaionMdtVo.getOrderViewId(), finishConsultaionMdtVo.getDoctorIdByLoginUser());
    }

    @ApiOperation(value="\u5f00\u59cb\u89c6\u9891\u4f1a\u8bca")
    @PostMapping(value={"/startConsultation"})
    public ResultInfo<Map<String, String>> startConsultation(@RequestBody StartConsultaionMdtVo startConsultaionMdtVo) {
        if (startConsultaionMdtVo == null || StringUtil.isBlank((String)startConsultaionMdtVo.getOrderViewId())) {
            return this.returnFailure("\u975e\u6cd5\u53c2\u6570");
        }
        return this.mdtClinicManager.startConsultation(startConsultaionMdtVo.getOrderViewId());
    }

    @ApiOperation(value="\u591a\u5b66\u79d1\u4e13\u5bb6\u63a5\u8bca")
    @PostMapping(value={"/mdt_expert_accept"})
    public ResultInfo orderExpertAccept(@RequestBody ExpertAcceptMdtVo expertAcceptMdtVo) {
        if (expertAcceptMdtVo == null || StringUtil.isBlank((String)expertAcceptMdtVo.getOrderViewId())) {
            return this.returnFailure("\u63d0\u4ea4\u53c2\u6570\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        if (expertAcceptMdtVo.getExpertId() == null || expertAcceptMdtVo.getExpertId().intValue() == 0) {
            return this.returnFailure("\u4e13\u5bb6id\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        Integer type = expertAcceptMdtVo.getType();
        if (type == null || type == 0) {
            return this.returnFailure("\u4f1a\u8bca\u5f62\u5f0f\u53c2\u6570\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        if (type.intValue() != OrderTypeEnum.TYPE_VEDIO.getValue().intValue() && type.intValue() != OrderTypeEnum.TYPE_TUWEN.getValue().intValue()) {
            return this.returnFailure("\u4f1a\u8bca\u5f62\u5f0f\u53c2\u6570\u4e0d\u6b63\u786e");
        }
        return this.mdtClinicManager.orderExpertAccept(expertAcceptMdtVo.getOrderViewId(), expertAcceptMdtVo.getExpertId(), type);
    }

    @ApiOperation(value="\u591a\u5b66\u79d1\u53d6\u6d88\u8ba2\u5355")
    @PostMapping(value={"/cancelOrder"})
    public ResultInfo<String> cancelOrder(@RequestBody CancelOrderMdtVo cancelOrderMdtVo) {
        if (cancelOrderMdtVo == null) {
            return this.returnFailure("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        log.info("====\u53d6\u6d88\u8ba2\u5355\u53c2\u6570===cancelOrderMdtVo:" + cancelOrderMdtVo.toString());
        if (StringUtil.isBlank((String)cancelOrderMdtVo.getOrderViewId())) {
            return this.returnFailure("orderViewId\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        if (cancelOrderMdtVo.getCloserId().intValue() == 0) {
            return this.returnFailure("\u5173\u95ed\u8005id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (cancelOrderMdtVo.getCloserType() == 0) {
            return this.returnFailure("\u5173\u95ed\u8005\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.mdtClinicManager.cancelOrder(cancelOrderMdtVo);
    }
}

