/*
 * Decompiled with CFR 0.152.
 */
package com.byh.controller.mdtconsultation;

import com.alibaba.excel.EasyExcel;
import com.byh.common.ResultInfo;
import com.byh.controller.BaseController;
import com.byh.manage.mdtconsultation.MdtConsultationManager;
import com.byh.pojo.vo.consultation.AppOrderListVo;
import com.byh.pojo.vo.consultation.ExcelParamVo;
import com.byh.pojo.vo.consultation.OrderReqVo;
import com.byh.pojo.vo.consultation.excel.ConsultationDataInfoVO;
import com.byh.pojo.vo.consultation.req.AdminAuditConsultationReqVo;
import com.byh.pojo.vo.consultation.req.AdminRefundConsultationReqVo;
import com.byh.pojo.vo.consultation.res.UserRefundRespVo;
import com.byh.pojo.vo.mdtconsultation.AdminMdtListReqVO;
import com.byh.pojo.vo.mdtconsultation.DoctorOrderConsultationVo;
import com.byh.pojo.vo.mdtconsultation.DoctorReportListReqVo;
import com.byh.pojo.vo.mdtconsultation.ManagerMdtReqVO;
import com.byh.pojo.vo.mdtconsultation.MdtConsultationDataInfoVO;
import com.byh.pojo.vo.mdtconsultation.MdtHosManageOrderVo;
import com.byh.pojo.vo.mdtconsultation.MdtListReqVO;
import com.byh.pojo.vo.mdtconsultation.MdtReportDto;
import com.byh.pojo.vo.mdtconsultation.MdtWeChatListVo;
import com.byh.pojo.vo.mdtconsultation.PatientReportListReqVo;
import com.byh.pojo.vo.mdtconsultation.SuperOrderConsultationVo;
import com.byh.util.StringUtil;
import com.ebaiyihui.framework.response.BaseResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.Consts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u591a\u5b66\u79d1\u4f1a\u8bca\u5217\u8868"})
@RestController
@RequestMapping(value={"/api/v2/consultation/list"}, produces={"application/json;charset:UTF-8"})
public class MdtListController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(MdtListController.class);
    @Autowired
    private MdtConsultationManager mdtConsultationManager;

    @ApiOperation(value="\u60a3\u8005\u7aef\u6211\u7684\u62a5\u544a\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="patientId", value="\u60a3\u8005id", required=true, dataType="long", paramType="query"), @ApiImplicitParam(name="pageIndex", value="\u5f53\u524d\u9875", defaultValue="1", dataType="int", paramType="query"), @ApiImplicitParam(name="pageSize", value="\u6bcf\u9875\u6761\u6570", defaultValue="10", dataType="int", paramType="query")})
    @PostMapping(value={"/query_consultationReport_byPatientId"})
    public ResultInfo<List<MdtReportDto>> queryConsultationReportByPatient(@RequestBody PatientReportListReqVo patientReportListReqVo) {
        if (patientReportListReqVo == null) {
            return this.returnFailure("\u63d0\u4ea4\u53c2\u6570\u4e3a\u7a7a");
        }
        if (patientReportListReqVo.getPatientId() == null) {
            log.info("\u60a3\u8005id\u4e3a\u7a7a==========");
            return this.returnFailure("\u60a3\u8005id\u4e3a\u7a7a!");
        }
        return this.mdtConsultationManager.queryConsultationReportByPatient(patientReportListReqVo.getPatientId(), patientReportListReqVo.getPageIndex(), patientReportListReqVo.getPageSize());
    }

    @ApiOperation(value="\u533b\u751f\u7aef\u6211\u7684\u62a5\u544a\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="doctorId", value="\u533b\u751fid", required=true, dataType="long", paramType="query"), @ApiImplicitParam(name="type", value="\u7c7b\u578b", required=true, dataType="int", paramType="query"), @ApiImplicitParam(name="pageIndex", value="\u5f53\u524d\u9875", defaultValue="1", dataType="int", paramType="query"), @ApiImplicitParam(name="pageSize", value="\u6bcf\u9875\u6761\u6570", defaultValue="10", dataType="int", paramType="query"), @ApiImplicitParam(name="search", value="\u6a21\u7cca\u5b57\u6bb5", defaultValue="", dataType="String", paramType="query")})
    @PostMapping(value={"/query_consultationReport_byDoctorId"})
    public ResultInfo<List<MdtReportDto>> queryConsultationReportByDoctorId(@RequestBody DoctorReportListReqVo doctorReportListReqVo) {
        if (doctorReportListReqVo == null) {
            return this.returnFailure("\u63d0\u4ea4\u53c2\u6570\u4e3a\u7a7a");
        }
        if (doctorReportListReqVo.getDoctorId() == null || doctorReportListReqVo.getDoctorId().intValue() == 0) {
            return this.returnFailure("\u533b\u751fid\u9519\u8bef!");
        }
        if (doctorReportListReqVo.getType() == null || doctorReportListReqVo.getType() == 0) {
            return this.returnFailure("\u7c7b\u578b\u9519\u8bef!");
        }
        return this.mdtConsultationManager.queryConsultationReportByDoctorId(doctorReportListReqVo);
    }

    @GetMapping(value={"/weixin/getWeixinOrderList"})
    public BaseResponse<List<MdtWeChatListVo>> getWeixinOrderList(@RequestParam(value="pageIndex", required=false, defaultValue="1") Integer pageIndex, @RequestParam(value="pageSize", required=false, defaultValue="10") Integer pageSize, @RequestParam(value="patientId", required=false, defaultValue="0") Long patientId, @RequestParam(value="userId", required=false, defaultValue="0") Long userId, @RequestParam(value="appCode", required=true, defaultValue="") String appCode) {
        if (StringUtil.isEmpty((String)appCode)) {
            return BaseResponse.error((String)"\u8282\u70b9code\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List list = patientId != 0L ? this.mdtConsultationManager.getWeixinOrderListByPatientId(appCode, pageIndex, pageSize, patientId) : this.mdtConsultationManager.getWeixinOrderListByUserId(appCode, pageIndex, pageSize, userId);
        return BaseResponse.success((Object)list);
    }

    @ApiOperation(value="\u8d85\u7ea7\u7ba1\u7406\u5458_\u5bfc\u51faEXCEL-\u6570\u636e\u7ba1\u7406")
    @PostMapping(value={"/Admin/superExportExcel"})
    public void superExportExcel(@RequestBody ExcelParamVo excelParamVo, HttpServletResponse response) {
        response.setContentType("application/vnd.ms-excel");
        response.setCharacterEncoding(Consts.UTF_8.name());
        String fileName = "";
        String ids = excelParamVo.getIds() == null ? "" : excelParamVo.getIds();
        String search = excelParamVo.getSearch() == null ? "" : excelParamVo.getSearch();
        Integer type = excelParamVo.getType() == null ? 0 : excelParamVo.getType();
        Integer status = excelParamVo.getStatus() == null ? 0 : excelParamVo.getStatus();
        Integer timeType = excelParamVo.getTimeType() == null ? 0 : excelParamVo.getTimeType();
        String beginTime = excelParamVo.getBeginTime() == null ? "" : excelParamVo.getBeginTime();
        String endTime = excelParamVo.getEndTime() == null ? "" : excelParamVo.getEndTime();
        Integer qualified = excelParamVo.getQualified() == null ? 0 : excelParamVo.getQualified();
        Integer applicationChannels = excelParamVo.getApplicationChannels() == null ? 0 : excelParamVo.getApplicationChannels();
        try {
            fileName = URLEncoder.encode("\u4f1a\u8bca\u8868\u5355\u6570\u636e\u4fe1\u606f" + System.currentTimeMillis(), Consts.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        response.setHeader("Content-disposition", "attachment;filename=" + fileName + ".xlsx");
        try {
            EasyExcel.write((OutputStream)response.getOutputStream(), MdtConsultationDataInfoVO.class).sheet("\u4f1a\u8bca\u8868\u5355\u6570\u636e\u4fe1\u606f").doWrite(this.mdtConsultationManager.superAdminExportDataInfo(ids, search, type, status, timeType, beginTime, endTime, qualified, applicationChannels));
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    @GetMapping(value={"/superAdmin/order/data"})
    public BaseResponse<Map<String, Object>> superAdminOrderData(@RequestParam(value="search", required=false, defaultValue="") String search, @RequestParam(value="type", required=false, defaultValue="0") Integer type, @RequestParam(value="status", required=false, defaultValue="0") Integer status, @RequestParam(value="timeType", required=false, defaultValue="0") Integer timeType, @RequestParam(value="beginTime", required=false, defaultValue="") String beginTime, @RequestParam(value="endTime", required=false, defaultValue="") String endTime, @RequestParam(value="qualified", required=false, defaultValue="0") Integer qualified, @RequestParam(value="pageIndex", defaultValue="1") Integer pageIndex, @RequestParam(value="pageSize", defaultValue="20") Integer pageSize, @RequestParam(value="applicationChannels", defaultValue="0") Integer applicationChannels) {
        ManagerMdtReqVO mdtReqVO = new ManagerMdtReqVO();
        mdtReqVO.setSearch(search);
        mdtReqVO.setType(type);
        mdtReqVO.setStatus(status);
        mdtReqVO.setTimeType(timeType);
        mdtReqVO.setBeginTime(beginTime);
        mdtReqVO.setEndTime(endTime);
        mdtReqVO.setQualified(qualified);
        mdtReqVO.setPageIndex(pageIndex);
        mdtReqVO.setPageSize(pageSize);
        mdtReqVO.setApplicationChannels(applicationChannels);
        return BaseResponse.success((Object)this.mdtConsultationManager.superAdminOrderData(mdtReqVO));
    }

    @ApiOperation(value="\u7efc\u5408\u7ba1\u7406\u5e73\u53f0\u5bfc\u51fa\u4f1a\u8bca\u6570\u636eexcel")
    @PostMapping(value={"/Admin/exportExcel"})
    public void exportExcel(@RequestBody ExcelParamVo excelParamVo, HttpServletResponse response) {
        response.setContentType("application/vnd.ms-excel");
        response.setCharacterEncoding(Consts.UTF_8.name());
        String fileName = "";
        String ids = excelParamVo.getIds() == null ? "" : excelParamVo.getIds();
        String search = excelParamVo.getSearch() == null ? "" : excelParamVo.getSearch();
        Integer type = excelParamVo.getType() == null ? 0 : excelParamVo.getType();
        Integer status = excelParamVo.getStatus() == null ? 0 : excelParamVo.getStatus();
        Integer timeType = excelParamVo.getTimeType() == null ? 0 : excelParamVo.getTimeType();
        String beginTime = excelParamVo.getBeginTime() == null ? "" : excelParamVo.getBeginTime();
        String endTime = excelParamVo.getEndTime() == null ? "" : excelParamVo.getEndTime();
        Integer qualified = excelParamVo.getQualified() == null ? 0 : excelParamVo.getQualified();
        String userId = excelParamVo.getUserId() == null ? "" : excelParamVo.getUserId();
        String appCode = excelParamVo.getAppCode() == null ? "" : excelParamVo.getAppCode();
        Integer applicationChannels = excelParamVo.getApplicationChannels() == null ? 0 : excelParamVo.getApplicationChannels();
        try {
            fileName = URLEncoder.encode("\u4f1a\u8bca\u6570\u636e\u4fe1\u606f" + System.currentTimeMillis(), Consts.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        response.setHeader("Content-disposition", "attachment;filename=" + fileName + ".xlsx");
        try {
            EasyExcel.write((OutputStream)response.getOutputStream(), ConsultationDataInfoVO.class).sheet("\u4f1a\u8bca\u8ba2\u5355\u6570\u636e\u4fe1\u606f").doWrite(this.mdtConsultationManager.exportConsultationDataInfo(ids, appCode, search, type, status, timeType, beginTime, endTime, userId, qualified, applicationChannels));
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    @ApiOperation(value="\u7efc\u5408\u7ba1\u7406\u5e73\u53f0\u6570\u636e\u7edf\u8ba1\u63a5\u53e3")
    @GetMapping(value={"/management/order/data"})
    public ResultInfo<Map<String, Object>> orderDataManagement(@RequestHeader(value="userId", defaultValue="0") String userId, @RequestHeader(value="appCode", defaultValue="") String appCode, @RequestParam(value="search", required=false, defaultValue="") String search, @RequestParam(value="type", required=false, defaultValue="0") Integer type, @RequestParam(value="status", required=false, defaultValue="0") Integer status, @RequestParam(value="timeType", required=false, defaultValue="0") Integer timeType, @RequestParam(value="beginTime", required=false, defaultValue="") String beginTime, @RequestParam(value="endTime", required=false, defaultValue="") String endTime, @RequestParam(value="qualified", required=false, defaultValue="0") Integer qualified, @RequestParam(value="pageIndex", defaultValue="1") Integer pageIndex, @RequestParam(value="pageSize", defaultValue="20") Integer pageSize, @RequestParam(value="applicationChannels", defaultValue="0") Integer applicationChannels) {
        ManagerMdtReqVO mdtReqVO = new ManagerMdtReqVO();
        mdtReqVO.setUserId(userId);
        mdtReqVO.setAppCode(appCode);
        mdtReqVO.setSearch(search);
        mdtReqVO.setType(type);
        mdtReqVO.setStatus(status);
        mdtReqVO.setTimeType(timeType);
        mdtReqVO.setBeginTime(beginTime);
        mdtReqVO.setEndTime(endTime);
        mdtReqVO.setQualified(qualified);
        mdtReqVO.setPageIndex(pageIndex);
        mdtReqVO.setPageSize(pageSize);
        mdtReqVO.setApplicationChannels(applicationChannels);
        return this.mdtConsultationManager.queryManageDataConsultation(mdtReqVO);
    }

    @ApiOperation(value="\u7efc\u5408\u7ba1\u7406\u5e73\u53f0\u4f1a\u8bca\u8ba2\u5355\u5217\u8868")
    @PostMapping(value={"/query_hospitalManage_order_byHospitalId"})
    public ResultInfo<DoctorOrderConsultationVo> queryHospitalManageOrderByHospitalId(@RequestHeader(value="userId", defaultValue="0") String userId, @RequestHeader(value="appCode", defaultValue="") String appCode, @RequestParam(value="pageIndex", required=false, defaultValue="1") Integer pageIndex, @RequestParam(value="pageSize", required=false, defaultValue="20") Integer pageSize, @RequestParam(value="search", required=false, defaultValue="") String search, @RequestParam(value="beginTime", required=false, defaultValue="") String beginTime, @RequestParam(value="endTime", required=false, defaultValue="") String endTime, @RequestParam(value="depName", required=false, defaultValue="") String depName, @RequestParam(value="status", required=false, defaultValue="0") Integer status, @RequestParam(value="isSponsor", defaultValue="3") Integer isSponsor, @RequestParam(value="type", required=false, defaultValue="0") Integer type, @RequestParam(value="reportStatus", required=false) Integer reportStatus, @RequestParam(value="timeType", required=false, defaultValue="1") Integer timeType, @RequestParam(value="applicationChannels", defaultValue="0") Integer applicationChannels, @RequestParam(value="isMdt", required=false, defaultValue="1") Integer isMdt) {
        ManagerMdtReqVO mdtReqVO = new ManagerMdtReqVO();
        mdtReqVO.setUserId(userId);
        mdtReqVO.setAppCode(appCode);
        mdtReqVO.setPageIndex(pageIndex);
        mdtReqVO.setPageSize(pageSize);
        mdtReqVO.setSearch(search);
        mdtReqVO.setBeginTime(beginTime);
        mdtReqVO.setEndTime(endTime);
        mdtReqVO.setDepName(depName);
        mdtReqVO.setStatus(status);
        mdtReqVO.setIsSponsor(isSponsor);
        mdtReqVO.setType(type);
        mdtReqVO.setReportStatus(reportStatus);
        mdtReqVO.setTimeType(timeType);
        mdtReqVO.setApplicationChannels(applicationChannels);
        mdtReqVO.setIsMdt(isMdt);
        return this.mdtConsultationManager.queryHospitalManageOrderByHospitalId(mdtReqVO);
    }

    @ApiOperation(value="\u67e5\u8be2\u4f1a\u8bca\u8ba2\u5355\u5217\u8868")
    @GetMapping(value={"query_consultation_list"})
    public ResultInfo<SuperOrderConsultationVo> queryConsultationList(@RequestParam(value="pageIndex", required=false, defaultValue="1") Integer pageIndex, @RequestParam(value="pageSize", required=false, defaultValue="20") Integer pageSize, @RequestParam(value="beginTime", required=false, defaultValue="") String beginTime, @RequestParam(value="endTime", required=false, defaultValue="") String endTime, @RequestParam(value="status", required=false, defaultValue="") Integer status, @RequestParam(value="depName", required=false, defaultValue="") String depName, @RequestParam(value="search", required=false, defaultValue="") String search, @RequestParam(value="type", required=false, defaultValue="0") Integer type, @RequestParam(value="reportStatus", required=false) Integer reportStatus, @RequestParam(value="timeType", required=false, defaultValue="1") Integer timeType, @RequestParam(value="applicationChannels", defaultValue="0") Integer applicationChannels) {
        AdminMdtListReqVO mdtReqVO = new AdminMdtListReqVO();
        mdtReqVO.setPageIndex(pageIndex);
        mdtReqVO.setPageSize(pageSize);
        mdtReqVO.setBeginTime(beginTime);
        mdtReqVO.setEndTime(endTime);
        mdtReqVO.setStatus(status);
        mdtReqVO.setDepName(depName);
        mdtReqVO.setSearch(search);
        mdtReqVO.setType(type);
        mdtReqVO.setReportStatus(reportStatus);
        mdtReqVO.setTimeType(timeType);
        mdtReqVO.setApplicationChannels(applicationChannels);
        return this.mdtConsultationManager.queryConsultationList(mdtReqVO);
    }

    @ApiOperation(value="\u67e5\u8be2\u533b\u751f\u8ba2\u5355\u5217\u8868")
    @GetMapping(value={"/query_consultation_list_by_doctor_id"})
    public ResultInfo<DoctorOrderConsultationVo> queryConsultationListByDoctorId(MdtListReqVO mdtListReqVO) {
        return this.mdtConsultationManager.queryConsultationListByDoctorId(mdtListReqVO);
    }

    @PostMapping(value={"/app"})
    public BaseResponse<List<AppOrderListVo>> getAppOrderList(@RequestBody OrderReqVo orderReqVo) {
        return this.mdtConsultationManager.getMdtAppOrderList(orderReqVo);
    }

    @GetMapping(value={"/userRefundConsultation"})
    @ApiOperation(value="\u60a3\u8005\u7533\u8bf7\u9000\u6b3e")
    public BaseResponse<String> userRefundConsultation(@RequestParam(value="consultationId") Long consultationId, @RequestParam(value="refundReason") String refundReason) {
        log.info("\u7528\u6237\u8981\u7533\u8bf7\u9000\u6b3e\u7684\u8ba2\u5355ID\u662f:{},\u9000\u6b3e\u539f\u56e0\u662f:{}", (Object)consultationId, (Object)refundReason);
        String ret = this.mdtConsultationManager.userRefundConsultation(consultationId, refundReason);
        return BaseResponse.success((Object)ret);
    }

    @GetMapping(value={"/userGetRefundStatusConsultation"})
    @ApiOperation(value="\u7528\u6237\u83b7\u53d6\u8ba2\u5355\u7684\u9000\u6b3e\u72b6\u6001")
    public BaseResponse<UserRefundRespVo> userGetRefundStatusConsultation(@RequestParam(value="consultationId") Long consultationId) {
        UserRefundRespVo userRefundRespVo = this.mdtConsultationManager.userGetRefundStatusConsultation(consultationId);
        return BaseResponse.success((Object)userRefundRespVo);
    }

    @PostMapping(value={"/adminRefundConsultation"})
    @ApiOperation(value="\u7ba1\u7406\u5458\u7533\u8bf7\u9000\u6b3e")
    public BaseResponse<ResultInfo<String>> adminRefundConsultation(@RequestBody @Validated AdminRefundConsultationReqVo adminRefundConsultationReqVo) {
        ResultInfo res = this.mdtConsultationManager.adminRefundConsultation(adminRefundConsultationReqVo);
        return BaseResponse.success((Object)res);
    }

    @PostMapping(value={"/adminAuditRefundConsultation"})
    @ApiOperation(value="\u7ba1\u7406\u5458\u5ba1\u6838\u7533\u8bf7\u9000\u6b3e\u8ba2\u5355")
    public BaseResponse<ResultInfo<String>> adminAuditRefundConsultation(@RequestBody @Validated AdminAuditConsultationReqVo adminAuditConsultationReqVo) {
        ResultInfo res = this.mdtConsultationManager.adminAuditRefundConsultation(adminAuditConsultationReqVo);
        return BaseResponse.success((Object)res);
    }

    @ApiOperation(value="\u7b2c\u4e09\u65b9\u5e73\u53f0\u4f1a\u8bca\u8ba2\u5355\u5217\u8868")
    @PostMapping(value={"/listConsultation"})
    public ResultInfo<List<MdtHosManageOrderVo>> listConsultation(@RequestBody ManagerMdtReqVO mdtReqVO) {
        return this.mdtConsultationManager.listConsultation(mdtReqVO);
    }
}

