/*
 * Decompiled with CFR 0.152.
 */
package com.byh.controller.mdtconsultation;

import com.byh.common.ResultInfo;
import com.byh.controller.BaseController;
import com.byh.manage.mdt.MdtManage;
import com.byh.pojo.mdt.dto.OrderDetailMdtDto;
import com.byh.pojo.mdt.dto.OrderVideoingDto;
import com.byh.pojo.mdt.dto.PatientInfoDto;
import com.byh.pojo.mdt.vo.ApplicationPatientInfoParamVo;
import com.byh.pojo.mdt.vo.HealthDoctorParamVo;
import com.byh.pojo.mdt.vo.OrderImproveMdtVo;
import com.byh.pojo.mdt.vo.OrderMdtVo;
import com.byh.pojo.mdt.vo.OrderPatientMdtVo;
import com.byh.pojo.mdt.vo.OrderVideoingVo;
import com.byh.pojo.mdt.vo.PatientSignatureVo;
import com.byh.pojo.mdt.vo.SignatureParamVo;
import com.byh.pojo.mdt.vo.UpdateAppointmentTimeVo;
import com.byh.pojo.mdt.vo.UpdatePatientCaseVo;
import com.byh.pojo.mdt.vo.VideoOngoingVo;
import com.doctor.basedata.api.vo.RetBusinessDoctorListVo;
import com.ebaiyihui.framework.page.PageResult;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/mdt"}, produces={"application/json;charset:UTF-8"})
public class MdtOrderController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(MdtOrderController.class);
    @Autowired
    private MdtManage mdtManage;

    @ApiOperation(value="\u533b\u751f\u7aef\u7533\u8bf7")
    @PostMapping(value={"/addOrder"})
    public ResultInfo<String> saveOrder(@RequestBody OrderMdtVo orderMdtVo) {
        return this.mdtManage.saveOrder(orderMdtVo);
    }

    @ApiOperation(value="\u60a3\u8005\u7b7e\u540d")
    @PostMapping(value={"/patientSignature"})
    public ResultInfo<String> patientSignature(@RequestBody PatientSignatureVo patientSignatureVo) {
        return this.mdtManage.patientSignature(patientSignatureVo);
    }

    @ApiOperation(value="\u60a3\u8005\u7aef\u7533\u8bf7")
    @PostMapping(value={"/addOrderPatient"})
    public ResultInfo<String> addOrderPatient(@RequestBody OrderPatientMdtVo orderPatientMdtVo) {
        return this.mdtManage.addOrderPatient(orderPatientMdtVo);
    }

    @ApiOperation(value="\u5b8c\u5584\u60a3\u8005\u8ba2\u5355")
    @PostMapping(value={"/improveOrder"})
    public ResultInfo<String> improveOrder(@RequestBody OrderImproveMdtVo orderImproveMdtVo) {
        return this.mdtManage.improveOrder(orderImproveMdtVo);
    }

    @ApiOperation(value="\u533b\u8054\u4f53\u4e13\u5bb6\u5217\u8868 \u9ed8\u8ba4\u5168\u90e8")
    @PostMapping(value={"/healthAllianceDoctorList"})
    public ResultInfo<PageResult<RetBusinessDoctorListVo>> healthAllianceDoctorList(@RequestBody HealthDoctorParamVo healthDoctorParamVo) {
        log.info("\u533b\u8054\u4f53\u4e13\u5bb6\u5217\u8868 \u9ed8\u8ba4\u5168\u90e8\u4f20\u9012\u7684\u53c2\u6570\u662f:{}", (Object)healthDoctorParamVo.toString());
        return this.mdtManage.healthAllianceDoctorList(healthDoctorParamVo);
    }

    @ApiOperation(value="web \u9009\u62e9\u60a3\u8005\u5217\u8868")
    @PostMapping(value={"/queryOncePatient"})
    public ResultInfo<List<PatientInfoDto>> queryOncePatient(@RequestBody ApplicationPatientInfoParamVo applicationPatientInfoParamVo) {
        log.info("web \u9009\u62e9\u60a3\u8005\u5217\u8868\u4f20\u9012\u7684\u53c2\u6570\u662f:{}", (Object)applicationPatientInfoParamVo.toString());
        return this.mdtManage.queryOncePatient(applicationPatientInfoParamVo);
    }

    @ApiOperation(value="APP \u65b0\u7533\u8bf7\u8ba2\u5355\u60a3\u8005\u4fe1\u606f\u5217\u8868")
    @PostMapping(value={"/queryNewApplicationPatientInfoList"})
    public ResultInfo<List<PatientInfoDto>> queryNewApplicationPatientInfoList(@RequestBody ApplicationPatientInfoParamVo applicationPatientInfoParamVo) {
        log.info("\u65b0\u7533\u8bf7\u8ba2\u5355\u60a3\u8005\u4fe1\u606f\u5217\u8868\u4f20\u9012\u7684\u53c2\u6570\u662f:{}", (Object)applicationPatientInfoParamVo.toString());
        return this.mdtManage.queryNewApplicationPatientInfoList(applicationPatientInfoParamVo);
    }

    @ApiOperation(value="\u8ba2\u5355\u8be6\u60c5")
    @GetMapping(value={"/orderDetail"})
    public ResultInfo<OrderDetailMdtDto> orderDetail(@RequestParam(value="orderViewId") String orderViewId, @RequestParam(value="doctorId", defaultValue="0") Long doctorId) {
        log.info("\u8ba2\u5355\u8be6\u60c5\u4f20\u9012\u7684\u53c2\u6570\u662f:{},{}", (Object)orderViewId, (Object)doctorId);
        return this.mdtManage.orderDetail(orderViewId, doctorId);
    }

    @ApiOperation(value="\u4fee\u6539\u75c5\u4f8b")
    @PostMapping(value={"/updatePatientCaseInfo"})
    public ResultInfo<String> updatePatientCaseInfo(@RequestBody UpdatePatientCaseVo updatePatientCaseVo) {
        log.info("\u4fee\u6539\u75c5\u4f8b\u4f20\u9012\u7684\u53c2\u6570\u662f:{}", (Object)updatePatientCaseVo.toString());
        return this.mdtManage.updatePatientCaseInfo(updatePatientCaseVo);
    }

    @ApiOperation(value="\u9884\u7ea6\u65f6\u95f4\u4fee\u6539")
    @PostMapping(value={"/updateAppointmentTime"})
    public ResultInfo<String> updateAppointmentTime(@RequestBody UpdateAppointmentTimeVo updateAppointmentTimeVo) {
        return this.mdtManage.updateAppointmentTime(updateAppointmentTimeVo);
    }

    @ApiOperation(value="\u8ba2\u5355\u89c6\u9891\u72b6\u6001")
    @PostMapping(value={"/updateVideoOngoing"})
    public ResultInfo<String> updateVideoOngoing(@RequestBody VideoOngoingVo videoOngoingVo) {
        log.info("\u8ba2\u5355\u89c6\u9891\u72b6\u6001\u4f20\u9012\u7684\u53c2\u6570\u662f:{}", (Object)videoOngoingVo.toString());
        return this.mdtManage.updateVideoOngoing(videoOngoingVo);
    }

    @ApiOperation(value="\u6b63\u5728\u89c6\u9891\u4e2d\u8ba2\u5355")
    @PostMapping(value={"/selectOrderVideoing"})
    public ResultInfo<List<OrderVideoingDto>> selectOrderVideoing(@RequestBody OrderVideoingVo orderVideoingVo) {
        log.info("\u6b63\u5728\u89c6\u9891\u4e2d\u8ba2\u5355\u4f20\u9012\u7684\u53c2\u6570\u662f:{}", (Object)orderVideoingVo.toString());
        if (orderVideoingVo.getDoctorId().intValue() == 0) {
            return this.returnSucceed(new ArrayList(), "\u53c2\u6570\u533b\u751fid\u4e3a0");
        }
        return this.mdtManage.selectOrderVideoing(orderVideoingVo);
    }

    @ApiOperation(value="\u83b7\u53d6\u60a3\u8005\u901a\u8fc7\u4e8c\u7ef4\u7801\u4e0a\u4f20\u7684\u60a3\u8005\u7b7e\u540d")
    @PostMapping(value={"/selectPatientSignatureQrCode"})
    public ResultInfo<String> selectPatientSignatureQrCode(@RequestBody SignatureParamVo signatureParamVo) {
        log.info("\u83b7\u53d6\u60a3\u8005\u901a\u8fc7\u4e8c\u7ef4\u7801\u4e0a\u4f20\u7684\u60a3\u8005\u7b7e\u540d\u4f20\u9012\u7684\u53c2\u6570\u662f:{}", (Object)signatureParamVo.toString());
        return this.mdtManage.selectPatientSignatureQrCode(signatureParamVo);
    }
}

