/*
 * Decompiled with CFR 0.152.
 */
package com.byh.controller.patient;

import com.byh.enums.ReturnCodeEnum;
import com.byh.pojo.entity.patient.PatientCaseInfoEntity;
import com.byh.pojo.vo.patient.CaseVO;
import com.byh.pojo.vo.patient.PatientCaseInfoVO;
import com.byh.service.patient.PatientCaseInfoService;
import com.ebaiyihui.framework.response.BaseResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u60a3\u8005\u75c5\u4f8b\u4fe1\u606f\u63a5\u53e3"})
@RestController
@RequestMapping(value={"/api/v1/patient_patientcaseinfo"}, produces={"application/json;charset:UTF-8"})
public class PatientCaseInfoController {
    private static final Logger log = LoggerFactory.getLogger(PatientCaseInfoController.class);
    @Autowired
    private PatientCaseInfoService patientCaseInfoService;

    @ApiOperation(value="\u6839\u636eid\u5220\u9664PatientCaseInfo")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="id", required=true, dataType="Long", paramType="query")})
    @PostMapping(value={"/deletebyid"})
    public BaseResponse<Integer> deletePatientCaseInfoById(@RequestParam(value="id") Long id) {
        this.patientCaseInfoService.deletePatientCaseInfoById(id);
        return BaseResponse.success();
    }

    @ApiOperation(value="\u6dfb\u52a0patientInfoEntity")
    @PostMapping(value={"/save"})
    public BaseResponse<PatientCaseInfoVO> savePatientCaseInfo(@RequestBody PatientCaseInfoVO patientCaseInfoVO) {
        PatientCaseInfoVO patientCaseInfo = this.patientCaseInfoService.insertPatientCaseInfo(patientCaseInfoVO);
        return BaseResponse.success((Object)patientCaseInfo);
    }

    @ApiOperation(value="\u4fdd\u5b58patientCaseInfo\u5217\u8868")
    @PostMapping(value={"/save_patient_case_info_list"})
    public BaseResponse<List<PatientCaseInfoVO>> savePatientCaseInfoList(@RequestBody List<PatientCaseInfoVO> patientCaseInfoVO) {
        ArrayList<PatientCaseInfoVO> patientCaseInfoVOList = new ArrayList<PatientCaseInfoVO>();
        for (PatientCaseInfoVO patientCaseInfo : patientCaseInfoVO) {
            PatientCaseInfoVO patientCaseInfo1 = this.patientCaseInfoService.insertPatientCaseInfo(patientCaseInfo);
            if (patientCaseInfo1 == null) {
                return BaseResponse.error((String)ReturnCodeEnum.FAILURE.getDisplay());
            }
            patientCaseInfoVOList.add(patientCaseInfo1);
        }
        return BaseResponse.success(patientCaseInfoVOList);
    }

    @ApiOperation(value="\u53ef\u9009\u62e9\u7684\u4fdd\u5b58patientCaseInfo\u5c5e\u6027")
    @PostMapping(value={"/saveselective"})
    public BaseResponse<PatientCaseInfoVO> savePatientCaseInfoSelective(@RequestBody PatientCaseInfoVO patientCaseInfoVO) {
        PatientCaseInfoVO n = this.patientCaseInfoService.insertPatientCaseInfo(patientCaseInfoVO);
        if (n == null) {
            return BaseResponse.error((String)ReturnCodeEnum.FAILURE.getDisplay());
        }
        return BaseResponse.success((Object)n);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2PatientCaseInfo")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="id", required=true, dataType="Long", paramType="query")})
    @GetMapping(value={"/getbyid"})
    public BaseResponse<PatientCaseInfoEntity> getPatientCaseInfoById(@RequestParam(value="id") Long id) {
        PatientCaseInfoEntity patientCaseInfo = this.patientCaseInfoService.selectPatientCaseInfoById(id);
        return BaseResponse.success((Object)patientCaseInfo);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2\u60a3\u8005\u75c5\u4f8b\u8be6\u60c5")
    @GetMapping(value={"/findPatientCaseInfoById"})
    public BaseResponse<PatientCaseInfoEntity> findPatientCaseInfoById(@RequestParam(value="id") Long id) {
        PatientCaseInfoEntity patientCaseInfo = this.patientCaseInfoService.findPatientCaseInfoById(id);
        return BaseResponse.success((Object)patientCaseInfo);
    }

    @ApiOperation(value="\u901a\u8fc7\u591a\u4e2aid\u67e5\u8be2\u60a3\u8005\u75c5\u4f8b\u4fe1\u606f\u5217\u8868")
    @PostMapping(value={"/get_patient_case_info_list_by_ids"})
    public BaseResponse<List<PatientCaseInfoEntity>> getPatientCaseInfoById(@RequestBody List<Long> ids) {
        log.info("\u8f93\u5165\u53c2\u6570\uff1a" + ids.toString());
        List patientCaseInfo = this.patientCaseInfoService.findPatientCaseInfoListByIds(ids);
        return BaseResponse.success((Object)patientCaseInfo);
    }

    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u53ef\u7528\u7684\u7684PatientCaseInfo")
    @GetMapping(value={"/getallvalid"})
    public BaseResponse<List<PatientCaseInfoEntity>> getAllValidPatientCaseInfo() {
        List patientCaseInfoList = this.patientCaseInfoService.selectPatientCaseInfoByStatus(Integer.valueOf(1));
        return BaseResponse.success((Object)patientCaseInfoList);
    }

    @ApiOperation(value="\u901a\u8fc7id\u53ef\u9009\u62e9\u7684\u4fee\u6539patientCaseInfo\u5c5e\u6027")
    @PostMapping(value={"/updatebyid"})
    public BaseResponse<Integer> updatePatientCaseInfoByIdSelective(@RequestBody PatientCaseInfoVO patientCaseInfoVO) {
        Integer n = this.patientCaseInfoService.updatePatientCaseInfoByIdSelective(patientCaseInfoVO);
        if (n == 0) {
            return BaseResponse.error((String)ReturnCodeEnum.FAILURE.getDisplay());
        }
        return BaseResponse.success((Object)n);
    }

    @ApiOperation(value="\u6839\u636e\u60a3\u8005id\u4e0e\u75c5\u4f8b\u7c7b\u578b\u4e0e\u79d1\u5ba4\u4e0e\u65f6\u95f4\u67e5\u8be2\u60a3\u8005\u75c5\u4f8b\u5217\u8868")
    @GetMapping(value={"/findPatientCaseListByPatientIdAndDeptIdAndCaseTypeAndInputTime"})
    public BaseResponse<List<CaseVO>> findPatientCaseListByPatientIdAndDeptIdAndCaseTypeAndInputTime(@RequestParam(value="patientViewId") String patientViewId, @RequestParam(value="deptId", required=false) Long deptId, @RequestParam(value="caseType", required=false) Integer caseType, @RequestParam(value="startTime", required=false) String startTime, @RequestParam(value="endTime", required=false) String endTime) {
        List patientCaseInfoDTOList = this.patientCaseInfoService.findPatientCaseListByPatientIdAndDeptIdAndCaseTypeAndInputTime(patientViewId, deptId, caseType, startTime, endTime);
        return BaseResponse.success((Object)patientCaseInfoDTOList);
    }
}

