/*
 * Decompiled with CFR 0.152.
 */
package com.byh.manage.consultation;

import com.byh.manage.consultation.RemoteManage;
import com.byh.pojo.dto.pay.PayNotifyAggregationVo;
import com.byh.pojo.dto.pay.PayNotifyReqVO;
import com.byh.pojo.dto.pay.RefundCallbackVo;
import com.byh.pojo.entity.consultation.ConsultationEntity;
import com.byh.pojo.entity.consultation.ServiceMerchantConfigEntity;
import com.byh.pojo.entity.consultation.ServicePayBillEntity;
import com.byh.service.cosultation.ServiceMerchantConfigService;
import com.byh.service.cosultation.ServicePayBillService;
import com.byh.util.SignUtil;
import com.byh.util.StringUtil;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class AggregationPayManage {
    private static final Logger log = LoggerFactory.getLogger(AggregationPayManage.class);
    @Autowired
    private RemoteManage remoteManage;
    @Autowired
    private ServiceMerchantConfigService serviceMerchantConfigService;
    @Autowired
    private ServicePayBillService servicePayBillService;

    @Async
    public void aggregationPayCallback(PayNotifyReqVO payNotifyReqVO, ConsultationEntity order) {
        log.info("\u652f\u4ed8\u8d26\u5355\u2014\u2014\u805a\u5408\u652f\u4ed8\u56de\u8c03\u53c2\u6570payNotifyReqVO\uff1a{}\uff1b", (Object)payNotifyReqVO);
        String appCode = this.remoteManage.getAppCodeByHospitalId(Integer.valueOf(order.getDoctorHospitalId().intValue()));
        log.info("\u652f\u4ed8\u8d26\u5355\u2014\u2014appCode\uff1a{}\uff1b", (Object)appCode);
        ServiceMerchantConfigEntity serviceMerchantConfigEntity = this.serviceMerchantConfigService.selectByApplyId(payNotifyReqVO.getApplyId());
        log.info("\u652f\u4ed8\u8d26\u5355\u2014\u2014serviceMerchantConfigEntity\uff1a{}\uff1b", (Object)serviceMerchantConfigEntity);
        String organName = StringUtil.convertHanzi2Pinyin((String)order.getDoctorHosName(), (boolean)false).toUpperCase();
        String serviceCode = appCode + "_" + organName + "_YCHZ";
        PayNotifyAggregationVo payNotifyAggregationVo = new PayNotifyAggregationVo();
        payNotifyAggregationVo.setReturnCode(payNotifyReqVO.getReturnCode());
        payNotifyAggregationVo.setReturnMsg(payNotifyReqVO.getReturnMsg());
        payNotifyAggregationVo.setResultCode(payNotifyReqVO.getResultCode());
        payNotifyAggregationVo.setErrCode(payNotifyReqVO.getErrCode());
        payNotifyAggregationVo.setErrCodeDes(payNotifyReqVO.getErrCodeDes());
        payNotifyAggregationVo.setPayChannel(payNotifyReqVO.getPayChannel());
        payNotifyAggregationVo.setServiceCode(payNotifyReqVO.getServiceCode());
        payNotifyAggregationVo.setDealTradeNo(payNotifyReqVO.getDealTradeNo());
        payNotifyAggregationVo.setOutTradeNo(payNotifyReqVO.getOutTradeNo());
        payNotifyAggregationVo.setTotalAmount(payNotifyReqVO.getTotalAmount());
        payNotifyAggregationVo.setPayTime(payNotifyReqVO.getPayTime());
        payNotifyAggregationVo.setTradeNo(payNotifyReqVO.getTradeNo());
        payNotifyAggregationVo.setMchCode(payNotifyReqVO.getMchCode());
        payNotifyAggregationVo.setMchId(payNotifyReqVO.getMchId());
        payNotifyAggregationVo.setMchName(payNotifyReqVO.getMchName());
        payNotifyAggregationVo.setNotifyResultStr(payNotifyReqVO.getNotifyResultStr());
        payNotifyAggregationVo.setAttach(payNotifyReqVO.getAttach());
        payNotifyAggregationVo.setRemake(payNotifyReqVO.getRemake());
        payNotifyAggregationVo.setSign(payNotifyReqVO.getSign());
        payNotifyAggregationVo.setApplyId(payNotifyReqVO.getApplyId());
        log.info("\u652f\u4ed8\u8d26\u5355\u2014\u2014payNotifyAggregationVo\uff1a{}\uff1b", (Object)payNotifyAggregationVo);
        Map map = SignUtil.getKeyAndValue((Object)payNotifyAggregationVo);
        Boolean bool = SignUtil.checkSign((Map)map, (String)serviceMerchantConfigEntity.getApplyKey());
        log.info("\u652f\u4ed8\u8d26\u5355\u2014\u2014\u9a8c\u7b7e\u7ed3\u679cbool\uff1a{}\uff1b", (Object)bool);
        if (bool.booleanValue()) {
            ServicePayBillEntity servicePayBillEntity = new ServicePayBillEntity();
            servicePayBillEntity.setStatus(Integer.valueOf(3));
            servicePayBillEntity.setAppCode(appCode);
            servicePayBillEntity.setOrganName(organName);
            servicePayBillEntity.setWorkServiceCode("YCHZ");
            servicePayBillEntity.setApplyCode(serviceMerchantConfigEntity.getMerchantSeq());
            servicePayBillEntity.setPayChannel(payNotifyAggregationVo.getPayChannel());
            servicePayBillEntity.setTradeTime(payNotifyAggregationVo.getPayTime());
            servicePayBillEntity.setTradeNo(payNotifyAggregationVo.getTradeNo());
            servicePayBillEntity.setOutTradeNo(payNotifyAggregationVo.getOutTradeNo());
            servicePayBillEntity.setTradeStatus("SUCCESS");
            servicePayBillEntity.setOrderAmount(payNotifyAggregationVo.getTotalAmount());
            servicePayBillEntity.setDealAmount(payNotifyAggregationVo.getTotalAmount());
            servicePayBillEntity.setServiceCode(serviceCode);
            servicePayBillEntity.setDealTradeNo(payNotifyAggregationVo.getDealTradeNo());
            log.info("\u652f\u4ed8\u8d26\u5355\u2014\u2014\u805a\u5408\u652f\u4ed8\u56de\u8c03\u6570\u636e\u4fdd\u5b58servicePayBillEntity\uff1a{}\uff1b", (Object)servicePayBillEntity);
            this.servicePayBillService.insert(servicePayBillEntity);
        }
    }

    public void aggregationRefundCallback(RefundCallbackVo refundCallbackVo, ConsultationEntity consultationEntity) {
        log.info("\u652f\u4ed8\u8d26\u5355\u2014\u2014\u9000\u6b3e\u652f\u4ed8\u56de\u8c03\u53c2\u6570refundCallbackVo\uff1a{}\uff1b", (Object)refundCallbackVo);
        ServiceMerchantConfigEntity serviceMerchantConfigEntity = this.serviceMerchantConfigService.selectByApplyId(refundCallbackVo.getApplyId());
        log.info("\u652f\u4ed8\u8d26\u5355\u2014\u2014\u9000\u6b3e\u652f\u4ed8\u56de\u8c03serviceMerchantConfigEntity\uff1a{}\uff1b", (Object)serviceMerchantConfigEntity);
        List servicePayBillEntityList = this.servicePayBillService.selectByOutTradeNo(consultationEntity.getViewId());
        ServicePayBillEntity servicePayBillEntity = (ServicePayBillEntity)servicePayBillEntityList.get(0);
        String organName = StringUtil.convertHanzi2Pinyin((String)consultationEntity.getDoctorHosName(), (boolean)false).toUpperCase();
        String serviceCode = serviceMerchantConfigEntity.getAppCode() + "_" + organName + "_YCHZ";
        Map map = SignUtil.getKeyAndValue((Object)refundCallbackVo);
        Boolean bool = SignUtil.checkSign((Map)map, (String)serviceMerchantConfigEntity.getApplyKey());
        if (bool.booleanValue()) {
            ServicePayBillEntity refundPayBillEntity = new ServicePayBillEntity();
            refundPayBillEntity.setStatus(Integer.valueOf(6));
            refundPayBillEntity.setRemark("");
            refundPayBillEntity.setAppCode(serviceMerchantConfigEntity.getAppCode());
            refundPayBillEntity.setOrganName(organName);
            refundPayBillEntity.setWorkServiceCode("YCHZ");
            refundPayBillEntity.setApplyCode(serviceMerchantConfigEntity.getMerchantSeq());
            refundPayBillEntity.setPayChannel(refundCallbackVo.getPayChannel());
            refundPayBillEntity.setTradeTime(servicePayBillEntity.getTradeTime());
            refundPayBillEntity.setTradeNo(servicePayBillEntity.getTradeNo());
            refundPayBillEntity.setOutTradeNo(refundCallbackVo.getOutTradeNo());
            refundPayBillEntity.setTradeStatus("SUCCESS");
            refundPayBillEntity.setOrderAmount(refundCallbackVo.getTotalAmount());
            refundPayBillEntity.setDealAmount(refundCallbackVo.getTotalAmount());
            refundPayBillEntity.setRefundNo(refundCallbackVo.getRefundNo());
            refundPayBillEntity.setOutRefundNo(refundCallbackVo.getRefundNo());
            refundPayBillEntity.setRefundTime(refundCallbackVo.getRefundTime());
            refundPayBillEntity.setRefundAmount(refundCallbackVo.getRefundMoney());
            refundPayBillEntity.setServiceCode(serviceCode);
            refundPayBillEntity.setDealTradeNo(refundCallbackVo.getDealTradeNo());
            log.info("\u652f\u4ed8\u8d26\u5355\u2014\u2014\u9000\u6b3e\u652f\u4ed8\u56de\u8c03\u6570\u636e\u4fdd\u5b58refundPayBillEntity\uff1a{}\uff1b", (Object)refundPayBillEntity);
            this.servicePayBillService.insert(refundPayBillEntity);
        }
    }
}

