/*
 * Decompiled with CFR 0.152.
 */
package com.byh.manage.consultation;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.byh.manage.consultation.TRTCManage;
import com.byh.pojo.entity.consultation.ConsultationEntity;
import com.byh.pojo.entity.consultation.RtcRoomEntity;
import com.ebaiyihui.framework.response.BaseResponse;
import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.cvm.v20170312.models.DescribeZonesRequest;
import com.tencentcloudapi.vod.v20180717.models.SearchMediaResponse;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import redis.clients.jedis.JedisCluster;

@Service
public class BusinessManage {
    private static final Logger log = LoggerFactory.getLogger(BusinessManage.class);
    @Autowired
    private TRTCManage trtcManage;
    @Autowired
    private JedisCluster jedisCluster;

    public Map<String, String> getVideoDetailL(ConsultationEntity consultationEntity) {
        String sdkAccountId;
        RtcRoomEntity rtcRoomEntity = this.trtcManage.getByOrderIdAndOrderType(consultationEntity.getId(), consultationEntity.getType());
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            sdkAccountId = this.trtcManage.getSdkAccount("master", consultationEntity);
            String expertStreamId = this.trtcManage.getUnitVedioId(rtcRoomEntity.getId(), sdkAccountId);
            SearchMediaResponse expertMediaRespose = this.trtcManage.getVedioInfoByStreamId(expertStreamId);
            String info = DescribeZonesRequest.toJsonString((AbstractModel)expertMediaRespose);
            JSONArray jsonArray = JSONObject.parseObject((String)info).getJSONArray("MediaInfoSet");
            String mediaInfo = jsonArray.getJSONObject(0).getJSONObject("BasicInfo").getString("MediaUrl");
            map.put("expertVideoDetail", mediaInfo);
        }
        catch (Exception e) {
            log.info("======\u83b7\u53d6\u4e13\u5bb6\u7aef\u89c6\u9891\u5f02\u5e38=====");
            log.error(e.getMessage(), (Throwable)e);
        }
        try {
            sdkAccountId = this.trtcManage.getSdkAccount("slave", consultationEntity);
            String doctorStreamId = this.trtcManage.getUnitVedioId(rtcRoomEntity.getId(), sdkAccountId);
            SearchMediaResponse doctorMediaRespose = this.trtcManage.getVedioInfoByStreamId(doctorStreamId);
            String info2 = DescribeZonesRequest.toJsonString((AbstractModel)doctorMediaRespose);
            JSONArray jsonArray2 = JSONObject.parseObject((String)info2).getJSONArray("MediaInfoSet");
            String mediaInfo2 = jsonArray2.getJSONObject(0).getJSONObject("BasicInfo").getString("MediaUrl");
            map.put("doctorVideoDetail", mediaInfo2);
        }
        catch (Exception e) {
            log.info("======\u83b7\u53d6\u533b\u751f\u7aef\u89c6\u9891\u5f02\u5e38=====", (Throwable)e);
        }
        return map;
    }

    public BaseResponse<String> saveOrUpdateSignCode(String appCode, String signCode) {
        String value = this.jedisCluster.set("consultation_sign_code:" + appCode, signCode);
        return BaseResponse.success((Object)value);
    }

    public BaseResponse<String> getSignCodeByAppCode(String appCode) {
        String value = this.jedisCluster.get("consultation_sign_code:" + appCode);
        return BaseResponse.success((Object)value);
    }
}

