/*
 * Decompiled with CFR 0.152.
 */
package com.byh.manage.consultation;

import com.alibaba.fastjson.JSONObject;
import com.byh.common.ResultInfo;
import com.byh.constants.ConsultationConstant;
import com.byh.constants.ReportConstant;
import com.byh.controller.BaseController;
import com.byh.enums.BillBusinessTypeEnum;
import com.byh.enums.DoctorServiceEnum;
import com.byh.enums.OrderStatusEnum;
import com.byh.enums.OrderTypeEnum;
import com.byh.feign.IOssApiClient;
import com.byh.feign.IhospitalApiClient;
import com.byh.manage.consultation.BusinessManage;
import com.byh.manage.consultation.RemoteManage;
import com.byh.manage.consultation.TRTCManage;
import com.byh.pojo.bo.consultation.BasePatDocExpertDto;
import com.byh.pojo.bo.consultation.ConsultationReportDto;
import com.byh.pojo.bo.consultation.DynamicMedicalRecordsDto;
import com.byh.pojo.bo.consultation.NormalImagesDto;
import com.byh.pojo.bo.consultation.OrderDetailDto;
import com.byh.pojo.bo.consultation.OrderDetailEditionTwoDto;
import com.byh.pojo.entity.consultation.ConsultationEntity;
import com.byh.pojo.entity.consultation.ConsultationExtendEntity;
import com.byh.pojo.entity.consultation.ConsultationReportEntity;
import com.byh.pojo.entity.consultation.ConsultationTranscodeVideoEntity;
import com.byh.pojo.entity.consultation.DoctorBillInfoEntity;
import com.byh.pojo.entity.consultation.RtcRoomEntity;
import com.byh.pojo.entity.patient.PatientCaseInfoEntity;
import com.byh.pojo.vo.consultation.DoctorBillVo;
import com.byh.pojo.vo.consultation.res.PatientInfoRespVO;
import com.byh.remotecall.PatientInfoRemote;
import com.byh.service.cosultation.ConsultationExtendService;
import com.byh.service.cosultation.ConsultationReportService;
import com.byh.service.cosultation.ConsultationService;
import com.byh.service.cosultation.ConsultationTranscodeVideoService;
import com.byh.service.cosultation.DoctorBillInfoService;
import com.byh.service.patient.PatientCaseInfoService;
import com.byh.util.CommonUtils;
import com.byh.util.DateTimeUtil;
import com.byh.util.StringUtil;
import com.byh.util.UuidUtils;
import com.doctoruser.api.pojo.dto.BaseDTO;
import com.doctoruser.api.pojo.vo.OrganBasicInfoRespVO;
import com.doctoruser.api.pojo.vo.OssFileVO;
import com.doctoruser.api.pojo.vo.basedata.doctor.DoctorEntityInfoVO;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.sysinfocloudclient.PatientDynamicMedicalClient;
import com.ebaiyihui.sysinfocloudcommon.vo.medical.PatientDynamicMedicalEntityVo;
import com.ebaiyihui.sysinfocloudcommon.vo.medical.PatientDynamicMedicalIdVo;
import com.ebaiyihui.sysinfocloudcommon.vo.medical.PatientGetMedicalTemplateReqVo;
import com.ebaiyihui.sysinfocloudcommon.vo.medical.PatientMedicalTemplateResVo;
import com.github.pagehelper.PageHelper;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ConsultationReportManager
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(ConsultationReportManager.class);
    private SimpleDateFormat formatTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    @Autowired
    private ConsultationService consultationService;
    @Autowired
    private ConsultationReportService consultationReportService;
    @Autowired
    private PatientCaseInfoService patientCaseInfoService;
    @Autowired
    private RemoteManage remoteManage;
    @Autowired
    private PatientInfoRemote patientInfoRemote;
    @Autowired
    private IOssApiClient iOssApiClient;
    @Autowired
    private TRTCManage trtcManage;
    @Autowired
    private BusinessManage businessManage;
    @Autowired
    private ConsultationExtendService consultationExtendService;
    @Autowired
    private ConsultationTranscodeVideoService consultationTranscodeVideoService;
    @Autowired
    private DoctorBillInfoService doctorBillInfoService;
    @Autowired
    private IhospitalApiClient ihospitalApiClient;
    @Autowired
    private PatientDynamicMedicalClient patientDynamicMedicalClient;

    public ResultInfo saveUpdateConsultationReport(String orderViewId, Integer orderType, String treatPlan, String signature, String photoReport) {
        ConsultationEntity consultationEntity = this.consultationService.queryConsultationEntityByViewId(orderViewId);
        if (consultationEntity == null) {
            return this.returnFailure("\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        ConsultationReportEntity consultationReport = this.consultationReportService.queryConsultationReportEntityByViewId(orderViewId);
        ConsultationReportEntity consultationReportEntity = new ConsultationReportEntity();
        if (consultationReport == null) {
            log.info("\u4f1a\u8bca\u62a5\u544a\u65b0\u5efa=========");
            consultationReportEntity.setViewId(UuidUtils.generateUUID());
            consultationReportEntity.setOrderViewId(orderViewId);
            consultationReportEntity.setOrderType(orderType);
            if (photoReport == null || photoReport.equals("")) {
                consultationReportEntity.setTreatPlan(treatPlan);
                consultationReportEntity.setSignature(signature);
                consultationReportEntity.setAttentions("");
                consultationReportEntity.setDiagnosis("");
                int i = this.consultationReportService.savaConsultationReportEntity1(consultationReportEntity);
                if (i < 0) {
                    log.info("\u4f1a\u8bca\u62a5\u544a\u65b0\u5efa\u5931\u8d25=========");
                    return this.returnFailure("\u4f1a\u8bca\u62a5\u544a\u65b0\u5efa\u5931\u8d25");
                }
                log.info("\u4f1a\u8bca\u62a5\u544a\u65b0\u5efa\u6210\u529f=========");
                consultationEntity.setReportStatus(consultationReportEntity.getStatus());
                this.consultationService.updateConsultationEntity(consultationEntity);
                return this.returnSucceed("\u4f1a\u8bca\u62a5\u544a\u65b0\u5efa\u6210\u529f");
            }
            consultationReportEntity.setPhotoReport(photoReport);
            consultationReportEntity.setAttentions("");
            consultationReportEntity.setDiagnosis("");
            consultationReportEntity.setTreatPlan("");
            int i = this.consultationReportService.savaConsultationReportEntity2(consultationReportEntity);
            if (i < 0) {
                log.info("\u4f1a\u8bca\u62a5\u544a\u65b0\u5efa\u5931\u8d25=========");
                return this.returnFailure("\u4f1a\u8bca\u62a5\u544a\u65b0\u5efa\u5931\u8d25");
            }
            consultationEntity.setReportStatus(consultationReportEntity.getStatus());
            this.consultationService.updateConsultationEntity(consultationEntity);
            log.info("\u4f1a\u8bca\u62a5\u544a\u65b0\u5efa\u6210\u529f=========");
            return this.returnSucceed("\u4f1a\u8bca\u62a5\u544a\u65b0\u5efa\u6210\u529f");
        }
        log.info("\u4f1a\u8bca\u62a5\u544a\u4fee\u6539=========");
        consultationReportEntity = consultationReport;
        consultationReportEntity.setTreatPlan(treatPlan);
        consultationReportEntity.setSignature(signature);
        consultationReportEntity.setPhotoReport(photoReport);
        int i = this.consultationReportService.updateConsultationReportEntity(consultationReportEntity);
        if (i > 0) {
            log.info("\u4f1a\u8bca\u62a5\u544a\u4fee\u6539\u6210\u529f=========");
            consultationEntity.setReportStatus(Integer.valueOf(1));
            this.consultationService.updateConsultationEntity(consultationEntity);
            return this.returnSucceed("\u4f1a\u8bca\u62a5\u544a\u4fee\u6539\u6210\u529f");
        }
        log.info("\u4f1a\u8bca\u62a5\u544a\u4fee\u6539\u5931\u8d25========");
        return this.returnFailure("\u4f1a\u8bca\u62a5\u544a\u4fee\u6539\u5931\u8d25");
    }

    public ResultInfo<ConsultationReportDto> queryConsultationReportByOrder(String orderViewId) {
        ConsultationReportEntity consultationReportEntity;
        ConsultationReportDto consultationReportDto = new ConsultationReportDto();
        ConsultationEntity consultationEntity = this.consultationService.queryConsultationEntityByViewId(orderViewId);
        ConsultationExtendEntity consultationExtendEntity = this.consultationExtendService.queryByConsultationId(consultationEntity.getId());
        try {
            this.videoLengthCompensation(consultationEntity, consultationExtendEntity);
        }
        catch (Exception e) {
            log.info("queryConsultationReportByOrder \u5f02\u5e38:{}", (Object)e.toString());
        }
        if (consultationEntity == null || consultationExtendEntity == null) {
            return this.returnFailure("\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        consultationReportDto.setOrderId(consultationEntity.getId());
        consultationReportDto.setOrderViewId(consultationEntity.getViewId());
        consultationReportDto.setGroupId(consultationEntity.getGroupId());
        consultationReportDto.setOrderBeginTime(consultationEntity.getBeginTime());
        consultationReportDto.setOrderFinishTime(consultationEntity.getFinishTime());
        consultationReportDto.setConsultationDate(consultationEntity.getConsultationDate());
        consultationReportDto.setConsultationTime(consultationEntity.getConsultationTime());
        consultationReportDto.setOrderType(consultationEntity.getType());
        consultationReportDto.setDate(consultationEntity.getBeginTime() + " \u81f3 " + consultationEntity.getFinishTime());
        consultationReportDto.setPatientId(consultationEntity.getPatientId());
        consultationReportDto.setPatientName(consultationEntity.getPatientName());
        consultationReportDto.setPatientSex(consultationExtendEntity.getPatientSex());
        consultationReportDto.setPatientAge(consultationExtendEntity.getPatientAge());
        consultationReportDto.setPatIdCard(consultationExtendEntity.getPatientIdCard());
        consultationReportDto.setDocId(consultationEntity.getDoctorId());
        consultationReportDto.setDocName(consultationEntity.getDoctorName());
        consultationReportDto.setDocDepName(consultationEntity.getDoctorDepName());
        consultationReportDto.setDocHosName(consultationEntity.getDoctorHosName());
        consultationReportDto.setExpertId(Long.valueOf(consultationEntity.getExpertId() == null ? 0L : consultationEntity.getExpertId()));
        consultationReportDto.setExpertName(consultationEntity.getExpertName() == null ? "" : consultationEntity.getExpertName());
        consultationReportDto.setExpertDepName(consultationEntity.getExpertDeptName() == null ? "" : consultationEntity.getExpertDeptName());
        consultationReportDto.setExpertHosName(consultationEntity.getExpertHosName() == null ? "" : consultationEntity.getExpertHosName());
        PatientInfoRespVO patientInfoRespVO = this.patientInfoRemote.getPatientInfoById(consultationEntity.getPatientId(), consultationEntity.getDoctorHospitalId());
        if (patientInfoRespVO != null) {
            consultationReportDto.setPatientTel(patientInfoRespVO.getContactMobile());
        }
        if ((consultationReportEntity = this.consultationReportService.queryConsultationReportEntityByViewId(orderViewId)) != null) {
            consultationReportDto.setIsWrite(Integer.valueOf(1));
            consultationReportDto.setTreatPlan(consultationReportEntity.getTreatPlan());
            consultationReportDto.setSignature(consultationReportEntity.getSignature());
            consultationReportDto.setPhotoReport(consultationReportEntity.getPhotoReport());
            consultationReportDto.setReportStatus(consultationReportEntity.getStatus());
        }
        return this.returnSucceed((Object)consultationReportDto, "\u6210\u529f");
    }

    public ResultInfo<List<ConsultationReportDto>> queryConsultationReportByPatient(Long patientId, Integer pageIndex, Integer pageSize) {
        PageHelper.startPage((int)pageIndex, (int)pageSize);
        List consultationEntityList = this.consultationService.queryConsultationEntityByPatientId(patientId);
        if (consultationEntityList == null || consultationEntityList.size() < 1) {
            log.info("\u8be5\u60a3\u8005\u6ca1\u6709\u4f1a\u8bca\u62a5\u544a===========");
            return this.returnSucceed("\u8be5\u60a3\u8005\u6ca1\u6709\u4f1a\u8bca\u62a5\u544a");
        }
        ArrayList<ConsultationReportDto> list = new ArrayList<ConsultationReportDto>();
        for (ConsultationEntity consultationEntity : consultationEntityList) {
            String orderViewId = consultationEntity.getViewId();
            ConsultationReportDto consultationReportDto = this.getConsultationReportDto(orderViewId);
            if (consultationReportDto == null) {
                log.info("\u8be5\u8ba2\u5355\u65e0\u4f1a\u8bca\u62a5\u544a=====" + orderViewId);
                continue;
            }
            consultationReportDto.setIsWrite(Integer.valueOf(1));
            list.add(consultationReportDto);
        }
        return this.returnSucceed(list, "\u6210\u529f");
    }

    public ResultInfo<List<ConsultationReportDto>> queryConsultationReportByDoctorId(Long doctorId, Integer type, Integer pageIndex, Integer pageSize, String search) {
        PageHelper.startPage((int)pageIndex, (int)pageSize);
        List consultationEntityList = this.consultationService.queryConsultationListByDocIdAndType(doctorId, type, search);
        if (consultationEntityList == null) {
            return this.returnSucceed("\u7a7a\u7a7a\u5982\u4e5f");
        }
        ArrayList<ConsultationReportDto> list = new ArrayList<ConsultationReportDto>();
        for (ConsultationEntity consultationEntity : consultationEntityList) {
            String orderViewId;
            BasePatDocExpertDto basePatDocExpertDto;
            ConsultationReportDto consultationReportDto = new ConsultationReportDto();
            consultationReportDto.setOrderId(consultationEntity.getId());
            consultationReportDto.setGroupId(consultationEntity.getGroupId());
            consultationReportDto.setOrderViewId(consultationEntity.getViewId());
            consultationReportDto.setOrderBeginTime(consultationEntity.getBeginTime());
            consultationReportDto.setOrderFinishTime(consultationEntity.getFinishTime());
            consultationReportDto.setConsultationDate(consultationEntity.getConsultationDate());
            consultationReportDto.setConsultationTime(consultationEntity.getConsultationTime());
            consultationReportDto.setOrderType(consultationEntity.getType());
            PatientInfoRespVO patientInfoRespVO = this.patientInfoRemote.getPatientInfoById(consultationEntity.getPatientId(), consultationEntity.getDoctorHospitalId());
            if (patientInfoRespVO != null) {
                consultationReportDto.setPatIdCard(patientInfoRespVO.getCredNo());
            }
            if ((basePatDocExpertDto = this.queryPatDocExpertDto(orderViewId = consultationEntity.getViewId())) == null) {
                log.info("\u83b7\u53d6\u57fa\u7840\u4fe1\u606f\u5931\u8d25=======");
            }
            BeanCopier copier = BeanCopier.create(BasePatDocExpertDto.class, ConsultationReportDto.class, (boolean)false);
            try {
                copier.copy((Object)basePatDocExpertDto, (Object)consultationReportDto, null);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            ConsultationReportEntity consultationReportEntity = this.consultationReportService.queryConsultationReportEntityByViewId(orderViewId);
            if (consultationReportEntity == null) {
                consultationReportDto.setIsWrite(Integer.valueOf(0));
            } else {
                consultationReportDto.setIsWrite(Integer.valueOf(1));
                consultationReportDto.setDate(consultationEntity.getBeginTime() + " \u81f3 " + consultationEntity.getFinishTime());
                consultationReportDto.setTreatPlan(consultationReportEntity.getTreatPlan());
                consultationReportDto.setSignature(consultationReportEntity.getSignature());
                consultationReportDto.setPhotoReport(consultationReportEntity.getPhotoReport());
                consultationReportDto.setReportCreateTime(consultationReportEntity.getCreateTime());
                consultationReportDto.setReportUpdateTime(consultationReportEntity.getUpdateTime());
                consultationReportDto.setReportStatus(consultationReportEntity.getStatus());
            }
            list.add(consultationReportDto);
        }
        return this.returnSucceed(list, "\u6210\u529f");
    }

    private ConsultationReportDto getConsultationReportDto(String orderViewId) {
        ConsultationReportEntity consultationReportEntity;
        ConsultationReportDto consultationReportDto = new ConsultationReportDto();
        ConsultationEntity consultationEntity = this.consultationService.queryConsultationEntityByViewId(orderViewId);
        ConsultationExtendEntity consultationExtendEntity = this.consultationExtendService.queryByConsultationId(consultationEntity.getId());
        if (consultationEntity == null || consultationExtendEntity == null) {
            return null;
        }
        consultationReportDto.setOrderId(consultationEntity.getId());
        consultationReportDto.setOrderViewId(consultationEntity.getViewId());
        consultationReportDto.setOrderBeginTime(consultationEntity.getBeginTime());
        consultationReportDto.setOrderFinishTime(consultationEntity.getFinishTime());
        consultationReportDto.setConsultationDate(consultationEntity.getConsultationDate());
        consultationReportDto.setConsultationTime(consultationEntity.getConsultationTime());
        consultationReportDto.setOrderType(consultationEntity.getType());
        consultationReportDto.setReportCreateTime(consultationEntity.getCreateTime());
        consultationReportDto.setReportUpdateTime(consultationEntity.getUpdateTime());
        consultationReportDto.setPatientId(consultationEntity.getPatientId());
        consultationReportDto.setPatientName(consultationEntity.getPatientName());
        consultationReportDto.setPatientSex(consultationExtendEntity.getPatientSex());
        consultationReportDto.setPatientAge(consultationExtendEntity.getPatientAge());
        consultationReportDto.setPatIdCard(consultationExtendEntity.getPatientIdCard());
        consultationReportDto.setDocId(consultationEntity.getDoctorId());
        consultationReportDto.setDocName(consultationEntity.getDoctorName());
        consultationReportDto.setDocDepName(consultationEntity.getDoctorDepName());
        consultationReportDto.setDocHosName(consultationEntity.getDoctorHosName());
        consultationReportDto.setExpertId(Long.valueOf(consultationEntity.getExpertId() == null ? 0L : consultationEntity.getExpertId()));
        consultationReportDto.setExpertName(consultationEntity.getExpertName() == null ? "" : consultationEntity.getExpertName());
        consultationReportDto.setExpertDepName(consultationEntity.getExpertDeptName() == null ? "" : consultationEntity.getExpertDeptName());
        consultationReportDto.setExpertHosName(consultationEntity.getExpertHosName() == null ? "" : consultationEntity.getExpertHosName());
        PatientInfoRespVO patientInfoRespVO = this.patientInfoRemote.getPatientInfoById(consultationEntity.getPatientId(), consultationEntity.getDoctorHospitalId());
        if (patientInfoRespVO != null) {
            consultationReportDto.setPatientTel(patientInfoRespVO.getContactMobile());
        }
        if ((consultationReportEntity = this.consultationReportService.queryConsultationReportEntityByViewId(orderViewId)) == null) {
            log.info("\u8be5\u8ba2\u5355\u7684\u4f1a\u8bca\u62a5\u544a\u4e0d\u5b58\u5728===\u8ba2\u5355id\u662f:" + consultationEntity.getId());
            return null;
        }
        consultationReportDto.setDate(consultationEntity.getBeginTime() + " \u81f3 " + consultationEntity.getFinishTime());
        consultationReportDto.setTreatPlan(consultationReportEntity.getTreatPlan());
        consultationReportDto.setSignature(consultationReportEntity.getSignature());
        consultationReportDto.setPhotoReport(consultationReportEntity.getPhotoReport());
        return consultationReportDto;
    }

    private BasePatDocExpertDto queryPatDocExpertDto(String orderViewId) {
        ConsultationEntity consultationEntity = this.consultationService.queryConsultationEntityByViewId(orderViewId);
        ConsultationExtendEntity consultationExtendEntity = this.consultationExtendService.queryByConsultationId(consultationEntity.getId());
        if (consultationEntity == null || consultationExtendEntity == null) {
            return null;
        }
        BasePatDocExpertDto basePatDocExpertDto = new BasePatDocExpertDto();
        basePatDocExpertDto.setPatientId(consultationEntity.getPatientId());
        basePatDocExpertDto.setPatientName(consultationEntity.getPatientName());
        basePatDocExpertDto.setPatientSex(consultationExtendEntity.getPatientSex());
        basePatDocExpertDto.setPatientAge(consultationExtendEntity.getPatientAge());
        basePatDocExpertDto.setDocId(consultationEntity.getDoctorId());
        basePatDocExpertDto.setDocName(consultationEntity.getDoctorName());
        basePatDocExpertDto.setDocDepName(consultationEntity.getDoctorDepName());
        basePatDocExpertDto.setDocHosName(consultationEntity.getDoctorHosName());
        basePatDocExpertDto.setExpertId(Long.valueOf(consultationEntity.getExpertId() == null ? 0L : consultationEntity.getExpertId()));
        basePatDocExpertDto.setExpertName(consultationEntity.getExpertName() == null ? "" : consultationEntity.getExpertName());
        basePatDocExpertDto.setExpertDepName(consultationEntity.getExpertDeptName() == null ? "" : consultationEntity.getExpertDeptName());
        basePatDocExpertDto.setExpertHosName(consultationEntity.getExpertHosName() == null ? "" : consultationEntity.getExpertHosName());
        PatientInfoRespVO patientInfoRespVO = this.patientInfoRemote.getPatientInfoById(consultationEntity.getPatientId(), consultationEntity.getDoctorHospitalId());
        if (patientInfoRespVO != null) {
            basePatDocExpertDto.setPatientTel(patientInfoRespVO.getContactMobile());
        }
        return basePatDocExpertDto;
    }

    public ResultInfo<OrderDetailDto> queryOrderDetail(String orderViewId) {
        PatientCaseInfoEntity patientCaseInfoEntity;
        DoctorEntityInfoVO expertEntityInfoVO;
        ConsultationReportEntity consultationReportEntity;
        String acceptTime;
        OrderDetailDto orderDetailDto = new OrderDetailDto();
        ConsultationEntity consultationEntity = this.consultationService.queryConsultationEntityByViewId(orderViewId);
        ConsultationExtendEntity consultationExtendEntity = this.consultationExtendService.queryByConsultationId(consultationEntity.getId());
        if (consultationEntity == null || consultationExtendEntity == null) {
            return this.returnFailure("\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        try {
            this.videoLengthCompensation(consultationEntity, consultationExtendEntity);
        }
        catch (Exception e) {
            log.info("queryOrderDetail \u5f02\u5e38:{}", (Object)e.toString());
        }
        orderDetailDto.setOrderId(consultationEntity.getId());
        orderDetailDto.setOrderCreateTime(consultationEntity.getCreateTime());
        orderDetailDto.setOrderUpdateTime(consultationEntity.getUpdateTime());
        orderDetailDto.setOrderBeginTime(consultationEntity.getBeginTime());
        orderDetailDto.setOrderFinishTime(consultationEntity.getFinishTime());
        orderDetailDto.setOrderViewId(consultationEntity.getViewId());
        orderDetailDto.setOrderStatus(consultationEntity.getStatus());
        orderDetailDto.setOrderType(consultationEntity.getType());
        orderDetailDto.setDcmPackUrl(consultationExtendEntity.getDcmPackUrl());
        orderDetailDto.setVideoUrl(consultationExtendEntity.getVideoUrl());
        orderDetailDto.setTencentRong(consultationEntity.getTencentRong());
        orderDetailDto.setOrderPayStats(consultationExtendEntity.getPayState());
        orderDetailDto.setPayTime(consultationEntity.getPayTime());
        orderDetailDto.setConsultationDate(consultationEntity.getConsultationDate());
        orderDetailDto.setConsultationTime(consultationEntity.getConsultationTime());
        orderDetailDto.setOrderApplicationChannels(consultationEntity.getApplicationChannels());
        orderDetailDto.setOrderAcceptTime(consultationEntity.getAcceptTime());
        orderDetailDto.setGroupId(consultationEntity.getGroupId());
        orderDetailDto.setOrderPayType(consultationExtendEntity.getPayType());
        orderDetailDto.setOrderPrice(consultationExtendEntity.getPrice());
        orderDetailDto.setPatientInformedConsentUrl(consultationEntity.getPatientInformedConsentUrl());
        orderDetailDto.setDcmFileUrl(consultationExtendEntity.getDcmFileUrl());
        orderDetailDto.setDcmPackUrl(consultationExtendEntity.getDcmPackUrl());
        ConsultationTranscodeVideoEntity videoEntity = this.consultationTranscodeVideoService.getByOrderViewIdAndOrderType(consultationEntity.getViewId(), consultationEntity.getType());
        if (videoEntity != null && StringUtil.isNotEmpty((String)videoEntity.getVideoUrl())) {
            orderDetailDto.setMp4VideoUrl(videoEntity.getVideoUrl());
        } else {
            orderDetailDto.setMp4VideoUrl(consultationExtendEntity.getVideoUrl());
        }
        if (consultationEntity.getType().intValue() == OrderTypeEnum.TYPE_VEDIO.getValue().intValue() && consultationEntity.getStatus() >= OrderStatusEnum.RUNNING.getValue() && consultationEntity.getStatus().intValue() != OrderStatusEnum.CANCEL.getValue().intValue()) {
            RtcRoomEntity roomEntity = this.trtcManage.getByOrderIdAndOrderType(consultationEntity.getId(), consultationEntity.getType());
            if (roomEntity == null) {
                this.trtcManage.saveRtcRoomId(consultationEntity.getId());
                RtcRoomEntity roomEntity1 = this.trtcManage.getByOrderIdAndOrderType(consultationEntity.getId(), consultationEntity.getType());
                orderDetailDto.setRoomId(roomEntity1.getId().toString());
            } else {
                orderDetailDto.setRoomId(roomEntity.getId().toString());
            }
        }
        log.info("consultationExtendEntity\u5bf9\u8c61\u4fe1\u606f:{}", (Object)consultationExtendEntity);
        orderDetailDto.setPatientId(consultationEntity.getPatientId());
        orderDetailDto.setPatientName(consultationEntity.getPatientName());
        orderDetailDto.setPatientSex(consultationExtendEntity.getPatientSex());
        orderDetailDto.setPatientAge(consultationExtendEntity.getPatientAge());
        orderDetailDto.setPatIdCard(consultationExtendEntity.getPatientIdCard());
        orderDetailDto.setPatientTel(consultationExtendEntity.getPatientPhone());
        orderDetailDto.setDocId(consultationEntity.getDoctorId());
        orderDetailDto.setDocName(consultationEntity.getDoctorName());
        orderDetailDto.setDocDepId(consultationEntity.getDoctorDepId());
        orderDetailDto.setDocDepName(consultationEntity.getDoctorDepName());
        orderDetailDto.setDocHospId(consultationEntity.getDoctorHospitalId());
        orderDetailDto.setDocHosName(consultationEntity.getDoctorHosName());
        BaseDTO docBaseDTO = new BaseDTO();
        docBaseDTO.setId(Integer.valueOf(consultationEntity.getDoctorHospitalId().intValue()));
        BaseResponse docBaseResponse = this.ihospitalApiClient.queryOrganInfoByIdOrOrganCode(docBaseDTO);
        if (docBaseResponse.getCode().equals("1")) {
            log.info("\u8bbe\u7f6e\u966a\u8bca\u533b\u751f\u533b\u9662\u5730\u5740");
            log.info("docBaseResponse\uff1a{}", (Object)docBaseResponse);
            if (docBaseResponse.getData() == null) {
                orderDetailDto.setDocOrganAddress("");
            } else {
                orderDetailDto.setDocOrganAddress(((OrganBasicInfoRespVO)docBaseResponse.getData()).getAddress());
            }
        }
        orderDetailDto.setExpertId(Long.valueOf(Objects.isNull(consultationEntity.getExpertId()) ? 0L : consultationEntity.getExpertId()));
        orderDetailDto.setExpertName(Objects.isNull(consultationEntity.getExpertName()) ? "" : consultationEntity.getExpertName());
        orderDetailDto.setExpertDepId(Long.valueOf(Objects.isNull(consultationEntity.getExpertDepId()) ? 0L : consultationEntity.getExpertDepId()));
        orderDetailDto.setExpertDepName(Objects.isNull(consultationEntity.getExpertDeptName()) ? "" : consultationEntity.getExpertDeptName());
        orderDetailDto.setExpertHospId(Long.valueOf(Objects.isNull(consultationEntity.getExpertHospitalId()) ? 0L : consultationEntity.getExpertHospitalId()));
        orderDetailDto.setExpertHosName(Objects.isNull(consultationEntity.getExpertHosName()) ? "" : consultationEntity.getExpertHosName());
        BaseDTO expertBaseDTO = new BaseDTO();
        expertBaseDTO.setId(Integer.valueOf(consultationEntity.getExpertHospitalId().intValue()));
        BaseResponse expertBaseResponse = this.ihospitalApiClient.queryOrganInfoByIdOrOrganCode(expertBaseDTO);
        if (expertBaseResponse.getCode().equals("1")) {
            if (expertBaseResponse.getData() == null) {
                orderDetailDto.setExpertOrganAddress("");
            } else {
                orderDetailDto.setExpertOrganAddress(((OrganBasicInfoRespVO)expertBaseResponse.getData()).getAddress());
            }
        }
        if ((acceptTime = consultationEntity.getAcceptTime()) != null && !acceptTime.equals("")) {
            Date acceptDate = DateTimeUtil.addHour((Date)DateTimeUtil.parseTime((String)acceptTime, (String)"yyyy-MM-dd HH:mm:ss"), (int)24);
            orderDetailDto.setOrderAcceptExpireTime(DateTimeUtil.formatTime((Date)acceptDate, (String)"yyyy-MM-dd HH:mm:ss"));
        }
        if ((consultationReportEntity = this.consultationReportService.queryConsultationReportEntityByViewId(consultationEntity.getViewId())) == null) {
            orderDetailDto.setIsReport(Integer.valueOf(0));
        } else {
            orderDetailDto.setIsReport(Integer.valueOf(1));
            orderDetailDto.setReportStatus(consultationReportEntity.getStatus());
            orderDetailDto.setPhotoReportUrl(consultationReportEntity.getPhotoReport());
            orderDetailDto.setDiagnosis(consultationReportEntity.getDiagnosis());
            orderDetailDto.setTreatPlan(consultationReportEntity.getTreatPlan());
            orderDetailDto.setAttentions(consultationReportEntity.getAttentions());
            orderDetailDto.setSignature(consultationReportEntity.getSignature());
        }
        orderDetailDto.setPatientTel(consultationExtendEntity.getPatientPhone());
        DoctorEntityInfoVO doctorEntityInfoVO = this.remoteManage.getDoctorDetailById(consultationEntity.getDoctorId());
        if (doctorEntityInfoVO != null) {
            orderDetailDto.setDocTel(consultationExtendEntity.getDoctorPhone());
            orderDetailDto.setDoctorHeadUrl("");
            orderDetailDto.setDocProfession("");
            orderDetailDto.setDocProfessionCode("");
            orderDetailDto.setDocTel(doctorEntityInfoVO.getRegisterMobile());
            orderDetailDto.setDoctorHeadUrl(doctorEntityInfoVO.getHeadPortrait());
            orderDetailDto.setDocProfession(doctorEntityInfoVO.getProfession());
            orderDetailDto.setDocProfessionCode(doctorEntityInfoVO.getProfessionCode());
        }
        if (StringUtil.isNotEmpty((String)consultationEntity.getClosedTime())) {
            orderDetailDto.setOrderClosedTime(consultationEntity.getClosedTime());
        }
        if (consultationEntity.getExpertId() != null && consultationEntity.getExpertId().intValue() != 0 && (expertEntityInfoVO = this.remoteManage.getDoctorDetailById(consultationEntity.getExpertId())) != null) {
            orderDetailDto.setExpertTel(consultationExtendEntity.getExpertPhone());
            orderDetailDto.setExpertHeadUrl("");
            orderDetailDto.setExpertProfession("");
            orderDetailDto.setExpertProfessionCode("");
            orderDetailDto.setExpertTel(expertEntityInfoVO.getRegisterMobile());
            orderDetailDto.setExpertHeadUrl(expertEntityInfoVO.getHeadPortrait());
            orderDetailDto.setExpertProfession(expertEntityInfoVO.getProfession());
            orderDetailDto.setExpertProfessionCode(expertEntityInfoVO.getProfessionCode());
        }
        if (StringUtil.isNotEmpty((String)consultationEntity.getDynamicId()) && consultationEntity.getDynamicId().length() < 10) {
            if (consultationExtendEntity.getInitiatorType() == 1) {
                orderDetailDto.setOrderSource(Integer.valueOf(1));
                patientCaseInfoEntity = this.patientCaseInfoService.selectPatientCaseInfoById(consultationEntity.getCaseId());
                if (patientCaseInfoEntity != null) {
                    orderDetailDto.setPatCaseMainSuit(patientCaseInfoEntity.getMainSuit());
                    orderDetailDto.setPastHistory(patientCaseInfoEntity.getPastHistory());
                    orderDetailDto.setPresentHistory(patientCaseInfoEntity.getPresentHistory());
                    orderDetailDto.setPatPrimaryDiagno(patientCaseInfoEntity.getPrimaryDiagno());
                    orderDetailDto.setPatCaseFamilyHistory(patientCaseInfoEntity.getFamilyHistory());
                    orderDetailDto.setPatCaseMedicationHistory(patientCaseInfoEntity.getMedicationHistory());
                    orderDetailDto.setPatCaseConsultAim(patientCaseInfoEntity.getConsultAim());
                    String normalImages = patientCaseInfoEntity.getNormalImages();
                    ArrayList<NormalImagesDto> caseAttachmentList = new ArrayList<NormalImagesDto>();
                    if (StringUtil.isNotEmpty((String)normalImages)) {
                        if (normalImages.contains(",")) {
                            List<String> stringList = Arrays.asList(normalImages.split(","));
                            for (String s : stringList) {
                                BaseResponse ossFileVOBaseResponse = this.iOssApiClient.getById(Long.valueOf(Long.parseLong(s)));
                                if (!ossFileVOBaseResponse.getCode().equals("1")) {
                                    return this.returnFailure(ossFileVOBaseResponse.getMsg());
                                }
                                OssFileVO ossFileEntity = (OssFileVO)ossFileVOBaseResponse.getData();
                                NormalImagesDto normalImagesDto = new NormalImagesDto();
                                normalImagesDto.setId(ossFileEntity.getId());
                                normalImagesDto.setUrl(ossFileEntity.getUrl());
                                caseAttachmentList.add(normalImagesDto);
                                orderDetailDto.setCaseAttachmentList(caseAttachmentList);
                            }
                        } else {
                            OssFileVO ossFileEntity = (OssFileVO)this.iOssApiClient.getById(Long.valueOf(Long.parseLong(normalImages))).getData();
                            NormalImagesDto normalImagesDto = new NormalImagesDto();
                            normalImagesDto.setId(ossFileEntity.getId());
                            normalImagesDto.setUrl(ossFileEntity.getUrl());
                            caseAttachmentList.add(normalImagesDto);
                            orderDetailDto.setCaseAttachmentList(caseAttachmentList);
                        }
                    } else {
                        orderDetailDto.setCaseAttachmentList(caseAttachmentList);
                    }
                }
            }
        } else if (StringUtil.isNotEmpty((String)consultationEntity.getDynamicId()) && consultationEntity.getDynamicId().length() > 10) {
            BaseResponse responseList = null;
            List TemplateList = new ArrayList();
            String medicalDetail = "";
            ArrayList<DynamicMedicalRecordsDto> list = new ArrayList<DynamicMedicalRecordsDto>();
            PatientGetMedicalTemplateReqVo patientGetMedicalTemplateReqVo = new PatientGetMedicalTemplateReqVo();
            patientGetMedicalTemplateReqVo.setHospitalId(consultationEntity.getExpertHospitalId().toString());
            patientGetMedicalTemplateReqVo.setServType(Integer.valueOf(4));
            responseList = this.patientDynamicMedicalClient.getMedicalTemplate(patientGetMedicalTemplateReqVo);
            if (responseList.getCode().equals("1")) {
                TemplateList = (List)responseList.getData();
            }
            PatientDynamicMedicalIdVo patientDynamicMedicalIdVo = new PatientDynamicMedicalIdVo();
            patientDynamicMedicalIdVo.setId(consultationEntity.getDynamicId());
            BaseResponse response = this.patientDynamicMedicalClient.getMedicalInfoById(patientDynamicMedicalIdVo);
            if (response.getCode().equals("1") && response.getData() != null) {
                medicalDetail = ((PatientDynamicMedicalEntityVo)response.getData()).getMedicalDetail();
            }
            orderDetailDto.setOrderSource(Integer.valueOf(2));
            JSONObject json = JSONObject.parseObject((String)medicalDetail);
            if (Objects.nonNull(json)) {
                Set sets = json.keySet();
                for (String str : sets) {
                    DynamicMedicalRecordsDto dynamicMedicalRecordsDto = new DynamicMedicalRecordsDto();
                    for (PatientMedicalTemplateResVo patientMedicalTemplateResVo : TemplateList) {
                        if (!patientMedicalTemplateResVo.getKeywords().equals(str)) continue;
                        log.info("key:{}", (Object)str);
                        dynamicMedicalRecordsDto.setKey(str);
                        dynamicMedicalRecordsDto.setKeyType(patientMedicalTemplateResVo.getTitleType());
                        dynamicMedicalRecordsDto.setKeyName(patientMedicalTemplateResVo.getTitleContent());
                        if (json.get((Object)str) != null) {
                            dynamicMedicalRecordsDto.setContent(String.valueOf(json.get((Object)str)));
                        } else {
                            dynamicMedicalRecordsDto.setContent("");
                        }
                        dynamicMedicalRecordsDto.setInputType(patientMedicalTemplateResVo.getInputType());
                        dynamicMedicalRecordsDto.setSort(patientMedicalTemplateResVo.getSort());
                        list.add(dynamicMedicalRecordsDto);
                    }
                }
            }
            orderDetailDto.setDynamicMedicalRecordsList(list.stream().sorted(Comparator.comparing(DynamicMedicalRecordsDto::getInputType)).sorted(Comparator.comparing(DynamicMedicalRecordsDto::getSort)).collect(Collectors.toList()));
        } else {
            orderDetailDto.setOrderSource(Integer.valueOf(1));
            patientCaseInfoEntity = this.patientCaseInfoService.selectPatientCaseInfoById(consultationEntity.getCaseId());
            if (patientCaseInfoEntity != null) {
                orderDetailDto.setPatCaseMainSuit(patientCaseInfoEntity.getMainSuit());
                orderDetailDto.setPastHistory(patientCaseInfoEntity.getPastHistory());
                orderDetailDto.setPresentHistory(patientCaseInfoEntity.getPresentHistory());
                orderDetailDto.setPatPrimaryDiagno(patientCaseInfoEntity.getPrimaryDiagno());
                orderDetailDto.setPatCaseFamilyHistory(patientCaseInfoEntity.getFamilyHistory());
                orderDetailDto.setPatCaseMedicationHistory(patientCaseInfoEntity.getMedicationHistory());
                orderDetailDto.setPatCaseConsultAim(patientCaseInfoEntity.getConsultAim());
                String normalImages = patientCaseInfoEntity.getNormalImages();
                ArrayList<NormalImagesDto> caseAttachmentList = new ArrayList<NormalImagesDto>();
                if (StringUtil.isNotEmpty((String)normalImages)) {
                    if (normalImages.contains(",")) {
                        List<String> stringList = Arrays.asList(normalImages.split(","));
                        for (String s : stringList) {
                            BaseResponse ossFileVOBaseResponse = this.iOssApiClient.getById(Long.valueOf(Long.parseLong(s)));
                            if (!ossFileVOBaseResponse.getCode().equals("1")) {
                                return this.returnFailure("oss\u670d\u52a1\u9519\u8bef:" + ossFileVOBaseResponse.getMsg());
                            }
                            OssFileVO ossFileEntity = (OssFileVO)ossFileVOBaseResponse.getData();
                            NormalImagesDto normalImagesDto = new NormalImagesDto();
                            normalImagesDto.setId(ossFileEntity.getId());
                            normalImagesDto.setUrl(ossFileEntity.getUrl());
                            caseAttachmentList.add(normalImagesDto);
                            orderDetailDto.setCaseAttachmentList(caseAttachmentList);
                        }
                    } else {
                        OssFileVO ossFileEntity = (OssFileVO)this.iOssApiClient.getById(Long.valueOf(Long.parseLong(normalImages))).getData();
                        NormalImagesDto normalImagesDto = new NormalImagesDto();
                        normalImagesDto.setId(ossFileEntity.getId());
                        normalImagesDto.setUrl(ossFileEntity.getUrl());
                        caseAttachmentList.add(normalImagesDto);
                        orderDetailDto.setCaseAttachmentList(caseAttachmentList);
                    }
                } else {
                    orderDetailDto.setCaseAttachmentList(caseAttachmentList);
                }
            }
        }
        log.info("\u8ba2\u5355\u8be6\u7ec6\u4fe1\u606f-\u8131\u654f\u524d:={}", (Object)orderDetailDto);
        orderDetailDto.setPatIdCard(CommonUtils.idEncrypt((String)orderDetailDto.getPatIdCard()));
        orderDetailDto.setPatientTel(CommonUtils.mobileEncrypt((String)orderDetailDto.getPatientTel()));
        log.info("\u8ba2\u5355\u8be6\u7ec6\u4fe1\u606f-\u8131\u654f\u540e:={}", (Object)orderDetailDto);
        return this.returnSucceed((Object)orderDetailDto, "\u8ba2\u5355\u8be6\u60c5\u6210\u529f");
    }

    public ResultInfo<OrderDetailEditionTwoDto> queryOrderDetailEditionTwoDto(String orderViewId) {
        boolean dynamicPatient;
        PatientInfoRespVO patientInfoRespVO;
        OrderDetailEditionTwoDto orderDetailEditionTwoDto = new OrderDetailEditionTwoDto();
        ConsultationEntity consultationEntity = this.consultationService.queryConsultationEntityByViewId(orderViewId);
        if (Objects.isNull(consultationEntity)) {
            return this.returnFailure("\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        orderDetailEditionTwoDto.setConsultationEntity(consultationEntity);
        ConsultationExtendEntity consultationExtendEntity = this.consultationExtendService.queryByConsultationId(consultationEntity.getId());
        try {
            this.videoLengthCompensation(consultationEntity, consultationExtendEntity);
        }
        catch (Exception e) {
            log.info("queryOrderDetailEditionTwoDto \u5f02\u5e38:{}", (Object)e.toString());
        }
        ConsultationReportEntity consultationReportEntity = this.consultationReportService.queryConsultationReportEntityByViewId(consultationEntity.getViewId());
        if (consultationReportEntity != null) {
            orderDetailEditionTwoDto.setConsultationReportEntity(consultationReportEntity);
        }
        if (consultationEntity.getPatientId() != null && !consultationEntity.getPatientId().equals(0L) && (patientInfoRespVO = this.patientInfoRemote.getPatientInfoById(consultationEntity.getPatientId(), consultationEntity.getDoctorHospitalId())) != null) {
            patientInfoRespVO.setContactMobile(CommonUtils.mobileEncrypt((String)patientInfoRespVO.getContactMobile()));
            patientInfoRespVO.setCredNo(CommonUtils.idEncrypt((String)patientInfoRespVO.getCredNo()));
            orderDetailEditionTwoDto.setPatientInfoDTO(patientInfoRespVO);
        }
        boolean bl = dynamicPatient = StringUtil.isNotEmpty((String)consultationEntity.getDynamicId()) && consultationEntity.getDynamicId().length() > 10;
        if (dynamicPatient) {
            this.processDynamicPatientInfo(orderDetailEditionTwoDto, consultationEntity, consultationExtendEntity);
        } else {
            this.processCaseAttachment(orderDetailEditionTwoDto, consultationEntity);
        }
        DoctorEntityInfoVO doctorEntityInfoVO = this.remoteManage.getDoctorDetailById(consultationEntity.getDoctorId());
        orderDetailEditionTwoDto.setDoctorDetailInfoEntity(doctorEntityInfoVO);
        if (doctorEntityInfoVO != null) {
            doctorEntityInfoVO.setContactMobile(CommonUtils.mobileEncrypt((String)doctorEntityInfoVO.getContactMobile()));
        }
        if (consultationEntity.getExpertId() != null && consultationEntity.getExpertId().intValue() != 0) {
            DoctorEntityInfoVO expertEntityInfoVO = this.remoteManage.getDoctorDetailById(consultationEntity.getExpertId());
            orderDetailEditionTwoDto.setExpertHosName(consultationEntity.getExpertHosName());
            if (StringUtil.isNotEmpty((String)expertEntityInfoVO.getContactMobile())) {
                expertEntityInfoVO.setContactMobile(CommonUtils.mobileEncrypt((String)expertEntityInfoVO.getContactMobile()));
            }
            expertEntityInfoVO.setContactMobile("");
            orderDetailEditionTwoDto.setExpertRegisterInfoEntity(expertEntityInfoVO);
        }
        return this.returnSucceed((Object)orderDetailEditionTwoDto, "\u6210\u529f");
    }

    private void processCaseAttachment(OrderDetailEditionTwoDto orderDetailEditionTwoDto, ConsultationEntity consultationEntity) {
        boolean originPatient;
        ArrayList<NormalImagesDto> caseAttachmentList = new ArrayList<NormalImagesDto>();
        boolean bl = originPatient = consultationEntity.getCaseId() != null && consultationEntity.getCaseId().intValue() != 0;
        if (!originPatient) {
            return;
        }
        PatientCaseInfoEntity patientCaseInfoDTO = this.patientCaseInfoService.selectPatientCaseInfoById(consultationEntity.getCaseId());
        if (Objects.isNull(patientCaseInfoDTO)) {
            return;
        }
        orderDetailEditionTwoDto.setPatientCaseInfoDTO(patientCaseInfoDTO);
        String normalImages = patientCaseInfoDTO.getNormalImages();
        if (StringUtil.isEmpty((String)normalImages)) {
            return;
        }
        String[] split = normalImages.split(",");
        for (int i = 0; i < split.length; ++i) {
            OssFileVO ossFileEntity;
            BaseResponse ossFileVOBaseResponse = this.iOssApiClient.getById(Long.valueOf(split[i]));
            if (!ossFileVOBaseResponse.isSuccess() || (ossFileEntity = (OssFileVO)ossFileVOBaseResponse.getData()) == null) continue;
            NormalImagesDto normalImagesDto = new NormalImagesDto();
            normalImagesDto.setId(ossFileEntity.getId());
            normalImagesDto.setUrl(ossFileEntity.getUrl());
            caseAttachmentList.add(normalImagesDto);
        }
        orderDetailEditionTwoDto.setCaseAttachmentList(caseAttachmentList);
    }

    private void processDynamicPatientInfo(OrderDetailEditionTwoDto orderDetailEditionTwoDto, ConsultationEntity consultationEntity, ConsultationExtendEntity consultationExtendEntity) {
        ArrayList<DynamicMedicalRecordsDto> medicalRecordsList = new ArrayList<DynamicMedicalRecordsDto>();
        PatientGetMedicalTemplateReqVo patientGetMedicalTemplateReqVo = new PatientGetMedicalTemplateReqVo();
        patientGetMedicalTemplateReqVo.setHospitalId(consultationEntity.getExpertHospitalId().toString());
        patientGetMedicalTemplateReqVo.setServType(Integer.valueOf(4));
        BaseResponse responseList = this.patientDynamicMedicalClient.getMedicalTemplate(patientGetMedicalTemplateReqVo);
        List templateList = new ArrayList();
        if (responseList.isSuccess()) {
            templateList = (List)responseList.getData();
        }
        PatientDynamicMedicalIdVo patientDynamicMedicalIdVo = new PatientDynamicMedicalIdVo();
        patientDynamicMedicalIdVo.setId(consultationEntity.getDynamicId());
        BaseResponse response = this.patientDynamicMedicalClient.getMedicalInfoById(patientDynamicMedicalIdVo);
        if (response.isSuccess() && Objects.nonNull(response.getData()) && StringUtil.isNotEmpty((String)((PatientDynamicMedicalEntityVo)response.getData()).getMedicalDetail())) {
            String medicalDetail = ((PatientDynamicMedicalEntityVo)response.getData()).getMedicalDetail();
            JSONObject json = JSONObject.parseObject((String)medicalDetail);
            Set sets = json.keySet();
            for (String str : sets) {
                DynamicMedicalRecordsDto dynamicMedicalRecordsDto = new DynamicMedicalRecordsDto();
                for (PatientMedicalTemplateResVo patientMedicalTemplateResVo : templateList) {
                    if (!patientMedicalTemplateResVo.getKeywords().equals(str)) continue;
                    dynamicMedicalRecordsDto.setKey(str);
                    dynamicMedicalRecordsDto.setKeyType(patientMedicalTemplateResVo.getTitleType());
                    dynamicMedicalRecordsDto.setKeyName(patientMedicalTemplateResVo.getTitleContent());
                    if (json.get((Object)str) != null) {
                        dynamicMedicalRecordsDto.setContent(json.get((Object)str).toString());
                    }
                    dynamicMedicalRecordsDto.setInputType(patientMedicalTemplateResVo.getInputType());
                    dynamicMedicalRecordsDto.setSort(patientMedicalTemplateResVo.getSort());
                    medicalRecordsList.add(dynamicMedicalRecordsDto);
                }
            }
        }
        orderDetailEditionTwoDto.setOrderSource(Integer.valueOf(2));
        List dynamicMedicalRecordsList = medicalRecordsList.stream().sorted(Comparator.comparing(DynamicMedicalRecordsDto::getInputType)).sorted(Comparator.comparing(DynamicMedicalRecordsDto::getSort)).collect(Collectors.toList());
        orderDetailEditionTwoDto.setDynamicMedicalRecordsList(dynamicMedicalRecordsList);
        if (consultationExtendEntity.getInitiatorType() == 1) {
            this.processCaseAttachment(orderDetailEditionTwoDto, consultationEntity);
        }
    }

    public ResultInfo<OrderDetailDto> queryOrderDetailByOrderId(Long orderId) throws ParseException {
        BaseResponse responseList;
        ConsultationReportEntity consultationReportEntity;
        OrderDetailDto orderDetailDto = new OrderDetailDto();
        ConsultationEntity consultationEntity = this.consultationService.queryConsultationEntityById(orderId);
        ConsultationExtendEntity consultationExtendEntity = this.consultationExtendService.queryByConsultationId(consultationEntity.getId());
        if (consultationEntity == null || consultationExtendEntity == null) {
            return this.returnFailure("\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        try {
            this.videoLengthCompensation(consultationEntity, consultationExtendEntity);
        }
        catch (Exception e) {
            log.info("queryOrderDetailByOrderId \u5f02\u5e38:{}", (Object)e.toString());
        }
        orderDetailDto.setOrderId(consultationEntity.getId());
        orderDetailDto.setOrderCreateTime(consultationEntity.getCreateTime());
        orderDetailDto.setOrderUpdateTime(consultationEntity.getUpdateTime());
        orderDetailDto.setOrderBeginTime(consultationEntity.getBeginTime());
        orderDetailDto.setOrderFinishTime(consultationEntity.getFinishTime());
        orderDetailDto.setOrderViewId(consultationEntity.getViewId());
        orderDetailDto.setOrderStatus(consultationEntity.getStatus());
        orderDetailDto.setOrderType(consultationEntity.getType());
        orderDetailDto.setDcmPackUrl(consultationExtendEntity.getDcmPackUrl());
        orderDetailDto.setVideoUrl(consultationExtendEntity.getVideoUrl());
        orderDetailDto.setPayTime(consultationEntity.getPayTime());
        orderDetailDto.setConsultationDate(consultationEntity.getConsultationDate());
        orderDetailDto.setConsultationTime(consultationEntity.getConsultationTime());
        orderDetailDto.setOrderApplicationChannels(consultationEntity.getApplicationChannels());
        orderDetailDto.setOrderAcceptTime(consultationEntity.getAcceptTime());
        orderDetailDto.setGroupId(consultationEntity.getGroupId());
        orderDetailDto.setOrderPayType(consultationExtendEntity.getPayType());
        orderDetailDto.setOrderPrice(consultationExtendEntity.getPrice());
        orderDetailDto.setPatientInformedConsentUrl(consultationEntity.getPatientInformedConsentUrl());
        orderDetailDto.setDcmFileUrl(consultationExtendEntity.getDcmFileUrl());
        orderDetailDto.setDcmPackUrl(consultationExtendEntity.getDcmPackUrl());
        orderDetailDto.setTencentRong(consultationEntity.getTencentRong());
        orderDetailDto.setPatientId(consultationEntity.getPatientId());
        orderDetailDto.setPatientName(consultationEntity.getPatientName());
        orderDetailDto.setPatientSex(consultationExtendEntity.getPatientSex());
        orderDetailDto.setPatientAge(consultationExtendEntity.getPatientAge());
        orderDetailDto.setPatIdCard(CommonUtils.idEncrypt((String)consultationExtendEntity.getPatientIdCard()));
        orderDetailDto.setDocId(consultationEntity.getDoctorId());
        orderDetailDto.setDocName(consultationEntity.getDoctorName());
        orderDetailDto.setDocDepId(consultationEntity.getDoctorDepId());
        orderDetailDto.setDocDepName(consultationEntity.getDoctorDepName());
        orderDetailDto.setDocHospId(consultationEntity.getDoctorHospitalId());
        orderDetailDto.setDocHosName(consultationEntity.getDoctorHosName());
        orderDetailDto.setExpertTel(CommonUtils.mobileEncrypt((String)consultationExtendEntity.getExpertPhone()));
        orderDetailDto.setExpertId(Long.valueOf(consultationEntity.getExpertId() == null ? 0L : consultationEntity.getExpertId()));
        orderDetailDto.setExpertName(consultationEntity.getExpertName() == null ? "" : consultationEntity.getExpertName());
        orderDetailDto.setExpertDepId(Long.valueOf(consultationEntity.getExpertDepId() == null ? 0L : consultationEntity.getExpertDepId()));
        orderDetailDto.setExpertDepName(consultationEntity.getExpertDeptName() == null ? "" : consultationEntity.getExpertDeptName());
        orderDetailDto.setExpertHospId(Long.valueOf(consultationEntity.getExpertHospitalId() == null ? 0L : consultationEntity.getExpertHospitalId()));
        orderDetailDto.setExpertHosName(consultationEntity.getExpertHosName() == null ? "" : consultationEntity.getExpertHosName());
        String acceptTime = consultationEntity.getAcceptTime();
        if (StringUtil.isNotBlank((String)acceptTime)) {
            Date parse = this.formatTime.parse(acceptTime);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(parse);
            calendar.set(11, calendar.get(11) + 24);
            orderDetailDto.setOrderAcceptExpireTime(this.formatTime.format(calendar.getTime()));
        }
        if ((consultationReportEntity = this.consultationReportService.queryConsultationReportEntityByViewId(consultationEntity.getViewId())) == null) {
            orderDetailDto.setIsReport(Integer.valueOf(0));
        } else {
            orderDetailDto.setIsReport(Integer.valueOf(1));
            orderDetailDto.setReportStatus(consultationReportEntity.getStatus());
            orderDetailDto.setPhotoReportUrl(consultationReportEntity.getPhotoReport());
            orderDetailDto.setDiagnosis(consultationReportEntity.getDiagnosis());
            orderDetailDto.setTreatPlan(consultationReportEntity.getTreatPlan());
            orderDetailDto.setAttentions(consultationReportEntity.getAttentions());
            orderDetailDto.setSignature(consultationReportEntity.getSignature());
        }
        orderDetailDto.setPatientTel(CommonUtils.mobileEncrypt((String)consultationExtendEntity.getPatientPhone()));
        orderDetailDto.setDocTel("");
        orderDetailDto.setDoctorHeadUrl("");
        if (consultationEntity.getExpertId() != null && consultationEntity.getExpertId().intValue() != 0) {
            orderDetailDto.setExpertHeadUrl("");
        }
        if (StringUtil.isNotEmpty((String)consultationEntity.getDynamicId()) && consultationEntity.getDynamicId().length() < 10) {
            responseList = null;
            List TemplateList = new ArrayList();
            String medicalDetail = "";
            ArrayList<DynamicMedicalRecordsDto> list = new ArrayList<DynamicMedicalRecordsDto>();
            PatientGetMedicalTemplateReqVo patientGetMedicalTemplateReqVo = new PatientGetMedicalTemplateReqVo();
            patientGetMedicalTemplateReqVo.setHospitalId(consultationEntity.getExpertHospitalId().toString());
            patientGetMedicalTemplateReqVo.setServType(Integer.valueOf(4));
            responseList = this.patientDynamicMedicalClient.getMedicalTemplate(patientGetMedicalTemplateReqVo);
            if (responseList.getCode().equals("1")) {
                TemplateList = (List)responseList.getData();
            }
            PatientDynamicMedicalIdVo patientDynamicMedicalIdVo = new PatientDynamicMedicalIdVo();
            patientDynamicMedicalIdVo.setId(consultationEntity.getDynamicId());
            BaseResponse response = this.patientDynamicMedicalClient.getMedicalInfoById(patientDynamicMedicalIdVo);
            if (response.getCode().equals("1") && response.getData() != null) {
                medicalDetail = ((PatientDynamicMedicalEntityVo)response.getData()).getMedicalDetail();
            }
            orderDetailDto.setOrderSource(Integer.valueOf(2));
            JSONObject json = JSONObject.parseObject((String)medicalDetail);
            Set sets = json.keySet();
            for (String str : sets) {
                DynamicMedicalRecordsDto dynamicMedicalRecordsDto = new DynamicMedicalRecordsDto();
                for (PatientMedicalTemplateResVo patientMedicalTemplateResVo : TemplateList) {
                    if (!patientMedicalTemplateResVo.getKeywords().equals(str)) continue;
                    dynamicMedicalRecordsDto.setKey(str);
                    dynamicMedicalRecordsDto.setKeyType(patientMedicalTemplateResVo.getTitleType());
                    dynamicMedicalRecordsDto.setKeyName(patientMedicalTemplateResVo.getTitleContent());
                    dynamicMedicalRecordsDto.setContent(json.get((Object)str).toString());
                    dynamicMedicalRecordsDto.setInputType(patientMedicalTemplateResVo.getInputType());
                    dynamicMedicalRecordsDto.setSort(patientMedicalTemplateResVo.getSort());
                    list.add(dynamicMedicalRecordsDto);
                }
            }
            orderDetailDto.setDynamicMedicalRecordsList(list.stream().sorted(Comparator.comparing(DynamicMedicalRecordsDto::getInputType)).sorted(Comparator.comparing(DynamicMedicalRecordsDto::getSort)).collect(Collectors.toList()));
        } else if (StringUtil.isNotEmpty((String)consultationEntity.getDynamicId()) && consultationEntity.getDynamicId().length() > 10) {
            responseList = null;
            List TemplateList = new ArrayList();
            String medicalDetail = "";
            ArrayList<DynamicMedicalRecordsDto> list = new ArrayList<DynamicMedicalRecordsDto>();
            PatientGetMedicalTemplateReqVo patientGetMedicalTemplateReqVo = new PatientGetMedicalTemplateReqVo();
            patientGetMedicalTemplateReqVo.setHospitalId(consultationEntity.getExpertHospitalId().toString());
            patientGetMedicalTemplateReqVo.setServType(Integer.valueOf(4));
            responseList = this.patientDynamicMedicalClient.getMedicalTemplate(patientGetMedicalTemplateReqVo);
            if (responseList.getCode().equals("1")) {
                TemplateList = (List)responseList.getData();
            }
            PatientDynamicMedicalIdVo patientDynamicMedicalIdVo = new PatientDynamicMedicalIdVo();
            patientDynamicMedicalIdVo.setId(consultationEntity.getDynamicId());
            BaseResponse response = this.patientDynamicMedicalClient.getMedicalInfoById(patientDynamicMedicalIdVo);
            if (response.getCode().equals("1") && response.getData() != null) {
                medicalDetail = ((PatientDynamicMedicalEntityVo)response.getData()).getMedicalDetail();
            }
            orderDetailDto.setOrderSource(Integer.valueOf(2));
            JSONObject json = JSONObject.parseObject((String)medicalDetail);
            Set sets = json.keySet();
            for (String str : sets) {
                DynamicMedicalRecordsDto dynamicMedicalRecordsDto = new DynamicMedicalRecordsDto();
                for (PatientMedicalTemplateResVo patientMedicalTemplateResVo : TemplateList) {
                    if (!patientMedicalTemplateResVo.getKeywords().equals(str)) continue;
                    dynamicMedicalRecordsDto.setKey(str);
                    dynamicMedicalRecordsDto.setKeyType(patientMedicalTemplateResVo.getTitleType());
                    dynamicMedicalRecordsDto.setKeyName(patientMedicalTemplateResVo.getTitleContent());
                    dynamicMedicalRecordsDto.setContent(json.get((Object)str).toString());
                    dynamicMedicalRecordsDto.setInputType(patientMedicalTemplateResVo.getInputType());
                    dynamicMedicalRecordsDto.setSort(patientMedicalTemplateResVo.getSort());
                    list.add(dynamicMedicalRecordsDto);
                }
            }
            orderDetailDto.setDynamicMedicalRecordsList(list.stream().sorted(Comparator.comparing(DynamicMedicalRecordsDto::getInputType)).sorted(Comparator.comparing(DynamicMedicalRecordsDto::getSort)).collect(Collectors.toList()));
        } else {
            PatientCaseInfoEntity patientCaseInfoEntity = this.patientCaseInfoService.selectPatientCaseInfoById(consultationEntity.getCaseId());
            if (patientCaseInfoEntity != null) {
                orderDetailDto.setPatCaseMainSuit(patientCaseInfoEntity.getMainSuit());
                orderDetailDto.setPastHistory(patientCaseInfoEntity.getPastHistory());
                orderDetailDto.setPresentHistory(patientCaseInfoEntity.getPresentHistory());
                orderDetailDto.setPatPrimaryDiagno(patientCaseInfoEntity.getPrimaryDiagno());
                orderDetailDto.setPatCaseFamilyHistory(patientCaseInfoEntity.getFamilyHistory());
                orderDetailDto.setPatCaseMedicationHistory(patientCaseInfoEntity.getMedicationHistory());
                orderDetailDto.setPatCaseConsultAim(patientCaseInfoEntity.getConsultAim());
                String normalImages = patientCaseInfoEntity.getNormalImages();
                ArrayList<NormalImagesDto> caseAttachmentList = new ArrayList<NormalImagesDto>();
                if (StringUtil.isBlank((String)normalImages)) {
                    String[] split = normalImages.split(",");
                    for (int i = 0; i < split.length; ++i) {
                        BaseResponse ossFileEntityResultInfoReturn = this.iOssApiClient.getById(Long.valueOf(split[i]));
                        if (!ossFileEntityResultInfoReturn.getCode().equals("1")) {
                            return this.returnFailure(ossFileEntityResultInfoReturn.getMsg());
                        }
                        OssFileVO ossFileEntity = (OssFileVO)ossFileEntityResultInfoReturn.getData();
                        if (ossFileEntity == null) continue;
                        NormalImagesDto normalImagesDto = new NormalImagesDto();
                        normalImagesDto.setId(ossFileEntity.getId());
                        normalImagesDto.setUrl(ossFileEntity.getUrl());
                        caseAttachmentList.add(normalImagesDto);
                    }
                    orderDetailDto.setCaseAttachmentList(caseAttachmentList);
                } else {
                    orderDetailDto.setCaseAttachmentList(caseAttachmentList);
                }
            }
        }
        return this.returnSucceed((Object)orderDetailDto, "\u8ba2\u5355\u8be6\u60c5\u6210\u529f");
    }

    @Transactional(rollbackFor={Exception.class})
    public ResultInfo consultationReportDraft(String orderViewId, Integer orderType, String treatPlan, String signature, String photoReport) {
        ConsultationEntity consultationEntity = this.consultationService.queryConsultationEntityByViewId(orderViewId);
        if (consultationEntity == null) {
            return this.returnFailure("\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        ConsultationReportEntity consultationReport = this.consultationReportService.queryConsultationReportEntityByViewId(orderViewId);
        if (consultationReport != null && consultationReport.getStatus().intValue() == ReportConstant.STATUS_REPORT_ONLINE.intValue()) {
            log.error("\u8be5\u8ba2\u5355\u7684\u4f1a\u8bca\u62a5\u544a\u5b58\u5728===========");
            return this.returnFailure("\u8be5\u8ba2\u5355\u7684\u4f1a\u8bca\u62a5\u544a\u5b58\u5728");
        }
        if (consultationReport != null && consultationReport.getStatus().intValue() == ReportConstant.STATUS_REPORT_DRAFT.intValue()) {
            consultationReport.setTreatPlan(treatPlan);
            consultationReport.setSignature(signature);
            consultationReport.setPhotoReport(photoReport);
            consultationReport.setStatus(ReportConstant.STATUS_REPORT_DRAFT);
            int i = this.consultationReportService.updateConsultationReportDraft(consultationReport);
            if (i > 0) {
                log.info("\u4f1a\u8bca\u62a5\u544a\u8349\u7a3f\u4fee\u6539\u6210\u529f==============");
                consultationEntity.setReportStatus(consultationReport.getStatus());
                this.consultationService.updateConsultationEntity(consultationEntity);
                return this.returnSucceed("\u4f1a\u8bca\u62a5\u544a\u8349\u7a3f\u4fee\u6539\u6210\u529f");
            }
            log.error("\u4f1a\u8bca\u62a5\u544a\u8349\u7a3f\u4fee\u6539\u5931\u8d25==============");
            return this.returnFailure("\u4f1a\u8bca\u62a5\u544a\u8349\u7a3f\u4fee\u6539\u5931\u8d25");
        }
        ConsultationReportEntity consultationReportEntity = new ConsultationReportEntity();
        consultationReportEntity.setViewId(UuidUtils.generateUUID());
        consultationReportEntity.setOrderViewId(orderViewId);
        consultationReportEntity.setOrderType(orderType);
        consultationReportEntity.setTreatPlan(treatPlan);
        consultationReportEntity.setSignature(signature);
        consultationReportEntity.setPhotoReport(photoReport);
        consultationReportEntity.setStatus(ReportConstant.STATUS_REPORT_DRAFT);
        int i = this.consultationReportService.saveConsultationReportDraft(consultationReportEntity);
        if (i > 0) {
            log.info("\u4f1a\u8bca\u62a5\u544a\u8349\u7a3f\u6dfb\u52a0\u6210\u529f==============");
            consultationEntity.setReportStatus(consultationReportEntity.getStatus());
            this.consultationService.updateConsultationEntity(consultationEntity);
            return this.returnSucceed("\u4f1a\u8bca\u62a5\u544a\u8349\u7a3f\u6dfb\u52a0\u6210\u529f");
        }
        log.error("\u4f1a\u8bca\u62a5\u544a\u8349\u7a3f\u6dfb\u52a0\u5931\u8d25==============");
        return this.returnFailure("\u4f1a\u8bca\u62a5\u544a\u8349\u7a3f\u6dfb\u52a0\u5931\u8d25");
    }

    public ResultInfo consultationReportInspect(String orderViewId, Integer status, String reason) {
        ConsultationReportEntity consultationReport = this.consultationReportService.queryConsultationReportEntityByViewId(orderViewId);
        if (consultationReport == null) {
            return this.returnFailure("\u8be5\u8ba2\u5355\u7684\u4f1a\u8bca\u62a5\u544a\u4e0d\u5b58\u5728");
        }
        int i = this.consultationReportService.updateConsultationReportInspect(orderViewId, status, reason);
        if (i > 0) {
            log.info("\u4f1a\u8bca\u62a5\u544a\u5ba1\u6838\u6210\u529f===========");
            ConsultationEntity consultationEntity = this.consultationService.queryConsultationEntityByViewId(orderViewId);
            consultationEntity.setReportStatus(status);
            this.consultationService.updateConsultationEntity(consultationEntity);
            return this.returnSucceed("\u4f1a\u8bca\u62a5\u544a\u5ba1\u6838\u6210\u529f");
        }
        log.error("\u4f1a\u8bca\u62a5\u544a\u5ba1\u6838\u5931\u8d25===========");
        return this.returnFailure("\u4f1a\u8bca\u62a5\u544a\u5ba1\u6838\u5931\u8d25");
    }

    public ResultInfo upLoadReportMore(ConsultationEntity consultationEntity, ConsultationExtendEntity consultationExtendEntity, String photoReport) {
        if (consultationEntity == null || consultationExtendEntity == null) {
            return this.returnFailure("\u6b64\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        ConsultationReportEntity consultationReport = this.consultationReportService.queryConsultationReportEntityByViewId(consultationEntity.getViewId());
        ConsultationReportEntity consultationReportEntity = new ConsultationReportEntity();
        Integer i = 0;
        if (consultationReport == null) {
            log.info("============\u65e0\u4f1a\u8bca\u62a5\u544a===========");
            consultationReportEntity.setViewId(UuidUtils.generateUUID());
            consultationReportEntity.setOrderViewId(consultationEntity.getViewId());
            consultationReportEntity.setOrderType(consultationEntity.getType());
            consultationReportEntity.setStatus(ReportConstant.STATUS_REPORT_ONLINE);
            consultationReportEntity.setPhotoReport(photoReport);
            i = this.consultationReportService.savaConsultationReportEntity2(consultationReportEntity);
        } else {
            log.info("============\u6709\u4f1a\u8bca\u62a5\u544a,status:{}", (Object)consultationReport.getStatus());
            consultationReportEntity = consultationReport;
            consultationReportEntity.setDiagnosis("");
            consultationReportEntity.setTreatPlan("");
            consultationReportEntity.setAttentions("");
            consultationReportEntity.setSignature("");
            consultationReportEntity.setReason("");
            consultationReportEntity.setStatus(ReportConstant.STATUS_REPORT_ONLINE);
            consultationReportEntity.setPhotoReport(photoReport);
            i = this.consultationReportService.update(consultationReportEntity);
        }
        if (i == 0) {
            return this.returnFailure("\u4e0a\u4f20\u5931\u8d25");
        }
        consultationEntity.setReportStatus(consultationReportEntity.getStatus());
        this.consultationService.updateConsultationEntity(consultationEntity);
        return this.returnSucceed("\u4e0a\u4f20\u6210\u529f");
    }

    public void compensateVideo(ConsultationEntity consultationEntity, ConsultationExtendEntity consultationExtendEntity) {
        if (consultationEntity.getType().equals(OrderTypeEnum.TYPE_VEDIO.getValue()) && StringUtil.isEmpty((String)consultationExtendEntity.getVideoUrl())) {
            List expertVideoList;
            Map videoMap = this.businessManage.getVideoDetailL(consultationEntity);
            log.info("=====\u4ece\u8865\u507f\u89c6\u9891\u673a\u5236\u4e2d\u83b7\u53d6\u5f55\u5236\u89c6\u9891\uff0c\u8ba2\u5355id\u662f:{}====\u83b7\u53d6\u5230\u7684\u89c6\u9891map\u662f:{}", (Object)consultationEntity.getId(), (Object)videoMap);
            if (!videoMap.isEmpty() && StringUtil.isNotEmpty((String)((String)videoMap.get("expertVideoDetail")))) {
                consultationExtendEntity.setVideoUrl((String)videoMap.get("expertVideoDetail"));
            } else if (!videoMap.isEmpty() && StringUtil.isNotEmpty((String)((String)videoMap.get("doctorVideoDetail")))) {
                consultationExtendEntity.setVideoUrl((String)videoMap.get("doctorVideoDetail"));
            } else {
                consultationExtendEntity.setVideoUrl("");
            }
            Long doctorDuration = 0L;
            Long expertDuration = 0L;
            Map videoFilesMap = this.trtcManage.getDoctorVideoFileds(consultationEntity);
            List doctorVideoList = (List)videoFilesMap.get("doctorVideoFileId");
            if (CollectionUtils.isNotEmpty((Collection)doctorVideoList)) {
                doctorDuration = this.trtcManage.getTotalVideoDuration(doctorVideoList);
            }
            if (CollectionUtils.isNotEmpty((Collection)(expertVideoList = (List)videoFilesMap.get("expertVideoFileId")))) {
                expertDuration = this.trtcManage.getTotalVideoDuration(expertVideoList);
            }
            if (doctorDuration != null && expertDuration != null && doctorDuration < expertDuration) {
                consultationExtendEntity.setVideoTime(String.valueOf(doctorDuration));
            } else {
                consultationExtendEntity.setVideoTime(String.valueOf(expertDuration));
            }
        }
    }

    public void recorded(ConsultationEntity consultationEntity, ConsultationExtendEntity consultationExtendEntity) {
        log.info("====\u5f00\u59cb\u5165\u8d26=====>\u8ba2\u5355\u7684view_id\u662f:{}", (Object)consultationEntity.getViewId());
        Integer accompanyType = new Integer(0);
        Integer receiveType = new Integer(0);
        String serviceCodeName = DoctorServiceEnum.getByValue((Integer)consultationEntity.getServiceCode()).getDisplay();
        if (StringUtil.isNotEmpty((String)serviceCodeName) && serviceCodeName.contains("\u533b\u9662")) {
            accompanyType = consultationEntity.getType().equals(ConsultationConstant.TYPE_ORDER_VIDEO) ? BillBusinessTypeEnum.HOS_UNION_VIDEO_COMP.getValue() : BillBusinessTypeEnum.HOS_UNION_TUWEN_COMP.getValue();
            receiveType = consultationEntity.getType().equals(ConsultationConstant.TYPE_ORDER_VIDEO) ? BillBusinessTypeEnum.HOS_UNION_VIDEO_RECV.getValue() : BillBusinessTypeEnum.HOS_UNION_TUWEN_RECV.getValue();
        } else {
            accompanyType = consultationEntity.getType().equals(ConsultationConstant.TYPE_ORDER_VIDEO) ? BillBusinessTypeEnum.PER_UNION_VIDEO_COMP.getValue() : BillBusinessTypeEnum.PER_UNION_TUWEN_COMP.getValue();
            receiveType = consultationEntity.getType().equals(ConsultationConstant.TYPE_ORDER_VIDEO) ? BillBusinessTypeEnum.PER_UNION_VIDEO_RECV.getValue() : BillBusinessTypeEnum.PER_UNION_TUWEN_RECV.getValue();
        }
        DoctorBillVo doctorBillVo = new DoctorBillVo();
        doctorBillVo.setBillStatus(Integer.valueOf(-1));
        doctorBillVo.setBusinessId(consultationEntity.getViewId());
        doctorBillVo.setBusinessType(accompanyType.intValue());
        doctorBillVo.setDoctorId(consultationEntity.getDoctorId());
        doctorBillVo.setOriginalMoney(consultationExtendEntity.getAccompanyFee());
        doctorBillVo.setSubsidyMoney(new BigDecimal(0));
        doctorBillVo.setSponsor(consultationExtendEntity.getInitiatorType());
        doctorBillVo.setSource(BillBusinessTypeEnum.getByValue((Integer)accompanyType).getDisplay());
        doctorBillVo.setType(Integer.valueOf(1));
        log.info("===\u7ed9\u533b\u751f\u5165\u8d26\u7684\u4fe1\u606f\u662f:{}", (Object)doctorBillVo.toString());
        DoctorBillInfoEntity doctorBillInfoEntityResultInfo = this.doctorBillInfoService.addOne(doctorBillVo);
        DoctorBillVo expertBillVo = new DoctorBillVo();
        expertBillVo.setBillStatus(Integer.valueOf(-1));
        expertBillVo.setBusinessId(consultationEntity.getViewId());
        expertBillVo.setBusinessType(receiveType.intValue());
        expertBillVo.setDoctorId(consultationEntity.getExpertId());
        expertBillVo.setOriginalMoney(consultationExtendEntity.getAmissionFee());
        expertBillVo.setSubsidyMoney(new BigDecimal(0));
        expertBillVo.setSponsor(consultationExtendEntity.getInitiatorType());
        expertBillVo.setSource(BillBusinessTypeEnum.getByValue((Integer)receiveType).getDisplay());
        expertBillVo.setType(Integer.valueOf(1));
        log.info("====\u7ed9\u4e13\u5bb6\u5165\u8d26\u7684\u4fe1\u606f\u662f:{}", (Object)expertBillVo.toString());
        DoctorBillInfoEntity expertBillInfoEntityResultInfo = this.doctorBillInfoService.addOne(expertBillVo);
        if (doctorBillInfoEntityResultInfo == null || expertBillInfoEntityResultInfo == null) {
            throw new RuntimeException("\u5165\u533b\u751f\u8d26\u5355\u670d\u52a1\u9519\u8bef");
        }
    }

    @Async
    public void videoLengthCompensation(ConsultationEntity consultationEntity, ConsultationExtendEntity extendEntity) {
        if (consultationEntity.getType().equals(OrderTypeEnum.TYPE_VEDIO.getValue()) && consultationEntity.getStatus().equals(OrderStatusEnum.FINISH.getValue()) && StringUtil.isNotBlank((String)extendEntity.getVideoUrl()) && StringUtil.isEmpty((String)extendEntity.getVideoTime()) && extendEntity.getVideoTime().equals("0")) {
            List expertVideoList;
            log.info("==========\u8fdb\u5165\u8be6\u60c5\u89c6\u9891\u65f6\u957f\u8865\u507f\u673a\u5236==========");
            Long doctorDuration = 0L;
            Long expertDuration = 0L;
            Map videoFilesMap = this.trtcManage.getDoctorVideoFileds(consultationEntity);
            List doctorVideoList = (List)videoFilesMap.get("doctorVideoFileId");
            if (CollectionUtils.isNotEmpty((Collection)doctorVideoList)) {
                doctorDuration = this.trtcManage.getTotalVideoDuration(doctorVideoList);
                log.info("\u966a\u8bca\u533b\u751f\u65f6\u957fdoctorDuration:{}", (Object)doctorDuration);
            }
            if (CollectionUtils.isNotEmpty((Collection)(expertVideoList = (List)videoFilesMap.get("expertVideoFileId")))) {
                expertDuration = this.trtcManage.getTotalVideoDuration(expertVideoList);
                log.info("\u4e13\u5bb6\u65f6\u957fexpertDuration:{}", (Object)expertDuration);
            }
            if (doctorDuration != null && expertDuration != null && doctorDuration < expertDuration) {
                extendEntity.setVideoTime(String.valueOf(doctorDuration));
            } else {
                extendEntity.setVideoTime(String.valueOf(expertDuration));
            }
            this.consultationExtendService.update(extendEntity);
        }
        log.info("==========\u8be6\u60c5\u89c6\u9891\u65f6\u957f\u8865\u507f\u673a\u5236\u7ed3\u675f==========");
    }
}

