/*
 * Decompiled with CFR 0.152.
 */
package com.byh.manage.consultation;

import com.alibaba.fastjson.JSON;
import com.byh.config.RemoteCallAddressConfig;
import com.byh.enums.OrderStatusEnum;
import com.byh.enums.PayChannelEnum;
import com.byh.enums.PayMethodEnum;
import com.byh.enums.PayStateEnum;
import com.byh.enums.PayStatusEnum;
import com.byh.enums.ReceiptTypeEnum;
import com.byh.enums.ReturnCodeEnum;
import com.byh.feign.IhospitalApiClient;
import com.byh.manage.consultation.AggregationPayManage;
import com.byh.pojo.bo.pay.CustomerRequest;
import com.byh.pojo.bo.pay.GoodsRequest;
import com.byh.pojo.bo.pay.TradeCreateReqDto;
import com.byh.pojo.bo.pay.UnifiedOrder;
import com.byh.pojo.dto.pay.BusinessBillsParamVo;
import com.byh.pojo.dto.pay.CreateOrderDto;
import com.byh.pojo.dto.pay.PayOrderDtoReq;
import com.byh.pojo.dto.pay.RefundCallbackVo;
import com.byh.pojo.dto.pay.RefundHttpVo;
import com.byh.pojo.dto.pay.RefundVo;
import com.byh.pojo.dto.pay.RequestOfflineOederQueryVO;
import com.byh.pojo.entity.consultation.ConsultationEntity;
import com.byh.pojo.entity.consultation.ConsultationExtendEntity;
import com.byh.pojo.entity.consultation.ConsultationMerchantConfigEntity;
import com.byh.pojo.entity.consultation.ConsultationPayInfoEntity;
import com.byh.pojo.entity.consultation.ServiceMerchantConfigEntity;
import com.byh.pojo.entity.consultation.ServicePayBillEntity;
import com.byh.pojo.vo.consultation.AggregationPayVo;
import com.byh.pojo.vo.consultation.AggregationPayWxVo;
import com.byh.pojo.vo.consultation.DiscountVo;
import com.byh.pojo.vo.consultation.req.ReceiptVO;
import com.byh.pojo.vo.consultation.res.QrCodeResVO;
import com.byh.service.cosultation.CommonService;
import com.byh.service.cosultation.ConsultationExtendService;
import com.byh.service.cosultation.ConsultationMerchantConfigService;
import com.byh.service.cosultation.ConsultationPayInfoService;
import com.byh.service.cosultation.ConsultationService;
import com.byh.service.cosultation.ServiceMerchantConfigService;
import com.byh.service.cosultation.ServicePayBillService;
import com.byh.util.DateTimeUtil;
import com.byh.util.HttpUtils;
import com.byh.util.MapUtil;
import com.byh.util.SignUtil;
import com.byh.util.StringUtil;
import com.doctoruser.api.pojo.dto.BaseDTO;
import com.ebaiyihui.framework.response.BaseResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.http.Consts;
import org.apache.http.entity.ContentType;
import org.json.JSONObject;
import org.json.XML;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class OrderPayManage {
    private static final Logger log = LoggerFactory.getLogger(OrderPayManage.class);
    @Autowired
    private ConsultationService consultationService;
    @Autowired
    private IhospitalApiClient ihospitalApiClient;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private ConsultationPayInfoService consultationPayInfoService;
    @Autowired
    private RemoteCallAddressConfig remoteCallAddressConfig;
    @Autowired
    private ConsultationMerchantConfigService consultationMerchantConfigService;
    @Autowired
    private ConsultationExtendService consultationExtendService;
    @Autowired
    private CommonService commonService;
    @Autowired
    private ServiceMerchantConfigService serviceMerchantConfigService;
    @Autowired
    private ServicePayBillService servicePayBillService;
    @Autowired
    private AggregationPayManage aggregationPayManage;

    public String createOrderTrade(Long orderId, String merchantSeq, String bizsysSeq) {
        com.alibaba.fastjson.JSONObject responseJson;
        ConsultationEntity order = this.consultationService.queryConsultationEntityById(orderId);
        ConsultationExtendEntity consultationExtendEntity = this.consultationExtendService.queryByConsultationId(orderId);
        String tradeNo = "";
        String code = this.getAppCode(orderId);
        String url = this.remoteCallAddressConfig.getPayCoreAddress() + "trade/create";
        TradeCreateReqDto tradeCreateReqDto = new TradeCreateReqDto();
        tradeCreateReqDto.setMerchantSeq(merchantSeq);
        CustomerRequest customerRequest = new CustomerRequest();
        customerRequest.setBizCustomerSeq(order.getExpertId().toString());
        customerRequest.setName(order.getExpertName());
        customerRequest.setMobile("");
        tradeCreateReqDto.setCustomerRequest(customerRequest);
        tradeCreateReqDto.setBizCustomerSeq(order.getPatientId().toString());
        tradeCreateReqDto.setBizSysSeq(bizsysSeq);
        tradeCreateReqDto.setBizDealSeq(order.getViewId());
        tradeCreateReqDto.setActuallyPaid(consultationExtendEntity.getPrice());
        ArrayList<GoodsRequest> goodsRequestList = new ArrayList<GoodsRequest>();
        GoodsRequest goodsRequest = new GoodsRequest();
        goodsRequest.setBizGoodsSeq(order.getPatientName() + "\u7684\u4f1a\u8bca\u8ba2\u5355");
        goodsRequest.setBizGoodsSeq(order.getPatientId().toString());
        goodsRequest.setName("\u8fdc\u7a0b\u4f1a\u8bca\u8ba2\u5355");
        goodsRequest.setQuantity(Integer.valueOf(1));
        goodsRequest.setGoodsPrice(consultationExtendEntity.getPrice());
        goodsRequest.setUnit("\u4f8b");
        goodsRequestList.add(goodsRequest);
        tradeCreateReqDto.setGoodsRequestList(goodsRequestList);
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.add("Authorization", "byhYCHZ01");
        HttpEntity tradeCreateReqDtoHttpEntity = new HttpEntity((Object)tradeCreateReqDto, (MultiValueMap)httpHeaders);
        String jsonObject = com.alibaba.fastjson.JSONObject.toJSONString((Object)tradeCreateReqDtoHttpEntity);
        log.info("=====\u521b\u5efa\u4ea4\u6613url:" + url + "======\u53d1\u9001\u7684json\u4e32\u662f:" + jsonObject);
        ResponseEntity stringResponseEntity = this.restTemplate.exchange(url, HttpMethod.POST, tradeCreateReqDtoHttpEntity, String.class, new Object[0]);
        if (stringResponseEntity.getStatusCodeValue() == HttpStatus.OK.value() && StringUtil.isNotEmpty((String)((String)stringResponseEntity.getBody()))) {
            log.info("\u8c03\u7528\u8fd4\u56de\u7684\u4fe1\u606f\u662f:" + stringResponseEntity.toString());
            String bodyStr = (String)stringResponseEntity.getBody();
            responseJson = com.alibaba.fastjson.JSONObject.parseObject((String)bodyStr);
            log.info("=====\u521b\u5efa\u4ea4\u6613\u8fd4\u56de\u7684\u4fe1\u606f\u662f:" + responseJson);
            if (!(responseJson.getInteger("returnCode").equals(200) && responseJson.getString("status").equalsIgnoreCase("Success") && StringUtil.isNotEmpty((String)responseJson.getString("data")))) {
                throw new RuntimeException("\u53d6\u4ea4\u6613\u53f7\u65f6\u9519\u8bef\uff0cmsg:" + stringResponseEntity.toString());
            }
        } else {
            throw new RuntimeException("\u521b\u5efa\u4ea4\u6613\u65f6\u51fa\u9519\uff0cmsg:" + stringResponseEntity.toString());
        }
        tradeNo = responseJson.getString("data");
        return tradeNo;
    }

    public String payQRcode(String tradeNo, Long orderId) {
        return this.getPayInfo(tradeNo, orderId, "");
    }

    public String byhPayQrCode(Long orderId) {
        ConsultationEntity consultationEntity = this.consultationService.queryConsultationEntityById(orderId);
        ConsultationExtendEntity extendEntity = this.consultationExtendService.queryByConsultationId(orderId);
        PayOrderDtoReq payOrderDtoReq = new PayOrderDtoReq();
        payOrderDtoReq.setOrderId(orderId);
        payOrderDtoReq.setPayChannel(PayChannelEnum.QR_CODE.getValue());
        payOrderDtoReq.setPayMethod(PayMethodEnum.WECHAT_PAY.getValue());
        BaseResponse jsonObjectBaseResponse = this.createTrade(payOrderDtoReq, consultationEntity, extendEntity);
        if (ReturnCodeEnum.SUCCEED.getValue().equalsIgnoreCase(jsonObjectBaseResponse.getCode())) {
            return ((com.alibaba.fastjson.JSONObject)jsonObjectBaseResponse.getData()).getString("codeUrl");
        }
        throw new RuntimeException("\u521b\u5efa\u652f\u4ed8\u4e8c\u7ef4\u7801\u51fa\u9519,\u9519\u8bef\u4fe1\u606f:" + jsonObjectBaseResponse.getMsg());
    }

    public String byhPayQrCodeAggregation(Long orderId) {
        ConsultationEntity consultationEntity = this.consultationService.queryConsultationEntityById(orderId);
        ConsultationExtendEntity extendEntity = this.consultationExtendService.queryByConsultationId(orderId);
        PayOrderDtoReq payOrderDtoReq = new PayOrderDtoReq();
        payOrderDtoReq.setOrderId(orderId);
        payOrderDtoReq.setPayChannel(PayChannelEnum.QR_CODE.getValue());
        payOrderDtoReq.setPayMethod(PayMethodEnum.WECHAT_PAY.getValue());
        BaseResponse jsonObjectBaseResponse = this.createTradeAggregation(payOrderDtoReq, consultationEntity, extendEntity);
        if (ReturnCodeEnum.SUCCEED.getValue().equalsIgnoreCase(jsonObjectBaseResponse.getCode())) {
            return ((com.alibaba.fastjson.JSONObject)jsonObjectBaseResponse.getData()).getString("codeUrl");
        }
        throw new RuntimeException("\u521b\u5efa\u652f\u4ed8\u4e8c\u7ef4\u7801\u51fa\u9519,\u9519\u8bef\u4fe1\u606f:" + jsonObjectBaseResponse.getMsg());
    }

    public String getAppCode(Long orderId) {
        ConsultationEntity order = this.consultationService.queryConsultationEntityById(orderId);
        String code = "";
        if (order != null) {
            BaseDTO baseDTO = new BaseDTO();
            baseDTO.setId(Integer.valueOf(order.getDoctorHospitalId().intValue()));
            code = (String)this.ihospitalApiClient.queryAppCodeByHospitalId(baseDTO).getData();
            log.info("\u83b7\u53d6\u8282\u70b9code:{}", (Object)code);
        }
        return code;
    }

    public String getPayInfo(String tradeNo, Long orderId, String openId) {
        String qrcode = "";
        UnifiedOrder unifiedOrder = new UnifiedOrder();
        unifiedOrder.setDealSeq(tradeNo);
        if (StringUtil.isNotEmpty((String)openId)) {
            unifiedOrder.setDealType("JSAPI");
            unifiedOrder.setOpenId(openId);
        } else {
            unifiedOrder.setDealType("NATIVE");
        }
        String appCode = this.getAppCode(orderId);
        ConsultationMerchantConfigEntity consultationMerchantConfigEntity = this.consultationMerchantConfigService.getByAppCode(appCode.toUpperCase());
        log.info("\u6839\u636eappCode:{},\u53d6\u5230\u7684\u5546\u6237\u53f7\u662f:{},\u53d6\u5230\u7684\u4e1a\u52a1\u7cfb\u7edf\u7f16\u53f7\u662f:{}", new Object[]{appCode, consultationMerchantConfigEntity.getMerchantSeq(), consultationMerchantConfigEntity.getBizSysSeq()});
        unifiedOrder.setMerchantSeq(consultationMerchantConfigEntity.getMerchantSeq());
        unifiedOrder.setBizSysSeq(consultationMerchantConfigEntity.getBizSysSeq());
        String url = this.remoteCallAddressConfig.getPayGateWayAddress() + "weixin/unifiedOrder?bizSysSeq=" + unifiedOrder.getBizSysSeq() + "&dealSeq=" + unifiedOrder.getDealSeq() + "&dealType=" + unifiedOrder.getDealType() + "&merchantSeq=" + unifiedOrder.getMerchantSeq() + "";
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.add("Authorization", "byhYCHZ01");
        Map map = MapUtil.beanToMap((Object)unifiedOrder);
        HttpEntity unifiedOrderHttpEntity = new HttpEntity((Object)map, (MultiValueMap)httpHeaders);
        String reqStr = com.alibaba.fastjson.JSONObject.toJSONString((Object)unifiedOrderHttpEntity);
        log.info("====\u53bb\u62ff\u4e8c\u7ef4\u7801\u7684\u65f6\u5019\u7684url:" + url + "=====\u8bf7\u6c42\u53c2\u6570\u662f:" + reqStr);
        ResponseEntity stringResponseXml = this.restTemplate.exchange(url, HttpMethod.POST, unifiedOrderHttpEntity, String.class, new Object[0]);
        JSONObject jsonObjectResponse = XML.toJSONObject((String)((String)stringResponseXml.getBody()));
        JSONObject jsonObject = jsonObjectResponse.getJSONObject("ResultTemplate");
        if (jsonObject == null || jsonObject.getInt("returnCode") != 200 || !jsonObject.getString("status").equalsIgnoreCase("Success") || jsonObject.getJSONObject("data") == null) {
            throw new RuntimeException("\u8c03\u7528\u83b7\u53d6\u4e8c\u7ef4\u7801\u51fa\u9519,msg:" + stringResponseXml.toString());
        }
        log.info("======\u83b7\u53d6\u4e8c\u7ef4\u7801\u8fd4\u56de\u7684\u4fe1\u606f\u662f:" + jsonObject.getJSONObject("data").toString());
        qrcode = jsonObject.getJSONObject("data").getString("codeUrl");
        return qrcode;
    }

    public void closeTrade(Long orderId, String tradeNo) {
        String code = this.getAppCode(orderId);
        ConsultationEntity order = this.consultationService.queryConsultationEntityById(orderId);
        String url = this.remoteCallAddressConfig.getPayCoreAddress() + "trade/close";
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.add("Authorization", "byhYCHZ01");
        List payInfoEntities = this.consultationPayInfoService.getPayInfoListByOrderIdAndType(Long.valueOf(Long.parseLong(order.getViewId())), order.getType());
        if (CollectionUtils.isNotEmpty((Collection)payInfoEntities)) {
            for (ConsultationPayInfoEntity payInfoEntity : payInfoEntities) {
                if (payInfoEntity.getTradeNo().equals(tradeNo)) continue;
                com.alibaba.fastjson.JSONObject jsonObject = new com.alibaba.fastjson.JSONObject();
                jsonObject.put("dealSeq", (Object)payInfoEntity.getTradeNo());
                HttpEntity stringHttpEntity = new HttpEntity((Object)jsonObject, (MultiValueMap)httpHeaders);
                ResponseEntity stringResponseEntity = this.restTemplate.exchange(url, HttpMethod.POST, stringHttpEntity, String.class, new Object[0]);
                if (stringResponseEntity.getStatusCodeValue() != HttpStatus.OK.value() || !StringUtil.isNotEmpty((String)((String)stringResponseEntity.getBody()))) continue;
                String bodyStr = (String)stringResponseEntity.getBody();
                com.alibaba.fastjson.JSONObject responseJson = com.alibaba.fastjson.JSONObject.parseObject((String)bodyStr);
                log.info("=====\u5173\u95ed\u4ea4\u6613\u65f6\u8fd4\u56de\u7684\u4fe1\u606f:" + responseJson);
                if (!responseJson.getInteger("returnCode").equals(200)) continue;
                this.consultationPayInfoService.updateStatusByTradeNo(Integer.valueOf(-1), payInfoEntity.getTradeNo());
            }
        }
    }

    public BaseResponse<com.alibaba.fastjson.JSONObject> createTrade(PayOrderDtoReq payOrderDtoReq, ConsultationEntity consultationEntity, ConsultationExtendEntity consultationExtendEntity) {
        String appCode = this.getAppCode(payOrderDtoReq.getOrderId());
        ConsultationMerchantConfigEntity consultationMerchantConfigEntity = this.consultationMerchantConfigService.getByAppCode(appCode.toUpperCase());
        log.info("\u6839\u636eappCode:{},\u53d6\u5230\u7684\u4f70\u533b\u6c47\u652f\u4ed8\u7cfb\u7edf\u7684\u5546\u6237\u53f7\u662f:{},\u53d6\u5230\u7684\u4f70\u533b\u6c47\u652f\u4ed8\u7cfb\u7edf\u7684\u4e1a\u52a1\u7cfb\u7edf\u7f16\u53f7\u662f:{}", new Object[]{appCode, consultationMerchantConfigEntity.getByhMerchantSeq(), consultationMerchantConfigEntity.getByhSysSeq()});
        CreateOrderDto createOrderDto = new CreateOrderDto();
        createOrderDto.setMchCode(consultationMerchantConfigEntity.getByhMerchantSeq());
        createOrderDto.setOutTradeNo(consultationEntity.getViewId());
        createOrderDto.setTotalAmount(consultationExtendEntity.getPrice());
        createOrderDto.setActuallyAmount(consultationExtendEntity.getPrice());
        createOrderDto.setServiceCode(consultationMerchantConfigEntity.getByhSysSeq());
        createOrderDto.setProductInfo("\u8fdc\u7a0b\u4f1a\u8bca\u8ba2\u5355");
        createOrderDto.setPayChannel(PayMethodEnum.WECHAT_PAY.getValue());
        String url = null;
        if (PayChannelEnum.WX_XCX.getValue().equalsIgnoreCase(payOrderDtoReq.getPayChannel())) {
            createOrderDto.setUserSign(payOrderDtoReq.getOpenId());
            createOrderDto.setPayType("JSAPI");
            url = new StringBuffer(this.remoteCallAddressConfig.getRemoteCallAddress()).append("payment/trade/create-order").toString();
        } else if (PayChannelEnum.QR_CODE.getValue().equalsIgnoreCase(payOrderDtoReq.getPayChannel())) {
            createOrderDto.setPayType("NATIVE");
            url = new StringBuffer(this.remoteCallAddressConfig.getRemoteCallAddress()).append("payment/trade/create-order").toString();
        } else {
            createOrderDto.setPayType("APP");
            url = new StringBuffer(this.remoteCallAddressConfig.getRemoteCallAddress()).append("payment/trade/create-order").toString();
        }
        try {
            log.info("\u9884\u652f\u4ed8\u7684\u8bf7\u6c42url\u662f:{}=========\u8bf7\u6c42\u53c2\u6570\u662f:{}", (Object)url, (Object)JSON.toJSONString((Object)createOrderDto));
            String respStr = HttpUtils.doPost((String)url, (String)JSON.toJSONString((Object)createOrderDto), (String)Consts.UTF_8.name(), (String)ContentType.APPLICATION_JSON.getMimeType());
            log.info("\u8bf7\u6c42\u9884\u652f\u4ed8\u7684\u54cd\u5e94\u7ed3\u679c\u662f:{}", (Object)respStr);
            String code = JSON.parseObject((String)respStr).getString("code");
            if (ReturnCodeEnum.SUCCEED.getValue().equals(code) && JSON.parseObject((String)respStr).getJSONObject("data") != null) {
                return BaseResponse.success((Object)JSON.parseObject((String)respStr).getJSONObject("data"));
            }
            return BaseResponse.error((String)JSON.parseObject((String)respStr).getString("msg"));
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public BaseResponse<com.alibaba.fastjson.JSONObject> createTradeAggregation(PayOrderDtoReq payOrderDtoReq, ConsultationEntity consultationEntity, ConsultationExtendEntity consultationExtendEntity) {
        String appCode = this.getAppCode(payOrderDtoReq.getOrderId());
        ServiceMerchantConfigEntity serviceMerchantConfigEntity = this.serviceMerchantConfigService.selectByAppCode(appCode.toUpperCase());
        log.info("\u6839\u636eappCode:{},\u53d6\u5230\u7684\u4f70\u533b\u6c47\u652f\u4ed8\u7cfb\u7edf\u7684\u5546\u6237\u53f7\u662f:{},\u53d6\u5230\u7684\u4f70\u533b\u6c47\u652f\u4ed8\u7cfb\u7edf\u7684\u4e1a\u52a1\u7cfb\u7edf\u7f16\u53f7\u662f:{}", (Object)appCode, (Object)serviceMerchantConfigEntity.getMerchantSeq());
        CreateOrderDto createOrderDto = new CreateOrderDto();
        createOrderDto.setMchCode(serviceMerchantConfigEntity.getMerchantSeq());
        createOrderDto.setOutTradeNo(consultationEntity.getViewId());
        createOrderDto.setTotalAmount(consultationExtendEntity.getPrice());
        createOrderDto.setActuallyAmount(consultationExtendEntity.getPrice());
        createOrderDto.setServiceCode(serviceMerchantConfigEntity.getMerchantSeq());
        createOrderDto.setProductInfo("\u8fdc\u7a0b\u4f1a\u8bca\u8ba2\u5355");
        createOrderDto.setUserSign(payOrderDtoReq.getOpenId());
        createOrderDto.setPayChannel(PayMethodEnum.WECHAT_PAY.getValue());
        String url = null;
        AggregationPayVo aggregationPayVo = new AggregationPayVo();
        AggregationPayWxVo aggregationPayWxVo = new AggregationPayWxVo();
        if (PayChannelEnum.WX_XCX.getValue().equalsIgnoreCase(payOrderDtoReq.getPayChannel())) {
            aggregationPayWxVo = this.AggregationPayWx(createOrderDto, appCode, consultationEntity);
            log.info("\u805a\u5408\u652f\u4ed8\u521b\u5efaaggregationPayWxVo\uff1a{}", (Object)aggregationPayWxVo);
            url = new StringBuffer(this.remoteCallAddressConfig.getPayHttpAddress() + "/trade/create-order").toString();
            log.info("\u805a\u5408\u652f\u4ed8\u521b\u5efa\u8bf7\u6c42\u8def\u5f84url\uff1a{}", (Object)url);
        } else if (PayChannelEnum.QR_CODE.getValue().equalsIgnoreCase(payOrderDtoReq.getPayChannel())) {
            aggregationPayVo = this.AggregationPay(createOrderDto, appCode, consultationEntity);
            log.info("\u805a\u5408\u652f\u4ed8\u521b\u5efaaggregationPayVo\uff1a{}", (Object)aggregationPayVo);
            url = new StringBuffer(this.remoteCallAddressConfig.getPayHttpAddress() + "/qr_code/prepayment").toString();
            log.info("\u805a\u5408\u652f\u4ed8\u521b\u5efa\u8bf7\u6c42\u8def\u5f84url\uff1a{}", (Object)url);
        } else {
            createOrderDto.setPayType("APP");
            url = new StringBuffer(this.remoteCallAddressConfig.getRemoteCallAddress()).append("payment/trade/create-order").toString();
        }
        try {
            String respStr = "";
            if (PayChannelEnum.QR_CODE.getValue().equalsIgnoreCase(payOrderDtoReq.getPayChannel())) {
                log.info("\u9884\u805a\u5408\u652f\u4ed8\u7684\u8bf7\u6c42url\u662f:{}=========\u8bf7\u6c42\u53c2\u6570\u662f:{}", (Object)url, (Object)JSON.toJSONString((Object)aggregationPayVo));
                respStr = HttpUtils.doPost((String)url, (String)JSON.toJSONString((Object)aggregationPayVo), (String)Consts.UTF_8.name(), (String)ContentType.APPLICATION_JSON.getMimeType());
            } else if (PayChannelEnum.WX_XCX.getValue().equalsIgnoreCase(payOrderDtoReq.getPayChannel())) {
                log.info("\u9884\u805a\u5408\u652f\u4ed8\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u7684\u8bf7\u6c42url\u662f:{}=========\u8bf7\u6c42\u53c2\u6570\u662f:{}", (Object)url, (Object)JSON.toJSONString((Object)aggregationPayWxVo));
                respStr = HttpUtils.doPost((String)url, (String)JSON.toJSONString((Object)aggregationPayWxVo), (String)Consts.UTF_8.name(), (String)ContentType.APPLICATION_JSON.getMimeType());
            } else {
                log.info("\u9884\u652f\u4ed8\u7684\u8bf7\u6c42url\u662f:{}=========\u8bf7\u6c42\u53c2\u6570\u662f:{}", (Object)url, (Object)JSON.toJSONString((Object)createOrderDto));
                respStr = HttpUtils.doPost((String)url, (String)JSON.toJSONString((Object)createOrderDto), (String)Consts.UTF_8.name(), (String)ContentType.APPLICATION_JSON.getMimeType());
            }
            log.info("\u8bf7\u6c42\u9884\u652f\u4ed8\u7684\u54cd\u5e94\u7ed3\u679c\u662f:{}", (Object)respStr);
            String code = JSON.parseObject((String)respStr).getString("code");
            if (ReturnCodeEnum.SUCCEED.getValue().equals(code) && JSON.parseObject((String)respStr).getJSONObject("data") != null) {
                return BaseResponse.success((Object)JSON.parseObject((String)respStr).getJSONObject("data"));
            }
            return BaseResponse.error((String)JSON.parseObject((String)respStr).getString("msg"));
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public BaseResponse<QrCodeResVO> getPayQRCodeInfo(ConsultationEntity consultationEntity) {
        ConsultationExtendEntity extendEntity = this.consultationExtendService.queryByConsultationId(consultationEntity.getId());
        String qrCode = this.byhPayQrCodeAggregation(consultationEntity.getId());
        QrCodeResVO qrCodeResVO = new QrCodeResVO();
        qrCodeResVO.setQrCode(qrCode);
        qrCodeResVO.setPrice(extendEntity.getPrice());
        return BaseResponse.success((Object)qrCodeResVO);
    }

    public BaseResponse<QrCodeResVO> getPayQRCodeInfoAggregation(ConsultationEntity consultationEntity) {
        ConsultationExtendEntity extendEntity = this.consultationExtendService.queryByConsultationId(consultationEntity.getId());
        String qrCode = this.byhPayQrCodeAggregation(consultationEntity.getId());
        QrCodeResVO qrCodeResVO = new QrCodeResVO();
        qrCodeResVO.setQrCode(qrCode);
        qrCodeResVO.setPrice(extendEntity.getPrice());
        return BaseResponse.success((Object)qrCodeResVO);
    }

    public BaseResponse<String> receiptPay(ReceiptVO receiptVO) {
        ConsultationEntity consultationEntity = this.consultationService.selectByViewId(receiptVO.getOrderViewId());
        if (consultationEntity == null) {
            return BaseResponse.error((String)"\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        if (ReceiptTypeEnum.WECHAT_PAY.getValue().equals(receiptVO.getReceiptType())) {
            this.consultationExtendService.updateWechatReceiptPay(consultationEntity.getId(), receiptVO.getReceiptNumber());
        } else {
            this.consultationExtendService.updateAliReceiptPay(consultationEntity.getId(), receiptVO.getReceiptNumber());
        }
        if (OrderStatusEnum.UN_PAY.getValue().equals(consultationEntity.getStatus())) {
            consultationEntity.setStatus(OrderStatusEnum.WAITING.getValue());
            consultationEntity.setPayTime(DateTimeUtil.formatTime((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
            this.consultationService.updateConsultationEntity(consultationEntity);
            try {
                if (consultationEntity.getTencentRong().toString().equals("1")) {
                    this.commonService.creatRongCloudGroup(consultationEntity.getId());
                }
                if (consultationEntity.getTencentRong().toString().equals("2")) {
                    this.commonService.tencentCreatRongCloudGroup(consultationEntity);
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return BaseResponse.success((Object)"\u6210\u529f");
    }

    public BaseResponse<com.alibaba.fastjson.JSONObject> queryOfflinePayOrder(RequestOfflineOederQueryVO reqVo) {
        String url = new StringBuffer(this.remoteCallAddressConfig.getRemoteCallAddress()).append("payment/trade/offline_order_query").toString();
        try {
            log.info("\u7ebf\u4e0b\u67e5\u8be2\u8ba2\u5355\u7684\u8bf7\u6c42url\u662f:{}=========\u8bf7\u6c42\u53c2\u6570\u662f:{}", (Object)url, (Object)JSON.toJSONString((Object)reqVo));
            String respStr = HttpUtils.doPost((String)url, (String)JSON.toJSONString((Object)reqVo), (String)Consts.UTF_8.name(), (String)ContentType.APPLICATION_JSON.getMimeType());
            log.info("\u7ebf\u4e0b\u67e5\u8be2\u8ba2\u5355\u7684\u54cd\u5e94\u7ed3\u679c\u662f:{}", (Object)respStr);
            String code = JSON.parseObject((String)respStr).getString("code");
            if (ReturnCodeEnum.SUCCEED.getValue().equals(code) && JSON.parseObject((String)respStr).getJSONObject("data") != null) {
                return BaseResponse.success((Object)JSON.parseObject((String)respStr).getJSONObject("data"));
            }
            return BaseResponse.error((String)JSON.parseObject((String)respStr).getString("msg"));
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Async
    public AggregationPayVo AggregationPay(CreateOrderDto createOrderDto, String appCode, ConsultationEntity consultationEntity) {
        ServiceMerchantConfigEntity serviceMerchantConfigEntity = this.serviceMerchantConfigService.selectByAppCode(appCode);
        log.info("serviceMerchantConfigEntity:{}", (Object)serviceMerchantConfigEntity);
        StringBuffer serviceCode = new StringBuffer();
        String organName = StringUtil.convertHanzi2Pinyin((String)consultationEntity.getDoctorHosName(), (boolean)false).toUpperCase();
        serviceCode.append(appCode).append("_").append(organName).append("_").append("YCHZ");
        AggregationPayVo aggregationPayVo = new AggregationPayVo();
        aggregationPayVo.setPayChannel(createOrderDto.getPayChannel());
        aggregationPayVo.setPayType("JSAPI");
        aggregationPayVo.setMchCode(createOrderDto.getMchCode());
        aggregationPayVo.setServiceCode(serviceCode.toString());
        aggregationPayVo.setUserSign(createOrderDto.getUserSign());
        aggregationPayVo.setOutTradeNo(createOrderDto.getOutTradeNo());
        aggregationPayVo.setTotalAmount(createOrderDto.getTotalAmount());
        aggregationPayVo.setActuallyAmount(createOrderDto.getActuallyAmount());
        aggregationPayVo.setProductInfo(createOrderDto.getProductInfo());
        aggregationPayVo.setDiscountVo(new DiscountVo());
        aggregationPayVo.setAuthCode("");
        aggregationPayVo.setNonceStr(StringUtil.getRandomString((int)32));
        aggregationPayVo.setPayNotifyUrl(this.remoteCallAddressConfig.getPayCallbackAddress() + "/cloud/consultation/api/order/pay/callback/payNotify");
        aggregationPayVo.setApplyCode(serviceMerchantConfigEntity.getMerchantSeq());
        String[] str = new String[]{};
        Map map = SignUtil.getKeyAndValue((Object)aggregationPayVo);
        String sign = SignUtil.createSign((Map)map, (String)serviceMerchantConfigEntity.getApplyKey(), (String[])str);
        aggregationPayVo.setSign(sign);
        log.info("aggregationPayVo:{}", (Object)aggregationPayVo);
        return aggregationPayVo;
    }

    @Async
    public AggregationPayWxVo AggregationPayWx(CreateOrderDto createOrderDto, String appCode, ConsultationEntity consultationEntity) {
        ServiceMerchantConfigEntity serviceMerchantConfigEntity = this.serviceMerchantConfigService.selectByAppCode(appCode);
        log.info("serviceMerchantConfigEntity:{}", (Object)serviceMerchantConfigEntity);
        StringBuffer serviceCode = new StringBuffer();
        String organName = StringUtil.convertHanzi2Pinyin((String)consultationEntity.getDoctorHosName(), (boolean)false).toUpperCase();
        serviceCode.append(appCode).append("_").append(organName).append("_").append("YCHZ");
        AggregationPayWxVo aggregationPayWxVo = new AggregationPayWxVo();
        aggregationPayWxVo.setPayChannel(createOrderDto.getPayChannel());
        aggregationPayWxVo.setPayType("JSAPI");
        aggregationPayWxVo.setMchCode(serviceMerchantConfigEntity.getMerchantSeq());
        aggregationPayWxVo.setServiceCode(serviceCode.toString());
        aggregationPayWxVo.setUserSign(createOrderDto.getUserSign());
        aggregationPayWxVo.setOutTradeNo(createOrderDto.getOutTradeNo());
        aggregationPayWxVo.setTotalAmount(createOrderDto.getTotalAmount());
        aggregationPayWxVo.setActuallyAmount(createOrderDto.getActuallyAmount());
        aggregationPayWxVo.setProductInfo(createOrderDto.getProductInfo());
        aggregationPayWxVo.setDiscountVo(new DiscountVo());
        aggregationPayWxVo.setAuthCode("");
        aggregationPayWxVo.setNonceStr(StringUtil.getRandomString((int)32));
        aggregationPayWxVo.setPayNotifyUrl(this.remoteCallAddressConfig.getPayCallbackAddress() + "/cloud/consultation/api/order/pay/callback/payNotify");
        aggregationPayWxVo.setApplyCode(serviceMerchantConfigEntity.getMerchantSeq());
        String[] str = new String[]{};
        Map map = SignUtil.getKeyAndValue((Object)aggregationPayWxVo);
        String sign = SignUtil.createSign((Map)map, (String)serviceMerchantConfigEntity.getApplyKey(), (String[])str);
        aggregationPayWxVo.setSign(sign);
        log.info("aggregationPayWxVo:{}", (Object)aggregationPayWxVo);
        return aggregationPayWxVo;
    }

    public BaseResponse<List<ServicePayBillEntity>> queryBusinessBills(BusinessBillsParamVo businessBillsParamVo) {
        List list = this.servicePayBillService.queryBusinessBills(businessBillsParamVo);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            return BaseResponse.success((Object)list);
        }
        return BaseResponse.success(new ArrayList());
    }

    public BaseResponse<Object> refund(RefundVo refundVo) {
        ConsultationEntity consultationEntity = this.consultationService.selectByViewId(refundVo.getOrderViewId());
        ConsultationExtendEntity consultationExtendEntity = this.consultationExtendService.queryByConsultationId(consultationEntity.getId());
        List servicePayBillEntityList = this.servicePayBillService.selectByOutTradeNo(refundVo.getOrderViewId());
        ServicePayBillEntity servicePayBillEntity = (ServicePayBillEntity)servicePayBillEntityList.get(0);
        ServiceMerchantConfigEntity serviceMerchantConfigEntity = this.serviceMerchantConfigService.selectByAppCode(servicePayBillEntity.getAppCode());
        RefundHttpVo refundHttpVo = new RefundHttpVo();
        refundHttpVo.setPayChannel(servicePayBillEntity.getPayChannel());
        refundHttpVo.setMchCode(servicePayBillEntity.getApplyCode());
        refundHttpVo.setOutTradeNo(servicePayBillEntity.getOutTradeNo());
        refundHttpVo.setDealTradeNo(servicePayBillEntity.getDealTradeNo());
        refundHttpVo.setTotalAmount(consultationExtendEntity.getPrice());
        refundHttpVo.setRefundAmount(consultationExtendEntity.getPrice());
        refundHttpVo.setNonceStr(StringUtil.getRandomString((int)32));
        refundHttpVo.setRefundNotifyUrl(this.remoteCallAddressConfig.getPayCallbackAddress() + "/cloud/consultation/api/order/pay/refundCallback");
        refundHttpVo.setApplyCode(servicePayBillEntity.getApplyCode());
        String[] str = new String[]{};
        Map map = SignUtil.getKeyAndValue((Object)refundHttpVo);
        String sign = SignUtil.createSign((Map)map, (String)serviceMerchantConfigEntity.getApplyKey(), (String[])str);
        refundHttpVo.setSign(sign);
        String url = this.remoteCallAddressConfig.getPayHttpAddress() + "/trade/refund";
        String respStr = "";
        log.info("\u9000\u6b3e\u8bf7\u6c42url\u662f:{} http\u8bf7\u6c42\u53c2\u6570\u662f:{}", (Object)url, (Object)JSON.toJSONString((Object)refundHttpVo));
        try {
            respStr = HttpUtils.doPost((String)url, (String)JSON.toJSONString((Object)refundHttpVo), (String)Consts.UTF_8.name(), (String)ContentType.APPLICATION_JSON.getMimeType());
        }
        catch (Exception e) {
            log.error("refund", (Throwable)e);
        }
        log.info("\u9000\u6b3e\u8bf7\u6c42http\u8bf7\u6c42\u8fd4\u56de:{}", (Object)respStr);
        String code = JSON.parseObject((String)respStr).getString("code");
        if (ReturnCodeEnum.SUCCEED.getValue().equals(code)) {
            return BaseResponse.success((Object)"\u9000\u6b3e\u6210\u529f");
        }
        return BaseResponse.error((String)"\u9000\u6b3e\u5931\u8d25");
    }

    public BaseResponse<String> refundCallback(RefundCallbackVo refundCallbackVo) {
        if (!PayStatusEnum.SUCCESS.getValue().equals(refundCallbackVo.getReturnCode())) {
            log.error("\u8ba2\u5355\u9000\u6b3e\u5931\u8d25\uff1a{}", (Object)refundCallbackVo.getOutTradeNo());
            return BaseResponse.error((String)PayStatusEnum.FAIL.getValue());
        }
        ConsultationEntity consultationEntity = this.consultationService.selectByViewId(refundCallbackVo.getOutTradeNo());
        ConsultationExtendEntity consultationExtendEntity = this.consultationExtendService.queryByConsultationId(consultationEntity.getId());
        consultationExtendEntity.setPayState(PayStateEnum.PAY_REFUND.getValue());
        this.consultationExtendService.update(consultationExtendEntity);
        this.aggregationPayManage.aggregationRefundCallback(refundCallbackVo, consultationEntity);
        return BaseResponse.success((Object)PayStatusEnum.SUCCESS.getValue());
    }
}

