/*
 * Decompiled with CFR 0.152.
 */
package com.byh.manage.consultation;

import com.alibaba.fastjson.JSONObject;
import com.byh.controller.BaseController;
import com.byh.exception.PushInfoException;
import com.byh.manage.consultation.ProgramMessageManager;
import com.byh.manage.consultation.RemoteManage;
import com.byh.pojo.entity.consultation.ConsultationEntity;
import com.byh.pojo.entity.consultation.ConsultationExtendEntity;
import com.byh.pojo.entity.consultation.ConsultationMdtEntity;
import com.byh.pojo.entity.consultation.DoctorBillInfoEntity;
import com.byh.pojo.vo.consultation.req.BaseAliSmsReqVO;
import com.byh.pojo.vo.consultation.res.SmsClientCode;
import com.byh.remotecall.UserCenterRemote;
import com.byh.service.cosultation.ConsultationExtendService;
import com.byh.service.cosultation.ConsultationService;
import com.byh.service.mdtconsultation.MdtConsultationService;
import com.byh.util.DateTimeUtil;
import com.byh.util.PushInfoManagerUtils;
import com.byh.util.StringUtil;
import com.doctoruser.api.pojo.vo.UcConfigurationVO;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class ShortMessageManager
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(ShortMessageManager.class);
    public static final String SMSAPPCODE = "";
    public static final Integer USER = 0;
    public static final Integer DOCTOR = 1;
    @Autowired
    private PushInfoManagerUtils pushInfoManagerUtils;
    @Autowired
    private ConsultationService consultationService;
    @Autowired
    private UserCenterRemote userCenterRemote;
    @Autowired
    private ConsultationExtendService consultationExtendService;
    @Autowired
    private RemoteManage remoteManage;
    @Autowired
    private ProgramMessageManager programMessageManager;
    @Autowired
    private MdtConsultationService mdtConsultationService;

    public String getSignCodeDoc(UcConfigurationVO configurationVO) {
        String signCode = SMSAPPCODE;
        if (configurationVO != null) {
            String code = configurationVO.getClientCode();
            SmsClientCode smsClientCode = (SmsClientCode)JSONObject.parseObject((String)code, SmsClientCode.class);
            signCode = smsClientCode.getSignCode().getDoctorCode();
        }
        return signCode;
    }

    public String getClientCodeDoc(UcConfigurationVO configurationVO) {
        String clientCode = SMSAPPCODE;
        if (configurationVO != null) {
            String code = configurationVO.getClientCode();
            SmsClientCode smsClientCode = (SmsClientCode)JSONObject.parseObject((String)code, SmsClientCode.class);
            clientCode = smsClientCode.getClientCode();
        }
        return clientCode;
    }

    public String getSignCodePat(UcConfigurationVO configurationVO) {
        String signCode = SMSAPPCODE;
        if (configurationVO != null) {
            String code = configurationVO.getClientCode();
            SmsClientCode smsClientCode = (SmsClientCode)JSONObject.parseObject((String)code, SmsClientCode.class);
            signCode = smsClientCode.getSignCode().getPatientCode();
        }
        return signCode;
    }

    @Async
    public void newConsultationToDoctor(String orderViewId) {
        try {
            ConsultationEntity consultationEntity = this.consultationService.selectByViewId(orderViewId);
            ConsultationExtendEntity consultationExtendEntity = this.consultationExtendService.queryByConsultationId(consultationEntity.getId());
            BaseAliSmsReqVO baseAliSmsReqVO = new BaseAliSmsReqVO();
            baseAliSmsReqVO.setTemplateCode("SMS_152213161");
            this.improveBaseAliSmsReqVO(baseAliSmsReqVO, consultationEntity.getDoctorId());
            String sex = consultationExtendEntity.getPatientSex().equals(1) ? "\u7537" : "\u5973";
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("patientname", consultationEntity.getPatientName());
            map.put("sex", sex);
            map.put("age", consultationExtendEntity.getPatientAge().toString());
            baseAliSmsReqVO.setParams(map);
            String doctorAppCode = this.remoteManage.getAppCodeByHospitalId(Integer.valueOf(consultationEntity.getDoctorHospitalId().intValue()));
            UcConfigurationVO configurationVO = this.programMessageManager.getUcConfigurationVO(doctorAppCode, "sms");
            String signCodeDoc = this.getSignCodeDoc(configurationVO);
            this.pushInfoManagerUtils.aliSmsPush(doctorAppCode, baseAliSmsReqVO, signCodeDoc);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new PushInfoException(e.getMessage());
        }
    }

    @Async
    public void videoConsultationAccept(String orderViewId) {
        try {
            ConsultationEntity consultationEntity = this.consultationService.selectByViewId(orderViewId);
            BaseAliSmsReqVO baseAliSmsReqVO = new BaseAliSmsReqVO();
            baseAliSmsReqVO.setTemplateCode("SMS_152289907");
            this.improveBaseAliSmsReqVO(baseAliSmsReqVO, consultationEntity.getDoctorId());
            String time = consultationEntity.getConsultationDate() + " " + consultationEntity.getConsultationTime();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("expertname", consultationEntity.getExpertName());
            map.put("time", time);
            baseAliSmsReqVO.setParams(map);
            String doctorAppCode = this.remoteManage.getAppCodeByHospitalId(Integer.valueOf(consultationEntity.getDoctorHospitalId().intValue()));
            UcConfigurationVO configurationVO = this.programMessageManager.getUcConfigurationVO(doctorAppCode, "sms");
            String signCodeDoc = this.getSignCodeDoc(configurationVO);
            this.pushInfoManagerUtils.aliSmsPush(doctorAppCode, baseAliSmsReqVO, signCodeDoc);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new PushInfoException(e.getMessage());
        }
    }

    @Async
    public void photoConsultationAccept(String orderViewId) {
        try {
            ConsultationEntity consultationEntity = this.consultationService.selectByViewId(orderViewId);
            BaseAliSmsReqVO baseAliSmsReqVO = new BaseAliSmsReqVO();
            baseAliSmsReqVO.setTemplateCode("SMS_152505054");
            this.improveBaseAliSmsReqVO(baseAliSmsReqVO, consultationEntity.getDoctorId());
            String time = consultationEntity.getConsultationDate() + " " + consultationEntity.getConsultationTime();
            Date date = DateTimeUtil.parseTime((String)time, (String)"yyyy-MM-dd HH:mm:ss");
            String dateTimeStr = DateTimeUtil.formatTime((Date)DateTimeUtil.addDay((Date)date, (int)1), (String)"yyyy-MM-dd HH:mm:ss");
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("expertname", consultationEntity.getExpertName());
            map.put("time", dateTimeStr);
            baseAliSmsReqVO.setParams(map);
            String doctorAppCode = this.remoteManage.getAppCodeByHospitalId(Integer.valueOf(consultationEntity.getDoctorHospitalId().intValue()));
            UcConfigurationVO configurationVO = this.programMessageManager.getUcConfigurationVO(doctorAppCode, "sms");
            String signCodeDoc = this.getSignCodeDoc(configurationVO);
            this.pushInfoManagerUtils.aliSmsPush(doctorAppCode, baseAliSmsReqVO, signCodeDoc);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new PushInfoException(e.getMessage());
        }
    }

    @Async
    public void consultationExpertChanged(String orderViewId) {
        try {
            ConsultationEntity consultationEntity = this.consultationService.selectByViewId(orderViewId);
            BaseAliSmsReqVO baseAliSmsReqVO = new BaseAliSmsReqVO();
            baseAliSmsReqVO.setTemplateCode("SMS_152213163");
            this.improveBaseAliSmsReqVO(baseAliSmsReqVO, consultationEntity.getDoctorId());
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("doctorname", consultationEntity.getDoctorName());
            map.put("expertname", consultationEntity.getExpertName());
            baseAliSmsReqVO.setParams(map);
            String doctorAppCode = this.remoteManage.getAppCodeByHospitalId(Integer.valueOf(consultationEntity.getDoctorHospitalId().intValue()));
            UcConfigurationVO configurationVO = this.programMessageManager.getUcConfigurationVO(doctorAppCode, "sms");
            String signCodeDoc = this.getSignCodeDoc(configurationVO);
            this.pushInfoManagerUtils.aliSmsPush(doctorAppCode, baseAliSmsReqVO, signCodeDoc);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new PushInfoException(e.getMessage());
        }
    }

    @Async
    public void consultationStartToDoctor(ConsultationEntity consultationEntity, String expertName) {
        try {
            BaseAliSmsReqVO baseAliSmsReqVO = new BaseAliSmsReqVO();
            baseAliSmsReqVO.setTemplateCode("SMS_152505059");
            this.improveBaseAliSmsReqVO(baseAliSmsReqVO, consultationEntity.getDoctorId());
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("patientname", consultationEntity.getPatientName());
            map.put("expertname", expertName);
            baseAliSmsReqVO.setParams(map);
            String doctorAppCode = this.remoteManage.getAppCodeByHospitalId(Integer.valueOf(consultationEntity.getDoctorHospitalId().intValue()));
            UcConfigurationVO configurationVO = this.programMessageManager.getUcConfigurationVO(doctorAppCode, "sms");
            String signCodeDoc = this.getSignCodeDoc(configurationVO);
            this.pushInfoManagerUtils.aliSmsPush(doctorAppCode, baseAliSmsReqVO, signCodeDoc);
        }
        catch (Exception e) {
            log.error("\u4f1a\u8bca\u5f00\u59cb\u4e00\u5c0f\u65f6\u63d0\u9192\u901a\u77e5(\u533b\u751f)\u5931\u8d25", (Throwable)e);
        }
    }

    @Async
    public void consultationStartedToDoctor(ConsultationEntity consultationEntity) {
        try {
            BaseAliSmsReqVO baseAliSmsReqVO = new BaseAliSmsReqVO();
            baseAliSmsReqVO.setTemplateCode("SMS_152208306");
            this.improveBaseAliSmsReqVO(baseAliSmsReqVO, consultationEntity.getDoctorId());
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("patientname", consultationEntity.getPatientName());
            map.put("expertname", consultationEntity.getExpertName());
            baseAliSmsReqVO.setParams(map);
            String doctorAppCode = this.remoteManage.getAppCodeByHospitalId(Integer.valueOf(consultationEntity.getDoctorHospitalId().intValue()));
            UcConfigurationVO configurationVO = this.programMessageManager.getUcConfigurationVO(doctorAppCode, "sms");
            String signCodeDoc = this.getSignCodeDoc(configurationVO);
            this.pushInfoManagerUtils.aliSmsPush(doctorAppCode, baseAliSmsReqVO, signCodeDoc);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    @Async
    public void videoConsultationFromAdminToDoctor(ConsultationEntity consultationEntity) {
        try {
            BaseAliSmsReqVO baseAliSmsReqVO = new BaseAliSmsReqVO();
            baseAliSmsReqVO.setSmsAppCode(SMSAPPCODE);
            baseAliSmsReqVO.setTemplateCode("SMS_152505063");
            this.improveBaseAliSmsReqVO(baseAliSmsReqVO, consultationEntity.getDoctorId());
            HashMap map = new HashMap();
            baseAliSmsReqVO.setParams(map);
            String doctorAppCode = this.remoteManage.getAppCodeByHospitalId(Integer.valueOf(consultationEntity.getDoctorHospitalId().intValue()));
            UcConfigurationVO configurationVO = this.programMessageManager.getUcConfigurationVO(doctorAppCode, "sms");
            String signCodeDoc = this.getSignCodeDoc(configurationVO);
            this.pushInfoManagerUtils.aliSmsPush(doctorAppCode, baseAliSmsReqVO, signCodeDoc);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new PushInfoException(e.getMessage());
        }
    }

    @Async
    public void photoConsultationFromAdminToDoctor(String orderViewId) {
        try {
            ConsultationEntity consultationEntity = this.consultationService.selectByViewId(orderViewId);
            BaseAliSmsReqVO baseAliSmsReqVO = new BaseAliSmsReqVO();
            baseAliSmsReqVO.setTemplateCode("SMS_152505067");
            this.improveBaseAliSmsReqVO(baseAliSmsReqVO, consultationEntity.getDoctorId());
            HashMap map = new HashMap();
            baseAliSmsReqVO.setParams(map);
            String doctorAppCode = this.remoteManage.getAppCodeByHospitalId(Integer.valueOf(consultationEntity.getDoctorHospitalId().intValue()));
            UcConfigurationVO configurationVO = this.programMessageManager.getUcConfigurationVO(doctorAppCode, "sms");
            String signCodeDoc = this.getSignCodeDoc(configurationVO);
            this.pushInfoManagerUtils.aliSmsPush(doctorAppCode, baseAliSmsReqVO, signCodeDoc);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new PushInfoException(e.getMessage());
        }
    }

    @Async
    public void reportHaveSubmitToDoctor(String orderViewId) {
        try {
            ConsultationEntity consultationEntity = this.consultationService.selectByViewId(orderViewId);
            BaseAliSmsReqVO baseAliSmsReqVO = new BaseAliSmsReqVO();
            baseAliSmsReqVO.setTemplateCode("SMS_152289922");
            this.improveBaseAliSmsReqVO(baseAliSmsReqVO, consultationEntity.getDoctorId());
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("expertname", consultationEntity.getExpertName());
            baseAliSmsReqVO.setParams(map);
            String doctorAppCode = this.remoteManage.getAppCodeByHospitalId(Integer.valueOf(consultationEntity.getDoctorHospitalId().intValue()));
            UcConfigurationVO configurationVO = this.programMessageManager.getUcConfigurationVO(doctorAppCode, "sms");
            String signCodeDoc = this.getSignCodeDoc(configurationVO);
            this.pushInfoManagerUtils.aliSmsPush(doctorAppCode, baseAliSmsReqVO, signCodeDoc);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new PushInfoException(e.getMessage());
        }
    }

    @Async
    public void videoConsultationApplyToExpert(String orderViewId) {
        try {
            ConsultationEntity consultationEntity = this.consultationService.selectByViewId(orderViewId);
            BaseAliSmsReqVO baseAliSmsReqVO = new BaseAliSmsReqVO();
            baseAliSmsReqVO.setTemplateCode("SMS_152505111");
            this.improveBaseAliSmsReqVO(baseAliSmsReqVO, consultationEntity.getExpertId());
            HashMap map = new HashMap();
            baseAliSmsReqVO.setParams(map);
            String expertAppCode = this.remoteManage.getAppCodeByHospitalId(Integer.valueOf(consultationEntity.getExpertHospitalId().intValue()));
            UcConfigurationVO configurationVO = this.programMessageManager.getUcConfigurationVO(expertAppCode, "sms");
            String signCodeExp = this.getSignCodeDoc(configurationVO);
            this.pushInfoManagerUtils.aliSmsPush(expertAppCode, baseAliSmsReqVO, signCodeExp);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new PushInfoException(e.getMessage());
        }
    }

    @Async
    public void photoConsultationApplyToExpert(String orderViewId) {
        try {
            ConsultationEntity consultationEntity = this.consultationService.selectByViewId(orderViewId);
            BaseAliSmsReqVO baseAliSmsReqVO = new BaseAliSmsReqVO();
            baseAliSmsReqVO.setTemplateCode("SMS_152289964");
            this.improveBaseAliSmsReqVO(baseAliSmsReqVO, consultationEntity.getExpertId());
            HashMap map = new HashMap();
            baseAliSmsReqVO.setParams(map);
            String expertAppCode = this.remoteManage.getAppCodeByHospitalId(Integer.valueOf(consultationEntity.getExpertHospitalId().intValue()));
            UcConfigurationVO configurationVO = this.programMessageManager.getUcConfigurationVO(expertAppCode, "sms");
            String signCodeExp = this.getSignCodeDoc(configurationVO);
            this.pushInfoManagerUtils.aliSmsPush(expertAppCode, baseAliSmsReqVO, signCodeExp);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new PushInfoException(e.getMessage());
        }
    }

    @Async
    public void consultationStartToExpert(ConsultationEntity consultationEntity, List<ConsultationMdtEntity> mdtList) {
        try {
            for (ConsultationMdtEntity entity : mdtList) {
                BaseAliSmsReqVO baseAliSmsReqVO = new BaseAliSmsReqVO();
                baseAliSmsReqVO.setTemplateCode("SMS_152505116");
                this.improveBaseAliSmsReqVO(baseAliSmsReqVO, entity.getExpertId());
                HashMap<String, String> map = new HashMap<String, String>(16);
                map.put("patientname", consultationEntity.getPatientName());
                map.put("doctorname", consultationEntity.getDoctorName());
                baseAliSmsReqVO.setParams(map);
                String expertAppCode = this.remoteManage.getAppCodeByHospitalId(Integer.valueOf(entity.getExpertHospitalId().intValue()));
                UcConfigurationVO configurationVO = this.programMessageManager.getUcConfigurationVO(expertAppCode, "sms");
                String signCodeExp = this.getSignCodeDoc(configurationVO);
                this.pushInfoManagerUtils.aliSmsPush(expertAppCode, baseAliSmsReqVO, signCodeExp);
            }
        }
        catch (Exception e) {
            log.error("\u89c6\u9891\u4f1a\u8bca\u5f00\u59cb\u524d\u4e00\u5c0f\u65f6\u63d0\u9192\u901a\u77e5(\u4e13\u5bb6)\u5931\u8d25", (Throwable)e);
        }
    }

    @Async
    public void consultationStartedToExpert(String orderViewId) {
        try {
            ConsultationEntity consultationEntity = this.consultationService.selectByViewId(orderViewId);
            BaseAliSmsReqVO baseAliSmsReqVO = new BaseAliSmsReqVO();
            baseAliSmsReqVO.setTemplateCode("SMS_152289971");
            this.improveBaseAliSmsReqVO(baseAliSmsReqVO, consultationEntity.getExpertId());
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("patientname", consultationEntity.getPatientName());
            map.put("doctorname", consultationEntity.getDoctorName());
            baseAliSmsReqVO.setParams(map);
            String expertAppCode = this.remoteManage.getAppCodeByHospitalId(Integer.valueOf(consultationEntity.getExpertHospitalId().intValue()));
            UcConfigurationVO configurationVO = this.programMessageManager.getUcConfigurationVO(expertAppCode, "sms");
            String signCodeExp = this.getSignCodeDoc(configurationVO);
            this.pushInfoManagerUtils.aliSmsPush(expertAppCode, baseAliSmsReqVO, signCodeExp);
        }
        catch (Exception e) {
            log.info(e.getMessage(), (Throwable)e);
            throw new PushInfoException(e.getMessage());
        }
    }

    @Async
    public void videoConsultationFromAdminToReport(ConsultationEntity consultationEntity) {
        try {
            BaseAliSmsReqVO baseAliSmsReqVO = new BaseAliSmsReqVO();
            baseAliSmsReqVO.setTemplateCode("SMS_152505120");
            this.improveBaseAliSmsReqVO(baseAliSmsReqVO, consultationEntity.getExpertId());
            HashMap map = new HashMap();
            baseAliSmsReqVO.setParams(map);
            String expertAppCode = this.remoteManage.getAppCodeByHospitalId(Integer.valueOf(consultationEntity.getExpertHospitalId().intValue()));
            UcConfigurationVO configurationVO = this.programMessageManager.getUcConfigurationVO(expertAppCode, "sms");
            String signCodeExp = this.getSignCodeDoc(configurationVO);
            this.pushInfoManagerUtils.aliSmsPush(expertAppCode, baseAliSmsReqVO, signCodeExp);
        }
        catch (Exception e) {
            throw new PushInfoException(e.getMessage());
        }
    }

    @Async
    public void photoConsultationFromAdminToReport(ConsultationEntity consultationEntity) {
        try {
            String userId = this.userCenterRemote.getUserIdByDoctorId(consultationEntity.getExpertId()).getUserId();
            BaseAliSmsReqVO baseAliSmsReqVO = new BaseAliSmsReqVO();
            baseAliSmsReqVO.setSmsAppCode(SMSAPPCODE);
            baseAliSmsReqVO.setTemplateCode("SMS_152505121");
            baseAliSmsReqVO.setUserType(DOCTOR);
            baseAliSmsReqVO.setAppSdkType("ali");
            HashMap map = new HashMap();
            baseAliSmsReqVO.setParams(map);
            String doctorAppCode = this.remoteManage.getAppCodeByHospitalId(Integer.valueOf(consultationEntity.getDoctorHospitalId().intValue()));
            UcConfigurationVO configurationVO = this.programMessageManager.getUcConfigurationVO(doctorAppCode, "sms");
            String signCodeExp = this.getSignCodeDoc(configurationVO);
            this.pushInfoManagerUtils.aliSmsPush(doctorAppCode, baseAliSmsReqVO, signCodeExp);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new PushInfoException(e.getMessage());
        }
    }

    @Async
    public void expertConsultationReportRefused(String orderViewId, String reason) {
        try {
            ConsultationEntity consultationEntity = this.consultationService.selectByViewId(orderViewId);
            BaseAliSmsReqVO baseAliSmsReqVO = new BaseAliSmsReqVO();
            baseAliSmsReqVO.setTemplateCode("SMS_155370905");
            this.improveBaseAliSmsReqVO(baseAliSmsReqVO, consultationEntity.getExpertId());
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("reason", reason);
            baseAliSmsReqVO.setParams(map);
            String expertAppCode = this.remoteManage.getAppCodeByHospitalId(Integer.valueOf(consultationEntity.getExpertHospitalId().intValue()));
            UcConfigurationVO configurationVO = this.programMessageManager.getUcConfigurationVO(expertAppCode, "sms");
            String signCodeExp = this.getSignCodeDoc(configurationVO);
            this.pushInfoManagerUtils.aliSmsPush(expertAppCode, baseAliSmsReqVO, signCodeExp);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new PushInfoException(e.getMessage());
        }
    }

    @Async
    public void expertConsultationReportNews(String orderViewId) {
        try {
            ConsultationEntity consultationEntity = this.consultationService.selectByViewId(orderViewId);
            BaseAliSmsReqVO baseAliSmsReqVO = new BaseAliSmsReqVO();
            baseAliSmsReqVO.setSmsAppCode(SMSAPPCODE);
            baseAliSmsReqVO.setTemplateCode("SMS_164155640");
            this.improveBaseAliSmsReqVO(baseAliSmsReqVO, consultationEntity.getExpertId());
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("patientName", consultationEntity.getPatientName());
            map.put("doctorName", consultationEntity.getDoctorName());
            baseAliSmsReqVO.setParams(map);
            String expertAppCode = this.remoteManage.getAppCodeByHospitalId(Integer.valueOf(consultationEntity.getExpertHospitalId().intValue()));
            UcConfigurationVO configurationVO = this.programMessageManager.getUcConfigurationVO(expertAppCode, "sms");
            String signCodeExp = this.getSignCodeDoc(configurationVO);
            this.pushInfoManagerUtils.aliSmsPush(expertAppCode, baseAliSmsReqVO, signCodeExp);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new PushInfoException(e.getMessage());
        }
    }

    @Async
    public void expertSecondVideoConsultationNews(String orderViewId) {
        try {
            List consultationMdtEntityList = this.mdtConsultationService.getConsultationMdtListByOrderViewId(orderViewId);
            for (ConsultationMdtEntity consultationMdtEntity : consultationMdtEntityList) {
                BaseAliSmsReqVO baseAliSmsReqVO = new BaseAliSmsReqVO();
                baseAliSmsReqVO.setSmsAppCode(SMSAPPCODE);
                baseAliSmsReqVO.setTemplateCode("yyht_sphz");
                this.improveBaseAliSmsReqVO(baseAliSmsReqVO, consultationMdtEntity.getExpertId());
                String expertAppCode = this.remoteManage.getAppCodeByHospitalId(Integer.valueOf(consultationMdtEntity.getExpertHospitalId().intValue()));
                UcConfigurationVO configurationVO = this.programMessageManager.getUcConfigurationVO(expertAppCode, "sms");
                String signCodeExp = this.getSignCodeDoc(configurationVO);
                String clientCode = this.getClientCodeDoc(configurationVO);
                baseAliSmsReqVO.setSmsAppCode(clientCode);
                this.pushInfoManagerUtils.aliSmsPush(expertAppCode, baseAliSmsReqVO, signCodeExp);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new PushInfoException(e.getMessage());
        }
    }

    @Async
    public void expertSecondMsgConsultationNews(String orderViewId) {
        try {
            List consultationMdtEntityList = this.mdtConsultationService.getConsultationMdtListByOrderViewId(orderViewId);
            for (ConsultationMdtEntity consultationMdtEntity : consultationMdtEntityList) {
                BaseAliSmsReqVO baseAliSmsReqVO = new BaseAliSmsReqVO();
                baseAliSmsReqVO.setSmsAppCode(SMSAPPCODE);
                baseAliSmsReqVO.setTemplateCode("yyht_twhz");
                this.improveBaseAliSmsReqVO(baseAliSmsReqVO, consultationMdtEntity.getExpertId());
                String expertAppCode = this.remoteManage.getAppCodeByHospitalId(Integer.valueOf(consultationMdtEntity.getExpertHospitalId().intValue()));
                UcConfigurationVO configurationVO = this.programMessageManager.getUcConfigurationVO(expertAppCode, "sms");
                String signCodeExp = this.getSignCodeDoc(configurationVO);
                String clientCode = this.getClientCodeDoc(configurationVO);
                baseAliSmsReqVO.setSmsAppCode(clientCode);
                this.pushInfoManagerUtils.aliSmsPush(expertAppCode, baseAliSmsReqVO, signCodeExp);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new PushInfoException(e.getMessage());
        }
    }

    @Async
    public void applySubmittedToUser(String orderViewId) {
        try {
            ConsultationEntity consultationEntity = this.consultationService.selectByViewId(orderViewId);
            BaseAliSmsReqVO baseAliSmsReqVO = new BaseAliSmsReqVO();
            baseAliSmsReqVO.setSmsAppCode(SMSAPPCODE);
            baseAliSmsReqVO.setTemplateCode("SMS_153995160");
            baseAliSmsReqVO.setUserType(USER);
            this.improveBaseAliSmsReqVO(baseAliSmsReqVO, consultationEntity.getDoctorId());
            baseAliSmsReqVO.setAppSdkType("ali");
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("doctorName", consultationEntity.getDoctorName());
            baseAliSmsReqVO.setParams(map);
            String doctorAppCode = this.remoteManage.getAppCodeByHospitalId(Integer.valueOf(consultationEntity.getDoctorHospitalId().intValue()));
            UcConfigurationVO configurationVO = this.programMessageManager.getUcConfigurationVO(doctorAppCode, "sms");
            String signCode = this.getSignCodePat(configurationVO);
            this.pushInfoManagerUtils.aliSmsPush(doctorAppCode, baseAliSmsReqVO, signCode);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new PushInfoException(e.getMessage());
        }
    }

    @Async
    public void doctorHaveSubmitApply(ConsultationEntity consultationEntity) {
        try {
            BaseAliSmsReqVO baseAliSmsReqVO = new BaseAliSmsReqVO();
            baseAliSmsReqVO.setSmsAppCode(SMSAPPCODE);
            baseAliSmsReqVO.setTemplateCode("SMS_156465082");
            baseAliSmsReqVO.setUserType(USER);
            baseAliSmsReqVO.setAppSdkType("ali");
            this.improveBaseAliSmsReqVO(baseAliSmsReqVO, consultationEntity.getDoctorId());
            HashMap<String, String> map = new HashMap<String, String>();
            if (StringUtil.isEmpty((String)consultationEntity.getExpertName())) {
                List consultationMdtEntityList = this.mdtConsultationService.getConsultationMdtListByOrderViewId(consultationEntity.getViewId());
                if (CollectionUtils.isNotEmpty((Collection)consultationMdtEntityList)) {
                    String expertName = consultationMdtEntityList.stream().map(ConsultationMdtEntity::getExpertName).collect(Collectors.joining(","));
                    map.put("expertName", expertName);
                } else {
                    map.put("expertName", consultationEntity.getExpertName());
                }
            } else {
                map.put("expertName", consultationEntity.getExpertName());
            }
            map.put("doctorName", consultationEntity.getDoctorName());
            map.put("hospitalName", consultationEntity.getDoctorHosName());
            baseAliSmsReqVO.setParams(map);
            String doctorAppCode = this.remoteManage.getAppCodeByHospitalId(Integer.valueOf(consultationEntity.getDoctorHospitalId().intValue()));
            UcConfigurationVO configurationVO = this.programMessageManager.getUcConfigurationVO(doctorAppCode, "sms");
            String signCode = this.getSignCodeDoc(configurationVO);
            this.pushInfoManagerUtils.aliSmsPush(doctorAppCode, baseAliSmsReqVO, signCode);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new PushInfoException(e.getMessage());
        }
    }

    @Async
    public void expertHaveAcceptApply(String orderViewId) {
        try {
            ConsultationEntity consultationEntity = this.consultationService.selectByViewId(orderViewId);
            BaseAliSmsReqVO baseAliSmsReqVO = new BaseAliSmsReqVO();
            baseAliSmsReqVO.setSmsAppCode(SMSAPPCODE);
            baseAliSmsReqVO.setTemplateCode("SMS_153990171");
            baseAliSmsReqVO.setUserType(USER);
            baseAliSmsReqVO.setAppSdkType("ali");
            this.improveBaseAliSmsReqVO(baseAliSmsReqVO, consultationEntity.getDoctorId());
            String time = consultationEntity.getConsultationDate() + " " + consultationEntity.getConsultationTime();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("expertName", consultationEntity.getExpertName());
            map.put("date", time);
            baseAliSmsReqVO.setParams(map);
            String doctorAppCode = this.remoteManage.getAppCodeByHospitalId(Integer.valueOf(consultationEntity.getDoctorHospitalId().intValue()));
            UcConfigurationVO configurationVO = this.programMessageManager.getUcConfigurationVO(doctorAppCode, "sms");
            String signCode = this.getSignCodeDoc(configurationVO);
            this.pushInfoManagerUtils.aliSmsPush(doctorAppCode, baseAliSmsReqVO, signCode);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new PushInfoException(e.getMessage());
        }
    }

    @Async
    public void remindUserWatchReport(String orderViewId) {
        try {
            ConsultationEntity consultationEntity = this.consultationService.selectByViewId(orderViewId);
            BaseAliSmsReqVO baseAliSmsReqVO = new BaseAliSmsReqVO();
            baseAliSmsReqVO.setSmsAppCode(SMSAPPCODE);
            baseAliSmsReqVO.setTemplateCode("SMS_153995162");
            baseAliSmsReqVO.setUserType(USER);
            baseAliSmsReqVO.setAppSdkType("ali");
            this.improveBaseAliSmsReqVO(baseAliSmsReqVO, consultationEntity.getDoctorId());
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("expertname", consultationEntity.getExpertName());
            baseAliSmsReqVO.setParams(map);
            String doctorAppCode = this.remoteManage.getAppCodeByHospitalId(Integer.valueOf(consultationEntity.getDoctorHospitalId().intValue()));
            UcConfigurationVO configurationVO = this.programMessageManager.getUcConfigurationVO(doctorAppCode, "sms");
            String signCode = this.getSignCodeDoc(configurationVO);
            this.pushInfoManagerUtils.aliSmsPush(doctorAppCode, baseAliSmsReqVO, signCode);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new PushInfoException(e.getMessage());
        }
    }

    @Async
    public void remindUserSignName(ConsultationEntity consultationEntity, String patientPhone) {
        try {
            BaseAliSmsReqVO baseAliSmsReqVO = new BaseAliSmsReqVO();
            baseAliSmsReqVO.setSmsAppCode(SMSAPPCODE);
            baseAliSmsReqVO.setTemplateCode("SMS_153990172");
            baseAliSmsReqVO.setUserType(USER);
            baseAliSmsReqVO.setAppSdkType("ali");
            baseAliSmsReqVO.setPhone(patientPhone);
            HashMap map = new HashMap();
            baseAliSmsReqVO.setParams(map);
            String doctorAppCode = this.remoteManage.getAppCodeByHospitalId(Integer.valueOf(consultationEntity.getDoctorHospitalId().intValue()));
            UcConfigurationVO configurationVO = this.programMessageManager.getUcConfigurationVO(doctorAppCode, "sms");
            String signCode = this.getSignCodeDoc(configurationVO);
            this.pushInfoManagerUtils.aliSmsPush(doctorAppCode, baseAliSmsReqVO, signCode);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new PushInfoException(e.getMessage());
        }
    }

    @Async
    public void cancelConsultationApply(String orderViewId, String reason) {
        try {
            ConsultationEntity consultationEntity = this.consultationService.selectByViewId(orderViewId);
            ConsultationExtendEntity extendEntity = this.consultationExtendService.queryByConsultationId(consultationEntity.getId());
            BaseAliSmsReqVO baseAliSmsReqVO = new BaseAliSmsReqVO();
            baseAliSmsReqVO.setSmsAppCode(SMSAPPCODE);
            baseAliSmsReqVO.setTemplateCode("SMS_155275066");
            baseAliSmsReqVO.setUserType(USER);
            baseAliSmsReqVO.setAppSdkType("ali");
            baseAliSmsReqVO.setPhone(extendEntity.getPatientPhone());
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("reason", reason);
            baseAliSmsReqVO.setParams(map);
            String doctorAppCode = this.remoteManage.getAppCodeByHospitalId(Integer.valueOf(consultationEntity.getDoctorHospitalId().intValue()));
            UcConfigurationVO configurationVO = this.programMessageManager.getUcConfigurationVO(doctorAppCode, "sms");
            String signCode = this.getSignCodeDoc(configurationVO);
            this.pushInfoManagerUtils.aliSmsPush(doctorAppCode, baseAliSmsReqVO, signCode);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new PushInfoException(e.getMessage());
        }
    }

    @Async
    public void cancelConsultationToDoctor(String orderViewId) {
        try {
            ConsultationEntity consultationEntity = this.consultationService.selectByViewId(orderViewId);
            BaseAliSmsReqVO baseAliSmsReqVO = new BaseAliSmsReqVO();
            baseAliSmsReqVO.setTemplateCode("SMS_145595379");
            this.improveBaseAliSmsReqVO(baseAliSmsReqVO, consultationEntity.getDoctorId());
            String doctorAppCode = this.remoteManage.getAppCodeByHospitalId(Integer.valueOf(consultationEntity.getDoctorHospitalId().intValue()));
            UcConfigurationVO configurationVO = this.programMessageManager.getUcConfigurationVO(doctorAppCode, "sms");
            String signCode = this.getSignCodeDoc(configurationVO);
            this.pushInfoManagerUtils.aliSmsPush(doctorAppCode, baseAliSmsReqVO, signCode);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new PushInfoException(e.getMessage());
        }
    }

    @Async
    public void verifyDoctorBillInfo(DoctorBillInfoEntity billInfoEntity, String phone, Integer doctorHospitalId) {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("money", billInfoEntity.getActualMoney().toString());
            BaseAliSmsReqVO aliSmsSendPatientInfoReqVO = new BaseAliSmsReqVO();
            aliSmsSendPatientInfoReqVO.setAppSdkType("ali");
            aliSmsSendPatientInfoReqVO.setSmsAppCode("EHOS_BYH");
            aliSmsSendPatientInfoReqVO.setTemplateCode("SMS_152208307");
            aliSmsSendPatientInfoReqVO.setUserType(DOCTOR);
            aliSmsSendPatientInfoReqVO.setPhone(phone);
            if (params != null) {
                aliSmsSendPatientInfoReqVO.setParams(params);
            }
            String doctorAppCode = this.remoteManage.getAppCodeByHospitalId(doctorHospitalId);
            UcConfigurationVO configurationVO = this.programMessageManager.getUcConfigurationVO(doctorAppCode, "sms");
            String signCode = this.getSignCodeDoc(configurationVO);
            this.pushInfoManagerUtils.aliSmsPush(doctorAppCode, aliSmsSendPatientInfoReqVO, signCode);
            log.info("================\u5165\u8d26\u77ed\u4fe1\u63a8\u9001\u5b8c\u6210=============");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new PushInfoException(e.getMessage());
        }
    }

    private void improveBaseAliSmsReqVO(BaseAliSmsReqVO baseAliSmsReqVO, Long doctorId) {
        String phone = this.remoteManage.getDoctorDetailById(doctorId).getRegisterMobile();
        baseAliSmsReqVO.setSmsAppCode(SMSAPPCODE);
        baseAliSmsReqVO.setPhone(phone);
        baseAliSmsReqVO.setUserType(DOCTOR);
        baseAliSmsReqVO.setAppSdkType("ali");
    }
}

